/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Global;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormExportProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNPeriodNameHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormExportBaseUtils {
    private static final Logger logger = CoreUIObject.getLogger(BgFormExportBaseUtils.class);
    public static String isMoveDimension = "isMoveDimension";
    public static String exportPermission = "exportPermission";
    public static String pageViewNumbers = "pageViewNumbers";

    public static Map getMbgFromExportParams(BgFormInfo _bgFormInfo, MBGFormExportProvider mbgFormExportProvider) throws Exception {
        return BgFormExportBaseUtils.getMbgFromExportParams(_bgFormInfo, mbgFormExportProvider, mbgFormExportProvider.getBookMap().get(_bgFormInfo.getId().toString()));
    }

    public static Map getMbgFromExportParams(BgFormInfo _bgFormInfo, MBGFormProvider mbgFormExportProvider, Book book) throws Exception {
        HashMap<String, Serializable> _parameter = new HashMap<String, Serializable>();
        BigDecimal _coefficient = ((IMbgViewManager)mbgFormExportProvider.getCurMbgViewManager()).getDefaultMeasureUnit().getCoefficient();
        HashMap<String, BigDecimal> newMeasureUnitMap = new HashMap<String, BigDecimal>();
        if (_bgFormInfo.getBgMeasureUnit() != null) {
            BgMeasureUnitInfo _muInfo = null;
            Iterator mes = _bgFormInfo.getBgMeasureUnit().iterator();
            while (mes.hasNext()) {
                _muInfo = (BgMeasureUnitInfo)mes.next();
                newMeasureUnitMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        if (book != null) {
            book.getProtection().deleteOperations();
            ArrayList<String> sheetName = new ArrayList<String>();
            int sheetSize = book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                sheetName.add(book.getSheet(sheetIndex).getSheetName());
            }
            _parameter.put("EXPORT_SHEETNAME", sheetName);
            _parameter.put("EXPORT_BOOK", (Serializable)book);
            BgFormExportBaseUtils.setSheetHide(null, _bgFormInfo, book);
        }
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        _parameter.put("EXPORT_ROW_MEMBER_UNMERGE", Boolean.FALSE);
        _parameter.put("EXPORT_MEASUREUNIT", newMeasureUnitMap);
        _parameter.put("EXPORT_BGFORMULA", null);
        _parameter.put("EXPORT_DATA", Boolean.TRUE);
        return _parameter;
    }

    public static KDSBook exportMbgExcelFile(BgFormInfo _bgFormInfo, MBGFormExportProvider mbgFormExportProvider) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getMbgFromExportParams(_bgFormInfo, mbgFormExportProvider);
        return BgNFSHelper.exportExcel(mbgFormExportProvider.getCtx(), tmpMap);
    }

    public static Book exportMbgExcelFile2007(BgFormInfo _bgFormInfo, MBGFormExportProvider mbgFormExportProvider) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getMbgFromExportParams(_bgFormInfo, mbgFormExportProvider);
        Book _book = BgNFSHelper.exportExcel2007(mbgFormExportProvider.getCtx(), tmpMap);
        BgNFSHelper.stopBookProtection(_book);
        List sheetName = (List)tmpMap.get("EXPORT_SHEETNAME");
        if (!sheetName.isEmpty()) {
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
                _book.getSheet(sheetIndex).setName((String)sheetName.get(sheetSize - sheetIndex - 1));
            }
        }
        return _book;
    }

    public static KDSBook exportFixExcelFile(Context ctx, BgFormInfo _bgFormInfo) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getFixExcelExportParams(ctx, _bgFormInfo, null);
        return BgNFSHelper.exportExcel(ctx, tmpMap);
    }

    public static Book exportFixExcelFile2007(Context ctx, BgFormInfo _bgFormInfo, Book book) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getFixExcelExportParams(ctx, _bgFormInfo, book);
        Book _book = BgNFSHelper.exportExcel2007(ctx, tmpMap);
        BgFormExportBaseUtils.convertPeriod(_bgFormInfo, _book);
        BgNFSHelper.stopBookProtection(_book);
        List sheetName = (List)tmpMap.get("EXPORT_SHEETNAME");
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
            _book.getSheet(sheetIndex).setName((String)sheetName.get(sheetSize - sheetIndex - 1));
        }
        return _book;
    }

    public static void convertPeriod(BgFormInfo info, Book book) throws Exception {
        if (book == null || info == null || info.getBgPeriod() == null || info.getBgPeriod().getNumber() == null || info.getBgPeriod().getPeriodType() == null) {
            return;
        }
        BgNPeriodNameHelper bgNPeriodNameHelper = new BgNPeriodNameHelper();
        bgNPeriodNameHelper.setBgFormPeriodNumber(info.getBgPeriod().getNumber());
        bgNPeriodNameHelper.setBgFormPeriodType(info.getBgPeriod().getPeriodType().getValue());
        Sheet sheet = null;
        Cell cell = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            rowCount = sheet.getMaxRowIndex();
            colCount = sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null) continue;
                    bgNPeriodNameHelper.addCell(cell);
                }
            }
        }
        bgNPeriodNameHelper.end();
    }

    private static Map getFixExcelExportParams(Context ctx, BgFormInfo _bgFormInfo, Book book) throws Exception {
        Book _book = null;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        BigDecimal _coefficient = null;
        BigDecimal bigDecimal = _coefficient = _bgFormInfo.getMeasureUnit() != null ? _bgFormInfo.getMeasureUnit().getCoefficient() : null;
        if (_bgFormInfo.getBgMeasureUnit() != null) {
            BgMeasureUnitInfo _muInfo = null;
            Iterator mes = _bgFormInfo.getBgMeasureUnit().iterator();
            while (mes.hasNext()) {
                _muInfo = (BgMeasureUnitInfo)mes.next();
                _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        Map _dataMap = null;
        MBgTemplateHelper.logTime("******************* UI LOGGER start getBgDataInfo: " + _bgFormInfo.getId() + "  " + _bgFormInfo.getName());
        if (_bgFormInfo.isUseThread()) {
            _dataMap = _bgFormInfo.getThreadBgDataMap();
            _bgFormInfo.setThreadBgDataMap(null);
            if (_dataMap == null) {
                _dataMap = BgFormExportBaseUtils.getBgFormInstance(ctx).getBgDataInfo(_bgFormInfo, null);
                _bgFormInfo.setUseThread(false);
            }
        } else {
            _dataMap = BgFormExportBaseUtils.getBgFormInstance(ctx).getBgDataInfo(_bgFormInfo, null);
        }
        MBgTemplateHelper.logTime("******************* UI LOGGER end getBgDataInfo: " + _bgFormInfo.getId() + "  " + _bgFormInfo.getName());
        _book = book == null ? _bgFormInfo.getBook() : book;
        _book.getProtection().deleteOperations();
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        BgFormExportBaseUtils.setSheetHide(ctx, _bgFormInfo, _book);
        BgFormExportBaseUtils.refillFixBook(ctx, _book, _dataMap, _bgFormInfo);
        ArrayList<String> sheetName = new ArrayList<String>();
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            sheetName.add(_book.getSheet(sheetIndex).getSheetName());
        }
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", _book);
        _tmpMap.put("EXPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("EXPORT_MEASUREUNIT", _muMap);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        _tmpMap.put("EXPORT_SHEETNAME", sheetName);
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)_bgFormInfo.getBgTemplate().getFormType())) {
            if (_bgFormInfo.getBgSpecialItems().isEmpty()) {
                _bgFormInfo.getBgSpecialItems().add(BgSpecialBudgetHelper.getBgSpecialItemByForm(ctx, _bgFormInfo));
            }
            _tmpMap.put("bgSpecialItems", (Object)_bgFormInfo.getBgSpecialItems());
        }
        return _tmpMap;
    }

    public static IBgForm getBgFormInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getLocalInstance(ctx);
    }

    public static void setSheetHide(Context ctx, BgFormInfo _bgFormInfo, Book _book) throws EASBizException, BOSException {
        MbgPermissionHelper.setSheetHide(ctx, _bgFormInfo.getBgScheme().getBgSchemeType().getSchemeType(), ctx == null ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), _bgFormInfo.getBgTemplate().getId().toString(), _bgFormInfo.getBgScheme().getId().toString(), _book);
        _book.getProtection().deleteOperations();
        for (int s = _book.getSheetCount() - 1; s >= 0; --s) {
            if (!_book.getSheet(s).isHide()) continue;
            _book.removeSheet(s);
        }
    }

    public static void refillFixBook(Context ctx, Book book, Map dataMap, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
        Sheet _sheet = null;
        Cell _cell = null;
        String formula = null;
        BgNDataInfo bgData = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            _sheet = book.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    formula = BgNFSHelper.getFormulaOfCell(_cell);
                    if (StringUtils.isEmpty((String)formula)) continue;
                    String tmpKey = DimUtils.getDimDataKey(formula, bgFormInfo.getBgVersion().getNumber());
                    bgData = dataMap.containsKey(bgFormInfo.getOrgUnit().getId().toString()) ? (BgNDataInfo)((Map)dataMap.get(bgFormInfo.getOrgUnit().getId().toString())).get(tmpKey) : (BgNDataInfo)dataMap.get(tmpKey);
                    if (bgData != null) {
                        if (cacheHelper.getBudgetScens().contains(bgData.getBgScenario())) {
                            if (bgData.getAdjustValue() != null) {
                                BgNFSHelper.setValue(_cell, bgData.getAdjustValue());
                                continue;
                            }
                            BgNFSHelper.setValue(_cell, bgData.getBudgetValue());
                            continue;
                        }
                        BgNFSHelper.setValue(_cell, bgData.getBizActual());
                        continue;
                    }
                    BgNFSHelper.setValue(_cell, null);
                }
            }
        }
    }

    public static KDSBook exportViewListExcelFile(BgFormInfo _bgFormInfo, MBGViewListFormExportProvider viewlistExportProcessor) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getViewListExcelExportParams(_bgFormInfo, viewlistExportProcessor);
        return BgNFSHelper.exportExcel(viewlistExportProcessor.getCtx(), tmpMap);
    }

    public static Book exportViewListExcelFile2007(BgFormInfo _bgFormInfo, MBGViewListFormExportProvider viewlistExportProcessor) throws Exception {
        Map tmpMap = BgFormExportBaseUtils.getViewListExcelExportParams(_bgFormInfo, viewlistExportProcessor);
        Book _book = BgNFSHelper.exportExcel2007(viewlistExportProcessor.getCtx(), tmpMap);
        BgNFSHelper.stopBookProtection(_book);
        List sheetName = (List)tmpMap.get("EXPORT_SHEETNAME");
        int nameIndex = 0;
        boolean hideSheetCount = false;
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
            if (_book.getSheet(sheetIndex).isHide()) continue;
            _book.getSheet(sheetIndex).setName((String)sheetName.get(nameIndex));
            ++nameIndex;
        }
        return _book;
    }

    private static Map getViewListExcelExportParams(BgFormInfo _bgFormInfo, MBGViewListFormExportProvider viewlistExportProcessor) throws Exception {
        Book book = viewlistExportProcessor.getBook(_bgFormInfo.getId().toString());
        BgFormExportBaseUtils.setSheetHide(null, _bgFormInfo, book);
        MbgViewlistMeasureUnitHelper measureHelper = BgFormExportBaseUtils.getViewlistMeasureUnitHelper(_bgFormInfo, viewlistExportProcessor);
        return BgFormExportBaseUtils.getViewListExcelExportParams(book, measureHelper);
    }

    public static Map getViewListExcelExportParams(Book book, MbgViewlistMeasureUnitHelper measureHelper) {
        HashMap _muMap = new HashMap();
        book.getProtection().deleteOperations();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        ArrayList<String> sheetName = new ArrayList<String>();
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            if (book.getSheet(sheetIndex).isHide()) continue;
            sheetName.add(book.getSheet(sheetIndex).getSheetName());
        }
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("EXPORT_BOOK", book);
        _tmpMap.put("EXPORT_BGFORMULA", null);
        _tmpMap.put("EXPORT_DATA", Boolean.TRUE);
        _tmpMap.put("EXPORT_SHEETNAME", sheetName);
        _tmpMap.put("EXPORT_ROW_MEMBER_UNMERGE", Boolean.FALSE);
        _tmpMap.put("isProcessTitle", Boolean.TRUE);
        _tmpMap.put("MbgViewlistMeasureUnitHelper", measureHelper);
        _tmpMap.put("isOutOfFormExport", true);
        return _tmpMap;
    }

    private static MbgViewlistMeasureUnitHelper getViewlistMeasureUnitHelper(BgFormInfo _bgFormInfo, ViewListProvider viewlistExportProcessor) throws BOSException {
        Map elementObjMap = BgElementHelper.getElementoObjMap();
        TemplateStyleInfo templateStyle = viewlistExportProcessor.getTemplateStyle(_bgFormInfo);
        if (templateStyle == null) {
            templateStyle = viewlistExportProcessor.getTemplateStyle();
        }
        MbgViewlistMeasureUnitHelper viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(viewlistExportProcessor.getAccountDataTypeMap(), templateStyle, elementObjMap);
        return viewlistMeasureHelper;
    }

    public static LinkedHashMap<String, BgFormInfo> getBgFormMap(Context ctx, Map _tmpBgFormIdsMap) {
        LinkedHashMap<String, BgFormInfo> bgFormMap = new LinkedHashMap<String, BgFormInfo>();
        ArrayList<String> formIds = new ArrayList<String>();
        Iterator iter = _tmpBgFormIdsMap.keySet().iterator();
        while (iter.hasNext()) {
            formIds.add((String)iter.next());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(BgFormExportBaseUtils.getSelector());
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(formIds), CompareType.INCLUDE));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        evi.setSorter(sort);
        try {
            BgFormCollection colls = BgFormExportBaseUtils.getBgFormInstance(ctx).getBgFormCollection(evi);
            for (int index = 0; index < colls.size(); ++index) {
                bgFormMap.put(colls.get(index).getId().toString(), colls.get(index));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return bgFormMap;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("creator");
        sic.add("creator.*");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.bgSchemeType.id");
        sic.add("bgScheme.bgSchemeType.schemeType");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.bgType.name");
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.dimensionAlias");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("orgUnit.longNumber");
        sic.add("orgUnit.simpleName");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.longNumber");
        sic.add("bgVersion.versionId");
        sic.add("state");
        sic.add("processType");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("creator.number");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("lastUpdateUser.number");
        return sic;
    }

    public static boolean checkSheetName(String name) {
        if (name == null || name.length() < 1 || name.length() > 31) {
            return false;
        }
        String regex = "(.*\\*.*)|(.*\\\\.*)|(.*\\?.*)|(.*\\/.*)|(.*\\[.*)|(.*\\].*)|(.*\\:.*)";
        if (name.matches(regex)) {
            return false;
        }
        char[] invalidChars = new char[]{'+', '*', '/', '='};
        boolean valid = true;
        for (int i = 0; i < invalidChars.length; ++i) {
            if (name.indexOf(invalidChars[i]) < 0) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static String getNewSheetName(Book book, String seedName, boolean copySign) {
        String newName;
        if (StringUtil.isEmptyString((String)seedName)) {
            String sheetNamePrefix = Global.getStringProperity((String)"SheetNamePrefix", (String)"Sheet");
            int num = book.getSheetCount() + 1;
            newName = sheetNamePrefix + num;
            while (BgFormExportBaseUtils.getSheetIndexByName(book, newName) >= 0) {
                newName = sheetNamePrefix + ++num;
            }
        } else {
            int dup = 2;
            int rightIndex = seedName.lastIndexOf(41);
            int leftIndex = seedName.lastIndexOf(40);
            if (leftIndex >= 0 && rightIndex > leftIndex - 1 && rightIndex == seedName.length() - 1) {
                try {
                    dup = Integer.parseInt(seedName.substring(leftIndex + 1, rightIndex));
                    seedName = seedName.substring(0, leftIndex);
                }
                catch (Exception e) {
                    dup = 2;
                }
            }
            newName = seedName;
            int seedLen = seedName.length();
            while (BgFormExportBaseUtils.getSheetIndexByName(book, newName) >= 0) {
                String tail = copySign ? "(" + dup + ")" : String.valueOf(dup);
                int tLen = tail.length();
                newName = seedLen + tLen > 31 ? seedName.substring(0, 31 - tLen) + tail : seedName + tail;
                ++dup;
            }
        }
        return newName;
    }

    private static int getSheetIndexByName(Book book, String sheetName) {
        if (StringUtil.isEmptyString((String)sheetName)) {
            return -1;
        }
        int index = -1;
        int sheetCount = book.getSheetCount();
        for (int i = sheetCount - 1; i >= 0; --i) {
            if (book.getSheet(i).getSheetName().compareToIgnoreCase(sheetName) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    public static String getNewSheetName(KDSBook kdsBook, String seedName, boolean copySign) {
        String newName;
        if (StringUtil.isEmptyString((String)seedName)) {
            String sheetNamePrefix = Global.getStringProperity((String)"SheetNamePrefix", (String)"Sheet");
            int num = kdsBook.getSheetCount() + 1;
            newName = sheetNamePrefix + num;
            while (BgFormExportBaseUtils.getSheetIndexByName(kdsBook, newName) >= 0) {
                newName = sheetNamePrefix + ++num;
            }
        } else {
            int dup = 2;
            int rightIndex = seedName.lastIndexOf(41);
            int leftIndex = seedName.lastIndexOf(40);
            if (leftIndex >= 0 && rightIndex > leftIndex - 1 && rightIndex == seedName.length() - 1) {
                try {
                    dup = Integer.parseInt(seedName.substring(leftIndex + 1, rightIndex));
                    seedName = seedName.substring(0, leftIndex);
                }
                catch (Exception e) {
                    dup = 2;
                }
            }
            newName = seedName;
            int seedLen = seedName.length();
            while (BgFormExportBaseUtils.getSheetIndexByName(kdsBook, newName) >= 0) {
                String tail = copySign ? "(" + dup + ")" : String.valueOf(dup);
                int tLen = tail.length();
                newName = seedLen + tLen > 31 ? seedName.substring(0, 31 - tLen) + tail : seedName + tail;
                ++dup;
            }
        }
        return newName;
    }

    private static int getSheetIndexByName(KDSBook kdsBook, String sheetName) {
        if (StringUtil.isEmptyString((String)sheetName)) {
            return -1;
        }
        int index = -1;
        for (int i = kdsBook.getSheetCount() - 1; i >= 0; --i) {
            if (kdsBook.getSheet((Object)i).getName().compareToIgnoreCase(sheetName) != 0) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void showMergeExortMenuItem(Map uiContext, KDMenuItem menuItemMergeExport) {
        if (uiContext != null && !uiContext.isEmpty() && menuItemMergeExport != null && uiContext.containsKey("WORKTABLEID_All")) {
            menuItemMergeExport.setVisible(true);
            menuItemMergeExport.setEnabled(true);
        }
    }
}

