/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgRollTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class BgFormHelper {
    public static final String STRRESOURCE = "com.kingdee.eas.ma.mbg.client.BgFormResource";
    public static final String ADJUSTSOURCE = "com.kingdee.eas.ma.mbg.client.BgFormAdjustResource";
    public static final String OrgUnitId = "orgUnitId";
    public static final String OrgUnitInfo = "orgUnitInfo";
    public static final String OrgUnitCU = "OrgUnitCU";
    public static final String isOpenReport = "OpenReport";
    public static final String isBizActual = "isBizActual";
    public static final String OpenReportState = "OpenReportState";
    public static final String OpenReportModal = "OpenReportModal";
    public static final String bgFormType = "bgFormType";
    public static final String budgetEditType = "budgetEditType";
    public static final String adjustHistory = "adjustHistory";
    public static final String OPEN_FORMULA = "OPEN_FORMULA";
    public static final String isNewAdjustForm = "isNewAdjustForm";
    public static final String isActionAdjust = "isActionAdjust";
    public static final String isCheckTmpData = "isCheckTmpData";
    private static DecimalFormat df = new DecimalFormat("00");
    private static String regex = "[^0-9]";
    private static Pattern pattern = Pattern.compile(regex);

    public static boolean checkInProInst(Context ctx, String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = null;
        procInsts = ctx == null ? EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(id) : EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean checkInProInst(String id) throws BOSException {
        return BgFormHelper.checkInProInst(null, id);
    }

    public static boolean checkProcessDefIsEnable(String userId, IObjectValue bizObject, String functionName, String operationName) throws BOSException {
        boolean result = true;
        String procId = EnactmentServiceFactory.createRemoteEnactService().findSubmitProcDef(userId, bizObject, functionName, operationName);
        if (procId == null) {
            result = false;
        }
        return result;
    }

    public static String getMessage(String msg) {
        return EASResource.getString((String)STRRESOURCE, (String)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backFillBgFormInfo(Context ctx, BgFormInfo info) throws Exception {
        HashSet<String> actScenarios = new HashSet<String>();
        List scenarios = BgScenarioHelper.getAcScenario((Context)ctx);
        for (BgScenarioInfo scenario : scenarios) {
            actScenarios.add(scenario.getNumber());
        }
        Map bgdataMap = (Map)info.get("CELL_DATA");
        if (bgdataMap == null || bgdataMap.isEmpty()) {
            return;
        }
        if (bgdataMap.get(info.getOrgUnit().getId().toString()) instanceof Map) {
            bgdataMap = (Map)bgdataMap.get(info.getOrgUnit().getId().toString());
        }
        Book book = info.getBook();
        BgNFSHelper.disableUndo(book);
        BgNFSHelper.disableCal(book);
        try {
            for (int s = 0; s < book.getSheetCount(); ++s) {
                Sheet sheet = book.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        Cell cell = sheet.getCell(r, c, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        String _tmpStr = BgNFSHelper.getFormulaOfCell(cell);
                        String _bgDataKey = DimUtils.getDimDataKey(_tmpStr, info.getBgVersion().getNumber());
                        if (bgdataMap.containsKey(_bgDataKey)) {
                            BgNDataInfo _info = (BgNDataInfo)bgdataMap.get(_bgDataKey);
                            if (cell == null || _info == null) continue;
                            if (actScenarios.contains(_info.getBgScenario())) {
                                BgNFSHelper.setValue(cell, _info.getBizActual());
                                continue;
                            }
                            if (_info.getAdjustValue() != null) {
                                BgNFSHelper.setValue(cell, _info.getAdjustValue());
                                continue;
                            }
                            BgNFSHelper.setValue(cell, _info.getBudgetValue());
                            continue;
                        }
                        if (cell == null) continue;
                        BgNFSHelper.setValue(cell, null);
                    }
                }
            }
        }
        finally {
            BgNFSHelper.enableCal(book);
            BgNFSHelper.enableUndo(book);
        }
        info.setBook(book);
    }

    public static void checkBgRollRule(BgFormInfo bgFormInfo, IMbgViewBase viewManager) throws EASBizException, BOSException {
        BgRollRuleInfo bgRollRule = bgFormInfo.getBgTemplate().getBgRollRule();
        if (bgRollRule == null) {
            return;
        }
        if (!BgFormHelper.checkBgPeriodByRollRule(null, bgFormInfo, viewManager)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"checkSaveByRollRule"));
            SysUtil.abort();
        }
    }

    public static boolean checkBgPeriodByRollRule(Context ctx, BgFormInfo b, IMbgViewBase viewManager) throws BOSException, EASBizException {
        if (viewManager == null) {
            return true;
        }
        BgRollRuleInfo bgRollRule = b.getBgTemplate().getBgRollRule();
        if (bgRollRule == null) {
            return true;
        }
        BgRollPartEnum rollPart = bgRollRule.getRollPart();
        LinkedHashSet<String> bgPeriodNumbers = new LinkedHashSet<String>();
        LinkedHashMap<String, Set<String>> pTypeNumbers = new LinkedHashMap<String, Set<String>>();
        BgRollTypeEnum rollType = bgRollRule.getRollType();
        BgPeriodInfo bgPeriod = b.getBgPeriod();
        BgFormHelper.queryPeriodByN(bgPeriodNumbers, viewManager, bgPeriod, rollPart);
        BgFormHelper.queryLeafPeriodMember(ctx, bgPeriodNumbers, pTypeNumbers);
        if (BgRollTypeEnum.limitLengthRoll.equals((Object)rollType)) {
            if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                return BgFormHelper.checkLimitedRoll4MonthQuarter(b, pTypeNumbers, bgPeriod);
            }
            return BgFormHelper.checkLimitLengthRoll(b, pTypeNumbers, bgPeriod);
        }
        if (BgRollPartEnum.monthWeek_monthRoll.equals((Object)rollPart)) {
            return BgFormHelper.checkUnLimitedRoll(b, pTypeNumbers, bgPeriod, BgPeriodEnum.MWEEK);
        }
        if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
            return BgFormHelper.checkUnLimitedRoll(b, pTypeNumbers, bgPeriod, BgPeriodEnum.MONTH);
        }
        return BgFormHelper.checkLimitLengthRoll(b, pTypeNumbers, bgPeriod);
    }

    private static boolean checkLimitedRoll4MonthQuarter(BgFormInfo b, Map<String, Set<String>> pTypeNumbers, BgPeriodInfo bgPeriod) {
        String pNumber = bgPeriod.getNumber();
        String quarter = pNumber.substring(pNumber.lastIndexOf(".") + 1);
        quarter = pattern.matcher(quarter).replaceAll("").trim();
        String firstLeafPeriod = df.format((Integer.parseInt(quarter) - 1) * 3 + 1);
        String concat = pNumber.substring(0, pNumber.lastIndexOf("."));
        String trim = pattern.matcher(concat).replaceAll("").trim();
        trim = trim.concat(firstLeafPeriod);
        for (Map.Entry<String, Set<String>> entry : pTypeNumbers.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(key.split(",")));
            if (!keys.contains(String.valueOf(BgPeriodEnum.MONTH.getValue())) || !BgFormHelper.check(trim, entry)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkUnLimitedRoll(BgFormInfo b, Map<String, Set<String>> pTypeNumbers, BgPeriodInfo bgPeriod, BgPeriodEnum periodEnum) {
        String typeNumber = null;
        String pNumber = null;
        String trim = null;
        String firstLeafPeriod = "01";
        pNumber = bgPeriod.getNumber();
        typeNumber = pNumber.substring(0, pNumber.indexOf("."));
        if (BgPeriodEnum.MWEEK.equals((Object)periodEnum)) {
            trim = pattern.matcher(pNumber).replaceAll("").trim();
        } else if (BgPeriodEnum.MONTH.equals((Object)periodEnum)) {
            String quarter = pNumber.substring(pNumber.lastIndexOf(".") + 1);
            quarter = pattern.matcher(quarter).replaceAll("").trim();
            firstLeafPeriod = df.format((Integer.parseInt(quarter) - 1) * 3 + 1);
            String concat = pNumber.substring(0, pNumber.lastIndexOf("."));
            trim = pattern.matcher(concat).replaceAll("").trim();
        }
        boolean flag = false;
        boolean childFlag = false;
        for (Map.Entry<String, Set<String>> entry : pTypeNumbers.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> keys = new ArrayList<String>(Arrays.asList(key.split(",")));
            if (!flag && keys.contains(typeNumber)) {
                flag = BgFormHelper.check(pattern.matcher(pNumber).replaceAll("").trim(), entry);
                continue;
            }
            if (childFlag || !keys.contains(String.valueOf(periodEnum.getValue())) || trim == null) continue;
            trim = trim.concat(firstLeafPeriod);
            childFlag = BgFormHelper.check(trim, entry);
        }
        return flag && childFlag;
    }

    private static boolean check(String trim, Map.Entry<String, Set<String>> entry) {
        boolean exists = false;
        int out = Integer.parseInt(trim);
        for (String number : entry.getValue()) {
            int in = Integer.parseInt(pattern.matcher(number = number.substring(number.indexOf("."))).replaceAll("").trim());
            if (in < out) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private static boolean checkLimitLengthRoll(BgFormInfo b, Map<String, Set<String>> pTypeNumbers, BgPeriodInfo bgPeriod) {
        String pNumber = bgPeriod.getNumber();
        String typeNumber = pNumber.substring(0, pNumber.indexOf("."));
        if (pTypeNumbers.containsKey(typeNumber = typeNumber.concat(",").concat(String.valueOf(bgPeriod.getPeriodType().getValue())))) {
            Iterator<String> iter = pTypeNumbers.get(typeNumber).iterator();
            while (iter.hasNext()) {
                if (iter.next().compareTo(pNumber) < 0) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private static void queryLeafPeriodMember(Context ctx, Set<String> bgPeriodNumbers, Map<String, Set<String>> pTypeNumbers) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("periodType");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", bgPeriodNumbers, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type.fiscalYear", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        IBgPeriodDisp instance = null;
        instance = ctx == null ? BgPeriodDispFactory.getRemoteInstance() : BgPeriodDispFactory.getLocalInstance((Context)ctx);
        BgPeriodDispCollection pCol = instance.getBgPeriodDispCollection(evi);
        for (BgPeriodDispInfo info : pCol) {
            String bgPeriodNumber = info.getNumber();
            String pType = bgPeriodNumber.substring(0, bgPeriodNumber.indexOf("."));
            BgPeriodEnum periodType = info.getPeriodType();
            if (!pTypeNumbers.containsKey(pType = pType.concat(",").concat(String.valueOf(periodType.getValue())))) {
                HashSet pNumbers = new HashSet();
                pTypeNumbers.put(pType, pNumbers);
            }
            pTypeNumbers.get(pType).add(bgPeriodNumber);
        }
    }

    public static void queryPeriodByN(Set<String> bgPeriodNumbers, IMbgViewBase viewManager, BgPeriodInfo bgPeriod) throws BgPeriodException {
        BgFormHelper.queryPeriodByN(bgPeriodNumbers, viewManager, bgPeriod, null);
    }

    public static void queryPeriodByN(Set<String> bgPeriodNumbers, IMbgViewBase viewManager, BgPeriodInfo bgPeriod, BgRollPartEnum rollPart) throws BgPeriodException {
        List<MbgViewListDimensionInfo> dimensions = null;
        String number = null;
        BgDimensionBaseInfo dimension = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            if (viewManager.getSheetManagers().get(s).getDimensionManager() instanceof MbgViewListDimensionManager) {
                dimensions = ((MbgViewListDimensionManager)viewManager.getSheetManagers().get(s).getDimensionManager()).getAllDimensions();
                BgFormHelper.queryRelationPeriod(bgPeriodNumbers, (MbgViewListDimensionManager)viewManager.getSheetManagers().get(s).getDimensionManager(), bgPeriod);
            } else {
                dimensions = viewManager.getSheetManagers().get(s).getDimensionManager().getDimension();
            }
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_PERIOD_NUMBER.equals((dimension = (BgDimensionBaseInfo)dimensions.get(d)).getNumber())) continue;
                for (int m = 0; m < dimension.getSelectMembers().size(); ++m) {
                    number = null;
                    if (dimension.getSelectMembers().get(m) instanceof BgDimensionMember) {
                        number = ((BgDimensionMember)dimension.getSelectMembers().get(m)).getNumber();
                    } else if (dimension.getSelectMembers().get(m) instanceof BgPeriodInfo) {
                        number = ((BgPeriodInfo)dimension.getSelectMembers().get(m)).getNumber();
                    }
                    if (number == null) continue;
                    int targetPeriodType = bgPeriod.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriod.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)number, (int)targetPeriodType));
                }
            }
        }
    }

    public static String getPeriodNNumber(Set<String> bgPeriodNumbers, IMbgViewBase viewManager, BgPeriodInfo bgPeriod, BgRollPartEnum rollPart) throws BgPeriodException {
        List<MbgViewListDimensionInfo> dimensions = null;
        String number = null;
        BgDimensionBaseInfo dimension = null;
        String periodNNumber = "";
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimensions = viewManager.getSheetManagers().get(s).getDimensionManager() instanceof MbgViewListDimensionManager ? ((MbgViewListDimensionManager)viewManager.getSheetManagers().get(s).getDimensionManager()).getAllDimensions() : viewManager.getSheetManagers().get(s).getDimensionManager().getDimension();
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_PERIOD_NUMBER.equals((dimension = (BgDimensionBaseInfo)dimensions.get(d)).getNumber())) continue;
                for (int m = 0; m < dimension.getSelectMembers().size(); ++m) {
                    number = null;
                    if (dimension.getSelectMembers().get(m) instanceof BgDimensionMember) {
                        number = ((BgDimensionMember)dimension.getSelectMembers().get(m)).getNumber();
                    } else if (dimension.getSelectMembers().get(m) instanceof BgPeriodInfo) {
                        number = ((BgPeriodInfo)dimension.getSelectMembers().get(m)).getNumber();
                    }
                    if (number == null) continue;
                    int targetPeriodType = bgPeriod.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriod.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    try {
                        bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)number, (int)targetPeriodType));
                        continue;
                    }
                    catch (Exception e) {
                        periodNNumber = number;
                        return periodNNumber;
                    }
                }
            }
            if (!StringUtils.isEmpty((String)periodNNumber) || !(viewManager.getSheetManagers().get(s).getDimensionManager() instanceof MbgViewListDimensionManager)) continue;
            MbgViewListDimensionManager bm = (MbgViewListDimensionManager)viewManager.getSheetManagers().get(s).getDimensionManager();
            ArrayList<MbgRelationMap> relationMaps = new ArrayList<MbgRelationMap>();
            if (bm.getPageRelationMaps() != null && !bm.getPageRelationMaps().isEmpty()) {
                relationMaps.addAll(bm.getPageRelationMaps());
            }
            List<IMbgViewListObject> rowCols = bm.getRowCols();
            MbgViewListRowCol rowCol = null;
            if (rowCols != null && !rowCols.isEmpty()) {
                for (int i = 0; i < rowCols.size(); ++i) {
                    if (!(rowCols.get(i) instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)rowCols.get(i)).getRelationMaps() == null || rowCol.getRelationMaps().isEmpty()) continue;
                    relationMaps.addAll(rowCol.getRelationMaps());
                }
            }
            MbgRelationMap relationMap = null;
            DimensionRelationshipCollection relationShips = null;
            DimensionRelationshipInfo dimensionRelationshipInfo = null;
            String dimensionNumber = null;
            String dimensionName = null;
            if (relationMaps == null || relationMaps.isEmpty()) continue;
            for (int j = 0; j < relationMaps.size(); ++j) {
                relationMap = (MbgRelationMap)relationMaps.get(j);
                if (relationMap.getRelationShips() == null || relationMap.getRelationShips().isEmpty()) continue;
                relationShips = relationMap.getRelationShips();
                String newDimensionNumber = null;
                Object newDimensionName = null;
                for (int x = 0; x < relationShips.size(); ++x) {
                    dimensionRelationshipInfo = relationShips.get(x);
                    dimensionNumber = dimensionRelationshipInfo.getDimensionNumber();
                    dimensionName = dimensionRelationshipInfo.getDimensionName();
                    newDimensionNumber = dimensionNumber;
                    if (StringUtils.isEmpty((String)dimensionNumber)) continue;
                    String[] arrayStrs = dimensionNumber.split(",");
                    for (int index = 0; index < arrayStrs.length; ++index) {
                        String memberNum = arrayStrs[index];
                        if (memberNum.indexOf(":") <= 0) continue;
                        String[] arr = memberNum.split(":");
                        String srcNum = arr[0];
                        String num = arr[1];
                        if (!DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)num)) continue;
                        int targetPeriodType = bgPeriod.getPeriodType().getValue();
                        String targetPeriodNumber = bgPeriod.getNumber();
                        try {
                            bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)num, (int)targetPeriodType));
                            continue;
                        }
                        catch (Exception e) {
                            periodNNumber = num;
                            return periodNNumber;
                        }
                    }
                }
            }
        }
        return periodNNumber;
    }

    public static void queryRelationPeriod(Set<String> bgPeriodNumbers, MbgViewListDimensionManager bm, BgPeriodInfo bgPeriod) throws BgPeriodException {
        ArrayList<MbgRelationMap> relationMaps = new ArrayList<MbgRelationMap>();
        if (bm.getPageRelationMaps() != null && !bm.getPageRelationMaps().isEmpty()) {
            relationMaps.addAll(bm.getPageRelationMaps());
        }
        List<IMbgViewListObject> rowCols = bm.getRowCols();
        MbgViewListRowCol rowCol = null;
        if (rowCols != null && !rowCols.isEmpty()) {
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol) || (rowCol = (MbgViewListRowCol)rowCols.get(i)).getRelationMaps() == null || rowCol.getRelationMaps().isEmpty()) continue;
                relationMaps.addAll(rowCol.getRelationMaps());
            }
        }
        BgFormHelper.queryRelationPeriod(bgPeriodNumbers, relationMaps, bgPeriod);
    }

    public static void queryRelationPeriod(Set<String> bgPeriodNumbers, List<MbgRelationMap> relationMaps, BgPeriodInfo bgPeriod) throws BgPeriodException {
        MbgRelationMap relationMap = null;
        DimensionRelationshipCollection relationShips = null;
        DimensionRelationshipInfo dimensionRelationshipInfo = null;
        String dimensionNumber = null;
        String dimensionName = null;
        if (relationMaps != null && !relationMaps.isEmpty()) {
            for (int j = 0; j < relationMaps.size(); ++j) {
                relationMap = relationMaps.get(j);
                if (relationMap.getRelationShips() == null || relationMap.getRelationShips().isEmpty()) continue;
                relationShips = relationMap.getRelationShips();
                String newDimensionNumber = null;
                Object newDimensionName = null;
                for (int s = 0; s < relationShips.size(); ++s) {
                    dimensionRelationshipInfo = relationShips.get(s);
                    dimensionNumber = dimensionRelationshipInfo.getDimensionNumber();
                    dimensionName = dimensionRelationshipInfo.getDimensionName();
                    newDimensionNumber = dimensionNumber;
                    if (StringUtils.isEmpty((String)dimensionNumber)) continue;
                    String[] arrayStrs = dimensionNumber.split(",");
                    for (int index = 0; index < arrayStrs.length; ++index) {
                        String memberNum = arrayStrs[index];
                        if (memberNum.indexOf(":") <= 0) continue;
                        String[] arr = memberNum.split(":");
                        String srcNum = arr[0];
                        String num = arr[1];
                        if (!DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || !BgPeriodNVariableHelper.checkCanConvert((String)num)) continue;
                        int targetPeriodType = bgPeriod.getPeriodType().getValue();
                        String targetPeriodNumber = bgPeriod.getNumber();
                        String newNumber = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)num, (int)targetPeriodType);
                        bgPeriodNumbers.add(newNumber);
                    }
                }
            }
        }
    }

    public static String getFirstMontPeriod(String sourceN, BgRollPartEnum rollPart) {
        String yearStr = sourceN.substring(sourceN.indexOf("."), sourceN.lastIndexOf(".") + 1);
        String quarter = sourceN.substring(sourceN.lastIndexOf(".") + 1);
        quarter = pattern.matcher(quarter).replaceAll("").trim();
        String firstMontPeriod = df.format((Integer.parseInt(quarter) - 1) * 3 + 1);
        return "MONT".concat(yearStr).concat(firstMontPeriod).concat("M");
    }

    public static BgPeriodEnum getPeriodByRollPart(BgRollPartEnum rollPart) {
        int type = 4;
        switch (rollPart.getValue()) {
            case 1: {
                type = 4;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 3: {
                type = 2;
                break;
            }
            case 4: {
                type = 3;
                break;
            }
            case 5: {
                type = 4;
                break;
            }
            case 0: {
                type = 6;
                break;
            }
            default: {
                type = 4;
            }
        }
        return BgPeriodEnum.getEnum((int)type);
    }

    public static String getMsg(Context ctx, String msgKey, BgFormInfo bgFormInfo, Object other) {
        String specialDimName;
        Object[] params = null;
        String string = specialDimName = bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null;
        if (!StringUtils.isEmpty(specialDimName)) {
            msgKey = msgKey + "Special";
        }
        if (other != null) {
            params = StringUtils.isEmpty((String)specialDimName) ? new Object[7] : new Object[8];
            params[params.length - 1] = other;
        } else {
            params = StringUtils.isEmpty((String)specialDimName) ? new Object[6] : new Object[7];
        }
        params[0] = bgFormInfo.getOrgUnit().getName();
        params[1] = bgFormInfo.getBgTemplate().getName();
        params[2] = bgFormInfo.getBgPeriod().getName();
        params[3] = bgFormInfo.getBgVersion().getName();
        params[4] = bgFormInfo.getCurrency().getName();
        if (!StringUtils.isEmpty((String)specialDimName)) {
            params[5] = specialDimName;
            params[6] = bgFormInfo.getProcessType().getAlias();
        } else {
            params[5] = bgFormInfo.getProcessType().getAlias();
        }
        return BgFormHelper.getMsg(ctx, msgKey, params);
    }

    public static String getMsg(Context ctx, String msgKey, Object[] param) {
        if (param == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)msgKey, (Locale)ctx.getLocale());
        }
        return MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)msgKey, (Locale)ctx.getLocale()), param);
    }

    public static String dealBgSpecialItems(String rule) {
        String[] props = new String[]{"dimensionNumber", "dimensionName", "memberName", "memberDisplayName"};
        rule = rule.indexOf("EntryAllWhere") != 1 ? rule.replaceAll("EntryAllWhere", "and").replaceAll(" ON bgSpecialItems", "") : rule.replaceAll("EntryAll", "").replaceAll(" ON bgSpecialItems", "");
        for (int i = 0; i < props.length; ++i) {
            rule = rule.replaceAll(props[i], "bgSpecialItems." + props[i]);
        }
        return rule;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Set<String>> getHasRollFormKey(Connection conn, TempTablePool pool, BgFormInfo baseInfo, Object[] orgUnitInfos, Object[] bgTemplateInfos, Object[] bgVersionInfos, Object[] currencyInfos, int processTypeValue, boolean isQueryByOrg) throws BOSException, EASBizException {
        HashMap<String, Set<String>> hasFormKeys = new HashMap<String, Set<String>>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String tmpIdTable = null;
        if (orgUnitInfos != null && orgUnitInfos.length != 0) {
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (!(orgUnitInfos[i] instanceof BgOrgUnitInfo)) continue;
                orgUnitInfos[i] = ((BgOrgUnitInfo)orgUnitInfos[i]).castToFullOrgUnitInfo();
            }
        }
        try {
            boolean orgFlag = true;
            int temFlag = 2;
            int verFlag = 3;
            int curFlag = 4;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            BgFormHelper.addToParam(paramList, orgUnitInfos, 1);
            BgFormHelper.addToParam(paramList, bgTemplateInfos, 2);
            BgFormHelper.addToParam(paramList, bgVersionInfos, 3);
            BgFormHelper.addToParam(paramList, currencyInfos, 4);
            tmpIdTable = pool.createTempTable("create table T_MBG_TemIdTable(FFlag INT NOT NULL, FID Varchar(44) NOT NULL)");
            pool.createIndex(tmpIdTable, "FFlag,FID", true, true);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpIdTable + "(FFlag, FID) Values(?, ?)"), paramList);
            StringBuilder sql = BgFormHelper.getExistsRollFormSQL(baseInfo, isQueryByOrg, tmpIdTable);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, baseInfo.getBgScheme().getId().toString());
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 2);
            pstmt.setInt(4, 3);
            pstmt.setInt(5, 4);
            if (isQueryByOrg) {
                pstmt.setInt(6, 1);
                pstmt.setInt(7, 2);
            } else {
                pstmt.setInt(6, processTypeValue == 0 ? baseInfo.getProcessType().getValue() : processTypeValue);
            }
            if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
                if (isQueryByOrg) {
                    pstmt.setString(8, baseInfo.getBgSpecialItems().get(0).getDimensionNumber());
                } else {
                    pstmt.setString(7, baseInfo.getBgSpecialItems().get(0).getDimensionNumber());
                }
            }
            res = pstmt.executeQuery();
            while (res.next()) {
                String rollFormKey;
                String period_state = res.getString("FNumber").concat(",").concat(String.valueOf(res.getInt("FState")));
                if (isQueryByOrg) {
                    if (res.getInt("FisLeaf") == 1 && res.getInt("FProcessType") == 1) {
                        rollFormKey = BgFormHelper.getRollKey4Process(res.getString("FOrgUnitId"), res.getString("FBgTemplateId"), res.getString("FBgVersionId"), res.getString("FCurrencyId"), res.getInt("FProcessType"));
                        if (!hasFormKeys.containsKey(rollFormKey)) {
                            hasFormKeys.put(rollFormKey, new HashSet());
                        }
                        ((Set)hasFormKeys.get(rollFormKey)).add(period_state);
                        continue;
                    }
                    if (res.getInt("FisLeaf") != 0 || res.getInt("FProcessType") != 2) continue;
                    rollFormKey = BgFormHelper.getRollKey4Process(res.getString("FOrgUnitId"), res.getString("FBgTemplateId"), res.getString("FBgVersionId"), res.getString("FCurrencyId"), res.getInt("FProcessType"));
                    if (!hasFormKeys.containsKey(rollFormKey)) {
                        hasFormKeys.put(rollFormKey, new HashSet());
                    }
                    ((Set)hasFormKeys.get(rollFormKey)).add(period_state);
                    continue;
                }
                if (StringUtils.isEmpty((String)res.getString("FOrgUnitId"))) continue;
                rollFormKey = BgFormHelper.getRollKey4Process(res.getString("FOrgUnitId"), res.getString("FBgTemplateId"), res.getString("FBgVersionId"), res.getString("FCurrencyId"), res.getInt("FProcessType"));
                if (!hasFormKeys.containsKey(rollFormKey)) {
                    hasFormKeys.put(rollFormKey, new HashSet());
                }
                ((Set)hasFormKeys.get(rollFormKey)).add(period_state);
            }
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (EASBizException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new BOSException((Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                if (tmpIdTable == null) throw throwable;
                pool.releaseTable(tmpIdTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        if (tmpIdTable == null) return hasFormKeys;
        pool.releaseTable(tmpIdTable);
        return hasFormKeys;
    }

    public static String getRollKey4Process(Object orgUnitId, Object bgTemplateId, Object bgVersionId, Object currencyId, int processTypeValue) {
        return orgUnitId + "_" + bgTemplateId + "_" + bgVersionId + "_" + currencyId + "_" + processTypeValue;
    }

    public static void addToParam(List<Object[]> paramList, Object[] objectValues, int flag) {
        for (Object obj : objectValues) {
            paramList.add(new Object[]{flag, ((CoreBaseInfo)obj).getId().toString()});
        }
    }

    private static StringBuilder getExistsRollFormSQL(BgFormInfo baseInfo, boolean isQueryByOrg, String tmpIdTable) {
        StringBuilder sql = new StringBuilder();
        sql.append("Select t0.Fid, t0.FOrgUnitId, t0.FBgTemplateId, t0.FBgVersionId, t0.FCurrencyId, t2.FisLeaf, t0.FProcessType,t3.FNumber,t0.FState FROM T_MBG_BgForm t0 ");
        if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
            sql.append(" Left Join T_MBG_BgSpecialItems t1 ON t1.FBgFormId = t0.FID ");
        }
        sql.append(" Left Join T_MBG_BgOrgUnit t2 ON t2.FOrgUnitID = t0.FOrgUnitId ");
        sql.append(" Left Join T_MBG_BgPeriod t3 ON t3.FID = t0.FBgPeriodId ");
        sql.append("Where t0.FBgSchemeId = ?  AND t0.FState in ('6','12','2')");
        sql.append(" AND t0.FBgRollPeriodID is not null ");
        sql.append("AND t0.FOrgUnitId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FBgTemplateId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FBgVersionId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        sql.append("AND t0.FCurrencyId IN(Select FID FROM ").append(tmpIdTable).append(" Where FFlag = ?) ");
        if (isQueryByOrg) {
            sql.append("AND (t0.FProcessType = ? ");
            sql.append("OR t0.FProcessType = ? )");
        } else {
            sql.append("AND t0.FProcessType = ? ");
        }
        if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
            sql.append(" AND (t1.FDimensionNumber = ? OR t1.FDimensionNumber IS NULL)");
        }
        return sql;
    }
}

