/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;

public class BgFormulaReapeatCHelper {
    private static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource";

    public static StringBuilder checkFormulaRepeat(Book book) {
        if (BgParamCHelper.isFormulaRepeat()) {
            return null;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        int sheetSize = book.getSheetCount();
        block0: for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            String sheetName = _sheet.getSheetName();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    String[] params = BgNFSHelper.parseFormulaPara(null, formulaStr);
                    String[] paramsNew = new String[6];
                    if (formulaStr.toLowerCase().indexOf("=bgitem") >= 0) {
                        if (params.length == 5) {
                            paramsNew[0] = params[0];
                            paramsNew[1] = params[1];
                            paramsNew[2] = params[2];
                            paramsNew[3] = params[3];
                            paramsNew[4] = "true";
                            paramsNew[5] = params[4];
                        } else if (params.length == 6) {
                            paramsNew = params;
                        }
                        formulaStr = BgNFSHelper.getFormulaFromParam(paramsNew);
                    }
                    if (!formulaMap.containsKey(formulaStr)) {
                        formulaMap.put(formulaStr, sheetName + "#@" + _cell.getName(false, false));
                        continue;
                    }
                    String orignalSheet = (String)formulaMap.get(formulaStr);
                    String[] split = orignalSheet.split("#@");
                    String format = MessageFormat.format(BgCommCHelper.getMessageStr((String)RESOURCE, (String)"repeatFormulaError"), split[0], split[1], sheetName, _cell.getName(false, false));
                    str.append(format);
                    break block0;
                }
            }
        }
        return str;
    }

    private static String getMsg(Context ctx, String msgKey, BgFormInfo bgFormInfo, Object[] paramBook) {
        String specialDimName;
        Object[] params = null;
        String string = specialDimName = bgFormInfo.getBgSpecialItems() != null && !bgFormInfo.getBgSpecialItems().isEmpty() ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null;
        if (!StringUtils.isEmpty(specialDimName)) {
            msgKey = msgKey + "Special";
        }
        params = StringUtils.isEmpty(specialDimName) ? new Object[10] : new Object[11];
        params[0] = bgFormInfo.getOrgUnit().getName();
        params[1] = bgFormInfo.getBgTemplate().getName();
        params[2] = bgFormInfo.getBgPeriod().getName();
        params[3] = bgFormInfo.getBgVersion().getName();
        params[4] = bgFormInfo.getCurrency().getName();
        if (!StringUtils.isEmpty((String)specialDimName)) {
            params[5] = specialDimName;
            params[6] = bgFormInfo.getProcessType().getAlias();
            params[7] = paramBook[0];
            params[8] = paramBook[1];
            params[9] = paramBook[2];
            params[10] = paramBook[3];
        } else {
            params[5] = bgFormInfo.getProcessType().getAlias();
            params[6] = paramBook[0];
            params[7] = paramBook[1];
            params[8] = paramBook[2];
            params[9] = paramBook[3];
        }
        return MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)msgKey, (Locale)ctx.getLocale()), params);
    }

    public static StringBuilder checkFormulaRepeatSer(Context ctx, Book book, BgFormInfo formInfo) {
        if (BgParamNHelper.isFormulaRepeat((Context)ctx)) {
            return null;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        int sheetSize = book.getSheetCount();
        block0: for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            String sheetName = _sheet.getSheetName();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    if (!formulaMap.containsKey(formulaStr)) {
                        formulaMap.put(formulaStr, sheetName + "#@" + _cell.getName(false, false));
                        continue;
                    }
                    String orignalSheet = (String)formulaMap.get(formulaStr);
                    String[] split = orignalSheet.split("#@");
                    Object[] param = new Object[]{split[0], split[1], sheetName, _cell.getName(false, false)};
                    String format = BgFormulaReapeatCHelper.getMsg(ctx, "repeatFormulaErrorSer", formInfo, param);
                    str.append(format);
                    break block0;
                }
            }
        }
        return str;
    }
}

