/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.assist.HandleWhenNoValueFormula;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.bgcsl.BgCslAdjFormInfo;
import com.kingdee.eas.ma.bgcsl.BgCslElimInfo;
import com.kingdee.eas.ma.bgcsl.BgCslFormInfo;
import com.kingdee.eas.ma.bgcsl.MbgWorkPaperInfo;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcExpreUtils;
import com.kingdee.eas.ma.mbg.AbstractBgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgNFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgNFormFacade;
import com.kingdee.eas.ma.mbg.app.formula.face.IBgCalculator;
import com.kingdee.eas.ma.mbg.app.formula.face.IFormula;
import com.kingdee.eas.ma.mbg.app.formula.impl.FormulaInfo;
import com.kingdee.eas.ma.mbg.app.formula.impl.adjustDate.BgAdjustDateInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgSpecialInfo;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.impl.DataManagerImpl;
import com.kingdee.eas.ma.mbg.dimension.impl.DimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.formula.IMbgFormulaConstants;
import com.kingdee.eas.ma.mbg.utils.BgExcelFormulaPaserHelper;
import com.kingdee.eas.ma.mbg.utils.BgExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.mbg.utils.CustomerFormat;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgNExpressionHelper
implements IMbgFormulaConstants {
    private static final Logger logger = Logger.getLogger(BgNExpressionHelper.class);
    public static final String AT_STR = "@";
    public static final String MBGACTUALS_STR = "MbgActuals";
    public static final String MBGFORMULA_STR = "MbgFormula";
    public static final String MBGAGGREGATE_STR = "MbgAggregate";
    public static final String MBGBGAVLBAL_STR = "MbgBgAvlBal";
    public static final String MBGADJUST_STR = "Mbgadjust";
    public static final String MBGADJUSTDATE_STR = "MbgAdjustDate";
    public static final String MBGCSL_STR = "MbgCsl";
    public static final String MbgControlStr = "MbgControl";
    public static final String MBGACTUALDAY_STR = "MbgActualDay";
    public static final String MBGACCT = "ACCT";
    public static final String MBGCSREF = "CSREF";
    public static final String MBGINACCT = "INACCT";
    public static final String MBGELIMDATA = "ElimData";
    public static final String MBGCORUNIT = "MbgCorUnit";
    private static Context context = null;
    private static Connection conn = null;
    public static IMbgSheetBase curSheetManager = null;
    public static List<BgDimensionMember> curMemberList = new ArrayList<BgDimensionMember>();
    public static OrgUnitInfo curOrgUnit = null;
    private static boolean isByRowColCalc = false;
    private static Set<String> periodNums;
    private static Set<String> currencyNums;
    private static DimensionParameter parameter;
    private static BizCalcExpreUtils bizCalcExpreUtils;

    public static Context getCtx() {
        return context;
    }

    public static void setCtx(Context ctx) {
        context = ctx;
    }

    public static void setConn(Connection connection) {
        conn = connection;
    }

    public static Connection getConn() {
        return conn;
    }

    public static String checkExpression(Context ctx, Cell cell, String expressions, IObjectValue model, String costCenterNumber, boolean isReplacePeriodNVar, boolean isCsl) {
        return BgNExpressionHelper.checkExpression(ctx, cell, expressions, model, costCenterNumber, null, isReplacePeriodNVar, isCsl);
    }

    public static String checkExpression(final Context ctx, Cell cell, String expressions, final IObjectValue model, final String costCenterNumber, final String itemCombine, final boolean isReplacePeriodNVar, final boolean isCsl) {
        if (StringUtils.isEmpty((String)expressions) || !(model instanceof IDimDataQuery)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (BgNExpressionHelper.checkHasFunctionExpr(expression)) {
                if (cell != null && expression instanceof FunctionExpr) {
                    BgNExpressionHelper.checkFuncionName((FunctionExpr)expression, cell);
                }
                if (expression instanceof Ref3DExpr) {
                    return expressions;
                }
            } else {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNExpressionHelper.checkExpression(ctx, expr, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
                }
            });
            _expressions = '=' + ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression);
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    public static String checkExpression(final Context ctx, String expressions, final String unionOrgNumber) {
        if (StringUtils.isEmpty((String)expressions)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (BgNExpressionHelper.checkHasFunctionExpr(expression)) {
                if (expression instanceof Ref3DExpr) {
                    return expressions;
                }
            } else {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNExpressionHelper.checkExpression(ctx, expr, unionOrgNumber);
                }
            });
            _expressions = ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression).replaceAll("\\s*", "");
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static boolean isFunctionExpr(Expression expression) {
        return expression instanceof FunctionExpr;
    }

    private static boolean checkHasFunctionExpr(Expression expression) {
        boolean isFunctionExpr = BgNExpressionHelper.isFunctionExpr(expression);
        if (isFunctionExpr) {
            return true;
        }
        if (expression instanceof BinaryOperationExpr) {
            isFunctionExpr = BgNExpressionHelper.checkHasFunctionExpr(((BinaryOperationExpr)expression).left);
            if (isFunctionExpr) {
                return true;
            }
            isFunctionExpr = BgNExpressionHelper.checkHasFunctionExpr(((BinaryOperationExpr)expression).right);
            if (isFunctionExpr) {
                return true;
            }
        }
        return false;
    }

    private static Expression dealExpressSpecialSymbols(Expression expression, List members) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.dealExpressSpecialSymbols((FunctionExpr)expression, members);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.dealExpressSpecialSymbols((BinaryOperationExpr)expression, members);
        }
        return expression;
    }

    private static Expression dealExpressSpecialSymbols(FunctionExpr expression, List members) {
        String funcName = expression.funcionName;
        List parameter = expression.parameters;
        if (MBGAGGREGATE_STR.equalsIgnoreCase(funcName) || MBGADJUST_STR.equalsIgnoreCase(funcName) || MBGADJUSTDATE_STR.equalsIgnoreCase(funcName) || MBGACTUALDAY_STR.equalsIgnoreCase(funcName) || MbgControlStr.equalsIgnoreCase(funcName)) {
            int parIndex = 3;
            String itemNumber = ((StringExpr)parameter.get((int)parIndex)).value;
            if (!StringUtils.isEmpty((String)itemNumber) && itemNumber.indexOf(AT_STR) >= 0) {
                ((StringExpr)parameter.get((int)parIndex)).value = BgNExpressionHelper.replaceSpecialSymbols(itemNumber, members);
            }
        } else if (MBGBGAVLBAL_STR.equalsIgnoreCase(funcName) || MBGCSL_STR.equalsIgnoreCase(funcName)) {
            int parIndex = 4;
            String itemNumber = ((StringExpr)parameter.get((int)parIndex)).value;
            if (!StringUtils.isEmpty((String)itemNumber) && itemNumber.indexOf(AT_STR) >= 0) {
                ((StringExpr)parameter.get((int)parIndex)).value = BgNExpressionHelper.replaceSpecialSymbols(itemNumber, members);
            }
        } else if (MBGCORUNIT.equalsIgnoreCase(funcName)) {
            int corUnitIndex = 4;
            String corUnitNumber = ((StringExpr)parameter.get((int)corUnitIndex)).value;
            int parIndex = 5;
            String itemNumber = ((StringExpr)parameter.get((int)parIndex)).value;
            if (!StringUtils.isEmpty((String)itemNumber) && itemNumber.indexOf(AT_STR) >= 0) {
                ((StringExpr)parameter.get((int)parIndex)).value = BgNExpressionHelper.replaceSpecialSymbols(corUnitNumber, itemNumber, members);
            }
        }
        return expression;
    }

    private static String replaceSpecialSymbols(String corUnitNumber, String itemNumber, List members) {
        BgDimensionMember member;
        if (StringUtils.isEmpty((String)corUnitNumber)) {
            return BgNExpressionHelper.replaceSpecialSymbols(itemNumber, members);
        }
        if (StringUtils.isEmpty((String)itemNumber) || members == null || members.isEmpty()) {
            return itemNumber;
        }
        for (int index = members.size() - 1; index >= 0; --index) {
            member = (BgDimensionMember)members.get(index);
            if (!MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType()) && !corUnitNumber.equalsIgnoreCase(member.getNumber())) continue;
            members.remove(index);
        }
        Collections.sort(members, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember o1, BgDimensionMember o2) {
                if (DimensionCommonHelper.getField(o1.getAttribute().toUpperCase()) > DimensionCommonHelper.getField(o2.getAttribute().toUpperCase())) {
                    return 1;
                }
                if (DimensionCommonHelper.getField(o1.getAttribute().toUpperCase()) < DimensionCommonHelper.getField(o2.getAttribute().toUpperCase())) {
                    return -1;
                }
                return 0;
            }
        });
        String item = "";
        int size = members.size();
        for (int index = 0; index < size; ++index) {
            member = (BgDimensionMember)members.get(index);
            if (member.getType() == null || MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) continue;
            item = item + member.getSrcNumber() + ":" + member.getNumber();
            if (index >= size - 1) continue;
            item = item + ",";
        }
        if (StringUtils.isEmpty((String)item)) {
            return itemNumber;
        }
        return itemNumber.replaceAll(AT_STR, item);
    }

    private static Expression dealExpressSpecialSymbols(BinaryOperationExpr boExpr, List members) {
        boExpr.left = BgNExpressionHelper.dealExpressSpecialSymbols(boExpr.left, members);
        boExpr.right = BgNExpressionHelper.dealExpressSpecialSymbols(boExpr.right, members);
        return boExpr;
    }

    public static String dealExpressSpecialSymbols(String expressions, final List members) {
        String _expressions = "";
        try {
            Expression expression = ExcelFormulaPaserHelper.parse((String)expressions);
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNExpressionHelper.dealExpressSpecialSymbols(expr, members);
                }
            });
            _expressions = '=' + ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _expressions;
    }

    private static String replaceSpecialSymbols(String itemNumber, List<BgDimensionMember> members) {
        BgDimensionMember member;
        if (StringUtils.isEmpty((String)itemNumber) || members == null || members.isEmpty()) {
            return itemNumber;
        }
        for (int index = members.size() - 1; index >= 0; --index) {
            member = members.get(index);
            if (!MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType()) && !MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType()) && !DimensionConstants.DEF_CSL_NUMBER.equalsIgnoreCase(member.getType())) continue;
            members.remove(index);
        }
        Collections.sort(members, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember o1, BgDimensionMember o2) {
                if (DimensionCommonHelper.getField(o1.getAttribute().toUpperCase()) > DimensionCommonHelper.getField(o2.getAttribute().toUpperCase())) {
                    return 1;
                }
                if (DimensionCommonHelper.getField(o1.getAttribute().toUpperCase()) < DimensionCommonHelper.getField(o2.getAttribute().toUpperCase())) {
                    return -1;
                }
                return 0;
            }
        });
        String item = "";
        int size = members.size();
        for (int index = 0; index < size; ++index) {
            member = members.get(index);
            if (member.getType() == null || MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_INDEX.equalsIgnoreCase(member.getType()) || MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType()) || DimensionConstants.DEF_CSL_NUMBER.equalsIgnoreCase(member.getType())) continue;
            item = item + member.getSrcNumber() + ":" + member.getNumber();
            if (index >= size - 1) continue;
            item = item + ",";
        }
        if (StringUtils.isEmpty((String)item)) {
            return itemNumber;
        }
        return itemNumber.replaceAll(AT_STR, item);
    }

    private static void checkFuncionName(FunctionExpr expr, Cell cell) {
        String obj;
        if (expr == null || cell == null) {
            return;
        }
        String funcionName = expr.funcionName;
        if (("RPTDATE".equalsIgnoreCase(funcionName) || "MbgRptDate".equalsIgnoreCase(funcionName) || "MbgCreateDate".equalsIgnoreCase(funcionName) || "MbgGetOrgNum".equalsIgnoreCase(funcionName)) && ((obj = cell.getStyle().getNumberFormat()) == null || !AT_STR.equals(obj))) {
            BgNFSHelper.setNumberFormat(cell, AT_STR);
        }
    }

    private static Expression checkExpression(Context ctx, Expression expression, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar, boolean isCsl) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.checkFunctionExpr(ctx, (FunctionExpr)expression, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkBinaryOperationExpr(ctx, (BinaryOperationExpr)expression, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, model);
        }
        return expression;
    }

    private static Expression checkExpression(Context ctx, Expression expression, String unionOrgNumber) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.checkFunctionExpr(ctx, (FunctionExpr)expression, unionOrgNumber);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkBinaryOperationExpr(ctx, (BinaryOperationExpr)expression, unionOrgNumber);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, null);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(Context ctx, FunctionExpr funExpr, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar, boolean isCsl) {
        String funcionName = funExpr.funcionName;
        try {
            Expression p2;
            if (MBGFORMULA_STR.equalsIgnoreCase(funcionName) || MBGAGGREGATE_STR.equalsIgnoreCase(funcionName) || "MbgBal".equalsIgnoreCase(funcionName) || MBGACTUALS_STR.equalsIgnoreCase(funcionName) || "MbgRefBgTem".equalsIgnoreCase(funcionName) || MBGADJUST_STR.equalsIgnoreCase(funcionName) || MBGADJUSTDATE_STR.equalsIgnoreCase(funcionName) || "MbgAvlBal".equalsIgnoreCase(funcionName) || "MbgRefBgForm".equalsIgnoreCase(funcionName) || "MbgActualExt".equalsIgnoreCase(funcionName) || MBGBGAVLBAL_STR.equalsIgnoreCase(funcionName) || "IF".equalsIgnoreCase(funcionName) || MbgControlStr.equalsIgnoreCase(funcionName) || MBGACTUALDAY_STR.equalsIgnoreCase(funcionName) || MBGACCT.equalsIgnoreCase(funcionName)) {
                FormulaUtils.updateParams(funExpr);
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    String[] pp;
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    if (StringUtils.isEmpty((String)valueStr)) {
                        if (!StringUtils.isEmpty((String)costCenterNumber) && (MBGAGGREGATE_STR.equalsIgnoreCase(funcionName) || MBGADJUSTDATE_STR.equalsIgnoreCase(funcionName) || MBGADJUST_STR.equalsIgnoreCase(funcionName) || MBGBGAVLBAL_STR.equalsIgnoreCase(funcionName) || "MbgRefBgTem".equalsIgnoreCase(funcionName) || "MbgRefBgForm".equalsIgnoreCase(funcionName) || MbgControlStr.equalsIgnoreCase(funcionName) || MBGACTUALDAY_STR.equalsIgnoreCase(funcionName))) {
                            sp.value = costCenterNumber;
                        } else if (MBGACCT.equals(funcionName)) {
                            BgExpressionHelper.checkActExprOrg(ctx, funExpr, model, BgNExpressionHelper.getOrgUnitIdByNumber(costCenterNumber));
                        }
                    } else if (!MBGAGGREGATE_STR.equalsIgnoreCase(funcionName) && (pp = valueStr.split(";")) != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i].trim()));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgNExpressionHelper.checkExpression(ctx, (Expression)_expression, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
                    }
                } else if (p0 instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam((FunctionExpr)p0, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
                }
                if (_expression instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam(_expression, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
                }
                return _expression;
            }
            if (MBGELIMDATA.equalsIgnoreCase(funcionName)) {
                Expression p22 = (Expression)funExpr.parameters.get(2);
                if (p22 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p22;
                    String valueStr = sp.value;
                    if (StringUtils.isEmpty((String)valueStr)) {
                        BgExpressionHelper.checkElimDataExprOrg(ctx, funExpr, model, BgNExpressionHelper.getOrgUnitIdByNumber(costCenterNumber), isCsl);
                    }
                }
            } else if (MBGINACCT.equalsIgnoreCase(funcionName)) {
                Expression p23 = (Expression)funExpr.parameters.get(0);
                if (p23 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p23;
                    String valueStr = sp.value;
                    if (StringUtils.isEmpty((String)valueStr)) {
                        BgExpressionHelper.checkInAcctExpr(ctx, funExpr, model, costCenterNumber != null ? BgNExpressionHelper.getOrgUnitIdByNumber(costCenterNumber) : null);
                    }
                }
            } else if (MBGCSREF.equalsIgnoreCase(funcionName) && (p2 = (Expression)funExpr.parameters.get(1)) instanceof StringExpr) {
                StringExpr sp = (StringExpr)p2;
                String valueStr = sp.value;
                if (StringUtils.isEmpty((String)valueStr)) {
                    BgExpressionHelper.checkCsRefExprOrg(ctx, funExpr, model, costCenterNumber != null ? BgNExpressionHelper.getOrgUnitIdByNumber(costCenterNumber) : null);
                }
            }
            BgNExpressionHelper.checkExpressionParam(funExpr, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static Expression checkFunctionExpr(Context ctx, FunctionExpr funExpr, String unionOrgNumber) {
        String funcionName = funExpr.funcionName;
        try {
            if (MBGELIMDATA.equalsIgnoreCase(funcionName)) {
                Expression p2 = (Expression)funExpr.parameters.get(2);
                if (p2 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p2;
                    String valueStr = sp.value;
                    if (StringUtils.isEmpty((String)valueStr)) {
                        BgExpressionHelper.checkElimDataExprOrg(ctx, funExpr, unionOrgNumber);
                    }
                }
                BgNExpressionHelper.checkElimParam(funExpr);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static OrgUnitInfo getOrgUnitIdByNumber(String costCenterNumber) {
        OrgUnitInfo orgUnit = new OrgUnitInfo();
        BgDimensionMember temp = null;
        if (curMemberList == null) {
            return null;
        }
        for (int i = 0; i < curMemberList.size(); ++i) {
            temp = curMemberList.get(i);
            if (!temp.getNumber().equals(costCenterNumber) || !BOSUuid.isValid((String)temp.getAttribute(), (boolean)true)) continue;
            orgUnit.setId(BOSUuid.read((String)temp.getAttribute()));
        }
        if (orgUnit.getId() == null) {
            return null;
        }
        return orgUnit;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(Context ctx, BinaryOperationExpr boExpr, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar, boolean isCsl) {
        boExpr.left = BgNExpressionHelper.checkExpression(ctx, boExpr.left, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
        boExpr.right = BgNExpressionHelper.checkExpression(ctx, boExpr.right, model, costCenterNumber, itemCombine, isReplacePeriodNVar, isCsl);
        return boExpr;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(Context ctx, BinaryOperationExpr boExpr, String unionOrgNumber) {
        boExpr.left = BgNExpressionHelper.checkExpression(ctx, boExpr.left, unionOrgNumber);
        boExpr.right = BgNExpressionHelper.checkExpression(ctx, boExpr.right, unionOrgNumber);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, IObjectValue model) {
        return boExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) throws Exception {
        String funcionName = funExpr.funcionName;
        if (MBGFORMULA_STR.equalsIgnoreCase(funcionName) || MBGACTUALS_STR.equalsIgnoreCase(funcionName) || "MbgGetOrgTypeVal".equalsIgnoreCase(funcionName) || MbgControlStr.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMBgFormulaParam(funExpr.parameters, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        } else if (MBGCSL_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMBgCslParam(funExpr.parameters, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        } else if (MBGAGGREGATE_STR.equalsIgnoreCase(funcionName) || MBGADJUST_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgAggregateParam(funExpr.parameters, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        } else if (MBGBGAVLBAL_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMbgBgAvlBalFormulaParam(funExpr.parameters, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgRefBgTemplateParam(funExpr.parameters, model, costCenterNumber, isReplacePeriodNVar);
        } else if ("MbgRefBgForm".equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgRefBgFormParam(funExpr.parameters, model, costCenterNumber);
        } else if (MBGACCT.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkAcctParam(funExpr, model, costCenterNumber);
        } else if (MBGELIMDATA.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkElimParam(funExpr);
        } else if (MBGADJUSTDATE_STR.equalsIgnoreCase(funcionName) || MBGACTUALDAY_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMbgAdjustDateParam(funExpr.parameters, itemCombine, model);
        } else if (MBGCORUNIT.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMbgCorUnitParam(funExpr.parameters, model, costCenterNumber, itemCombine, isReplacePeriodNVar);
        }
    }

    public static void checkMbgCorUnitParam(List parameter, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) {
        Object data;
        StringExpr param7;
        StringExpr param6;
        IBgSpecialInfo _bgFormInfo;
        if (parameter == null || parameter.size() != FormulaUtils.MBGAGGREGATE_PARAM_LENGTH) {
            return;
        }
        StringExpr dimItemNum = (StringExpr)parameter.get(5);
        if (AT_STR.equals(dimItemNum.value) && !StringUtils.isEmpty((String)itemCombine)) {
            dimItemNum.value = itemCombine;
        }
        if (model instanceof IBgSpecialInfo && BgSpecialBudgetHelper.checkIsSpecialBudget(_bgFormInfo = (IBgSpecialInfo)model)) {
            dimItemNum.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameter.get((int)2)).value, _bgFormInfo, dimItemNum.value);
        }
        StringExpr corUnitNumber = (StringExpr)parameter.get(4);
        String corSrcNumber = BgNExpressionHelper.querySrcNumber(corUnitNumber.value);
        if (!StringUtils.isEmpty((String)dimItemNum.value) && dimItemNum.value.contains(",")) {
            StringBuffer excludeCorAndCslItem = new StringBuffer();
            String[] expre = dimItemNum.value.split(",");
            for (int index = 0; index < expre.length; ++index) {
                if (!expre[index].contains(":")) continue;
                String[] itemStr = expre[index].split(":");
                if (StringUtils.isEmpty((String)corSrcNumber) || corSrcNumber.contains(itemStr[0]) || DimensionConstants.DEF_CSL_SRCNUMBER.contains(itemStr[0])) continue;
                excludeCorAndCslItem.append(expre[index]).append(",");
            }
            dimItemNum.value = excludeCorAndCslItem.length() > 0 ? excludeCorAndCslItem.delete(excludeCorAndCslItem.length() - 1, excludeCorAndCslItem.length()).toString() : "";
        } else if (dimItemNum.value.contains(":")) {
            String[] itemStr = dimItemNum.value.split(":");
            if (!StringUtils.isEmpty((String)corSrcNumber) && corSrcNumber.contains(itemStr[0]) || DimensionConstants.DEF_CSL_SRCNUMBER.contains(itemStr[0])) {
                dimItemNum.value = "";
            }
        }
        if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            param6 = (StringExpr)parameter.get(6);
            String bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param6.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            param7 = (StringExpr)parameter.get(7);
            bgPeriodNum = param7.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param7.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param7.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof IDimDataQuery) {
            data = (IDimDataQuery)model;
            param6 = (StringExpr)parameter.get(6);
            String bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBizPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBizPeriod().getNumber(), (String)param6.value, (int)data.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            param7 = (StringExpr)parameter.get(7);
            bgPeriodNum = param7.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBizPeriod() != null) {
                try {
                    param7.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBizPeriod().getNumber(), (String)param7.value, (int)data.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            data = (BgAnalysReportInfo)model;
            param6 = (StringExpr)parameter.get(6);
            String bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && ((AbstractBgAnalysReportInfo)data).getBgPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)((AbstractBgAnalysReportInfo)data).getBgPeriod().getNumber(), (String)param6.value, (int)((AbstractBgAnalysReportInfo)data).getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            param7 = (StringExpr)parameter.get(7);
            bgPeriodNum = param7.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && ((AbstractBgAnalysReportInfo)data).getBgPeriod() != null) {
                try {
                    param7.value = BgPeriodNVariableHelper.getBgPeriodByN((String)((AbstractBgAnalysReportInfo)data).getBgPeriod().getNumber(), (String)param7.value, (int)((AbstractBgAnalysReportInfo)data).getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
        if (!(model instanceof BgFormInfo) && !(model instanceof BgActualRecordInfo)) {
            StringExpr param0;
            if (model instanceof BgCslAdjFormInfo) {
                BgCslAdjFormInfo bgCslAdjFormInfo = (BgCslAdjFormInfo)model;
                param0 = (StringExpr)parameter.get(0);
                if (StringUtils.isEmpty((String)param0.value)) {
                    OrgTreeInfo orgTreeInfo = BgNExpressionHelper.getOrgTree(bgCslAdjFormInfo.getOrgTree());
                    param0.value = orgTreeInfo.getNumber() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(orgTreeInfo.getStartDate());
                }
                StringExpr param1 = (StringExpr)parameter.get(1);
                if (StringUtils.isEmpty((String)param1.value)) {
                    param1.value = bgCslAdjFormInfo.getOrgUnit().getNumber();
                }
            } else if (model instanceof BgCslFormInfo) {
                BgCslFormInfo bgCslInfo = (BgCslFormInfo)model;
                param0 = (StringExpr)parameter.get(0);
                if (StringUtils.isEmpty((String)param0.value)) {
                    OrgTreeInfo orgTreeInfo = BgNExpressionHelper.getOrgTree(bgCslInfo.getOrgTree());
                    param0.value = orgTreeInfo.getNumber() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(orgTreeInfo.getStartDate());
                }
                StringExpr param1 = (StringExpr)parameter.get(1);
                if (StringUtils.isEmpty((String)param1.value)) {
                    param1.value = bgCslInfo.getOrgUnit().getNumber();
                }
            } else if (model instanceof MbgWorkPaperInfo) {
                MbgWorkPaperInfo mbgWorkPaperInfo = (MbgWorkPaperInfo)model;
                param0 = (StringExpr)parameter.get(0);
                if (StringUtils.isEmpty((String)param0.value)) {
                    OrgTreeInfo orgTreeInfo = BgNExpressionHelper.getOrgTree(mbgWorkPaperInfo.getOrgTree());
                    param0.value = orgTreeInfo.getNumber() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(orgTreeInfo.getStartDate());
                }
                StringExpr param1 = (StringExpr)parameter.get(1);
                if (StringUtils.isEmpty((String)param1.value)) {
                    param1.value = mbgWorkPaperInfo.getOrgUnit().getNumber();
                }
            } else if (model instanceof BgCslElimInfo) {
                BgCslElimInfo bgCslElimInfo = (BgCslElimInfo)model;
                param0 = (StringExpr)parameter.get(0);
                if (StringUtils.isEmpty((String)param0.value)) {
                    OrgTreeInfo orgTreeInfo = BgNExpressionHelper.getOrgTree(bgCslElimInfo.getOrgTree());
                    param0.value = orgTreeInfo.getNumber() + "_" + new SimpleDateFormat("yyyy-MM-dd").format(orgTreeInfo.getStartDate());
                }
                StringExpr param1 = (StringExpr)parameter.get(1);
                if (StringUtils.isEmpty((String)param1.value)) {
                    param1.value = bgCslElimInfo.getOrgUnit().getNumber();
                }
            }
        }
    }

    private static OrgTreeInfo getOrgTree(OrgTreeInfo orgTreeInfo) {
        if (orgTreeInfo == null || orgTreeInfo.getId() == null) {
            return orgTreeInfo;
        }
        try {
            if (BgNExpressionHelper.getCtx() == null) {
                return OrgTreeFactory.getRemoteInstance().getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeInfo.getId()));
            }
            return OrgTreeFactory.getLocalInstance((Context)BgNExpressionHelper.getCtx()).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeInfo.getId()));
        }
        catch (BOSException e) {
            logger.error((Object)"getOrgTree", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"getOrgTree", (Throwable)e);
        }
        return orgTreeInfo;
    }

    private static String querySrcNumber(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        try {
            MbgDimInfo mbgDimInfo = BgNExpressionHelper.getMbgDim().getMbgDimInfo("select id, name, number, srcNumber Where number = '" + number + "'");
            if (mbgDimInfo != null) {
                return mbgDimInfo.getSrcNumber();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"querySrcNumber", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"querySrcNumber", (Throwable)e);
        }
        return null;
    }

    private static IMbgDim getMbgDim() throws BOSException {
        if (BgNExpressionHelper.getCtx() == null) {
            return MbgDimFactory.getRemoteInstance();
        }
        return MbgDimFactory.getLocalInstance((Context)BgNExpressionHelper.getCtx());
    }

    private static void checkMbgAdjustDateParam(List parameters, String itemCombine, IObjectValue model) {
        IBgSpecialInfo _bgFormInfo;
        StringExpr dimItemNum = (StringExpr)parameters.get(3);
        if (AT_STR.equals(dimItemNum.value) && !StringUtils.isEmpty((String)itemCombine)) {
            dimItemNum.value = itemCombine;
        }
        if (model instanceof IBgSpecialInfo && BgSpecialBudgetHelper.checkIsSpecialBudget(_bgFormInfo = (IBgSpecialInfo)model)) {
            dimItemNum.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameters.get((int)1)).value, _bgFormInfo, dimItemNum.value);
        }
    }

    private static void checkElimParam(FunctionExpr funExpr) throws Exception {
        if (bizCalcExpreUtils == null) {
            bizCalcExpreUtils = new BizCalcExpreUtils(BgNExpressionHelper.getCtx(), BgNExpressionHelper.getConn(), (IDimensionParameter)parameter);
            bizCalcExpreUtils.setCurrCompany(curOrgUnit);
        }
        BizCalcExpreUtils.ElimData elim = new BizCalcExpreUtils.ElimData(bizCalcExpreUtils);
        elim.builder(BgNExpressionHelper.getPeriodNums(), BgNExpressionHelper.getCurrencyNums(), funExpr);
    }

    public static Set<String> getPeriodNums() {
        return periodNums;
    }

    public static void setPeriodNums(Set<String> periodNums) {
        BgNExpressionHelper.periodNums = periodNums;
    }

    public static Set<String> getCurrencyNums() {
        return currencyNums;
    }

    public static void setCurrencyNums(Set<String> currencyNums) {
        BgNExpressionHelper.currencyNums = currencyNums;
    }

    public static boolean isByRowColCalc() {
        return isByRowColCalc;
    }

    public static void setByRowColCalc(boolean isByRowColCalc) {
        BgNExpressionHelper.isByRowColCalc = isByRowColCalc;
    }

    public static IMbgSheetBase getCurSheetManager() {
        return curSheetManager;
    }

    public static DimensionParameter getParameter() {
        return parameter;
    }

    public static void setParameter(DimensionParameter parameter) {
    }

    private static void checkAcctParam(FunctionExpr funExpr, IObjectValue model, String costCenterNumber) throws Exception {
        try {
            if (model instanceof IDimDataQuery && isByRowColCalc) {
                IDimDataQuery _bgFormInfo = (IDimDataQuery)model;
                StringExpr acctItem = null;
                if (funExpr != null && funExpr.parameters != null) {
                    acctItem = (StringExpr)funExpr.parameters.get(1);
                }
                HashSet<String> acctNums = new HashSet<String>();
                HashMap<String, String> dimNumMap = new HashMap<String, String>();
                BgDimensionMember curDimensionMember = null;
                int accountCount = 0;
                for (int i = 0; i < curMemberList.size(); ++i) {
                    curDimensionMember = curMemberList.get(i);
                    if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(curDimensionMember.getType())) {
                        dimNumMap.put(DimensionBaseConstants.DEF_ORGUNIT_FIELD, curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                        continue;
                    }
                    if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(curDimensionMember.getType())) {
                        dimNumMap.put(DimensionBaseConstants.DEF_CURRENCY_FIELD, DimensionBaseConstants.DEF_CURRENCY_SRCNUMBER + ":" + curDimensionMember.getNumber());
                        continue;
                    }
                    if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(curDimensionMember.getType())) {
                        dimNumMap.put(DimensionBaseConstants.DEF_VERSION_FIELD, curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                        continue;
                    }
                    if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(curDimensionMember.getType())) {
                        dimNumMap.put(DimensionBaseConstants.DEF_PERIOD_FIELD, curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                        continue;
                    }
                    if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(curDimensionMember.getType())) {
                        ++accountCount;
                        dimNumMap.put(curDimensionMember.getAttribute(), curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                        acctNums.add(curDimensionMember.getNumber());
                        continue;
                    }
                    if (DimensionBaseConstants.necessary.contains(curDimensionMember.getType())) {
                        dimNumMap.put(curDimensionMember.getAttribute(), curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                        continue;
                    }
                    dimNumMap.put(curDimensionMember.getAttribute(), curDimensionMember.getSrcNumber() + ":" + curDimensionMember.getNumber());
                }
                if (accountCount == 0 && acctItem != null && acctItem.value != null && acctItem.value.indexOf("|@") > -1) {
                    String[] split = acctItem.value.split("\\|");
                    acctNums.add(split[0]);
                }
                BizCalcExpreUtils.Acct acct = new BizCalcExpreUtils.Acct(bizCalcExpreUtils);
                acct.builder(null, acctNums, BgNExpressionHelper.getPeriodNums(), BgNExpressionHelper.getCurrencyNums(), dimNumMap, new HashMap(), null, funExpr, null);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static void dealParameter(IDimDataQuery _bgFormInfo) {
        if (parameter == null && _bgFormInfo != null) {
            parameter = new DimensionParameter();
            DataManagerImpl dataManagerImpl = new DataManagerImpl();
            dataManagerImpl.setBgScheme(_bgFormInfo.getBizBgScheme());
            parameter.setDataManager(dataManagerImpl);
            parameter.setBgSchemeId(_bgFormInfo.getBizBgScheme().getId());
        } else if (parameter != null && _bgFormInfo != null && parameter.getDataManager() != null && _bgFormInfo.getBizBgScheme() != null) {
            parameter.getDataManager().setBgScheme(_bgFormInfo.getBizBgScheme());
            parameter.setBgSchemeId(_bgFormInfo.getBizBgScheme().getId());
        }
        if (_bgFormInfo instanceof BgFormInfo) {
            parameter.setOrgUnitId(((BgFormInfo)_bgFormInfo).getOrgUnit().getId());
        } else if (_bgFormInfo instanceof BgActualRecordInfo) {
            parameter.setOrgUnitId(((BgActualRecordInfo)_bgFormInfo).getBgForm().getOrgUnit().getId());
        }
    }

    public static BizCalcExpreUtils getBizCalcExpreUtils() {
        return bizCalcExpreUtils;
    }

    public static void setBizCalcExpreUtils(BizCalcExpreUtils bizCalcExpreUtils) {
        BgNExpressionHelper.bizCalcExpreUtils = bizCalcExpreUtils;
    }

    public static BizCalcExpreUtils beaforeDealAcct() throws Exception {
        if (bizCalcExpreUtils == null) {
            bizCalcExpreUtils = new BizCalcExpreUtils(BgNExpressionHelper.getCtx(), BgNExpressionHelper.getConn(), (IDimensionParameter)parameter);
        }
        bizCalcExpreUtils.setCurrCompany(curOrgUnit);
        bizCalcExpreUtils.beforeCalc();
        return bizCalcExpreUtils;
    }

    public static void checkBgAggregateParam(List parameter, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) {
        if (parameter == null || parameter.size() != FormulaUtils.MBGAGGREGATE_PARAM_LENGTH) {
            return;
        }
        StringExpr dimItemNum = (StringExpr)parameter.get(3);
        if (AT_STR.equals(dimItemNum.value) && !StringUtils.isEmpty((String)itemCombine)) {
            dimItemNum.value = itemCombine;
        }
        if (model instanceof IBgSpecialInfo) {
            IBgSpecialInfo _bgFormInfo = (IBgSpecialInfo)model;
            if (BgSpecialBudgetHelper.checkIsSpecialBudget(_bgFormInfo)) {
                dimItemNum.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameter.get((int)1)).value, _bgFormInfo, dimItemNum.value);
            }
            if (model instanceof IDimDataQuery) {
                IDimDataQuery dimDataQuery = (IDimDataQuery)model;
                StringExpr param4 = (StringExpr)parameter.get(4);
                String bgPeriodNum = param4.value;
                if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && dimDataQuery.getBizPeriod() != null) {
                    try {
                        param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)dimDataQuery.getBizPeriod().getNumber(), (String)param4.value, (int)dimDataQuery.getBizPeriod().getPeriodType().getValue());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
                StringExpr param5 = (StringExpr)parameter.get(5);
                bgPeriodNum = param5.value;
                if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && dimDataQuery.getBizPeriod() != null) {
                    try {
                        param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)dimDataQuery.getBizPeriod().getNumber(), (String)param5.value, (int)dimDataQuery.getBizPeriod().getPeriodType().getValue());
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        } else if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param4.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof IDimDataQuery) {
            IDimDataQuery data = (IDimDataQuery)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBizPeriod() != null) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBizPeriod().getNumber(), (String)param4.value, (int)data.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBizPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBizPeriod().getNumber(), (String)param5.value, (int)data.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            BgAnalysReportInfo data = (BgAnalysReportInfo)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBgPeriod() != null) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBgPeriod().getNumber(), (String)param4.value, (int)data.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && data.getBgPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)data.getBgPeriod().getNumber(), (String)param5.value, (int)data.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkBgRefBgFormParam(List parameter, IObjectValue model, String costCenterNumber) {
        if (parameter == null || parameter.size() != FormulaUtils.MBGREFBGFORM_PARAM_LENGTH) {
            return;
        }
    }

    private static void checkBgRefBgTemplateParam(List parameter, IObjectValue model, String costCenterNumber, boolean isReplacePeriodNVar) {
        if (parameter == null || parameter.size() == FormulaUtils.MBGREFBGTEM_PARAM_LENGTH && parameter.size() == 10 && parameter.size() == 8) {
            return;
        }
        if (model instanceof IDimDataQuery) {
            IDimDataQuery _bgFormInfo = (IDimDataQuery)model;
            StringExpr param3 = (StringExpr)parameter.get(3);
            String bgPeriodNumber = param3.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNumber) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param3.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param3.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            BgAnalysReportInfo _bgFormInfo = (BgAnalysReportInfo)model;
            StringExpr param3 = (StringExpr)parameter.get(3);
            String bgPeriodNumber = param3.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNumber) && _bgFormInfo.getBgPeriod() != null) {
                try {
                    param3.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param3.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkMBgFormulaParam(List parameter, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) {
        if (parameter == null || parameter.size() <= 5) {
            return;
        }
        StringExpr param3 = (StringExpr)parameter.get(3);
        if (AT_STR.equals(param3.value) && !StringUtils.isEmpty((String)itemCombine)) {
            param3.value = itemCombine;
        }
        if (model instanceof IBgSpecialInfo) {
            IBgSpecialInfo _bgFormInfo = (IBgSpecialInfo)model;
            if (BgSpecialBudgetHelper.checkIsSpecialBudget(_bgFormInfo)) {
                param3.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameter.get((int)1)).value, _bgFormInfo, param3.value);
            }
        } else if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param4.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof IDimDataQuery) {
            IDimDataQuery _bgFormInfo = (IDimDataQuery)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param4.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            BgAnalysReportInfo _bgFormInfo = (BgAnalysReportInfo)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBgPeriod() != null) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param4.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBgPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkMBgCslParam(List parameter, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) {
        StringExpr param5;
        Object _bgFormInfo;
        if (parameter == null || parameter.size() <= 5) {
            return;
        }
        StringExpr param3 = (StringExpr)parameter.get(3);
        if (AT_STR.equals(param3.value) && !StringUtils.isEmpty((String)itemCombine)) {
            param3.value = itemCombine;
        }
        if (model instanceof IBgSpecialInfo && BgSpecialBudgetHelper.checkIsSpecialBudget((IBgSpecialInfo)(_bgFormInfo = (IBgSpecialInfo)model))) {
            ((StringExpr)parameter.get((int)4)).value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameter.get((int)2)).value, (IBgSpecialInfo)_bgFormInfo, ((StringExpr)parameter.get((int)4)).value);
            if (StringUtils.isEmpty((String)param3.value)) {
                param3.value = BgSpecialBudgetHelper.getBgCslExpressionBySpecialItem((IBgSpecialInfo)_bgFormInfo, param3.value, DimensionBaseConstants.DEF_SCENARIO_SRCNUMBER);
            }
            StringExpr param9 = (StringExpr)parameter.get(9);
            if (StringUtils.isEmpty((String)param9.value)) {
                param9.value = BgSpecialBudgetHelper.getBgCslExpressionBySpecialItem((IBgSpecialInfo)_bgFormInfo, param9.value, DimensionBaseConstants.DEF_ELEMENT_SRCNUMBER);
            }
        }
        if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            StringExpr param4 = (StringExpr)parameter.get(4);
            String bgPeriodNum = param4.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param4.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param4.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param52 = (StringExpr)parameter.get(5);
            bgPeriodNum = param52.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param52.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param52.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof IDimDataQuery) {
            _bgFormInfo = (IDimDataQuery)model;
            param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            _bgFormInfo = (BgAnalysReportInfo)model;
            param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && ((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod() != null) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod().getNumber(), (String)param5.value, (int)((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && ((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod().getNumber(), (String)param6.value, (int)((AbstractBgAnalysReportInfo)_bgFormInfo).getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    private static void checkMbgBgAvlBalFormulaParam(List parameter, IObjectValue model, String costCenterNumber, String itemCombine, boolean isReplacePeriodNVar) {
        if (parameter == null || parameter.size() != 9) {
            return;
        }
        StringExpr dimItemNum = (StringExpr)parameter.get(4);
        if (AT_STR.equals(dimItemNum.value) && !StringUtils.isEmpty((String)itemCombine)) {
            dimItemNum.value = itemCombine;
        }
        if (model instanceof BgFormInfo) {
            BgFormInfo _bgFormInfo = (BgFormInfo)model;
            if (BgSpecialBudgetHelper.checkIsSpecialBudget(_bgFormInfo)) {
                dimItemNum.value = BgSpecialBudgetHelper.getBgExpressionBySpecialItem(((StringExpr)parameter.get((int)1)).value, _bgFormInfo, dimItemNum.value);
            }
            StringExpr param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBgPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgActualRecordInfo) {
            BgActualRecordInfo _bgActualInfo = (BgActualRecordInfo)model;
            StringExpr param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param5.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgActualInfo.getBgForm().getBgPeriod().getNumber(), (String)param6.value, (int)_bgActualInfo.getBgForm().getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof IDimDataQuery) {
            IDimDataQuery _bgFormInfo = (IDimDataQuery)model;
            StringExpr param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBizPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBizPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBizPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        } else if (model instanceof BgAnalysReportInfo) {
            BgAnalysReportInfo _bgFormInfo = (BgAnalysReportInfo)model;
            StringExpr param5 = (StringExpr)parameter.get(5);
            String bgPeriodNum = param5.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum)) {
                try {
                    param5.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param5.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            StringExpr param6 = (StringExpr)parameter.get(6);
            bgPeriodNum = param6.value;
            if (isReplacePeriodNVar && !StringUtils.isEmpty((String)bgPeriodNum) && _bgFormInfo.getBgPeriod() != null) {
                try {
                    param6.value = BgPeriodNVariableHelper.getBgPeriodByN((String)_bgFormInfo.getBgPeriod().getNumber(), (String)param6.value, (int)_bgFormInfo.getBgPeriod().getPeriodType().getValue());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    public static void getExpressionParam(String expressions, final BgPeriodInfo periodInfo, final Map param) {
        if (!StringUtils.isEmpty((String)expressions)) {
            Expression expression = null;
            try {
                expression = ExcelFormulaPaserHelper.parse((String)expressions);
                expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                    public Expression handle(Expression expr) {
                        return BgNExpressionHelper.checkExpression(expr, periodInfo, param);
                    }
                });
            }
            catch (Exception ex) {
                logger.error((Object)expressions);
                logger.error((Object)ex);
            }
        }
    }

    private static Expression checkExpression(Expression expression, BgPeriodInfo periodInfo, Map params) {
        if (expression instanceof FunctionExpr) {
            expression = BgNExpressionHelper.checkFunctionExpr((FunctionExpr)expression, periodInfo, params);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgNExpressionHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, periodInfo, params);
        } else if (expression instanceof UnaryOperationExpr) {
            expression = BgNExpressionHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, periodInfo, params);
        }
        return expression;
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, BgPeriodInfo periodInfo, Map params) {
        boExpr.left = BgNExpressionHelper.checkExpression(boExpr.left, periodInfo, params);
        boExpr.right = BgNExpressionHelper.checkExpression(boExpr.right, periodInfo, params);
        return boExpr;
    }

    private static UnaryOperationExpr checkUnaryOperationExpr(UnaryOperationExpr boExpr, BgPeriodInfo periodInfo, Map params) {
        return boExpr;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, BgPeriodInfo periodInfo, Map params) {
        String funcionName = funExpr.funcionName;
        FormulaUtils.updateParams(funExpr);
        try {
            if (MBGFORMULA_STR.equalsIgnoreCase(funcionName)) {
                FunctionExpr _expression = funExpr;
                if (_expression instanceof FunctionExpr) {
                    BgNExpressionHelper.checkExpressionParam(_expression, periodInfo, params);
                }
                return _expression;
            }
            BgNExpressionHelper.checkExpressionParam(funExpr, periodInfo, params);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, BgPeriodInfo periodInfo, Map params) {
        String funcionName = funExpr.funcionName;
        if (MBGFORMULA_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkBgFormulaParam(funExpr.toString(), periodInfo, funExpr.parameters, params);
        } else if (MBGAGGREGATE_STR.equalsIgnoreCase(funcionName) || MBGADJUST_STR.equalsIgnoreCase(funcionName)) {
            BgNExpressionHelper.checkMbgAggregateParam(funExpr.toString(), periodInfo, funExpr.parameters, params);
        }
    }

    private static void checkMbgAggregateParam(String expr, BgPeriodInfo periodInfo, List parameter, Map params) {
        if (parameter == null || parameter.size() != FormulaUtils.MBGAGGREGATE_PARAM_LENGTH) {
            return;
        }
        Object[] item = new Object[FormulaUtils.MBGAGGREGATE_PARAM_LENGTH];
        item[0] = ((StringExpr)parameter.get((int)0)).value;
        item[1] = ((StringExpr)parameter.get((int)1)).value;
        item[2] = ((StringExpr)parameter.get((int)2)).value;
        item[3] = ((StringExpr)parameter.get((int)3)).value;
        item[4] = ((StringExpr)parameter.get((int)4)).value;
        if (item[4] != null && BgNExpressionHelper.isInteger((String)item[4])) {
            item[4] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression((String)periodInfo.getNumber(), (int)Integer.parseInt((String)item[4]));
        }
        item[5] = ((StringExpr)parameter.get((int)5)).value;
        if (item[5] != null && BgNExpressionHelper.isInteger((String)item[5])) {
            item[5] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression((String)periodInfo.getNumber(), (int)Integer.parseInt((String)item[5]));
        }
        item[6] = ((StringExpr)parameter.get((int)6)).value;
        item[7] = ((StringExpr)parameter.get((int)7)).value;
        item[8] = ((StringExpr)parameter.get((int)8)).value;
        item[9] = ((StringExpr)parameter.get((int)9)).value;
        item[10] = ((StringExpr)parameter.get((int)10)).value;
        item[11] = ((StringExpr)parameter.get((int)11)).value;
        params.put(expr, item);
    }

    private static void checkBgFormulaParam(String expr, BgPeriodInfo periodInfo, List parameter, Map params) {
        if (parameter == null || parameter.size() != FormulaUtils.MBGFORMULA_PARAM_LENGTH) {
            return;
        }
        Object[] item = new Object[9];
        item[0] = ((StringExpr)parameter.get((int)0)).value;
        item[1] = ((StringExpr)parameter.get((int)1)).value;
        item[2] = ((StringExpr)parameter.get((int)2)).value;
        item[3] = ((StringExpr)parameter.get((int)3)).value;
        if (item[3] != null && BgNExpressionHelper.isInteger((String)item[3])) {
            item[3] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression((String)periodInfo.getNumber(), (int)Integer.parseInt((String)item[3]));
        }
        item[4] = ((StringExpr)parameter.get((int)4)).value;
        if (item[4] != null && BgNExpressionHelper.isInteger((String)item[4])) {
            item[4] = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression((String)periodInfo.getNumber(), (int)Integer.parseInt((String)item[4]));
        }
        item[5] = ((StringExpr)parameter.get((int)5)).value;
        item[6] = ((StringExpr)parameter.get((int)6)).value;
        item[7] = ((StringExpr)parameter.get((int)7)).value;
        item[8] = ((StringExpr)parameter.get((int)8)).value;
        params.put(expr, item);
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void checkAcctParam(List parameter, IObjectValue model, Map cacheMap) {
        block33: {
            CostCenterOrgUnitInfo costInfo;
            String accountItem;
            StringExpr param1;
            Context ctx;
            OrgUnitInfo info;
            block32: {
                if (parameter == null || parameter.size() < 8 || parameter.size() > 9) {
                    return;
                }
                Map<BOSUuid, OrgUnitInfo> comapnyCache = null;
                if (cacheMap != null && cacheMap.containsKey("ORGUNIT_COMPANY")) {
                    comapnyCache = (Map)cacheMap.get("ORGUNIT_COMPANY");
                } else {
                    comapnyCache = new HashMap();
                    if (cacheMap != null) {
                        cacheMap.put("ORGUNIT_COMPANY", comapnyCache);
                    }
                }
                OrgUnitInfo orginfo = null;
                info = null;
                if (model.get("orgUnit") instanceof OrgUnitInfo) {
                    orginfo = (OrgUnitInfo)model.get("orgUnit");
                }
                if (orginfo == null) {
                    if (model instanceof BgActualRecordInfo) {
                        BgActualRecordInfo actualInfo = (BgActualRecordInfo)model;
                        orginfo = actualInfo.getBgForm().getOrgUnit();
                        if (orginfo == null) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                if (!(parameter.get(0) instanceof StringExpr)) {
                    return;
                }
                ctx = ConfigMDUtil.isClient() ? null : ConfigMDUtil.getContext();
                try {
                    orginfo = ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId())) : FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (comapnyCache.containsKey(orginfo.getId())) {
                    info = (OrgUnitInfo)comapnyCache.get(orginfo.getId());
                } else {
                    info = BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(ctx, orginfo);
                    comapnyCache.put(orginfo.getId(), info);
                }
                StringExpr param0 = (StringExpr)parameter.get(0);
                String orgNumber = param0.value;
                if (StringUtils.isEmpty((String)orgNumber)) {
                    param0.value = info.getNumber();
                }
                if (!(parameter.get(1) instanceof StringExpr)) {
                    return;
                }
                param1 = (StringExpr)parameter.get(1);
                accountItem = param1.value;
                costInfo = null;
                try {
                    if (orginfo.isIsCostOrgUnit()) {
                        costInfo = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId())) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orginfo.getId()));
                        break block32;
                    }
                    return;
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
            String[] itemType = accountItem.split("\\|");
            if (info == null) {
                return;
            }
            String companyID = info.getId().toString();
            if (itemType.length != 1) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FASSTHGATTRIBUTE,fnumber from T_BD_AsstActType where fid in ");
                sql.append("(select FAsstActTypeID from T_BD_AsstActGroupDetail where fAsstAccountID=");
                sql.append("(select FCAA from T_BD_AccountView where FCompanyID= '" + companyID + "'  and fnumber in ");
                String[] items = itemType[0].split(":");
                sql.append("(");
                for (int n = 0; n < items.length; ++n) {
                    sql.append("'").append(items[n]).append("'");
                    sql.append(",");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                sql.append("))");
                try {
                    IBgNFormFacade ibnf = null;
                    ibnf = ctx == null ? BgNFormFacadeFactory.getRemoteInstance() : BgNFormFacadeFactory.getLocalInstance(ctx);
                    List costCenterOrgNumber = ibnf.getAccountBizCostCenterNumber(sql.toString());
                    if (costCenterOrgNumber == null || costCenterOrgNumber.isEmpty()) break block33;
                    String type = null;
                    String number = null;
                    String[] array = null;
                    boolean findOrg = false;
                    for (int i = 0; i < costCenterOrgNumber.size(); ++i) {
                        array = (String[])costCenterOrgNumber.get(i);
                        type = array[0];
                        number = array[1];
                        if (!"costOrg".equalsIgnoreCase(type)) continue;
                        int len = itemType.length;
                        String[] newItemType = new String[len + 1];
                        for (int k = 0; k < itemType.length; ++k) {
                            newItemType[k] = itemType[k];
                            if (!itemType[k].equals(number)) continue;
                            findOrg = true;
                            if (k == itemType.length - 1) {
                                newItemType[k + 1] = costInfo.getNumber();
                                continue;
                            }
                            if (!"".equals(itemType[k + 1])) continue;
                            newItemType[k + 1] = costInfo.getNumber();
                            ++k;
                        }
                        param1.value = "";
                        param1.value = !findOrg ? param1.value + newItemType[0] + "|" + number + "|" + costInfo.getNumber() : param1.value + newItemType[0];
                        for (int m = 1; m < newItemType.length; ++m) {
                            if (newItemType[m] == null) continue;
                            if (m == 1) {
                                param1.value = param1.value + "|";
                            }
                            param1.value = m == newItemType.length - 1 || m == newItemType.length - 2 && newItemType[m + 1] == null ? param1.value + newItemType[m] : param1.value + newItemType[m] + "|";
                        }
                        break;
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public static OrgUnitInfo getCompanyOrgUnitByBgOrgUnit(Context ctx, OrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            return orgInfo;
        }
        if (orgInfo.isIsCompanyOrgUnit()) {
            return orgInfo;
        }
        if (orgInfo.isIsCostOrgUnit()) {
            try {
                CostCenterOrgUnitInfo costInfo = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId())) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
                CostCenterOrgUnitInfo parentInfo = costInfo.getParent();
                if (parentInfo == null) {
                    return costInfo;
                }
                parentInfo = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId())) : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()));
                return BgNExpressionHelper.getCompanyOrgUnitByBgOrgUnit(ctx, (OrgUnitInfo)parentInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return orgInfo;
    }

    public static void dealAcctExpressionAtAddNew(Context ctx, Book book, IObjectValue model, int viewMode, boolean isCsl) throws Exception {
        if (book == null) {
            return;
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet sheet = null;
        Cell cell = null;
        Object exp = null;
        Object tmpExp = null;
        HashMap cacheMap = new HashMap();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    BgNExpressionHelper.dealAcctExpressionAtAddNew(ctx, model, cell, cacheMap, isCsl);
                }
            }
        }
    }

    public static void dealAcctExpressionAtAddNew(Context ctx, Book book, IObjectValue model, int viewMode) throws Exception {
        if (book == null) {
            return;
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet sheet = null;
        Cell cell = null;
        Object exp = null;
        Object tmpExp = null;
        HashMap cacheMap = new HashMap();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRow = sheet.getMaxRowIndex() + 1;
            int maxCol = sheet.getMaxColIndex() + 1;
            for (int rowIndex = 0; rowIndex < maxRow; ++rowIndex) {
                for (int colIndex = 0; colIndex < maxCol; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    BgNExpressionHelper.dealAcctExpressionAtAddNew(ctx, model, cell, cacheMap, false);
                }
            }
        }
    }

    public static void dealAcctExpressionAtAddNew(final Context ctx, final IObjectValue model, Cell cell, Map cacheMap, final boolean isCsl) throws Exception {
        if (BgNFSHelper.checkHasExpression(cell)) {
            String exp = BgNFSHelper.getExpression(cell);
            if (StringUtils.isEmpty((String)exp)) {
                return;
            }
            if (exp.toUpperCase().indexOf(MBGACCT) >= 0) {
                Expression expression = null;
                try {
                    expression = ExcelFormulaPaserHelper.parse((String)exp);
                    expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                        public Expression handle(Expression expr) {
                            try {
                                return BgExpressionHelper.checkExpression(ctx, expr, model, isCsl);
                            }
                            catch (Exception exception) {
                                return expr;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)e.getCause());
                }
                if (expression != null) {
                    String expressionStr = BgExcelFormulaPaserHelper.toReducedBracketsString(expression);
                    String tmpExp = "=" + expressionStr;
                    if (tmpExp != null && !tmpExp.equalsIgnoreCase(exp)) {
                        BgNFSHelper.setExpression(cell, tmpExp);
                    }
                }
            }
        }
    }

    public static void resetFunctionName(FunctionExpr funExpr) {
    }

    public static List<FunctionExpr> getFuncionExpress(Book book, String filterFunction) throws Exception {
        String express = null;
        if (book != null && book.getActiveSheet() != null && book.getActiveSheet().getActiveCellRange() != null && !book.getActiveSheet().getActiveCellRange().isEmpty()) {
            express = book.getActiveSheet().getActiveCellRange().getFormula();
        }
        return BgNExpressionHelper.getFuncionExpress(express, filterFunction);
    }

    public static List<FunctionExpr> getFuncionExpress(String express, String filterFunction) throws Exception {
        ArrayList<FunctionExpr> expressList = new ArrayList<FunctionExpr>();
        if (!StringUtils.isEmpty((String)express)) {
            Expression expression = ExcelFormulaPaserHelper.parse((String)express);
            BgNExpressionHelper.addExpress(expression, filterFunction, expressList);
        }
        return expressList;
    }

    private static void addExpress(Expression expression, String filterFunction, List<FunctionExpr> expressList) {
        if (expression instanceof FunctionExpr) {
            BgNExpressionHelper.addFunctionExpr((FunctionExpr)expression, filterFunction, expressList);
        } else if (expression instanceof BinaryOperationExpr) {
            BgNExpressionHelper.addBinaryOperationExpr((BinaryOperationExpr)expression, filterFunction, expressList);
        } else if (expression instanceof UnaryOperationExpr) {
            // empty if block
        }
    }

    private static void addBinaryOperationExpr(BinaryOperationExpr expression, String filterFunction, List<FunctionExpr> expressList) {
        BgNExpressionHelper.addExpress(expression.left, filterFunction, expressList);
        BgNExpressionHelper.addExpress(expression.right, filterFunction, expressList);
    }

    private static void addFunctionExpr(FunctionExpr expression, String filterFunction, List<FunctionExpr> expressList) {
        String[] orgNumbers;
        String orgParam;
        if (!StringUtils.isEmpty((String)filterFunction) && !filterFunction.equalsIgnoreCase(expression.funcionName)) {
            return;
        }
        if (expression.parameters.get(0) instanceof StringExpr && !StringUtils.isEmpty((String)(orgParam = ((StringExpr)expression.parameters.get((int)0)).value)) && (orgNumbers = orgParam.split(";")).length > 1) {
            for (String org : orgNumbers) {
                FunctionExpr _expression = new FunctionExpr(expression.funcionName);
                _expression.parameters.addAll(expression.parameters);
                _expression.parameters.set(0, new StringExpr(org.trim()));
                expressList.add(_expression);
            }
            return;
        }
        expressList.add(expression);
    }

    public static String getStringValue(Object exprParam) {
        if (exprParam instanceof String) {
            return (String)exprParam;
        }
        if (exprParam instanceof StringExpr) {
            return ((StringExpr)exprParam).value;
        }
        return StringUtils.cnulls((Object)exprParam);
    }

    public static String handleRefExpression(String express, Book book) throws Exception {
        if (!StringUtils.isEmpty((String)express)) {
            Expression expression = ExcelFormulaPaserHelper.parse((String)express);
            expression = (Expression)BgNExpressionHelper.handle(expression, book);
            return '=' + ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression);
        }
        return express;
    }

    private static Object handle(Object expression, Book book) {
        if (expression instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expression;
            for (int i = 0; i < functionExpr.parameters.size(); ++i) {
                functionExpr.parameters.set(i, BgNExpressionHelper.handle(functionExpr.parameters.get(i), book));
            }
        } else if (expression instanceof BinaryOperationExpr) {
            BinaryOperationExpr binaryExpr = (BinaryOperationExpr)expression;
            binaryExpr.left = (Expression)BgNExpressionHelper.handle(binaryExpr.left, book);
            binaryExpr.right = (Expression)BgNExpressionHelper.handle(binaryExpr.right, book);
            if ((binaryExpr.operationType == 7 || binaryExpr.operationType == 9) && (binaryExpr.left instanceof StringExpr || binaryExpr.right instanceof StringExpr)) {
                CustomerFormat format = new CustomerFormat();
                expression = new StringExpr(format.getString(binaryExpr.left) + format.getString(binaryExpr.right));
            }
        } else if (expression instanceof UnaryOperationExpr) {
            UnaryOperationExpr unaryExpr = (UnaryOperationExpr)expression;
            unaryExpr.operand = (Expression)BgNExpressionHelper.handle(unaryExpr.operand, book);
        } else {
            if (expression instanceof Ref3DExpr) {
                String sheetName = ((Ref3DExpr)expression).sheetName;
                Sheet otherSheet = book.getSheet(sheetName);
                if (otherSheet == null) {
                    logger.error((Object)("error sheetName:" + sheetName));
                    return expression;
                }
                ReferenceExpr ref = ((Ref3DExpr)expression).ref;
                Cell cell = otherSheet.getCell(ref.row, ref.col, false);
                return BgNExpressionHelper.handleReferenceExpr(ref, cell);
            }
            if (expression instanceof ReferenceExpr) {
                Cell cell = book.getActiveSheet().getCell(((ReferenceExpr)expression).row, ((ReferenceExpr)expression).col, true);
                return BgNExpressionHelper.handleReferenceExpr((ReferenceExpr)expression, cell);
            }
        }
        return expression;
    }

    private static Object handleReferenceExpr(ReferenceExpr ref, Cell cell) {
        Expression retExpr = new HandleWhenNoValueFormula().exec(cell);
        if (retExpr != null) {
            return retExpr;
        }
        return ref;
    }

    public static boolean checkExpressionAcct(Context ctx, Expression expression, OrgUnitInfo curOrgUnit, List<BgDimensionMember> memberList) throws Exception {
        if (expression instanceof FunctionExpr) {
            return BgNExpressionHelper.checkFunctionExprAcct(ctx, (FunctionExpr)expression, curOrgUnit, memberList);
        }
        if (expression instanceof BinaryOperationExpr) {
            return BgNExpressionHelper.checkBinaryOperationExprAcct(ctx, (BinaryOperationExpr)expression, curOrgUnit, memberList);
        }
        if (expression instanceof UnaryOperationExpr) {
            return BgNExpressionHelper.checkUnaryOperationExprAcct((UnaryOperationExpr)expression, curOrgUnit, memberList);
        }
        return false;
    }

    public static boolean checkExpressionAcct(Expression expression, List<BgDimensionMember> memberList) throws Exception {
        return BgNExpressionHelper.checkExpressionAcct(null, expression, null, memberList);
    }

    public static Map<String, MbgDimInfo> queryDimensionSources(Context ctx, Map<String, List<IFormula>> batchKeyMap) throws BOSException {
        HashSet dimSrcNumbers = new HashSet();
        HashMap<String, MbgDimInfo> sources = new HashMap<String, MbgDimInfo>();
        Map<String, MbgDimInfo> tmpSources = null;
        String tmpKey = null;
        Iterator<String> it = batchKeyMap.keySet().iterator();
        while (it.hasNext()) {
            String srcNumbers = BgAdjustDateInfo.getSrcNumbers((String)it.next());
            if (srcNumbers == null) continue;
            dimSrcNumbers.addAll(Arrays.asList((Object[])srcNumbers.split(",")));
        }
        if (!dimSrcNumbers.isEmpty()) {
            tmpSources = DimUtils.getDimInfoMap(ctx);
            it = dimSrcNumbers.iterator();
            while (it.hasNext()) {
                tmpKey = it.next().toString();
                if (!tmpSources.containsKey(tmpKey)) continue;
                sources.put(tmpKey, tmpSources.get(tmpKey));
            }
        }
        return sources;
    }

    public static Map<String, BgSchemeInfo> queryBgSchemeInfo(IBgCalculator calculator) throws BOSException {
        HashMap<String, BgSchemeInfo> bgSchemeMap = new HashMap<String, BgSchemeInfo>();
        HashSet<String> bgSchemeIds = new HashSet<String>();
        Iterator it = calculator.getCacheManager().getBatchKeyMap().keySet().iterator();
        while (it.hasNext()) {
            bgSchemeIds.add(((String[])calculator.getCacheManager().getBgSchemeNumberMap().get(BgAdjustDateInfo.getSchemeMapKey((String)((String)it.next()))))[0]);
        }
        if (bgSchemeIds.isEmpty()) {
            return bgSchemeMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgSchemeIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("name");
        evi.getSelector().add("number");
        evi.getSelector().add("refCube");
        evi.getSelector().add("periodType");
        evi.getSelector().add("bgDimSettings");
        evi.getSelector().add("bgDimSettings.dimnumber");
        evi.getSelector().add("bgDimSettings.members.type");
        evi.getSelector().add("bgDimSettings.members.memberID");
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(calculator.getContext()).getBgSchemeCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                bgSchemeMap.put(col.get(i).getId().toString(), col.get(i));
            }
        }
        return bgSchemeMap;
    }

    public static Map<String, BgOrgUnitInfo> queryOrgUnit(IBgCalculator calculator, BgSchemeInfo schemeInfo) throws BOSException {
        HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        if (schemeInfo == null || schemeInfo.getEditOrgViewId() == null) {
            return orgUnitMap;
        }
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < calculator.getFormula().size(); ++i) {
            FormulaInfo info = (FormulaInfo)calculator.getFormula().get(i);
            if (!info.isCalculate() || !info.getBgSchemeNumber().equals(schemeInfo.getNumber())) continue;
            numbers.add(info.getOrgUnitNumber());
        }
        if (!numbers.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)schemeInfo.getEditOrgViewId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("name");
            sic.add("number");
            sic.add("longNumber");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(calculator.getContext()).getBgOrgUnitCollection(view);
            if (colls != null && !colls.isEmpty()) {
                for (int i = 0; i < colls.size(); ++i) {
                    orgUnitMap.put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        return orgUnitMap;
    }

    private static boolean checkFunctionExprAcct(Context ctx, FunctionExpr expression, OrgUnitInfo curOrgUnit, List<BgDimensionMember> memberList) throws Exception {
        String functionName = expression.funcionName;
        if (MBGACCT.equalsIgnoreCase(functionName)) {
            if (memberList != null) {
                if (expression == null || expression.parameters == null || memberList.isEmpty()) {
                    return false;
                }
                StringExpr acctItem = (StringExpr)expression.parameters.get(1);
                BgDimensionMember bgDimensionMember = null;
                String[] split = null;
                if (acctItem != null && !StringUtils.isEmpty((String)acctItem.value)) {
                    split = acctItem.value.split("\\|");
                    int memberCount = 0;
                    int accCount = 0;
                    for (int i = 0; i < memberList.size(); ++i) {
                        bgDimensionMember = memberList.get(i);
                        if (!DimensionBaseConstants.necessary.contains(bgDimensionMember.getType())) {
                            ++memberCount;
                            continue;
                        }
                        if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(bgDimensionMember.getType())) continue;
                        ++accCount;
                    }
                    if ("@|@".equals(acctItem.value) && accCount * memberCount < 1 || acctItem.value.startsWith("@|") && !AT_STR.equals(split[1]) && accCount > 1 || acctItem.value.endsWith("|@") && !split[0].equals(AT_STR) && memberCount < 1 || acctItem.value.equals(AT_STR) && accCount > 1) {
                        return false;
                    }
                }
                return true;
            }
            BgNExpressionHelper.curOrgUnit = curOrgUnit;
            BgNExpressionHelper.beaforeDealAcct();
            return true;
        }
        return false;
    }

    private static boolean checkBinaryOperationExprAcct(Context ctx, BinaryOperationExpr boExpr, OrgUnitInfo curOrgUnit, List<BgDimensionMember> memberList) throws Exception {
        return BgNExpressionHelper.checkExpressionAcct(ctx, boExpr.left, curOrgUnit, memberList) || BgNExpressionHelper.checkExpressionAcct(ctx, boExpr.right, curOrgUnit, memberList);
    }

    private static boolean checkUnaryOperationExprAcct(UnaryOperationExpr boExpr, OrgUnitInfo curOrgUnit, List<BgDimensionMember> memberList) {
        return false;
    }

    public static String checkExpression(final Context ctx, String expressions, final IObjectValue model, final String costCenterNumber, final boolean isReplacePeriodNVar, final boolean isCsl) {
        if (StringUtils.isEmpty((String)expressions)) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (BgNExpressionHelper.checkHasFunctionExpr(expression)) {
                if (expression instanceof Ref3DExpr) {
                    return expressions;
                }
            } else {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNExpressionHelper.checkExpression(ctx, expr, model, costCenterNumber, null, isReplacePeriodNVar, isCsl);
                }
            });
            _expressions = '=' + ExcelFormulaPaserHelper.toReducedBracketsString((Expression)expression);
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    static {
        parameter = null;
        bizCalcExpreUtils = null;
    }
}

