/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgMeasureUnitCollection;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.utils.BudgetProvider;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.StyleAttributes;
import com.kingdee.eas.ma.mbg.common.ViewListTitleRenderBase;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgTreeHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public final class BgNFSHelper {
    private static final Logger logger = Logger.getLogger(BgNFSHelper.class);
    public static final boolean trans4TO6 = true;
    public static final int paraItem = 0;
    public static final int paraPeriod = 1;
    public static final int paraElement = 2;
    public static final int paraScenario = 3;
    public static final int paraCurrency = 4;
    public static final int paraOldItem = 0;
    public static final int paraOldPeriod = 1;
    public static final int paraOldElement = 2;
    public static final int paraOldScenario = 3;
    public static final int paraOldCollect = 4;
    public static final int paraOldCurrency = 5;
    public static final int BUDGET_VIEW = 0;
    public static final int ACTUAL_VIEW = 1;
    public static final int ADD_VIEW = 2;
    public static final String SHEET_CREATER_ID = "SHEET_CREATER_ID";
    public static long totalTime = 0L;
    public static String INCREMENT_SET = "INCREMENT_SET";
    public static String DECREMENT_SET = "DECREMENT_SET";
    public static final String NF_THOUSAND_FORMAT = "0\".\"000 \"(\u5343\u5143)\"";
    public static final String NF_THOUSAND_FORMAT_F = "0\".\"000";
    public static final String NF_TENTHOUSAND_FORMAT = "0\".\"0,\"(\u4e07\u5143)\"";
    public static final String NF_TENTHOUSAND_FORMAT_F = "0\".\"0,";

    public static SelectorItemCollection getSelectors() {
        return BgNFSHelper.getSelectors(true);
    }

    public static SelectorItemCollection getSelectors(boolean hasSheetParam) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("auditor.id");
        sic.add("auditor.name");
        sic.add("state");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("processType");
        sic.add("description");
        sic.add("versionNo");
        sic.add("sourceType");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("orgUnit.simplename");
        sic.add("orgUnit.isCompanyOrgUnit");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("bgVersion.isRollVersion");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.refCube");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("bgScheme.bgSchemeType.schemeType");
        sic.add("bgScheme.orgUnit.id");
        sic.add("bgScheme.isEnableAnalyse");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.readonly");
        sic.add("bgTemplate.isTransferQingAnalyse");
        sic.add("bgTemplate.bgScenario.id");
        sic.add("bgTemplate.bgScenario.number");
        sic.add("bgTemplate.bgScenario.name");
        sic.add("bgTemplate.templateStatus");
        sic.add("bgTemplate.bgRollRule.*");
        sic.add("templateLastUpdateTime");
        sic.add("templateData");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.longnumber");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("bgRollPeriod.id");
        sic.add("bgRollPeriod.name");
        sic.add("bgRollPeriod.number");
        sic.add("bgRollRule.*");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        if (hasSheetParam) {
            sic.add("postils.*");
            sic.add("postils.report.id");
            sic.add("postils.sheet.id");
            sic.add("postils.sheet.sheetID");
            sic.add("postils.creator.id");
            sic.add("postils.creator.name");
            sic.add("sheetParam.id");
            sic.add("sheetParam.sheetName");
            sic.add("sheetParam.startYear");
            sic.add("sheetParam.endYear");
            sic.add("sheetParam.startPeriod");
            sic.add("sheetParam.endPeriod");
            sic.add("sheetParam.startDate");
            sic.add("sheetParam.endDate");
            sic.add("sheetParam.isIncludingUnposted");
            sic.add("sheetParam.relaType");
            sic.add("sheetParam.sheetID");
            sic.add("sheetParam.reportClass");
            sic.add("sheetParam.cslSheetManner");
            sic.add("sheetParam.orgRela.id");
            sic.add("sheetParam.orgRela.orgType");
            sic.add("sheetParam.orgRela.orgUnit.id");
            sic.add("sheetParam.orgRela.orgUnit.type");
            sic.add("sheetParam.orgRela.orgUnit.name");
            sic.add("sheetParam.currency.id");
            sic.add("sheetParam.currency.number");
            sic.add("sheetParam.currency.name");
            sic.add("sheetParam.currency.precision");
        }
        sic.add("adjust.id");
        sic.add("adjust.versionNo");
        sic.add("adjustMapData");
        sic.add("auditTime");
        sic.add("courseOrgId");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("entries.rollStep");
        sic.add("entries.schemes.id");
        sic.add("entries.schemes.seq");
        sic.add("entries.schemes.bgFormState");
        sic.add("entries.schemes.scheme.id");
        sic.add("entries.schemes.level");
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.hide");
        sic.add("bgSpecialItems.dimensionAlias");
        sic.add("bgSpecialItems.dimRelaGroupRef.*");
        sic.add("bgSpecialItems.dimRelaGroupRef.dimRelaGroup.*");
        return sic;
    }

    public static SelectorItemCollection getFormBaseSelectors(boolean hasData) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        if (hasData) {
            sic.add("data");
        }
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.refCube");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.bgScheme.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("bgVersion.isRollVersion");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("state");
        sic.add("processType");
        return sic;
    }

    public static SelectorItemCollection getViewBaseSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getFormBaseSelectors(false);
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        return sic;
    }

    public static SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("canModify");
        sic.add("templateStatus");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("rootId");
        sic.add("formType");
        sic.add("description");
        return sic;
    }

    public static boolean isNumerical(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            return false;
        }
        boolean re = false;
        try {
            new BigDecimal(value.toString().trim().replaceAll(",", ""));
            re = true;
        }
        catch (Exception ex) {
            re = false;
        }
        return re;
    }

    public static boolean isPercentageNumerical(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            return false;
        }
        boolean re = false;
        try {
            if (value.toString().indexOf("%") > 0) {
                new BigDecimal(value.toString().trim().replaceAll("%", ""));
                re = true;
            }
        }
        catch (Exception ex) {
            re = false;
        }
        return re;
    }

    public static Integer getNumeric(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return 0;
        }
        Integer value = null;
        try {
            value = new Integer(str);
        }
        catch (Exception ex) {
            value = new Integer(0);
        }
        return value;
    }

    public static boolean checkInProInst(String billId) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(billId);
        if (procInsts != null) {
            int in = procInsts.length;
            for (int i = 0; i < in; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean checkIsEmptyRow(Row row) {
        return BgNFSHelper.checkIsEmptyRow(row, false);
    }

    public static boolean checkIsEmptyRow(Row row, boolean isCheckMarge) {
        if (row == null) {
            return true;
        }
        Cell _cell = null;
        Sheet sheet = row.getSheet();
        int in = sheet.getMaxColIndex();
        for (int i = 0; i <= in; ++i) {
            CellBlock m_cell;
            _cell = row.getCell(i, false);
            if (!BgNFSHelper.checkIsEmptyCell(_cell)) {
                return false;
            }
            if (!isCheckMarge) continue;
            MergeBlocks mbs = sheet.getMerger(false);
            CellBlock cbl = sheet.getRange(row.getRow(), i).getBlock(0);
            if (mbs == null || !mbs.isMerged(cbl) || (m_cell = mbs.calActualBlock(cbl)) == null) continue;
            for (int mr = m_cell.getRow(); mr <= m_cell.getRow2(); ++mr) {
                for (int mc = m_cell.getCol(); mc <= m_cell.getCol2(); ++mc) {
                    if (BgNFSHelper.checkIsEmptyCell(sheet.getCell(mr, mc, false))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean checkIsEmptyCell(Cell cell) {
        return BgNFSHelper.checkIsEmptyValue(cell) && !BgNFSHelper.checkHasFormulaOfCell(cell) && !BgNFSHelper.checkHasExpression(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasCurrencyInfo(cell) && !BgNFSHelper.checkHasComment(cell) && !BgNFSHelper.checkHasLinked(cell);
    }

    public static boolean checkIsItemFormulaCell(Cell cell) {
        return !BgNFSHelper.checkHasFormulaOfCell(cell) && !BgNFSHelper.checkHasBgItemInfo(cell) && !BgNFSHelper.checkHasBgPeriodInfo(cell) && !BgNFSHelper.checkHasBgElementInfo(cell) && !BgNFSHelper.checkHasCurrencyInfo(cell);
    }

    public static boolean checkIsEmptyValue(Cell cell) {
        if (cell == null || cell.getValue() == Variant.nullVariant) {
            return true;
        }
        return cell.getValue() == Variant.nullVariant || cell.getValue().getValue() == null || cell.getValue().isNull() || cell.getValue().isEmpty() || StringUtils.isEmpty((String)cell.getValue().getValue().toString());
    }

    public static boolean checkIsEmptyContext(Cell cell) {
        return cell == null || cell.getValue().getValue() == null || cell.isEmptyContent();
    }

    public static boolean checkHasItemFormula(Cell cell) {
        Object obj;
        return cell != null && (obj = cell.getUserObjectValue("ITEM")) != null && obj instanceof ItemFormula;
    }

    public static boolean checkHasComment(Cell cell) {
        return cell != null && cell.getComment() != null;
    }

    public static boolean checkHasLinked(Cell cell) {
        return false;
    }

    public static boolean checkHasFormulaOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getFormula();
            return !StringUtils.isEmpty((String)formulaStr);
        }
        return false;
    }

    public static boolean checkHasCertificate(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object _obj = BgNFSHelper.getCellData(cell, "COURSE_CER");
        return _obj != null && BgNConstants.TRUE_STE.equals(_obj.toString());
    }

    public static boolean checkHasCause(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object _obj = BgNFSHelper.getCellData(cell, "COURSE_CAUSE");
        return _obj != null && BgNConstants.TRUE_STE.equals(_obj.toString());
    }

    public static boolean checkHasGatFormulaOfCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getExt("GATHER_FORMULA");
            return !StringUtils.isEmpty((String)formulaStr);
        }
        return false;
    }

    public static String getFormulaOfCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getFormula();
            return !StringUtils.isEmpty((String)formulaStr) ? formulaStr : null;
        }
        return null;
    }

    public static String getFormulaOfItem(ItemFormula itemFormula) {
        if (itemFormula == null) {
            return null;
        }
        return !StringUtils.isEmpty((String)itemFormula.getFormula()) ? itemFormula.getFormula() : null;
    }

    public static String getVersionOfitem(ItemFormula itemFormula) {
        if (itemFormula != null) {
            return itemFormula.getExt("Version");
        }
        return null;
    }

    public static String getOrgUnitOfItem(ItemFormula itemFormula) {
        if (itemFormula != null) {
            return itemFormula.getExt("ORGUNIT");
        }
        return null;
    }

    public static String getGatFormulaOfCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String formulaStr = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            formulaStr = itemFormula.getExt("GATHER_FORMULA");
            return !StringUtils.isEmpty((String)formulaStr) ? formulaStr : null;
        }
        return null;
    }

    public static String replaceAlter(String number) {
        if ("@".equals(number)) {
            return "";
        }
        return number;
    }

    public static String getDisplayFormula(String formulaStr, Map formulaMap) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        String[] parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        if (parameter != null) {
            StringBuffer _formulaStr = new StringBuffer();
            if (parameter.length == 6) {
                parameter[2] = BgNFSHelper.replaceAlter(parameter[2]);
                parameter[3] = BgNFSHelper.replaceAlter(parameter[3]);
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\",\"" + parameter[5] + "\")");
                return _formulaStr.toString();
            }
            if (parameter.length == 5) {
                parameter[2] = BgNFSHelper.replaceAlter(parameter[2]);
                parameter[3] = BgNFSHelper.replaceAlter(parameter[3]);
                _formulaStr.append("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\",\"" + parameter[4] + "\")");
                return _formulaStr.toString();
            }
        }
        return formulaStr;
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr, boolean isCreate) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt("13", formulaStr);
        } else if (isCreate) {
            itemFormula = new ItemFormula(formulaStr);
            cell.setUserObject("ITEM", (Object)itemFormula);
        }
    }

    public static void setFormulaOfCell(Cell cell, String formulaStr) {
        BgNFSHelper.setFormulaOfCell(cell, formulaStr, false);
    }

    public static void clearFormulaOfCell(Cell cell) {
        if (cell != null) {
            cell.removeUserObject("ITEM");
        }
    }

    public static BigDecimal getBudgetValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String valueStr = null;
        BigDecimal value = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && !StringUtils.isEmpty((String)(valueStr = (itemFormula = (ItemFormula)obj).getExt("BG_BUDGET_VALUE")))) {
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                value = null;
            }
            return value;
        }
        return null;
    }

    public static void setBudgetValue(Cell cell, BigDecimal value) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        String valueStr = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            valueStr = value != null ? CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value) : null;
            itemFormula.putExt("BG_BUDGET_VALUE", valueStr);
        }
    }

    public static BigDecimal getActualValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        String valueStr = null;
        BigDecimal value = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && !StringUtils.isEmpty((String)(valueStr = (itemFormula = (ItemFormula)obj).getExt("BG_ACTUAL_VALUE")))) {
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                value = null;
            }
            return value;
        }
        return null;
    }

    public static void setActualValue(Cell cell, BigDecimal value) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        String valueStr = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            valueStr = value != null ? CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)value) : null;
            itemFormula.putExt("BG_ACTUAL_VALUE", valueStr);
        }
    }

    public static String checkFormula(Map formulaMap, String formulaStr, IObjectValue model) throws EASBizException {
        BgFormInfo formInfo;
        BgRollRuleInfo rollRuleInfo;
        if (StringUtils.isEmpty((String)formulaStr) || model == null || !(model instanceof IDimDataQuery)) {
            return formulaStr;
        }
        IDimDataQuery bgFormInfo = (IDimDataQuery)model;
        BgRollPartEnum rollPart = null;
        if (bgFormInfo instanceof BgFormInfo && (rollRuleInfo = (formInfo = (BgFormInfo)bgFormInfo).getBgTemplate().getBgRollRule()) != null) {
            rollPart = rollRuleInfo.getRollPart();
        }
        return BgNFSHelper.checkFormula(formulaMap, formulaStr, bgFormInfo.getBizPeriod(), bgFormInfo.getBizCurrency(), rollPart);
    }

    public static String checkFormula(Map formulaMap, String formulaStr, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo) throws EASBizException {
        return BgNFSHelper.checkFormula(formulaMap, formulaStr, bgPeriodInfo, currencyInfo, null);
    }

    public static String checkFormula(Map formulaMap, String formulaStr, BgPeriodInfo bgPeriodInfo, CurrencyInfo currencyInfo, BgRollPartEnum rollPart) throws EASBizException {
        if (StringUtils.isEmpty((String)formulaStr) || bgPeriodInfo == null || currencyInfo == null) {
            return formulaStr;
        }
        boolean isBuilder = false;
        String[] parameter = BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        String bgFormPeriodNumber = bgPeriodInfo.getNumber();
        int bgFormPeriodType = bgPeriodInfo.getPeriodType().getValue();
        if (parameter != null) {
            if (parameter.length == 6) {
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormPeriodNumber;
                    isBuilder = true;
                } else {
                    String newPeriod;
                    int targetPeriodType = bgPeriodInfo.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriodInfo.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    if (!(newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)parameter[1], (int)targetPeriodType)).equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (java.util.regex.Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber((String)bgFormPeriodNumber, (int)new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[5])) {
                    parameter[5] = currencyInfo.getNumber();
                    isBuilder = true;
                }
            } else if (parameter.length == 5) {
                isBuilder = true;
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormPeriodNumber;
                    isBuilder = true;
                } else {
                    String newPeriod;
                    int targetPeriodType = bgPeriodInfo.getPeriodType().getValue();
                    String targetPeriodNumber = bgPeriodInfo.getNumber();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    if (!(newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)parameter[1], (int)targetPeriodType)).equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (java.util.regex.Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber((String)bgFormPeriodNumber, (int)new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[4])) {
                    parameter[4] = currencyInfo.getNumber();
                    isBuilder = true;
                }
            } else {
                return null;
            }
        }
        if (isBuilder) {
            if (formulaMap != null) {
                formulaMap.remove(formulaStr);
            }
            if (parameter.length == 6) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
            } else if (parameter.length == 5) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\",true,\"" + parameter[4] + "\")").toString();
            }
            BgNFSHelper.parseFormulaPara(formulaMap, formulaStr);
        }
        return formulaStr;
    }

    public static String[] parseFormulaPara(Map formulaMap, String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        String[] parameter = null;
        if (formulaMap != null && formulaMap.containsKey(formulaStr)) {
            String[] _parameter = (String[])formulaMap.get(formulaStr);
            parameter = new String[_parameter.length];
            System.arraycopy(_parameter, 0, parameter, 0, parameter.length);
        } else {
            parameter = BgNFSHelper.parseFormulaPara(formulaStr);
            if (formulaMap != null) {
                formulaMap.put(formulaStr, parameter);
            }
        }
        return parameter;
    }

    public static String[] parseFormulaPara(String formulaStr) {
        int i;
        String[] parameter = null;
        if (StringUtils.isEmpty((String)formulaStr)) {
            return parameter;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        boolean begin = false;
        boolean load = false;
        StringBuffer value = new StringBuffer();
        int in = formulaStr.length();
        for (i = 0; i < in; ++i) {
            char _char = formulaStr.charAt(i);
            if (begin) {
                if (_char == ')') {
                    begin = false;
                }
                if (_char == '\"') {
                    load = !load;
                    continue;
                }
                if (!(_char != ',' && _char != ')' || load)) {
                    tokens.add(value.toString());
                    value.setLength(0);
                    continue;
                }
                value.append(_char);
                continue;
            }
            if (_char != '(') continue;
            begin = true;
        }
        if (!tokens.isEmpty()) {
            parameter = new String[tokens.size()];
            in = tokens.size();
            for (i = 0; i < in; ++i) {
                parameter[i] = tokens.get(i) != null ? ((String)tokens.get(i)).trim() : null;
            }
        }
        return parameter;
    }

    public static String getFormulaFromParam(String itemNumber, String periodNumber, String elementNumber, String currencyNumber, String scenarioNumber) {
        return BgNFSHelper.getFormulaFromParam(new String[]{itemNumber, periodNumber, elementNumber, scenarioNumber, currencyNumber});
    }

    public static String getFormulaFromParam(String[] parameter) {
        if (parameter == null) {
            return null;
        }
        String formulaStr = null;
        if (parameter.length == 6) {
            formulaStr = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\"," + StringUtils.cnulls((String)parameter[4]) + ",\"" + StringUtils.cnulls((String)parameter[5]) + "\")").toString();
        } else if (parameter.length == 5) {
            formulaStr = new StringBuffer("=BgItem(\"" + StringUtils.cnulls((String)parameter[0]) + "\",\"" + StringUtils.cnulls((String)parameter[1]) + "\",\"" + StringUtils.cnulls((String)parameter[2]) + "\",\"" + StringUtils.cnulls((String)parameter[3]) + "\",true,\"" + StringUtils.cnulls((String)parameter[4]) + "\")").toString();
        }
        return formulaStr;
    }

    public static void setFormulaEditOfDisable(Cell cell) {
        BgNFSHelper.setFormulaEditOfCell(cell, false);
    }

    public static void setFormulaEditOfCell(Cell cell, boolean editable) {
        if (cell == null) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (editable) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
            } else {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            }
        }
    }

    public static boolean checkCanEditFormulaOfCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            if (itemFormula.getExt("BGFORMULA_CANUPDATE") == null) {
                itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                return true;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.FALSE_UPDATE)) {
                return false;
            }
            if (itemFormula.getExt("BGFORMULA_CANUPDATE").equals(BgNConstants.TRUE_UPDATE)) {
                return true;
            }
        }
        return true;
    }

    public static void setEditFormulaOfCell(Cell cell, boolean canEdit) {
        if (cell != null) {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                if (canEdit) {
                    itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.TRUE_UPDATE);
                } else {
                    itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
                }
            }
        }
    }

    public static void checkExpressions(Context ctx, Cell cell, IObjectValue model, int VIEW_MODE, boolean isReplacePeriodNVar) {
        if (!BgNFSHelper.checkHasExpression(cell) || model == null || !(model instanceof IDimDataQuery)) {
            return;
        }
        String expressions = null;
        String string = expressions = cell.hasFormula() ? cell.getFormula() : null;
        if (!StringUtils.isEmpty((String)expressions)) {
            if (!StringUtils.isEmpty((String)(expressions = BgNFSHelper.checkExpression(ctx, cell, expressions, model, isReplacePeriodNVar, false)))) {
                Object object;
                if (cell != null && (object = cell.getUserObjectValue("ITEM")) != null && object instanceof ItemFormula) {
                    String bgItemStr = ((ItemFormula)object).getFormula();
                    if (expressions.indexOf("@") > -1 && null != bgItemStr && !"".equals(bgItemStr.trim())) {
                        int startIndex = bgItemStr.indexOf("\"") + 1;
                        int endIndex = bgItemStr.indexOf("\",");
                        String newChar = bgItemStr.substring(startIndex, endIndex);
                        expressions = expressions.replace("@", newChar);
                    }
                }
                BgNFSHelper.setExpression(cell, expressions);
            }
        } else {
            BgNFSHelper.clearExpression(cell);
        }
    }

    public static void checkExpression(Context ctx, Cell cell, IObjectValue model, boolean isCsl) {
        String _expression;
        if (cell == null || model == null || !(model instanceof IDimDataQuery)) {
            return;
        }
        String expression = BgNFSHelper.getExpression(cell);
        if (!StringUtils.isEmpty((String)expression) && (_expression = BgNFSHelper.checkExpression(ctx, cell, expression, model, true, isCsl)) != null && !expression.equalsIgnoreCase(_expression.replaceAll(" ", ""))) {
            cell.setFormula(_expression);
            cell.setValue(cell.getValue());
        }
    }

    public static String checkExpression(Context ctx, Cell cell, String expression, IObjectValue model, boolean isReplacePeriodNVar, boolean isCsl) {
        return BgNExpressionHelper.checkExpression(ctx, cell, expression, model, null, isReplacePeriodNVar, isCsl);
    }

    public static boolean checkHasExpression(Cell cell) {
        if (cell == null) {
            return false;
        }
        long st = System.currentTimeMillis();
        String express = cell.getFormula();
        if (cell != null && !cell.hasFormula() && !StringUtils.isEmpty((String)express) && express.startsWith("=")) {
            cell.setFormula(cell.getFormula());
        }
        totalTime += System.currentTimeMillis() - st;
        return cell != null && cell.hasFormula();
    }

    public static boolean checkHasExpression(Cell cell, int VIEW_MODE) {
        return BgNFSHelper.checkHasExpression(cell);
    }

    public static boolean checkIsExpression(String text) {
        return !StringUtils.isEmpty((String)text) && text.indexOf("=") == 0;
    }

    public static String getExpression(Cell cell) {
        return cell != null && cell.hasFormula() ? cell.getFormula() : null;
    }

    public static void setExpressions(Cell cell, int VIEW_MODE) {
    }

    public static void setExpression(Cell cell, String expression) {
        if (cell != null) {
            cell.setFormula(expression);
            cell.setValue(cell.getValue());
        }
    }

    public static void clearExpression(Cell cell) {
        if (cell != null && cell.hasFormula()) {
            cell.setFormula(null);
        }
    }

    public static void clearExpression(Cell cell, int VIEW_MODE) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).isEmpty()) {
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static String loadExpression(Cell cell, int VIEW_MODE) {
        if (cell != null && cell.hasFormula()) {
            return cell.getFormula();
        }
        return null;
    }

    public static void saveExpression(Cell cell, String expression, int VIEW_MODE) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
        } else {
            _tmpMap = new HashMap();
            cell.setUserObject("CELL_DATA", _tmpMap);
        }
        cell.setFormula(expression);
        if (_tmpMap.isEmpty()) {
            cell.removeUserObject("CELL_DATA");
        }
    }

    public static void setLockOfCell(Cell cell, boolean isLocked) {
        BgNFSHelper.setCellLocked(null, cell, isLocked);
    }

    public static void setLockOfCell(Context ctx, Cell cell, boolean isLocked) {
        BgNFSHelper.setCellLocked(ctx, cell, isLocked);
    }

    public static boolean checkHasBudget(IObjectValue model) {
        if (model == null) {
            return false;
        }
        Object obj = model.get("BGFORMINFO_TYPE");
        if (obj != null && obj instanceof String) {
            String _tmpStr = (String)obj;
            return _tmpStr.equals("BGFORM_BUDGET");
        }
        return false;
    }

    public static void setBudget(IObjectValue model) {
        if (model != null) {
            model.put("BGFORMINFO_TYPE", (Object)"BGFORM_BUDGET");
        }
    }

    public static boolean checkHasActual(IObjectValue model) {
        if (model == null) {
            return false;
        }
        Object obj = model.get("BGFORMINFO_TYPE");
        if (obj != null && obj instanceof String) {
            String _tmpStr = (String)obj;
            return _tmpStr.equals("BGFORM_ACTUAL");
        }
        return false;
    }

    public static void setActual(IObjectValue model) {
        if (model != null) {
            model.put("BGFORMINFO_TYPE", (Object)"BGFORM_ACTUAL");
        }
    }

    public static void clearTypeSign(IObjectValue model) {
        if (model != null) {
            model.remove("BGFORMINFO_TYPE");
        }
    }

    public static boolean checkHasAdjust(BOSUuid bgFormId) throws Exception {
        return BgNFSHelper.checkHasAdjust(null, bgFormId);
    }

    public static boolean checkHasAdjust(Context ctx, BOSUuid bgFormId) throws Exception {
        if (bgFormId == null) {
            return false;
        }
        IBgForm iBgForm = null;
        iBgForm = ctx == null ? BgFormFactory.getRemoteInstance() : BgFormFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        if (bgFormInfo != null) {
            return BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo);
        }
        return false;
    }

    public static boolean checkHasAdjust(IObjectValue model) {
        if (model == null) {
            return false;
        }
        BgFormInfo info = (BgFormInfo)model;
        return info.getState().getValue() == 4 || info.getState().getValue() == 35 || info.getState().getValue() == 6 || info.getState().getValue() == 12;
    }

    public static ItemFormula getItemFormula(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            return (ItemFormula)obj;
        }
        return null;
    }

    public static void removeItemFormula(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.removeUserObject("ITEM");
    }

    public static void setItemFormula(Cell cell, ItemFormula itemFormula) {
        if (cell != null && itemFormula != null) {
            cell.setUserObject("ITEM", (Object)itemFormula);
        }
    }

    public static boolean checkHasBgItemInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_item".equals(obj);
        }
        return false;
    }

    public static String[] getBgItemInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_item".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[4];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue_itemId");
            _tmpInfo[2] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillSrcNumber");
            _tmpInfo[3] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static void clearBgItemInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_item".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
                _tmpMap.remove("bgFillValue_itemId");
                _tmpMap.remove("bgFillSrcNumber");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasBgElementInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_element".equals(obj);
        }
        return false;
    }

    public static void clearBgElementInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_element".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
                _tmpMap.remove("isAttachFormula");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static void clearBgScenarioInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_scenario".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
                _tmpMap.remove("isAttachFormula");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasBgPeriodInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_period".equals(obj);
        }
        return false;
    }

    public static void clearBgPeriodInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if ("bgFillValueType_period".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasCurrencyInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType")) {
            obj = _tmpMap.get("bgFillType");
            return "bgFillValueType_currency".equals(obj);
        }
        return false;
    }

    public static void clearCurrencyInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            if (_tmpMap.containsKey("bgFillType") && "bgFillValueType_currency".equals(obj = _tmpMap.get("bgFillType"))) {
                _tmpMap.remove("bgFillType");
                _tmpMap.remove("bgFillValue");
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static boolean checkHasOverstepMax(BigDecimal value) {
        return value != null && value.compareTo(BgNConstants.maxBigDecimal) > 0;
    }

    public static boolean checkHasOverstepMin(BigDecimal value) {
        return value != null && value.compareTo(BgNConstants.minBigDecimal) < 0;
    }

    public static Map getMeasureUnitMap(BgFormInfo model) {
        if (model == null) {
            return new HashMap();
        }
        if (model.getBgMeasureUnit() != null && !model.getBgMeasureUnit().isEmpty()) {
            HashMap<String, BigDecimal> measureUnit = new HashMap<String, BigDecimal>();
            BgMeasureUnitInfo muInfo = null;
            BgMeasureUnitCollection muCol = model.getBgMeasureUnit();
            Iterator iter = muCol.iterator();
            while (iter.hasNext()) {
                muInfo = (BgMeasureUnitInfo)iter.next();
                if (muInfo == null || muInfo.getBgElement() == null || muInfo.getMeasureUnit() == null) continue;
                measureUnit.put(muInfo.getBgElement().getNumber(), muInfo.getMeasureUnit().getCoefficient());
            }
            return measureUnit;
        }
        return new HashMap();
    }

    public static Object getValue(Cell cell) {
        return cell != null && cell.getValue() != Variant.nullVariant ? cell.getValue().getValue() : null;
    }

    public static void setValue(Cell cell, Object value) {
        if (cell != null) {
            if (value != null) {
                cell.setValue(new Variant(value));
            } else {
                cell.setValue(Variant.nullVariant);
            }
        }
    }

    public static boolean checkHasTextOfCell(Cell cell) {
        try {
            if (cell != null && cell.getStyle() != null) {
                return BgNFSHelper.checkHasTextOfCell(cell.getStyle().getNumberFormat());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkHasTextOfCell(Sheet sheet, int rowIndex, int colIndex) {
        try {
            if (sheet != null) {
                com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
                sheet.getRange(rowIndex, colIndex).getStyle(sa, sa);
                return BgNFSHelper.checkHasTextOfCell(sa.getNumberFormat());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkHasTextOfCell(String numberFormat) {
        return !StringUtils.isEmpty((String)numberFormat) && "@".equals(numberFormat);
    }

    public static boolean checkHasPercentage(Cell cell) {
        if (cell != null && cell.getStyle() != null) {
            try {
                return BgNFSHelper.checkHasPercentage(cell.getStyle().getNumberFormat());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean checkHasPercentage(Sheet sheet, int rowIndex, int colIndex) {
        if (sheet != null) {
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sheet.getRange(rowIndex, colIndex).getStyle(sa, sa);
            try {
                return BgNFSHelper.checkHasPercentage(sa.getNumberFormat());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean checkHasPercentage(String numberFormat) {
        return !StringUtils.isEmpty((String)numberFormat) && (numberFormat.endsWith("%") || numberFormat.endsWith("%)"));
    }

    public static boolean checkIsNumericOfCell(Cell cell) {
        return cell != null && cell.getValue() != null && cell.getValue() != Variant.nullVariant && cell.getValue().getValue() != null && (cell.getValue().isNumber() || cell.getValue().isNumeric());
    }

    public static boolean checkHasNumbericOfCell(Cell cell) {
        if (cell != null && cell.getStyle() != null) {
            try {
                String _numberFormat = cell.getStyle().getNumberFormat();
                if (StringUtils.isEmpty((String)_numberFormat) || _numberFormat.equals(BgNConstants.routineStr) || _numberFormat.indexOf("0") >= 0) {
                    return _numberFormat.indexOf("%") < 0 && _numberFormat.indexOf("\uffe5") < 0;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String checkShowStrByNumberic(Cell cell) {
        try {
            if (cell == null || cell.getStyle() == null || StringUtils.isEmpty((String)cell.getStyle().getNumberFormat())) {
                return null;
            }
            String numberFormat = cell.getStyle().getNumberFormat();
            String[] split = numberFormat.split(";");
            if (split != null && split.length == 3 && java.util.regex.Pattern.matches("(#|,)*(\\d|\\.)*(;|-|\\[Red\\]|\\()*(#|,)*(#|,)*(\\d|\\.)*", split[0] + ";" + split[1])) {
                return split[2].replaceAll("\"", "");
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getDigitOfNumber(Cell cell, int digit) {
        return BgNFSHelper.getDigitOfNumber(cell, digit, null);
    }

    public static int getDigitOfNumber(Cell cell, int digit, String numberFormat) {
        try {
            if (cell == null || cell.getStyle() == null || cell.getStyle().getNumberFormat() == null) {
                return digit;
            }
            if (numberFormat == null) {
                numberFormat = cell.getStyle().getNumberFormat();
            }
            if (numberFormat.indexOf("0") >= 0) {
                String tmpString = null;
                if (numberFormat.trim().indexOf(";") >= 0) {
                    java.util.regex.Pattern p = java.util.regex.Pattern.compile(";");
                    String[] str = p.split(numberFormat.trim());
                    tmpString = str[0];
                    if (tmpString != null && tmpString.indexOf(".") >= 0) {
                        java.util.regex.Pattern p1 = java.util.regex.Pattern.compile("\\.");
                        String[] str1 = p1.split(tmpString);
                        if (str1[1] != null && str1[1].length() > 0) {
                            digit = str1[1].length();
                        }
                    } else {
                        digit = 0;
                    }
                } else if (numberFormat != null && numberFormat.indexOf(".") >= 0) {
                    java.util.regex.Pattern p = java.util.regex.Pattern.compile("\\.");
                    String[] str = p.split(numberFormat);
                    if (str[1] != null && str[1].length() > 0) {
                        digit = 0;
                        int n = str[1].length();
                        for (int i = 0; i < n; ++i) {
                            tmpString = str[1].substring(i, i + 1);
                            if (!tmpString.equals("0")) continue;
                            ++digit;
                        }
                    } else {
                        digit = 0;
                    }
                } else {
                    digit = 0;
                }
            }
            return digit;
        }
        catch (Exception e) {
            return digit;
        }
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static boolean checkIsNumeric(Object obj) {
        if (obj != null) {
            try {
                new BigDecimal(obj.toString().trim().replaceAll(",", ""));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Row addRow(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        range.insert(true);
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static Row addRow(Sheet sheet, int rowIndex, boolean hasStyle) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        if (hasStyle) {
            range.insert(true);
        } else {
            range.insert(true, InsertType.NOSTYLE);
        }
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static void addRowsOne(Sheet sheet, int rowIndex, int rowCont, boolean hasStyle) {
        for (int r = 0; r < rowCont; ++r) {
            BgNFSHelper.addRow(sheet, rowIndex, hasStyle);
        }
    }

    public static void addRows(Sheet sheet, int rowIndex, int rowCont, boolean hasStyle) {
        if (sheet == null || rowIndex < 0) {
            return;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex + rowCont - 1);
        range.setIgnoreProtected(true);
        if (hasStyle) {
            range.insert(true);
        } else {
            range.insert(true, InsertType.NOSTYLE);
        }
        for (int i = rowIndex; i < rowIndex + rowCont; ++i) {
            Row row = sheet.getRow(i, true);
            int maxColIndex = row.size();
            for (int j = 0; j < maxColIndex; ++j) {
                BgNTemplateHelper.clearAll(row.getAt(j), false);
            }
        }
    }

    public static boolean removeRow(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0 || rowIndex > sheet.getMaxRowIndex()) {
            return false;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        return range.delete();
    }

    public static Column addColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0) {
            return null;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        range.insert();
        Column col = sheet.getColumn(colIndex, true);
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            BgNTemplateHelper.clearAll(sheet.getCell(i, colIndex, false), false);
        }
        return col;
    }

    public static boolean removeColumn(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0 || colIndex > sheet.getMaxColIndex()) {
            return false;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        return range.delete();
    }

    public static void enableUndo(Book book) {
        if (book != null) {
            book.getUndoManager().enable(true);
        }
    }

    public static void disableUndo(Book book) {
        if (book != null) {
            book.getUndoManager().enable(false);
        }
    }

    public static void enableCal(Book book) {
        if (book != null) {
            book.setCalculate(true);
        }
    }

    public static void disableCal(Book book) {
        if (book != null) {
            book.setCalculate(false);
        }
    }

    public static void checkFormulaPara(String formulaStr, String[] formulaPara) throws EASBizException {
        if (formulaPara == null) {
            throw new BgFormException(BgFormException.ERRORPARAMETER, new String[]{formulaStr});
        }
        if (formulaPara.length == 6) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[1])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[3])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOSCENARIO, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[5])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOCURRENCY, new String[]{formulaStr});
            }
        } else if (formulaPara.length == 5) {
            if (StringUtils.isEmpty((String)formulaPara[0])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOITEM, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[1])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOPERIOD, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[2])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOELEMENT, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[3])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOSCENARIO, new String[]{formulaStr});
            }
            if (StringUtils.isEmpty((String)formulaPara[4])) {
                throw new BgFormException(BgFormException.ERRORPARAMETERNOCURRENCY, new String[]{formulaStr});
            }
        }
    }

    public static void setSheetObject(Sheet sheet, String key, Object obj) {
        if (sheet != null && !StringUtils.isEmpty((String)key)) {
            sheet.setUserObject(key, obj);
        }
    }

    public static boolean checkHasSign(Sheet sheet) {
        String sign = BgNFSHelper.getSheetSign(sheet);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getSheetSign(Sheet sheet) {
        if (sheet != null) {
            Object obj = sheet.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static void setSheetSign(Sheet sheet) {
        if (sheet != null) {
            BgNFSHelper.setSheetSign(sheet, BOSUuid.create((String)"FF66566A").toString());
        }
    }

    public static void setSheetSign(Sheet sheet, String sign) {
        if (sheet != null && !StringUtils.isEmpty((String)sign)) {
            sheet.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearSheetSign(Sheet sheet) {
        if (sheet != null) {
            sheet.removeUserObject("SIGN_DATA_ID");
            sheet.removeUserObject("SIGN_DATA_SOURCE");
            sheet.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static Object getRowObject(Row row, String key) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            return row.getUserObjectValue(key);
        }
        return null;
    }

    public static void setRowObject(Row row, String key, Object obj) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            row.setUserObject(key, obj);
        }
    }

    public static Object getColObject(Column column, String key) {
        if (column != null && !StringUtils.isEmpty((String)key)) {
            return column.getUserObjectValue(key);
        }
        return null;
    }

    public static void setColObject(Column column, String key, Object obj) {
        if (column != null && !StringUtils.isEmpty((String)key)) {
            column.setUserObject(key, obj);
        }
    }

    public static boolean checkHasSign(Row row) {
        String sign = BgNFSHelper.getRowSign(row);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getRowSign(Row row) {
        if (row != null) {
            Object obj = row.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static String setRowSign(Row row) {
        String sign = BOSUuid.create((String)"BBBCCAAA").toString();
        BgNFSHelper.setRowSign(row, sign);
        return sign;
    }

    public static void setRowNullSign(Row row) {
        if (row != null) {
            row.setUserObject("IS_NULL_ROW", (Object)"IS_NULL_ROW");
        }
    }

    public static boolean checkHasNullSign(Row row) {
        return row.getUserObject("IS_NULL_ROW") != null && row.getUserObject("IS_NULL_ROW").getValue() != null && "IS_NULL_ROW".equals(row.getUserObject("IS_NULL_ROW").getValue().toString());
    }

    public static void setRowSign(Row row, String sign) {
        if (row != null && !StringUtils.isEmpty((String)sign)) {
            row.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearRowSign(Row row, String key) {
        if (row != null && !StringUtils.isEmpty((String)key)) {
            row.removeUserObject(key);
        }
    }

    public static void clearRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_ID");
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setRowSource(Row row, String source) {
        if (row != null && !StringUtils.isEmpty((String)source)) {
            BgNFSHelper.setRowObject(row, "SIGN_DATA_SOURCE", source);
        }
    }

    public static Object getRowSource(Row row) {
        if (row != null) {
            return BgNFSHelper.getRowObject(row, "SIGN_DATA_SOURCE");
        }
        return null;
    }

    public static void removeRowSource(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static boolean checkHasSign(Column column) {
        String sign = BgNFSHelper.getColSign(column);
        return sign != null && !StringUtils.isEmpty((String)sign.toString());
    }

    public static String getColSign(Column column) {
        if (column != null) {
            Object obj = column.getUserObjectValue("SIGN_DATA_ID");
            return obj != null ? obj.toString() : null;
        }
        return null;
    }

    public static String setColSign(Column column) {
        String sign = BOSUuid.create((String)"CCCAABBB").toString();
        BgNFSHelper.setColSign(column, sign);
        return sign;
    }

    public static void setColSign(Column column, String sign) {
        if (column != null && !StringUtils.isEmpty((String)sign)) {
            column.setUserObject("SIGN_DATA_ID", (Object)sign);
        }
    }

    public static void clearColSign(Column column) {
        if (column != null) {
            column.removeUserObject("SIGN_DATA_ID");
            column.removeUserObject("SIGN_DATA_SOURCE");
            column.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setColSource(Column column, String source) {
        if (column != null && !StringUtils.isEmpty((String)source)) {
            BgNFSHelper.setColObject(column, "SIGN_DATA_SOURCE", source);
        }
    }

    public static Object getColSource(Column column) {
        if (column != null) {
            return column.getUserObjectValue("SIGN_DATA_SOURCE");
        }
        return null;
    }

    public static void removeColumnSource(Column column) {
        if (column != null) {
            column.removeUserObject("SIGN_DATA_SOURCE");
            column.removeUserObject("SIGN_DATA_SOURCE_OTHER");
        }
    }

    public static void setCellSource(Cell cell, String source) {
        if (cell == null || StringUtils.isEmpty((String)source)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt("SIGN_DATA_SOURCE", source);
        }
    }

    public static String getCellSource(Cell cell) {
        if (cell != null) {
            Object obj = null;
            ItemFormula itemFormula = null;
            obj = cell.getUserObjectValue("ITEM");
            if (obj != null && obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
                return itemFormula.getExt("SIGN_DATA_SOURCE");
            }
        }
        return null;
    }

    public static void setUserObject(Cell cell, String key, String obj) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            cell.setUserObject(key, (Object)obj);
        }
    }

    public static Object getUserObject(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            return cell.getUserObjectValue(key);
        }
        return null;
    }

    public static void setCellFormulaValue(Cell cell, String key, String value) {
        if (cell == null || StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) {
            return;
        }
        Object obj = null;
        ItemFormula itemFormula = null;
        obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            itemFormula = (ItemFormula)obj;
            itemFormula.putExt(key, value);
        }
    }

    public static void removeCellData(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            _tmpMap.remove(key);
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static void setCellData(Cell cell, String key, Object value) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map<String, Object> _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
            } else {
                _tmpMap = new HashMap();
                cell.setUserObject("CELL_DATA", _tmpMap);
            }
            if (_tmpMap != null) {
                _tmpMap.put(key, value);
            }
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static Object getCellData(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
                return _tmpMap.get(key);
            }
        }
        return null;
    }

    public static void removeCellExtData(Cell cell, String key) {
        if (cell == null || StringUtils.isEmpty((String)key)) {
            return;
        }
        Map _tmpMap = null;
        Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
        if (obj != null && obj instanceof Map) {
            _tmpMap = (Map)obj;
            _tmpMap.remove(key);
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA_EXT");
            }
        }
    }

    public static void setCellExtData(Cell cell, String key, Object value) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map<String, Object> _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
            } else {
                _tmpMap = new HashMap();
                cell.setUserObject("CELL_DATA_EXT", _tmpMap);
            }
            if (_tmpMap != null) {
                _tmpMap.put(key, value);
            }
        }
    }

    public static Object getCellExtData(Cell cell, String key) {
        if (cell != null && !StringUtils.isEmpty((String)key)) {
            Map _tmpMap = null;
            Object obj = cell.getUserObjectValue("CELL_DATA_EXT");
            if (obj != null && obj instanceof Map) {
                _tmpMap = (Map)obj;
                return _tmpMap.get(key);
            }
        }
        return null;
    }

    public static Map getFormulaMapOfBook(Book book, String orgUnitId, String schemeId) {
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return formulaMap;
        }
        String formulaStr = null;
        StringBuffer _tmpKey = null;
        BigDecimal value = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Object _obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    value = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _tmpKey = new StringBuffer(orgUnitId).append("!").append(schemeId).append("!").append(formulaStr);
                    _obj = BgNFSHelper.getValue(_cell);
                    if (_obj != null) {
                        try {
                            value = new BigDecimal(_obj.toString());
                        }
                        catch (Exception e) {
                            value = BgNConstants.ZERO;
                        }
                    }
                    formulaMap.put(_tmpKey.toString(), value);
                }
            }
        }
        return formulaMap;
    }

    public static List getFormulaListOfBook(Book book) {
        return BgNFSHelper.getFormulaListOfBook(book, null);
    }

    public static List getFormulaListOfBook(Book book, String[] sheetNames) {
        ArrayList<String> formulaList = new ArrayList<String>();
        if (book == null) {
            return formulaList;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        List sheetList = BgNFSHelper.toList(sheetNames);
        String formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (!sheetList.isEmpty() && !sheetList.contains(_sheet.getSheetName())) continue;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    formulaList.add(formulaStr);
                }
            }
        }
        return formulaList;
    }

    public static List toList(Object[] objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (objs != null) {
            for (Object o : objs) {
                list.add(o);
            }
        }
        return list;
    }

    public static void setBackGroup(Cell cell, Color color) {
        Sheet sheet;
        if (cell == null) {
            return;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        sa.setBackground(color);
        if (Styles.getNullColor().equals(color)) {
            sa.setPattern(Pattern.None);
        }
        if ((sheet = cell.getSheet()) == null) {
            return;
        }
        Range range = sheet.getRange(cell);
        boolean oldFlag = range.isIgnoreProtected();
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
        range.setIgnoreProtected(oldFlag);
    }

    public static void setAdjustBeforeColor(Cell cell) {
        if (cell == null || BgNFSHelper.getAdjustBeforeColor(cell) != null) {
            return;
        }
        Color color = BgNFSHelper.getBackGroup(cell);
        BgNFSHelper.setAdjustBeforeColor(cell, color);
    }

    public static void setAdjustBeforeColor(Cell cell, Color color) {
        if (color == null) {
            BgNFSHelper.removeCellExtData(cell, "ADJUST_BEFORE_COLOR");
        } else {
            BgNFSHelper.setCellExtData(cell, "ADJUST_BEFORE_COLOR", color);
        }
    }

    public static Color getAdjustBeforeColor(Cell cell) {
        return (Color)BgNFSHelper.getCellExtData(cell, "ADJUST_BEFORE_COLOR");
    }

    public static Color getBackGroup(Cell cell) {
        if (cell == null) {
            return null;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes SA = Styles.getSA((ShareStyleAttributes)cell.getSSA());
        if (SA == null) {
            return null;
        }
        return SA.getBackground();
    }

    public static void setNumberFormat(Cell cell, String numFormat) {
        if (cell == null) {
            return;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        sa.setNumberFormat(numFormat);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setHided(Row row, boolean hided) {
        if (row != null) {
            Range range = row.getSheet().getRowRange(row.getRow(), row.getRow());
            range.setIgnoreProtected(true);
            range.setHidden(hided, true);
        }
    }

    public static void setHided(Column column, boolean hided) {
        if (column != null) {
            Range range = column.getSheet().getColRange(column.getCol(), column.getCol());
            range.setIgnoreProtected(true);
            range.setColumnHidden(hided);
        }
    }

    public static boolean isHided(Row row) {
        Range range = row.getSheet().getRowRange(row.getRow(), row.getRow());
        return range != null && range.getHidden() != null && (range.getHidden() != false || range.getRowHeight() == 0);
    }

    public static boolean isHided(Column col) {
        Range range = col.getSheet().getColRange(col.getCol(), col.getCol());
        return range != null && (range.getHidden() != false || range.getColumnWidth() == 0);
    }

    public static void replaceSheetSign(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Row _row = null;
        Column _column = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        rowCount = sheet.getMaxRowIndex();
        colCount = sheet.getMaxColIndex();
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign(_row)) continue;
            BgNFSHelper.setRowSource(_row, "DATA_SOURCE_TEMPLATE");
        }
        for (colIndex = 0; colIndex <= colCount; ++colIndex) {
            _column = sheet.getColumn(colIndex, false);
            if (_column == null || !BgNFSHelper.checkHasSign(_column)) continue;
            BgNFSHelper.setColSource(_column, "DATA_SOURCE_TEMPLATE");
        }
    }

    public static void checkBookSign(Book book) {
        if (book == null) {
            return;
        }
        Object _obj = null;
        Sheet _sheet = null;
        Row _row = null;
        Column _column = null;
        boolean isEmptyRow = false;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            boolean check = true;
            if (!BgNFSHelper.checkHasSign(_sheet)) {
                BgNFSHelper.setSheetSign(_sheet);
            }
            for (rowIndex = rowCount; rowIndex >= 0; --rowIndex) {
                _row = _sheet.getRow(rowIndex, true);
                isEmptyRow = BgNFSHelper.checkIsEmptyRow(_row);
                if (check && isEmptyRow) {
                    BgNFSHelper.removeRowSign(_row);
                    BgNFSHelper.removeRowSource(_row);
                    continue;
                }
                check = false;
                if (!BgNFSHelper.checkHasSign(_row)) {
                    BgNFSHelper.setRowSign(_row);
                }
                if (isEmptyRow) {
                    BgNFSHelper.setRowNullSign(_row);
                }
                if (BgNFSHelper.checkHasNullSign(_row) && !isEmptyRow) {
                    BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
                    BgNFSHelper.removeNullRowSign(_row);
                    continue;
                }
                _obj = BgNFSHelper.getRowSource(_row);
                if (_obj != null) continue;
                BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
            }
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _column = _sheet.getColumn(colIndex, true);
                if (!BgNFSHelper.checkHasSign(_column)) {
                    BgNFSHelper.setColSign(_column);
                }
                if ((_obj = BgNFSHelper.getColSource(_column)) != null) continue;
                BgNFSHelper.setColSource(_column, "DATA_SOURCE_EDIT");
            }
        }
    }

    public static void updateAliasAudit(Book book) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Row _row = null;
        Column _column = null;
        Cell _cell = null;
        Object _source = null;
        int sheetIndex = 0;
        int sheetSize = 0;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        sheetSize = book.getSheetCount();
        for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                _row = _sheet.getRow(rowIndex, false);
                if (_row != null && BgNFSHelper.checkHasSign(_row)) {
                    _source = BgNFSHelper.getRowSource(_row);
                    if (_source != null && "DATA_SOURCE_COLLECT".equals(_source.toString())) {
                        BgNFSHelper.setRowSource(_row, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setRowObject(_row, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        String sourceString;
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (_cell == null || (sourceString = BgNFSHelper.getCellSource(_cell)) == null || !"DATA_SOURCE_COLLECT".equals(sourceString)) continue;
                        BgNFSHelper.setCellSource(_cell, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setCellFormulaValue(_cell, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                }
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    if (rowIndex == 0 && (_column = _sheet.getColumn(colIndex, false)) != null && BgNFSHelper.checkHasSign(_column) && (_source = BgNFSHelper.getColSource(_column)) != null && "DATA_SOURCE_COLLECT".equals(_source.toString())) {
                        BgNFSHelper.setColSource(_column, "DATA_SOURCE_EDIT");
                        BgNFSHelper.setColObject(_column, "SIGN_DATA_SOURCE_OTHER", "DATA_SOURCE_COLLECT");
                    }
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell = _sheet.getCell(rowIndex, colIndex, false))) {
                        BgNFSHelper.setEditFormulaOfCell(_cell, false);
                    }
                    if (_cell == null) continue;
                    _cell.removeUserObject("SIGN_DATA_SOURCE");
                }
            }
        }
    }

    public static void removeRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("SIGN_DATA_ID");
            row.removeUserObject("SIGN_DATA_SOURCE");
            row.removeUserObject("IS_NULL_ROW");
        }
    }

    public static void removeNullRowSign(Row row) {
        if (row != null) {
            row.removeUserObject("IS_NULL_ROW");
        }
    }

    public static void removeColSign(Column col) {
        if (col != null && BgNFSHelper.checkHasSign(col)) {
            col.removeUserObject("SIGN_DATA_ID");
            if (col.getUserObjectValue("SIGN_DATA_SOURCE") != null) {
                col.removeUserObject("SIGN_DATA_SOURCE");
            }
        }
    }

    public static void removeSheetSign(Sheet sheet) {
        if (sheet != null && BgNFSHelper.checkHasSign(sheet)) {
            sheet.removeUserObject("SIGN_DATA_ID");
            if (sheet.getUserObjectValue("SIGN_DATA_SOURCE") != null) {
                sheet.removeUserObject("SIGN_DATA_SOURCE");
            }
        }
    }

    public static boolean checkIsLinkCell(Cell cell) {
        return cell != null && (!StringUtils.isEmpty((String)((String)BgNFSHelper.getCellData(cell, "BG_LINK_FORM_ID"))) || !StringUtils.isEmpty((String)((String)BgNFSHelper.getCellData(cell, "BG_LINK_TEMPLATE_ID"))));
    }

    public static void setFocusOfCell(SpreadContext spread) {
        if (spread == null || spread.getSpread().getBook() == null || spread.getSpread().getBook().getSheet(0) == null) {
            return;
        }
        Range range = spread.getSpread().getBook().getSheet(0).getRange(0, 0);
        if (range != null) {
            range.select();
        }
        spread.getSpread().scrollCellVisible(0, 0);
    }

    public static void setFocusOfCell(SpreadContext spread, int sheetIndex, int rowIndex, int colIndex) {
        if (spread == null || spread.getSpread().getBook() == null || spread.getSpread().getBook().getSheet(sheetIndex) == null) {
            return;
        }
        Range range = spread.getSpread().getBook().getSheet(sheetIndex).getRange(rowIndex, colIndex);
        if (range != null) {
            range.select();
        }
        spread.getSpread().scrollCellVisible(0, 0);
    }

    public static void setLinkOfCell(Cell cell, String link, String bgFormId) {
        if (cell == null || StringUtils.isEmpty((String)link) || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        BgNFSHelper.setCellData(cell, "BG_LINK_FORM_ID", bgFormId);
        BgNFSHelper.setValue(cell, link);
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        sa.setFontColor(Color.BLUE);
        sa.setUnderline(true);
        sa.setNumberFormat("@");
        cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
    }

    public static void clearLinkOfCell(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkIsLinkCell(cell)) {
            Map _tmpMap = (Map)cell.getUserObjectValue("CELL_DATA");
            BgNFSHelper.removeCellData(cell, "BG_LINK_FORM_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_ORGUNIT_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_SCHEME_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_SCHEME_NUMBER");
            BgNFSHelper.removeCellData(cell, "BG_LINK_TEMPLATE_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_TEMPLATE_NUMBER");
            BgNFSHelper.removeCellData(cell, "BG_LINK_PERIOD_ID");
            BgNFSHelper.removeCellData(cell, "BG_LINK_CURRENCY_ID");
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sa.setUnderline(false);
            cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
            if (_tmpMap.isEmpty()) {
                cell.removeUserObject("CELL_DATA");
            }
        }
    }

    public static void stopBookProtection(Book book) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (pro.isProtected()) {
            pro.stop("");
        }
        if (pro.isProtected()) {
            pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
        }
        pro.deleteOperations();
    }

    public static void startBookProtection(Book book) {
        if (book == null) {
            return;
        }
        BgNFSHelper.stopBookProtection(book);
        BookProtection pro = book.getProtection();
        pro.appendOperation(1);
        pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
    }

    public static void setBookLocked(Book book, boolean locked) {
        if (book == null) {
            return;
        }
    }

    public static void setBookProtection(Book book, boolean locked, List bookOperation) {
        if (book == null) {
            return;
        }
        BookProtection pro = book.getProtection();
        if (locked) {
            if (!pro.isProtected()) {
                if (bookOperation != null && !bookOperation.isEmpty()) {
                    Object _obj2 = null;
                    pro.deleteOperations();
                    for (Object _obj2 : bookOperation) {
                        if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                        pro.appendOperation(((Integer)_obj2).intValue());
                    }
                    BgNFSHelper.objClear(bookOperation);
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            book.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setSheetLocked(Sheet sheet, boolean locked) {
        if (sheet == null) {
            return;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes saIn = Styles.getEmptySA();
        Range r = null;
        r = sheet.getMaxRowIndex() == 1048575 ? sheet.getSheetRange() : sheet.getRange(0, 0, 1048574, 16383);
        r.getStyle(sa, saIn);
        sa.setLocked(locked);
        r.setStyle(sa, saIn);
        boolean isHide = false;
        isHide = sheet.isHide();
        sheet.setHide(isHide);
    }

    public static void setSheetProtection(Sheet sheet, boolean locked, List sheetOperation) {
        if (sheet == null) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(true);
        if (locked) {
            if (!pro.isProtected()) {
                if (sheetOperation != null && !sheetOperation.isEmpty()) {
                    Object _obj2 = null;
                    pro.deleteOperations();
                    for (Object _obj2 : sheetOperation) {
                        if (_obj2 == null || !(_obj2 instanceof Integer)) continue;
                        pro.appendOperation(((Integer)_obj2).intValue());
                    }
                }
                pro.start("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.FALSE_UPDATE);
        } else {
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
                if (pro.isProtected()) {
                    pro.stop();
                }
            }
            sheet.setUserObject("SHEET_LOCK", (Object)BgNConstants.TRUE_UPDATE);
        }
    }

    public static void setCellLocked(Context ctx, Cell cell, boolean isLocked) {
        if (cell == null) {
            return;
        }
        if (BgNTemplateHelper.hasForceLock(cell)) {
            if (isLocked) {
                return;
            }
            String longNumber = BgNTemplateHelper.getForceLockLongNumber(cell);
            FullOrgUnitInfo fullOrgUnitInfo = null;
            fullOrgUnitInfo = ctx == null ? SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo() : ContextUtil.getCurrentCostUnit((Context)ctx).castToFullOrgUnitInfo();
            String currentLongNumber = fullOrgUnitInfo.getLongNumber();
            if (!currentLongNumber.equals(longNumber)) {
                return;
            }
        }
        if (isLocked) {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
        } else {
            BgNFSHelper.setCellExtData(cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        sa.setLocked(isLocked);
        Range range = cell.getSheet().getRange(cell);
        range.setIgnoreProtected(true);
        range.setStyle(sa, Styles.getEmptySA());
    }

    public static void setBookLANDP(Book book, boolean locked, List bookOperation, List sheetOperation) {
        if (book == null) {
            return;
        }
        BgNFSHelper.setBookProtection(book, locked, bookOperation);
        BgNFSHelper.setBookLocked(book, locked);
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            BgNFSHelper.setSheetLANDP(book.getSheet(i), locked, sheetOperation);
        }
    }

    public static void setSheetLANDP(Sheet sheet, boolean locked, List sheetOperation) {
        if (sheet == null) {
            return;
        }
        BgNFSHelper.setSheetProtection(sheet, locked, sheetOperation);
        BgNFSHelper.setSheetLocked(sheet, locked);
    }

    public static void setAllCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    if (isLocked) {
                        if (_cell.isLocked() || _cell == null) continue;
                        if (isLocked) {
                            BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
                        } else {
                            BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
                        }
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (!_cell.isLocked() || _cell == null) continue;
                    if (isLocked) {
                        BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.FALSE_UPDATE);
                    } else {
                        BgNFSHelper.setCellExtData(_cell, "CELL_LOCK", BgNConstants.TRUE_UPDATE);
                    }
                    if (range == null) {
                        range = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range == null) continue;
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
        }
    }

    public static List getOnlySelectCellOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        if (!BgNSHelper.isProtectionRowAndCol(null)) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(4));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    public static List getOnlySelectCellOperation(boolean isCtrlEnumerate, IBookProvider bookProvider) {
        List onlySelectCellOperation = BgNFSHelper.getOnlySelectCellOperation();
        if (isCtrlEnumerate && bookProvider instanceof BudgetProvider) {
            onlySelectCellOperation.add(2048);
        }
        return onlySelectCellOperation;
    }

    public static List getOnlySelectCellOperationWorkFlow() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(8));
        sheetOperation.add(new Integer(16));
        sheetOperation.add(new Integer(32768));
        return sheetOperation;
    }

    public static List getMaxOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgNSHelper.isProtectionRowAndCol(null)) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(32));
        sheetOperation.add(new Integer(64));
        sheetOperation.add(new Integer(128));
        sheetOperation.add(new Integer(256));
        sheetOperation.add(new Integer(512));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        sheetOperation.add(new Integer(16384));
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(4096));
        return sheetOperation;
    }

    public static List getMaxOperation(boolean isCtrlEnumerate, IBookProvider bookProvider) {
        List maxOperation = BgNFSHelper.getMaxOperation();
        if (isCtrlEnumerate && bookProvider instanceof BudgetProvider) {
            maxOperation.add(2048);
        }
        return maxOperation;
    }

    public static List getBookOperation() {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        return sheetOperation;
    }

    public static void setCellLocked(Sheet sheet, Range range, boolean isLocked) {
        if (sheet == null || range == null) {
            return;
        }
        Cell _cell = null;
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            for (int rowIndex = block.getRow(); rowIndex <= block.getRow2(); ++rowIndex) {
                for (int colIndex = block.getCol(); colIndex <= block.getCol2(); ++colIndex) {
                    _cell = sheet.getCell(rowIndex, colIndex, false);
                    if (BgNFSHelper.getCellData(_cell, "BGDATA_CAN_UPDATE") instanceof Boolean && !Boolean.parseBoolean(BgNFSHelper.getCellData(_cell, "BGDATA_CAN_UPDATE").toString())) continue;
                    BgNFSHelper.setCellLocked(null, _cell, isLocked);
                }
            }
        }
    }

    public static List getIsNotEnumerateOperation() {
        return BgNFSHelper.getIsNotEnumerateOperation(null);
    }

    public static List getIsNotEnumerateOperation(Context ctx) {
        ArrayList<Integer> sheetOperation = new ArrayList<Integer>();
        sheetOperation.add(new Integer(1));
        sheetOperation.add(new Integer(2));
        sheetOperation.add(new Integer(4));
        if (!BgNSHelper.isProtectionRowAndCol(ctx)) {
            sheetOperation.add(new Integer(8));
            sheetOperation.add(new Integer(16));
        }
        sheetOperation.add(new Integer(32768));
        sheetOperation.add(new Integer(65536));
        sheetOperation.add(new Integer(8192));
        return sheetOperation;
    }

    public static void setIsWorkFlowUpdateCellLocked(Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        boolean _isLockOfOpen = BgParamCHelper.isLockCellByFormula();
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            Range range = null;
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa2 = Styles.getEmptySA();
            sa2.setLocked(true);
            Range range2 = null;
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell != null && (BgNFSHelper.checkHasExpression(_cell) || BgNFSHelper.checkHasFormulaOfCell(_cell))) {
                        if (isLocked) {
                            if (!_cell.isLocked()) {
                                if (range == null) {
                                    range = _cell.getSheet().getRange(_cell);
                                } else {
                                    range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                                }
                            }
                        } else if (!(!_cell.isLocked() || BgNFSHelper.checkHasCertificate(_cell) || _isLockOfOpen && _cell.hasFormula())) {
                            if (range == null) {
                                range = _cell.getSheet().getRange(_cell);
                            } else {
                                range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                            }
                        }
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        if (range2 == null) {
                            range2 = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell != null && (_cell.getValue() == Variant.nullVariant || "".equals(_cell.getValue().toString().trim()))) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (_cell == null) continue;
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    boolean cellIsLock = obj instanceof String && BgNConstants.FALSE_UPDATE.equals((String)obj);
                    boolean isUserEdit = BgNFSHelper.isUserEditBgFormCell(_cell);
                    if (cellIsLock) {
                        if (range2 == null) {
                            range2 = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (isUserEdit) {
                        if (range == null) {
                            range = _cell.getSheet().getRange(_cell);
                            continue;
                        }
                        range.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                        continue;
                    }
                    if (range2 == null) {
                        range2 = _cell.getSheet().getRange(_cell);
                        continue;
                    }
                    range2.addAll((SortedCellBlockArray)_cell.getSheet().getRange(_cell));
                }
            }
            if (range != null) {
                range.setIgnoreProtected(true);
                range.setStyle(sa, Styles.getEmptySA());
            }
            if (range2 == null) continue;
            range2.setIgnoreProtected(true);
            range2.setStyle(sa2, Styles.getEmptySA());
        }
    }

    public static void setIsNotEnumerateCellLocked(Context ctx, Book book, boolean isLocked) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        boolean _isLockOfOpen = ctx == null ? BgParamCHelper.isLockCellByFormula() : BgParamNHelper.isLockCellByFormula((Context)ctx);
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object obj = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(isLocked);
            BgSheetRange sheetRange = new BgSheetRange(_sheet);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa2 = Styles.getEmptySA();
            sa2.setLocked(true);
            BgSheetRange lockedRange = new BgSheetRange(_sheet);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    if (_cell != null && (BgNFSHelper.checkHasExpression(_cell) || BgNFSHelper.checkHasFormulaOfCell(_cell))) {
                        if (isLocked) {
                            if (_cell.isLocked()) continue;
                            sheetRange.addCell(rowIndex, colIndex);
                            continue;
                        }
                        if (!_cell.isLocked() || BgNFSHelper.checkHasCertificate(_cell) || _isLockOfOpen && _cell.hasFormula() || BgNFSHelper.checkHasFormulaOfCell(_cell) && (obj == null || BgNConstants.FALSE_UPDATE.equals(obj)) || isLocked || BgNFSHelper.checkHasExpression(_cell) && _cell.isLocked() && !BgNTemplateHelper.hasForceLock(_cell)) continue;
                        sheetRange.addCell(rowIndex, colIndex);
                        continue;
                    }
                    if (_cell != null && (_cell.getValue() == Variant.nullVariant || "".equals(_cell.getValue().toString().trim()))) {
                        if (isLocked == _cell.isLocked()) continue;
                        sheetRange.addCell(rowIndex, colIndex);
                        continue;
                    }
                    if (_cell == null) continue;
                    obj = BgNFSHelper.getCellExtData(_cell, "CELL_LOCK");
                    boolean cellIsLock = obj instanceof String && BgNConstants.FALSE_UPDATE.equals((String)obj);
                    boolean isUserEdit = BgNFSHelper.isUserEditBgFormCell(_cell);
                    if (cellIsLock) {
                        if (_cell.isLocked()) continue;
                        lockedRange.addCell(rowIndex, colIndex);
                        continue;
                    }
                    if (isUserEdit) {
                        if (isLocked == _cell.isLocked()) continue;
                        sheetRange.addCell(rowIndex, colIndex);
                        continue;
                    }
                    if (_cell.isLocked() || BgNTemplateHelper.hasForceLock(_cell) || _cell.getSheet().getValidations().getValidate(_cell.getRow(), _cell.getCol()) != null) continue;
                    lockedRange.addCell(rowIndex, colIndex);
                }
            }
            Range range = sheetRange.getRange();
            if (range != null && !range.isEmpty()) {
                range.setIgnoreProtected(true);
                range.setStyle(sa, Styles.getEmptySA());
            }
            if ((range = lockedRange.getRange()) == null || range.isEmpty()) continue;
            range.setIgnoreProtected(true);
            range.setStyle(sa2, Styles.getEmptySA());
        }
    }

    public static boolean isUserEditBgFormCell(Cell _cell) {
        if (_cell == null) {
            return false;
        }
        Object colObj = null;
        Object rowObj = null;
        colObj = BgNFSHelper.getColSource(_cell.getSheet().getColumn(_cell.getCol(), false));
        rowObj = BgNFSHelper.getRowSource(_cell.getSheet().getRow(_cell.getRow(), false));
        Object obj = null;
        obj = BgNFSHelper.getCellData(_cell, "USER_EIDT");
        if (obj instanceof String && Boolean.TRUE.toString().equals((String)obj)) {
            return true;
        }
        if (colObj instanceof String && "DATA_SOURCE_EDIT".equals((String)colObj)) {
            return true;
        }
        return rowObj instanceof String && "DATA_SOURCE_EDIT".equals((String)rowObj);
    }

    public static void printBookRowSign(Book book) {
    }

    public static Map getFormulaMap(IObjectValue bgFormInfo) {
        if (bgFormInfo != null) {
            return (Map)bgFormInfo.get("formulaMap_calculate");
        }
        return null;
    }

    public static void setFormulaMap(IObjectValue bgFormInfo, Map formulaMap) {
        if (bgFormInfo != null) {
            bgFormInfo.put("formulaMap_calculate", (Object)formulaMap);
        }
    }

    public static void clearFormulaMap(IObjectValue bgFormInfo) {
        if (bgFormInfo != null) {
            bgFormInfo.remove("formulaMap_calculate");
        }
    }

    public static boolean isSimpleExpression(Cell cell, String expressions) {
        if (cell == null || StringUtils.isEmpty((String)expressions)) {
            return false;
        }
        return BookFormulaHelper.isExcelFunction((Book)cell.getSheet().getBook(), (Sheet)cell.getSheet(), (String)expressions);
    }

    public static boolean checkIsEmptyRow(Row row, int y, int width) {
        if (row == null) {
            return true;
        }
        Cell _cell = null;
        int in = width;
        for (int i = y; i <= in; ++i) {
            _cell = row.getCell(i, false);
            if (BgNFSHelper.checkIsItemFormulaCell(_cell)) continue;
            return false;
        }
        return true;
    }

    public static String getTemplateKey(Context ctx, BgTemplateInfo temp) {
        if (ctx == null || temp == null) {
            return null;
        }
        return ctx.getAIS() + "_" + ContextUtil.getCurrentUserInfo((Context)ctx).getInvalidationDate() + "_" + temp.getId();
    }

    public static TreeModel getOrgTreeModel(String orgUnitId) throws Exception {
        return BgNFSHelper.getOrgTreeModel(null, orgUnitId);
    }

    public static TreeModel getFullTreeModel(String orgUnitId) throws Exception {
        return BgNFSHelper.getFullTreeModel(orgUnitId, false);
    }

    public static TreeModel getFullTreeModel(String orgUnitId, boolean isContainSealUp) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        return BgNFSHelper.getOrgTreeModel(OrgViewType.COSTCENTER, orgUnitId, isContainSealUp);
    }

    public static void setTreeNodeEnable(DefaultKingdeeTreeNode root, boolean isEnable) {
        if (root == null) {
            return;
        }
        Color color = new Color(77, 77, 77);
        if (isEnable) {
            color = Color.BLACK;
        }
        root.setTextColor(color);
        for (int index = 0; index < root.getChildCount(); ++index) {
            DefaultKingdeeTreeNode temp = (DefaultKingdeeTreeNode)root.getChildAt(index);
            temp.setTextColor(color);
            OrgStructureInfo org = (OrgStructureInfo)temp.getUserObject();
            if (org.getUnit().isIsLeaf()) continue;
            BgNFSHelper.setTreeNodeEnable(temp, isEnable);
        }
    }

    public static TreeModel getOrgTreeModel(String orgUnitId, final KDTree treeOrgUnit) throws Exception {
        String _tmpStr = null;
        _tmpStr = StringUtils.isEmpty((String)orgUnitId) ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : orgUnitId;
        TreeModel treeMode = BgNFSHelper.getNewTreeModel(OrgViewType.COSTCENTER, _tmpStr, true);
        if (treeMode != null && treeOrgUnit != null) {
            treeOrgUnit.addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                    try {
                        BgNFSHelper.addChildNode(node);
                        if (((OrgStructureInfo)node.getUserObject()).get("isChildLoad") == null) {
                            BgOrgTreeHelper.processOrgTreeModel(treeOrgUnit.getModel());
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((String)"", (Throwable)e1);
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
        }
        return treeMode;
    }

    public static TreeModel getOrgTreeModelNoEvent(String orgUnitId, KDTree treeOrgUnit, boolean needSealUp) throws Exception {
        String _tmpStr = null;
        _tmpStr = StringUtils.isEmpty((String)orgUnitId) ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : orgUnitId;
        TreeModel treeMode = BgNFSHelper.getNewTreeModel(OrgViewType.COSTCENTER, _tmpStr, false, needSealUp);
        return treeMode;
    }

    public static void addChildNode(DefaultKingdeeTreeNode node) throws Exception {
        DefaultKingdeeTreeNode tempNode;
        if (node == null) {
            return;
        }
        int childCount = node.getChildCount();
        if (childCount == 1 && (tempNode = (DefaultKingdeeTreeNode)node.getChildAt(0)).getUserObject() == null) {
            int index;
            node.removeAllChildren();
            DefaultKingdeeTreeNode tempNode1 = BgNFSHelper.getDefaultKingdeeTreeNode(node, null, false);
            BgNFSHelper.dealNode(tempNode1);
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (index = tempNode1.getChildCount(); index > 0; --index) {
                list.add(tempNode1.getChildAt(index - 1));
            }
            if (!list.isEmpty()) {
                for (index = list.size(); index > 0; --index) {
                    node.add((MutableTreeNode)((DefaultKingdeeTreeNode)list.get(index - 1)));
                }
            }
        }
    }

    private static TreeModel getNewTreeModel(OrgViewType viewType, String orgUnitId, boolean addOrgRange) throws Exception {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        DefaultTreeModel _model = null;
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureInfo selectNode = istruct.getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name,unit.parent,parent where unit.id = '" + orgUnitId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)viewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        DefaultKingdeeTreeNode node = BgNFSHelper.getDefaultKingdeeTreeNode(rootNode, viewType, addOrgRange);
        node.setTextColor(Color.BLACK);
        BgNFSHelper.dealNode(node);
        _model = new DefaultTreeModel((TreeNode)node);
        return _model;
    }

    private static TreeModel getNewTreeModel(OrgViewType viewType, String orgUnitId, boolean addOrgRange, boolean isSealUp) throws Exception {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        DefaultTreeModel _model = null;
        IOrgStructure istruct = OrgStructureFactory.getRemoteInstance();
        OrgStructureInfo selectNode = istruct.getOrgStructureInfo("select id, longnumber ,unit.id,unit.number,unit.longnumber,unit.name,unit.parent,parent where unit.id = '" + orgUnitId + "' and tree.id = '" + NewOrgViewHelper.convert2TreeId((OrgViewType)viewType) + "'");
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)selectNode);
        DefaultKingdeeTreeNode node = BgNFSHelper.getDefaultKingdeeTreeNode(rootNode, viewType, addOrgRange, isSealUp);
        node.setTextColor(Color.BLACK);
        BgNFSHelper.dealNode(node);
        _model = new DefaultTreeModel((TreeNode)node);
        return _model;
    }

    private static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode rootNode, OrgViewType viewType, boolean isNeedAddOrgRange) throws EASBizException, BOSException {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)viewType);
        return BgNFSHelper.getNewOrgViewFacadeInstance(null).getViewDirectChildNodesByMultiCondition(viewType, treeid, true, true, rootNode, true, isNeedAddOrgRange, null, null, null);
    }

    private static DefaultKingdeeTreeNode getDefaultKingdeeTreeNode(DefaultKingdeeTreeNode rootNode, OrgViewType viewType, boolean isNeedAddOrgRange, boolean isNeedSealUp) throws EASBizException, BOSException {
        if (viewType == null) {
            viewType = OrgViewType.COSTCENTER;
        }
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)viewType);
        return BgNFSHelper.getNewOrgViewFacadeInstance(null).getViewDirectChildNodesByMultiCondition(viewType, treeid, true, true, rootNode, isNeedSealUp, isNeedAddOrgRange, null, null, null);
    }

    private static void dealNode(DefaultKingdeeTreeNode node) {
        if (node == null || node.getChildCount() == 0) {
            return;
        }
        int count = node.getChildCount();
        DefaultKingdeeTreeNode child = null;
        OrgStructureInfo orginfo = null;
        for (int index = 0; index < count; ++index) {
            child = (DefaultKingdeeTreeNode)node.getChildAt(index);
            child.setTextColor(Color.BLACK);
            orginfo = (OrgStructureInfo)child.getUserObject();
            if (orginfo == null || orginfo.isIsLeaf()) continue;
            child.add((MutableTreeNode)new DefaultKingdeeTreeNode());
        }
    }

    public static TreeModel getOrgTreeModel(OrgViewType viewType, String orgUnitId) throws Exception {
        return BgNFSHelper.getOrgTreeModel(viewType, orgUnitId, false);
    }

    public static TreeModel getOrgTreeModel(OrgViewType viewType, String orgUnitId, boolean isContainSealUp) throws Exception {
        String _tmpStr = null;
        _tmpStr = StringUtils.isEmpty((String)orgUnitId) ? SysContext.getSysContext().getCurrentCostUnit().getId().toString() : orgUnitId;
        if (BgNFSHelper.checkHasNewOrgInterface()) {
            return BgNFSHelper.getNewOrgTreeModel(viewType, _tmpStr, isContainSealUp);
        }
        return BgNFSHelper.getOldOrgTreeModel(viewType, _tmpStr, isContainSealUp);
    }

    private static boolean checkHasNewOrgInterface() {
        boolean re = false;
        Class<?> _class = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.basedata.org.NewOrgUtils");
            _method = _class.getMethod("getTreeModel", OrgViewType.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, HashMap.class, Integer.TYPE, Boolean.TYPE, IMetaDataPK.class, IMetaDataPK.class);
            if (_method != null) {
                re = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return re;
    }

    private static TreeModel getOldOrgTreeModel(OrgViewType viewType, String orgUnitId, boolean isContainSealUp) throws Exception {
        OrgViewType _viewType = viewType;
        if (_viewType == null) {
            _viewType = OrgViewType.COSTCENTER;
        }
        return NewOrgUtils.getTreeModel((OrgViewType)_viewType, null, (boolean)false, (boolean)false, (boolean)isContainSealUp, (String)orgUnitId, (boolean)true, null, (int)0, null, null);
    }

    private static TreeModel getNewOrgTreeModel(OrgViewType viewType, String orgUnitId, boolean isContainSealUp) throws Exception {
        OrgViewType _viewType = viewType;
        if (_viewType == null) {
            _viewType = OrgViewType.COSTCENTER;
        }
        TreeModel _model = null;
        Class<?> _class = null;
        Method _method = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.NewOrgUtils");
        _method = _class.getMethod("getTreeModel", OrgViewType.class, String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, HashMap.class, Integer.TYPE, Boolean.TYPE, IMetaDataPK.class, IMetaDataPK.class);
        _model = (TreeModel)_method.invoke(_class, _viewType, null, false, false, isContainSealUp, orgUnitId, true, null, new Integer(0), true, null, null);
        return _model;
    }

    public static FullOrgUnitCollection getOrgPermission(IObjectPK pk) throws Exception {
        if (pk == null) {
            return new FullOrgUnitCollection();
        }
        if (BgNFSHelper.checkHasNewOrgPermissionInterface()) {
            return BgNFSHelper.getNewOrgPermission(pk);
        }
        return BgNFSHelper.getOldOrgPermission(pk);
    }

    public static FullOrgUnitCollection getOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        if (pk == null) {
            return new FullOrgUnitCollection();
        }
        if (BgNFSHelper.checkHasNewOrgPermissionInterface()) {
            return BgNFSHelper.getNewOrgPermission(ctx, pk);
        }
        return BgNFSHelper.getOldOrgPermission(ctx, pk);
    }

    private static boolean checkHasNewOrgPermissionInterface() {
        boolean re = false;
        Class<?> _class = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacade");
            _method = _class.getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                re = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return re;
    }

    private static FullOrgUnitCollection getOldOrgPermission(IObjectPK pk) throws Exception {
        return PermissionFactory.getRemoteInstance().getOrgRanges(pk);
    }

    private static FullOrgUnitCollection getOldOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        return PermissionFactory.getLocalInstance((Context)ctx).getOrgRanges(pk);
    }

    private static FullOrgUnitCollection getNewOrgPermission(IObjectPK pk) throws Exception {
        Class<?> _class = null;
        Method _method = null;
        Object _obj = null;
        FullOrgUnitCollection unitCollection = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory");
        _method = _class.getMethod("getRemoteInstance", null);
        if (_method != null) {
            _obj = _method.invoke(_class, null);
            _method = _obj.getClass().getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                unitCollection = (FullOrgUnitCollection)_method.invoke(_obj, pk);
            }
        }
        if (unitCollection == null) {
            unitCollection = new FullOrgUnitCollection();
        }
        return unitCollection;
    }

    private static FullOrgUnitCollection getNewOrgPermission(Context ctx, IObjectPK pk) throws Exception {
        Class<?> _class = null;
        Method _method = null;
        Object _obj = null;
        FullOrgUnitCollection unitCollection = null;
        _class = Class.forName("com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory");
        _method = _class.getMethod("getLocalInstance", Context.class);
        if (_method != null) {
            _obj = _method.invoke(_class, ctx);
            _method = _obj.getClass().getMethod("getSimpleOrgRanges", IObjectPK.class);
            if (_method != null) {
                unitCollection = (FullOrgUnitCollection)_method.invoke(_obj, pk);
            }
        }
        if (unitCollection == null) {
            unitCollection = new FullOrgUnitCollection();
        }
        return unitCollection;
    }

    public static Set getFinanceOrgID(Set costCenterOrgIds) throws BOSException {
        if (costCenterOrgIds == null || costCenterOrgIds.isEmpty()) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        ICostCenterOrgUnit iCost = BgNFSHelper.getCostInstance(null);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo(EntryFilterType.NORMAL);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)costCenterOrgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longNumber");
        view.setSelector(sic);
        view.setFilter(filter);
        CostCenterOrgUnitCollection costs = iCost.getCostCenterOrgUnitCollection(view);
        for (int index = 0; index < costs.size(); ++index) {
            ids.add(costs.get(index).getId().toString());
        }
        return ids;
    }

    public static void getAllCostCenterIDs(Set costIDSet, DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui;
        if (node == null) {
            return;
        }
        if (costIDSet == null) {
            costIDSet = new HashSet<String>();
        }
        if ((oui = (OrgStructureInfo)node.getUserObject()).getUnit() != null) {
            costIDSet.add(oui.getUnit().getId().toString());
        }
        Enumeration child = node.children();
        while (child.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)child.nextElement();
            oui = (OrgStructureInfo)tempNode.getUserObject();
            if (oui.getUnit() != null) {
                costIDSet.add(oui.getUnit().getId().toString());
            }
            if (tempNode.isLeaf()) continue;
            BgNFSHelper.getAllCostCenterIDs(costIDSet, tempNode);
        }
    }

    public static void objClear(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Map) {
            ((Map)obj).clear();
        } else if (obj instanceof Collection) {
            ((Collection)obj).clear();
        } else {
            try {
                Method method = obj.getClass().getMethod("clear", null);
                if (method != null) {
                    method.invoke(obj, null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void objAllClear(Object obj) {
        if (obj == null) {
            return;
        }
        Object key2 = null;
        Object value2 = null;
        if (obj instanceof Map) {
            Map _map = (Map)obj;
            for (Object key2 : _map.keySet()) {
                value2 = _map.get(key2);
                BgNFSHelper.objAllClear(value2);
            }
            BgNFSHelper.objClear(obj);
        } else if (obj instanceof Collection) {
            Collection _col = (Collection)obj;
            for (Object value2 : _col) {
                BgNFSHelper.objAllClear(value2);
            }
            BgNFSHelper.objClear(obj);
        }
    }

    public static boolean isEmptyMap(Object obj) {
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        return true;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("baseExchangeTable.id");
            sic.add("baseExchangeTable.name");
            return BgNFSHelper.getCompanyInstance(ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = null;
        parent = orgUnitInfo.get("isCompanyOrgUnit") == null ? BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId())) : BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgNFSHelper.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static ProfitCenterOrgUnitInfo getProfitByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null) {
            return null;
        }
        if (orgUnitInfo.isIsProfitOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            return BgNFSHelper.getProfitCenterOrgUnitInstance(ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = null;
        parent = orgUnitInfo.get("isProfitCenterOrgUnit") == null ? BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId())) : BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.PROFITCENTER);
        if (parent != null) {
            return BgNFSHelper.getProfitByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgNFSHelper.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static ProfitCenterOrgUnitInfo getProfitCenterInfo(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = BgNFSHelper.getFullOrgUnitInstance(ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsProfitOrgUnit()) {
            return (ProfitCenterOrgUnitInfo)orgUnitInfo.cast(ProfitCenterOrgUnitInfo.class);
        }
        OrgUnitInfo parent = BgNFSHelper.getNewOrgViewFacadeInstance(ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.PROFITCENTER);
        if (parent != null) {
            return BgNFSHelper.getProfitByOrgUnit(ctx, parent);
        }
        return null;
    }

    public static boolean checkLocalInProInst(Context ctx, String billId) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(billId);
        if (procInsts != null) {
            int in = procInsts.length;
            for (int i = 0; i < in; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static ICostCenterOrgUnit getCostInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return CostCenterOrgUnitFactory.getRemoteInstance();
        }
        return CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    public static ICompanyOrgUnit getCompanyInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance();
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    public static IFullOrgUnit getFullOrgUnitInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return FullOrgUnitFactory.getRemoteInstance();
        }
        return FullOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    public static IProfitCenterOrgUnit getProfitCenterOrgUnitInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return ProfitCenterOrgUnitFactory.getRemoteInstance();
        }
        return ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    public static INewOrgViewFacade getNewOrgViewFacadeInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return NewOrgViewFacadeFactory.getRemoteInstance();
        }
        return NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
    }

    public static IOrgUnitRelation getOrgUnitRelationInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return OrgUnitRelationFactory.getRemoteInstance();
        }
        return OrgUnitRelationFactory.getLocalInstance((Context)ctx);
    }

    public static String arrayToString(Object[] obj, String split) {
        StringBuffer name = new StringBuffer();
        for (int j = 0; j < obj.length; ++j) {
            name.append(obj[j] == null ? "" : obj[j].toString());
            if (j == obj.length - 1) continue;
            name.append(split);
        }
        return name.toString();
    }

    public static void setBlocksChangeLastUpdataTime(Sheet sheet, SortedCellBlockArray blocks) {
        if (sheet == null || blocks == null || blocks.isEmpty()) {
            return;
        }
        Cell cell = null;
        CellBlock block = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        int size = blocks.size();
        for (int index = 0; index < size; ++index) {
            block = blocks.getBlock(index);
            if (block == null) continue;
            int rowBegin = block.getRow();
            int rowEnd = block.getRow2() > rowCount ? rowCount : block.getRow2();
            int colBegin = block.getCol();
            int colEnd = block.getCol2() > colCount ? colCount : block.getCol2();
            for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || BgNFSHelper.getItemFormula(cell) == null) continue;
                    BgNFSHelper.setCellChangeLastUpdataTime(cell);
                }
            }
        }
    }

    public static void setCellChangeLastUpdataTime(Cell cell) {
        if (cell == null) {
            return;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        if (cell.getUserObject("CELL_CHANGE_LASTUPDATETIME") != null) {
            cell.getUserObject("CELL_CHANGE_LASTUPDATETIME").setValue((Object)ts.toString());
        } else {
            cell.setUserObject("CELL_CHANGE_LASTUPDATETIME", (Object)ts.toString());
        }
    }

    public static void removeCellChangeLastUpdataTime(Book book) {
    }

    public static void removeCellChangeLastUpdataTime(Cell cell) {
        if (cell == null) {
            return;
        }
        cell.removeUserObject("CELL_CHANGE_LASTUPDATETIME");
    }

    public static Timestamp getCellChangeLastUpdataTime(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("CELL_CHANGE_LASTUPDATETIME");
        try {
            if (obj != null) {
                if (obj instanceof Timestamp) {
                    return (Timestamp)obj;
                }
                if (obj instanceof String) {
                    return Timestamp.valueOf((String)obj);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static Boolean checkUpdataValueByTime(Cell cell, BgNDataInfo data) {
        boolean isUpdateValue = true;
        if (cell == null || data == null) {
            return isUpdateValue;
        }
        if (BgNFSHelper.getCellChangeLastUpdataTime(cell) != null) {
            Timestamp cellChangeTime = BgNFSHelper.getCellChangeLastUpdataTime(cell);
            if (data.getUpdateTime() == null) {
                data.setUpdateTime(cellChangeTime);
            }
            if (data.getUpdateTime().after(cellChangeTime)) {
                isUpdateValue = false;
            }
        } else if (data.getUpdateTime() != null) {
            isUpdateValue = false;
        }
        return isUpdateValue;
    }

    public static void synPeriod(ReportBaseInfo info, BgPeriodInfo period) {
        if (period == null || info == null) {
            return;
        }
        BgPeriodEnum periodType = period.getPeriodType();
        int year = period.getYear();
        int halfYear = period.getHalfYear();
        int month = period.getMonth();
        int quart = period.getQuarter();
        info.setYear(year);
        if (periodType != null) {
            if (periodType.getValue() == 1) {
                info.setPeriodType(RptPeriodTypeEnum.YEARLY);
                info.setPeriod((short)1);
            } else if (periodType.getValue() == 2) {
                info.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                info.setPeriod((short)halfYear);
            } else if (periodType.getValue() == 3) {
                info.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                info.setPeriod((short)quart);
            } else if (periodType.getValue() == 4) {
                info.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                info.setPeriod((short)month);
            } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                info.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                info.setPeriod((short)month);
            }
        }
    }

    public static void replaceSplitInfo(Book newBook, Book oldBook) {
        if (newBook == null || oldBook == null) {
            return;
        }
        ViewSplitInfo newSplitInfo = null;
        ViewSplitInfo oldSplitInfo = null;
        int oldSheetCount = oldBook.getSheetCount();
        for (int i = 0; i < oldSheetCount; ++i) {
            if (newBook.getSheet(i).getSheetOption() == null || oldBook.getSheet(i).getSheetOption() == null) continue;
            newSplitInfo = newBook.getSheet(i).getSheetOption().getViewSplitInfo();
            oldSplitInfo = oldBook.getSheet(i).getSheetOption().getViewSplitInfo();
            if (newSplitInfo == null || oldSplitInfo == null) continue;
            newSplitInfo.setFreezed(oldSplitInfo.isFreezed());
            newSplitInfo.setFirstRow(oldSplitInfo.getFirstRow());
            newSplitInfo.setFirstRow2(oldSplitInfo.getFirstRow2());
            newSplitInfo.setFirstCol(oldSplitInfo.getFirstCol());
            newSplitInfo.setFirstCol2(oldSplitInfo.getFirstCol2());
            newSplitInfo.setActivePane(oldSplitInfo.getActivePane());
            newSplitInfo.setColFixLine(oldSplitInfo.getColFixLine());
            newSplitInfo.setColSplit(oldSplitInfo.getColSplit());
            newSplitInfo.setRowFixLine(oldSplitInfo.getRowFixLine());
            newSplitInfo.setRowSplit(oldSplitInfo.getRowSplit());
        }
    }

    public static void replaceSplitInfo(BgTemplateInfo bgTemplate, Book oldBook, Boolean isUpdate) throws Exception {
        if (bgTemplate == null || oldBook == null) {
            return;
        }
        Book book = bgTemplate.getBook();
        if (book == null) {
            return;
        }
        BgNFSHelper.replaceSplitInfo(book, oldBook);
        bgTemplate.setData(IOHelper.packBook((Book)book));
        if (isUpdate.booleanValue()) {
            BgTemplateFactory.getRemoteInstance().updateDataInfo((IObjectValue)bgTemplate);
        }
    }

    public static void replaceSplitInfo(BgFormInfo bgFormInfo, Book oldBook) throws Exception {
        if (bgFormInfo == null || oldBook == null) {
            return;
        }
        Book book = bgFormInfo.getBook();
        if (book == null) {
            return;
        }
        BgNFSHelper.replaceSplitInfo(book, oldBook);
        bgFormInfo.setData(IOHelper.packBook((Book)book));
    }

    public static void replaceSplitInfo(BgActualRecordInfo bgFormInfo, Book oldBook) throws Exception {
        if (bgFormInfo == null || oldBook == null) {
            return;
        }
        Book book = bgFormInfo.getBook();
        if (book == null) {
            return;
        }
        BgNFSHelper.replaceSplitInfo(book, oldBook);
        bgFormInfo.setData(IOHelper.packBook((Book)book));
    }

    public static ViewSplitInfo transStrToSplit(String strSplit) {
        ViewSplitInfo info = new ViewSplitInfo();
        if (StringUtils.isEmpty((String)strSplit)) {
            return info;
        }
        String[] arr = strSplit.split(BgBaseConstants.SEP_THR_STR);
        if (arr.length != 10) {
            return info;
        }
        info.setFirstRow(Integer.valueOf(arr[0]).intValue());
        info.setFirstCol(Integer.valueOf(arr[1]).intValue());
        info.setFirstRow2(Integer.valueOf(arr[2]).intValue());
        info.setFirstCol2(Integer.valueOf(arr[3]).intValue());
        info.setColSplit(Integer.valueOf(arr[4]).intValue());
        info.setRowSplit(Integer.valueOf(arr[5]).intValue());
        info.setActivePane(Integer.valueOf(arr[6]).intValue());
        info.setFreezed(Boolean.valueOf(arr[7]).booleanValue());
        info.setColFixLine(Integer.valueOf(arr[8]).intValue());
        info.setRowFixLine(Integer.valueOf(arr[9]).intValue());
        return info;
    }

    public static String transSplitToStr(ViewSplitInfo info) {
        if (info == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(info.getFirstRow())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getFirstCol())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getFirstRow2())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getFirstCol2())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getColSplit())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getRowSplit())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getActivePane())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.isFreezed())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getColFixLine())).append(BgBaseConstants.SEP_THR_STR).append(String.valueOf(info.getRowFixLine()));
        return sb.toString();
    }

    public static String[] getBgPeriodInfo(Cell cell) {
        Map _tmpMap;
        if (cell == null) {
            return null;
        }
        String[] _tmpInfo = null;
        Object obj = cell.getUserObjectValue("CELL_DATA");
        if (obj != null && obj instanceof Map && (_tmpMap = (Map)obj).containsKey("bgFillType") && "bgFillValueType_period".equals(obj = _tmpMap.get("bgFillType"))) {
            _tmpInfo = new String[2];
            obj = _tmpMap.get("bgFillType");
            _tmpInfo[0] = obj != null ? (String)obj : null;
            obj = _tmpMap.get("bgFillValue");
            _tmpInfo[1] = obj != null ? (String)obj : null;
        }
        return _tmpInfo;
    }

    public static boolean checkBookHasFormula(Book book) {
        if (book == null) {
            return false;
        }
        Sheet sheet = null;
        Cell cell = null;
        Object formulaStr = null;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            rowCount = sheet.getMaxRowIndex();
            colCount = sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Book setFormAddNewSign(BgFormInfo bgFormInfo, Book book) throws BOSException {
        if (bgFormInfo == null) {
            return book;
        }
        boolean isSelfTemplate = true;
        BgTemplateInfo bgTemplate = bgFormInfo.getBgTemplate();
        isSelfTemplate = bgTemplate != null && bgTemplate.getBgType() != null && bgTemplate.getBgType().getId().toString().equals("bgMAAAAKIcA7rHKd");
        if (isSelfTemplate) {
            return book;
        }
        try {
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
            Sheet sheet = null;
            Cell cell = null;
            Object _formulaStr = null;
            for (int s = 0; s < book.getSheetCount(); ++s) {
                sheet = book.getSheet(s);
                BgNFSHelper.replaceSheetSign(sheet);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        cell = sheet.getCell(r, c, false);
                        if (cell == null) continue;
                        BgNFSHelper.setCellData(cell, "CELL_FROM_TEMPLATE", Boolean.TRUE);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return book;
    }

    public static boolean isCellFromTemplate(Cell cell) {
        boolean isCellFromTempalte = false;
        if (cell == null) {
            return isCellFromTempalte;
        }
        if (BgNFSHelper.getCellData(cell, "CELL_FROM_TEMPLATE") instanceof Boolean) {
            isCellFromTempalte = (Boolean)BgNFSHelper.getCellData(cell, "CELL_FROM_TEMPLATE");
        }
        return isCellFromTempalte;
    }

    public static void updateSignByTemplate(BgFormInfo bgFormInfo, Book book) throws BOSException {
        if (bgFormInfo == null) {
            return;
        }
        boolean isSelfTemplate = true;
        BgTemplateInfo bgTemplate = bgFormInfo.getBgTemplate();
        isSelfTemplate = bgTemplate != null && bgTemplate.getBgType() != null && bgTemplate.getBgType().getId().toString().equals("bgMAAAAKIcA7rHKd");
        if (!(0 != bgFormInfo.getBgTemplate().getFormType().getValue() && 8 != bgFormInfo.getBgTemplate().getFormType().getValue() || isSelfTemplate)) {
            try {
                bgFormInfo.setBook(BgNFSHelper.setFormAddNewSign(bgFormInfo, book));
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static void loadAdjustMap(Map adjustData, Map adjustMap, String orgUnitId, String userId) {
        if (adjustData == null || adjustMap == null || orgUnitId == null) {
            return;
        }
        HashMap<String, BgAdjustFormDiversityData> dataMap = (HashMap<String, BgAdjustFormDiversityData>)adjustMap.get(orgUnitId);
        if (dataMap == null) {
            dataMap = new HashMap<String, BgAdjustFormDiversityData>();
            adjustMap.put(orgUnitId, dataMap);
        }
        Iterator it = adjustData.keySet().iterator();
        while (it.hasNext()) {
            BgNDataInfo dataInfo = (BgNDataInfo)adjustData.get(it.next());
            if (dataMap.containsKey(dataInfo.getFormula())) {
                ((BgAdjustFormDiversityData)dataMap.get(dataInfo.getFormula())).setNewValue(dataInfo.getAdjustValue());
                continue;
            }
            BgAdjustFormDiversityData divData = new BgAdjustFormDiversityData();
            divData.setFormula(dataInfo.getFormula());
            divData.setNewValue(dataInfo.getAdjustValue());
            divData.setOldValue(dataInfo.getBudgetValue() == null ? new BigDecimal("0.00") : dataInfo.getBudgetValue());
            divData.setAdjustor(userId);
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
            dataMap.put(dataInfo.getFormula(), divData);
        }
    }

    public static void loadAdjustMapForMultiOrg(Map adjustData, Map adjustMap, Set<String> orgIdSet, String userId) {
        if (adjustData == null || adjustMap == null || orgIdSet == null || orgIdSet.isEmpty() || StringUtils.isEmpty((String)userId)) {
            return;
        }
        String orgId2 = null;
        BgNDataInfo dataInfo = null;
        BgAdjustFormDiversityData divData = null;
        HashMap<String, BgAdjustFormDiversityData> dataMap = null;
        Object afjustDataItem = null;
        for (String orgId2 : orgIdSet) {
            if (StringUtils.isEmpty((String)orgId2)) continue;
            dataMap = (HashMap<String, BgAdjustFormDiversityData>)adjustMap.get(orgId2);
            if (dataMap == null) {
                dataMap = new HashMap<String, BgAdjustFormDiversityData>();
                adjustMap.put(orgId2, dataMap);
            }
            if ((afjustDataItem = adjustData.get(orgId2)) == null || !(afjustDataItem instanceof Map)) continue;
            Iterator it = ((Map)afjustDataItem).keySet().iterator();
            while (it.hasNext()) {
                dataInfo = (BgNDataInfo)((Map)afjustDataItem).get(it.next());
                if (StringUtils.isEmpty((String)dataInfo.getOrgUnitId()) || !orgId2.equals(dataInfo.getOrgUnitId())) continue;
                if (dataMap.containsKey(dataInfo.getFormula())) {
                    ((BgAdjustFormDiversityData)dataMap.get(dataInfo.getFormula())).setNewValue(dataInfo.getAdjustValue());
                    continue;
                }
                divData = new BgAdjustFormDiversityData();
                divData.setFormula(dataInfo.getFormula());
                divData.setNewValue(dataInfo.getAdjustValue());
                divData.setOldValue(dataInfo.getBudgetValue() == null ? new BigDecimal("0.00") : dataInfo.getBudgetValue());
                divData.setAdjustor(userId);
                divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
                dataMap.put(dataInfo.getFormula(), divData);
            }
        }
    }

    public static void stopSheetProtection(SheetOption sheetOption) {
        if (sheetOption == null) {
            return;
        }
        Protection pro = sheetOption.getProtection(false);
        if (pro != null) {
            if (pro.isProtected()) {
                pro.stop("");
            }
            if (pro.isProtected()) {
                pro.stop("abcdefghijklmnopqrstuvwxyz123456789987654321");
            }
            pro.deleteOperations();
        }
    }

    public static BigDecimal addBigDecimal(BigDecimal result, BigDecimal value) {
        if (value == null) {
            return result;
        }
        if (result == null) {
            return value;
        }
        return result.add(value);
    }

    public static BigDecimal calFlexParam(BigDecimal value, BigDecimal flexParam) {
        if (value == null || flexParam == null) {
            return value;
        }
        return value.multiply(flexParam);
    }

    public static Book dealWithBookMeasure(BgFormInfo info) throws Exception {
        Book _book = info.getBook();
        BgNFSHelper.disableCal(_book);
        Sheet _sheet = null;
        Cell _cell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _tmpCoefficient = null;
        BigDecimal _coefficient = info.getMeasureUnit() != null ? info.getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        HashMap<String, BigDecimal> _muMap = new HashMap<String, BigDecimal>();
        if (info.getBgMeasureUnit() != null) {
            BgMeasureUnitInfo _muInfo = null;
            Iterator mes = info.getBgMeasureUnit().iterator();
            while (mes.hasNext()) {
                _muInfo = (BgMeasureUnitInfo)mes.next();
                if (_muInfo == null || _muInfo.getBgElement() == null || StringUtils.isEmpty((String)_muInfo.getBgElement().getNumber()) || _muInfo.getMeasureUnit() == null || _muInfo.getMeasureUnit().getCoefficient() == null) continue;
                _muMap.put(_muInfo.getBgElement().getNumber(), _muInfo.getMeasureUnit().getCoefficient());
            }
        }
        Boolean isRateElement = false;
        Object _bgAccountNumber = null;
        Object viewNumberFormat = null;
        boolean hasRowObject = false;
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            hasRowObject = false;
            if (_sheet.isHide()) {
                _book.removeSheet(new Integer(_sheetIndex).intValue());
                continue;
            }
            _rowCount = _sheet.getMaxRowIndex() + 1;
            _colCount = _sheet.getMaxColIndex() + 1;
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (BgNFSHelper.checkIsEmptyContext(_cell)) continue;
                    _tmpCoefficient = _coefficient;
                    if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                        _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(null, _formulaStr))[2])) {
                            _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                        }
                        if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                            try {
                                _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        } else {
                            _value = BgNConstants.ZERO;
                        }
                        if (!BgNFSHelper.checkHasPercentage(_cell)) {
                            _value = _value.divide(_tmpCoefficient, 8, 4);
                        }
                        BgNFSHelper.setValue(_cell, _value);
                        continue;
                    }
                    if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                        _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                        if (_muMap != null && !_muMap.isEmpty() && _muMap.containsKey((_parameter = BgNFSHelper.parseFormulaPara(null, _formulaStr))[2])) {
                            _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                        }
                        if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                            try {
                                _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        } else {
                            _value = BgNConstants.ZERO;
                        }
                        _value = _value.divide(_tmpCoefficient, 8, 4);
                        BgNFSHelper.setValue(_cell, _value);
                        continue;
                    }
                    if (BgNFSHelper.checkHasExpression(_cell)) {
                        if (_cell.getValue() == null || !(_cell.getValue().getValue() instanceof BigDecimal) || BgNFSHelper.checkHasPercentage(_cell)) continue;
                        _value = ((BigDecimal)_cell.getValue().getValue()).divide(_tmpCoefficient, 8, 4);
                        BgNFSHelper.setValue(_cell, _value);
                        continue;
                    }
                    if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                        _obj = _cell.getValue().getValue();
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                            _value = _value.divide(_tmpCoefficient, 8, 4);
                            BgNFSHelper.setValue(_cell, _value);
                            continue;
                        }
                        if (_obj instanceof Calendar) {
                            BgNFSHelper.setValue(_cell, _cell.getText());
                            continue;
                        }
                        if (_obj instanceof Date) {
                            BgNFSHelper.setValue(_cell, _cell.getText());
                            continue;
                        }
                        if (BgNFSHelper.checkIsNumericOfCell(_cell)) {
                            try {
                                _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                            _value = _value.divide(_tmpCoefficient, 8, 4);
                            BgNFSHelper.setValue(_cell, _value);
                            continue;
                        }
                        String value = _obj.toString();
                        if (_colIndex == 0 && _cell.getUserObject("NELevel") != null) {
                            int level = (Integer)_cell.getUserObject("NELevel").getValue();
                            for (int i = 0; i < level; ++i) {
                                value = "  " + value;
                            }
                        }
                        BgNFSHelper.setValue(_cell, value);
                        continue;
                    }
                    if (_cell.getValue().getValue() instanceof Calendar) continue;
                    if (_cell.getValue() != null && _cell.getValue().getValue() instanceof BigDecimal && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                        if (BgNFSHelper.checkHasPercentage(_cell)) continue;
                        _value = ((BigDecimal)_cell.getValue().getValue()).divide(_tmpCoefficient, 8, 4);
                        BgNFSHelper.setValue(_cell, _value);
                        continue;
                    }
                    BgNFSHelper.setValue(_cell, _cell.getValue().getValue().toString());
                }
            }
        }
        return _book;
    }

    public static Map getFormulaMapOfBook(Book book) {
        return BgNFSHelper.getFormulaMapOfBook(book, null);
    }

    public static Map getFormulaMapOfBook(Book book, String[] sheetNames) {
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return formulaMap;
        }
        String formulaStr = null;
        StringBuffer _tmpKey = null;
        BigDecimal value = null;
        Sheet _sheet = null;
        Cell _cell = null;
        Object _obj = null;
        List sheetList = BgNFSHelper.toList(sheetNames);
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            if (!sheetList.isEmpty() && !sheetList.contains(_sheet.getSheetName())) continue;
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    value = null;
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _tmpKey = new StringBuffer(formulaStr);
                    _obj = BgNFSHelper.getValue(_cell);
                    if (_obj != null) {
                        try {
                            value = new BigDecimal(_obj.toString());
                        }
                        catch (Exception e) {
                            value = BgNConstants.ZERO;
                        }
                    }
                    formulaMap.put(_tmpKey.toString(), value);
                }
            }
        }
        return formulaMap;
    }

    public static String getNumberKey(String id, int sheetIndex, String dimNumber) {
        return id + "_" + sheetIndex + "_" + dimNumber;
    }

    public static KDSBook exportExcel(Context ctx, Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        Book _book = (Book)parameter.get("EXPORT_BOOK");
        BgNFSHelper.stopBookProtection(_book);
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
        }
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        Integer displayModel = 0;
        if (parameter.get("DISPLAYMODE") != null) {
            displayModel = (Integer)parameter.get("DISPLAYMODE");
        }
        Object _obj = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _tmpCoefficient = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("EXPORT_COEFFICIENT");
        if (_coefficient == null || displayModel != 0) {
            _coefficient = BgNConstants.ONE;
            if (displayModel == 2) {
                _coefficient = BgNConstants.THOUSAND;
            } else if (displayModel == 4) {
                _coefficient = BgNConstants.TEN_THOUSAND;
            }
        }
        Map _muMap = (Map)parameter.get("EXPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("EXPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("EXPORT_DATA");
        boolean isProcessTitle = Boolean.TRUE.equals(parameter.get("isProcessTitle"));
        String[] exportSheetNames = (String[])parameter.get("EXPORT_SHEET");
        boolean _isUnMerge = Boolean.TRUE.equals(parameter.get("EXPORT_ROW_MEMBER_UNMERGE"));
        String viewlistValue = null;
        Boolean isRateElement = false;
        String eleNumber = null;
        String _bgAccountNumber = null;
        String viewNumberFormat = null;
        MbgViewlistMeasureUnitHelper viewlistMeasureUnitHelper = null;
        if (parameter.get("MbgViewlistMeasureUnitHelper") != null) {
            viewlistMeasureUnitHelper = (MbgViewlistMeasureUnitHelper)parameter.get("MbgViewlistMeasureUnitHelper");
        }
        _book = BgNFSHelper.exportBgSpecialItems(ctx, _book, parameter);
        _kdsBook = BookToKDSBook.traslate((Book)_book);
        boolean hasRowObject = false;
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            hasRowObject = false;
            _kdsSheet = _kdsBook.getSheet((Object)new Integer(_sheetIndex));
            _kdsSheet.setProtection(null);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    CellBlock _mergeBlock;
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    BgNFSHelper.checkCellBorder(_sheet, _rowIndex, _colIndex);
                    _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                    if (!BgNFSHelper.checkIsEmptyContext(_cell)) {
                        if (_hasData) {
                            Range range;
                            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes newStyle;
                            _tmpCoefficient = _coefficient;
                            if (BgNFSHelper.getCellData(_cell, "bgFillType") != null) {
                                _kdsSheet.setCellValue(_rowIndex, _colIndex, _cell.getValue().getValue());
                            } else if (BgNFSHelper.checkHasTextOfCell(_cell)) {
                                boolean isNum;
                                if (viewlistMeasureUnitHelper != null && (isNum = MbgViewListDescriptionHelper.checkCellViewListDescriptionIsNumeric(_cell))) {
                                    _kdsSheet.getCellStyleAttributes(_rowIndex, _colIndex).setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                }
                                _kdsSheet.setCellValue(_rowIndex, _colIndex, _cell.getValue().getValue());
                            } else if (BgNFSHelper.checkHasPercentage(_cell)) {
                                _kdsCell.setText(_cell.getText());
                            } else if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty()) {
                                    _parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr);
                                    if (_muMap.containsKey(_parameter[2])) {
                                        _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                    }
                                } else if (viewlistMeasureUnitHelper != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
                                    _bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue());
                                    if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                        if (_bgAccountNumber != null && !MBGViewListFormCommonHelper.checkElementRateOrPrice(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap)) {
                                            _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, null);
                                        }
                                    } else {
                                        eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                        _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, eleNumber);
                                    }
                                }
                                if (displayModel != 0) {
                                    _tmpCoefficient = BgNConstants.ONE;
                                    if (displayModel == 2) {
                                        _tmpCoefficient = BgNConstants.THOUSAND;
                                    } else if (displayModel == 4) {
                                        _tmpCoefficient = BgNConstants.TEN_THOUSAND;
                                    }
                                }
                                if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                    _value = (BigDecimal)_obj;
                                } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                } else {
                                    _value = BgNConstants.ZERO;
                                }
                                if (viewlistMeasureUnitHelper != null && !StringUtils.isEmpty((String)_bgAccountNumber)) {
                                    if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                        isRateElement = MBGViewListFormCommonHelper.checkRateElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    } else {
                                        eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    }
                                    viewNumberFormat = viewlistMeasureUnitHelper.getDataNumberFormate(_bgAccountNumber, isRateElement, eleNumber);
                                    viewlistValue = viewlistMeasureUnitHelper.getDisplayValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                    if (!viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe() && eleNumber != null && viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                                        Object[] object = viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().get(eleNumber);
                                        viewlistMeasureUnitHelper.getTemplateStyle().setDataNegativeIndex((Integer)object[2]);
                                        String numberFormat = viewlistMeasureUnitHelper.getTemplateStyle().toNumberPattern((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
                                        StyleAttributes styles = viewlistMeasureUnitHelper.getTemplateStyle().getDataStyleAttributes();
                                        newStyle = ViewListStyleHelper.convertStyle(styles);
                                        newStyle.setNumberFormat(numberFormat);
                                        newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                        range = _cell.getSheet().getRange(_cell);
                                        MBgTemplateHelper.setRangeStyle(range, newStyle, null);
                                    }
                                    if (!StringUtils.isEmpty((String)viewlistValue)) {
                                        if (viewlistValue.indexOf("%") > 0) {
                                            _kdsSheet.getCellStyleAttributes(_rowIndex, _colIndex).setNumberFormat(viewNumberFormat);
                                            _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_value, _kdsCell.getFormula(), (ShareStyleAttributes)_kdsSheet.getCellStyleAttributes(_rowIndex, _colIndex), viewlistValue);
                                        } else {
                                            try {
                                                _value = viewlistMeasureUnitHelper.getBigDecimalValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                                _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_value, _kdsCell.getFormula(), _cell.getSSA(), viewlistValue);
                                            }
                                            catch (NumberFormatException ex) {
                                                logger.error((Object)("error value NumberFormatException:" + viewlistValue + "****" + _cell));
                                            }
                                        }
                                    }
                                } else {
                                    if (!BgNFSHelper.checkHasPercentage(_cell)) {
                                        _value = _value.divide(_tmpCoefficient, 8, 4);
                                    }
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                                }
                            } else if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                                _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                                if (_muMap != null && !_muMap.isEmpty()) {
                                    _parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr);
                                    if (_muMap.containsKey(_parameter[2])) {
                                        _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                    }
                                } else if (viewlistMeasureUnitHelper != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
                                    _bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue());
                                    if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                        if (_bgAccountNumber != null && !MBGViewListFormCommonHelper.checkElementRateOrPrice(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap)) {
                                            _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, null);
                                        }
                                    } else {
                                        eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                        _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, eleNumber);
                                    }
                                }
                                if (displayModel != 0) {
                                    _tmpCoefficient = BgNConstants.ONE;
                                    if (displayModel == 2) {
                                        _tmpCoefficient = BgNConstants.THOUSAND;
                                    } else if (displayModel == 4) {
                                        _tmpCoefficient = BgNConstants.TEN_THOUSAND;
                                    }
                                }
                                if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                    _value = (BigDecimal)_obj;
                                } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                    try {
                                        _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                } else {
                                    _value = BgNConstants.ZERO;
                                }
                                if (viewlistMeasureUnitHelper != null && !StringUtils.isEmpty((String)_bgAccountNumber)) {
                                    if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                        isRateElement = MBGViewListFormCommonHelper.checkRateElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    } else {
                                        eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    }
                                    viewNumberFormat = viewlistMeasureUnitHelper.getDataNumberFormate(_bgAccountNumber, isRateElement, eleNumber);
                                    viewlistValue = viewlistMeasureUnitHelper.getDisplayValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                    if (!viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe() && eleNumber != null && viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                                        Object[] object = viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().get(eleNumber);
                                        viewlistMeasureUnitHelper.getTemplateStyle().setDataNegativeIndex((Integer)object[2]);
                                        String numberFormat = viewlistMeasureUnitHelper.getTemplateStyle().toNumberPattern((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
                                        StyleAttributes styles = viewlistMeasureUnitHelper.getTemplateStyle().getDataStyleAttributes();
                                        newStyle = ViewListStyleHelper.convertStyle(styles);
                                        newStyle.setNumberFormat(numberFormat);
                                        newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                        range = _cell.getSheet().getRange(_cell);
                                        MBgTemplateHelper.setRangeStyle(range, newStyle, null);
                                    }
                                    if (!StringUtils.isEmpty((String)viewlistValue)) {
                                        if (viewlistValue.indexOf("%") > 0) {
                                            _kdsSheet.getCellStyleAttributes(_rowIndex, _colIndex).setNumberFormat(viewNumberFormat);
                                            _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_value, (ShareStyleAttributes)_kdsSheet.getCellStyleAttributes(_rowIndex, _colIndex), viewlistValue);
                                        } else {
                                            try {
                                                viewlistValue = viewlistValue.trim();
                                                _value = viewlistValue.indexOf("(") >= 0 && viewlistValue.indexOf(")") >= 0 ? new BigDecimal(viewlistValue.replaceAll(",", "").replaceAll("\\(", "").replaceAll("\\)", "")).multiply(BgNConstants.NEG_ONE) : new BigDecimal(viewlistValue.replaceAll(",", ""));
                                            }
                                            catch (NumberFormatException ex) {
                                                logger.error((Object)("error value NumberFormatException:" + viewlistValue + "****" + _cell));
                                            }
                                            _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_value, _cell.getSSA(), viewlistValue);
                                        }
                                    }
                                } else {
                                    _value = _value.divide(_tmpCoefficient, 8, 4);
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                                }
                            } else if (BgNFSHelper.checkHasExpression(_cell)) {
                                if (_muMap != null) {
                                    BgNFSHelper.exportExpressionValue(_cell, _kdsSheet, _tmpCoefficient, _muMap);
                                } else if (viewlistMeasureUnitHelper != null && ViewListHelper.getCalculatorDataStyle(_cell) != null && (_obj = _cell.getValue().getValue()) instanceof BigDecimal && !StringUtils.isEmpty((String)(viewlistValue = viewlistMeasureUnitHelper.getCalcDisplayValue(_cell, _obj)))) {
                                    if (viewlistValue.indexOf("%") > 0) {
                                        _kdsSheet.setCell(_rowIndex, _colIndex, (Object)viewlistValue, _cell.getSSA(), viewlistValue);
                                    } else {
                                        try {
                                            viewlistValue = viewlistValue.trim();
                                            _value = viewlistValue.indexOf("(") >= 0 && viewlistValue.indexOf(")") >= 0 ? new BigDecimal(viewlistValue.replaceAll(",", "").replaceAll("\\(", "").replaceAll("\\)", "")).multiply(BgNConstants.NEG_ONE) : new BigDecimal(viewlistValue.replaceAll(",", ""));
                                        }
                                        catch (NumberFormatException ex) {
                                            logger.error((Object)("error value NumberFormatException:" + viewlistValue + "****" + _cell));
                                        }
                                        _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_value, _cell.getSSA(), viewlistValue);
                                        _kdsSheet.getCell(_rowIndex, _colIndex, false).setFormula(_cell.getFormula());
                                    }
                                }
                            } else if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                                _obj = _cell.getValue().getValue();
                                if (_obj instanceof BigDecimal) {
                                    _value = (BigDecimal)_obj;
                                    _value = _value.divide(_tmpCoefficient, 8, 4);
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                                } else if (_obj instanceof Calendar) {
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_cell.getText());
                                } else if (_obj instanceof Date) {
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_cell.getText());
                                } else if (BgNFSHelper.checkIsNumericOfCell(_cell)) {
                                    try {
                                        _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                    }
                                    catch (Exception ex) {
                                        _value = BgNConstants.ZERO;
                                    }
                                    _value = _value.divide(_tmpCoefficient, 8, 4);
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_value);
                                } else {
                                    String value = _obj.toString();
                                    if (_colIndex == 0 && _cell.getUserObject("NELevel") != null) {
                                        int level = (Integer)_cell.getUserObject("NELevel").getValue();
                                        for (int i = 0; i < level; ++i) {
                                            value = "  " + value;
                                        }
                                    }
                                    _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)value);
                                }
                            } else if (!(_cell.getValue().getValue() instanceof Calendar)) {
                                _kdsSheet.setCellValue(_rowIndex, _colIndex, (Object)_cell.getValue().getValue().toString());
                            }
                        }
                        if (_kdsCell == null || BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                            // empty if block
                        }
                    }
                    if (!_isUnMerge || _cell == null || _kdsCell == null || !_kdsCell.isMerged() || (_mergeBlock = _sheet.getMergeBlock(_cell)) == null || !Boolean.TRUE.equals(_sheet.getRange(_mergeBlock).getUserObject("row_member_merge"))) continue;
                    Object value = BgNFSHelper.getValue(_cell);
                    _kdsSheet.getMerges().remove(_rowIndex, _colIndex);
                    for (int r = _mergeBlock.getRow(); r <= _mergeBlock.getRow2(); ++r) {
                        for (int c = _mergeBlock.getCol(); c <= _mergeBlock.getCol2(); ++c) {
                            _kdsSheet.getCell(r, c, true).setValue(value);
                        }
                    }
                }
                if (!isProcessTitle || hasRowObject) continue;
                if (ViewListHelper.getDimension(_sheet.getRow(_rowIndex, false)) != null) {
                    hasRowObject = true;
                    continue;
                }
                _cell = _sheet.getCell(_rowIndex, 0, false);
                String title = ViewListTitleRenderBase.getTitle(_cell);
                if (StringUtils.isEmpty((String)title)) continue;
                _kdsSheet.getCell(_rowIndex, 0, true).setValue((Object)title);
                _cell.setSSA((ShareStyleAttributes)ViewListTitleRenderBase.getStyle(_cell.getStyle(), ViewListTitleRenderBase.getAlign(_cell).getValue()));
                _kdsSheet.setCell(_rowIndex, 0, (Object)title, _cell.getSSA());
            }
        }
        return _kdsBook;
    }

    private static void exportExpressionValue(Cell cell, KDSSheet kdsSheet, BigDecimal coefficient, Map muMap) {
        Object _obj;
        if (cell == null) {
            return;
        }
        String _expressions = BgNFSHelper.getExpression(cell);
        Expression _expression = null;
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean re = BgNFSHelper.exportExpressionValue(cell, kdsSheet, _expression, coefficient, muMap);
        if (!re && (_obj = BgNFSHelper.getValue(cell)) != null) {
            BigDecimal _value = null;
            if (_obj instanceof BigDecimal) {
                _value = (BigDecimal)_obj;
                _value = _value.divide(coefficient, 8, 4);
                kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
            } else if (_obj instanceof Calendar) {
                kdsSheet.setCellValue(cell.getRow(), cell.getCol(), _obj);
            } else {
                try {
                    _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                    _value = _value.divide(coefficient, 8, 4);
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
                }
                catch (Exception ex) {
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_obj.toString());
                }
            }
        }
    }

    private static boolean exportExpressionValue(Cell cell, KDSSheet kdsSheet, Expression expression, BigDecimal coefficient, Map muMap) {
        boolean re = false;
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if ("bgformula".equalsIgnoreCase(_funcionName) || "bgactuals".equalsIgnoreCase(_funcionName) || "bgbal".equalsIgnoreCase(_funcionName) || "bgadjust".equalsIgnoreCase(_funcionName) || "bgAvlBal".equalsIgnoreCase(_funcionName) || "bgactualext".equalsIgnoreCase(_funcionName)) {
                Object _obj;
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                BigDecimal _coefficient = coefficient;
                BigDecimal _value = null;
                if (muMap.containsKey(_bgelement.value)) {
                    _coefficient = (BigDecimal)muMap.get(_bgelement.value);
                }
                if ((_obj = BgNFSHelper.getValue(cell)) != null) {
                    if (_obj instanceof BigDecimal) {
                        _value = (BigDecimal)_obj;
                        _value = _value.divide(_coefficient, 8, 4);
                    } else {
                        try {
                            _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                            _value = _value.divide(_coefficient, 8, 4);
                        }
                        catch (Exception ex) {
                            _value = BgNConstants.ZERO;
                        }
                    }
                    kdsSheet.setCellValue(cell.getRow(), cell.getCol(), (Object)_value);
                }
                re = true;
            }
        } else if (expression instanceof BinaryOperationExpr && !(re = BgNFSHelper.exportExpressionValue(cell, kdsSheet, ((BinaryOperationExpr)expression).left, coefficient, muMap))) {
            re = BgNFSHelper.exportExpressionValue(cell, kdsSheet, ((BinaryOperationExpr)expression).right, coefficient, muMap);
        }
        return re;
    }

    public static void checkCellBorder(Sheet sheet, int r, int c) {
        try {
            Range rg = sheet.getRange(r, c);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes saInnerBorder = Styles.getEmptySA();
            rg.getStyle(sa, saInnerBorder);
            if (rg.isSingleCell() && Styles.getSA((com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes)sa).hasBordersAttributes() && sheet.getCell(r, c, false) == null) {
                sheet.getCell(r, c, true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"BgNFChelper checkCellBorder error:", (Throwable)e);
        }
    }

    protected static Book exportBgSpecialItems(Context ctx, Book _book, Map parameter) {
        if (parameter.get("bgSpecialItems") == null) {
            return _book;
        }
        Sheet _sheet = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        try {
            _book = IOHelper.unpackBook((byte[])IOHelper.packBook((Book)_book));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        IBgSpecialItemsInfo specialItems = (IBgSpecialItemsInfo)((IObjectCollection)parameter.get("bgSpecialItems")).getObject(0);
        String[] dimensions = specialItems.getDimensionNameAsAlias().split(",");
        String[] members = specialItems.getMemberName().split(DimensionConstants.TICK_SEPARATOR);
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
        }
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            Row newRow = BgNFSHelper.addRow(_sheet, 0, false);
            String spTitle = null;
            spTitle = ctx == null ? EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"specialItems") : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"specialItems", (Locale)ctx.getLocale());
            newRow.getCell(0, true).setValue(new Variant((Object)spTitle));
            for (int i = 0; i < dimensions.length; ++i) {
                newRow.getCell(i + 1, true).setValue(new Variant((Object)(dimensions[i] + ":" + members[i])));
            }
        }
        return _book;
    }

    public static Book exportExcel2007(Context ctx, Map parameter) {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        Book book = (Book)parameter.get("EXPORT_BOOK");
        Book _book = BgNFSHelper.copyBook2007(book);
        _book.getProtection().setEncryptedPassword("");
        _book.getProtection().stop();
        for (int s = 0; s < book.getSheetCount(); ++s) {
            if (_book.getSheet(s).getSheetOption().getProtection(false) == null) continue;
            _book.getSheet(s).getSheetOption().getProtection(false).setEncryptedPassword("");
            _book.getSheet(s).getSheetOption().getProtection(false).stop();
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        Integer displayModel = 0;
        if (parameter.get("DISPLAYMODE") != null) {
            displayModel = (Integer)parameter.get("DISPLAYMODE");
        }
        Object _obj = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BigDecimal _tmpCoefficient = null;
        BigDecimal _coefficient = (BigDecimal)parameter.get("EXPORT_COEFFICIENT");
        if (_coefficient == null || displayModel != 0) {
            _coefficient = BgNConstants.ONE;
            if (displayModel == 2) {
                _coefficient = BgNConstants.THOUSAND;
            } else if (displayModel == 4) {
                _coefficient = BgNConstants.TEN_THOUSAND;
            }
        }
        Map _muMap = (Map)parameter.get("EXPORT_MEASUREUNIT");
        Map _formulaMap = (Map)parameter.get("EXPORT_BGFORMULA");
        boolean _hasData = (Boolean)parameter.get("EXPORT_DATA");
        boolean isProcessTitle = Boolean.TRUE.equals(parameter.get("isProcessTitle"));
        boolean _isUnMerge = Boolean.TRUE.equals(parameter.get("EXPORT_ROW_MEMBER_UNMERGE"));
        boolean isOutOfFormExport = false;
        if (parameter.containsKey("isOutOfFormExport")) {
            isOutOfFormExport = true;
        }
        String viewlistValue = null;
        Boolean isRateElement = false;
        String eleNumber = null;
        String _bgAccountNumber = null;
        String viewNumberFormat = null;
        MbgViewlistMeasureUnitHelper viewlistMeasureUnitHelper = null;
        if (parameter.get("MbgViewlistMeasureUnitHelper") != null) {
            viewlistMeasureUnitHelper = (MbgViewlistMeasureUnitHelper)parameter.get("MbgViewlistMeasureUnitHelper");
        }
        _book = BgNFSHelper.exportBgSpecialItems(ctx, _book, parameter);
        BgNFSHelper.disableCal(_book);
        boolean hasRowObject = false;
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            hasRowObject = false;
            Range displayModeRange = null;
            _rowCount = _sheet.getMaxRowIndex() + 1;
            _colCount = _sheet.getMaxColIndex() + 1;
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    BgNFSHelper.checkCellBorder(_sheet, _rowIndex, _colIndex);
                    if (!BgNFSHelper.checkIsEmptyContext(_cell) && _hasData) {
                        Range range;
                        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes newStyle;
                        _tmpCoefficient = _coefficient;
                        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
                            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                            if (_muMap != null && !_muMap.isEmpty()) {
                                _parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr);
                                if (_muMap.containsKey(_parameter[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                            } else if (viewlistMeasureUnitHelper != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
                                _bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue());
                                if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                    if (_bgAccountNumber != null && !MBGViewListFormCommonHelper.checkElementRateOrPrice(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap)) {
                                        _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, null);
                                    }
                                } else {
                                    eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, eleNumber);
                                }
                            }
                            if (displayModel != 0) {
                                _tmpCoefficient = BgNConstants.ONE;
                                if (displayModel == 2) {
                                    _tmpCoefficient = BgNConstants.THOUSAND;
                                } else if (displayModel == 4) {
                                    _tmpCoefficient = BgNConstants.TEN_THOUSAND;
                                }
                            }
                            if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                            } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                try {
                                    _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                            } else {
                                _value = BgNConstants.ZERO;
                            }
                            if (viewlistMeasureUnitHelper != null && !StringUtils.isEmpty((String)_bgAccountNumber)) {
                                if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                    isRateElement = MBGViewListFormCommonHelper.checkRateElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                } else {
                                    eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                }
                                viewNumberFormat = viewlistMeasureUnitHelper.getDataNumberFormate(_bgAccountNumber, isRateElement, eleNumber);
                                viewlistValue = viewlistMeasureUnitHelper.getDisplayValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                if (!viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe() && eleNumber != null && viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                                    Object[] object = viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().get(eleNumber);
                                    viewlistMeasureUnitHelper.getTemplateStyle().setDataNegativeIndex((Integer)object[2]);
                                    String numberFormat = viewlistMeasureUnitHelper.getTemplateStyle().toNumberPattern((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
                                    StyleAttributes styles = viewlistMeasureUnitHelper.getTemplateStyle().getDataStyleAttributes();
                                    newStyle = ViewListStyleHelper.convertStyle(styles);
                                    newStyle.setNumberFormat(numberFormat);
                                    newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    range = _cell.getSheet().getRange(_cell);
                                    MBgTemplateHelper.setRangeStyle(range, newStyle, null);
                                }
                                if (!StringUtils.isEmpty((String)viewlistValue)) {
                                    if (viewlistValue.indexOf("%") > 0) {
                                        BgNFSHelper.setValue(_cell, viewlistValue);
                                    } else {
                                        try {
                                            _value = viewlistMeasureUnitHelper.getBigDecimalValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                            BgNFSHelper.setValue(_cell, _value);
                                        }
                                        catch (NumberFormatException ex) {
                                            logger.error((Object)("error value NumberFormat Exception:" + viewlistValue + "****" + _cell));
                                        }
                                    }
                                }
                            } else {
                                if (!BgNFSHelper.checkHasPercentage(_cell)) {
                                    _value = _value.divide(_tmpCoefficient, 8, 4);
                                }
                                BgNFSHelper.setValue(_cell, _value);
                            }
                        } else if (BgNFSHelper.checkHasGatFormulaOfCell(_cell)) {
                            _formulaStr = BgNFSHelper.getGatFormulaOfCell(_cell);
                            if (_muMap != null && !_muMap.isEmpty()) {
                                _parameter = BgNFSHelper.parseFormulaPara(_formulaMap, _formulaStr);
                                if (_muMap.containsKey(_parameter[2])) {
                                    _tmpCoefficient = (BigDecimal)_muMap.get(_parameter[2]);
                                }
                            } else if (viewlistMeasureUnitHelper != null && _cell.getUserObject("BGACCOUNT_NUMBER") != null && _cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
                                _bgAccountNumber = String.valueOf(_cell.getUserObject("BGACCOUNT_NUMBER").getValue());
                                if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                    if (_bgAccountNumber != null && !MBGViewListFormCommonHelper.checkElementRateOrPrice(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap)) {
                                        _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, null);
                                    }
                                } else {
                                    eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                    _tmpCoefficient = viewlistMeasureUnitHelper.getCoef(_bgAccountNumber, eleNumber);
                                }
                            }
                            if (displayModel != 0) {
                                _tmpCoefficient = BgNConstants.ONE;
                                if (displayModel == 2) {
                                    _tmpCoefficient = BgNConstants.THOUSAND;
                                } else if (displayModel == 4) {
                                    _tmpCoefficient = BgNConstants.TEN_THOUSAND;
                                }
                            }
                            if ((_obj = _cell.getValue().getValue()) instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                            } else if (BgNFSHelper.checkIsNumeric(_cell.getValue())) {
                                try {
                                    _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                            } else {
                                _value = BgNConstants.ZERO;
                            }
                            if (viewlistMeasureUnitHelper != null && !StringUtils.isEmpty((String)_bgAccountNumber)) {
                                if (viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe()) {
                                    isRateElement = MBGViewListFormCommonHelper.checkRateElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                } else {
                                    eleNumber = MBGViewListFormCommonHelper.getCellElement(_cell, viewlistMeasureUnitHelper.getElementObjMap(), _formulaMap);
                                }
                                viewNumberFormat = viewlistMeasureUnitHelper.getDataNumberFormate(_bgAccountNumber, isRateElement, eleNumber);
                                viewlistValue = viewlistMeasureUnitHelper.getDisplayValue(_value, _tmpCoefficient, 8, viewNumberFormat);
                                if (!viewlistMeasureUnitHelper.getTemplateStyle().isDataTYpe() && eleNumber != null && viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().containsKey(eleNumber)) {
                                    Object[] object = viewlistMeasureUnitHelper.getTemplateStyle().getEleMap().get(eleNumber);
                                    viewlistMeasureUnitHelper.getTemplateStyle().setDataNegativeIndex((Integer)object[2]);
                                    String numberFormat = viewlistMeasureUnitHelper.getTemplateStyle().toNumberPattern((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
                                    StyleAttributes styles = viewlistMeasureUnitHelper.getTemplateStyle().getDataStyleAttributes();
                                    newStyle = ViewListStyleHelper.convertStyle(styles);
                                    newStyle.setNumberFormat(numberFormat);
                                    newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                                    range = _cell.getSheet().getRange(_cell);
                                    MBgTemplateHelper.setRangeStyle(range, newStyle, null);
                                }
                                if (!StringUtils.isEmpty((String)viewlistValue)) {
                                    if (viewlistValue.indexOf("%") > 0) {
                                        BgNFSHelper.setValue(_cell, viewlistValue);
                                    } else {
                                        try {
                                            viewlistValue = viewlistValue.trim();
                                            _value = viewlistValue.indexOf("(") >= 0 && viewlistValue.indexOf(")") >= 0 ? new BigDecimal(viewlistValue.replaceAll(",", "").replaceAll("\\(", "").replaceAll("\\)", "")).multiply(BgNConstants.NEG_ONE) : new BigDecimal(viewlistValue.replaceAll(",", ""));
                                        }
                                        catch (NumberFormatException ex) {
                                            logger.error((Object)("error value NumberFormatException:" + viewlistValue + "****" + _cell));
                                        }
                                        BgNFSHelper.setValue(_cell, _value);
                                    }
                                }
                            } else {
                                _value = _value.divide(_tmpCoefficient, 8, 4);
                                BgNFSHelper.setValue(_cell, _value);
                            }
                        } else if (BgNFSHelper.checkHasExpression(_cell)) {
                            if (viewlistMeasureUnitHelper != null && ViewListHelper.getCalculatorDataStyle(_cell) != null) {
                                _obj = _cell.getValue().getValue();
                                if (_obj instanceof BigDecimal && !StringUtils.isEmpty((String)(viewlistValue = isOutOfFormExport ? _obj.toString() : viewlistMeasureUnitHelper.getCalcDisplayValue(_cell, _obj)))) {
                                    if (viewlistValue.indexOf("%") > 0) {
                                        BgNFSHelper.setValue(_cell, viewlistValue);
                                    } else {
                                        try {
                                            viewlistValue = viewlistValue.trim();
                                            _value = viewlistValue.indexOf("(") >= 0 && viewlistValue.indexOf(")") >= 0 ? new BigDecimal(viewlistValue.replaceAll(",", "").replaceAll("\\(", "").replaceAll("\\)", "")).multiply(BgNConstants.NEG_ONE) : new BigDecimal(viewlistValue.replaceAll(",", ""));
                                        }
                                        catch (NumberFormatException ex) {
                                            logger.error((Object)("error value NumberFormatException:" + viewlistValue + "****" + _cell));
                                        }
                                        BgNFSHelper.setValue(_cell, _value);
                                    }
                                }
                            } else if (_cell.getValue() != null && _cell.getValue().getValue() instanceof BigDecimal && !BgNFSHelper.checkHasPercentage(_cell)) {
                                _value = ((BigDecimal)_cell.getValue().getValue()).divide(_tmpCoefficient, 8, 4);
                                BgNFSHelper.setValue(_cell, _value);
                            }
                        } else if (BgNFSHelper.checkHasNumbericOfCell(_cell)) {
                            _obj = _cell.getValue().getValue();
                            if (_obj instanceof BigDecimal) {
                                _value = (BigDecimal)_obj;
                                _value = _value.divide(_tmpCoefficient, 8, 4);
                                BgNFSHelper.setValue(_cell, _value);
                            } else if (_obj instanceof Calendar) {
                                BgNFSHelper.setValue(_cell, _cell.getText());
                            } else if (_obj instanceof Date) {
                                BgNFSHelper.setValue(_cell, _cell.getText());
                            } else if (BgNFSHelper.checkIsNumericOfCell(_cell)) {
                                try {
                                    _value = new BigDecimal(_cell.getValue().getValue().toString().replaceAll(",", ""));
                                }
                                catch (Exception ex) {
                                    _value = BgNConstants.ZERO;
                                }
                                _value = _value.divide(_tmpCoefficient, 8, 4);
                                BgNFSHelper.setValue(_cell, _value);
                            } else {
                                String value = _obj.toString();
                                if (_colIndex == 0 && _cell.getUserObject("NELevel") != null) {
                                    int level = (Integer)_cell.getUserObject("NELevel").getValue();
                                    for (int i = 0; i < level; ++i) {
                                        value = "  " + value;
                                    }
                                }
                                BgNFSHelper.setValue(_cell, value);
                            }
                        } else if (!(_cell.getValue().getValue() instanceof Calendar)) {
                            if (_cell.getValue() != null && _cell.getValue().getValue() instanceof BigDecimal && !BgNFSHelper.checkHasTextOfCell(_cell)) {
                                if (!BgNFSHelper.checkHasPercentage(_cell)) {
                                    _value = ((BigDecimal)_cell.getValue().getValue()).divide(_tmpCoefficient, 8, 4);
                                    BgNFSHelper.setValue(_cell, _value);
                                }
                            } else if (viewlistMeasureUnitHelper != null) {
                                boolean isNum = MbgViewListDescriptionHelper.checkCellViewListDescriptionIsNumeric(_cell);
                                if (isNum) {
                                    BgNFSHelper.setValue(_cell, _cell.getValue().getValue().toString());
                                    _cell.setSSA((ShareStyleAttributes)ViewListTitleRenderBase.getStyle(_cell.getStyle(), Styles.HorizontalAlignment.RIGHT.getValue()));
                                } else {
                                    BgNFSHelper.setValue(_cell, _cell.getValue().getValue().toString());
                                }
                            } else {
                                BgNFSHelper.setValue(_cell, _cell.getValue().getValue().toString());
                            }
                        }
                    }
                    if (_cell == null || !BgNFSHelper.checkHasNumbericOfCell(_cell)) continue;
                    displayModeRange = BgNFSHelper.addDisplayRange(_cell, displayModel, displayModeRange);
                }
                if (!isProcessTitle || hasRowObject) continue;
                if (ViewListHelper.getDimension(_sheet.getRow(_rowIndex, false)) != null) {
                    hasRowObject = true;
                    continue;
                }
                _cell = _sheet.getCell(_rowIndex, 0, false);
                String title = ViewListTitleRenderBase.getTitle(_cell);
                if (StringUtils.isEmpty((String)title)) continue;
                BgNFSHelper.setValue(_cell, title);
                _cell.setSSA((ShareStyleAttributes)ViewListTitleRenderBase.getStyle(_cell.getStyle(), ViewListTitleRenderBase.getAlign(_cell).getValue()));
            }
            if (displayModeRange == null) continue;
            BgNFSHelper.setDisplayFormat(displayModel, displayModeRange);
        }
        book.getProtection().start();
        return _book;
    }

    public static Book copyBook2007(Book book) {
        int sheetIndex;
        Book _book = Book.Manager.getNewBook(null, (int)book.getSheetCount());
        _book.setActiveSheet(book.getActiveSheetIndex());
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        if (book.getCellActionAfterListener() != null) {
            CellActionAfterListener listener = book.getCellActionAfterListener();
            if (listener != null) {
                book.setCellActionAfterListener(null);
            }
            int sheetSize = book.getSheetCount();
            for (int sheetIndex2 = sheetSize - 1; sheetIndex2 >= 0; --sheetIndex2) {
                _book.getSheet(sheetIndex2).copySheetFrom(book.getSheet(sheetIndex2));
            }
            book.setCellActionAfterListener(listener);
        } else {
            int sheetSize = book.getSheetCount();
            for (sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                _book.getSheet(sheetIndex).copySheetFrom(book.getSheet(sheetIndex));
                _book.getSheet(sheetIndex).setID(book.getSheet(sheetIndex).getID());
            }
        }
        _book.getProtection().setEncryptedPassword("");
        _book.getProtection().stop();
        for (int s = 0; s < _book.getSheetCount(); ++s) {
            if (_book.getSheet(s).getSheetOption().getProtection(false) == null) continue;
            _book.getSheet(s).getSheetOption().getProtection(false).setEncryptedPassword("");
            _book.getSheet(s).getSheetOption().getProtection(false).stop();
        }
        BgNFSHelper.stopBookProtection(_book);
        int sheetSize = _book.getSheetCount();
        for (sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
        }
        return _book;
    }

    public static void checkSheetParam(ReportBaseInfo info, Book book) {
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        if (info.getSheetParam() == null) {
            info.put("sheetParam", (Object)new RptSheetParamCollection());
        }
        block0: for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            pinfo.setSheetID(sheet.getID());
            pinfo.setRelaType(ReportTypeEnum.REPORT);
            pinfo.getPostils().clear();
            if (info.getSheetParam() != null && info.getSheetParam().get(i) != null) {
                for (int m = 0; m < info.getSheetParam().size(); ++m) {
                    if (!info.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                    pinfo.setId(info.getSheetParam().get(m).getId());
                    info.getSheetParam().set(m, pinfo);
                    continue block0;
                }
                continue;
            }
            info.getSheetParam().add(pinfo);
        }
    }

    public static Map<String, Set<String>> getIncrementAndDecrementSet(Set<String> newNumberSet, Set<String> selectNumberSet) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet diffSet = new HashSet();
        Sets.difference(newNumberSet, selectNumberSet).copyInto(diffSet);
        Sets.difference(selectNumberSet, newNumberSet).copyInto(diffSet);
        HashSet incrementSet = new HashSet();
        Sets.intersection(newNumberSet, diffSet).copyInto(incrementSet);
        HashSet decrementSet = new HashSet();
        Sets.intersection(selectNumberSet, diffSet).copyInto(decrementSet);
        map.put(INCREMENT_SET, incrementSet);
        map.put(DECREMENT_SET, decrementSet);
        return map;
    }

    public static BigDecimal calcStr(String amountStr) {
        return BgNFSHelper.calcStr(amountStr, true, 2);
    }

    public static BigDecimal calcStr(String amountStr, boolean hasP, int precision) {
        amountStr = amountStr.replaceAll(",", "");
        BigDecimal retval = null;
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine se = manager.getEngineByName("js");
            Object object = se.eval(amountStr);
            if (object != null) {
                retval = new BigDecimal(Double.valueOf(object.toString()));
                if (hasP) {
                    retval = retval.setScale(precision, 4);
                }
            }
        }
        catch (Exception e) {
            retval = null;
        }
        return retval;
    }

    public static String dealBgSpecialItems(String rule) {
        String[] props = new String[]{"dimensionNumber", "dimensionName", "memberName", "memberDisplayName"};
        rule = rule.indexOf("EntryAllWhere") != 1 ? rule.replaceAll("EntryAllWhere", "and").replaceAll(" ON bgSpecialItems", "") : rule.replaceAll("EntryAll", "").replaceAll(" ON bgSpecialItems", "");
        for (int i = 0; i < props.length; ++i) {
            rule = rule.replaceAll(props[i], "bgSpecialItems." + props[i]);
        }
        return rule;
    }

    public static void copyBizAttachmentFiles(AttachmentServerManager attachmentServerManager, IDimDataQuery info, String sourceID, String destID) throws BOSException, EASBizException {
        if (info != null) {
            sourceID = info.getBizTemplateId().toString();
            destID = info.getId().toString();
        }
        String[] attachmentIDsByBoID = attachmentServerManager.getAttachmentIDsByBoID(destID);
        for (int i = 0; attachmentIDsByBoID != null && i < attachmentIDsByBoID.length; ++i) {
            if (StringUtils.isEmpty((String)attachmentIDsByBoID[i]) || "null".equalsIgnoreCase(attachmentIDsByBoID[i])) continue;
            attachmentServerManager.deleteOneAssociation(destID, attachmentIDsByBoID[i]);
        }
        attachmentServerManager.copyBizAttachmentFiles(sourceID, destID);
    }

    public static String getHardCodeRes(String resKey) {
        return BgNFSHelper.getHardCodeRes(null, resKey);
    }

    public static String getHardCodeRes(Context ctx, String resKey) {
        return BgNFSHelper.getHardCodeRes(ctx, resKey, null);
    }

    public static String getHardCodeRes(Context ctx, String resKey, Object[] object) {
        if (ctx == null) {
            if (object == null) {
                return EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgHardCodeResource", (String)resKey);
            }
            return EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgHardCodeResource", (String)resKey, (Object[])object);
        }
        if (object == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgHardCodeResource", (String)resKey, (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgHardCodeResource", (String)resKey, (Locale)ctx.getLocale(), (Object[])object);
    }

    public static Object dealValueWithDispalyMode(Context ctx, int displayMode, Object obj, BigDecimal coefficient, int precision) {
        BigDecimal _value = null;
        switch (displayMode) {
            case 1: 
            case 2: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(1000), precision, 4);
                break;
            }
            case 3: 
            case 4: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(new BigDecimal(10000), precision, 4);
                break;
            }
            default: {
                _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            }
        }
        return BgNFSHelper.dealUnitWithDispalyMode(ctx, displayMode, ((Object)_value).toString());
    }

    public static String dealUnitWithDispalyMode(Context ctx, int displayMode, String _text) {
        String text = null;
        switch (displayMode) {
            case 1: {
                if (ctx == null) {
                    text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"thousand") + ")";
                    break;
                }
                text = _text + "(" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"thousand", (Locale)ctx.getLocale()) + ")";
                break;
            }
            case 3: {
                if (ctx == null) {
                    text = _text + "(" + EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"tenThousand") + ")";
                    break;
                }
                text = _text + "(" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"tenThousand", (Locale)ctx.getLocale()) + ")";
                break;
            }
            default: {
                text = _text;
            }
        }
        return text;
    }

    public static void clearNumberFormat(NotifyEvent evt) {
        Object obj = evt.getSource();
        if (obj instanceof SpreadContext) {
            SpreadContext spreadContext = (SpreadContext)obj;
            spreadContext.getRangeManager().getAppropriateSelectionRange().setUserObject("display", null);
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
            sa.setNumberFormat("");
            spreadContext.getRangeManager().getAppropriateSelectionRange().setStyle(sa, Styles.getEmptySA());
        }
    }

    protected static Range addDisplayRange(Cell cell, int displayModel, Range disRange) {
        if (cell != null && displayModel != 0 && displayModel != 2 && displayModel != 4 && (BgNFSHelper.checkIsNumericOfCell(cell) || cell.getValue() != null && BgNFSHelper.isPercentageNumerical(cell.getValue().getValue()))) {
            if (disRange == null) {
                disRange = cell.getSheet().getRange(cell);
            } else {
                disRange.addAll((SortedCellBlockArray)cell.getSheet().getRange(cell));
            }
        }
        return disRange;
    }

    protected static void setDisplayFormat(int displayModel, Range disRange) {
        if (disRange == null) {
            return;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        switch (displayModel) {
            case 1: {
                sa.setNumberFormat(NF_THOUSAND_FORMAT);
                disRange.setStyle(sa, Styles.getEmptySA());
                break;
            }
            case 2: {
                sa.setNumberFormat(NF_THOUSAND_FORMAT_F);
                disRange.setStyle(sa, Styles.getEmptySA());
                break;
            }
            case 3: {
                sa.setNumberFormat(NF_TENTHOUSAND_FORMAT);
                disRange.setStyle(sa, Styles.getEmptySA());
                break;
            }
            case 4: {
                sa.setNumberFormat(NF_TENTHOUSAND_FORMAT_F);
                disRange.setStyle(sa, Styles.getEmptySA());
                break;
            }
        }
    }

    protected static void setDisplayFormat(int displayModel, KDSSheet kdsSheet, int rowIndex, int colIndex, KDSCell kdsCell) {
        if (displayModel == 0 || kdsSheet == null || kdsCell == null) {
            return;
        }
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes sa = Styles.getEmptySA();
        switch (displayModel) {
            case 1: {
                sa.setNumberFormat(NF_THOUSAND_FORMAT);
                kdsSheet.setCell(rowIndex, colIndex, kdsCell.getValue(), (ShareStyleAttributes)sa);
                break;
            }
            case 2: {
                sa.setNumberFormat(NF_THOUSAND_FORMAT_F);
                kdsSheet.setCell(rowIndex, colIndex, kdsCell.getValue(), (ShareStyleAttributes)sa);
                break;
            }
            case 3: {
                sa.setNumberFormat(NF_TENTHOUSAND_FORMAT);
                kdsSheet.setCell(rowIndex, colIndex, kdsCell.getValue(), (ShareStyleAttributes)sa);
                break;
            }
            case 4: {
                sa.setNumberFormat(NF_TENTHOUSAND_FORMAT_F);
                kdsSheet.setCell(rowIndex, colIndex, kdsCell.getValue(), (ShareStyleAttributes)sa);
                break;
            }
        }
    }

    public static boolean checkHasDisplayModel(String cellStyle, int displayMode) {
        return displayMode != 0 && !StringUtils.isEmpty((String)cellStyle) && (NF_THOUSAND_FORMAT.equals(cellStyle) || NF_TENTHOUSAND_FORMAT.equals(cellStyle) || NF_THOUSAND_FORMAT_F.equals(cellStyle) || NF_TENTHOUSAND_FORMAT_F.equals(cellStyle));
    }
}

