/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.IBgSetOrgUnitAdapter;
import com.kingdee.eas.ma.mbg.utils.IGetBgSchemeNumber;
import com.kingdee.util.PropertyContainer;
import java.util.Date;
import org.apache.log4j.Logger;

public class BgRptReportPropertyAdapter
implements IReportPropertyAdapter,
IGetBgSchemeNumber,
IBgSetOrgUnitAdapter {
    private static final Logger logger = CoreUIObject.getLogger(BgRptReportPropertyAdapter.class);
    private static final long serialVersionUID = 2153051364296710294L;
    public static final String BG_COST_CENTER_NUMBER = "BgCostCenterNum";
    public static final String BG_PERIOD_TYPE = "BG_PERIOD_TYPE";
    public static final String BG_PERIOD_YEAR = "BG_PERIOD_YEAR";
    public static final String BG_PERIOD_MONTH = "BG_PERIOD_MONTH";
    public static final String BG_PERIOD_ID = "BG_PERIOD_ID";
    public static final String BG_PERIOD_NUMBER = "BG_PERIOD_NUMBER";
    public static final String BG_VERSION_NUMBER = "BG_VERSION_NUMBER";
    public static final String BG_ORG_ID = "BG_ORG_ID";
    public static final String BG_FORM_ID = "BG_FORM_ID";
    public static final String BG_ORG_NUMBER = "BG_ORG_NUMBER";
    public static final String BG_ORG_NAME = "BG_ORG_NAME";
    public static final String BG_SCHEME_NUMBER = "BG_SCHEME_NUMBER";
    public static final String Bg_Begin_Date = "bg_begin_date";
    public static final String Bg_End_Date = "bg_end_date";
    public static final String BG_TEMPLATE_ID = "BG_TEMPLATE_ID";
    public static final String BG_Create_Date = "bg_create_date";
    public static final String BG_FORM_STATE = "BG_FORM_STATE";
    public static final String BG_FORM_PROCESSTYPE = "BG_FORM_PROCESSTYPE";
    public static final String Report_StartYear = "Report_StartYear";
    public static final String Report_EndYear = "Report_EndYear";
    public static final String Report_StartPeriod = "Report_StartPeriod";
    public static final String Report_EndPeriod = "Report_EndPeriod";
    public static final String Report_FormulaMap = "Report_FormulaMap";
    private FullOrgUnitInfo orgUnit = null;
    protected PropertyContainer p;

    public BgRptReportPropertyAdapter() {
    }

    public BgRptReportPropertyAdapter(BgFormInfo report) {
        try {
            this.setProperties(report);
        }
        catch (Exception e) {
            logger.error((Object)"BgRptReportPropertyAdapter error:", (Throwable)e);
        }
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnit) {
        this.p.setString(BG_ORG_ID, orgUnit == null ? "" : orgUnit.getId().toString());
        this.p.setString(BG_ORG_NUMBER, orgUnit == null ? "" : orgUnit.getNumber());
        this.p.setString(BG_ORG_NAME, orgUnit == null ? "" : orgUnit.getName());
        this.orgUnit = orgUnit;
    }

    public FullOrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    private void setProperties(BgFormInfo report) {
        FullOrgUnitInfo costCenter;
        if (this.p == null) {
            this.p = new PropertyContainer();
        }
        if (report.getCompany() != null && report.getCompany().getId() != null) {
            this.p.setString("Company.Name", report.getCompany().getName());
            this.p.setString("Company.Number", report.getCompany().getNumber());
            this.p.setString("Company.ID", report.getCompany().getId().toString());
        }
        FullOrgUnitInfo org = report.getOrgUnit();
        this.setOrgUnit(org);
        this.p.setString(BG_FORM_ID, report.getId().toString());
        this.p.setString(BG_TEMPLATE_ID, report.getBgTemplate().getId().toString());
        if (report.getBgScheme() != null) {
            this.p.setString(BG_SCHEME_NUMBER, report.getBgScheme().getNumber());
        }
        if (BgNFSHelper.getFormulaMap((IObjectValue)report) != null) {
            this.p.put(Report_FormulaMap, (Object)BgNFSHelper.getFormulaMap((IObjectValue)report));
        }
        BgPeriodInfo period = report.getBgPeriod();
        if (report.getBgPeriod() != null) {
            if (report.getBgPeriod().getBeginDate() != null) {
                this.p.setString(Bg_Begin_Date, String.valueOf(report.getBgPeriod().getBeginDate()));
                this.p.setDate("Report_StartDate", report.getBgPeriod().getBeginDate());
            } else {
                this.p.setDate("Report_StartDate", report.getStartDate());
            }
            if (report.getBgPeriod().getEndDate() != null) {
                this.p.setString(Bg_End_Date, String.valueOf(report.getBgPeriod().getEndDate()));
                this.p.setDate("Report_EndDate", report.getBgPeriod().getEndDate());
            } else {
                this.p.setDate("Report_EndDate", report.getEndDate());
            }
        }
        this.p.setDate(BG_Create_Date, report.getCreateTime() != null ? new Date(report.getCreateTime().getTime()) : new Date());
        if (period != null) {
            String id = period.getId().toString();
            BgPeriodEnum periodType = period.getPeriodType();
            int year = period.getYear();
            int halfYear = period.getHalfYear();
            int month = period.getMonth();
            int quart = period.getQuarter();
            this.p.setString(BG_PERIOD_ID, id);
            this.p.setString(BG_PERIOD_NUMBER, period.getNumber());
            if (period.getPeriodType() != null) {
                this.p.setInt(BG_PERIOD_TYPE, period.getPeriodType().getValue());
                this.p.setInt(BG_PERIOD_YEAR, period.getYear());
            }
            if (periodType != null) {
                if (periodType.getValue() == 1) {
                    report.setPeriodType(RptPeriodTypeEnum.YEARLY);
                    report.setYear(year);
                    report.setPeriod((short)1);
                } else if (periodType.getValue() == 2) {
                    report.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                    report.setYear(year);
                    report.setPeriod((short)halfYear);
                    this.p.setInt(BG_PERIOD_MONTH, period.getHalfYear());
                } else if (periodType.getValue() == 3) {
                    report.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                    report.setYear(year);
                    report.setPeriod((short)quart);
                    this.p.setInt(BG_PERIOD_MONTH, period.getQuarter());
                } else if (periodType.getValue() == 4) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getMonth());
                } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                    report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    report.setYear(year);
                    report.setPeriod((short)month);
                    this.p.setInt(BG_PERIOD_MONTH, period.getWeek());
                }
            }
        }
        this.p.setInt("Report.Year", report.getYear());
        this.p.setInt("Report.Period", (int)report.getPeriod());
        if (report.getCurrency() != null) {
            this.p.setString("Currency.Number", report.getCurrency().getNumber());
        }
        if (report.getLastUpdateUser() != null) {
            this.p.setString("LastUpdater.Name", report.getLastUpdateUser().getName());
        }
        this.p.setString("Report.Name", report.getName());
        if (report.getSourceType() != null) {
            this.p.setInt("Report.SourceType", report.getSourceType().getValue());
        }
        if (report.getCU() != null) {
            this.p.setString("CU.Name", report.getCU().getId().toString());
        }
        if (report.getCreator() != null) {
            this.p.setString("Creater.Name", report.getCreator().getName());
        }
        if ((costCenter = report.getOrgUnit()) != null) {
            this.p.setString(BG_COST_CENTER_NUMBER, costCenter.getNumber());
        }
        if (report.getSheetParam() != null && report.getSheetParam().size() > 0) {
            this.p.setInt(Report_StartYear, report.getSheetParam().get(0).getStartYear());
            this.p.setInt(Report_StartPeriod, report.getSheetParam().get(0).getStartPeriod());
            this.p.setInt(Report_EndYear, report.getSheetParam().get(0).getEndYear());
            this.p.setInt(Report_EndPeriod, report.getSheetParam().get(0).getEndPeriod());
        }
        if (report.getPeriodType() != null) {
            this.p.setInt("PeriodType", report.getPeriodType().getValue());
        }
        if (report.getBgVersion() != null) {
            this.p.setString(BG_VERSION_NUMBER, report.getBgVersion().getNumber());
        }
        this.p.setInt(BG_FORM_STATE, report.getState().getValue());
        if (report.getProcessType() == null) {
            report.setProcessType(BgProcessEnum.C01);
        }
        this.p.setString(BG_FORM_PROCESSTYPE, report.getProcessType().getName());
    }

    public Object getReportProperty(String name) {
        return this.p.get(name);
    }

    @Override
    public String getBgSchemeNumber() {
        return this.p.getString(BG_SCHEME_NUMBER);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof BgFormInfo) {
            this.setProperties((BgFormInfo)vo);
        } else if (vo instanceof BgActualRecordInfo) {
            this.setProperties(((BgActualRecordInfo)vo).getBgForm());
        }
    }
}

