/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.IMbgDim;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.IBgDimSettings;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgSchemeDimensionHelper
implements Serializable {
    private static final long serialVersionUID = 5895015431862621954L;
    protected Context ctx = null;
    private CoreBaseCollection settings = null;
    Map<String, BgDimSettingsInfo> dimSettingMap = null;
    private String bgSchemeId = null;
    private LinkedHashMap<String, BgDimensionInfo> dimensions = new LinkedHashMap();
    private Map<String, MbgDimInfo> refDim = new HashMap<String, MbgDimInfo>();
    private Map defaultMember;

    public CoreBaseCollection getSettings() {
        return this.settings;
    }

    public Map<String, BgDimSettingsInfo> getDimSettingMap() {
        if (this.dimSettingMap == null) {
            this.dimSettingMap = new HashMap<String, BgDimSettingsInfo>();
            CoreBaseCollection dimSettingColls = this.getSettings();
            for (int i = 0; i < dimSettingColls.size(); ++i) {
                this.dimSettingMap.put(((BgDimSettingsInfo)dimSettingColls.get(i)).getDimNumber(), (BgDimSettingsInfo)dimSettingColls.get(i));
            }
        }
        return this.dimSettingMap;
    }

    public LinkedHashMap<String, BgDimensionInfo> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(LinkedHashMap<String, BgDimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }

    public Map getDefaultMember() {
        return this.defaultMember;
    }

    public BgSchemeDimensionHelper() throws EASBizException, BOSException {
    }

    public BgSchemeDimensionHelper(String bgSchemeId) throws EASBizException, BOSException {
        this(null, bgSchemeId, false);
    }

    public BgSchemeDimensionHelper(Context ctx, String str, boolean isNumber) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.init(str, isNumber);
    }

    public BgSchemeDimensionHelper(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        this(ctx, bgSchemeId, false);
    }

    public Context getContext() {
        return this.ctx;
    }

    public static String getBgSchemeIdByBgForm(Context ctx, String bgFormId) throws BOSException {
        BgFormCollection col = BgSchemeDimensionHelper.getBgFormInstance(ctx).getBgFormCollection("select bgScheme.id where id = '" + bgFormId + "'");
        if (col != null && !col.isEmpty()) {
            return col.get(0).getBgScheme().getId().toString();
        }
        return null;
    }

    public String getBgSchemeId() {
        return this.bgSchemeId;
    }

    private static IBgForm getBgFormInstance(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getLocalInstance(ctx);
    }

    protected void init(String str, boolean isNumber) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (!this.isBgCsl()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("dimNumber", (Object)DimensionConstants.DEF_CSL_NUMBER, CompareType.NOTEQUALS));
        }
        if (isNumber) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)str));
        } else {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)str));
        }
        evi.setSelector(this.getSelectors());
        this.settings = this.getBgDimSettingsInstance().getCollection(evi);
        this.settings.sort("seq");
        this.defaultMember = this.getDefaultMember(this, false, false);
        for (int s = 0; s < this.settings.size(); ++s) {
            BgDimSettingsInfo sett = (BgDimSettingsInfo)this.settings.get(s);
            this.bgSchemeId = sett.getBgScheme().getId().toString();
            BgDimensionInfo dimension = new BgDimensionInfo(null);
            dimension.setType(sett.getDimNumber());
            dimension.setName(sett.getDimName());
            dimension.setAlias(dimension.getName());
            dimension.setNumber(sett.getDimNumber());
            sett.getMembers().sort("seq");
            for (int m = 0; m < sett.getMembers().size(); ++m) {
                BgDimSettingsMemberInfo settM = sett.getMembers().get(m);
                if (sett.getDimNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
                    dimension.setNumber(dimension.getType());
                    if (!MemberTypeEnum.budget.equals((Object)settM.getType())) continue;
                    this.initOrgViewId(dimension, settM.getMemberID());
                    continue;
                }
                if (sett.getDimNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                    dimension.setNumber(dimension.getType());
                    this.addMember(dimension, settM);
                    this.addDefaultMember(dimension, settM);
                    continue;
                }
                if (sett.getDimNumber().equals(DimensionConstants.DEF_ELEMENT_NUMBER)) {
                    dimension.setNumber(dimension.getType());
                    this.addMember(dimension, settM);
                    this.addDefaultMember(dimension, settM);
                    continue;
                }
                if (sett.getDimNumber().equals(DimensionConstants.DEF_CURRENCY_NUMBER)) {
                    this.addMember(dimension, settM);
                    dimension.setNumber(dimension.getType());
                    this.addDefaultMember(dimension, settM);
                    continue;
                }
                if (sett.getDimNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                    dimension.setNumber(dimension.getType());
                    this.addMember(dimension, settM);
                    this.addDefaultMember(dimension, settM);
                    continue;
                }
                if (sett.getDimNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                    dimension.setNumber(dimension.getType());
                    this.addMember(dimension, settM);
                    this.addDefaultMember(dimension, settM);
                    continue;
                }
                dimension.setNumber(dimension.getType());
                dimension.setViewId(settM.getMemberID().toString());
            }
            this.dimensions.put(dimension.getType(), dimension);
        }
        this.loadRefDimension();
        for (BgDimensionInfo dimension : this.dimensions.values()) {
            dimension.setAttribute(this.getRefField(dimension.getNumber()));
        }
    }

    protected void initOrgViewId(BgDimensionInfo dimension, BOSUuid orgViewId) {
        if (orgViewId == null) {
            return;
        }
        if (orgViewId.getType().equals((Object)new BgOrgViewInfo().getBOSType())) {
            dimension.setViewId(orgViewId.toString());
        }
    }

    private void loadRefDimension() throws BOSException {
        HashSet<String> dims = new HashSet<String>(this.dimensions.keySet());
        dims.removeAll(DimensionConstants.necessary);
        if (dims.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", dims, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("srcNumber");
        evi.getSelector().add("refField");
        MbgDimCollection col = this.getMbgDimInstance().getMbgDimCollection(evi);
        if (col != null && !col.isEmpty()) {
            for (int i = 0; i < col.size(); ++i) {
                this.refDim.put(col.get(i).getNumber(), col.get(i));
            }
        }
    }

    public String getSrcNumber(String dimNumber) {
        String srcNumber = DimensionFormulaHelper.getDefaultSrcNumber(dimNumber);
        if (srcNumber != null) {
            return srcNumber;
        }
        if (this.refDim.get(dimNumber) != null) {
            return this.refDim.get(dimNumber).getSrcNumber();
        }
        return null;
    }

    public String getRefField(String dimNumber) {
        String refField = DimensionFormulaHelper.getDefaultRefField(dimNumber);
        if (refField != null) {
            return refField;
        }
        if (this.refDim.get(dimNumber) != null) {
            return this.refDim.get(dimNumber).getRefField();
        }
        return null;
    }

    public String getRefFieldBySrcNumber(String srcNumber) {
        BgDimensionInfo dimension = this.getDimensionBySrcNumber().get(srcNumber);
        if (dimension != null) {
            return this.getRefField(dimension.getNumber());
        }
        return null;
    }

    public String getSrcNumberByRefField(String refField) {
        BgDimensionInfo dimension = this.getDimensionByRefField().get(refField);
        if (dimension != null) {
            return this.getSrcNumber(dimension.getNumber());
        }
        return null;
    }

    public List<String> getAccAndOtherDim(boolean isOnlyRefDim) {
        List<String> dims = this.getAllDim();
        dims.removeAll(DimensionConstants.necessary);
        if (!isOnlyRefDim) {
            dims.add(0, DimensionConstants.DEF_ACCOUNT_NUMBER);
        }
        return dims;
    }

    public List<String> getAllDim() {
        return new ArrayList<String>(this.dimensions.keySet());
    }

    public List<BgDimensionInfo> getAllDimensions() {
        return new ArrayList<BgDimensionInfo>(this.dimensions.values());
    }

    public Map<String, BgDimensionInfo> getDimensionBySrcNumber() {
        HashMap<String, BgDimensionInfo> result = new HashMap<String, BgDimensionInfo>();
        for (BgDimensionInfo dim : this.dimensions.values()) {
            result.put(this.getSrcNumber(dim.getNumber()), dim);
        }
        return result;
    }

    public Map<String, BgDimensionInfo> getDimensionByRefField() {
        LinkedHashMap<String, BgDimensionInfo> result = new LinkedHashMap<String, BgDimensionInfo>();
        for (BgDimensionInfo dim : this.dimensions.values()) {
            result.put(this.getRefField(dim.getNumber()), dim);
        }
        return result;
    }

    private void addMember(BgDimensionInfo dimension, BgDimSettingsMemberInfo settM) {
        BgDimensionMember member = new BgDimensionMember(dimension.getNumber(), null, settM.getName(), settM.getNumber());
        member.setAttribute(settM.getMemberID().toString());
        dimension.getMember().add(member);
    }

    private void addDefaultMember(BgDimensionInfo dimension, BgDimSettingsMemberInfo settM) {
        if (dimension == null || settM == null || dimension.getNumber() == null) {
            return;
        }
        Object objectInfo = null;
        if (dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            objectInfo = this.defaultMember.get(DimensionConstants.DEF_PERIOD_NUMBER);
        } else if (dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
            objectInfo = this.defaultMember.get(DimensionConstants.DEF_VERSION_NUMBER);
        } else if (dimension.getNumber().equals(DimensionConstants.DEF_CURRENCY_NUMBER)) {
            objectInfo = this.defaultMember.get(DimensionConstants.DEF_CURRENCY_NUMBER);
        } else if (dimension.getNumber().equals(DimensionConstants.DEF_ELEMENT_NUMBER)) {
            objectInfo = this.defaultMember.get(DimensionConstants.DEF_ELEMENT_NUMBER);
        } else if (dimension.getNumber().equals(DimensionConstants.DEF_SCENARIO_NUMBER)) {
            objectInfo = this.defaultMember.get(DimensionConstants.DEF_SCENARIO_NUMBER);
        }
        if (objectInfo != null && objectInfo instanceof DataBaseInfo) {
            BgDimensionMember member = new BgDimensionMember(dimension.getNumber(), null, ((DataBaseInfo)objectInfo).getName(), ((DataBaseInfo)objectInfo).getNumber());
            member.setAttribute(((DataBaseInfo)objectInfo).getId() != null ? ((DataBaseInfo)objectInfo).getId().toString() : null);
            dimension.setDefaultMember(member);
        }
    }

    public Map getDefaultMember(BgSchemeDimensionHelper helper, boolean isCheckLeaf, boolean isPeriodPutInColls) throws EASBizException, BOSException {
        if (this.ctx == null) {
            return BgSchemeFactory.getRemoteInstance().getDefaultMember(helper, isCheckLeaf, isPeriodPutInColls);
        }
        return BgSchemeFactory.getLocalInstance(this.ctx).getDefaultMember(helper, isCheckLeaf, isPeriodPutInColls);
    }

    private IBgDimSettings getBgDimSettingsInstance() throws BOSException {
        if (this.ctx == null) {
            return BgDimSettingsFactory.getRemoteInstance();
        }
        return BgDimSettingsFactory.getLocalInstance(this.ctx);
    }

    private IMbgDim getMbgDimInstance() throws BOSException {
        if (this.ctx == null) {
            return MbgDimFactory.getRemoteInstance();
        }
        return MbgDimFactory.getLocalInstance((Context)this.ctx);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("members.*");
        sic.add("bgScheme.id");
        return sic;
    }

    public BgDimensionInfo getDimensionOnCheck(String dimNumber) throws DimensionException {
        if (!this.dimensions.containsKey(dimNumber)) {
            throw new DimensionException(DimensionException.NOFOUNDDIMESION, new Object[]{dimNumber});
        }
        return this.dimensions.get(dimNumber);
    }

    public BgDimensionInfo getDimension(String dimNumber) {
        return this.dimensions.get(dimNumber);
    }

    public Set<String> getMemberSet(String dimNumber, boolean isNumber) {
        BgDimensionInfo dimension = this.dimensions.get(dimNumber);
        return BgSchemeDimensionHelper.getMemberSet(dimension, isNumber);
    }

    public static Set<String> getMemberSet(BgDimensionInfo dimension, boolean isNumber) {
        if (dimension == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < dimension.getMember().size(); ++i) {
            if (isNumber) {
                ids.add(((BgDimensionMember)dimension.getMember().get(i)).getNumber());
                continue;
            }
            ids.add(((BgDimensionMember)dimension.getMember().get(i)).getAttribute());
        }
        return ids;
    }

    public Set<String> getSrcNumbers() {
        HashSet<String> srcNumbers = new HashSet<String>();
        srcNumbers.add(DimensionConstants.DEF_INDEX_SRCNUMBER);
        List<String> others = this.getAccAndOtherDim(true);
        if (others != null) {
            for (int i = 0; i < others.size(); ++i) {
                srcNumbers.add(this.getSrcNumber(others.get(i)));
            }
        }
        return srcNumbers;
    }

    public Map<String, String> getOtherDimFilterMap(String dimNumber) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> otherDim = this.getAccAndOtherDim(true);
        if (!StringUtils.isEmpty((String)dimNumber)) {
            otherDim.clear();
            otherDim.add(dimNumber);
        }
        for (int i = 0; i < otherDim.size(); ++i) {
            BgDimensionInfo dim = this.getDimension(otherDim.get(i));
            if (dim == null) continue;
            result.put(dim.getNumber(), dim.getViewId());
        }
        return result;
    }

    public void checkCombination(String strItemCombi, boolean isMustAllDim, boolean ischeckAccount, Cell cell, Map<String, Set<String>> filterValueMap) throws BgTemplateException {
        BgTemplateException ex = null;
        ex = this.isBgCsl() ? (cell == null ? (ischeckAccount ? new BgTemplateException(BgTemplateException.NEEDALLDIMCSL) : new BgTemplateException(BgTemplateException.NEEDALLDIMNOINDEXCSL)) : new BgTemplateException(BgTemplateException.NEEDALLDIMFORCELLCSL, new Object[]{TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow())})) : (cell == null ? (ischeckAccount ? new BgTemplateException(BgTemplateException.NEEDALLDIM) : new BgTemplateException(BgTemplateException.NEEDALLDIMNOINDEX)) : new BgTemplateException(BgTemplateException.NEEDALLDIMFORCELL, new Object[]{TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow())}));
        if (StringUtils.isEmpty((String)strItemCombi)) {
            throw ex;
        }
        if (ischeckAccount) {
            // empty if block
        }
        Set<String> srcNumbers = this.getSrcNumbers();
        if (!ischeckAccount) {
            srcNumbers.remove(DimensionConstants.DEF_INDEX_SRCNUMBER);
        }
        if (isMustAllDim && filterValueMap != null && !filterValueMap.isEmpty()) {
            Set<String> filterSrcSet = filterValueMap.keySet();
            String filterSrc = null;
            Iterator<String> ite = srcNumbers.iterator();
            while (ite.hasNext()) {
                filterSrc = ite.next();
                if (filterSrcSet.contains(filterSrc)) continue;
                ite.remove();
            }
        }
        String[] items = DimensionFormulaHelper.splitCombinations(strItemCombi);
        if (filterValueMap != null && !filterValueMap.isEmpty() && isMustAllDim && items.length > srcNumbers.size() && cell != null) {
            ex = new BgTemplateException(BgTemplateException.BGITEMHASSPECIALITEM, new Object[]{TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow())});
            throw ex;
        }
        if (isMustAllDim && srcNumbers.size() != items.length) {
            throw ex;
        }
        for (int s = 0; s < items.length; ++s) {
            if (srcNumbers.contains(DimensionFormulaHelper.getSrcNumber(items[s]))) continue;
            throw ex;
        }
    }

    public List<String> getRefDims() {
        ArrayList<String> refFields = new ArrayList<String>();
        List<String> dimNumbers = this.getAccAndOtherDim(false);
        for (int i = 0; i < dimNumbers.size(); ++i) {
            refFields.add(this.getRefField(dimNumbers.get(i)));
        }
        return refFields;
    }

    public String getBgOrgViewId() {
        return this.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER) != null ? this.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() : null;
    }

    public Map<String, String> getRefFieldMap() {
        HashMap<String, String> refFieldMap = new HashMap<String, String>();
        List<String> allDims = this.getAllDim();
        for (int i = 0; i < allDims.size(); ++i) {
            refFieldMap.put(allDims.get(i), this.getRefField(allDims.get(i)));
        }
        return refFieldMap;
    }

    public Map<String, String> getSrcNumberMap() {
        HashMap<String, String> refFieldMap = new HashMap<String, String>();
        List<String> allDims = this.getAllDim();
        for (int i = 0; i < allDims.size(); ++i) {
            refFieldMap.put(allDims.get(i), this.getSrcNumber(allDims.get(i)));
        }
        return refFieldMap;
    }

    public boolean isBgCsl() {
        return false;
    }

    public static BgSchemeDimensionHelper getCslInstance(Context ctx, String bgSchemeId, OrgTreeInfo orgTree) throws EASBizException, BOSException {
        try {
            Class<?> cls = Class.forName(DimensionConstants.CSLSCHEME_HELPER);
            return (BgSchemeDimensionHelper)cls.getConstructor(Context.class, String.class, OrgTreeInfo.class).newInstance(ctx, bgSchemeId, orgTree);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

