/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.ma.mbg.BgTemplatePostilInfo;
import com.kingdee.eas.ma.mbg.utils.CmtComparator;
import com.kingdee.eas.ma.mbg.utils.CommentConstants;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class BgTemplateComment
implements Cloneable {
    protected boolean isInited = false;
    protected BgTemplateComment mirror = null;
    protected int status = 1;
    protected static int tipLength = 100;
    public String content = null;
    public UserInfo author = null;
    public Timestamp date = null;
    protected BgTemplatePostilInfo source;

    protected Object clone() {
        return this.getCommentCopy();
    }

    public BgTemplateComment() {
        this.source = null;
        this.mirror = this;
    }

    public BgTemplateComment(BgTemplatePostilInfo source) throws Exception {
        this.status = 4;
        this.source = source;
        this.mirror = this;
        this.content = new String(source.getDescription());
    }

    protected void initialize() {
        if (this.isInited) {
            return;
        }
        if (this.source != null) {
            this.content = new String(this.source.getDescription());
            this.author = this.source.getLastUpdateUser();
            if (this.source.getLastUpdateTime() != null) {
                this.date = (Timestamp)this.source.getLastUpdateTime().clone();
            }
            this.status = 4;
        } else {
            this.content = RptResourceHelper.getString((String)"rptcomment-default");
            this.author = null;
            this.date = null;
            this.status = 1;
        }
        if (this.author == null) {
            this.author = (UserInfo)SysContext.getSysContext().getCurrentUser();
        }
        if (this.date == null) {
            this.date = new Timestamp(System.currentTimeMillis());
        }
        this.isInited = true;
    }

    public BgTemplatePostilInfo getTrueSource() {
        if (this.source == null) {
            this.source = new BgTemplatePostilInfo();
            this.initialize(this.source);
        }
        this.source.setDescription(this.getContent());
        this.source.setLastUpdateTime(this.date);
        return this.source;
    }

    public BgTemplatePostilInfo getSource() {
        if (this.source == null) {
            this.source = new BgTemplatePostilInfo();
            this.initialize(this.source);
        }
        if (this.status == 1) {
            return null;
        }
        this.source.setDescription(this.getContent());
        this.source.setLastUpdateTime(this.date);
        return this.source;
    }

    protected void initialize(BgTemplatePostilInfo info) {
        info.setCreator(this.author);
        info.setLastUpdateTime(this.date);
        info.setDescription(this.content);
        info.setPostilType(PostilTypeEnum.REPORT);
    }

    public void setSource(BgTemplatePostilInfo source) {
        this.source = source;
    }

    public BgTemplateComment getCommentCopy() {
        this.initialize();
        BgTemplateComment res = new BgTemplateComment();
        res.mirror = this;
        res.source = this.source == null ? null : (BgTemplatePostilInfo)this.source.clone();
        res.author = this.author;
        res.date = this.date;
        res.status = this.status;
        res.isInited = true;
        res.content = this.content == null ? "" : new String(this.content);
        return res;
    }

    public BgTemplateComment getSmartCopy() {
        if (this.mirror != null) {
            this.status = CommentConstants.getStatus(this.mirror.status, this.status);
            this.mirror = null;
        } else {
            this.status = this.status == 2 || this.content == null ? 1 : 0;
        }
        return this.status == 1 ? null : this;
    }

    public String getTipString(int length) {
        this.initialize();
        String res = "";
        Locale lc = SysContext.getSysContext().getLocale();
        int len = 0;
        String tmp = null;
        if (this.author != null) {
            if (lc != null) {
                tmp = this.author.getName(lc);
            }
            if (tmp == null) {
                tmp = this.author.getName();
            }
            if (tmp != null && (len += (tmp = tmp.trim()).length()) < length - 1) {
                res = res + tmp + ", ";
            }
        }
        if (this.date != null) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 3, lc);
            if (df != null) {
                tmp = df.format(this.date);
            }
            if (tmp != null && (len += tmp.length()) < length - 1) {
                res = res + tmp + ", ";
            }
        }
        if (this.content != null) {
            tmp = this.content.trim();
            if ((len = length - len) < 1) {
                tmp = "";
            } else if (len < tmp.length()) {
                tmp = tmp.substring(0, len - 1);
            }
            res = res + tmp;
        }
        return res;
    }

    public String getFullString() {
        if (!this.isInited || !this.isValid()) {
            return null;
        }
        String res = "";
        Locale lc = SysContext.getSysContext().getLocale();
        String tmp = null;
        if (this.author != null) {
            if (lc != null) {
                tmp = this.author.getName(lc);
            }
            if (tmp == null) {
                tmp = this.author.getName();
            }
            if (tmp != null) {
                tmp = tmp.trim();
                res = res + tmp + ", ";
            }
        }
        if (this.date != null) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 3, lc);
            if (df != null) {
                tmp = df.format(this.date);
            }
            if (tmp != null) {
                res = res + tmp + ", ";
            }
        }
        if (this.content != null) {
            tmp = this.content.trim();
            res = res + tmp;
        }
        return res;
    }

    public static Comparator getComparator(int compMode) {
        return new CmtComparator(compMode);
    }

    public String toString() {
        return this.getTipString(tipLength);
    }

    public boolean isFresh() {
        return this.status == 0 || this.status == 1;
    }

    public String getContent() {
        this.initialize();
        return this.content;
    }

    public String getDate() {
        this.initialize();
        return DateTimeUtils.format((Date)this.date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public Timestamp getDateTimeStamp() {
        return this.date;
    }

    public String getUser() {
        this.initialize();
        return this.author == null ? null : this.author.getName();
    }

    public void setContent(String text) {
        this.initialize();
        String def = RptResourceHelper.getString((String)"rptcomment-default");
        if (def.equals(text)) {
            return;
        }
        this.content = text;
        this.status = CommentConstants.getStatus(this.status, 3);
    }

    public void setDead() {
        this.status = CommentConstants.getStatus(this.status, 2);
    }

    public boolean isValid() {
        return this.status != 2;
    }

    public void setdate(Timestamp timestamp) {
        this.date = timestamp;
    }

    public void setNewly() {
        this.initialize();
        this.status = 0;
    }
}

