/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DimensionMemberCheckFactory {
    private Context ctx = null;
    private String bgTemplateId;
    private BgSchemeDimensionHelper schemeHelper = null;
    private DimensionCacheHelper cacheHelper = null;
    private boolean isDecompose = false;
    private Map checkHelpers = new HashMap();
    public long useTime = 0L;

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public DimensionMemberCheckFactory(Context ctx, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, boolean isDecompose) {
        this.ctx = ctx;
        this.bgTemplateId = bgTemplateId;
        this.schemeHelper = schemeHelper;
        this.cacheHelper = new DimensionCacheHelper(ctx);
        this.cacheHelper.setMemberCacheHelper(new ViewListMemberCacheHelper());
        this.cacheHelper.getMemberCacheHelper().setCtx(ctx);
        this.cacheHelper.getMemberCacheHelper().setSchemeHelper(schemeHelper);
        this.isDecompose = isDecompose;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void setCacheHelper(DimensionCacheHelper cacheHelper) {
        this.cacheHelper = cacheHelper;
    }

    public void clear() {
        this.checkHelpers.clear();
    }

    public Map getCheckHelpers() {
        return this.checkHelpers;
    }

    public void addAllOrgUnit(Map orgMap) {
        this.cacheHelper.addAllOrgUnit(orgMap);
    }

    public OrgUnitInfo getOrgUnit(String orgNumber) throws EASBizException, BOSException {
        return this.cacheHelper.getOrgUnitByNumber(orgNumber);
    }

    public final DimensionMemberCheckHelper getHelperByNumber(String orgUnitNumber, IMbgViewManager view) throws EASBizException, BOSException {
        return this.getHelper(this.getOrgUnit(orgUnitNumber).getId().toString(), view);
    }

    public final DimensionMemberCheckHelper getHelper(String orgUnitId, IMbgViewBase view) throws EASBizException, BOSException {
        if (!this.checkHelpers.containsKey(orgUnitId)) {
            long st = System.currentTimeMillis();
            DimensionMemberCheckHelper helper = this.createCheckHelper(this.ctx, this.cacheHelper, orgUnitId, this.bgTemplateId, this.schemeHelper, view);
            this.useTime = this.useTime + System.currentTimeMillis() - st;
            this.putCheckHelper(orgUnitId, helper);
        }
        return (DimensionMemberCheckHelper)this.checkHelpers.get(orgUnitId);
    }

    protected DimensionMemberCheckHelper createCheckHelper(Context ctx, DimensionCacheHelper cacheHelper, String orgUnitId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, IMbgViewBase view) throws EASBizException, BOSException {
        if (ctx == null) {
            return DimensionMemberCheckHelper.getRemoteIntance(cacheHelper, orgUnitId, orgUnitId, schemeHelper, view, this.isDecompose);
        }
        return DimensionMemberCheckHelper.getLocalIntance(ctx, cacheHelper, orgUnitId, bgTemplateId, schemeHelper, view, this.isDecompose);
    }

    public void putCheckHelper(String orgUnitId, DimensionMemberCheckHelper checkHelper) {
        this.checkHelpers.put(orgUnitId, checkHelper);
    }

    public void clearDimensionRelation() {
        Iterator it = this.checkHelpers.values().iterator();
        while (it.hasNext()) {
            ((DimensionMemberCheckHelper)it.next()).cleanDimensionRelation();
        }
    }
}

