/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewBase;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionMemberCheckHelper
implements Serializable {
    private static final long serialVersionUID = -7406563036604490727L;
    private static final Logger logger = Logger.getLogger((String)DimensionMemberCheckHelper.class.getName());
    private static final Set<String> memberDims = new HashSet<String>();
    private Context ctx;
    private Map<String, DimensionMemberRelationShipHelper> relationHelpers = new HashMap<String, DimensionMemberRelationShipHelper>();
    private Map<String, Set<String>> dimensionRelation = null;
    private String orgId;
    private CostCenterOrgUnitInfo costCenterOrgUnit;
    protected boolean isNeedCheck = true;
    protected Map<String, Set<String>> leafMap = new HashMap<String, Set<String>>();
    private DimensionCacheHelper cacheHelper;
    private boolean isDecompose = false;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, Set<String>> cacheScenMap = new HashMap<String, Set<String>>();
    private Map<String, String[]> formulaParamMap = new HashMap<String, String[]>();

    public String getOrgId() {
        return this.orgId;
    }

    public void setNeedCheck(boolean isNeedCheck) {
        this.isNeedCheck = isNeedCheck;
    }

    public Map<String, Set<String>> getLeafMap() {
        return this.leafMap;
    }

    public boolean isDecompose() {
        return this.isDecompose;
    }

    protected DimensionMemberCheckHelper(Context ctx, DimensionCacheHelper cacheHelper, BgSchemeDimensionHelper schemeHelper) {
        this(ctx, cacheHelper, schemeHelper, false);
    }

    protected DimensionMemberCheckHelper(Context ctx, DimensionCacheHelper cacheHelper, BgSchemeDimensionHelper schemeHelper, boolean isDecompose) {
        this.ctx = ctx;
        this.cacheHelper = cacheHelper == null ? new DimensionCacheHelper(ctx) : cacheHelper;
        this.schemeHelper = schemeHelper;
        this.isDecompose = isDecompose;
    }

    public boolean isNeedCheck() {
        return this.isNeedCheck;
    }

    public CostCenterOrgUnitInfo getCostCenterOrgUnit() throws BOSException, EASBizException {
        if (this.costCenterOrgUnit == null) {
            ICostCenterOrgUnit biz = null;
            biz = this.ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance() : CostCenterOrgUnitFactory.getLocalInstance((Context)this.ctx);
            this.costCenterOrgUnit = (CostCenterOrgUnitInfo)biz.getOrgUnitInfo("select id, number, name, longNumber, level where id = '" + this.orgId + "'");
        }
        return this.costCenterOrgUnit;
    }

    protected Map<String, Set<String>> getCacheScenMap() {
        return this.cacheScenMap;
    }

    public Map<String, String[]> getFormulaParamMap() {
        return this.formulaParamMap;
    }

    public final boolean isDetailItem(String formula) {
        if (StringUtils.isEmpty((String)formula) || this.leafMap == null || this.leafMap.isEmpty()) {
            return false;
        }
        String[] formulaParam = null;
        if (this.getFormulaParamMap().containsKey(formula)) {
            formulaParam = this.getFormulaParamMap().get(formula);
        } else {
            formulaParam = BgNFSHelper.parseFormulaPara(formula);
            this.getFormulaParamMap().put(formula, formulaParam);
        }
        return this.isDetailItem(formulaParam);
    }

    protected boolean isDetailItem(String[] formulaParam) {
        String[] itemNumbers = formulaParam[0].split(",");
        for (int i = 0; i < itemNumbers.length; ++i) {
            String number;
            if (StringUtils.isEmpty((String)itemNumbers[i])) {
                return false;
            }
            String srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
            if (this.check(srcNumber, number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean canSave(String formula, String editScen, String versionNumber) {
        if (StringUtils.isEmpty((String)formula) || this.leafMap == null || this.leafMap.isEmpty()) {
            return false;
        }
        if (!StringUtils.isEmpty((String)versionNumber) && !this.check(DimensionConstants.DEF_VERSION_SRCNUMBER, versionNumber)) {
            return false;
        }
        String[] formulaParam = null;
        if (this.getFormulaParamMap().containsKey(formula)) {
            formulaParam = this.getFormulaParamMap().get(formula);
        } else {
            formulaParam = BgNFSHelper.parseFormulaPara(formula);
            this.getFormulaParamMap().put(formula, formulaParam);
        }
        String scen = formulaParam[3];
        if (!StringUtils.isEmpty((String)editScen)) {
            Set<Object> editScenSet = null;
            if (this.getCacheScenMap().containsKey(editScen)) {
                editScenSet = this.getCacheScenMap().get(editScen);
            } else {
                editScenSet = new HashSet();
                this.getCacheScenMap().put(editScen, editScenSet);
                String[] tmpStrs = editScen.split(",");
                if (tmpStrs != null) {
                    int in = tmpStrs.length;
                    for (int i = 0; i < in; ++i) {
                        editScenSet.add(tmpStrs[i]);
                    }
                }
            }
            if (scen == null || !editScenSet.isEmpty() && !editScenSet.contains(scen)) {
                return false;
            }
        } else if (editScen != null) {
            return false;
        }
        if (!this.check(DimensionConstants.DEF_SCENARIO_SRCNUMBER, formulaParam[3])) {
            return false;
        }
        if (!this.check(DimensionConstants.DEF_CURRENCY_SRCNUMBER, formulaParam[5])) {
            return false;
        }
        if (!this.check(DimensionConstants.DEF_ELEMENT_SRCNUMBER, formulaParam[2])) {
            return false;
        }
        if (!this.check(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulaParam[1])) {
            return false;
        }
        return this.isDetailItem(formulaParam);
    }

    public boolean canEditCurrency(String formula, String currencyNumber) {
        if (StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)currencyNumber)) {
            return true;
        }
        String[] formulaParam = null;
        if (this.getFormulaParamMap().containsKey(formula)) {
            formulaParam = this.getFormulaParamMap().get(formula);
        } else {
            formulaParam = BgNFSHelper.parseFormulaPara(formula);
            this.getFormulaParamMap().put(formula, formulaParam);
        }
        return currencyNumber.equals(formulaParam[5]);
    }

    public boolean canSave(BgNDataInfo dataInfo, String editScen, String versionNumber) {
        if (dataInfo == null) {
            return false;
        }
        return this.canSave(dataInfo.getFormula(), editScen, versionNumber);
    }

    public List<BgDimensionMember> getRelationMember(BgDimensionInfo dimension) throws EASBizException, BOSException {
        if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) {
            return dimension.getMember();
        }
        HashMap<String, BgDimensionMember> members = new HashMap<String, BgDimensionMember>();
        for (int r = 0; r < dimension.getMappingList().size(); ++r) {
            DimensionRelationshipGroupInfo group = dimension.getMappingList().get(r);
            Map<String, BgDimensionMember> tempMembers = this.getRelationMember(dimension, group);
            if (tempMembers == null || tempMembers.isEmpty()) {
                members.clear();
                break;
            }
            if (r == 0) {
                members.putAll(tempMembers);
                continue;
            }
            BgViewHelper.retainAll(members, tempMembers);
        }
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        result.addAll(members.values());
        Collections.sort(result);
        return result;
    }

    private Map<String, BgDimensionMember> getRelationMember(BgDimensionInfo dimension, DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        HashMap<String, Set<String>> hasMember = new HashMap<String, Set<String>>();
        for (BgDimensionInfo otherDim : dimension.getDimensionManager().getDimension()) {
            if (otherDim == dimension || otherDim.isMapping() && otherDim.getMember().isEmpty()) continue;
            for (int m = 0; m < otherDim.getMember().size(); ++m) {
                BgDimensionMember member = (BgDimensionMember)otherDim.getMember().get(m);
                if (!hasMember.containsKey(member.getSrcNumberHasDefault())) {
                    hasMember.put(member.getSrcNumberHasDefault(), new HashSet());
                }
                ((Set)hasMember.get(member.getSrcNumberHasDefault())).add(member.getNumber());
            }
        }
        DimensionMemberRelationShipHelper helper = this.getRelationHelper(group.getId().toString(), dimension.getDimensionManager().getSheet().getViewManager().getRelationMaps());
        if (helper != null) {
            return helper.getMembers(dimension, hasMember);
        }
        return new HashMap<String, BgDimensionMember>();
    }

    public boolean check(String srcNumber, String number) {
        if (this.leafMap != null && this.leafMap.containsKey(srcNumber)) {
            return this.leafMap.get(srcNumber).contains(number);
        }
        return false;
    }

    private void setNeedCheck(String orgId, String bgTemplateId, boolean isDecomposeSend) throws BOSException, EASBizException {
        this.orgId = orgId;
        if (this.schemeHelper == null) {
            this.isNeedCheck = false;
        } else if (isDecomposeSend) {
            this.isNeedCheck = true;
        } else if (this.getCacheHelper() != null && this.getCacheHelper().getOrgLeafMap() != null && this.getCacheHelper().getOrgLeafMap().get(orgId) != null) {
            this.isNeedCheck = this.getCacheHelper().getOrgLeafMap().get(orgId);
        } else {
            this.isNeedCheck = this.getFormulaFacade().isLeaf(orgId, bgTemplateId, this.schemeHelper.getBgSchemeId());
            if (this.isDecompose) {
                this.isNeedCheck = !this.isNeedCheck;
            }
        }
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    private IDimensionFormulaFacade getFormulaFacade() throws BOSException {
        if (this.ctx == null) {
            return DimensionFormulaFacadeFactory.getRemoteInstance();
        }
        return DimensionFormulaFacadeFactory.getLocalInstance(this.ctx);
    }

    private void processCombinMembers(MbgViewListRowCol rowColObject, Map<String, Set<String>> members) {
        ArrayList<BgDimensionMember> combinMembers = new ArrayList<BgDimensionMember>();
        combinMembers.addAll(rowColObject.getCombinMembers());
        combinMembers.addAll(rowColObject.getCombinSelectMembers());
        for (int i = 0; i < combinMembers.size(); ++i) {
            BgDimensionMember comMember = (BgDimensionMember)combinMembers.get(i);
            String[] numbers = DimensionFormulaHelper.splitCombinations(comMember.getNumber());
            String[] srcNumbers = DimensionFormulaHelper.splitCombinations(comMember.getSrcNumber());
            for (int m = 0; m < numbers.length; ++m) {
                String srcNumber;
                if (StringUtils.isEmpty((String)numbers[m])) continue;
                String number = numbers[m];
                String string = srcNumber = srcNumbers == null ? "" : srcNumbers[m];
                if (StringUtils.isEmpty((String)srcNumber) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(srcNumber) || DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) continue;
                if (!members.containsKey(srcNumber)) {
                    members.put(srcNumber, new HashSet());
                }
                members.get(srcNumber).add(number);
            }
        }
    }

    private void processMembers(List dimens, Map<String, Set<String>> members) {
        String srcNumber = null;
        for (int d = 0; d < dimens.size(); ++d) {
            BgDimensionMember member;
            BgDimensionBaseInfo dimen;
            if (!(dimens.get(d) instanceof BgDimensionBaseInfo) || (dimen = (BgDimensionBaseInfo)dimens.get(d)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            for (int m = 0; m < dimen.getMember().size(); ++m) {
                member = (BgDimensionMember)dimen.getMember().get(m);
                srcNumber = member.getSrcNumberHasDefault();
                if (srcNumber == null) continue;
                if (!members.containsKey(srcNumber)) {
                    members.put(srcNumber, new HashSet());
                }
                members.get(srcNumber).add(member.getNumber());
            }
            if (!(dimen instanceof MbgViewListDimensionInfo)) continue;
            List selectMembers = ((MbgViewListDimensionInfo)dimen).getSelectMembers();
            for (int m = 0; m < selectMembers.size(); ++m) {
                if (selectMembers.get(m) instanceof BgDimensionMember) {
                    member = (BgDimensionMember)selectMembers.get(m);
                    if (srcNumber == null) continue;
                    if (!members.containsKey(srcNumber)) {
                        members.put(srcNumber, new HashSet());
                    }
                    members.get(srcNumber).add(member.getNumber());
                    continue;
                }
                if (!(selectMembers.get(m) instanceof DataBaseInfo)) continue;
                DataBaseInfo info = (DataBaseInfo)selectMembers.get(m);
                if (srcNumber == null) continue;
                if (!members.containsKey(srcNumber)) {
                    members.put(srcNumber, new HashSet());
                }
                members.get(srcNumber).add(info.getNumber());
            }
        }
    }

    private void processRowColMembers(MbgViewListSheetManager sheetManager, Map<String, Set<String>> members) {
        List<IMbgViewListObject> rows = sheetManager.getDimensionManager().getRowCols();
        for (int r = 0; r < rows.size(); ++r) {
            if (!(rows.get(r) instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol object = (MbgViewListRowCol)rows.get(r);
            if (object.isCombin()) {
                this.processCombinMembers(object, members);
                continue;
            }
            this.processMembers(object.getDimensions(), members);
        }
    }

    protected void init(IMbgViewBase view) throws BOSException, EASBizException {
        List dimens;
        int s;
        IMbgViewBase tmpView;
        long ct = System.currentTimeMillis();
        if (view == null || !this.isNeedCheck()) {
            return;
        }
        HashMap<String, Set<String>> members = new HashMap<String, Set<String>>();
        if (view instanceof IMbgViewManager) {
            tmpView = (IMbgViewManager)view;
            for (s = 0; s < tmpView.getSheetManagers().size(); ++s) {
                dimens = tmpView.getSheetManagers().get(s).getDimensionManager().getDimension();
                this.processMembers(dimens, members);
            }
        } else if (view instanceof MbgViewListManager) {
            tmpView = (MbgViewListManager)view;
            for (s = 0; s < ((AbstractMbgViewBase)tmpView).getSheetManagers().size(); ++s) {
                dimens = ((MbgViewListSheetManager)((AbstractMbgViewBase)tmpView).getSheetManagers().get(s)).getDimensionManager().getDimension();
                this.processMembers(dimens, members);
                this.processRowColMembers((MbgViewListSheetManager)((AbstractMbgViewBase)tmpView).getSheetManagers().get(s), members);
            }
        }
        HashMap<String, BgDimensionInfo> dimensions = new HashMap<String, BgDimensionInfo>();
        List<String> dims = this.schemeHelper.getAllDim();
        dims.remove(DimensionConstants.DEF_ORGUNIT_NUMBER);
        for (int i = 0; i < dims.size(); ++i) {
            BgDimensionInfo dimen = this.schemeHelper.getDimension(dims.get(i));
            String srcNumber = this.schemeHelper.getSrcNumber(dimen.getNumber());
            dimensions.put(srcNumber, dimen);
            if (!memberDims.contains(dimen.getNumber()) || !members.containsKey(srcNumber)) continue;
            ((Set)members.get(srcNumber)).retainAll(this.schemeHelper.getMemberSet(dimen.getNumber(), true));
            if (!((Set)members.get(srcNumber)).isEmpty()) continue;
            this.leafMap.clear();
            return;
        }
        Map<String, Set<String>> queryMembers = members;
        if (this.cacheHelper.getMemberCacheHelper() != null) {
            queryMembers = this.cacheHelper.getMemberCacheHelper().removeInChache(this.orgId, members);
        }
        boolean isEmpty = true;
        for (Set subSet : queryMembers.values()) {
            if (subSet.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        this.leafMap = !isEmpty ? this.getFormulaFacade().getLeafMember(this.orgId, this.schemeHelper.getBgSchemeId(), queryMembers, dimensions, this.isBgCsl()) : new HashMap<String, Set<String>>();
        if (this.cacheHelper.getMemberCacheHelper() != null) {
            this.leafMap = this.cacheHelper.getMemberCacheHelper().margeLeafMap(this.orgId, members, this.leafMap);
        }
        logger.info((Object)("init Check Helper:" + (System.currentTimeMillis() - ct) + "ms"));
    }

    protected boolean isBgCsl() {
        return false;
    }

    public static DimensionMemberCheckHelper getLocalIntance(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, Collection formulas, boolean isDecompose) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, formulas, null, isDecompose, false);
    }

    public static DimensionMemberCheckHelper getLocalIntance(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, Collection formulas, boolean isDecompose, boolean isDecomposeSend) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, formulas, null, isDecompose, isDecomposeSend);
    }

    public static DimensionMemberCheckHelper getLocalIntance(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, Collection formulas, Set<String> versionNumber, boolean isDecompose) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, formulas, versionNumber, isDecompose, false);
    }

    public static DimensionMemberCheckHelper getRemoteIntance(DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, Collection formulas, Set<String> versionNumber, boolean isDecompose) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(null, cacheHelper, orgId, bgTemplateId, schemeHelper, formulas, versionNumber, isDecompose, false);
    }

    public static DimensionMemberCheckHelper getLocalIntance(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, IMbgViewBase view, boolean isDecompose) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, view, isDecompose, false);
    }

    public static DimensionMemberCheckHelper getRemoteIntance(DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, IMbgViewBase view, boolean isDecompose) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.buildHelper(null, cacheHelper, orgId, bgTemplateId, schemeHelper, view, isDecompose, false);
    }

    private static DimensionMemberCheckHelper buildHelper(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, IMbgViewBase view, boolean isDecompose, boolean isDecomposeSend) throws BOSException, EASBizException {
        DimensionMemberCheckHelper helper = new DimensionMemberCheckHelper(ctx, cacheHelper, schemeHelper, isDecompose);
        helper.setNeedCheck(orgId, bgTemplateId, isDecomposeSend);
        helper.init(view);
        return helper;
    }

    private static DimensionMemberCheckHelper buildHelper(Context ctx, DimensionCacheHelper cacheHelper, String orgId, String bgTemplateId, BgSchemeDimensionHelper schemeHelper, Collection formulas, Set<String> versionNumber, boolean isDecompose, boolean isDecomposeSend) throws BOSException, EASBizException {
        MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager(ctx, formulas, versionNumber);
        return DimensionMemberCheckHelper.buildHelper(ctx, cacheHelper, orgId, bgTemplateId, schemeHelper, view, isDecompose, isDecomposeSend);
    }

    public DimensionMemberRelationShipHelper getRelationHelper(String relationGroupId, List<MbgRelationMap> relationMaps) throws EASBizException, BOSException {
        if (!this.relationHelpers.containsKey(relationGroupId)) {
            this.relationHelpers.put(relationGroupId, DimensionMemberRelationShipHelper.buildHelper(this.ctx, this.cacheHelper, relationGroupId, this.orgId, relationMaps));
        }
        return this.relationHelpers.get(relationGroupId);
    }

    public boolean hasRelation(BgDimensionInfo bgDimensionInfo) {
        if (bgDimensionInfo == null) {
            return false;
        }
        return this.getDimensionRelation(bgDimensionInfo.getDimensionManager()).containsKey(bgDimensionInfo.getNumber());
    }

    public void cleanDimensionRelation() {
        this.dimensionRelation = null;
    }

    private Map<String, Set<String>> getDimensionRelation(IBgDimensionManager dimensionManager) {
        if (this.dimensionRelation == null) {
            this.dimensionRelation = new HashMap<String, Set<String>>();
            for (int d = 0; d < dimensionManager.getDimension().size(); ++d) {
                BgDimensionInfo dimension = (BgDimensionInfo)dimensionManager.getDimension().get(d);
                if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                for (int m = 0; m < dimension.getMappingList().size(); ++m) {
                    DimensionRelationshipGroupInfo group = dimension.getMappingList().get(m);
                    if ((group = this.cacheHelper.getRelationGroup(group.getId().toString())) == null) continue;
                    for (int s = 0; s < group.getEntries().size(); ++s) {
                        String dimensionNumber = group.getEntries().get(s).getDimNumber();
                        if (!this.dimensionRelation.containsKey(dimensionNumber)) {
                            this.dimensionRelation.put(dimensionNumber, new HashSet());
                        }
                        this.dimensionRelation.get(dimensionNumber).add(group.getId().toString());
                    }
                }
            }
        }
        return this.dimensionRelation;
    }

    public String getEditScen(IMbgViewBase view, int sheetIndex, BgScenarioType scenType) throws EASBizException, BOSException {
        if (view == null || sheetIndex < 0 || sheetIndex >= view.getSheetManagers().size()) {
            return "";
        }
        String editScen = view.getSheetManagers().get(sheetIndex).getEditScenNumber();
        return this.cacheHelper.getEditScen(editScen, scenType);
    }

    public boolean isBudgetScen(String scenarioNum) {
        boolean re = false;
        try {
            re = this.cacheHelper.getBudgetScens().contains(scenarioNum);
        }
        catch (Exception ex) {
            logger.error((Object)"get Budget Scenario Error:", (Throwable)ex);
        }
        return re;
    }

    public boolean isActualScen(String scenarioNum) {
        boolean re = false;
        try {
            re = this.cacheHelper.getActualScens().contains(scenarioNum);
        }
        catch (Exception ex) {
            logger.error((Object)"get Budget Scenario Error:", (Throwable)ex);
        }
        return re;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void clearCtx() {
        this.ctx = null;
    }

    public void addCheckHelper(DimensionMemberCheckHelper newCheckHelper) {
        if (newCheckHelper == null || newCheckHelper.leafMap == null || newCheckHelper.leafMap.isEmpty()) {
            return;
        }
        if (this.leafMap == null) {
            this.leafMap = newCheckHelper.leafMap;
        } else {
            for (String key : newCheckHelper.leafMap.keySet()) {
                if (this.leafMap.containsKey(key)) {
                    this.leafMap.get(key).addAll((Collection<String>)newCheckHelper.leafMap.get(key));
                    continue;
                }
                this.leafMap.put(key, newCheckHelper.leafMap.get(key));
            }
        }
    }

    static {
        memberDims.add(DimensionConstants.DEF_CURRENCY_NUMBER);
        memberDims.add(DimensionConstants.DEF_SCENARIO_NUMBER);
        memberDims.add(DimensionConstants.DEF_ELEMENT_NUMBER);
        memberDims.add(DimensionConstants.DEF_VERSION_NUMBER);
    }

    public static class DimensionNullCheckHelper
    extends DimensionMemberCheckHelper {
        public DimensionNullCheckHelper() {
            super(null, null, null);
        }

        @Override
        public boolean canSave(String formula, String editScen, String versionNumber) {
            return false;
        }

        @Override
        public boolean isNeedCheck() {
            return false;
        }
    }
}

