/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.ActualRecordSourceTypeEnum;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FormulaUtils {
    private static String LEFT_BRACKET = "(";
    private static String RIGHT_BRACKET = ")";
    public static int MBGFORMULA_PARAM_LENGTH = 9;
    public static int MBGACTUALS_PARAM_LENGTH = 9;
    public static int MBGAGGREGATE_PARAM_LENGTH = 12;
    public static int MBGREFBGFORM_PARAM_LENGTH = 4;
    public static int MBGREFBGTEM_PARAM_LENGTH = 9;
    private static Map<String, BgScenarioInfo> bgScenarioMap = null;
    public static int ARRAY_INDEX_ORG = 0;
    public static int ARRAY_INDEX_SCHEME = 1;
    public static int ARRAY_INDEX_SCENARIO = 2;
    public static int ARRAY_INDEX_DIMITEM = 3;
    public static int ARRAY_INDEX_PERIOD_BEGIN = 4;
    public static int ARRAY_INDEX_PERIOD_END = 5;
    public static int ARRAY_INDEX_VERSION = 6;
    public static int ARRAY_INDEX_CURRENCY = 7;
    public static int ARRAY_INDEX_ELEMENT = 8;
    public static int ARRAY_INDEX_DATASTATE = 9;
    public static int ARRAY_INDEX_PROCESSTYPE = 10;

    public static Map<String, BgScenarioInfo> getBgScenarioMap() {
        if (bgScenarioMap == null) {
            try {
                bgScenarioMap = BgScenarioHelper.getScenariooObjMap();
            }
            catch (BOSException e) {
                bgScenarioMap = new HashMap<String, BgScenarioInfo>();
            }
        }
        return bgScenarioMap;
    }

    public static void clearBgScenario() {
        if (bgScenarioMap != null) {
            bgScenarioMap = null;
        }
    }

    public static String getMbgFormulaExp(String orgUnitNum, String bgSchemeNum, String bgScenarioNum, String mbgItemNum, String beginPeriodNum, String endPeriodNum, String versionNum, String currencyNum, String bgElementNum) {
        return BgNConstants.EQUALS_STR + "MbgFormula" + LEFT_BRACKET + "\"" + orgUnitNum + "\",\"" + bgSchemeNum + "\",\"" + bgScenarioNum + "\",\"" + mbgItemNum + "\",\"" + beginPeriodNum + "\",\"" + endPeriodNum + "\",\"" + versionNum + "\",\"" + currencyNum + "\",\"" + bgElementNum + "\"" + RIGHT_BRACKET;
    }

    public static String getMbgActualsExp(String orgUnitNum, String bgSchemeNum, String bgScenarioNum, String mbgItemNum, String beginPeriodNum, String endPeriodNum, String versionNum, String currencyNum, String bgElementNum, ActualRecordSourceTypeEnum source) {
        if (source == null) {
            source = ActualRecordSourceTypeEnum.all;
        }
        return BgNConstants.EQUALS_STR + "MbgActuals" + LEFT_BRACKET + "\"" + orgUnitNum + "\",\"" + bgSchemeNum + "\",\"" + bgScenarioNum + "\",\"" + mbgItemNum + "\",\"" + beginPeriodNum + "\",\"" + endPeriodNum + "\",\"" + currencyNum + "\",\"" + bgElementNum + "\",\"" + source.getName() + "\"" + RIGHT_BRACKET;
    }

    public static String getMbgControlExp(String orgUnitNum, String bgSchemeNum, String bgScenarioNum, String mbgItemNum, String beginPeriodNum, String endPeriodNum, String versionNum, String currencyNum, String bgElementNum) {
        return BgNConstants.EQUALS_STR + "MbgControl" + LEFT_BRACKET + "\"" + orgUnitNum + "\",\"" + bgSchemeNum + "\",\"" + bgScenarioNum + "\",\"" + mbgItemNum + "\",\"" + beginPeriodNum + "\",\"" + endPeriodNum + "\",\"" + currencyNum + "\",\"" + bgElementNum + "\"" + RIGHT_BRACKET;
    }

    public static String getMbgAggregateExp(String orgUnitNum, String bgSchemeNum, String bgScenarioNum, String mbgItemNum, String beginPeriodNum, String endPeriodNum, String versionNum, String currencyNum, String bgElementNum, AggregateDataTypeEnum source, String dataState, BgProcessEnum processType) {
        if (source == null) {
            source = AggregateDataTypeEnum.budget;
        }
        return BgNConstants.EQUALS_STR + "MbgAggregate" + LEFT_BRACKET + "\"" + orgUnitNum + "\",\"" + bgSchemeNum + "\",\"" + bgScenarioNum + "\",\"" + mbgItemNum + "\",\"" + beginPeriodNum + "\",\"" + endPeriodNum + "\",\"" + versionNum + "\",\"" + currencyNum + "\",\"" + bgElementNum + "\",\"" + source.getName() + "\",\"" + (dataState == null ? "" : dataState) + "\",\"" + (processType == null ? "" : processType.getName()) + "\"" + RIGHT_BRACKET;
    }

    public static FunctionExpr replaceExprParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        if ("MbgFormula".equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = FormulaUtils.replaceMBgFormulaParams(funExpr, expParams);
        } else if ("MbgActuals".equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = FormulaUtils.replaceMBgActualsParams(funExpr, expParams);
        } else if ("MbgAggregate".equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = FormulaUtils.replaceMbgAggregateParams(funExpr, expParams);
        } else if ("MbgControl".equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = FormulaUtils.replaceMbgControlParams(funExpr, expParams);
        } else if ("Mbgadjust".equalsIgnoreCase(funExpr.funcionName)) {
            funExpr = FormulaUtils.replaceMbgAdjustParams(funExpr, expParams);
        }
        return funExpr;
    }

    protected static FunctionExpr replaceMbgAdjustParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        FormulaUtils.updateParams(funExpr);
        FormulaUtils.checkParam(funExpr, 0, expParams, ARRAY_INDEX_ORG);
        FormulaUtils.checkParam(funExpr, 1, expParams, ARRAY_INDEX_SCHEME);
        FormulaUtils.checkParamBgScenario(funExpr, 2, expParams, ARRAY_INDEX_SCENARIO);
        FormulaUtils.checkParam(funExpr, 3, expParams, ARRAY_INDEX_DIMITEM);
        FormulaUtils.checkParam(funExpr, 4, expParams, ARRAY_INDEX_PERIOD_BEGIN);
        FormulaUtils.checkParam(funExpr, 5, expParams, ARRAY_INDEX_PERIOD_END);
        FormulaUtils.checkParam(funExpr, 6, expParams, ARRAY_INDEX_VERSION);
        FormulaUtils.checkParam(funExpr, 7, expParams, ARRAY_INDEX_CURRENCY);
        FormulaUtils.checkParam(funExpr, 8, expParams, ARRAY_INDEX_ELEMENT);
        FormulaUtils.checkParam(funExpr, 11, expParams, ARRAY_INDEX_PROCESSTYPE);
        return funExpr;
    }

    protected static FunctionExpr replaceMbgControlParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        FormulaUtils.checkParam(funExpr, 0, expParams, ARRAY_INDEX_ORG);
        FormulaUtils.checkParam(funExpr, 1, expParams, ARRAY_INDEX_SCHEME);
        FormulaUtils.checkParam(funExpr, 2, expParams, ARRAY_INDEX_SCENARIO);
        FormulaUtils.checkParam(funExpr, 3, expParams, ARRAY_INDEX_DIMITEM);
        FormulaUtils.checkParam(funExpr, 4, expParams, ARRAY_INDEX_PERIOD_BEGIN);
        FormulaUtils.checkParam(funExpr, 5, expParams, ARRAY_INDEX_PERIOD_END);
        FormulaUtils.checkParam(funExpr, 6, expParams, ARRAY_INDEX_CURRENCY);
        FormulaUtils.checkParam(funExpr, 7, expParams, ARRAY_INDEX_ELEMENT);
        return funExpr;
    }

    protected static FunctionExpr replaceMBgFormulaParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        FormulaUtils.checkParam(funExpr, 0, expParams, ARRAY_INDEX_ORG);
        FormulaUtils.checkParam(funExpr, 1, expParams, ARRAY_INDEX_SCHEME);
        FormulaUtils.checkParam(funExpr, 2, expParams, ARRAY_INDEX_SCENARIO);
        FormulaUtils.checkParam(funExpr, 3, expParams, ARRAY_INDEX_DIMITEM);
        FormulaUtils.checkParam(funExpr, 4, expParams, ARRAY_INDEX_PERIOD_BEGIN);
        FormulaUtils.checkParam(funExpr, 5, expParams, ARRAY_INDEX_PERIOD_END);
        FormulaUtils.checkParam(funExpr, 6, expParams, ARRAY_INDEX_VERSION);
        FormulaUtils.checkParam(funExpr, 7, expParams, ARRAY_INDEX_CURRENCY);
        FormulaUtils.checkParam(funExpr, 8, expParams, ARRAY_INDEX_ELEMENT);
        return funExpr;
    }

    protected static FunctionExpr replaceMBgActualsParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        FormulaUtils.checkParam(funExpr, 0, expParams, ARRAY_INDEX_ORG);
        FormulaUtils.checkParam(funExpr, 1, expParams, ARRAY_INDEX_SCHEME);
        FormulaUtils.checkParam(funExpr, 2, expParams, ARRAY_INDEX_SCENARIO);
        FormulaUtils.checkParam(funExpr, 3, expParams, ARRAY_INDEX_DIMITEM);
        FormulaUtils.checkParam(funExpr, 4, expParams, ARRAY_INDEX_PERIOD_BEGIN);
        FormulaUtils.checkParam(funExpr, 5, expParams, ARRAY_INDEX_PERIOD_END);
        FormulaUtils.checkParam(funExpr, 6, expParams, ARRAY_INDEX_CURRENCY);
        FormulaUtils.checkParam(funExpr, 7, expParams, ARRAY_INDEX_ELEMENT);
        return funExpr;
    }

    protected static FunctionExpr replaceMbgAggregateParams(FunctionExpr funExpr, String[] expParams) {
        if (funExpr == null || expParams == null) {
            return funExpr;
        }
        FormulaUtils.updateParams(funExpr);
        FormulaUtils.checkParam(funExpr, 0, expParams, ARRAY_INDEX_ORG);
        FormulaUtils.checkParam(funExpr, 1, expParams, ARRAY_INDEX_SCHEME);
        FormulaUtils.checkParamBgScenario(funExpr, 2, expParams, ARRAY_INDEX_SCENARIO);
        FormulaUtils.checkParam(funExpr, 3, expParams, ARRAY_INDEX_DIMITEM);
        FormulaUtils.checkParam(funExpr, 4, expParams, ARRAY_INDEX_PERIOD_BEGIN);
        FormulaUtils.checkParam(funExpr, 5, expParams, ARRAY_INDEX_PERIOD_END);
        FormulaUtils.checkParam(funExpr, 6, expParams, ARRAY_INDEX_VERSION);
        FormulaUtils.checkParam(funExpr, 7, expParams, ARRAY_INDEX_CURRENCY);
        FormulaUtils.checkParam(funExpr, 8, expParams, ARRAY_INDEX_ELEMENT);
        FormulaUtils.checkParam(funExpr, 10, expParams, ARRAY_INDEX_DATASTATE);
        FormulaUtils.checkParam(funExpr, 11, expParams, ARRAY_INDEX_PROCESSTYPE);
        Object dataState = funExpr.parameters.get(10);
        if (dataState instanceof StringExpr && !StringUtils.isEmpty((String)((StringExpr)dataState).value) && funExpr.parameters.get(9) instanceof StringExpr) {
            StringExpr type = (StringExpr)funExpr.parameters.get(9);
            if (!StringUtils.isEmpty((String)type.value) && !AggregateDataTypeEnum.budget.getName().equalsIgnoreCase(type.value)) {
                funExpr.parameters.set(10, new StringExpr(""));
            }
        }
        return funExpr;
    }

    private static void checkParamBgScenario(FunctionExpr funExpr, int checkIndex, String[] expParams, int paramIndex) {
        if (funExpr == null || expParams == null) {
            return;
        }
        if (expParams.length <= paramIndex || StringUtils.isEmpty((String)expParams[paramIndex])) {
            return;
        }
        List parameter = funExpr.parameters;
        if (parameter.size() <= checkIndex) {
            return;
        }
        Object obj = parameter.get(checkIndex);
        if (obj instanceof StringExpr) {
            StringExpr _param = (StringExpr)obj;
            if (!FormulaUtils.getBgScenarioMap().containsKey(expParams[paramIndex])) {
                return;
            }
            BgScenarioInfo bgScenarioInfo = FormulaUtils.getBgScenarioMap().get(expParams[paramIndex]);
            if ("MbgAggregate".equalsIgnoreCase(funExpr.funcionName) && parameter.size() > 10 && parameter.get(9) instanceof StringExpr) {
                StringExpr aggDataType = (StringExpr)parameter.get(9);
                if (AggregateDataTypeEnum.budget.getName().equals(aggDataType.value) && BgScenarioType.BudgetData.equals((Object)bgScenarioInfo.getType()) || !AggregateDataTypeEnum.budget.getName().equals(aggDataType.value) && BgScenarioType.ActualData.equals((Object)bgScenarioInfo.getType())) {
                    _param.value = new String(expParams[paramIndex]);
                }
            } else if ("Mbgadjust".equalsIgnoreCase(funExpr.funcionName) && BgScenarioType.BudgetData.equals((Object)bgScenarioInfo.getType())) {
                _param.value = new String(expParams[paramIndex]);
            }
        }
    }

    private static void checkParam(FunctionExpr funExpr, int checkIndex, String[] expParams, int paramIndex) {
        if (funExpr == null || expParams == null) {
            return;
        }
        if (expParams.length <= paramIndex || StringUtils.isEmpty((String)expParams[paramIndex])) {
            return;
        }
        List parameter = funExpr.parameters;
        if (parameter.size() <= checkIndex) {
            return;
        }
        Object obj = parameter.get(checkIndex);
        if (obj instanceof StringExpr) {
            StringExpr _param = (StringExpr)obj;
            _param.value = new String(expParams[paramIndex]);
        }
    }

    public static void updateParams(FunctionExpr funExpr) {
        if (funExpr == null) {
            return;
        }
        FormulaUtils.updateParams(funExpr.funcionName, funExpr.parameters);
    }

    public static Object[] updateParams(String funcionName, Parameter parameter) {
        if (parameter.getArgs() == null || parameter.getArgs().length == 0) {
            return parameter.getArgs();
        }
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(parameter.getArgs()));
        FormulaUtils.updateParams(funcionName, list);
        return list.toArray();
    }

    public static void updateParams(String funcionName, List params) {
        if ("MbgAggregate".equalsIgnoreCase(funcionName)) {
            FormulaUtils.updateMBgAggregateParams(params);
        } else if ("Mbgadjust".equalsIgnoreCase(funcionName)) {
            FormulaUtils.updateMBgAdjustParams(params);
        } else if ("MbgRefBgTem".equalsIgnoreCase(funcionName)) {
            FormulaUtils.updateMbgRefBgTemplateParams(params);
        }
    }

    private static void updateMbgRefBgTemplateParams(List params) {
        int size = FormulaUtils.getSize(params);
        if (size < 9) {
            FormulaUtils.addNullParam(params, size);
        }
    }

    private static void updateMBgAdjustParams(List params) {
        int size = FormulaUtils.getSize(params);
        if (size < 12) {
            FormulaUtils.addNullParam(params, size);
        }
    }

    private static void updateMBgAggregateParams(List params) {
        int size = FormulaUtils.getSize(params);
        if (size < 11) {
            FormulaUtils.addNullParam(params, size);
            FormulaUtils.addNullParam(params, size);
        } else if (size == 11) {
            FormulaUtils.addNullParam(params, 10);
        }
    }

    public static String[] updateParams(String funcionName, String[] formulaParam) {
        if (formulaParam == null) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(formulaParam));
        FormulaUtils.updateParams(funcionName, params);
        String[] newParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            newParams[i] = params.get(i) instanceof String ? (String)params.get(i) : (params.get(i) instanceof StringExpr ? ((StringExpr)params.get((int)i)).value : StringUtils.cnulls(params.get(i)));
        }
        return newParams;
    }

    public static int getSize(Object params) {
        if (params instanceof List) {
            return ((List)params).size();
        }
        if (params instanceof Parameter) {
            return ((Parameter)params).count();
        }
        return 0;
    }

    private static void addNullParam(List params, int index) {
        StringExpr nullExpr = new StringExpr("");
        if (!params.isEmpty() && !(params.get(0) instanceof Expression)) {
            nullExpr = Variant.emptyVariant;
        }
        if (params.size() <= index) {
            params.add(nullExpr);
        } else {
            params.add(index, nullExpr);
        }
    }
}

