/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillCollection;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgAdjustBillTypeEnum;
import com.kingdee.eas.ma.mbg.BgAdjustRuleFactory;
import com.kingdee.eas.ma.mbg.BgAdjustRuleInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.MBgAdjustConstants;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;

public class MBGAdjustBillHelper {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgAdjustBillResource";
    public static final String BGADJUSTRULE_RESOURCE = "com.kingdee.eas.ma.mbg.BgAdjustRuleResource";
    private static Map<String, Date> pNumberMap = new HashMap<String, Date>();

    public static Map<Integer, String> sortRefField(Set<String> tempDims) {
        if (MBGAdjustBillHelper.checkParamsIsNull(tempDims)) {
            return null;
        }
        TreeMap<Object, String> sortMap = new TreeMap<Object, String>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Integer value1 = Integer.valueOf(o1.toString());
                Integer value2 = Integer.valueOf(o2.toString());
                return value1 - value2;
            }
        });
        for (String str : tempDims) {
            sortMap.put(Integer.parseInt(str.substring(1)), str);
        }
        return sortMap;
    }

    public static Map<String, List<String>> extractCombinDimension(Map<String, List<String>> refDimens, Set<String> tempDims, Set<String> srcNumberSet) {
        if (MBGAdjustBillHelper.checkParamsIsNull(refDimens, tempDims, srcNumberSet)) {
            return null;
        }
        HashMap<String, List<String>> indexGroupMap = new HashMap<String, List<String>>();
        for (String key : refDimens.keySet()) {
            String[] dimMembers;
            String keyStr;
            if (key == null || (keyStr = key.toString()).indexOf(",") <= -1 || (dimMembers = keyStr.split(",")) == null) continue;
            for (int i = 0; i < dimMembers.length; ++i) {
                String string = dimMembers[i];
                if (string == null || string.startsWith("BgE")) continue;
                String e = string.split(":")[0];
                srcNumberSet.add(e);
                List<String> value = refDimens.get(key);
                if (value == null || !(value instanceof List)) continue;
                List<String> temp = value;
                tempDims.addAll(temp);
                indexGroupMap.put(e, temp);
            }
        }
        return indexGroupMap;
    }

    public static Map<String, List<String>> extractCombinDimension(BgSchemeDimensionHelper schemeHelper, Set<String> tempDims, Set<String> srcNumberSet) {
        if (MBGAdjustBillHelper.checkParamsIsNull(schemeHelper, tempDims, srcNumberSet)) {
            return null;
        }
        HashMap<String, List<String>> indexGroupMap = new HashMap<String, List<String>>();
        List<String> lst = schemeHelper.getAccAndOtherDim(false);
        for (String dimNumber : lst) {
            tempDims.add(schemeHelper.getRefField(dimNumber));
            srcNumberSet.add(schemeHelper.getSrcNumber(dimNumber));
        }
        return indexGroupMap;
    }

    public static void addErrorDataInfo(Map<Integer, Map<String, String>> errorDataInfo, Integer key, Map<String, String> value, String errorInfo) {
        if (errorDataInfo == null || key == null || value == null || errorInfo == null) {
            return;
        }
        value.put("MBG_HEADKEY_ERROR", errorInfo);
        errorDataInfo.put(key, value);
    }

    public static boolean checkParamsIsNull(Object ... objects) {
        if (objects == null || objects.length <= 0) {
            return true;
        }
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) continue;
            return true;
        }
        return false;
    }

    public static String trim(Object obj) {
        if (obj == null) {
            return "";
        }
        String str = obj.toString();
        if (str == null || str.length() <= 0) {
            return "";
        }
        return str.trim();
    }

    public static List<BgOrgUnitInfo> getBgOrgUnitList(String viewID, List<OrgUnitInfo> orgUnits) throws BOSException {
        ArrayList<BgOrgUnitInfo> bgOrgUnitList = new ArrayList<BgOrgUnitInfo>();
        if (StringUtils.isEmpty((String)viewID) || EmptyUtil.isEmpty(orgUnits)) {
            return bgOrgUnitList;
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        for (OrgUnitInfo orgUnitInfo : orgUnits) {
            orgIdSet.add(orgUnitInfo.getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(MBGAdjustBillHelper.getBgOrgUnitSelector());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)viewID, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", orgIdSet, CompareType.INCLUDE));
        BgOrgUnitCollection orgUnitColl = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        BgOrgUnitInfo info = null;
        int size = orgUnitColl.size();
        for (int i = 0; i < size; ++i) {
            info = orgUnitColl.get(i);
            bgOrgUnitList.add(info);
        }
        return bgOrgUnitList;
    }

    public static SelectorItemCollection getBgOrgUnitSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgUnitID"));
        sic.add(new SelectorItemInfo("viewID"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isOUSealUp"));
        return sic;
    }

    public static String getString(String key) {
        return EASResource.getString((String)RES, (String)key);
    }

    public static Collection<BgDimensionMember> getDetailDimMember(String orgID, List<BgDimensionMember> dimMemberList, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgID) || dimMemberList == null || dimMemberList.isEmpty()) {
            new HashSet();
        }
        HashMap<String, BgDimensionMember> key2MemberMap = new HashMap<String, BgDimensionMember>();
        HashMap revkey2MemberMap = new HashMap();
        HashMap srcNum2MemberNumMap = new HashMap();
        BgDimensionMember member = null;
        String key = null;
        String srcNum = null;
        Set<String> memberNumSet = null;
        int size = dimMemberList.size();
        for (int i = 0; i < size; ++i) {
            member = dimMemberList.get(i);
            srcNum = member.getSrcNumber();
            key = srcNum + "_" + member.getNumber();
            if (!key2MemberMap.containsKey(key)) {
                key2MemberMap.put(key, member);
            }
            if (!srcNum2MemberNumMap.containsKey(srcNum)) {
                memberNumSet = new HashSet<String>();
                memberNumSet.add(member.getNumber());
                srcNum2MemberNumMap.put(srcNum, memberNumSet);
                continue;
            }
            memberNumSet = (Set)srcNum2MemberNumMap.get(srcNum);
            memberNumSet.add(member.getNumber());
        }
        IDimensionFormulaFacade formulaFacade = DimensionFormulaFacadeFactory.getRemoteInstance();
        Map revMap = formulaFacade.getLeafMember(orgID, schemeHelper.getBgSchemeId(), srcNum2MemberNumMap, schemeHelper.getDimensionBySrcNumber(), false);
        for (Object object : revMap.keySet()) {
            srcNum = (String)object;
            memberNumSet = (HashSet<String>)revMap.get(srcNum);
            if (memberNumSet.isEmpty()) continue;
            for (String memberNum : memberNumSet) {
                if (StringUtils.isEmpty((String)memberNum) || !key2MemberMap.containsKey(key = srcNum + "_" + memberNum)) continue;
                revkey2MemberMap.put(key, key2MemberMap.get(key));
            }
        }
        return revkey2MemberMap.values();
    }

    public static void checkBill(List ids, StringBuffer sb, String billTyPe, boolean isCheckMutex) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("orgunit.name");
        sic.add("orgunit.number");
        sic.add("number");
        sic.add("state");
        sic.add("id");
        view.setSelector(sic);
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        ArrayList<String> cloneIds = new ArrayList<String>(ids);
        Set<String> lockIds = null;
        if (isCheckMutex) {
            try {
                lockIds = MBgCheckHelper.requestMutex(null, ids, true);
                if (lockIds != null) {
                    cloneIds.removeAll(lockIds);
                }
            }
            catch (BOSException e) {
                throw e;
            }
            finally {
                MBgCheckHelper.releaseMutex(null, cloneIds);
            }
        }
        BgAdjustBillCollection bgAdjustBillCollection = BgAdjustBillFactory.getRemoteInstance().getBgAdjustBillCollection(view);
        String actionName = BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.ActionResource", "actionDiscard");
        int failbill = 0;
        for (int i = 0; i < bgAdjustBillCollection.size(); ++i) {
            BgAdjustBillInfo bgAdjustBillInfo = bgAdjustBillCollection.get(i);
            String orgNameAndNumber = bgAdjustBillInfo.getOrgUnit().getNumber() + "(" + bgAdjustBillInfo.getOrgUnit().getName() + ")";
            String billNumber = bgAdjustBillInfo.getNumber();
            if (lockIds != null && lockIds.contains(bgAdjustBillInfo.getId().toString())) {
                sb.append(MessageFormat.format(BgNFCHelper.getMessageStr(RES, "checkLock"), orgNameAndNumber, billNumber, billTyPe, actionName)).append("\r\n");
                ids.remove(bgAdjustBillInfo.getId().toString());
                ++failbill;
                continue;
            }
            if (bgAdjustBillInfo.getState().getValue() != 0 && bgAdjustBillInfo.getState().getValue() != 1) {
                sb.append(MessageFormat.format(BgNFCHelper.getMessageStr(RES, "discardStatecheck"), orgNameAndNumber, billNumber, billTyPe) + "\r\n");
                ids.remove(bgAdjustBillInfo.getId().toString());
                ++failbill;
                continue;
            }
            if (!BgFormHelper.checkInProInst(bgAdjustBillInfo.getId().toString())) continue;
            IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(bgAdjustBillInfo.getId().toString());
            int n = procInsts.length;
            for (int j = 0; j < n; ++j) {
                if (!"open.running".equals(procInsts[j].getState()) && !"open.not_running.suspended".equals(procInsts[j].getState())) continue;
                instInfo = procInsts[j];
            }
            if (instInfo == null) continue;
            ActivityInstInfo[] relatedActInstsByProcInstID = service2.getRelatedActInstsByProcInstID(instInfo.getProcInstId());
            String discardAction = "ActionDiscard";
            boolean isExistDiscardActivity = false;
            for (int m = 0; m < relatedActInstsByProcInstID.length; ++m) {
                if (!"open.not_running.not_started".equals(relatedActInstsByProcInstID[m].getState())) continue;
                AssignmentInfo[] allAssignmentByActInstId = service2.getAllAssignmentByActInstId(relatedActInstsByProcInstID[m].getActInstId());
                for (int n2 = 0; n2 < allAssignmentByActInstId.length; ++n2) {
                    if (!discardAction.equals(allAssignmentByActInstId[n2].getAssignInfo().getBizOperation())) continue;
                    isExistDiscardActivity = true;
                }
            }
            if (isExistDiscardActivity) continue;
            sb.append(MessageFormat.format(BgNFCHelper.getMessageStr(RES, "discardProcedureCheck"), orgNameAndNumber, billNumber, billTyPe) + "\r\n");
            ++failbill;
            ids.remove(bgAdjustBillInfo.getId().toString());
        }
    }

    public static BgAdjustRuleInfo queryBgAdjustRule(BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType) throws BOSException, EASBizException {
        return BgAdjustRuleFactory.getRemoteInstance().queryBgAdjustRuleInfo(schemeHelper.getBgSchemeId(), bgAdjustBillType);
    }

    public static void checkDefaultMember(BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, Map<String, JComponent> componentMap) throws EASBizException, BOSException {
        Map<String, Set<String>> baseMembers;
        BgAdjustRuleInfo info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType);
        if (info != null && (baseMembers = MBGAdjustBillHelper.queryAdjustRuleBaseMembers(info)) != null && !baseMembers.isEmpty()) {
            String dimNum2 = null;
            JComponent cp = null;
            for (String dimNum2 : componentMap.keySet()) {
                cp = componentMap.get(dimNum2);
                if (!(cp instanceof KDBizPromptBox) || ((KDBizPromptBox)cp).getData() == null) continue;
                Object data = ((KDBizPromptBox)cp).getData();
                String memberNum = null;
                if (data instanceof DataBaseInfo) {
                    memberNum = ((DataBaseInfo)data).getNumber();
                } else if (data instanceof BgPeriodCollection) {
                    memberNum = ((BgPeriodCollection)data).get(0).getNumber();
                }
                if (StringUtils.isEmpty((String)memberNum) || !baseMembers.containsKey(dimNum2) || baseMembers.get(dimNum2).contains(memberNum)) continue;
                ((KDBizPromptBox)cp).setDataNoNotify(null);
            }
        }
    }

    public static Set<String> queryBaseCanAdjustNumbers(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String dimNumber) throws EASBizException, BOSException {
        Map<String, Set<String>> baseMembers;
        Set<String> canAdjustNumbers = new HashSet<String>();
        BgAdjustRuleInfo info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType);
        if (info != null && (baseMembers = MBGAdjustBillHelper.queryAdjustRuleBaseMembers(info)) != null && !baseMembers.isEmpty() && baseMembers.get(dimNumber) != null) {
            canAdjustNumbers = baseMembers.get(dimNumber);
        }
        return canAdjustNumbers;
    }

    public static Map<String, Set<String>> queryAdjustRuleBaseMembers(BgAdjustRuleInfo ruleInfo) {
        HashMap<String, Set<String>> baseMembers = new HashMap<String, Set<String>>();
        if (ruleInfo != null) {
            int i;
            List members = null;
            BgDimensionMember member = null;
            if (ruleInfo.getBgScenarios() != null && (members = (List)BgAnalyseHelper.getObject(ruleInfo.getBgScenarios())) != null && !members.isEmpty()) {
                baseMembers.put(DimensionConstants.DEF_SCENARIO_NUMBER, new HashSet());
                for (i = 0; i < members.size(); ++i) {
                    member = (BgDimensionMember)members.get(i);
                    ((Set)baseMembers.get(DimensionConstants.DEF_SCENARIO_NUMBER)).add(member.getNumber());
                }
            }
            if (ruleInfo.getBgElements() != null && (members = (List)BgAnalyseHelper.getObject(ruleInfo.getBgElements())) != null && !members.isEmpty()) {
                baseMembers.put(DimensionConstants.DEF_ELEMENT_NUMBER, new HashSet());
                for (i = 0; i < members.size(); ++i) {
                    member = (BgDimensionMember)members.get(i);
                    ((Set)baseMembers.get(DimensionConstants.DEF_ELEMENT_NUMBER)).add(member.getNumber());
                }
            }
            if (ruleInfo.getCurrencys() != null && (members = (List)BgAnalyseHelper.getObject(ruleInfo.getCurrencys())) != null && !members.isEmpty()) {
                baseMembers.put(DimensionConstants.DEF_CURRENCY_NUMBER, new HashSet());
                for (i = 0; i < members.size(); ++i) {
                    member = (BgDimensionMember)members.get(i);
                    ((Set)baseMembers.get(DimensionConstants.DEF_CURRENCY_NUMBER)).add(member.getNumber());
                }
            }
            if (ruleInfo.getBgVersions() != null && (members = (List)BgAnalyseHelper.getObject(ruleInfo.getBgVersions())) != null && !members.isEmpty()) {
                baseMembers.put(DimensionConstants.DEF_VERSION_NUMBER, new HashSet());
                for (i = 0; i < members.size(); ++i) {
                    member = (BgDimensionMember)members.get(i);
                    ((Set)baseMembers.get(DimensionConstants.DEF_VERSION_NUMBER)).add(member.getNumber());
                }
            }
            if (ruleInfo.getBgPeriods() != null && (members = (List)BgAnalyseHelper.getObject(ruleInfo.getBgPeriods())) != null && !members.isEmpty()) {
                baseMembers.put(DimensionConstants.DEF_PERIOD_NUMBER, new HashSet());
                for (i = 0; i < members.size(); ++i) {
                    member = (BgDimensionMember)members.get(i);
                    ((Set)baseMembers.get(DimensionConstants.DEF_PERIOD_NUMBER)).add(member.getNumber());
                }
            }
        }
        return baseMembers;
    }

    public static void appendBgAdjustRuleFiler(FilterInfo filter, String dimNumber, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType) throws BOSException, EASBizException {
        Map<String, Set<String>> baseMap;
        BgAdjustRuleInfo info;
        if (filter != null && (info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType)) != null && (baseMap = MBGAdjustBillHelper.queryAdjustRuleBaseMembers(info)) != null && baseMap.get(dimNumber) != null) {
            Set<String> numbers = baseMap.get(dimNumber);
            filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        }
    }

    public static boolean checkBgAdjustRuleInOrg(CoreUI coreUI, String currentOrgNumber, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, boolean showInfo) throws BOSException, EASBizException {
        boolean checkBgAdjustRuleInOrg = BgAdjustRuleFactory.getRemoteInstance().checkBgAdjustRuleInOrg(schemeHelper.getBgSchemeId(), bgAdjustBillType, currentOrgNumber);
        if (!checkBgAdjustRuleInOrg && showInfo) {
            MsgBox.showInfo((Component)coreUI, (String)BgCommCHelper.getMessageStr((String)BGADJUSTRULE_RESOURCE, (String)"innerAdjustNotInRule"));
            SysUtil.abort();
        }
        return checkBgAdjustRuleInOrg;
    }

    public static Set<String> queryBgAdjustRuleOrgIDs(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType) throws BOSException, EASBizException {
        return BgAdjustRuleFactory.getRemoteInstance().queryBgAdjustRuleOrgIds(schemeHelper.getBgSchemeId(), bgAdjustBillType);
    }

    public static Set<String> queryAccNumsByAdjRuleOrgNum(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber) throws EASBizException, BOSException {
        return BgAdjustRuleFactory.getRemoteInstance().queryAccNumsByAdjRuleOrgNum(schemeHelper.getBgSchemeId(), bgAdjustBillType, currentOrgNumber);
    }

    public static Map<String, Map<String, Set<String>>> queryOtherDimNumsByAdjRule(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber, Set currentAccountNumbers) throws EASBizException, BOSException {
        return BgAdjustRuleFactory.getRemoteInstance().queryOtherDimNumsByAdjRule(schemeHelper.getBgSchemeId(), bgAdjustBillType, currentOrgNumber, currentAccountNumbers);
    }

    public static Map<String, Set<String>> getAccountfilterValueMap(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber) throws EASBizException, BOSException {
        HashMap<String, Set<String>> filterMap = null;
        Set<String> bgAccountNums = MBGAdjustBillHelper.queryAccNumsByAdjRuleOrgNum(coreUI, schemeHelper, bgAdjustBillType, currentOrgNumber);
        if (bgAccountNums != null && !bgAccountNums.isEmpty()) {
            filterMap = new HashMap<String, Set<String>>();
            filterMap.put(DimensionConstants.DEF_INDEX_SRCNUMBER, bgAccountNums);
        }
        return filterMap;
    }

    public static Map<String, Set<String>> getDimfilterValueMap(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber, String currentAccountNumber) throws EASBizException, BOSException {
        HashSet<String> currentAccountNumbers = new HashSet<String>();
        currentAccountNumbers.add(currentAccountNumber);
        return MBGAdjustBillHelper.getDimfilterValueMap(coreUI, schemeHelper, bgAdjustBillType, currentOrgNumber, currentAccountNumbers);
    }

    public static Map<String, Set<String>> getDimfilterValueMap(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber, Set currentAccountNumbers) throws EASBizException, BOSException {
        HashMap filterMap = null;
        Map<String, Map<String, Set<String>>> dimMembersMap = MBGAdjustBillHelper.queryOtherDimNumsByAdjRule(coreUI, schemeHelper, bgAdjustBillType, currentOrgNumber, currentAccountNumbers);
        if (dimMembersMap != null && !dimMembersMap.isEmpty()) {
            filterMap = new HashMap();
            for (String accountNum : dimMembersMap.keySet()) {
                Map<String, Set<String>> tmpMap = dimMembersMap.get(accountNum);
                List<String> dimNumbers = schemeHelper.getAccAndOtherDim(true);
                String dimNumber = null;
                if (dimNumbers == null || dimNumbers.isEmpty()) continue;
                for (int i = 0; i < dimNumbers.size(); ++i) {
                    dimNumber = dimNumbers.get(i);
                    if (tmpMap.containsKey(dimNumber)) {
                        Set<String> memberNumbers = tmpMap.get(dimNumber);
                        if (!filterMap.containsKey(schemeHelper.getSrcNumber(dimNumber))) {
                            filterMap.put(schemeHelper.getSrcNumber(dimNumber), new HashSet());
                        }
                        ((Set)filterMap.get(schemeHelper.getSrcNumber(dimNumber))).addAll(memberNumbers);
                        continue;
                    }
                    if (filterMap.containsKey(schemeHelper.getSrcNumber(dimNumber))) continue;
                    filterMap.put(schemeHelper.getSrcNumber(dimNumber), new HashSet());
                }
            }
        }
        return filterMap;
    }

    public static boolean checkFormulasMatchAdjustRule(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, String currentOrgNumber, List<ItemFormula> formulaList) throws EASBizException, BOSException {
        BgAdjustRuleInfo info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType);
        if (info != null) {
            Map<String, Set<String>> baseMap = MBGAdjustBillHelper.queryAdjustRuleBaseMembers(info);
            Set<String> adjustRuleAccountNumbers = MBGAdjustBillHelper.queryAccNumsByAdjRuleOrgNum(coreUI, schemeHelper, bgAdjustBillType, currentOrgNumber);
            Map<String, BgDimensionInfo> dimensionsMap = schemeHelper.getDimensionBySrcNumber();
            HashSet<String> currentAccountNumbers = new HashSet<String>();
            HashMap paramsMap = new HashMap();
            String dimItemNumber = null;
            String bgPeriodNumber = null;
            String bgElementNumber = null;
            String bgScenarioNumber = null;
            String currencyNumber = null;
            String dimMemberNumber = null;
            String dimNum = null;
            String srcNum = null;
            String memberNum = null;
            for (ItemFormula formula : formulaList) {
                String[] params = BgNFSHelper.parseFormulaPara(paramsMap, formula.getFormula());
                dimItemNumber = params[0];
                bgPeriodNumber = params[1];
                bgElementNumber = params[2];
                bgScenarioNumber = params[3];
                currencyNumber = params[5];
                if (baseMap != null && !baseMap.isEmpty()) {
                    if (baseMap.containsKey(DimensionConstants.DEF_PERIOD_NUMBER) && !baseMap.get(DimensionConstants.DEF_PERIOD_NUMBER).contains(bgPeriodNumber)) {
                        return false;
                    }
                    if (baseMap.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && !baseMap.get(DimensionConstants.DEF_ELEMENT_NUMBER).contains(bgElementNumber)) {
                        return false;
                    }
                    if (baseMap.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && !baseMap.get(DimensionConstants.DEF_SCENARIO_NUMBER).contains(bgScenarioNumber)) {
                        return false;
                    }
                    if (baseMap.containsKey(DimensionConstants.DEF_CURRENCY_NUMBER) && !baseMap.get(DimensionConstants.DEF_CURRENCY_NUMBER).contains(currencyNumber)) {
                        return false;
                    }
                }
                String[] arr = dimItemNumber.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    dimMemberNumber = arr[i];
                    String[] ss = dimMemberNumber.split(":");
                    srcNum = ss[0];
                    memberNum = ss[1];
                    if (!DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNum)) continue;
                    if (adjustRuleAccountNumbers != null && !adjustRuleAccountNumbers.isEmpty() && !adjustRuleAccountNumbers.contains(memberNum)) {
                        return false;
                    }
                    currentAccountNumbers.add(memberNum);
                }
            }
            if (!currentAccountNumbers.isEmpty()) {
                Map<String, Map<String, Set<String>>> membersMap = MBGAdjustBillHelper.queryOtherDimNumsByAdjRule(coreUI, schemeHelper, bgAdjustBillType, currentOrgNumber, currentAccountNumbers);
                for (ItemFormula formula : formulaList) {
                    String[] params = BgNFSHelper.parseFormulaPara(paramsMap, formula.getFormula());
                    dimItemNumber = params[0];
                    String accountNumber = null;
                    String[] arr = dimItemNumber.split(",");
                    for (int i = 0; i < arr.length; ++i) {
                        dimMemberNumber = arr[i];
                        String[] ss = dimMemberNumber.split(":");
                        srcNum = ss[0];
                        dimNum = dimensionsMap.get(srcNum).getNumber();
                        memberNum = ss[1];
                        if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNum)) {
                            accountNumber = memberNum;
                            if (!membersMap.isEmpty() && !membersMap.containsKey(accountNumber)) {
                                return false;
                            }
                        }
                        if (membersMap.isEmpty() || !membersMap.containsKey(accountNumber) || !membersMap.get(accountNumber).containsKey(dimNum) || membersMap.get(accountNumber).get(dimNum).contains(memberNum)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static void processCanAdjustNoBudget(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, KDTable kdtEntity) throws EASBizException, BOSException {
        Object row = null;
        IColumn column = null;
        ICell cell = null;
        Object cellValue = null;
        String columnKey = null;
        BgAdjustRuleInfo info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType);
        if (info != null && kdtEntity != null && kdtEntity.getRowCount() > 1 && info.isAdjustNoBudget()) {
            for (int colIndex = 0; colIndex < kdtEntity.getColumnCount(); ++colIndex) {
                column = kdtEntity.getColumn(colIndex);
                columnKey = column.getKey();
                for (int rowIndex = 0; rowIndex < kdtEntity.getRowCount(); ++rowIndex) {
                    cell = kdtEntity.getCell(rowIndex, colIndex);
                    if (StringUtils.isEmpty((String)columnKey) || !columnKey.endsWith(MBgAdjustConstants.BEFORE_KEY) || cell.getValue() != null) continue;
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.ADJUST_KEY)).setValue(null);
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.AFTER_KEY)).setValue(null);
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.ADJUST_KEY)).getStyleAttributes().setLocked(true);
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.AFTER_KEY)).getStyleAttributes().setLocked(true);
                }
            }
        }
    }

    public static void processCanAdjustCurrentTime(CoreUI coreUI, BgSchemeDimensionHelper schemeHelper, BgAdjustBillTypeEnum bgAdjustBillType, KDTable kdtEntity, Timestamp currenctAdjustTime, Date currentDate) throws EASBizException, BOSException {
        if (currenctAdjustTime == null || currentDate == null) {
            return;
        }
        IColumn column = null;
        ICell cell = null;
        String columnKey = null;
        String pNumber = null;
        HashSet<String> pNumSet = new HashSet<String>();
        BgAdjustRuleInfo info = MBGAdjustBillHelper.queryBgAdjustRule(schemeHelper, bgAdjustBillType);
        if (info != null && kdtEntity != null && kdtEntity.getRowCount() > 1 && !info.isAdjustHisPeriod()) {
            for (int colIndex = 0; colIndex < kdtEntity.getColumnCount(); ++colIndex) {
                column = kdtEntity.getColumn(colIndex);
                columnKey = column.getKey();
                if (StringUtils.isEmpty((String)columnKey) || !columnKey.endsWith(MBgAdjustConstants.BEFORE_KEY) || pNumberMap.containsKey(pNumber = columnKey.split("_")[0])) continue;
                pNumSet.add(pNumber);
            }
            if (pNumSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(new FilterInfo());
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("number");
                sic.add("endDate");
                view.setSelector(sic);
                view.getFilter().getFilterItems().add(new FilterItemInfo("number", pNumSet, CompareType.INCLUDE));
                BgPeriodCollection colls = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
                for (int i = 0; i < colls.size(); ++i) {
                    pNumberMap.put(colls.get(i).getNumber(), colls.get(i).getEndDate());
                }
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String formatDate = format.format(currenctAdjustTime);
            Date oldDate = new Date();
            try {
                oldDate = format.parse(formatDate);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            boolean isAfter = oldDate.after(currentDate);
            for (int colIndex = 0; colIndex < kdtEntity.getColumnCount(); ++colIndex) {
                column = kdtEntity.getColumn(colIndex);
                columnKey = column.getKey();
                for (int rowIndex = 0; rowIndex < kdtEntity.getRowCount(); ++rowIndex) {
                    cell = kdtEntity.getCell(rowIndex, colIndex);
                    if (StringUtils.isEmpty((String)columnKey) || !columnKey.endsWith(MBgAdjustConstants.BEFORE_KEY)) continue;
                    pNumber = columnKey.split("_")[0];
                    if (pNumberMap.get(pNumber).after(currentDate)) {
                        kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.ADJUST_KEY)).getStyleAttributes().setLocked(false);
                        kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.AFTER_KEY)).getStyleAttributes().setLocked(false);
                        continue;
                    }
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.ADJUST_KEY)).getStyleAttributes().setLocked(true);
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.AFTER_KEY)).getStyleAttributes().setLocked(true);
                    if (isAfter) continue;
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.ADJUST_KEY)).setValue((Object)BigDecimal.ZERO);
                    kdtEntity.getCell(rowIndex, columnKey.replace(MBgAdjustConstants.BEFORE_KEY, MBgAdjustConstants.AFTER_KEY)).setValue(kdtEntity.getCell(rowIndex, columnKey).getValue());
                }
            }
        }
    }
}

