/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgElementDataTypeEnum;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListTitleRenderBase;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MBGViewListFormCommonHelper2 {
    public static final String RES_CLIENT = "com.kingdee.eas.ma.mbg.client.MBGViewListFormResource";

    public static String getString(String key) {
        return EASResource.getString((String)RES_CLIENT, (String)key);
    }

    public static void checkItemDimeinsionEmpty(CoreUIObject ui, MbgViewListDimensionManager bm) {
        if (ui != null && bm != null) {
            for (int i = 0; i < bm.getDimension().size(); ++i) {
                BgDimensionBaseInfo dimen;
                if (!(bm.getDimension().get(i) instanceof BgDimensionBaseInfo) || !"BGITEM".equalsIgnoreCase((dimen = (BgDimensionBaseInfo)bm.getDimension().get(i)).getType()) || !dimen.getMember().isEmpty()) continue;
                String msg = dimen.getAttribute();
                if (dimen.getAttribute().indexOf(",") > 0) {
                    msg = msg.substring(msg.lastIndexOf(",") + 1);
                }
                msg = MessageFormat.format(MBGViewListFormCommonHelper2.getString("noBgItemMember"), msg);
                MsgBox.showInfo((Component)ui, (String)msg);
            }
        }
    }

    public static boolean isCellReadonly(Cell cell, MbgViewListManager viewManager, IObjectValue bgFormInfo) {
        boolean isFormReadOnly = false;
        if (bgFormInfo instanceof BgFormInfo) {
            isFormReadOnly = ((BgFormInfo)bgFormInfo).getBgTemplate().isReadonly();
        }
        return MBGViewListFormCommonHelper2.isCellReadonly(cell, viewManager, isFormReadOnly);
    }

    public static boolean isCellReadonly(Cell cell, MbgViewListManager viewManager, boolean isTemplateReadOnly) {
        if (cell == null) {
            return false;
        }
        return MBGViewListFormCommonHelper2.isCellReadonly(cell.getSheet(), cell.getRow(), cell.getCol(), viewManager, isTemplateReadOnly);
    }

    public static boolean isCellReadonly(Sheet sheet, int row, int col, MbgViewListManager viewManager, boolean isTemplateReadOnly) {
        if (viewManager == null) {
            return false;
        }
        if (isTemplateReadOnly) {
            return true;
        }
        Map<String, MbgViewListCell> cellObjMap = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheet.getSheetIndex())).getDimensionManager().getCellStyles();
        IMbgViewListObject rowObj = ViewListHelper.getDimension(sheet.getRow(row, false));
        IMbgViewListObject colObj = ViewListHelper.getDimension(sheet.getColumn(col, false));
        MbgViewListCell cellObj = null;
        MbgViewListCell varCell = new MbgViewListCell();
        if (rowObj instanceof IMbgViewListObject && colObj instanceof IMbgViewListObject) {
            varCell.setRow(rowObj);
            varCell.setCol(colObj);
            if (cellObjMap.containsKey(varCell.getCellName())) {
                cellObj = cellObjMap.get(varCell.getCellName());
            }
        }
        if (rowObj == null || colObj == null) {
            return false;
        }
        if (rowObj instanceof IMbgViewListStyle) {
            boolean isRowReadOnly = ((IMbgViewListStyle)((Object)rowObj)).isReadonly();
            if (colObj == null) {
                if (cellObj == null) {
                    return isRowReadOnly;
                }
                if (cellObj instanceof MbgViewListCell) {
                    return ((MbgViewListCell)cellObj).isReadonly();
                }
            } else if (colObj instanceof IMbgViewListStyle) {
                boolean isColReadOnly = ((IMbgViewListStyle)((Object)colObj)).isReadonly();
                if (cellObj == null) {
                    return isRowReadOnly || isColReadOnly;
                }
                if (cellObj instanceof MbgViewListCell) {
                    return cellObj.isReadonly();
                }
            }
        }
        return false;
    }

    public static BgNViewDataInfo getData(Map bgDataMap, String orgId, String formula, String versionNumber, boolean isCreate) {
        if (bgDataMap == null) {
            return null;
        }
        HashMap<String, BgNViewDataInfo> subMap = null;
        if (bgDataMap.containsKey(orgId)) {
            subMap = (HashMap<String, BgNViewDataInfo>)bgDataMap.get(orgId);
        }
        if (subMap == null && isCreate) {
            subMap = new HashMap<String, BgNViewDataInfo>();
            bgDataMap.put(orgId, subMap);
        }
        if (subMap == null) {
            return null;
        }
        BgNViewDataInfo data = null;
        String key = DimUtils.getDimDataKey(formula, versionNumber);
        if (subMap.containsKey(key)) {
            data = (BgNViewDataInfo)subMap.get(key);
        }
        if (data == null && isCreate) {
            data = new BgNViewDataInfo();
            data.setFormula(formula);
            data.setBgVersion(versionNumber);
            data.splitFormula();
            subMap.put(key, data);
        }
        return data;
    }

    public static void createNullData(Map bgDataMap, String orgId, String formula, String versionNumber) {
        if (bgDataMap == null || orgId == null || formula == null || versionNumber == null) {
            return;
        }
        Map<String, Object> subMap = null;
        if (bgDataMap.containsKey(orgId)) {
            subMap = (Map)bgDataMap.get(orgId);
        } else {
            subMap = new HashMap();
            bgDataMap.put(orgId, subMap);
        }
        subMap.put(DimUtils.getDimDataKey(formula, versionNumber), null);
    }

    public static void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue, DimensionCacheHelper cachehelper, int dataType) {
        if (dataValue == null) {
            BgNFSHelper.setValue(cell, null);
            return;
        }
        String[] params = BgNFSHelper.parseFormulaPara(dataValue.getFormula());
        try {
            if (cachehelper.getBudgetScens().contains(params[3])) {
                MBGViewListFormCommonHelper2.setBudgetValue(cell, dataValue);
            } else if (cachehelper.getActualScens().contains(params[3])) {
                if (16 == dataType) {
                    MBGViewListFormCommonHelper2.setAddActualValue(cell, dataValue);
                } else {
                    MBGViewListFormCommonHelper2.setActualValue(cell, dataValue);
                }
            }
        }
        catch (Exception ex) {
            BgNFSHelper.setValue(cell, null);
        }
    }

    private static void setAddActualValue(Cell cell, BgNViewDataInfo dataValue) {
        BgNFSHelper.setValue(cell, dataValue == null ? null : dataValue.getAddActualNoDef());
    }

    public static void setBudgetValue(Cell cell, BgNViewDataInfo dataValue) {
        BgNFSHelper.setValue(cell, dataValue == null ? null : dataValue.getBudgetValueNoDef());
    }

    public static void setActualValue(Cell cell, BgNViewDataInfo dataValue) {
        BgNFSHelper.setValue(cell, dataValue == null ? null : dataValue.getBizActualNoDef());
    }

    public static boolean isOrgOnRow(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return false;
        }
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> rowDimensions = ((MbgViewListRowCol)rows.get(i)).getDimensions();
            for (int j = 0; j < rowDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(rowDimensions.get(j).getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getOrgNumsifOrgonRowCol(MbgViewListSheetManager sheetManager) {
        int i;
        HashSet<String> orgNums = new HashSet<String>();
        if (sheetManager == null) {
            return orgNums;
        }
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        List<IMbgViewListObject> rowCols = sheetManager.getDimensionManager().getRowCols();
        for (i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            dimensions.addAll(((MbgViewListRowCol)rowCols.get(i)).getDimensions());
        }
        for (i = 0; i < dimensions.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)dimensions.get(i)).getNumber())) continue;
            for (int j = 0; j < ((BgDimensionBaseInfo)dimensions.get(i)).getMember().size(); ++j) {
                orgNums.add(((BgDimensionMember)((BgDimensionBaseInfo)dimensions.get(i)).getMember().get(j)).getNumber());
            }
        }
        return orgNums;
    }

    public static Map<String, List<IMbgViewListObject>> getViewListObjectsByOrg(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow) {
        IMbgViewListObject rowObject;
        int i;
        HashMap<String, List<IMbgViewListObject>> returnMap = new HashMap<String, List<IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        ArrayList<IMbgViewListObject> tempList = new ArrayList<IMbgViewListObject>();
        ArrayList<IMbgViewListObject> objectist = null;
        List<IMbgViewListObject> rowCols = null;
        String orgMemberNum = null;
        int maxIndex = -1;
        rowCols = isOrgOnRow != false ? dimensionManager.getRows() : dimensionManager.getColumns();
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) < maxIndex) continue;
            maxIndex = MBGViewListFormCommonHelper2.getIndex(rowObject);
        }
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) > maxIndex) continue;
            tempList.add(rowObject);
            if (rowObject instanceof MbgViewListRowCol) {
                MbgViewListRowCol row = (MbgViewListRowCol)rowObject;
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                    ArrayList<String> orgNumbers = new ArrayList<String>();
                    for (int x = 0; x < dimInfo.getMember().size(); ++x) {
                        if (orgNumbers.contains(((BgDimensionMember)dimInfo.getMember().get(x)).getNumber())) continue;
                        orgNumbers.add(((BgDimensionMember)dimInfo.getMember().get(x)).getNumber());
                    }
                    if (orgNumbers.size() == 1) {
                        orgMemberNum = (String)orgNumbers.get(0);
                        break;
                    }
                    return returnMap;
                }
            }
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) != maxIndex || orgMemberNum == null) continue;
            objectist = new ArrayList<IMbgViewListObject>();
            objectist.addAll(tempList);
            returnMap.put(orgMemberNum, objectist);
            tempList.clear();
            orgMemberNum = null;
        }
        return returnMap;
    }

    public static Map<String, List<IMbgViewListObject>> getViewListObjectsByOrg2(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow) {
        IMbgViewListObject rowObject;
        int i;
        HashMap<String, List<IMbgViewListObject>> returnMap = new HashMap<String, List<IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        ArrayList<IMbgViewListObject> tempList = new ArrayList<IMbgViewListObject>();
        ArrayList<IMbgViewListObject> objectist = null;
        List<IMbgViewListObject> rowCols = null;
        String orgMemberNum = null;
        int maxIndex = -1;
        rowCols = isOrgOnRow != false ? dimensionManager.getRows() : dimensionManager.getColumns();
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) < maxIndex) continue;
            maxIndex = MBGViewListFormCommonHelper2.getIndex(rowObject);
        }
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) > maxIndex) continue;
            tempList.add(rowObject);
            if (rowObject instanceof MbgViewListRowCol) {
                MbgViewListRowCol row = (MbgViewListRowCol)rowObject;
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                    ArrayList<String> orgNumbers = new ArrayList<String>();
                    for (int x = 0; x < dimInfo.getMember().size(); ++x) {
                        if (orgNumbers.contains(((BgDimensionMember)dimInfo.getMember().get(x)).getNumber())) continue;
                        orgNumbers.add(((BgDimensionMember)dimInfo.getMember().get(x)).getNumber());
                    }
                    if (orgNumbers.size() == 1) {
                        orgMemberNum = (String)orgNumbers.get(0);
                        break;
                    }
                    return null;
                }
            }
            if (MBGViewListFormCommonHelper2.getIndex(rowObject) > maxIndex || orgMemberNum == null) continue;
            objectist = new ArrayList<IMbgViewListObject>();
            objectist.addAll(tempList);
            returnMap.put(orgMemberNum, objectist);
            tempList.clear();
            orgMemberNum = null;
        }
        return returnMap;
    }

    public static Map<String, List<IMbgViewListObject>> getViewListObjectsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        HashMap<String, List<IMbgViewListObject>> returnMap = new HashMap<String, List<IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        Map<String, Map<Integer, IMbgViewListObject>> indexObjMap = MBGViewListFormCommonHelper2.getViewListIndexObjectsByTemp(dimensionManager, isOrgOnRow, currentOrgNum);
        for (String orgNum : indexObjMap.keySet()) {
            Map<Integer, IMbgViewListObject> tmpMap = indexObjMap.get(orgNum);
            returnMap.put(orgNum, new ArrayList());
            Iterator<IMbgViewListObject> it = tmpMap.values().iterator();
            while (it.hasNext()) {
                ((List)returnMap.get(orgNum)).add(it.next());
            }
        }
        return returnMap;
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjectsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        LinkedHashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new LinkedHashMap<String, Map<Integer, IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        List<IMbgViewListObject> viewlistOrgCols = isOrgOnRow != false ? dimensionManager.getRows() : dimensionManager.getColumns();
        return MBGViewListFormCommonHelper2.getViewListIndexObjectsByTemp(viewlistOrgCols, currentOrgNum);
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjectsByTemp(List<IMbgViewListObject> viewlistOrgCols, String currentOrgNum) {
        LinkedHashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new LinkedHashMap<String, Map<Integer, IMbgViewListObject>>();
        if (viewlistOrgCols == null) {
            return returnMap;
        }
        Integer objectIndex = -1;
        int size = viewlistOrgCols.size();
        for (int index = 0; index < size; ++index) {
            IMbgViewListObject viewlistObj = viewlistOrgCols.get(index);
            objectIndex = MBGViewListFormCommonHelper2.getIndex(viewlistObj);
            String orgMemberNum = null;
            if (viewlistObj instanceof MbgViewListRowCol) {
                MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                    if (dimInfo.getMember().size() == 1) {
                        orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                        break;
                    }
                    return returnMap;
                }
            } else if (orgMemberNum == null && currentOrgNum != null) {
                if (!returnMap.containsKey(currentOrgNum)) {
                    returnMap.put(currentOrgNum, new LinkedHashMap());
                }
                ((Map)returnMap.get(currentOrgNum)).put(objectIndex, viewlistObj);
            }
            if (orgMemberNum == null) continue;
            if (!returnMap.containsKey(orgMemberNum)) {
                returnMap.put(orgMemberNum, new LinkedHashMap());
            }
            ((Map)returnMap.get(orgMemberNum)).put(objectIndex, viewlistObj);
        }
        return returnMap;
    }

    public static Integer getIndex(IMbgViewListObject viewlistObj) {
        if (viewlistObj instanceof AbstractMbgViewListObject) {
            return ((AbstractMbgViewListObject)viewlistObj).getInitIndex();
        }
        return viewlistObj.getIndex();
    }

    public static Map<String, Map<String, MbgViewListCell>> getViewListCellsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        LinkedHashMap<String, Map<String, MbgViewListCell>> returnMap = new LinkedHashMap<String, Map<String, MbgViewListCell>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        Integer objectIndex = -1;
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        List<IMbgViewListObject> cols = dimensionManager.getColumns();
        if (isOrgOnRow.booleanValue()) {
            int size = rows.size();
            for (int index = 0; index < size; ++index) {
                MbgViewListCell cell;
                int xIndex;
                IMbgViewListObject viewlistObj = rows.get(index);
                objectIndex = MBGViewListFormCommonHelper2.getIndex(viewlistObj);
                String orgMemberNum = null;
                if (viewlistObj instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                    List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                    for (int j = 0; j < dimensions.size(); ++j) {
                        MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                        if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                        if (dimInfo.getMember().size() == 1) {
                            orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                            break;
                        }
                        return returnMap;
                    }
                } else if (orgMemberNum == null && currentOrgNum != null) {
                    if (!returnMap.containsKey(currentOrgNum)) {
                        returnMap.put(currentOrgNum, new HashMap());
                    }
                    for (xIndex = 0; xIndex < cols.size(); ++xIndex) {
                        cell = new MbgViewListCell();
                        cell.setRow(viewlistObj);
                        cell.setCol(cols.get(xIndex));
                        ((Map)returnMap.get(currentOrgNum)).put(MBGViewListFormCommonHelper2.getIndex(viewlistObj) + ":" + MBGViewListFormCommonHelper2.getIndex(cols.get(xIndex)), cell);
                    }
                }
                if (orgMemberNum == null) continue;
                if (!returnMap.containsKey(orgMemberNum)) {
                    returnMap.put(orgMemberNum, new HashMap());
                }
                for (xIndex = 0; xIndex < cols.size(); ++xIndex) {
                    cell = new MbgViewListCell();
                    cell.setRow(viewlistObj);
                    cell.setCol(cols.get(xIndex));
                    ((Map)returnMap.get(orgMemberNum)).put(MBGViewListFormCommonHelper2.getIndex(viewlistObj) + ":" + MBGViewListFormCommonHelper2.getIndex(cols.get(xIndex)), cell);
                }
            }
        } else {
            int size = cols.size();
            for (int index = 0; index < size; ++index) {
                MbgViewListCell cell;
                int xIndex;
                IMbgViewListObject viewlistObj = cols.get(index);
                objectIndex = MBGViewListFormCommonHelper2.getIndex(viewlistObj);
                String orgMemberNum = null;
                if (viewlistObj instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                    List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                    for (int j = 0; j < dimensions.size(); ++j) {
                        MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                        if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                        if (dimInfo.getMember().size() == 1) {
                            orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                            break;
                        }
                        return returnMap;
                    }
                } else if (orgMemberNum == null && currentOrgNum != null) {
                    if (!returnMap.containsKey(currentOrgNum)) {
                        returnMap.put(currentOrgNum, new HashMap());
                    }
                    for (xIndex = 0; xIndex < rows.size(); ++xIndex) {
                        cell = new MbgViewListCell();
                        cell.setRow(rows.get(xIndex));
                        cell.setCol(viewlistObj);
                        ((Map)returnMap.get(currentOrgNum)).put(MBGViewListFormCommonHelper2.getIndex(rows.get(xIndex)) + ":" + MBGViewListFormCommonHelper2.getIndex(viewlistObj), cell);
                    }
                }
                if (orgMemberNum == null) continue;
                if (!returnMap.containsKey(orgMemberNum)) {
                    returnMap.put(orgMemberNum, new HashMap());
                }
                for (xIndex = 0; xIndex < rows.size(); ++xIndex) {
                    cell = new MbgViewListCell();
                    cell.setRow(rows.get(xIndex));
                    cell.setCol(viewlistObj);
                    ((Map)returnMap.get(orgMemberNum)).put(MBGViewListFormCommonHelper2.getIndex(rows.get(xIndex)) + ":" + MBGViewListFormCommonHelper2.getIndex(viewlistObj), cell);
                }
            }
        }
        return returnMap;
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjects(Map<String, MbgViewListManager> viewlistManagerMap, int sheetIndex, Boolean isOrgOnRow) {
        HashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new HashMap<String, Map<Integer, IMbgViewListObject>>();
        if (viewlistManagerMap == null || viewlistManagerMap.isEmpty()) {
            return returnMap;
        }
        Integer objectIndex = -1;
        for (String orgNum : viewlistManagerMap.keySet()) {
            MbgViewListManager viewlistManager = viewlistManagerMap.get(orgNum);
            returnMap.put(orgNum, new LinkedHashMap());
            List<IMbgViewListObject> tmpLst = isOrgOnRow != false ? ((MbgViewListSheetManager)viewlistManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getRows() : ((MbgViewListSheetManager)viewlistManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getColumns();
            int size = tmpLst.size();
            for (int index = 0; index < size; ++index) {
                IMbgViewListObject viewlistObj = tmpLst.get(index);
                objectIndex = MBGViewListFormCommonHelper2.getIndex(viewlistObj);
                if (((Map)returnMap.get(orgNum)).containsKey(objectIndex)) continue;
                ((Map)returnMap.get(orgNum)).put(objectIndex, viewlistObj);
            }
        }
        return returnMap;
    }

    public static void processViewlistHeader(Book book) {
        MBGViewListFormCommonHelper2.processViewlistHeader(book, false);
    }

    public static void processViewlistHeader(Book book, boolean isClear) {
        int _sheetIndex = 0;
        int _sheetSize = book.getSheetCount();
        Cell _cell = null;
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        boolean hasRowObject = false;
        for (_sheetIndex = _sheetSize - 1; _sheetIndex >= 0; --_sheetIndex) {
            hasRowObject = false;
            Sheet _sheet = book.getSheet(_sheetIndex);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (hasRowObject) continue;
                    if (ViewListHelper.getDimension(_sheet.getRow(_rowIndex, false)) != null) {
                        hasRowObject = true;
                        continue;
                    }
                    _cell = _sheet.getCell(_rowIndex, 0, false);
                    String title = ViewListTitleRenderBase.getTitle(_cell);
                    if (StringUtils.isEmpty((String)title)) continue;
                    if (isClear) {
                        _sheet.getCell(_rowIndex, 0, true).setValue(Variant.nullVariant);
                        continue;
                    }
                    _sheet.getCell(_rowIndex, 0, true).setValue(new Variant((Object)title));
                }
            }
        }
    }

    public static boolean checkRateElement(Cell cell, Map<String, BgElementInfo> elementObjMap) {
        boolean isRateElement = false;
        if (cell == null || elementObjMap == null || elementObjMap.isEmpty()) {
            return isRateElement;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            String[] _parameter = BgNFSHelper.parseFormulaPara(_formulaStr);
            String elementNumber = null;
            if (_parameter.length == 6) {
                if (!StringUtils.isEmpty((String)_parameter[2])) {
                    elementNumber = _parameter[2];
                }
            } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
            if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.RATE)) {
                isRateElement = true;
            }
        }
        return isRateElement;
    }

    public static boolean checkRateElement(String formula, Map<String, BgElementInfo> elementObjMap) {
        boolean isRateElement = false;
        if (StringUtils.isEmpty((String)formula) || elementObjMap == null || elementObjMap.isEmpty()) {
            return isRateElement;
        }
        String[] _parameter = BgNFSHelper.parseFormulaPara(formula);
        String elementNumber = null;
        if (_parameter.length == 6) {
            if (!StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
        } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
            elementNumber = _parameter[2];
        }
        if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.RATE)) {
            isRateElement = true;
        }
        return isRateElement;
    }

    public static boolean checkPriceElement(Cell cell, Map<String, BgElementInfo> elementObjMap) {
        boolean isPriceElement = false;
        if (cell == null || elementObjMap == null || elementObjMap.isEmpty()) {
            return isPriceElement;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            String[] _parameter = BgNFSHelper.parseFormulaPara(_formulaStr);
            String elementNumber = null;
            if (_parameter.length == 6) {
                if (!StringUtils.isEmpty((String)_parameter[2])) {
                    elementNumber = _parameter[2];
                }
            } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
            if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.PRICE)) {
                isPriceElement = true;
            }
        }
        return isPriceElement;
    }

    public static boolean checkPriceElement(String formula, Map<String, BgElementInfo> elementObjMap) {
        boolean isPriceElement = false;
        if (StringUtils.isEmpty((String)formula) || elementObjMap == null || elementObjMap.isEmpty()) {
            return isPriceElement;
        }
        String[] _parameter = BgNFSHelper.parseFormulaPara(formula);
        String elementNumber = null;
        if (_parameter.length == 6) {
            if (!StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
        } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
            elementNumber = _parameter[2];
        }
        if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.PRICE)) {
            isPriceElement = true;
        }
        return isPriceElement;
    }

    public static boolean checkAmountElement(Cell cell, Map<String, BgElementInfo> elementObjMap) {
        boolean isAmountElement = false;
        if (cell == null || elementObjMap == null || elementObjMap.isEmpty()) {
            return isAmountElement;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            String[] _parameter = BgNFSHelper.parseFormulaPara(_formulaStr);
            String elementNumber = null;
            if (_parameter.length == 6) {
                if (!StringUtils.isEmpty((String)_parameter[2])) {
                    elementNumber = _parameter[2];
                }
            } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
            if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.AMOUNT)) {
                isAmountElement = true;
            }
        }
        return isAmountElement;
    }

    public static boolean checkAmountElement(String formula, Map<String, BgElementInfo> elementObjMap) {
        boolean isAmountElement = false;
        if (StringUtils.isEmpty((String)formula) || elementObjMap == null || elementObjMap.isEmpty()) {
            return isAmountElement;
        }
        String[] _parameter = BgNFSHelper.parseFormulaPara(formula);
        String elementNumber = null;
        if (_parameter.length == 6) {
            if (!StringUtils.isEmpty((String)_parameter[2])) {
                elementNumber = _parameter[2];
            }
        } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[2])) {
            elementNumber = _parameter[2];
        }
        if (elementNumber != null && elementObjMap.containsKey(elementNumber) && elementObjMap.get(elementNumber).getDataType().equals((Object)BgElementDataTypeEnum.AMOUNT)) {
            isAmountElement = true;
        }
        return isAmountElement;
    }

    public static boolean checkElementRateOrPrice(Cell cell, Map<String, BgElementInfo> elementObjMap) {
        return MBGViewListFormCommonHelper2.checkPriceElement(cell, elementObjMap) || MBGViewListFormCommonHelper2.checkRateElement(cell, elementObjMap) || MBGViewListFormCommonHelper2.checkAmountElement(cell, elementObjMap);
    }

    public static boolean checkElementRateOrPrice(String formula, Map<String, BgElementInfo> elementObjMap) {
        return MBGViewListFormCommonHelper2.checkPriceElement(formula, elementObjMap) || MBGViewListFormCommonHelper2.checkRateElement(formula, elementObjMap) || MBGViewListFormCommonHelper2.checkAmountElement(formula, elementObjMap);
    }

    public static boolean checkCanSave(Cell cell, IProvider provider, BgScenarioType editScenType) throws EASBizException, BOSException {
        String cellOrgId = null;
        String cellOrgNum = null;
        String version = null;
        ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
        if (itemFormula == null) {
            return false;
        }
        cellOrgId = itemFormula.getExt("ORGUNITID");
        cellOrgNum = itemFormula.getExt("ORGUNIT");
        IMbgViewBase view = (IMbgViewBase)((AbstractProvider)provider).getBgViewManagerForMulOrg().get(cellOrgNum);
        version = itemFormula.getExt("Version");
        DimensionMemberCheckHelper helper = provider.getCheckFactory().getHelper(cellOrgId, view);
        String editScen = helper.getEditScen(view, cell.getSheet().getSheetIndex(), editScenType);
        return helper.canSave(itemFormula.getFormula(), editScen, version);
    }

    public static void checkFormulaValue(BigDecimal value, int rowIndex, int colIndex) throws Exception {
        if (value == null) {
            return;
        }
        int compareValue = value.compareTo(BgNConstants.ZERO);
        if (compareValue > 0) {
            if (BgNFSHelper.checkHasOverstepMax(value)) {
                throw new BgFormException(BgFormException.VALUEHASOVERSTEPMAX, new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
            }
        } else if (compareValue < 0 && BgNFSHelper.checkHasOverstepMin(value)) {
            throw new BgFormException(BgFormException.VALUEHASOVERSTEPMIN, new String[]{TableToolkit.xy2range((int)colIndex, (int)rowIndex)});
        }
    }

    public static int transMeasureUnit(int index) {
        if (index == 0) {
            return 1;
        }
        if (index == 1) {
            return 1000;
        }
        if (index == 2) {
            return 10000;
        }
        if (index == 3) {
            return 100000;
        }
        if (index == 4) {
            return 1000000;
        }
        if (index == 5) {
            return 10000000;
        }
        if (index == 6) {
            return 100000000;
        }
        return 1;
    }

    public static void movePgaeOrgToView(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return;
        }
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            List pageDimensions = dimensionManager.getPageDimension();
            List viewDimensions = dimensionManager.getViewDimension();
            boolean isOrgOnPage = false;
            MbgViewListDimensionInfo orgDim = null;
            if (pageDimensions != null && !pageDimensions.isEmpty()) {
                for (int i = pageDimensions.size() - 1; i >= 0; --i) {
                    if (!(pageDimensions.get(i) instanceof MbgViewListDimensionInfo) || !((MbgViewListDimensionInfo)pageDimensions.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                    orgDim = (MbgViewListDimensionInfo)pageDimensions.get(i);
                    isOrgOnPage = true;
                    pageDimensions.remove(orgDim);
                    break;
                }
            }
            if (!isOrgOnPage || orgDim == null) continue;
            viewDimensions.add(orgDim);
        }
    }

    public static void moveHideDimToView(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return;
        }
        ArrayList<MbgViewListDimensionInfo> hideDims = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            List pageDimensions = dimensionManager.getPageDimension();
            List viewDimensions = dimensionManager.getViewDimension();
            hideDims = new ArrayList<MbgViewListDimensionInfo>();
            if (pageDimensions != null && !pageDimensions.isEmpty()) {
                for (int i = pageDimensions.size() - 1; i >= 0; --i) {
                    if (!(pageDimensions.get(i) instanceof MbgViewListDimensionInfo) || ((MbgViewListDimensionInfo)pageDimensions.get(i)).isShow()) continue;
                    hideDims.add((MbgViewListDimensionInfo)pageDimensions.get(i));
                    pageDimensions.remove((MbgViewListDimensionInfo)pageDimensions.get(i));
                }
            }
            if (hideDims.isEmpty()) continue;
            viewDimensions.addAll(hideDims);
        }
    }

    public static void movePageDimensionsToRow(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return;
        }
        List sheetManagers = viewManager.getSheetManagers();
        for (int s = 0; s < sheetManagers.size(); ++s) {
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)sheetManagers.get(s);
            MBGViewListFormCommonHelper2.movePageDimensionsToRow(sheetManager);
        }
    }

    public static void movePageDimensionsToRow(MbgViewListSheetManager sheetManager) {
        if (sheetManager == null) {
            return;
        }
        MbgViewListDimensionInfo dim = null;
        List<IMbgViewListObject> rows = sheetManager.getDimensionManager().getRows();
        List pageDimensions = sheetManager.getDimensionManager().getPageDimension();
        List rowDimensions = sheetManager.getDimensionManager().getRowDimension();
        HashMap nodimensionMap = new HashMap();
        for (int i = 0; i < rowDimensions.size(); ++i) {
            if (rowDimensions.get(i) instanceof MbgViewListDimensionInfo) {
                dim = (MbgViewListDimensionInfo)rowDimensions.get(i);
                continue;
            }
            String dimNumber = "000000000000000000000000000=";
            if (dim != null) {
                dimNumber = dim.getNumber();
            }
            if (!nodimensionMap.containsKey(dimNumber)) {
                nodimensionMap.put(dimNumber, new ArrayList());
            }
            ((List)nodimensionMap.get(dimNumber)).add(rowDimensions.get(i));
        }
        if (!pageDimensions.isEmpty()) {
            ArrayList<MbgViewListDimensionInfo> newDims = null;
            MbgViewListDimensionInfo cloneDim = null;
            for (int i = 0; i < rows.size(); ++i) {
                if (rows.get(i) instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(i);
                    newDims = new ArrayList<MbgViewListDimensionInfo>();
                    for (int j = 0; j < pageDimensions.size(); ++j) {
                        dim = (MbgViewListDimensionInfo)pageDimensions.get(j);
                        if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                        cloneDim = dim.clone();
                        cloneDim.getMember().clear();
                        cloneDim.getMember().addAll(dim.getMember());
                        newDims.add(cloneDim);
                    }
                    newDims.addAll(rowObj.getDimensions());
                    rowObj.getDimensions().clear();
                    rowObj.getDimensions().addAll(newDims);
                }
                if (newDims == null) continue;
                rowDimensions.clear();
                if (nodimensionMap.containsKey("000000000000000000000000000=")) {
                    rowDimensions.addAll((Collection)nodimensionMap.get("000000000000000000000000000="));
                }
                for (int d = 0; d < newDims.size(); ++d) {
                    dim = (MbgViewListDimensionInfo)newDims.get(d);
                    rowDimensions.add(dim);
                    if (!nodimensionMap.containsKey(dim.getNumber())) continue;
                    rowDimensions.addAll((Collection)nodimensionMap.get(dim.getNumber()));
                }
            }
            for (int k = pageDimensions.size() - 1; k >= 0; --k) {
                dim = (MbgViewListDimensionInfo)pageDimensions.get(k);
                if (dim == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                pageDimensions.remove(dim);
            }
        }
    }

    public static void filterCurPageView(IMbgViewBase view, String billId, Map<String, String> pageViewNumbers) {
        if (view == null || billId == null || pageViewNumbers == null || pageViewNumbers.isEmpty()) {
            return;
        }
        ArrayList pageViewDims = new ArrayList();
        String currNumber = null;
        BgDimensionBaseInfo dimension = null;
        for (IMbgSheetBase iMbgSheetBase : view.getSheetManagers()) {
            pageViewDims.clear();
            pageViewDims.addAll(iMbgSheetBase.getDimensionManager().getPageDisplayDimension());
            pageViewDims.addAll(iMbgSheetBase.getDimensionManager().getViewDisplayDimension());
            for (int d = 0; d < pageViewDims.size(); ++d) {
                if (!(pageViewDims.get(d) instanceof BgDimensionBaseInfo)) continue;
                dimension = (BgDimensionBaseInfo)pageViewDims.get(d);
                currNumber = pageViewNumbers.get(BgNFSHelper.getNumberKey(billId, iMbgSheetBase.getSheetIndex(), dimension.getNumber()));
                if (currNumber == null || dimension.getMember().size() <= 1) continue;
                Iterator it = dimension.getMember().iterator();
                while (it.hasNext()) {
                    if (currNumber.equals(BgViewHelper.getNumber(it.next()))) continue;
                    it.remove();
                }
            }
        }
    }

    protected static void addSubMembers(Map<String, Set<String>> subMembers, String sourceNumber, String subMemberNumber) {
        if (!subMembers.containsKey(sourceNumber)) {
            subMembers.put(sourceNumber, new HashSet());
        }
        subMembers.get(sourceNumber).add(subMemberNumber);
    }

    public static void checkOrgForRowCol(Set<Map<MbgViewListRowCol, Map<Integer, Row>>> set, ViewListProvider provider, Sheet sheet, String message) {
        if (provider == null || sheet == null || provider.getOrgUnitInfo() == null || !(provider instanceof MBGViewListFormBaseProvider) || set == null || set.isEmpty()) {
            return;
        }
        int sheetIndex = sheet.getIndex();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)((MbgViewListManager)provider.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        if (isorgOnPageOrView) {
            return;
        }
        String curOrgId = provider.getOrgUnitId();
        List members = null;
        String orgId = null;
        Set<MbgViewListRowCol> rowColSet = null;
        List<MbgViewListDimensionInfo> dimensions = null;
        for (Map<MbgViewListRowCol, Map<Integer, Row>> map : set) {
            if (map == null || map.isEmpty()) continue;
            rowColSet = map.keySet();
            if (rowColSet == null || rowColSet.isEmpty()) break;
            for (MbgViewListRowCol rowColItem : rowColSet) {
                dimensions = rowColItem.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimensions.get(j).getNumber()) || (members = dimensions.get(j).getMember()) == null || members.isEmpty()) continue;
                    for (int k = 0; k < members.size(); ++k) {
                        if (members.get(k) == null || !(members.get(k) instanceof MbgViewListDimensionMember) || StringUtils.isEmpty((String)(orgId = ((MbgViewListDimensionMember)members.get(k)).getAttribute())) || orgId.equals(curOrgId)) continue;
                        MsgBox.showInfo((String)EASResource.getString((String)RES_CLIENT, (String)"pleaseChooseFormOrg"));
                        SysUtil.abort();
                    }
                }
            }
        }
    }

    public static BgDimensionMember getOrgMember(MbgViewListSheetManager sheetManager, Row row, Column col) {
        BgDimensionMember orgMember;
        block24: {
            if (sheetManager == null || row == null || col == null) {
                return null;
            }
            Sheet sheet = row.getSheet();
            orgMember = null;
            BgDimensionMember[] rowMembers = ViewListHelper.getDimensionMember(row);
            IMbgViewListObject rowObject = ViewListHelper.getDimension(row);
            BgDimensionMember[] colMembers = ViewListHelper.getDimensionMember(col);
            IMbgViewListObject colObject = ViewListHelper.getDimension(col);
            List<IMbgViewListObject> viewlistObjects = null;
            int currentIndex = 0;
            int sheetRowColIndex = 0;
            if (rowMembers == null || rowMembers.length <= 0) {
                viewlistObjects = sheetManager.getDimensionManager().getRows();
                currentIndex = rowObject.getIndex();
                sheetRowColIndex = row.getRow();
                SortedRowArray rows = sheet.getRows();
                if (viewlistObjects != null) {
                    IMbgViewListObject object;
                    int i;
                    Row _row = null;
                    if (sheetManager.isRowColShowbyTemp()) {
                        for (i = 0; i < rows.size() - 1; ++i) {
                            _row = rows.getAt(i);
                            if (_row == null || (object = ViewListHelper.getDimension(_row)) == null) continue;
                            if (object.getIndex() > currentIndex) break;
                            if (object instanceof MbgViewListRowCol) {
                                orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                            }
                            if (orgMember == null) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (i = sheetRowColIndex - 1; i >= 0 && (object = ViewListHelper.getDimension(_row = sheet.getRow(i, false))) != null && MBGViewListFormCommonHelper2.getIndex(object) <= currentIndex; --i) {
                            if (object instanceof MbgViewListRowCol) {
                                orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                            }
                            if (orgMember != null) break;
                        }
                        if (orgMember == null) {
                            for (i = sheetRowColIndex + 1; i <= sheet.getMaxRowIndex() && (object = ViewListHelper.getDimension(_row = sheet.getRow(i, false))) != null && object.getIndex() >= currentIndex; ++i) {
                                if (!(object instanceof MbgViewListRowCol)) continue;
                                orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                            }
                        }
                    }
                }
            }
            if (orgMember != null) {
                return orgMember;
            }
            if (colMembers != null && colMembers.length > 0) break block24;
            viewlistObjects = sheetManager.getDimensionManager().getColumns();
            currentIndex = colObject.getIndex();
            sheetRowColIndex = col.getCol();
            if (viewlistObjects != null) {
                IMbgViewListObject object;
                Column _col = null;
                if (sheetManager.isRowColShowbyTemp()) {
                    for (int i = 0; i <= sheetRowColIndex - 1 && (object = ViewListHelper.getDimension(_col = sheet.getColumn(i, false))) != null && object.getIndex() <= currentIndex; ++i) {
                        if (object instanceof MbgViewListRowCol) {
                            orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                        }
                        if (orgMember == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    int i;
                    for (i = sheetRowColIndex - 1; i >= 0 && (object = ViewListHelper.getDimension(_col = sheet.getColumn(i, false))) != null && MBGViewListFormCommonHelper2.getIndex(object) <= currentIndex; --i) {
                        if (object instanceof MbgViewListRowCol) {
                            orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                        }
                        if (orgMember != null) break;
                    }
                    if (orgMember == null) {
                        for (i = sheetRowColIndex + 1; i <= sheet.getMaxRowIndex() && (object = ViewListHelper.getDimension(_col = sheet.getColumn(i, false))) != null && MBGViewListFormCommonHelper2.getIndex(object) >= currentIndex; ++i) {
                            if (!(object instanceof MbgViewListRowCol)) continue;
                            orgMember = MBGViewListFormCommonHelper2.getOrgMember((MbgViewListRowCol)object);
                        }
                    }
                }
            }
        }
        return orgMember;
    }

    public static BgDimensionMember getOrgMember(MbgViewListRowCol object) {
        if (object != null && object instanceof MbgViewListRowCol) {
            List<MbgViewListDimensionInfo> dims = object.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dims.get(j).getNumber()) || dims.get(j).getMember().size() != 1) continue;
                return (BgDimensionMember)dims.get(j).getMember().get(0);
            }
        }
        return null;
    }

    public static void setRowColUnHide(Book book) {
        if (book == null) {
            return;
        }
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            for (int r = 0; r < sheet.getMaxRowIndex(); ++r) {
                BgNFSHelper.setHided(sheet.getRow(r, false), false);
            }
            for (int c = 0; c < sheet.getMaxColIndex(); ++c) {
                BgNFSHelper.setHided(sheet.getColumn(c, false), false);
            }
        }
    }

    public static void processRowColHide(Book book, MbgViewListManager viewManager) {
        if (book == null) {
            return;
        }
        MbgViewListSheetManager sheetManager = null;
        Sheet sheet = null;
        Row row = null;
        Column column = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            sheetManager = (MbgViewListSheetManager)viewManager.getSheetManagers().get(i);
            int pageDimCount = MBGViewListFormCommonHelper2.getPageDimCount(sheetManager, false);
            for (int r = sheet.getMaxRowIndex() - 1; r >= 0; --r) {
                row = sheet.getRow(r, false);
                if (row == null || !BgNFSHelper.isHided(row)) continue;
                BgNFSHelper.setHided(row, false);
            }
            for (int c = sheet.getMaxColIndex() - 1; c >= 0; --c) {
                column = sheet.getColumn(c, false);
                if (!BgNFSHelper.isHided(column)) continue;
                BgNFSHelper.setHided(column, false);
                if (sheet.getColumn(c + pageDimCount, false) == null) continue;
                BgNFSHelper.setHided(sheet.getColumn(c + pageDimCount, false), true);
            }
        }
    }

    public static int getPageDimCount(MbgViewListSheetManager sheetManager, boolean isNeedOrg) {
        int count = 0;
        if (sheetManager == null || sheetManager.getDimensionManager() == null || sheetManager.getDimensionManager().getPageDimension().isEmpty()) {
            return count;
        }
        List pageDims = sheetManager.getDimensionManager().getPageDimension();
        boolean hasOrgDim = false;
        if (isNeedOrg) {
            count = pageDims.size();
        } else {
            for (int i = 0; i < pageDims.size(); ++i) {
                if (!(pageDims.get(i) instanceof MbgViewListDimensionInfo) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((MbgViewListDimensionInfo)pageDims.get(i)).getNumber())) continue;
                hasOrgDim = true;
                break;
            }
            count = hasOrgDim ? pageDims.size() - 1 : pageDims.size();
        }
        return count;
    }

    public static Map<String, Set<String>> getFormulaMapOfBook(IDimDataQuery info, Book book) {
        if (book == null) {
            return null;
        }
        HashMap<String, Set<String>> formulaMap = new HashMap<String, Set<String>>();
        Sheet sheet = null;
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String formulaStr = null;
        String cellVersion = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formula = BgNFSHelper.getItemFormula(cell);
                    formulaStr = formula.getFormula();
                    cellOrgId = formula.getExt("ORGUNITID");
                    if (cellOrgId == null) {
                        cellOrgId = info.getBizOrgUnit().getId().toString();
                    }
                    if ((cellVersion = formula.getExt("Version")) == null) {
                        cellVersion = info.getBizVersion().getNumber();
                    }
                    if (!formulaMap.containsKey(cellOrgId)) {
                        formulaMap.put(cellOrgId, new HashSet());
                    }
                    ((Set)formulaMap.get(cellOrgId)).add(DimUtils.getDimDataKey(formulaStr, cellVersion));
                }
            }
        }
        return formulaMap;
    }

    public static Set<String> getBgFormIds(BgFormInfo bgForm, Set<String> curOrgNums, SelectorItemCollection sic) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        BgFormCollection colls = MbgViewListDescriptionHelper.getBgFormColls(null, bgForm, curOrgNums, sic, false);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                ids.add(colls.get(i).getId().toString());
            }
        }
        return ids;
    }

    public static void hideToolBar(SpreadContext spreadContext) {
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Copy", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Paste", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Undo", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Redo", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Print", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_PrintPreview", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_PrintSetup", false);
        spreadContext.getToolBarManager().getToolBar("style").setVisible(false);
    }

    public static SelectorItemCollection getDecomposeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgForm.id");
        sic.add("bgForm.bgversion.id");
        sic.add("bgForm.bgversion.number");
        sic.add("bgForm.bgversion.versionId");
        sic.add("bgForm.bgversion.name");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.bgTemplate.bgScheme.id");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.processType");
        sic.add("bgForm.createTime");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.bgPeriod.*");
        sic.add("bgForm.currency.id");
        sic.add("bgScheme.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("refOrgUnit.id");
        sic.add("refOrgUnit.orgUnitID");
        sic.add("refOrgUnit.bgDecomposeForm.id");
        return sic;
    }
}

