/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgPeriodNExprSetterHelper;
import java.util.regex.Pattern;

public class MBgPeriodNVariableHelper
extends BgPeriodNVariableHelper {
    public static void processPeriodNvalue(String viewType, Book book, BgPeriodVariable bgPeriodVariable) throws Exception {
        if (viewType == null || book == null) {
            return;
        }
        BgNFSHelper.disableUndo(book);
        BgNFSHelper.disableCal(book);
        Sheet sheet = book.getActiveSheet();
        if (sheet != null) {
            Range range = sheet.getSelectionRange();
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int i = 0; i < range.size(); ++i) {
                CellBlock block = range.getBlock(i);
                int rowBegin = block.getRow() > maxRow ? maxRow : block.getRow();
                int rowEnd = block.getRow2() > maxRow ? maxRow : block.getRow2();
                int colBegin = block.getCol() > maxCol ? maxCol : block.getCol();
                int colEnd = block.getCol2() > maxCol ? maxCol : block.getCol2();
                for (int j = rowBegin; j <= rowEnd; ++j) {
                    for (int k = colBegin; k <= colEnd; ++k) {
                        Cell cell = sheet.getCell(j, k, false);
                        if (cell == null) continue;
                        if ("BGITEMFORMUAL".equals(viewType)) {
                            MBgPeriodNVariableHelper.processBgItemFormulaView(cell, bgPeriodVariable);
                        } else if ("bgActual".equals(viewType)) {
                            MBgPeriodNVariableHelper.processBgActualView(cell, bgPeriodVariable);
                        } else if ("bgData".equals(viewType)) {
                            MBgPeriodNVariableHelper.processBgDataView(cell, bgPeriodVariable);
                        } else if ("bgActualAdd".equals(viewType)) {
                            MBgPeriodNVariableHelper.processBgActualAddView(cell, bgPeriodVariable);
                        }
                        MBgPeriodNVariableHelper.processBgPeriod(cell, bgPeriodVariable);
                    }
                }
            }
        }
        BgNFSHelper.enableUndo(book);
        BgNFSHelper.enableCal(book);
    }

    private static void processBgPeriod(Cell cell, BgPeriodVariable bgPeriodVariable) {
        if (BgNFSHelper.checkHasBgPeriodInfo(cell)) {
            String period = BgNTemplateHelper.getBgDataValue(cell, "bgFillValue");
            String value = BgPeriodVariable.getBgPeriodParam((String)period, (BgPeriodVariable)bgPeriodVariable);
            cell.setValue(new Variant((Object)value));
            BgNFSHelper.setCellData(cell, "bgFillValue", value);
        }
    }

    public static boolean checkCanProcessPeriodNValue(String viewType) {
        if (viewType == null) {
            return false;
        }
        if ("bgValue".equals(viewType)) {
            return false;
        }
        return "BGITEMFORMUAL".equals(viewType) || "bgActual".equals(viewType) || "bgData".equals(viewType) || "bgActualAdd".equals(viewType);
    }

    private static void processBgDataView(Cell cell, BgPeriodVariable bgPeriodVariable) {
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula(cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, cell.getFormula(), bgPeriodVariable);
            BgNFSHelper.saveExpression(cell, expr, 0);
        }
    }

    private static void processBgActualView(Cell cell, BgPeriodVariable bgPeriodVariable) {
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula(cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, cell.getFormula(), bgPeriodVariable);
            BgNFSHelper.saveExpression(cell, expr, 1);
        }
    }

    private static void processBgActualAddView(Cell cell, BgPeriodVariable bgPeriodVariable) {
        if (BgNTemplateHelper.CheckTemplateHaveDataFormula(cell)) {
            String expr = BgPeriodNExprSetterHelper.checkExpression(cell, cell.getFormula(), bgPeriodVariable);
            BgNFSHelper.saveExpression(cell, expr, 2);
        }
    }

    private static void processBgItemFormulaView(Cell cell, BgPeriodVariable bgPeriodVariable) {
        String formulaString = null;
        String[] param = null;
        String newFormula = null;
        if (BgNFSHelper.checkHasItemFormula(cell)) {
            String isFormSuper;
            ItemFormula uItemFormual = BgNFSHelper.getItemFormula(cell);
            if (uItemFormual != null && "true".equals(isFormSuper = uItemFormual.getExt("isctrl_from_super_collection_form"))) {
                return;
            }
            formulaString = BgNFSHelper.getFormulaOfCell(cell);
            param = BgNFSHelper.parseFormulaPara(null, formulaString);
            if (param == null) {
                return;
            }
            String periodParam = null;
            if (param.length == 4) {
                periodParam = param[1];
                param[1] = BgPeriodVariable.getBgPeriodParam((String)periodParam, (BgPeriodVariable)bgPeriodVariable);
                if (param[1] != null) {
                    newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[4] + "\")";
                }
            }
            if (param.length == 6) {
                periodParam = param[1];
                param[1] = BgPeriodVariable.getBgPeriodParam((String)periodParam, (BgPeriodVariable)bgPeriodVariable);
                if (param[1] != null) {
                    newFormula = "=BgItem(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\"," + param[4] + ",\"" + param[5] + "\")";
                }
            }
            if (newFormula != null) {
                BgNFSHelper.setFormulaOfCell(cell, newFormula);
            }
        }
    }

    public static boolean checkCanConvert(String nValue) {
        if (nValue == null) {
            return false;
        }
        String[] nValues = nValue.split("\\.");
        String periodNum = null;
        String periodType = null;
        String[] tempStrs = null;
        boolean hasPeriodNVariable = false;
        int size = nValues.length;
        for (int i = 0; i < size; ++i) {
            tempStrs = nValues[i].split("!");
            if (tempStrs.length == 1) continue;
            if (tempStrs.length == 2) {
                periodNum = tempStrs[0];
                periodType = tempStrs[1];
                if (Pattern.matches("(N[\\s]?|\\+\\d{1,3}|\\-\\d{1,3})+", periodNum)) {
                    if (!"Y".equals(periodType) && !"HY".equals(periodType) && !"Q".equals(periodType) && !"M".equals(periodType) && !"D".equals(periodType) && !"W".equals(periodType) && !"MW".equals(periodType) && !"TD".equals(periodType)) continue;
                    hasPeriodNVariable = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return hasPeriodNVariable;
    }
}

