/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.ConditionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MBgPeriodVariable {
    public static final String bgPeriodStandardNumber = "bgPeriodStandardNumber";
    private static final String PERIOD_MEMBER_TAG = "(BgP|BgP1|BgP2):\\w{4}.(\\d{2,4}Y|.\\d{2,4}HY|.\\d{2,4}Q|.\\d{2,4}M|.\\d{2,4}M|.\\d{2,4}D|.\\d{2,4}W|.\\d{2,4}MW)+";
    private Locale locale = null;

    public String transPeirodVariale(String expression, BgPeriodVariable bgPeriodVariable) {
        if (StringUtils.isEmpty((String)expression) || bgPeriodVariable == null) {
            return expression;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(PERIOD_MEMBER_TAG);
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            matcher.appendReplacement(sb, BgPeriodVariable.getBgPeriodParam((String)matcher.group(), (BgPeriodVariable)bgPeriodVariable));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Set<String> transPeirodVariale(IObjectValue model, String expression, Set<String> standPeriodNumber, Set<String> bgPeriodChecks, List<String> causes) {
        HashSet<String> bgPeriodNums = new HashSet<String>();
        if (StringUtils.isEmpty((String)expression) || standPeriodNumber == null) {
            return bgPeriodNums;
        }
        for (String bgPeriodNum : standPeriodNumber) {
            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
            try {
                bgPeriodNum = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)expression, (int)periodType);
                if (bgPeriodChecks != null && !bgPeriodChecks.contains(bgPeriodNum)) continue;
                bgPeriodNums.add(bgPeriodNum);
            }
            catch (Exception ex) {
                MessageFormat mf;
                if (model instanceof BizCalcInfo) {
                    mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBizScope", (Locale)this.locale));
                    causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BizCalcInfo)model).getNumber(), expression, bgPeriodNum}));
                    continue;
                }
                if (!(model instanceof BgExamineInfo)) continue;
                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamineScope", (Locale)this.locale));
                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BgExamineInfo)model).getNumber(), expression, bgPeriodNum}));
            }
        }
        return bgPeriodNums;
    }

    public MBgPeriodVariable(Locale locale) {
        this.locale = locale;
    }

    public void transPeirodVariale(Context ctx, String bgSchemeId, List<?> models, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, String orgViewID, String orgNumber, String unionId) throws EASBizException, ParseException {
        if (models == null || models.isEmpty() || bgPeriodNums == null) {
            return;
        }
        ArrayList<String> causes = new ArrayList<String>();
        Object model = null;
        BizCalcInfo calc = null;
        BgExamineInfo examine = null;
        BizCalcSubsetInfo bizSubset = null;
        BgExamineSubsetInfo exSubset = null;
        Boolean isExpressionCalc = false;
        if (ctx != null && ctx.get((Object)"isExpressionCalc") instanceof Boolean) {
            isExpressionCalc = true;
        }
        int xn = models.size();
        for (int x = 0; x < xn; ++x) {
            int y;
            int yn;
            model = models.get(x);
            if (model instanceof BizCalcInfo) {
                calc = model;
                yn = calc.getBizCalcSubset().size();
                for (y = 0; y < yn; ++y) {
                    bizSubset = calc.getBizCalcSubset().get(y);
                    if (!StringUtils.isEmpty((String)orgNumber) && !StringUtils.isEmpty((String)orgViewID) && !StringUtils.isEmpty((String)bgSchemeId) && isExpressionCalc.booleanValue() && !bizSubset.checkHasOrgScope(ctx, orgNumber, orgViewID, bgSchemeId, unionId != null ? BOSUuid.read((String)unionId) : null)) continue;
                    this.transPeirodVariale((IObjectValue)calc, bizSubset.getExpres(), bgPeriodNums, bgPeriodChecks, causes, null);
                    this.transPeirodVariale((IObjectValue)calc, (IObjectCollection)bizSubset.getScope(), bgPeriodNums, bgPeriodChecks, causes);
                }
                continue;
            }
            if (!(model instanceof BgExamineInfo)) continue;
            examine = model;
            yn = examine.getBgExamineSubset().size();
            for (y = 0; y < yn; ++y) {
                exSubset = examine.getBgExamineSubset().get(y);
                this.transPeirodVariale((IObjectValue)examine, exSubset.getExpres(true), bgPeriodNums, bgPeriodChecks, causes, null);
                this.transPeirodVariale((IObjectValue)examine, (IObjectCollection)exSubset.getBgScope(), bgPeriodNums, bgPeriodChecks, causes);
            }
        }
        this.checkPeriodCause(model, causes);
    }

    public void transPeirodVariale(Context ctx, List<?> models, Set<String> bgPeriodNums, Set<String> bgPeriodChecks) throws EASBizException, ParseException {
        this.transPeirodVariale(ctx, null, models, bgPeriodNums, bgPeriodChecks, null, null, null);
    }

    private void checkPeriodCause(Object model, List<String> causes) throws EASBizException {
        if (model == null || causes == null || causes.isEmpty()) {
            return;
        }
        StringBuffer cause = new StringBuffer();
        int in = causes.size();
        for (int i = 0; i < in; ++i) {
            cause.append(causes.get(i) + "\r\n");
        }
        if (model instanceof BizCalcInfo) {
            throw new BgPeriodException(BgPeriodException.TRANSPERIODVARIABLEBYBIZ, new Throwable(cause.toString()));
        }
        if (model instanceof BgExamineInfo) {
            throw new BgPeriodException(BgPeriodException.TRANSPERIODVARIABLEBYEXAMINE, new Throwable(cause.toString()));
        }
    }

    public void transPeirodVariale(IObjectValue model, IObjectCollection scopes, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, List<String> causes) {
        if (this.locale == null || model == null || scopes == null || scopes.isEmpty() || bgPeriodNums == null || causes == null) {
            return;
        }
        IObjectValue scope = null;
        String _bgPeriodNum = null;
        String _variableNum = null;
        CoreBaseCollection clones = new CoreBaseCollection();
        int in = scopes.size();
        for (int i = 0; i < in; ++i) {
            scope = scopes.getObject(i);
            if (model instanceof BizCalcInfo) {
                BizScopeInfo _bizScope = (BizScopeInfo)scope;
                String memberNumber = _bizScope.getBgMemberNum();
                if (4 == _bizScope.getBizDataType().getValue() && DimensionBaseConstants.DEF_PERIOD_FIELD.equals(_bizScope.getRefField())) {
                    memberNumber = BizExprUtils.getDimMemByScopeFunction((String)_bizScope.getBgMemberNum());
                }
                if (bgPeriodNums != null && DimensionBaseConstants.DEF_PERIOD_FIELD.equals(_bizScope.getRefField()) && BgPeriodNVariableHelper.checkCanConvert((String)memberNumber)) {
                    boolean first = true;
                    for (String bgPeriodNum : bgPeriodNums) {
                        MessageFormat mf;
                        if (1 == _bizScope.getBizDataType().getValue()) {
                            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                            try {
                                _bgPeriodNum = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)_bizScope.getBgMemberNum(), (int)periodType);
                            }
                            catch (Exception ex) {
                                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBizScope", (Locale)this.locale));
                                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BizCalcInfo)model).getNumber(), _bizScope.getBgMemberNum(), bgPeriodNum}));
                            }
                        } else if (4 == _bizScope.getBizDataType().getValue()) {
                            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                            try {
                                _bgPeriodNum = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)memberNumber, (int)periodType);
                                if (!StringUtils.isEmpty((String)_bgPeriodNum)) {
                                    _bgPeriodNum = _bizScope.getBgMemberNum().replace(memberNumber, _bgPeriodNum);
                                }
                            }
                            catch (Exception ex) {
                                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBizScope", (Locale)this.locale));
                                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BizCalcInfo)model).getNumber(), _bizScope.getBgMemberNum(), bgPeriodNum}));
                            }
                        }
                        if (StringUtils.isEmpty(_bgPeriodNum) || bgPeriodChecks != null && !bgPeriodChecks.contains(_bgPeriodNum)) continue;
                        if (first) {
                            _bizScope.setBgMemberNum(_bgPeriodNum);
                            first = false;
                            continue;
                        }
                        BizScopeInfo _tmpScope = _bizScope.clone();
                        _tmpScope.setBgMemberNum(_bgPeriodNum);
                        clones.addObject((IObjectValue)_tmpScope);
                    }
                }
            } else if (model instanceof BgExamineInfo) {
                BgScopeInfo _exScope = (BgScopeInfo)scope;
                if (bgPeriodNums != null && DimensionBaseConstants.DEF_PERIOD_FIELD.equals(_exScope.getRefField()) && BgPeriodNVariableHelper.checkCanConvert((String)_exScope.getBgMemberNum())) {
                    boolean first = true;
                    for (String bgPeriodNum : bgPeriodNums) {
                        MessageFormat mf;
                        if (1 == _exScope.getBizDataType().getValue()) {
                            _variableNum = _exScope.getString("back_result");
                            if (_variableNum == null) {
                                _variableNum = _exScope.getBgMemberNum();
                            }
                            if (_exScope.getString("back_result") == null) {
                                _exScope.setString("back_result", _variableNum);
                            }
                            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                            try {
                                _bgPeriodNum = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)_variableNum, (int)periodType);
                            }
                            catch (Exception ex) {
                                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamineScope", (Locale)this.locale));
                                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BgExamineInfo)model).getNumber(), _exScope.getBgMemberNum(), bgPeriodNum}));
                            }
                        } else if (4 == _exScope.getBizDataType().getValue()) {
                            _variableNum = _exScope.getString("back_result");
                            if (_variableNum == null) {
                                _variableNum = _exScope.getBgMemberNum();
                            }
                            if (_exScope.getString("back_result") == null) {
                                _exScope.setString("back_result", _variableNum);
                            }
                            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                            try {
                                _bgPeriodNum = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)_variableNum, (int)periodType);
                            }
                            catch (Exception ex) {
                                mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamineScope", (Locale)this.locale));
                                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BgExamineInfo)model).getNumber(), _exScope.getBgMemberNum(), bgPeriodNum}));
                            }
                        }
                        if (StringUtils.isEmpty(_bgPeriodNum) || bgPeriodChecks != null && !bgPeriodChecks.contains(_bgPeriodNum)) continue;
                        if (first) {
                            _exScope.setBgMemberNum(_bgPeriodNum);
                            first = false;
                            continue;
                        }
                        BgScopeInfo _tmpScope = _exScope.clone();
                        _tmpScope.setBgMemberNum(_bgPeriodNum);
                        clones.addObject((IObjectValue)_tmpScope);
                    }
                }
            }
            if (clones.isEmpty()) continue;
            scopes.addObjectCollection((IObjectCollection)clones);
        }
    }

    public boolean checkPeirodVariale(List<?> models, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, boolean hasTransCheck) throws ParseException, EASBizException {
        boolean check = false;
        if (models == null || models.isEmpty()) {
            return check;
        }
        Object model = null;
        BizCalcInfo bizCalc = null;
        BizCalcSubsetInfo bizCalcSub = null;
        BizScopeInfo bizScope = null;
        BgExamineInfo examine = null;
        BgExamineSubsetInfo subset = null;
        BgScopeInfo scope = null;
        ArrayList<String> causes = new ArrayList<String>();
        ArrayList<String> periodVariable = new ArrayList<String>();
        int xn = models.size();
        for (int x = 0; x < xn && !check; ++x) {
            int z;
            int zn;
            int y;
            int yn;
            model = models.get(x);
            if (model instanceof BizCalcInfo) {
                bizCalc = model;
                yn = bizCalc.getBizCalcSubset().size();
                for (y = 0; y < yn && !check; ++y) {
                    bizCalcSub = bizCalc.getBizCalcSubset().get(y);
                    zn = bizCalcSub.getScope().size();
                    for (z = 0; z < zn && !check; ++z) {
                        bizScope = bizCalcSub.getScope().get(z);
                        this.checkScopePeirodVariale((IObjectValue)bizCalc, (IObjectValue)bizScope, bgPeriodNums, causes, periodVariable);
                        if (bgPeriodNums != null || periodVariable.isEmpty()) continue;
                        check = true;
                    }
                    this.checkExprPeirodVariale((IObjectValue)bizCalc, bizCalcSub.getExpres(), bgPeriodNums, causes, periodVariable);
                    if (bgPeriodNums != null || periodVariable.isEmpty()) continue;
                    check = true;
                }
                continue;
            }
            if (!(model instanceof BgExamineInfo)) continue;
            examine = model;
            yn = examine.getBgExamineSubset().size();
            for (y = 0; y < yn && !check; ++y) {
                subset = examine.getBgExamineSubset().get(y);
                zn = subset.getBgScope().size();
                for (z = 0; z < zn && !check; ++z) {
                    scope = subset.getBgScope().get(z);
                    this.checkScopePeirodVariale((IObjectValue)examine, (IObjectValue)scope, bgPeriodNums, causes, periodVariable);
                    if (bgPeriodNums != null || periodVariable.isEmpty()) continue;
                    check = true;
                }
                this.checkExprPeirodVariale((IObjectValue)examine, subset.getExpres(), bgPeriodNums, causes, periodVariable);
                if (bgPeriodNums != null || periodVariable.isEmpty()) continue;
                check = true;
            }
        }
        if (!periodVariable.isEmpty()) {
            check = true;
        }
        if (hasTransCheck) {
            this.checkPeriodCause(model, causes);
        }
        return check;
    }

    private void checkScopePeirodVariale(IObjectValue model, IObjectValue scope, Set<String> bgPeriodNums, List<String> causes, List<String> periodVariable) {
        block14: {
            block13: {
                if (model == null || scope == null || periodVariable == null) {
                    return;
                }
                if (!(model instanceof BgExamineInfo) || !(scope instanceof BgScopeInfo)) break block13;
                BgExamineInfo _examine = (BgExamineInfo)model;
                BgScopeInfo _scope = (BgScopeInfo)scope;
                if (_scope.getBgMemberType() != BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                    return;
                }
                if (!DimensionBaseConstants.DEF_PERIOD_FIELD.equals(_scope.getRefField()) || !BgPeriodNVariableHelper.checkCanConvert((String)_scope.getBgMemberNum())) break block14;
                periodVariable.add(_scope.getBgMemberNum());
                if (bgPeriodNums != null) {
                    for (String bgPeriodNum : bgPeriodNums) {
                        int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                        try {
                            BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)_scope.getBgMemberNum(), (int)periodType);
                        }
                        catch (Exception ex) {
                            if (causes == null) continue;
                            MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamineScope", (Locale)this.locale));
                            causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), _examine.getNumber(), _scope.getBgMemberNum(), bgPeriodNum}));
                        }
                    }
                }
                break block14;
            }
            if (model instanceof BizCalcInfo && scope instanceof BizScopeInfo) {
                BizCalcInfo _bizCalc = (BizCalcInfo)model;
                BizScopeInfo _scope = (BizScopeInfo)scope;
                if (_scope.getBgMemberType() != BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                    return;
                }
                if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(_scope.getRefField()) && BgPeriodNVariableHelper.checkCanConvert((String)_scope.getBgMemberNum())) {
                    periodVariable.add(_scope.getBgMemberNum());
                    if (bgPeriodNums != null) {
                        for (String bgPeriodNum : bgPeriodNums) {
                            int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                            try {
                                BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)_scope.getBgMemberNum(), (int)periodType);
                            }
                            catch (Exception ex) {
                                if (causes == null) continue;
                                MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBizScope", (Locale)this.locale));
                                causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), _bizCalc.getNumber(), _scope.getBgMemberNum(), bgPeriodNum}));
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkExprPeirodVariale(IObjectValue model, List<IExpress> expres, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        if (model == null || expres == null || peiiodVariable == null) {
            return;
        }
        for (IExpress expr : expres) {
            this.checkExprPeirodVariale(model, expr, bgPeriodNums, causes, peiiodVariable);
        }
    }

    private void checkExprPeirodVariale(IObjectValue model, IExpress expr, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        if (model == null || expr == null || peiiodVariable == null) {
            return;
        }
        if (expr instanceof BinaryExpr) {
            this.checkExprPeirodVariale(model, (BinaryExpr)expr, bgPeriodNums, causes, peiiodVariable);
        }
    }

    private void checkExprPeirodVariale(IObjectValue model, BinaryExpr expr, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        FunctionExpr fExpr;
        if (model == null || expr == null || peiiodVariable == null) {
            return;
        }
        if (expr.left instanceof MdxMemberExpr) {
            this.checkExprPeirodVariale(model, (MdxMemberExpr)expr.left, bgPeriodNums, causes, peiiodVariable);
        } else if (expr.left instanceof BinaryExpr) {
            this.checkExprPeirodVariale(model, (BinaryExpr)expr.left, bgPeriodNums, causes, peiiodVariable);
        } else if (expr.left instanceof FunctionExpr) {
            fExpr = (FunctionExpr)expr.left;
            this.checkFunctionExprPeriodVariable(model, fExpr, bgPeriodNums, causes, peiiodVariable);
        }
        if (expr.right instanceof MdxMemberExpr) {
            this.checkExprPeirodVariale(model, (MdxMemberExpr)expr.right, bgPeriodNums, causes, peiiodVariable);
        } else if (expr.right instanceof BinaryExpr) {
            this.checkExprPeirodVariale(model, (BinaryExpr)expr.right, bgPeriodNums, causes, peiiodVariable);
        } else if (expr.right instanceof FunctionExpr) {
            fExpr = (FunctionExpr)expr.right;
            this.checkFunctionExprPeriodVariable(model, fExpr, bgPeriodNums, causes, peiiodVariable);
        }
    }

    private void checkFunctionExprPeriodVariable(IObjectValue model, FunctionExpr fExpr, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        if (model == null || fExpr == null || peiiodVariable == null) {
            return;
        }
        if (fExpr.functionName.equalsIgnoreCase("Abs")) {
            List params = fExpr.params;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof BinaryExpr) {
                    this.checkExprPeirodVariale(model, (BinaryExpr)params.get(i), bgPeriodNums, causes, peiiodVariable);
                    continue;
                }
                if (!(params.get(i) instanceof MdxMemberExpr)) continue;
                this.checkExprPeirodVariale(model, (MdxMemberExpr)params.get(i), bgPeriodNums, causes, peiiodVariable);
            }
        }
    }

    private void checkExprPeirodVariale(IObjectValue model, MdxMemberExpr expr, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        if (model == null || expr == null || peiiodVariable == null) {
            return;
        }
        IExpress _expr = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            _expr = (IExpress)expr.params.get(i);
            if (!(_expr instanceof MemberExpr)) continue;
            this.checkExprPeirodVariale(model, (MemberExpr)_expr, bgPeriodNums, causes, peiiodVariable);
        }
    }

    private void checkExprPeirodVariale(IObjectValue model, MemberExpr expr, Set<String> bgPeriodNums, List<String> causes, List<String> peiiodVariable) {
        if (model == null || expr == null || peiiodVariable == null) {
            return;
        }
        if ((DimensionBaseConstants.DEF_PERIOD_FIELD.equals(expr.field) || DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(expr.srcNumber) || "BgP1".equals(expr.srcNumber) || "BgP2".equals(expr.srcNumber)) && BgPeriodNVariableHelper.checkCanConvert((String)expr.number)) {
            peiiodVariable.add(expr.number);
            if (bgPeriodNums != null) {
                for (String bgPeriodNum : bgPeriodNums) {
                    int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                    try {
                        BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)expr.number, (int)periodType);
                    }
                    catch (Exception ex) {
                        MessageFormat mf;
                        if (causes == null) continue;
                        if (model instanceof BizCalcInfo) {
                            mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBiz", (Locale)this.locale));
                            causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BizCalcInfo)model).getNumber(), expr.number, bgPeriodNum}));
                            continue;
                        }
                        if (!(model instanceof BgExamineInfo)) continue;
                        mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamine", (Locale)this.locale));
                        causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BgExamineInfo)model).getNumber(), expr.number, bgPeriodNum}));
                    }
                }
            }
        }
    }

    public void transPeirodVariale(IObjectValue model, Collection<IExpress> exprs, Set<String> bgPeriodNums, Set<String> bgPeriodChecks, List<String> causes, Map<String, String> expresMap) throws EASBizException {
        if (exprs == null || bgPeriodNums == null) {
            return;
        }
        boolean first = true;
        boolean check = false;
        IExpress _expr = null;
        IExpress _cExpr = null;
        String exprKey = null;
        HashSet<String> exprKeys = new HashSet<String>();
        ArrayList<IExpress> clones = new ArrayList<IExpress>();
        for (IExpress expr : exprs) {
            if (expr instanceof BinaryExpr && !((BinaryExpr)expr).hasCalc) continue;
            first = true;
            _expr = null;
            for (String bgPeriodNum : bgPeriodNums) {
                if (first) {
                    try {
                        _expr = expr.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                    check = this.transPeirodVariale(model, expr, bgPeriodNum, causes);
                    exprKeys.add(expr.toString());
                    first = false;
                    if (expresMap == null || !check) continue;
                    expresMap.put(expr.toPlanString(), _expr.toPlanString());
                    continue;
                }
                if (_expr == null) continue;
                try {
                    _cExpr = _expr.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                if (!(check = this.transPeirodVariale(model, _expr, bgPeriodNum, causes))) continue;
                exprKey = _expr.toString();
                if (!exprKeys.contains(exprKey)) {
                    exprKeys.add(exprKey);
                    clones.add(_expr);
                }
                if (expresMap == null) continue;
                expresMap.put(_cExpr.toPlanString(), _expr.toPlanString());
            }
        }
        if (!clones.isEmpty()) {
            exprs.addAll(clones);
        }
    }

    private boolean transPeirodVariale(IObjectValue model, IExpress expr, String bgPeriodNum, List<String> causes) {
        boolean check = false;
        if (expr == null || bgPeriodNum == null) {
            return check;
        }
        if (expr instanceof BinaryExpr) {
            check = this.transPeirodVariale(model, (BinaryExpr)expr, bgPeriodNum, causes);
        } else if (expr instanceof MdxMemberExpr) {
            check = this.transPeirodVariale(model, (MdxMemberExpr)expr, bgPeriodNum, causes);
        } else if (expr instanceof BinaryExpr) {
            check = this.transPeirodVariale(model, (BinaryExpr)expr, bgPeriodNum, causes);
        } else if (expr instanceof FunctionExpr) {
            FunctionExpr fExpr = (FunctionExpr)expr;
            check = this.transPeriodVariable(model, fExpr, bgPeriodNum, causes);
        } else if (expr instanceof ConditionExpr) {
            ConditionExpr fExpr = (ConditionExpr)expr;
            check = this.transPeriodVariable(model, fExpr, bgPeriodNum, causes);
        }
        return check;
    }

    private boolean transPeirodVariale(IObjectValue model, BinaryExpr expr, String bgPeriodNum, List<String> causes) {
        boolean check = false;
        if (expr == null || bgPeriodNum == null) {
            return check;
        }
        check = this.transPeirodVariale(model, expr.left, bgPeriodNum, causes);
        check = this.transPeirodVariale(model, expr.right, bgPeriodNum, causes);
        return check;
    }

    private boolean transPeriodVariable(IObjectValue model, ConditionExpr fExpr, String bgPeriodNum, List<String> causes) {
        boolean check = true;
        for (IExpress expr : fExpr.getAllExpresss()) {
            check = this.transPeirodVariale(model, expr, bgPeriodNum, causes);
        }
        return check;
    }

    private boolean transPeriodVariable(IObjectValue model, FunctionExpr fExpr, String bgPeriodNum, List<String> causes) {
        if (fExpr == null || bgPeriodNum == null) {
            return false;
        }
        boolean check = true;
        if (fExpr.functionName.equalsIgnoreCase("Abs")) {
            List params = fExpr.params;
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) instanceof BinaryExpr) {
                    check = this.transPeirodVariale(model, (BinaryExpr)params.get(i), bgPeriodNum, causes);
                    continue;
                }
                if (!(params.get(i) instanceof MdxMemberExpr)) continue;
                check = this.transPeirodVariale(model, (MdxMemberExpr)params.get(i), bgPeriodNum, causes);
            }
        }
        return check;
    }

    private boolean transPeirodVariale(IObjectValue model, MdxMemberExpr mdxMemberExpr, String bgPeriodNum, List<String> causes) {
        if (mdxMemberExpr == null || bgPeriodNum == null) {
            return false;
        }
        IExpress expr = null;
        boolean check = true;
        int in = mdxMemberExpr.params.size();
        for (int i = 0; i < in && check; ++i) {
            expr = (IExpress)mdxMemberExpr.params.get(i);
            if (!(expr instanceof MemberExpr)) continue;
            check = this.transPeirodVariale(model, (MemberExpr)expr, bgPeriodNum, causes);
        }
        return check;
    }

    private boolean transPeirodVariale(IObjectValue model, MemberExpr memberExpr, String bgPeriodNum, List<String> causes) {
        block5: {
            if (this.locale == null || model == null || memberExpr == null || bgPeriodNum == null) {
                return true;
            }
            if ((DimensionBaseConstants.DEF_PERIOD_FIELD.equals(memberExpr.field) || DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(memberExpr.srcNumber) || "BgP1".equals(memberExpr.srcNumber) || "BgP2".equals(memberExpr.srcNumber)) && BgPeriodNVariableHelper.checkCanConvert((String)memberExpr.number)) {
                try {
                    int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNum);
                    memberExpr.number = BgPeriodNVariableHelper.getBgPeriodByN((String)bgPeriodNum, (String)memberExpr.number, (int)periodType);
                }
                catch (Exception ex) {
                    if (causes == null) break block5;
                    if (model instanceof BizCalcInfo) {
                        MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByBiz", (Locale)this.locale));
                        causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BizCalcInfo)model).getNumber(), memberExpr.number, bgPeriodNum}));
                    }
                    if (!(model instanceof BgExamineInfo)) break block5;
                    MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"transPeriodVariableByExamine", (Locale)this.locale));
                    causes.add(mf.format(new String[]{String.valueOf(causes.size() + 1), ((BgExamineInfo)model).getNumber(), memberExpr.number, bgPeriodNum}));
                }
            }
        }
        return true;
    }

    public String getBgPeriodNumbers(Context ctx, Set<String> bgPeriodNumbers, BizCalcInfo bizCalc, BgPeriodInfo periodInfo, BgSchemeInfo bgSchemeInfo) throws Exception {
        BizCalcSubsetInfo bizSubset = null;
        BizScopeInfo bizScope = null;
        int yn = bizCalc.getBizCalcSubset().size();
        for (int y = 0; y < yn; ++y) {
            bizSubset = bizCalc.getBizCalcSubset().get(y);
            int zn = bizSubset.getScope().size();
            for (int z = 0; z < zn; ++z) {
                bizScope = bizSubset.getScope().get(z);
                if (bizScope.getBgMemberType() != BizConstants.BIZ_BGPERIOD_TYPE_VALUE) {
                    return null;
                }
                if (bizScope.getBizDataType().getValue() == 1) {
                    if (!DimensionBaseConstants.DEF_PERIOD_FIELD.equals(bizScope.getRefField())) continue;
                    if (!BgPeriodNVariableHelper.checkCanConvert((String)bizScope.getBgMemberNum())) {
                        bgPeriodNumbers.add(bizScope.getBgMemberNum());
                        continue;
                    }
                    try {
                        bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)periodInfo.getNumber(), (String)bizScope.getBgMemberNum(), (int)periodInfo.getPeriodType().getValue()));
                        continue;
                    }
                    catch (Exception e) {
                        return bizScope.getBgMemberNum();
                    }
                }
                if (bizScope.getBizDataType().getValue() != 4) continue;
                HashSet<String> numbers = new HashSet<String>();
                numbers.add(periodInfo.getNumber());
                ArrayList<BizCalcInfo> bizCalcs = new ArrayList<BizCalcInfo>();
                bizCalcs.add(bizCalc);
                this.transPeirodVariale(ctx, bizCalcs, numbers, null);
                MbgDimCollection mbgDims = new MbgDimCollection();
                MbgDimInfo mbgDimInfo = new MbgDimInfo();
                mbgDimInfo.setNumber(DimensionConstants.DEF_PERIOD_NUMBER);
                mbgDimInfo.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                mbgDimInfo.setRefField(DimensionConstants.DEF_PERIOD_FIELD);
                mbgDims.add(mbgDimInfo);
                Map scopeData = bizSubset.getScopeData(new HashMap(), numbers, null, true, true, ctx, bgSchemeInfo, mbgDims);
                bizSubset.setScopeMap(null);
                if (!scopeData.containsKey(DimensionConstants.DEF_PERIOD_FIELD) || scopeData.get(DimensionConstants.DEF_PERIOD_FIELD) == null || ((Set)scopeData.get(DimensionConstants.DEF_PERIOD_FIELD)).isEmpty()) continue;
                bgPeriodNumbers.addAll((Collection)scopeData.get(DimensionConstants.DEF_PERIOD_FIELD));
            }
            String errPeriod = this.getExprPeirodNumbers(bizCalc, bizSubset.getExpres(), periodInfo, bgPeriodNumbers);
            if (errPeriod == null) continue;
            return errPeriod;
        }
        return null;
    }

    private String getExprPeirodNumbers(BizCalcInfo bizCalc, List<IExpress> expres, BgPeriodInfo periodInfo, Set<String> bgPeriodNumbers) throws BgPeriodException {
        if (bizCalc == null || expres == null || periodInfo == null || bgPeriodNumbers == null) {
            return null;
        }
        for (IExpress expr : expres) {
            String errPeriod = this.getExprPeirodNumbers(bizCalc, expr, periodInfo, bgPeriodNumbers);
            if (errPeriod == null) continue;
            return errPeriod;
        }
        return null;
    }

    private String getExprPeirodNumbers(BizCalcInfo bizCalc, IExpress expr, BgPeriodInfo periodInfo, Set<String> bgPeriodNumbers) throws BgPeriodException {
        String errPeriod;
        if (bizCalc == null || expr == null || periodInfo == null || bgPeriodNumbers == null) {
            return null;
        }
        if (expr instanceof BinaryExpr && (errPeriod = this.getExprPeirodNumbers(bizCalc, (BinaryExpr)expr, periodInfo, bgPeriodNumbers)) != null) {
            return errPeriod;
        }
        return null;
    }

    private String getExprPeirodNumbers(BizCalcInfo bizCalc, BinaryExpr expr, BgPeriodInfo periodInfo, Set<String> bgPeriodNumbers) throws BgPeriodException {
        if (bizCalc == null || expr == null || periodInfo == null || bgPeriodNumbers == null) {
            return null;
        }
        String errPeriod = null;
        if (expr.left instanceof MdxMemberExpr) {
            errPeriod = this.getExprPeirodNumbers(bizCalc, (MdxMemberExpr)expr.left, periodInfo, bgPeriodNumbers);
        } else if (expr.left instanceof BinaryExpr) {
            errPeriod = this.getExprPeirodNumbers(bizCalc, (BinaryExpr)expr.left, periodInfo, bgPeriodNumbers);
        }
        if (errPeriod != null) {
            return errPeriod;
        }
        if (expr.right instanceof MdxMemberExpr) {
            errPeriod = this.getExprPeirodNumbers(bizCalc, (MdxMemberExpr)expr.right, periodInfo, bgPeriodNumbers);
        } else if (expr.right instanceof BinaryExpr) {
            errPeriod = this.getExprPeirodNumbers(bizCalc, (BinaryExpr)expr.right, periodInfo, bgPeriodNumbers);
        }
        return errPeriod;
    }

    private String getExprPeirodNumbers(BizCalcInfo bizCalc, MdxMemberExpr expr, BgPeriodInfo periodInfo, Set<String> bgPeriodNumbers) throws BgPeriodException {
        if (bizCalc == null || expr == null || periodInfo == null || bgPeriodNumbers == null) {
            return null;
        }
        IExpress _expr = null;
        int in = expr.params.size();
        for (int i = 0; i < in; ++i) {
            String errPeriod;
            _expr = (IExpress)expr.params.get(i);
            if (!(_expr instanceof MemberExpr) || (errPeriod = this.getExprPeirodNumbers(bizCalc, (MemberExpr)_expr, periodInfo, bgPeriodNumbers)) == null) continue;
            return errPeriod;
        }
        return null;
    }

    private String getExprPeirodNumbers(BizCalcInfo bizCalc, MemberExpr expr, BgPeriodInfo periodInfo, Set<String> bgPeriodNumbers) throws BgPeriodException {
        if (bizCalc == null || expr == null || periodInfo == null || bgPeriodNumbers == null) {
            return null;
        }
        if (DimensionBaseConstants.DEF_PERIOD_FIELD.equals(expr.field) || DimensionBaseConstants.DEF_PERIOD_SRCNUMBER.equals(expr.srcNumber)) {
            if (!BgPeriodNVariableHelper.checkCanConvert((String)expr.number)) {
                bgPeriodNumbers.add(expr.number);
            } else {
                try {
                    bgPeriodNumbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)periodInfo.getNumber(), (String)expr.number, (int)periodInfo.getPeriodType().getValue()));
                }
                catch (Exception e) {
                    return expr.number;
                }
            }
        }
        return null;
    }
}

