/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFormItemHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.IAdjust;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgAdjustHelper {
    private static final Logger logger = CoreUIObject.getLogger(MbgAdjustHelper.class);
    private IAdjust adjust;

    public MbgAdjustHelper(IAdjust adjust) {
        this.adjust = adjust;
    }

    public void loadAdjustMap(Map adjustData, Map adjustMap, String orgUnitId) {
        BgNFSHelper.loadAdjustMap(adjustData, adjustMap, orgUnitId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    public void loadAdjustMapForMultiOrg(Map adjustData, Map adjustMap, Set<String> orgIdSet) {
        BgNFSHelper.loadAdjustMapForMultiOrg(adjustData, adjustMap, orgIdSet, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    public void cell_Content_Changed(SheetChangeEvent e) {
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet _sheet = null;
            Cell _cell = null;
            CellBlock _block = null;
            SortedCellBlockArray _blocks = null;
            _sheet = e.getSheet();
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            _blocks = e.getChangedBlocks();
            int size = _blocks.size();
            for (int index = 0; index < size; ++index) {
                _block = _blocks.getBlock(index);
                if (_block == null) continue;
                int rowBegin = _block.getRow();
                int rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                int colBegin = _block.getCol();
                int colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        this.updateCellChangeValueInfo(_cell);
                    }
                }
            }
            BgNFSHelper.setBlocksChangeLastUpdataTime(_sheet, _blocks);
        }
    }

    public void updateCellChangeValueInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            String _formulaStr = null;
            String _orgUnitId = null;
            String _versionNumber = null;
            String key = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            if (this.hasBudgetScen(_formulaStr)) {
                try {
                    if (!BgNFormItemHelper.checkBgItemFullOfDim(this.adjust.getSchemeHelper(), BgNFSHelper.getFormulaOfCell(cell), true)) {
                        return;
                    }
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                _obj = BgNFSHelper.getValue(cell);
                if (_obj instanceof BigDecimal) {
                    _newValue = (BigDecimal)_obj;
                } else if (_obj == null) {
                    _newValue = null;
                } else {
                    try {
                        _newValue = new BigDecimal(_obj.toString());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                _obj = cell.getUserObjectValue("ITEM");
                _orgUnitId = ((ItemFormula)_obj).getExt("ORGUNITID");
                _versionNumber = ((ItemFormula)_obj).getExt("Version");
                Map _map = null;
                if (this.adjust.isFixel()) {
                    _map = this.adjust.getBgDataMap();
                    key = _formulaStr + "_" + this.adjust.getBgVersion();
                } else {
                    _map = (Map)this.adjust.getBgDataMap().get(_orgUnitId);
                    key = _formulaStr + "_" + _versionNumber;
                }
                BgNDataInfo dataInfo = null;
                if (_map != null && !_map.isEmpty() && _map.get(key) != null) {
                    dataInfo = (BgNDataInfo)_map.get(key);
                    _oldValue = dataInfo.getBudgetValue();
                    if (_oldValue != null && dataInfo.getOldValue() != null && _oldValue.compareTo(dataInfo.getOldValue()) != 0) {
                        _oldValue = dataInfo.getOldValue();
                    }
                } else {
                    _oldValue = null;
                }
                if (_newValue == null && dataInfo != null && dataInfo.getState() > 1 && dataInfo.getState() != 5) {
                    _newValue = BgNConstants.ZERO;
                    BgNFSHelper.setValue(cell, _newValue);
                }
                this.setDivInfo(cell, _newValue, _oldValue);
            }
        }
    }

    private boolean hasBudgetScen(String formulaStr) {
        boolean check;
        block10: {
            check = false;
            if (formulaStr == null || this.adjust == null) {
                return check;
            }
            String[] params = BgNFSHelper.parseFormulaPara(formulaStr);
            Method method = null;
            try {
                DimensionMemberCheckFactory checkFactory;
                try {
                    method = this.adjust.getClass().getMethod("getCheckHelper", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (method != null) {
                    DimensionMemberCheckHelper checkhelper = (DimensionMemberCheckHelper)method.invoke((Object)this.adjust, null);
                    if (checkhelper != null && checkhelper.isBudgetScen(params[3])) {
                        check = true;
                    }
                    break block10;
                }
                try {
                    method = this.adjust.getClass().getMethod("getCheckFactory", null);
                }
                catch (Exception checkhelper) {
                    // empty catch block
                }
                if (method != null && (checkFactory = (DimensionMemberCheckFactory)method.invoke((Object)this.adjust, null)) != null && checkFactory.getCacheHelper().getBudgetScens().contains(params[3])) {
                    check = true;
                }
            }
            catch (Exception ex) {
                check = false;
            }
        }
        return check;
    }

    public void setDivInfo(Cell cell, BigDecimal _newValue, BigDecimal _oldValue) {
        ItemFormula formula = (ItemFormula)cell.getUserObjectValue("ITEM");
        if (formula == null) {
            return;
        }
        String _orgUnitId = formula.getExt("ORGUNITID");
        String _versionNumber = formula.getExt("Version");
        if (_newValue == null) {
            boolean isRemove = false;
            if (_oldValue == null) {
                isRemove = true;
            } else if (BgNConstants.ZERO.compareTo(_oldValue) == 0) {
                String key = null;
                Map _map = null;
                if (this.adjust.isFixel()) {
                    _map = this.adjust.getBgDataMap();
                    key = formula.getFormula() + "_" + this.adjust.getBgVersion();
                } else {
                    _map = (Map)this.adjust.getBgDataMap().get(_orgUnitId);
                    key = formula.getFormula() + "_" + _versionNumber;
                }
                BgNDataInfo dataInfo = null;
                if (_map == null || _map.isEmpty() || _map.get(key) == null || (dataInfo = (BgNDataInfo)_map.get(key)) == null || dataInfo.getState() == 5) {
                    // empty if block
                }
            }
            if (isRemove) {
                this.removeDivInfo(cell, formula.getFormula(), _newValue, _oldValue);
                return;
            }
        }
        BgAdjustFormDiversityData divData = this.getAdjustData(formula.getFormula(), _orgUnitId);
        if (!MbgAdjustHelper.compareDivValue(_newValue, _oldValue)) {
            if (divData != null) {
                this.updateDivInfo(cell, formula.getFormula(), _newValue, _oldValue);
            } else {
                this.createDivInfo(cell, formula.getFormula(), _newValue, _oldValue);
            }
            this.adjust.setAdjustSave(false);
        } else if (divData != null) {
            this.updateDivInfo(cell, formula.getFormula(), _newValue, _oldValue);
        }
    }

    public static boolean compareDivValue(BigDecimal newValue, BigDecimal oldValue) {
        boolean re;
        if (newValue != null && oldValue == null) {
            return false;
        }
        if (newValue == null && oldValue != null) {
            return false;
        }
        boolean bl = re = newValue != null && newValue.compareTo(oldValue) == 0;
        if (!re && newValue != null && newValue.subtract(oldValue).abs().compareTo(BgNConstants.DIVVALUE) <= 0) {
            re = true;
        }
        return re;
    }

    public void removeDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        Object obj = cell.getUserObjectValue("ITEM");
        String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
        if (BgNConstants.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell))) {
            BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
        }
        this.removeAdjustData(formulaStr, orgUnitId);
    }

    public void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        Object obj = cell.getUserObjectValue("ITEM");
        String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
        BgAdjustFormDiversityData divData = this.getAdjustData(formulaStr, orgUnitId);
        if (divData != null) {
            if (MbgAdjustHelper.compareDivValue(newValue, divData.getOldValue())) {
                BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
            } else {
                BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
            }
            divData.setNewValue(newValue);
            divData.setAdjustor(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    public void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        BgAdjustFormDiversityData divData = new BgAdjustFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustor(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        Object obj = cell.getUserObjectValue("ITEM");
        String orgUnitId = ((ItemFormula)obj).getExt("ORGUNITID");
        orgUnitId = this.convertOrgUnitId(orgUnitId);
        if (this.adjust.getAdjustMap().get(orgUnitId) == null) {
            this.adjust.getAdjustMap().put(orgUnitId, new HashMap());
        }
        ((Map)this.adjust.getAdjustMap().get(orgUnitId)).put(formulaStr, divData);
        BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
    }

    private String convertOrgUnitId(String orgUnitId) {
        if (this.adjust.isFixel()) {
            return this.adjust.getOrgUnitId();
        }
        return orgUnitId;
    }

    private BgAdjustFormDiversityData getAdjustData(String formula, String orgUnitId) {
        orgUnitId = this.convertOrgUnitId(orgUnitId);
        if (this.adjust.getAdjustMap().containsKey(orgUnitId)) {
            return (BgAdjustFormDiversityData)((Map)this.adjust.getAdjustMap().get(orgUnitId)).get(formula);
        }
        return null;
    }

    private BgAdjustFormDiversityData removeAdjustData(String formula, String orgUnitId) {
        orgUnitId = this.convertOrgUnitId(orgUnitId);
        if (this.adjust.getAdjustMap().containsKey(orgUnitId)) {
            return (BgAdjustFormDiversityData)((Map)this.adjust.getAdjustMap().get(orgUnitId)).remove(formula);
        }
        return null;
    }

    public void updateChangeValueInfo(Book _book) {
        if (_book == null) {
            return;
        }
        Sheet _sheet = null;
        int size = _book.getSheetCount();
        for (int index = 0; index < size; ++index) {
            _sheet = _book.getSheet(index);
            SheetChangeEvent event = new SheetChangeEvent(_sheet, (SortedCellBlockArray)_sheet.getSheetRange(), SheetChangeEvent.Changed_Content);
            this.cell_Content_Changed(event);
        }
    }

    public static Set<String> dealFromIdSet(Set<String> formIdSet) throws EASBizException, BOSException {
        Set idSet = BgAdjustFacadaFactory.getRemoteInstance().getFormId(formIdSet);
        return idSet;
    }
}

