/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.StyleAttributes;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgViewListDispalyValueProvider
extends BudgetDisplayValueProvider {
    private static final Logger logger = Logger.getLogger(MbgViewListDispalyValueProvider.class);
    private Map bgAccountDataMap = null;
    private TemplateStyleInfo templateStyle = null;

    public MbgViewListDispalyValueProvider(Component component) {
        super(component);
    }

    public Map getAccountDataTypeMap() {
        if (this.bgAccountDataMap != null) {
            return this.bgAccountDataMap;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getAccountDataTypeMap", null);
                if (method != null) {
                    this.bgAccountDataMap = (Map)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        if (this.bgAccountDataMap == null) {
            this.bgAccountDataMap = new HashMap();
        }
        return this.bgAccountDataMap;
    }

    public TemplateStyleInfo getTemplateStyle() {
        if (this.templateStyle != null) {
            return this.templateStyle;
        }
        if (this.ui != null) {
            Method method = null;
            try {
                method = this.ui.getClass().getMethod("getTemplateStyle", null);
                if (method != null) {
                    this.templateStyle = (TemplateStyleInfo)method.invoke((Object)this.ui, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return this.templateStyle;
    }

    @Override
    public Object getDisplayValue(Cell cell, int viewMode) {
        String _text = cell.getText();
        if (!StringUtils.isEmpty((String)_text)) {
            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
            if (obj instanceof ReportCalculateErrorProvider) {
                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                if ("#DIV/0!".equals(_text)) {
                    return rcep.getZeroDivDisplayAs();
                }
            } else if ("#DIV/0!".equals(_text)) {
                return "";
            }
            if (ViewListHelper.getCalculatorDataStyle(cell) != null) {
                return this.getCalcDisplayValue(cell, viewMode);
            }
            return super.getDisplayValue(cell, viewMode);
        }
        return super.getDisplayValue(cell, viewMode);
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision, String numberFormat) {
        String _text = null;
        BigDecimal _value = null;
        Format _decFormat = null;
        boolean isNegative = false;
        if (obj instanceof BigDecimal && ((BigDecimal)obj).compareTo(BigDecimal.ZERO) < 0) {
            isNegative = true;
        }
        try {
            precision = this.checkHasPercent(precision, numberFormat);
            _value = this.dealValueWithDispalyMode(obj, coefficient, precision);
            if (!isNegative && _value.compareTo(BigDecimal.ZERO) < 0) {
                isNegative = true;
            }
            if (numberFormat != null) {
                numberFormat = this.getZeroFormat(_value, isNegative, numberFormat, precision);
                _decFormat = Formats.getFormat((String)numberFormat);
                if (isNegative && !numberFormat.contains(";-") && !numberFormat.contains(";(")) {
                    _value = _value.multiply(new BigDecimal(-1));
                }
            } else {
                _decFormat = precision != 0 ? (isNegative ? Formats.getFormat((String)numberFormat) : Formats.getFormat((String)("#,##0." + BgNFSHelper.getNumberFormat("0", precision)))) : Formats.getFormat((String)"#,##0");
            }
            _text = _decFormat.format(new Variant((Object)_value), false).toString();
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        _text = this.dealUnitWithDispalyMode(_text);
        return _text;
    }

    protected String getZeroFormat(BigDecimal textValue, boolean isNegative, String numberFormat, int precision) {
        if (BigDecimal.ZERO.compareTo(textValue) != 0 || numberFormat.indexOf("%") > 0) {
            return numberFormat;
        }
        if (isNegative) {
            StringBuffer sb = new StringBuffer();
            if (numberFormat.indexOf(";(") > 0 && numberFormat.indexOf(")") > 0) {
                sb.append("(");
            }
            sb.append("0");
            if (precision > 0) {
                sb.append(".");
            }
            for (int i = 0; i < precision; ++i) {
                sb.append("0");
            }
            if (numberFormat.indexOf("(") > 0 && numberFormat.indexOf(")") > 0) {
                sb.append(")");
            }
            numberFormat = numberFormat + ";" + sb.toString();
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("0");
            if (precision > 0) {
                sb.append(".");
            }
            for (int i = 0; i < precision; ++i) {
                sb.append("0");
            }
            numberFormat = numberFormat + ";" + sb.toString();
        }
        return numberFormat;
    }

    private String getDataNumberFormate(Integer accountType, boolean isRateElement, String eleNumber) {
        String numberFormat = ViewListStyleHelper.convertStyle(this.getTemplateStyle().getDataStyleAttributes()).getNumberFormat();
        if (this.templateStyle.isDataTYpe()) {
            if (accountType == 10) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getCurrencyDecNums(), this.templateStyle.isCurrencyHasGroupSep(), isRateElement ? this.templateStyle.isCurrencyShowPercent() : false);
            } else if (accountType == 20) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getNoCurrencyNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getNoCurrencyDecNums(), this.templateStyle.isNoCurrencyGroupSep(), isRateElement ? this.templateStyle.isNoCurrencyShowPercent() : false);
            } else if (accountType == 30) {
                this.templateStyle.setDataNegativeIndex(this.templateStyle.getRateNegativeIndex());
                numberFormat = this.templateStyle.toNumberPatternNoColor(this.templateStyle.getRateDecNums(), this.templateStyle.isRateHasGroupSep(), this.templateStyle.isRateShowPercent());
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = this.templateStyle.getEleMap().get(eleNumber);
            this.templateStyle.setDataNegativeIndex((Integer)object[2]);
            numberFormat = this.templateStyle.toNumberPatternNoColor((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
        }
        return numberFormat;
    }

    @Override
    protected Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String _bgAccountNumber = null;
        String numberFormat = null;
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (cell != null && cell.getUserObject("BGACCOUNT_NUMBER") != null && cell.getUserObject("BGACCOUNT_NUMBER").getValue() != null) {
            _bgAccountNumber = String.valueOf(cell.getUserObject("BGACCOUNT_NUMBER").getValue());
            if (_bgAccountNumber != null) {
                String eleNumber = MBGViewListFormClientHelper.getCellElement(cell, this.getElementObjMap(), this.getFormulaMap());
                if (this.getTemplateStyle().isDataTYpe()) {
                    if (!MBGViewListFormClientHelper.checkElementRateOrPrice(cell, this.getElementObjMap(), this.getFormulaMap())) {
                        _coefficient = this.getCoefficent(this.getCoef(_bgAccountNumber, null));
                    }
                } else {
                    _coefficient = this.getCoefficent(this.getCoef(_bgAccountNumber, eleNumber));
                }
                Boolean isRateElement = MBGViewListFormClientHelper.checkRateElement(cell, this.getElementObjMap(), this.getFormulaMap());
                if (this.getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
                    numberFormat = this.getDataNumberFormate((Integer)this.getAccountDataTypeMap().get(_bgAccountNumber), isRateElement, eleNumber);
                    if (!this.getTemplateStyle().isDataTYpe() && eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
                        Object[] object = this.templateStyle.getEleMap().get(eleNumber);
                        this.templateStyle.setDataNegativeIndex((Integer)object[2]);
                        String nFormat = this.templateStyle.toNumberPattern((Integer)object[0], (Boolean)object[1], (Boolean)object[4]);
                        StyleAttributes style = this.templateStyle.getDataStyleAttributes();
                        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes newStyle = ViewListStyleHelper.convertStyle(style);
                        newStyle.setNumberFormat(nFormat);
                        newStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        Range range = cell.getSheet().getRange(cell);
                        MBgTemplateHelper.setRangeStyle(range, newStyle, null);
                    }
                }
            }
            if (_parameter.length == 6) {
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
        return this.getDisplayValue(obj, _coefficient, _precision, numberFormat);
    }

    @Override
    public Object getMeasureUnitDisplayValue(ICell cell, String formulaStr, Object obj, boolean useMeasureUnit, String bgAccountNumber) {
        if (cell == null || StringUtils.isEmpty((String)formulaStr) || obj == null) {
            return null;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String _numberFormat = null;
        _parameter = BgNFSHelper.parseFormulaPara(formulaStr);
        if (_parameter == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)bgAccountNumber)) {
            String eleNumber = MBGViewListFormClientHelper.getCellElement(formulaStr, this.getElementObjMap(), this.getFormulaMap());
            if (this.getTemplateStyle().isDataTYpe()) {
                if (!MBGViewListFormClientHelper.checkElementRateOrPrice(formulaStr, this.getElementObjMap(), this.getFormulaMap())) {
                    _coefficient = this.getCoefficent(this.getCoef(bgAccountNumber, null));
                }
            } else {
                _coefficient = this.getCoefficent(this.getCoef(bgAccountNumber, eleNumber));
            }
            Boolean isRateElement = MBGViewListFormClientHelper.checkRateElement(formulaStr, this.getElementObjMap(), this.getFormulaMap());
            if (this.getAccountDataTypeMap().containsKey(bgAccountNumber)) {
                _numberFormat = this.getDataNumberFormate((Integer)this.getAccountDataTypeMap().get(bgAccountNumber), isRateElement, eleNumber);
            }
        }
        if (_parameter.length == 6) {
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        } else if (_parameter.length == 4 && !StringUtils.isEmpty((String)_parameter[4]) && this.getCurrencyMap().containsKey(_parameter[4])) {
            _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[4]);
            _precision = _currencyInfo.getPrecision();
        }
        return this.getDisplayValue(obj, _coefficient, _precision, _numberFormat);
    }

    protected int checkHasPercent(int precision, String numberFormat) {
        if (!StringUtils.isEmpty((String)numberFormat) && (numberFormat.endsWith("%") || numberFormat.endsWith("%)"))) {
            precision += 2;
        }
        return precision;
    }

    public BigDecimal getCoef(String _bgAccountNumber, String eleNumber) {
        BigDecimal defaultValue = new BigDecimal((Integer)this.getMeasureUnitMap().get("currency"));
        if (this.getAccountDataTypeMap() == null || !this.getAccountDataTypeMap().containsKey(_bgAccountNumber)) {
            return defaultValue;
        }
        if (this.templateStyle.isDataTYpe()) {
            if (this.getAccountDataTypeMap().get(_bgAccountNumber) != null && this.getAccountDataTypeMap().get(_bgAccountNumber) instanceof Integer) {
                if (10 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("currency"));
                }
                if (20 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("noCurrency"));
                }
                if (30 == (Integer)this.getAccountDataTypeMap().get(_bgAccountNumber)) {
                    return new BigDecimal((Integer)this.getMeasureUnitMap().get("rate"));
                }
            }
        } else if (eleNumber != null && this.templateStyle.getEleMap().containsKey(eleNumber)) {
            Object[] object = this.templateStyle.getEleMap().get(eleNumber);
            if ((Integer)object[3] == 0) {
                return this.templateStyle.getCof();
            }
            return new BigDecimal(MBGViewListFormCommonHelper.transMeasureUnit((Integer)object[3] - 1));
        }
        return defaultValue;
    }

    protected Object getCalcDisplayValue(Cell cell, int viewMode) {
        ViewListCalculatorDataStyleInfo calcDataStyle = ViewListHelper.getCalculatorDataStyle(cell);
        Object obj = cell.getValue().getValue();
        int _precision = BgNFSHelper.getDigitOfNumber(cell, this.getPrecision());
        BigDecimal _coefficient = new BigDecimal(MBGViewListFormClientHelper.transMeasureUnit(calcDataStyle.getMeasureUnit()));
        String numberFormat = this.getCalcNumberFormate(calcDataStyle);
        return this.getDisplayValue(obj, _coefficient, _precision, numberFormat);
    }

    private String getCalcNumberFormate(ViewListCalculatorDataStyleInfo calcDataStyle) {
        if (calcDataStyle != null) {
            this.getTemplateStyle().setDataNegativeIndex(calcDataStyle.getNegativeIndex());
        }
        String numberFormat = this.getTemplateStyle().toNumberPatternNoColor(calcDataStyle.getDecNums(), calcDataStyle.isHasGroupSep(), calcDataStyle.isShowPercent());
        return numberFormat;
    }
}

