/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.MbgVirtualLoadFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.awt.event.MouseWheelEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgVirtualBookUtils {
    private static Logger logger = Logger.getLogger((String)MbgVirtualBookUtils.class.getName());
    public static final String IS_VIRTUAL_LOADED = "is_virtual_loaded";
    public static final int MAX_CELL_SIZE = 200000;
    public static boolean isVirtualLoad = false;
    public static int COUNT = 500;
    private boolean isColsed = false;
    private BgFormInfo bgFormInfo = null;
    private Map<String, Map<String, Set<String>>> bgFormulaCacheMap = new HashMap<String, Map<String, Set<String>>>();
    public volatile Map<String, Map<String, BgNViewDataInfo>> bgDataCacheMap = new HashMap<String, Map<String, BgNViewDataInfo>>();

    public boolean isColsed() {
        return this.isColsed;
    }

    public void setColsed(boolean isColsed) {
        this.isColsed = isColsed;
    }

    public static void setClose(MBGViewListFormBaseProvider provider) {
        if (provider != null && provider.getMbgVirtualBookUtils() != null) {
            provider.getMbgVirtualBookUtils().setColsed(true);
        }
    }

    public BgFormInfo getBgFormInfo() {
        return this.bgFormInfo;
    }

    public MbgVirtualBookUtils(BgFormInfo bgFormInfo) {
        this.bgFormInfo = bgFormInfo;
        if (bgFormInfo != null && bgFormInfo.getBizTemplateId() != null) {
            try {
                isVirtualLoad = MbgVirtualLoadFacadeFactory.getRemoteInstance().isVirtualLoad(bgFormInfo.getBizTemplateId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void clearBgDataCacheMap() {
        this.bgDataCacheMap.clear();
        this.bgFormulaCacheMap.clear();
    }

    public static void setCellVirtualLoaded(Cell cell) {
        if (cell != null) {
            cell.setUserObject(IS_VIRTUAL_LOADED, (Object)Boolean.TRUE);
        }
    }

    public static void clearCellVirtualLoaded(Cell cell) {
        if (cell != null) {
            cell.removeUserObject(IS_VIRTUAL_LOADED);
        }
    }

    public static boolean isCellVirtualLoaded(Cell cell) {
        boolean isLoaded = false;
        if (cell != null && BgNFSHelper.getUserObject(cell, IS_VIRTUAL_LOADED) != null) {
            isLoaded = (Boolean)BgNFSHelper.getUserObject(cell, IS_VIRTUAL_LOADED);
        }
        return isLoaded;
    }

    public static void setRowVirtualLoaded(Row row) {
        if (row != null) {
            row.setUserObject(IS_VIRTUAL_LOADED, (Object)Boolean.TRUE);
        }
    }

    public static boolean isRowVirtualLoaded(Row row) {
        boolean isLoaded = false;
        if (row != null && row.getUserObjectValue(IS_VIRTUAL_LOADED) != null) {
            isLoaded = (Boolean)row.getUserObjectValue(IS_VIRTUAL_LOADED);
        }
        return isLoaded;
    }

    public static void clearRowVirtualLoaded(Row row) {
        if (row != null) {
            row.removeUserObject(IS_VIRTUAL_LOADED);
        }
    }

    public static void clearRowVirtualLoaded(Book book) {
        if (book != null) {
            int sheetSize = book.getSheetCount();
            Sheet sheet = null;
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                sheet = book.getSheet(sheetIndex);
                for (int r = 0; r < sheet.getMaxRowIndex(); ++r) {
                    if (sheet.getRow(r, false) == null) continue;
                    MbgVirtualBookUtils.clearRowVirtualLoaded(sheet.getRow(r, false));
                }
            }
        }
    }

    public static boolean checkBookCellSize(SpreadView theview) {
        boolean isOverSize = false;
        if (theview != null) {
            SpreadView view = theview.getSpread().getActiveView();
            Book book = view.getSpread().getBook();
            isOverSize = MbgVirtualBookUtils.checkBookCellSize(book);
        }
        return isOverSize;
    }

    public static boolean checkBookCellSize(Book book) {
        boolean isOverSize = false;
        if (book != null) {
            int sheetSize = book.getSheetCount();
            int sheetIndex = 0;
            int rowCount = 0;
            int colCount = 0;
            int cellSize = 0;
            sheetSize = book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                rowCount = book.getSheet(sheetIndex).getMaxRowIndex();
                colCount = book.getSheet(sheetIndex).getMaxColIndex();
                cellSize += rowCount * colCount;
            }
            if (cellSize >= 200000) {
                isOverSize = true;
            }
        }
        return isOverSize;
    }

    public void loadFirstData(SpreadView spreadView) throws EASBizException, BOSException {
        this.loadData(spreadView);
    }

    public void loadData(SpreadView theview) throws EASBizException, BOSException {
        SpreadView view = theview.getSpread().getActiveView();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int firstRow = view.getFirstRow();
        int endRow = view.getEndRow();
        if (endRow <= 0) {
            endRow = firstRow + 100;
        }
        this.loadData(view, firstRow, endRow);
        view.repaint();
    }

    public void loadData(SpreadView theview, int firstRow, int endRow) throws EASBizException, BOSException {
        SpreadView view = theview.getSpread().getActiveView();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        this.loadData(sheet, firstRow, endRow);
    }

    public void loadData(Sheet sheet, int firstRow, int endRow) throws EASBizException, BOSException {
        if (sheet == null) {
            return;
        }
        if (endRow <= 0) {
            endRow = firstRow + 100;
        }
        int maxColIndex = sheet.getMaxColIndex();
        Map bgDataMap = null;
        ItemFormula itemFormula = null;
        String formula = null;
        String version = null;
        String cellOrgId = null;
        String dimKey = null;
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> bgVersionNums = new HashSet<String>();
        HashSet<String> formulas = new HashSet<String>();
        Cell cell = null;
        Row row = null;
        int addRow = 6;
        for (int r = firstRow; r <= endRow + addRow; ++r) {
            row = sheet.getRow(r, false);
            if (MbgVirtualBookUtils.isRowVirtualLoaded(row)) continue;
            for (int c = 0; c <= maxColIndex; ++c) {
                cell = sheet.getCell(r, c, false);
                if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || (itemFormula = BgNFSHelper.getItemFormula(cell)) == null) continue;
                cellOrgId = itemFormula.getExt("ORGUNITID");
                version = itemFormula.getExt("Version");
                formula = itemFormula.getFormula();
                dimKey = formula + "_" + version;
                if (StringUtils.isEmpty((String)cellOrgId) || StringUtils.isEmpty((String)version) || StringUtils.isEmpty((String)formula)) continue;
                if (!this.bgFormulaCacheMap.containsKey(cellOrgId)) {
                    this.bgFormulaCacheMap.put(cellOrgId, new HashMap());
                }
                if (!this.bgFormulaCacheMap.get(cellOrgId).containsKey(version)) {
                    this.bgFormulaCacheMap.get(cellOrgId).put(version, new HashSet());
                }
                if (this.bgFormulaCacheMap.get(cellOrgId).get(version).contains(formula)) continue;
                this.bgFormulaCacheMap.get(cellOrgId).get(version).add(formula);
                if (this.bgDataCacheMap.containsKey(cellOrgId) && this.bgDataCacheMap.get(cellOrgId).containsKey(dimKey)) continue;
                orgIds.add(cellOrgId);
                bgVersionNums.add(version);
                formulas.add(formula);
            }
        }
        if (!(orgIds.isEmpty() || bgVersionNums.isEmpty() || formulas.isEmpty())) {
            logger.info((Object)("\u8868\u9875\uff1a" + sheet.getSheetName() + "; \u5f00\u59cb\u884c: " + firstRow + "; \u7ed3\u675f\u884c\uff1a " + endRow));
            logger.info((Object)("orgIds size: " + orgIds.size() + "; bgVersionNums size\uff1a " + bgVersionNums.size() + "; formulas size: " + formulas.size()));
            long ct1 = System.currentTimeMillis();
            MbgViewManagerImpl viewManager = DimensionFormulaHelper.buildViewMamager(null, formulas, bgVersionNums);
            logger.info((Object)("\u751f\u6210\u7ef4\u5ea6\u7ba1\u7406\u5668: " + (System.currentTimeMillis() - ct1) + "ms"));
            long ct2 = System.currentTimeMillis();
            bgDataMap = BgFormFactory.getRemoteInstance().getBgDataInfo(this.getBgFormInfo(), null, viewManager);
            logger.info((Object)("\u67e5\u8be2\u6570\u636e\u8017\u65f6: " + (System.currentTimeMillis() - ct1) + "ms"));
            if (bgDataMap != null && !bgDataMap.isEmpty()) {
                MultiThreadQuery.mergeData(this.bgDataCacheMap, bgDataMap);
            }
        }
    }

    public void doMouseWheelMoved(IContextManager contextManager, MouseWheelEvent e) throws EASBizException, BOSException {
        if (contextManager == null || e == null) {
            return;
        }
        if (!isVirtualLoad) {
            return;
        }
        if (!MbgVirtualBookUtils.checkVirtualOwner((CoreUIObject)contextManager.getOwnerUI())) {
            return;
        }
        if (contextManager.getProvider() instanceof MBGViewListFormBaseProvider && !((MBGViewListFormBaseProvider)contextManager.getProvider()).isFirstVirtualLoad()) {
            return;
        }
        long ct = System.currentTimeMillis();
        SpreadView theview = (SpreadView)e.getSource();
        this.loadData(theview);
        logger.info((Object)("doMouseWheelMoved: " + (System.currentTimeMillis() - ct) + "ms"));
    }

    public static boolean checkVirtualOwner(CoreUIObject owner) {
        boolean virtualOwner = false;
        if (owner.getClass().getName().indexOf("MbgViewListFormProcessUI") >= 0) {
            virtualOwner = true;
        }
        return virtualOwner;
    }

    public static void showMessage(CoreUIObject owner, String msg) {
        if (owner != null && !StringUtils.isEmpty((String)msg) && owner instanceof BgSpreadCoreViewUI) {
            ((BgSpreadCoreViewUI)owner).setMessageIcon(BgSpreadCoreViewUI.SHOW_MESSAGE_ICON_OK);
            ((BgSpreadCoreViewUI)owner).setMessageBgcolor(BgSpreadCoreViewUI.SHOW_MESSAGE_BG_OK);
            ((BgSpreadCoreViewUI)owner).setMessageText(msg);
            ((BgSpreadCoreViewUI)owner).showMessage();
        }
    }
}

