/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.DimBaseBiz;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DimBackBiz
extends DimBaseBiz {
    private static final Logger logger = Logger.getLogger(DimBackBiz.class);

    public DimBackBiz(BizMbgDataControlUtils utils) {
        super(utils);
    }

    public void back(Context ctx, List<String> billIds, Map<String, String> auditParams, Map<String, Object> result, AuditParam param) throws BOSException, EASBizException {
        logger.debug((Object)"begin back BgForm !");
        this.process(ctx, billIds, auditParams, param, result);
        logger.debug((Object)"end back BgForm !");
    }

    @Override
    protected void process(Context ctx, List<String> billIds, Map<String, String> auditParams, AuditParam param, Map<String, Object> result) throws BOSException, EASBizException {
        super.process(ctx, billIds, auditParams, param, result);
    }

    @Override
    protected boolean isSetAudit() {
        return false;
    }

    @Override
    protected boolean isCheckParentNoEdit() {
        return true;
    }

    @Override
    protected boolean checkAllData(Context ctx, Connection conn, IDimDataQuery model, List<IDimDataQuery> models, List<String> cOrgUnitIds, List<String> pOrgUnitIds, AuditParam param, Map<String, Object> result, boolean isOnlyDealCurBgForm) throws Exception {
        boolean isParentNoEdit = false;
        if (ctx == null || conn == null || model == null || models == null || cOrgUnitIds == null || pOrgUnitIds == null || param == null || result == null) {
            return false;
        }
        BgOrgUnitInfo bgOrgUnitInfo = null;
        bgOrgUnitInfo = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgScheme.getEditOrgViewId(), model.getBizOrgUnit().getId());
        if (model instanceof BgFormInfo) {
            ((BgFormInfo)model).setOrgUnit(bgOrgUnitInfo.castToFullOrgUnitInfo());
        }
        isParentNoEdit = isParentNoEdit || DimBackBiz.checkParentNoEdit(model, param, result);
        return !isParentNoEdit;
    }

    @Override
    protected void updateBaseData(Context ctx, Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (ctx == null || conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        boolean isDetail = model.getId().toString().equals(param.currtBillId);
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        int[] dataStates = this.getDataStates(param);
        String billId = model.getId().toString();
        String orgUnitId = model.getBizOrgUnit().getId().toString();
        int versionId = model.getBizVersion().getVersionId();
        boolean isDecompose = DimensionCommonHelper.isDecompose(model.getProcessType());
        try {
            for (String cubeName : param.cubes) {
                sql.setLength(0);
                if (isDetail) {
                    sql.append("update " + cubeName + " set FState = ?, FDetail = ?  where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")  and FVersion = ? ");
                    if (!isDecompose) {
                        sql.append(" and FDetail = 1");
                    }
                    sqlParams = new Object[]{param.audState, 0, param.getAccIntHelper().convertOrgObject(orgUnitId), billId, versionId};
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                    continue;
                }
                sql.append("update " + cubeName + " set FState = ?, FDetail = ?  where FOrgUnitId = ? and exists (select FDataId from " + param.cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)  and FState IN " + this.getSqlStates(dataStates) + " and FScenario IN (select FScenarioId from T_MBG_BgScenario where FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE + ")  and FVersion = ? ");
                if (!isDecompose) {
                    sql.append(" and FDetail = 0");
                }
                sqlParams = new Object[]{param.audState, 0, param.getAccIntHelper().convertOrgObject(orgUnitId), billId, versionId};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void updateViewData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return;
        }
        boolean isDetail = model.getId().toString().equals(param.currtBillId) && model.getBizOrgUnit().getId().toString().equals(bgOrgUnit.getOrgUnitID());
        int[] dataStates = this.getDataStates(param);
        String orgUnitId = bgOrgUnit.getOrgUnitID();
        int versionId = model.getBizVersion().getVersionId();
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        boolean isDecompose = DimensionCommonHelper.isDecompose(model.getProcessType());
        try {
            for (String cubeName : param.cubes) {
                Map.Entry<String, String> entry2;
                String field;
                String tmpTable;
                String mbgDimNum;
                sql.setLength(0);
                if (isDetail) {
                    sql.append("update " + cubeName + " set FState = ?, FDetail = ?  where FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cubeName + ".F2) ");
                    if (!param.getTmpExtMap().isEmpty()) {
                        mbgDimNum = null;
                        tmpTable = null;
                        field = null;
                        entry2 = null;
                        for (Map.Entry<String, String> entry2 : param.getTmpExtMap().entrySet()) {
                            mbgDimNum = entry2.getKey();
                            tmpTable = entry2.getValue();
                            field = param.mbgDims.get(mbgDimNum).getRefField();
                            sql.append(" and exists (select FID from " + tmpTable + " where " + param.getField("FNumber") + " = " + cubeName + "." + field + ") ");
                        }
                    }
                    sql.append(" and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cubeName + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cubeName + ".FScenario)  and FVersion = ?  and FState IN " + this.getSqlStates(dataStates));
                    if (!isDecompose) {
                        sql.append(" and FDetail = 1");
                    }
                    sqlParams = new Object[]{param.audState, 0, param.getAccIntHelper().convertOrgObject(orgUnitId), versionId};
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
                    continue;
                }
                sql.append("update " + cubeName + " set FState = ?, FDetail = ?  where FOrgUnitId = ?  and exists (select FNumber from " + param.getTmpBgIndex() + " where " + param.getField("FNumber") + " = " + cubeName + ".F2) ");
                if (!param.getTmpExtMap().isEmpty()) {
                    mbgDimNum = null;
                    tmpTable = null;
                    field = null;
                    entry2 = null;
                    for (Map.Entry<String, String> entry2 : param.getTmpExtMap().entrySet()) {
                        mbgDimNum = entry2.getKey();
                        tmpTable = entry2.getValue();
                        field = param.mbgDims.get(mbgDimNum).getRefField();
                        sql.append(" and exists (select FID from " + tmpTable + " where " + param.getField("FNumber") + " = " + cubeName + "." + field + ") ");
                    }
                }
                sql.append(" and exists (select FID from " + param.getTmpBgPeriod() + " where " + param.getField("FID") + " = " + cubeName + ".FBgPeriodID)  and exists (select FID from " + param.getTmpBgElement() + " where " + param.getField("FID") + " = " + cubeName + ".FBgElementID)  and exists (select FID from " + param.getTmpCurrency() + " where FID = " + cubeName + ".FCurrencyID)  and exists (select FID from " + param.getTmpScenario() + " where FID = " + cubeName + ".FScenario)  and FVersion = ?  and FState IN " + this.getSqlStates(dataStates));
                if (!isDecompose) {
                    sql.append(" and FDetail = 0 ");
                }
                sqlParams = new Object[]{param.audState, 0, param.getAccIntHelper().convertOrgObject(orgUnitId), versionId};
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    @Override
    protected void updateFormData(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        if (conn == null || model == null || bgOrgUnit == null || param == null) {
            return;
        }
        if (param.currtBillId.equals(model.getId().toString())) {
            super.updateFormData(conn, model, bgOrgUnit, param);
        }
    }

    @Override
    protected void succeed(IDimDataQuery model, AuditParam param, Map<String, Object> result) throws Exception {
        if (model == null || param == null || result == null) {
            return;
        }
        if (param.currtBillId.equals(model.getId().toString())) {
            super.succeed(model, param, result);
        }
    }

    @Override
    protected void updateAuditRecord(Context ctx, Connection conn, Locale locale, IDimDataQuery model, Map<String, String> auditParams, AuditParam param) throws Exception {
    }

    @Override
    protected String getLogItemName(AuditParam param) {
        return "mbg_bgForm_back";
    }
}

