/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.orgunit;

import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BgTreeView
extends KDTreeView {
    private static final long serialVersionUID = -2503685756909814388L;
    private Map<String, ActionListener> actionMap = new HashMap<String, ActionListener>();

    public void registerExpandListener(ActionListener listener) {
        if (listener != null && !this.actionMap.containsKey("expand")) {
            this.actionMap.put("expand", listener);
        }
    }

    public void registerExpandAllListener(ActionListener listener) {
        if (listener != null && !this.actionMap.containsKey("expandAll")) {
            this.actionMap.put("expandAll", listener);
        }
    }

    public void registerExpandLevelListener(ActionListener listener) {
        if (listener != null && !this.actionMap.containsKey("expandLevel")) {
            this.actionMap.put("expandLevel", listener);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        TreeNode root = (TreeNode)this.getTree().getModel().getRoot();
        if (cmd.equals(BgNFSHelper.getHardCodeRes("expandAll"))) {
            if (this.actionMap.containsKey("expandAll")) {
                this.actionMap.get("expandAll").actionPerformed(e);
            }
            this.getTree().expandAllNodes(true, root);
        } else if (cmd.equals(BgNFSHelper.getHardCodeRes("expand"))) {
            TreePath path = this.getTree().getSelectionPath();
            if (path != null) {
                if (this.actionMap.containsKey("expand")) {
                    this.actionMap.get("expand").actionPerformed(e);
                }
                this.getTree().expandPath(path);
            }
        } else if (cmd.equals(BgNFSHelper.getHardCodeRes("collapse"))) {
            TreePath path = this.getTree().getSelectionPath();
            if (path != null) {
                this.getTree().collapsePath(path);
            }
        } else if (cmd.equals(BgNFSHelper.getHardCodeRes("expandAllNodes"))) {
            TreePath path = this.getTree().getSelectionPath();
            if (path != null) {
                if (this.actionMap.containsKey("expandAll")) {
                    this.actionMap.get("expandAll").actionPerformed(e);
                }
                TreeNode node = (TreeNode)path.getLastPathComponent();
                this.getTree().expandAllNodes(true, node);
            }
        } else if (cmd.equals(BgNFSHelper.getHardCodeRes("collapseAll"))) {
            this.getTree().expandAllNodes(false, root);
        } else if (cmd.endsWith(BgNFSHelper.getHardCodeRes("expandLevel"))) {
            int level = Integer.parseInt(cmd.substring(0, cmd.indexOf(BgNFSHelper.getHardCodeRes("expandLevel"))));
            if (this.actionMap.containsKey("expandLevel")) {
                this.actionMap.get("expandLevel").actionPerformed(e);
            }
            this.getTree().expandOnLevel(level);
            if (level < this.getMaxExpandLevelForButton()) {
                this.setShowLevelExpandButton(level + 1);
            }
        }
        this.getTree().requestFocus();
    }
}

