/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.orgunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.utils.orgunit.BgTreeView;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgUnitBaseUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.tree.TreeModel;

public class CsOrgUnitTreeUtils
extends OrgUnitBaseUtils {
    private BgTreeView csTreeView = null;

    public BgTreeView getCsTreeView() {
        return this.csTreeView;
    }

    @Override
    protected boolean isRootCanntCollapse() {
        return false;
    }

    public CsOrgUnitTreeUtils(Component component, BgTreeView treeView, KDTree tree) {
        super(component, tree, OrgType.CostCenter);
        this.csTreeView = treeView;
    }

    public void buildCsTeee(String orgUnitId, boolean isSealUp) throws BOSException, EASBizException {
        String _orgUnitId = orgUnitId;
        if (StringUtils.isEmpty((String)_orgUnitId)) {
            _orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        }
        TreeModel treeModel = this.builderTreeModel(BOSUuid.read((String)_orgUnitId), isSealUp, false);
        this.setTreeModel(treeModel);
        this.getKdTree().setModel(treeModel);
        this.getKdTree().updateUI();
        this.registerListener();
    }

    public void rebuildCsTeee(boolean isSealUp, boolean isShowNumber) {
        this.setSealUp(isSealUp);
        this.setShowNumber(isShowNumber);
        this.clearNodeRef();
        TreeModel treeModel = this.builderTreeModel();
        this.setTreeModel(treeModel);
        this.getKdTree().setModel(treeModel);
        this.getKdTree().updateUI();
        this.registerListener();
    }

    protected void registerListener() {
        if (this.isAsyncLoad() && this.csTreeView != null) {
            this.csTreeView.registerExpandAllListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CsOrgUnitTreeUtils.this.loadTree(CsOrgUnitTreeUtils.this.getKdTree(), -1);
                }
            });
            this.csTreeView.registerExpandListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)CsOrgUnitTreeUtils.this.getKdTree().getSelectionPath().getLastPathComponent();
                }
            });
            this.csTreeView.registerExpandLevelListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd = e.getActionCommand();
                    int level = Integer.parseInt(cmd.substring(0, cmd.indexOf(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgBaseResource", (String)"expandLevelN"))));
                    if (level > 0) {
                        CsOrgUnitTreeUtils.this.loadTree(CsOrgUnitTreeUtils.this.getKdTree(), level);
                    }
                }
            });
        }
    }

    protected void loadTree(KDTree tree, int level) {
    }

    public void selectOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean selected, Set<String> ids) {
        if (root == null) {
            return;
        }
        if (selOrgUnitIds == null) {
            if (this.notContainsBgOrg(ids, root)) {
                this.selectCurrOrgUnit(root, selected);
            }
        } else if (selOrgUnitIds.contains(this.getId(root))) {
            this.selectCurrOrgUnit(root, selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node == null) continue;
            this.selectOrgUnit(node, selOrgUnitIds, selected, ids);
        }
    }

    private boolean notContainsBgOrg(Set<String> ids, DefaultKingdeeTreeNode node) {
        return !ids.contains(this.getOrgUnit(node).getId().toString());
    }
}

