/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.utils.orgunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.mbg.BgOrgUnitFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnitFacade;
import com.kingdee.eas.ma.mbg.utils.orgunit.AllOrgMenuListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.DirectSubOrgMenuListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.FinmenuOrgMenuListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.IOrgCheckListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.NotAddOrgMenuListener;
import com.kingdee.eas.ma.mbg.utils.orgunit.OrgTreeEvent;
import com.kingdee.eas.ma.mbg.utils.orgunit.TreePopupMenuListener;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class OrgUnitBaseUtils {
    private static final Logger logger = Logger.getLogger(OrgUnitBaseUtils.class);
    public static final int INDEX_ID = 0;
    public static final int INDEX_NAME = 1;
    public static final int INDEX_NUMBER = 2;
    public static final int INDEX_LONGNUMBER = 3;
    public static final int INDEX_LEVEL = 4;
    public static final int INDEX_ISLEAF = 5;
    public static final int INDEX_ISOUSEALUP = 6;
    public static final int INDEX_PARENT = 7;
    public static final int INDEX_SIMPLENAME = 8;
    public static final int INDEX_CODE = 9;
    public static final int INDEX_DESCRIPTION = 10;
    public static final int INDEX_ISVIRTAUL = 11;
    public static final int INDEX_ORGUNITID = 12;
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_LONGNUMBER = "longNumber";
    public static final String FIELD_LEVEL = "level";
    public static final String FIELD_ISLEAF = "isLeaf";
    public static final String FIELD_ISOUSEALUP = "isOUSealUp";
    public static final String FIELD_PARENTID = "parentId";
    public static final String FIELD_ISVIRTAUL = "isVirtual";
    public static final String FIELD_ORGUNITID = "orgUnitId";
    public static final String FIELD_SIMPLENAME = "simpleName";
    public static final String FIELD_CODE = "code";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgOrgUnitReource";
    private Component component = null;
    private KDTree kdTree = null;
    private TreeModel treeModel = null;
    private KDPopupMenu popMenu = null;
    private OrgType orgType = null;
    private boolean isSealUp = false;
    private boolean isShowNumber = false;
    private boolean isAsyncLoad = false;
    private boolean hasVirtualRoot = false;
    private boolean showPopMenu = true;
    private MouseListener mouseListener = null;
    private boolean isLoadAllOrgUnit = false;
    public static final int LOAD_LEVEL = 3;
    private Map<String, DefaultKingdeeTreeNode> orgNodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
    private IOrgCheckListener orgCheckListener = null;
    private String oldSearchTxt = null;
    private String createOrgId = null;
    private TreeWillExpandListener listener = null;
    private LongTimeDialog dialog = null;
    private Set<String> companyIds = null;

    protected void setComponent(Component component) {
        this.component = component;
    }

    protected Component getComponent() {
        return this.component;
    }

    public void setKdTree(KDTree kdTree) {
        this.kdTree = kdTree;
    }

    public KDTree getKdTree() {
        return this.kdTree;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setPopMenu(KDPopupMenu popMenu) {
        this.popMenu = popMenu;
    }

    public KDPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public OrgType getOrgType() {
        if (this.orgType == null) {
            this.orgType = OrgType.CostCenter;
        }
        return this.orgType;
    }

    public void setSealUp(boolean isSealUp) {
        this.isSealUp = isSealUp;
    }

    public boolean isSealUp() {
        return this.isSealUp;
    }

    public boolean isShowNumber() {
        return this.isShowNumber;
    }

    public void setShowNumber(boolean isShowNumber) {
        this.isShowNumber = isShowNumber;
    }

    public void setAsyncLoad(boolean isAsyncLoad) {
        this.isAsyncLoad = isAsyncLoad;
    }

    public boolean isAsyncLoad() {
        return this.isAsyncLoad;
    }

    public void setHasVirtualRoot(boolean hasVirtualRoot) {
        this.hasVirtualRoot = hasVirtualRoot;
    }

    public boolean isHasVirtualRoot() {
        return this.hasVirtualRoot;
    }

    protected boolean isRootCanntCollapse() {
        return true;
    }

    public void setShowPopMenu(boolean showPopMenu) {
        this.showPopMenu = showPopMenu;
        if (this.isShowPopMenu()) {
            this.getKdTree().addMouseListener(this.mouseListener);
        } else {
            this.getKdTree().removeMouseListener(this.mouseListener);
        }
    }

    public boolean isShowPopMenu() {
        return this.showPopMenu;
    }

    public Map<String, DefaultKingdeeTreeNode> getOrgNodeMap() {
        return this.orgNodeMap;
    }

    public void setOrgCheckListener(IOrgCheckListener orgCheckListener) {
        this.orgCheckListener = orgCheckListener;
    }

    public IOrgCheckListener getOrgCheckListener() {
        return this.orgCheckListener;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public String getCreateOrgId() {
        return this.createOrgId;
    }

    public OrgUnitBaseUtils(Component component, KDTree kdTree, OrgType orgType) {
        this(component, kdTree, orgType, true);
    }

    public OrgUnitBaseUtils(Component component, KDTree kdTree, OrgType orgType, boolean isAsyncLoad) {
        this.setComponent(component);
        this.setKdTree(kdTree);
        this.setOrgType(orgType);
        this.setAsyncLoad(isAsyncLoad);
        this.listener = new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
                try {
                    OrgUnitBaseUtils.this.addChildNode(node);
                }
                catch (Exception ex) {
                    logger.error((Object)"addChildNode error:", (Throwable)ex);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                KDTree tree = (KDTree)e.getSource();
                TreePath path = e.getPath();
                if (tree.getModel().getRoot() == path.getLastPathComponent()) {
                    throw new ExpandVetoException(e);
                }
            }
        };
        if (this.isRootCanntCollapse()) {
            this.getKdTree().addTreeWillExpandListener(this.listener);
        }
        if (this.mouseListener == null && this.getKdTree().isShowCheckBox()) {
            this.popMenu = new KDPopupMenu();
            KDMenuItem menu = new KDMenuItem();
            menu.setText(EASResource.getString((String)RESOURCE, (String)"selectSon"));
            menu.addActionListener((ActionListener)new DirectSubOrgMenuListener(this));
            this.popMenu.add((JMenuItem)menu);
            menu = new KDMenuItem();
            menu.setText(EASResource.getString((String)RESOURCE, (String)"selectAllSubOrgUnit"));
            menu.addActionListener((ActionListener)new AllOrgMenuListener(this));
            this.popMenu.add((JMenuItem)menu);
            menu = new KDMenuItem();
            menu.setText(EASResource.getString((String)RESOURCE, (String)"finOrg"));
            menu.addActionListener((ActionListener)new FinmenuOrgMenuListener(this));
            this.popMenu.add((JMenuItem)menu);
            menu = new KDMenuItem();
            menu.setText(EASResource.getString((String)RESOURCE, (String)"notAddOrg"));
            menu.addActionListener((ActionListener)new NotAddOrgMenuListener(this));
            this.popMenu.add((JMenuItem)menu);
            this.mouseListener = new TreePopupMenuListener(this.getKdTree(), this.popMenu);
        }
        this.getKdTree().addMouseListener(this.mouseListener);
    }

    protected IBgOrgUnitFacade getBizInterface() throws BOSException {
        return BgOrgUnitFacadeFactory.getRemoteInstance();
    }

    protected void clearNodeRef() {
        DefaultKingdeeTreeNode node2 = null;
        for (DefaultKingdeeTreeNode node2 : this.getOrgNodeMap().values()) {
            node2.removeAllChildren();
        }
    }

    protected TreeModel builderTreeModel(BOSUuid uuid, boolean isSealUp, boolean isShowNumber) throws BOSException, EASBizException {
        this.setSealUp(isSealUp);
        this.setShowNumber(isShowNumber);
        if (!this.isLoadAllOrgUnit) {
            List<Object[]> orgUnits = null;
            if (this.isAsyncLoad) {
                orgUnits = this.queryFirstOrgUnits(uuid);
                this.queryNextOrgUnits(uuid);
            } else {
                orgUnits = this.queryFullOrgUnits(uuid);
                this.isLoadAllOrgUnit = true;
            }
            this.transOrgUnit(orgUnits);
        }
        return this.builderTreeModel();
    }

    protected List<Object[]> queryFirstOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
        if (uuid == null) {
            return new ArrayList<Object[]>();
        }
        return this.getBizInterface().getFirstOrgUnits(uuid, this.getOrgType());
    }

    protected void queryNextOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
        if (uuid == null) {
            return;
        }
        LoadOrgUnitSwingWorker worker = new LoadOrgUnitSwingWorker(uuid);
        worker.start();
    }

    protected List<Object[]> queryFullOrgUnits(BOSUuid uuid) throws BOSException, EASBizException {
        if (uuid == null) {
            return new ArrayList<Object[]>();
        }
        return this.getBizInterface().getOrgUnits(uuid, this.getOrgType());
    }

    protected String getOrgUnitId(IObjectValue obj) {
        if (obj instanceof BgOrgUnitInfo) {
            return ((BgOrgUnitInfo)obj).getOrgUnitID();
        }
        if (obj.get("orgunitid") instanceof String) {
            return (String)obj.get("orgunitid");
        }
        return String.valueOf(obj.get("id"));
    }

    protected TreeModel builderTreeModel() {
        TreeModel model = null;
        if (this.getOrgNodeMap().isEmpty()) {
            model = this.getModel(this.getRoot());
            return model;
        }
        FullOrgUnitInfo orgUnit = null;
        DefaultKingdeeTreeNode parent = null;
        DefaultKingdeeTreeNode root = null;
        if (this.isHasVirtualRoot()) {
            root = this.getRoot();
        }
        ArrayList<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
        if (this.getOrgNodeMap() != null && !this.getOrgNodeMap().isEmpty()) {
            nodes.addAll(this.getOrgNodeMap().values());
        }
        Collections.sort(nodes, new Comparator<DefaultKingdeeTreeNode>(){

            @Override
            public int compare(DefaultKingdeeTreeNode n1, DefaultKingdeeTreeNode n2) {
                FullOrgUnitInfo o1 = OrgUnitBaseUtils.this.getOrgUnit(n1);
                FullOrgUnitInfo o2 = OrgUnitBaseUtils.this.getOrgUnit(n2);
                String oid1 = OrgUnitBaseUtils.this.getOrgUnitId((IObjectValue)o1);
                String oid2 = OrgUnitBaseUtils.this.getOrgUnitId((IObjectValue)o2);
                int re = o1.getInt(OrgUnitBaseUtils.FIELD_ISVIRTAUL) - o2.getInt(OrgUnitBaseUtils.FIELD_ISVIRTAUL);
                if (re == 0) {
                    if (OrgUnitBaseUtils.this.createOrgId != null) {
                        if (OrgUnitBaseUtils.this.createOrgId.equals(oid1)) {
                            return -1;
                        }
                        if (OrgUnitBaseUtils.this.createOrgId.equals(oid2)) {
                            return 1;
                        }
                    }
                    re = o1.getString(OrgUnitBaseUtils.FIELD_LONGNUMBER).compareTo(o2.getString(OrgUnitBaseUtils.FIELD_LONGNUMBER));
                }
                return re;
            }
        });
        for (DefaultKingdeeTreeNode node : nodes) {
            orgUnit = this.getOrgUnit(node);
            OrgStructureInfo orginfo = (OrgStructureInfo)node.getUserObject();
            if (node.getText().indexOf(orginfo.getUnit().getNumber() + "_") != -1) {
                node.setText(node.getText().substring(node.getText().indexOf(orginfo.getUnit().getNumber() + "_") + orginfo.getUnit().getNumber().length() + 1, node.getText().length()));
            }
            if (this.isShowNumber()) {
                node.setText(orginfo.getUnit().getNumber() + "_" + node.getText());
            }
            if (root == null) {
                root = node;
            }
            if (!this.isSealUp() && this.checkIsOUSealUp((IObjectValue)orgUnit)) continue;
            if (orgUnit.get(FIELD_PARENTID) != null) {
                parent = this.getOrgNodeMap().get(orgUnit.get(FIELD_PARENTID));
                if (parent == null) continue;
                this.checkNullNode(parent);
                parent.add((MutableTreeNode)node);
                continue;
            }
            if (!this.isHasVirtualRoot() || root == null) continue;
            root.add((MutableTreeNode)node);
        }
        model = this.getModel(root);
        return model;
    }

    protected TreeModel getModel(DefaultKingdeeTreeNode root) {
        return new DefaultTreeModel((TreeNode)root);
    }

    protected DefaultKingdeeTreeNode getRoot() {
        return new DefaultKingdeeTreeNode();
    }

    protected boolean checkIsOUSealUp(IObjectValue value) {
        if (value instanceof OrgUnitInfo) {
            return value.getBoolean(FIELD_ISOUSEALUP);
        }
        return false;
    }

    protected boolean checkIsLeaf(IObjectValue value) {
        if (value instanceof OrgUnitInfo) {
            return value.getBoolean(FIELD_ISLEAF);
        }
        return false;
    }

    protected boolean checkIsRoot(DefaultKingdeeTreeNode node) {
        return node == null || node.getUserObject() == null;
    }

    protected boolean checkNullNode(DefaultKingdeeTreeNode parent) {
        boolean check = false;
        if (parent.getChildCount() == 1 && ((DefaultKingdeeTreeNode)parent.getChildAt(0)).getUserObject() == null) {
            check = true;
            parent.removeAllChildren();
        }
        return check;
    }

    protected void transOrgUnit(List<Object[]> orgUnits) {
        if (orgUnits == null || orgUnits.isEmpty()) {
            return;
        }
        Object[] obj = null;
        IObjectValue orgUnit = null;
        DefaultKingdeeTreeNode node = null;
        int in = orgUnits.size();
        for (int i = 0; i < in; ++i) {
            obj = orgUnits.get(i);
            orgUnit = this.getOrgUnit(obj);
            node = this.getOrgUnitNode(orgUnit);
            this.addNodeData(node, orgUnit);
        }
    }

    protected void syncTree(List<Object[]> orgUnits) throws Exception {
        if (orgUnits == null || orgUnits.isEmpty()) {
            return;
        }
        IObjectValue orgUnit = null;
        DefaultKingdeeTreeNode parent = null;
        int in = orgUnits.size();
        for (int i = 0; i < in; ++i) {
            orgUnit = this.getOrgUnit(orgUnits.get(i));
            parent = this.getOrgNodeMap().get(orgUnit.get(FIELD_PARENTID));
            if (parent == null) continue;
            this.addNode(parent, orgUnit);
        }
    }

    public synchronized DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, IObjectValue orgUnit) throws Exception {
        return this.addNode(parent, orgUnit, null, false);
    }

    public synchronized DefaultKingdeeTreeNode addNode(DefaultKingdeeTreeNode parent, IObjectValue orgUnit, StringBuilder errMsg, boolean isAddByStructCostCenter) throws Exception {
        if (parent == null || orgUnit == null) {
            return null;
        }
        this.checkNullNode(parent);
        DefaultKingdeeTreeNode node = this.getOrgUnitNode(orgUnit);
        if (!this.isSealUp() && this.checkIsOUSealUp(orgUnit)) {
            return null;
        }
        if (this.getOrgCheckListener() != null) {
            OrgTreeEvent e = new OrgTreeEvent(this.getKdTree());
            e.setParent(parent);
            e.setNode(node);
            e.setErrMsg(errMsg);
            e.setAddByStructCostCenter(isAddByStructCostCenter);
            if (isAddByStructCostCenter & !this.getOrgCheckListener().treeNodesInsertCheck(e)) {
                return null;
            }
        }
        this.addNodeData(node, orgUnit);
        ((DefaultTreeModel)this.getKdTree().getModel()).insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, parent.getChildCount());
        return node;
    }

    protected void addNodeData(DefaultKingdeeTreeNode node, IObjectValue orgUnit) {
        if (node == null || orgUnit == null) {
            return;
        }
        this.getOrgNodeMap().put(this.getId(orgUnit), node);
    }

    public void removeNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.removeNode(node);
        }
        if (this.getOrgCheckListener() != null) {
            OrgTreeEvent e = new OrgTreeEvent(this.getKdTree());
            e.setNode(root);
            this.getOrgCheckListener().treeNodesRemoveCheck(e);
        }
        this.removeNodeData(root);
        if (root.getParent() != null) {
            ((DefaultTreeModel)this.getKdTree().getModel()).removeNodeFromParent((MutableTreeNode)root);
        }
    }

    protected void removeNodeData(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        FullOrgUnitInfo orgUnit = this.getOrgUnit(node);
        if (orgUnit != null) {
            this.getOrgNodeMap().remove(this.getId((IObjectValue)orgUnit));
        }
    }

    protected void removeNodesData(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        this.removeNodeData(root);
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.removeNodesData(node);
        }
    }

    protected String getOrgUnitOrderKey(IObjectValue orgUnit) {
        return orgUnit.getString(FIELD_LONGNUMBER);
    }

    protected IObjectValue getOrgUnit(Object[] obj) {
        if (obj == null) {
            return null;
        }
        IObjectValue orgUnit = this.createNewOrgUnit();
        orgUnit.setString(orgUnit.getPKField(), (String)obj[0]);
        orgUnit.setString(FIELD_NAME, (String)obj[1]);
        orgUnit.setString(FIELD_NUMBER, (String)obj[2]);
        orgUnit.setString(FIELD_LONGNUMBER, (String)obj[3]);
        orgUnit.setInt(FIELD_LEVEL, ((Integer)obj[4]).intValue());
        orgUnit.setBoolean(FIELD_ISLEAF, ((Boolean)obj[5]).booleanValue());
        orgUnit.setBoolean(FIELD_ISOUSEALUP, ((Boolean)obj[6]).booleanValue());
        if (obj[7] != null) {
            orgUnit.setString(FIELD_PARENTID, (String)obj[7]);
        }
        orgUnit.setString(FIELD_SIMPLENAME, (String)obj[8]);
        orgUnit.setString(FIELD_CODE, (String)obj[9]);
        orgUnit.setString(FIELD_DESCRIPTION, (String)obj[10]);
        return orgUnit;
    }

    protected IObjectValue createNewOrgUnit() {
        return new OrgUnitInfo();
    }

    protected String getId(IObjectValue value) {
        return value.getString(value.getPKField());
    }

    protected String getId(DefaultKingdeeTreeNode node) {
        FullOrgUnitInfo orgUnit = this.getOrgUnit(node);
        if (orgUnit != null) {
            return this.getId((IObjectValue)orgUnit);
        }
        return null;
    }

    public FullOrgUnitInfo getOrgUnit(DefaultKingdeeTreeNode node) {
        if (node != null && node.getUserObject() instanceof OrgStructureInfo) {
            return ((OrgStructureInfo)node.getUserObject()).getUnit();
        }
        return null;
    }

    public DefaultKingdeeTreeNode getOrgUnitNode(IObjectValue orgUnit) {
        if (orgUnit == null) {
            return null;
        }
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        OrgStructureInfo orgStructure = new OrgStructureInfo();
        orgStructure.setUnit((OrgUnitInfo)orgUnit);
        node.setUserObject((Object)orgStructure);
        if (this.checkIsOUSealUp(orgUnit)) {
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
        if (!this.checkIsLeaf(orgUnit)) {
            node.add((MutableTreeNode)new DefaultKingdeeTreeNode());
        }
        return node;
    }

    protected DefaultKingdeeTreeNode getOrgUnitNode(Object[] obj) {
        return this.getOrgUnitNode(this.getOrgUnit(obj));
    }

    public void waitLoadTree() {
        if (this.isLoadAllOrgUnit || !this.isAsyncLoad) {
            return;
        }
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor(this.getComponent());
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                for (int count = 0; !OrgUnitBaseUtils.this.isLoadAllOrgUnit && count < 60; ++count) {
                    Thread.sleep(1000L);
                }
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.dialog.show();
    }

    public void addChildNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        if (this.checkNullNode(root)) {
            FullOrgUnitInfo orgUnit = this.getOrgUnit(root);
            List orgUnits = this.getBizInterface().getChildOrgUnits(BOSUuid.read((String)this.getId((IObjectValue)orgUnit)), this.getOrgType());
            this.syncTree(orgUnits);
        }
    }

    public void selectNode(DefaultKingdeeTreeNode node) {
        if (node != null) {
            this.getKdTree().setSelectionPath(new TreePath(node.getPath()));
            this.getKdTree().scrollPathToVisible(this.getKdTree().getSelectionPath());
        }
    }

    public void expandNode(DefaultKingdeeTreeNode node) {
        if (node != null) {
            if (node.isLeaf()) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node != null) {
                this.getKdTree().expandPath(new TreePath(node.getPath()));
            }
        }
    }

    public static void expandNode(KDTree tree, DefaultKingdeeTreeNode node) {
        if (tree != null && node != null) {
            if (node.isLeaf()) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            if (node != null) {
                tree.expandPath(new TreePath(node.getPath()));
            }
        }
    }

    public void selectAllOrgUnit() {
        this.waitLoadTree();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        this.selectAllOrgUnit(root);
    }

    public void selectAllOrgUnit(DefaultKingdeeTreeNode root) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectOrgUnit(root, null, true);
        this.getKdTree().repaint();
    }

    public void selectAllOrgUnit(Set<String> selOrgUnitIds) {
        this.waitLoadTree();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        this.selectAllOrgUnit(root, selOrgUnitIds);
    }

    public void selectAllOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectOrgUnit(root, selOrgUnitIds, true);
        this.getKdTree().repaint();
    }

    public void unSelectAllOrgUnit() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        this.unSelectAllOrgUnit(root);
    }

    public void unSelectAllOrgUnit(DefaultKingdeeTreeNode root) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectOrgUnit(root, null, false);
        this.getKdTree().repaint();
    }

    public void unSelectAllOrgUnit(Set<String> selOrgUnitIds) {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        this.unSelectAllOrgUnit(root, selOrgUnitIds);
    }

    public void unSelectAllOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectOrgUnit(root, selOrgUnitIds, false);
        this.getKdTree().repaint();
    }

    protected void selectOrgUnit(DefaultKingdeeTreeNode root, Set<String> selOrgUnitIds, boolean selected) {
        if (root == null) {
            return;
        }
        if (selOrgUnitIds == null) {
            this.selectCurrOrgUnit(root, selected);
        } else if (selOrgUnitIds.contains(this.getId(root))) {
            this.selectCurrOrgUnit(root, selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node == null) continue;
            this.selectOrgUnit(node, selOrgUnitIds, selected);
        }
    }

    public void selectCurrOrgUnit(DefaultKingdeeTreeNode node, boolean selected) {
        if (this.canTheNodeBeSelected(node)) {
            node.setChecked(selected);
        }
    }

    protected boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node != null && node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public void selectDirectOrgUnit(DefaultKingdeeTreeNode root) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectDirectOrgUnit(root, true);
        this.getKdTree().repaint();
    }

    public void unSelectDirectOrgUnit(DefaultKingdeeTreeNode root) {
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.selectDirectOrgUnit(root, false);
        this.getKdTree().repaint();
    }

    protected void selectDirectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            this.selectCurrOrgUnit(node, selected);
        }
    }

    protected void enableCheckBox(DefaultKingdeeTreeNode root) {
        this.setNodeCheckBox(root, true);
    }

    protected void enableChildCheckBox(DefaultKingdeeTreeNode root) {
        this.setNodeCheckBox(root, true);
        root.setCheckBoxEnabled(true);
        root.setCheckBoxVisible(true);
    }

    protected void disableCheckBox(DefaultKingdeeTreeNode root) {
        this.setNodeCheckBox(root, false);
    }

    protected void disableChildCheckBox(DefaultKingdeeTreeNode root) {
        this.setNodeCheckBox(root, false);
        root.setCheckBoxEnabled(true);
        root.setCheckBoxVisible(true);
    }

    protected void setNodeCheckBox(DefaultKingdeeTreeNode root, boolean enabled) {
        if (root == null) {
            return;
        }
        root.setCheckBoxEnabled(enabled);
        root.setCheckBoxVisible(enabled);
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.setNodeCheckBox(node, enabled);
        }
    }

    public void selectCompanyOrgUnit() throws Exception {
        this.selectAllOrgUnit(null, this.companyIds);
    }

    public void selectCompanyOrgUnit(DefaultKingdeeTreeNode root) throws Exception {
        if (this.companyIds == null) {
            this.companyIds = this.getCompanyIds();
        }
        if (this.companyIds == null || this.companyIds.isEmpty()) {
            return;
        }
        this.selectAllOrgUnit(root, this.companyIds);
    }

    protected Set<String> getCompanyIds() throws Exception {
        return this.getBizInterface().getComapnyIds();
    }

    public void serachTree(String searchTxt) {
        if (StringUtils.isEmpty((String)searchTxt)) {
            return;
        }
        this.waitLoadTree();
        DefaultKingdeeTreeNode root = null;
        if (this.getKdTree().getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getSelectionPath().getLastPathComponent();
        }
        if (searchTxt != null && !searchTxt.equals(this.oldSearchTxt)) {
            root = null;
        }
        this.oldSearchTxt = searchTxt;
        DefaultKingdeeTreeNode node = this.serachTree(this.getAllNode(), root, searchTxt);
        this.selectNode(node);
        this.expandNode(node);
    }

    private DefaultKingdeeTreeNode serachTree(List<DefaultKingdeeTreeNode> nodes, DefaultKingdeeTreeNode node, String value) {
        DefaultKingdeeTreeNode check = null;
        if (nodes == null || value == null) {
            return check;
        }
        boolean beginCheck = node == null;
        DefaultKingdeeTreeNode _node = null;
        FullOrgUnitInfo orgUnit = null;
        int in = nodes.size();
        for (int i = 0; i < in && check == null; ++i) {
            _node = nodes.get(i);
            if (beginCheck) {
                orgUnit = this.getOrgUnit(_node);
                if (orgUnit == null) continue;
                String name = orgUnit.getString(FIELD_NAME);
                String number = orgUnit.getString(FIELD_NUMBER);
                if ((name == null || name.indexOf(value) < 0) && (number == null || number.indexOf(value) < 0)) continue;
                check = _node;
                continue;
            }
            if (!_node.equals(node)) continue;
            beginCheck = true;
        }
        return check;
    }

    public List<DefaultKingdeeTreeNode> getAllNode() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        return this.getAllNode(root);
    }

    public List<DefaultKingdeeTreeNode> getAllNode(DefaultKingdeeTreeNode root) {
        ArrayList<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
        if (root == null) {
            root = (DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot();
        }
        this.getAllNode(root, nodes);
        return nodes;
    }

    private void getAllNode(DefaultKingdeeTreeNode root, List<DefaultKingdeeTreeNode> nodes) {
        if (root == null || nodes == null) {
            return;
        }
        if (root.getUserObject() != null) {
            nodes.add(root);
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.getAllNode(node, nodes);
        }
    }

    public List<DefaultKingdeeTreeNode> getAllParentNodes(DefaultKingdeeTreeNode node) {
        ArrayList<DefaultKingdeeTreeNode> parents = new ArrayList<DefaultKingdeeTreeNode>();
        this.getAllParentNodes(node, parents);
        return parents;
    }

    private void getAllParentNodes(DefaultKingdeeTreeNode node, List<DefaultKingdeeTreeNode> parents) {
        DefaultKingdeeTreeNode parent;
        if (node == null || parents == null) {
            return;
        }
        if (node.getParent() != null && (parent = (DefaultKingdeeTreeNode)node.getParent()).getUserObject() instanceof OrgStructureInfo) {
            parents.add(parent);
            this.getAllParentNodes(parent, parents);
        }
    }

    public List<DefaultKingdeeTreeNode> getAllLeafNodes(DefaultKingdeeTreeNode node) {
        ArrayList<DefaultKingdeeTreeNode> leafs = new ArrayList<DefaultKingdeeTreeNode>();
        this.getAllLeafNodes(node, leafs);
        return leafs;
    }

    private void getAllLeafNodes(DefaultKingdeeTreeNode node, List<DefaultKingdeeTreeNode> nodes) {
        if (node == null || nodes == null) {
            return;
        }
        if (node.getChildCount() == 0) {
            nodes.add(node);
        } else {
            DefaultKingdeeTreeNode _node = null;
            int in = node.getChildCount();
            for (int i = 0; i < in; ++i) {
                _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.getAllLeafNodes(_node, nodes);
            }
        }
    }

    public List<DefaultKingdeeTreeNode> getSelectNodes() {
        ArrayList<DefaultKingdeeTreeNode> nodes = new ArrayList<DefaultKingdeeTreeNode>();
        this.selectNode((DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot(), nodes);
        return nodes;
    }

    protected void selectNode(DefaultKingdeeTreeNode root, List<DefaultKingdeeTreeNode> nodes) {
        if (root == null || nodes == null) {
            return;
        }
        if (root.isChecked()) {
            nodes.add(root);
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.selectNode(node, nodes);
        }
    }

    public List<IObjectValue> getSelectOrgUnits() {
        ArrayList<IObjectValue> orgUnits = new ArrayList<IObjectValue>();
        this.selectOrgUnit((DefaultKingdeeTreeNode)this.getKdTree().getModel().getRoot(), orgUnits);
        return orgUnits;
    }

    protected void selectOrgUnit(DefaultKingdeeTreeNode root, List<IObjectValue> nodes) {
        if (root == null || nodes == null) {
            return;
        }
        if (root.isChecked()) {
            nodes.add((IObjectValue)this.getOrgUnit(root));
        }
        DefaultKingdeeTreeNode node = null;
        int in = root.getChildCount();
        for (int i = 0; i < in; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.selectOrgUnit(node, nodes);
        }
    }

    protected DefaultKingdeeTreeNode getRootNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode _parent;
        DefaultKingdeeTreeNode parent = node;
        if (node == null) {
            return parent;
        }
        if (node.getParent() instanceof DefaultKingdeeTreeNode && (_parent = (DefaultKingdeeTreeNode)node.getParent()).getUserObject() instanceof OrgStructureInfo) {
            parent = this.getRootNode(_parent);
        }
        return parent;
    }

    protected void treeNodes_Removed(OrgTreeEvent e) throws Exception {
    }

    protected boolean treeNodes_Inserted(OrgTreeEvent e) throws Exception {
        return true;
    }

    public void initCheckListener() {
        this.orgCheckListener = new OrgCheckListener();
    }

    public class OrgCheckListener
    implements IOrgCheckListener {
        @Override
        public void treeNodesRemoveCheck(OrgTreeEvent event) throws Exception {
            OrgUnitBaseUtils.this.treeNodes_Removed(event);
        }

        @Override
        public boolean treeNodesInsertCheck(OrgTreeEvent event) throws Exception {
            return OrgUnitBaseUtils.this.treeNodes_Inserted(event);
        }
    }

    class LoadOrgUnitSwingWorker
    extends SwingWorker {
        private BOSUuid orgUnitId = null;

        public LoadOrgUnitSwingWorker(BOSUuid orgUnitId) {
            this.orgUnitId = orgUnitId;
        }

        public Object construct() {
            if (this.orgUnitId == null || OrgUnitBaseUtils.this.orgType == null) {
                return null;
            }
            List orgUnits = null;
            try {
                orgUnits = OrgUnitBaseUtils.this.getBizInterface().getLastOrgUnits(this.orgUnitId, OrgUnitBaseUtils.this.getOrgType());
                OrgUnitBaseUtils.this.syncTree(orgUnits);
                OrgUnitBaseUtils.this.isLoadAllOrgUnit = true;
            }
            catch (Exception ex) {
                logger.error((Object)"getLastOrgUnits error:", (Throwable)ex);
            }
            return null;
        }
    }
}

