/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ArrayUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.nbudget.BgExpressionsItemVariableHelper;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAutoEnurameHelper {
    private static final Logger logger = Logger.getLogger(BgAutoEnurameHelper.class);
    private static final String IS_TARGET_EXPR = "isTargetExpr";
    public static final String EXPR_BGITEM_VARIABLE = "@";
    public static final String BGFORMULA_STR = "BGFORMULA";
    public static final String BGBAL_STR = "BGBAL";
    public static final String BGACTUALS_STR = "BGACTUALS";
    public static final String BGADJUST_STR = "BGADJUST";
    public static final String BGAVLBAL_STR = "BGAVLBAL";
    public static final String LOAN_STR = "LOAN";
    public static final String LIMIT_STR = "LIMIT";
    public static final String CASH_STR = "CASH";
    public static final String CASHEXT_STR = "CASHEXT";
    public static final String CONVERT_RESULT = "CONVERT_RESULT";
    public static final String[] VAR_EXPR_BG = new String[]{"BGFORMULA", "BGBAL", "BGACTUALS", "BGADJUST", "BGAVLBAL"};
    public static final String[] VAR_EXPR_OTHER = new String[]{"LOAN", "LIMIT", "CASH", "CASHEXT"};

    public static void dealWithBgItemVariable(Sheet sheet, SortedCellBlockArray blocks, boolean isFormEdit, String formulaType) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        CellBlock _block = null;
        Object _blocks = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        _blocks = blocks != null && !blocks.isEmpty() ? blocks : sheet.getSelectionRange();
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    if (_cell == null) continue;
                    String currExprType = BgAutoEnurameHelper.getExprType(formulaType);
                    BgAutoEnurameHelper.setVariableExpr(_cell, isFormEdit, "BG_BUDGET_EXPRESSIONS", currExprType);
                    BgAutoEnurameHelper.setVariableExpr(_cell, isFormEdit, "BG_ACTUAL_EXPRESSIONS", currExprType);
                    BgAutoEnurameHelper.setVariableExpr(_cell, isFormEdit, "BG_ADD_EXPRESSIONS", currExprType);
                }
            }
        }
    }

    private static void setVariableExpr(Cell cell, boolean isFormEdit, String exprType, String currExprType) {
        if (cell == null) {
            return;
        }
        boolean hasBgItemVariable = false;
        String formula = null;
        if (exprType.equalsIgnoreCase(currExprType)) {
            if (cell.hasFormula()) {
                formula = cell.getFormula();
                BgNTemplateHelper.setBgDataValue(cell, exprType, formula, true);
                hasBgItemVariable = BgAutoEnurameHelper.parseVarExpr(formula);
            } else {
                BgNTemplateHelper.removeDataValue(cell, exprType, true);
            }
        } else {
            formula = BgNTemplateHelper.getBgDataValue(cell, exprType);
            hasBgItemVariable = BgAutoEnurameHelper.parseVarExpr(formula);
        }
        if (hasBgItemVariable) {
            BgAutoEnurameHelper.setVarFlagExpression(cell, exprType, formula);
        } else if (StringUtils.isEmpty((String)formula)) {
            BgAutoEnurameHelper.removeVarFlagExpression(cell, exprType);
        } else if (isFormEdit) {
            BgAutoEnurameHelper.removeVarFlagExpression(cell, exprType);
        }
    }

    public static String getVarExpressionKey(String exprType) {
        if (exprType != null) {
            if ("BG_BUDGET_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return "BG_BUDGET_VAR_EXPR_@";
            }
            if ("BG_ACTUAL_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return "BG_ACTUAL_VAR_EXPR_@";
            }
            if ("BG_ADD_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return "BG_ADD_VAR_EXPR_@";
            }
        }
        return null;
    }

    public static int getViewType(String exprType) {
        if (exprType != null) {
            if ("BG_BUDGET_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return 0;
            }
            if ("BG_ACTUAL_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return 1;
            }
            if ("BG_ADD_EXPRESSIONS".equalsIgnoreCase(exprType)) {
                return 2;
            }
        }
        return 0;
    }

    public static void autoBuildExpressions(Context ctx, Sheet sheet, SortedCellBlockArray _blocks, IObjectValue model, String currFormulaType) throws EASBizException, BOSException {
        if (sheet == null) {
            return;
        }
        CellBlock _block = null;
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String[] str = null;
        if (_blocks == null || _blocks.size() == 0) {
            return;
        }
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    if (_cell == null || (str = BgNFSHelper.getBgItemInfo(_cell)) == null || str.length != 3 || str[2] == null) continue;
                    BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, sheet, rowBegin, colBegin, false, false, model, BgAutoEnurameHelper.getExprType(currFormulaType));
                }
            }
        }
    }

    private static void buildExpressionsByCurrCell(Context ctx, Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, boolean isFromUpdate, IObjectValue model, String currExprType) throws BOSException, EASBizException {
        if (sheet == null) {
            return;
        }
        BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, sheet, rowIndex, colIndex, isFromDelete, isFromUpdate, model, "BG_BUDGET_EXPRESSIONS", currExprType);
        BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, sheet, rowIndex, colIndex, isFromDelete, isFromUpdate, model, "BG_ACTUAL_EXPRESSIONS", currExprType);
        BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, sheet, rowIndex, colIndex, isFromDelete, isFromUpdate, model, "BG_ADD_EXPRESSIONS", currExprType);
    }

    private static void buildExpressionsByCurrCell(Context ctx, Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, boolean isFromUpdate, IObjectValue model, String exprType, String currExprType) throws BOSException, EASBizException {
        if (sheet == null) {
            return;
        }
        int maxColIndex = sheet.getMaxColIndex();
        Cell _cell = null;
        String expressions = null;
        String itemCombinStr = null;
        int beginColIndex = 0;
        String companyNumber = BgNExpressionHelper.getCompanyNumber(ctx, model);
        for (beginColIndex = isFromUpdate ? colIndex : colIndex + 1; beginColIndex <= maxColIndex; ++beginColIndex) {
            _cell = sheet.getCell(rowIndex, beginColIndex, false);
            boolean hasItemVariable = BgAutoEnurameHelper.parseVarExpr(BgAutoEnurameHelper.getVarFlagExpression(_cell, exprType));
            if (!BgAutoEnurameHelper.checkFormulaIsAutoCreate(_cell, exprType) && !StringUtils.isEmpty((String)BgNTemplateHelper.getBgDataValue(_cell, exprType)) && !hasItemVariable) continue;
            expressions = BgAutoEnurameHelper.getBgItemVariable(sheet, _cell, rowIndex, beginColIndex, exprType);
            if (!StringUtils.isEmpty((String)expressions)) {
                String[] itemStrs;
                itemCombinStr = BgExpressionsItemVariableHelper.getBgItemCombinStr(sheet, rowIndex, beginColIndex, isFromDelete, new int[]{rowIndex, colIndex});
                if (!StringUtils.isEmpty((String)itemCombinStr) && (itemStrs = itemCombinStr.split(",")) != null && itemStrs.length > 1) {
                    HashMap bgItemCombinMap = new HashMap();
                    bgItemCombinMap.put(itemCombinStr, null);
                    IBgFormulaFacade iBgF = null;
                    iBgF = ctx != null ? BgFormulaFacadeFactory.getLocalInstance((Context)ctx) : BgFormulaFacadeFactory.getRemoteInstance();
                    bgItemCombinMap = iBgF.batchParseBgItemCombi(bgItemCombinMap, SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                    Object[] res = (Object[])bgItemCombinMap.get(itemCombinStr);
                    if (res[0] != null) {
                        itemCombinStr = (String)res[0];
                    }
                }
                if (StringUtils.isEmpty((String)itemCombinStr)) {
                    String tmpExpr = BgAutoEnurameHelper.getBgItemVariable(_cell, exprType);
                    if (!StringUtils.isEmpty((String)tmpExpr)) {
                        BgNFSHelper.checkExpression(_cell, model, companyNumber);
                        BgAutoEnurameHelper.saveExpression(_cell, tmpExpr, exprType, currExprType);
                        continue;
                    }
                    if (_cell == null) continue;
                    BgAutoEnurameHelper.saveExpression(_cell, tmpExpr, exprType, currExprType);
                    continue;
                }
                if (StringUtils.isEmpty((String)(expressions = BgAutoEnurameHelper.procesVarExprForBgItemCombin(expressions, new HashMap(), false, itemCombinStr, null, null)))) continue;
                boolean isAutoCreate = BgAutoEnurameHelper.checkFormulaIsAutoCreate(_cell, exprType);
                if (isFromUpdate && isAutoCreate) {
                    BgAutoEnurameHelper.saveExpression(_cell, expressions, exprType, currExprType);
                } else if (!isFromDelete && !isFromUpdate) {
                    if (_cell == null) {
                        _cell = sheet.getCell(rowIndex, beginColIndex, true);
                    }
                    BgAutoEnurameHelper.saveExpression(_cell, expressions, exprType, currExprType);
                    _cell.setUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType), (Object)BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
                } else if (isFromDelete && isAutoCreate) {
                    BgAutoEnurameHelper.saveExpression(_cell, expressions, exprType, currExprType);
                }
                BgNFSHelper.checkExpression(_cell, model, companyNumber);
                continue;
            }
            if (!BgAutoEnurameHelper.checkFormulaIsAutoCreate(_cell, exprType)) continue;
            _cell.removeUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
            BgAutoEnurameHelper.removeVarFlagExpression(_cell, exprType);
        }
        beginColIndex = 0;
        if (!isFromDelete) {
            return;
        }
        Cell currCell = sheet.getCell(rowIndex, colIndex, false);
        int maxRowIndex = sheet.getMaxRowIndex();
        for (int beginRowIndex = rowIndex + 1; beginRowIndex <= maxRowIndex; ++beginRowIndex) {
            _cell = sheet.getCell(beginRowIndex, colIndex, false);
            if (_cell == null || BgAutoEnurameHelper.parseVarExpr(BgNTemplateHelper.getBgDataValue(_cell, exprType)) || BgNTemplateHelper.getBgDataValue(currCell, exprType) == null || !BgAutoEnurameHelper.checkFormulaIsAutoCreate(_cell, exprType) && BgNFSHelper.checkHasExpression(_cell) || StringUtils.isEmpty((String)(expressions = BgAutoEnurameHelper.getBgItemVariable(sheet, _cell, beginRowIndex, colIndex, exprType)))) continue;
            itemCombinStr = BgExpressionsItemVariableHelper.getBgItemCombinStr(sheet, beginRowIndex, colIndex, isFromDelete, new int[]{rowIndex, colIndex});
            if (StringUtils.isEmpty((String)itemCombinStr)) {
                String tmpExpr = BgAutoEnurameHelper.getBgItemVariable(_cell, exprType);
                if (!StringUtils.isEmpty((String)tmpExpr)) {
                    _cell.setFormula(tmpExpr);
                    continue;
                }
                _cell.setFormula(null);
                continue;
            }
            if (StringUtils.isEmpty((String)(expressions = BgAutoEnurameHelper.procesVarExprForBgItemCombin(expressions, new HashMap(), false, itemCombinStr, null, null)))) continue;
            if (!isFromDelete) {
                _cell.setFormula(expressions);
                _cell.setUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType), (Object)BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
                continue;
            }
            if (!isFromDelete || !BgAutoEnurameHelper.checkFormulaIsAutoCreate(_cell, exprType)) continue;
            _cell.setFormula(expressions);
        }
    }

    public static void batchRemoveUserObject(Book book) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = _sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    BgAutoEnurameHelper.removeUserObject(_cell, "BG_BUDGET_EXPRESSIONS");
                    BgAutoEnurameHelper.removeUserObject(_cell, "BG_ACTUAL_EXPRESSIONS");
                    BgAutoEnurameHelper.removeUserObject(_cell, "BG_ADD_EXPRESSIONS");
                }
            }
        }
    }

    private static void removeUserObject(Cell cell, String exprType) {
        if (cell != null) {
            cell.removeUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
            BgAutoEnurameHelper.removeVarFlagExpression(cell, exprType);
            if (BgAutoEnurameHelper.parseVarExpr(BgNTemplateHelper.getBgDataValue(cell, exprType))) {
                cell.setFormula(null);
                BgNTemplateHelper.removeDataValue(cell, exprType, true);
            }
        }
    }

    private static String getVarFlagExpression(Cell cell, String exprType) {
        if (cell == null || cell.getUserObject(BgAutoEnurameHelper.getVarExpressionKey(exprType)) == null) {
            return null;
        }
        return (String)cell.getUserObjectValue(BgAutoEnurameHelper.getVarExpressionKey(exprType));
    }

    private static void setVarFlagExpression(Cell cell, String exprType, String expression) {
        if (StringUtils.isEmpty((String)expression)) {
            BgAutoEnurameHelper.removeVarFlagExpression(cell, exprType);
        } else if (!expression.equalsIgnoreCase(BgAutoEnurameHelper.getVarFlagExpression(cell, exprType))) {
            cell.setUserObject(BgAutoEnurameHelper.getVarExpressionKey(exprType), (Object)expression);
        }
    }

    private static void removeVarFlagExpression(Cell cell, String exprType) {
        if (BgAutoEnurameHelper.getVarFlagExpression(cell, exprType) != null) {
            cell.removeUserObject(BgAutoEnurameHelper.getVarExpressionKey(exprType));
        }
    }

    private static void saveExpression(Cell cell, String expressions, String exprType, String currExprType) {
        BgNFSHelper.saveExpression(cell, expressions, BgAutoEnurameHelper.getViewType(exprType));
        if (exprType.equalsIgnoreCase(currExprType)) {
            cell.setFormula(expressions);
        }
    }

    public static void batchRebuildExpressions(Book book, IObjectValue model, String currFormulaType, Context ctx) throws BOSException, EASBizException {
        BgAutoEnurameHelper.batchRebuildExpressions(book, model, currFormulaType, ctx, null);
    }

    public static void batchRebuildExpressions(Book book, IObjectValue model, String currFormulaType, Context ctx, Set filterSheet) throws BOSException, EASBizException {
        if (book == null || ctx == null) {
            return;
        }
        boolean isBySheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isBySheet = true;
        }
        String orgUnitId = null;
        if (model instanceof BgFormInfo) {
            orgUnitId = ((BgFormInfo)model).getOrgUnit().getId().toString();
        } else if (model instanceof BgTemplateInfo) {
            orgUnitId = ((BgTemplateInfo)model).getOrgUnit().getId().toString();
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet _sheet = null;
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (isBySheet && !filterSheet.contains(BgNFSHelper.getSheetSign(_sheet))) continue;
            int rowCount = _sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = _sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, _sheet, rowIndex, colIndex, false, false, model, BgAutoEnurameHelper.getExprType(currFormulaType));
                }
            }
        }
        BgNTemplateHelper.dealWith(book, orgUnitId, new HashMap(), true, false, currFormulaType, true, true, ctx, filterSheet);
    }

    public static void updateUserObject(Cell sourceCell, Cell targetCell, boolean isLocked) {
        BgAutoEnurameHelper.updateUserObject(sourceCell, targetCell, isLocked, "BG_BUDGET_EXPRESSIONS");
        BgAutoEnurameHelper.updateUserObject(sourceCell, targetCell, isLocked, "BG_ACTUAL_EXPRESSIONS");
        BgAutoEnurameHelper.updateUserObject(sourceCell, targetCell, isLocked, "BG_ADD_EXPRESSIONS");
    }

    private static void updateUserObject(Cell sourceCell, Cell targetCell, boolean isLocked, String exprType) {
        if (isLocked) {
            UserObject userObject = null;
            userObject = sourceCell.getUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
            Object value = null;
            if (userObject != null) {
                value = userObject.getValue();
            }
            if (value != null) {
                targetCell.setUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType), value);
            } else if (!BgAutoEnurameHelper.checkFormulaIsAutoCreate(targetCell, exprType)) {
                targetCell.removeUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
            }
            String expr = BgAutoEnurameHelper.getBgItemVariable(sourceCell, exprType);
            if (!StringUtils.isEmpty((String)expr)) {
                BgAutoEnurameHelper.setVarFlagExpression(targetCell, exprType, expr);
            } else {
                BgAutoEnurameHelper.removeVarFlagExpression(targetCell, exprType);
            }
        }
    }

    public static String getBgItemVariable(Sheet sheet, Cell cell, int rowIndex, int colIndex, String exprType) {
        String resultExpr = null;
        resultExpr = BgAutoEnurameHelper.getBgItemVariable(cell, exprType);
        if (!StringUtils.isEmpty((String)resultExpr)) {
            return resultExpr;
        }
        Cell _cell = null;
        for (int rowBeginIndex = rowIndex - 1; rowBeginIndex >= 0; --rowBeginIndex) {
            _cell = sheet.getCell(rowBeginIndex, colIndex, false);
            if (_cell == null || StringUtils.isEmpty((String)(resultExpr = BgAutoEnurameHelper.getBgItemVariable(_cell, exprType)))) continue;
            return resultExpr;
        }
        return resultExpr;
    }

    public static String getBgItemVariable(Cell cell, String exprType) {
        if (cell == null) {
            return null;
        }
        UserObject userObj = cell.getUserObject(BgAutoEnurameHelper.getVarExpressionKey(exprType));
        if (userObj == null) {
            return null;
        }
        return (String)userObj.getValue();
    }

    private static boolean checkFormulaIsAutoCreate(Cell cell, String exprType) {
        if (cell == null || cell.getFormula() == null) {
            return false;
        }
        UserObject userObject = cell.getUserObject(BgAutoEnurameHelper.getVarExprAutoCreateKey(exprType));
        return userObject != null && userObject.getValue() != null;
    }

    public static String getVarExprAutoCreateKey(String exprType) {
        if (exprType != null) {
            return exprType + "_IS_AUTO_CREAT";
        }
        return null;
    }

    public static boolean parseVarExpr(String expressions) {
        if (!StringUtils.isEmpty((String)expressions)) {
            String _expressions = null;
            HashMap isTargetExpr = new HashMap();
            _expressions = BgAutoEnurameHelper.procesVarExprForBgItemCombin(expressions, new HashMap(), true, null, null, isTargetExpr);
            if (StringUtils.isEmpty((String)_expressions)) {
                return false;
            }
            if (isTargetExpr.get(IS_TARGET_EXPR) != null) {
                return (Boolean)isTargetExpr.get(IS_TARGET_EXPR);
            }
            return false;
        }
        return false;
    }

    public static String procesVarExprForBgItemCombin(String expressions, final Map bgItemCombinMap, final boolean isEnumForm, final String itemCombinStr, final Map convertResult, final Map isTargetExpr) {
        if (StringUtils.isEmpty((String)expressions) || bgItemCombinMap == null) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        if (expressions.toUpperCase().indexOf("KPGETSQL") >= 0) {
            return expressions;
        }
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (expression instanceof Ref3DExpr) {
                return null;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgAutoEnurameHelper.checkExpression(expr, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    protected static Expression checkExpression(Expression expression, Map bgItemCombinMap, boolean isEnumForm, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        if (expression instanceof FunctionExpr) {
            expression = BgAutoEnurameHelper.checkFunctionExpr((FunctionExpr)expression, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
        } else if (expression instanceof BinaryOperationExpr) {
            expression = BgAutoEnurameHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, Map bgItemCombinMap, boolean isEnumForm, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        String funcionName = funExpr.funcionName;
        try {
            if (BgAutoEnurameHelper.isTheTargetExpression(funcionName)) {
                FunctionExpr _expression = funExpr;
                Expression p0 = (Expression)funExpr.parameters.get(0);
                if (p0 instanceof StringExpr) {
                    StringExpr sp = (StringExpr)p0;
                    String valueStr = sp.value;
                    String[] pp = valueStr.split(";");
                    if (pp != null && pp.length > 1) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < pp.length; ++i) {
                            funExpr.parameters.set(0, new StringExpr(pp[i]));
                            if (sb.length() > 1) {
                                sb.append('+');
                            }
                            funExpr.output(sb);
                        }
                        _expression = ExcelFormulaPaserHelper.parse((String)sb.toString());
                        _expression = BgAutoEnurameHelper.checkExpression((Expression)_expression, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
                    }
                }
                if (_expression instanceof FunctionExpr) {
                    BgAutoEnurameHelper.checkExpressionParam(_expression, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
                }
                return _expression;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return funExpr;
    }

    private static void checkExpressionParam(FunctionExpr funExpr, Map bgItemCombinMap, boolean isEnumForm, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        List parameter = funExpr.parameters;
        String funcionName = funExpr.funcionName;
        StringExpr varparam = BgAutoEnurameHelper.getVarParam(parameter, funcionName);
        if (varparam != null) {
            BgAutoEnurameHelper.putIsTargetExpr(isTargetExpr, new Boolean(EXPR_BGITEM_VARIABLE.equals(varparam.value)));
            if (!StringUtils.isEmpty((String)itemCombinStr)) {
                varparam.value = itemCombinStr;
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            if (EXPR_BGITEM_VARIABLE.equals(varparam.value) && isEnumForm) {
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            if (bgItemCombinMap.isEmpty()) {
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            String strItemCombi = varparam.value;
            String _strItemCombi = null;
            Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
            if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                _strItemCombi = (String)obj[0];
            }
            if (_strItemCombi == null) {
                varparam.value = "";
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.FALSE);
            }
            if (strItemCombi != null && _strItemCombi != null && !strItemCombi.equals(_strItemCombi) && !_strItemCombi.equals("")) {
                varparam.value = _strItemCombi;
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
            }
        } else if (BgAutoEnurameHelper.isBgTargetExpression(funcionName)) {
            StringExpr param3 = (StringExpr)parameter.get(3);
            BgAutoEnurameHelper.putIsTargetExpr(isTargetExpr, new Boolean(EXPR_BGITEM_VARIABLE.equals(param3.value)));
            if (!StringUtils.isEmpty((String)itemCombinStr)) {
                param3.value = itemCombinStr;
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            if (bgItemCombinMap.isEmpty()) {
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
                return;
            }
            String strItemCombi = param3.value;
            String _strItemCombi = null;
            Object[] obj = (Object[])bgItemCombinMap.get(strItemCombi);
            if (obj != null && obj.length >= 2 && obj[1] != null && !((Boolean)obj[1]).booleanValue()) {
                _strItemCombi = (String)obj[0];
            }
            if (_strItemCombi == null) {
                param3.value = "";
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.FALSE);
            }
            if (strItemCombi != null && _strItemCombi != null && !strItemCombi.equals(_strItemCombi) && !_strItemCombi.equals("")) {
                param3.value = _strItemCombi;
                BgAutoEnurameHelper.putConvertResult(convertResult, Boolean.TRUE);
            }
        }
    }

    public static void rebuildExpressions(Context ctx, NotifyEvent evt, IObjectValue model, String currFormulaType) throws EASBizException, BOSException {
        Book book = ((SpreadContext)evt.getSource()).getBook();
        book.setSkipListeners(true);
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet sheet = book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        CellBlock _block = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        Range _blocks = sheet.getSelectionRange();
        if (_blocks == null || _blocks.size() == 0) {
            return;
        }
        String[] str = null;
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    boolean isNeed;
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    boolean bl = isNeed = _cell == null;
                    if (_cell != null) {
                        if (_cell.getValue() == null || StringUtils.isEmpty((String)_cell.getValue().toString())) {
                            isNeed = true;
                            BgNFSHelper.clearBgItemInfo(_cell);
                        } else {
                            str = BgNFSHelper.getBgItemInfo(_cell);
                            if (str == null || str.length != 3 || str[2] == null) {
                                isNeed = true;
                            }
                        }
                    }
                    if (!isNeed) continue;
                    BgAutoEnurameHelper.buildExpressionsByCurrCell(ctx, sheet, rowBegin, colBegin, true, false, model, BgAutoEnurameHelper.getExprType(currFormulaType));
                }
            }
        }
        book.setSkipListeners(false);
    }

    public static void checkExpr4AutoFill(Cell cell, String exprType, String currExprType, Map bgItemCombinMap, boolean isEnumForm) {
        String expressions = BgNTemplateHelper.getBgDataValue(cell, exprType);
        String _expressions = null;
        if (!StringUtils.isEmpty((String)expressions) && !BookFormulaHelper.isExcelFunction((Book)cell.getSheet().getBook(), (Sheet)cell.getSheet(), (String)expressions)) {
            HashMap convertMap = new HashMap();
            _expressions = BgAutoEnurameHelper.procesVarExprForBgItemCombin(expressions, bgItemCombinMap, isEnumForm, null, convertMap, null);
            Boolean convertResult = (Boolean)convertMap.get(CONVERT_RESULT);
            if (convertResult != null && !convertResult.booleanValue()) {
                if (!BgAutoEnurameHelper.checkFormulaIsAutoCreate(cell, exprType) && !StringUtils.isEmpty((String)BgAutoEnurameHelper.getVarFlagExpression(cell, exprType))) {
                    _expressions = BgAutoEnurameHelper.getVarFlagExpression(cell, exprType);
                }
                BgAutoEnurameHelper.saveExpression(cell, _expressions, exprType, currExprType);
            } else if (!StringUtils.isEmpty((String)_expressions)) {
                BgAutoEnurameHelper.saveExpression(cell, _expressions, exprType, currExprType);
            }
        }
    }

    private static void putConvertResult(Map convertMap, Boolean bSuccess) {
        if (convertMap != null) {
            convertMap.put(CONVERT_RESULT, bSuccess);
        }
    }

    private static void putIsTargetExpr(Map isTargetExpr, Boolean bSuccess) {
        if (isTargetExpr != null) {
            isTargetExpr.put(IS_TARGET_EXPR, bSuccess);
        }
    }

    private static BinaryOperationExpr checkBinaryOperationExpr(BinaryOperationExpr boExpr, Map bgItemCombinMap, boolean isEnumForm, String itemCombinStr, Map convertResult, Map isTargetExpr) {
        boExpr.left = BgAutoEnurameHelper.checkExpression(boExpr.left, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
        boExpr.right = BgAutoEnurameHelper.checkExpression(boExpr.right, bgItemCombinMap, isEnumForm, itemCombinStr, convertResult, isTargetExpr);
        return boExpr;
    }

    public static boolean isTheTargetExpression(String functionName) {
        return BgAutoEnurameHelper.isBgTargetExpression(functionName) || BgAutoEnurameHelper.isOtherTargetExpression(functionName);
    }

    public static boolean isBgTargetExpression(String functionName) {
        if (functionName == null) {
            return false;
        }
        return ArrayUtil.findStringElement((String[])VAR_EXPR_BG, (String)functionName, (int)-1, (boolean)true) >= 0;
    }

    private static boolean isOtherTargetExpression(String functionName) {
        if (functionName == null) {
            return false;
        }
        return ArrayUtil.findStringElement((String[])VAR_EXPR_OTHER, (String)functionName, (int)-1, (boolean)true) >= 0;
    }

    private static StringExpr getVarParam(List params, String functionName) {
        StringExpr res = null;
        if (params != null && !StringUtils.isEmpty((String)functionName)) {
            if (BgAutoEnurameHelper.isBgTargetExpression(functionName) && params.size() > 3 && BgAutoEnurameHelper.isVarParam(params.get(3))) {
                res = (StringExpr)params.get(3);
            } else if (BgAutoEnurameHelper.isOtherTargetExpression(functionName)) {
                for (int i = 0; i < params.size(); ++i) {
                    if (!BgAutoEnurameHelper.isVarParam(params.get(i))) continue;
                    res = (StringExpr)params.get(i);
                    break;
                }
            }
        }
        return res;
    }

    private static boolean isVarParam(Object param) {
        return param instanceof StringExpr && EXPR_BGITEM_VARIABLE.equals(((StringExpr)param).value);
    }

    public static String getExprType(String formulaType) {
        if ("bgActual".equalsIgnoreCase(formulaType)) {
            return "BG_ACTUAL_EXPRESSIONS";
        }
        if ("bgActualAdd".equalsIgnoreCase(formulaType)) {
            return "BG_ADD_EXPRESSIONS";
        }
        return "BG_BUDGET_EXPRESSIONS";
    }
}

