/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.client.BgExamineXInputUI;
import com.kingdee.eas.ma.nbudget.BgCslFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslFormInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.IBgCslFacade;
import com.kingdee.eas.ma.nbudget.IBgCslForm;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgCslHelper {
    private static final Logger logger = Logger.getLogger(BgCslHelper.class);
    public static final boolean trans4TO6 = true;
    public static final int paraItem = 0;
    public static final int paraPeriod = 1;
    public static final int paraElement = 2;
    public static final int paraCurrency = 3;
    public static final int paraOldItem = 0;
    public static final int paraOldPeriod = 1;
    public static final int paraOldElement = 2;
    public static final int paraOldDataType = 3;
    public static final int paraOldCollect = 4;
    public static final int paraOldCurrency = 5;
    public static final int decimal = 8;
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgCslResource";

    public static String checkFormula(Map formulaMap, String formulaStr, IObjectValue model) throws BgFormException {
        if (StringUtils.isEmpty((String)formulaStr) || model == null || !(model instanceof BgCslFormInfo)) {
            return formulaStr;
        }
        boolean isBuilder = false;
        BgCslFormInfo bgFormInfo = (BgCslFormInfo)model;
        String[] parameter = BgCslHelper.parseFormulaPara(formulaMap, formulaStr);
        String bgFormPeriod = bgFormInfo.getBgPeriod().getNumber();
        int bgFormPeriodType = bgFormInfo.getBgPeriod().getPeriodType().getValue();
        if (parameter != null) {
            if (parameter.length == 6) {
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormInfo.getBgPeriod().getNumber();
                    isBuilder = true;
                } else {
                    String newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormPeriod, (String)parameter[1], (int)bgFormPeriodType);
                    if (!newPeriod.equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber(bgFormInfo.getBgPeriod().getNumber(), new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[5])) {
                    parameter[5] = bgFormInfo.getCurrency().getNumber();
                    isBuilder = true;
                }
            } else if (parameter.length == 4) {
                isBuilder = true;
                if (StringUtils.isEmpty((String)parameter[1])) {
                    parameter[1] = bgFormInfo.getBgPeriod().getNumber();
                    isBuilder = true;
                } else {
                    String newPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)bgFormPeriod, (String)parameter[1], (int)bgFormPeriodType);
                    if (!newPeriod.equals(parameter[1])) {
                        parameter[1] = newPeriod;
                        isBuilder = true;
                    } else if (Pattern.matches("\\-?\\d+", parameter[1])) {
                        parameter[1] = BgNPeriodHelper.getOffsetBgPeriodNumber(bgFormInfo.getBgPeriod().getNumber(), new Integer(parameter[1]));
                        isBuilder = true;
                    }
                }
                if (StringUtils.isEmpty((String)parameter[3])) {
                    parameter[3] = bgFormInfo.getCurrency().getNumber();
                    isBuilder = true;
                }
            } else {
                return null;
            }
        }
        if (isBuilder) {
            if (formulaMap != null) {
                formulaMap.remove(formulaStr);
            }
            if (parameter.length == 6) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
            } else if (parameter.length == 4) {
                formulaStr = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + "BgData\",true,\"" + parameter[3] + "\")").toString();
            }
            BgCslHelper.parseFormulaPara(formulaMap, formulaStr);
        }
        return formulaStr;
    }

    public static String[] parseFormulaPara(Map formulaMap, String formulaStr) {
        if (StringUtils.isEmpty((String)formulaStr)) {
            return null;
        }
        Expression expression = null;
        FunctionExpr expr = null;
        List parameterList = null;
        String[] parameter = null;
        if (formulaMap != null && formulaMap.containsKey(formulaStr)) {
            parameter = (String[])formulaMap.get(formulaStr);
        } else {
            try {
                expression = ExcelFormulaPaserHelper.parse((String)formulaStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            if (expression != null && expression instanceof FunctionExpr) {
                expr = (FunctionExpr)expression;
                parameterList = expr.parameters;
                int parameterSize = parameterList.size();
                parameter = new String[parameterSize];
                for (int i = 0; i < parameterSize; ++i) {
                    if (parameterList.get(i) != null) {
                        if (parameterList.get(i) instanceof StringExpr) {
                            parameter[i] = ((StringExpr)parameterList.get((int)i)).value;
                            continue;
                        }
                        if (parameterList.get(i) instanceof BoolExpr) {
                            parameter[i] = String.valueOf(((BoolExpr)parameterList.get((int)i)).value).toLowerCase();
                            continue;
                        }
                        parameter[i] = "";
                        continue;
                    }
                    parameter[i] = "";
                }
                parameterList.clear();
                if (formulaMap != null) {
                    formulaMap.put(formulaStr, parameter);
                }
            } else {
                parameter = new String[6];
            }
        }
        return parameter;
    }

    public static void calculateReport(Context ctx, Book book, BgCslFormInfo info, List formulas) throws BOSException, EASBizException {
        Map formulaMap;
        if (book == null || info == null || info.getOrgTree() == null || info.getOrgUnit() == null || info.getBgScheme() == null || info.getDataType() == null) {
            return;
        }
        String treeId = info.getOrgTree().getId().toString();
        String orgUnitId = info.getOrgUnit().getId().toString();
        String bgSchemeId = info.getBgScheme().getId().toString();
        IBgCslForm bgCslForm = null;
        bgCslForm = ctx != null ? BgCslFormFactory.getLocalInstance(ctx) : BgCslFormFactory.getRemoteInstance();
        if (formulas.isEmpty()) {
            formulas = BgCslHelper.getFormulasFromBook(book);
        }
        if ((formulaMap = bgCslForm.getCslData(treeId, orgUnitId, bgSchemeId, info.getDataType(), formulas)) != null && !formulaMap.isEmpty()) {
            BgCslHelper.fillData(book, formulaMap);
        }
    }

    public static List getFormulasFromBook(Book book) {
        Sheet sheet = null;
        Cell cell = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        if (book != null) {
            int sheetCount = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                sheet = book.getSheet(sheetIndex);
                int rowCount = sheet.getMaxRowIndex() + 1;
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    int colCount = sheet.getMaxColIndex() + 1;
                    for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        formulaList.add(BgNFSHelper.getFormulaOfCell(cell));
                    }
                }
            }
        }
        return formulaList;
    }

    public static void fillData(Book book, Map formulaMap) {
        if (book == null || formulaMap == null || formulaMap.isEmpty()) {
            return;
        }
        Sheet sheet = null;
        Cell cell = null;
        String formula = null;
        if (book != null) {
            int sheetCount = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                sheet = book.getSheet(sheetIndex);
                int rowCount = sheet.getMaxRowIndex() + 1;
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    int colCount = sheet.getMaxColIndex() + 1;
                    for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || !formulaMap.containsKey(formula = BgNFSHelper.getFormulaOfCell(cell))) continue;
                        BgNFSHelper.setValue(cell, formulaMap.get(formula));
                    }
                }
            }
        }
    }

    public static String returnExamineX(BOSUuid[] bgCslFormid, Object owner) {
        if (bgCslFormid == null) {
            return null;
        }
        String[] strs = new String[bgCslFormid.length];
        for (int i = 0; i < bgCslFormid.length; ++i) {
            strs[i] = bgCslFormid[i].toString();
        }
        String data = null;
        try {
            IBgCslFacade iBEx = BgCslFacadeFactory.getRemoteInstance();
            if (iBEx.canExamine(strs) && iBEx.examineHadX(bgCslFormid)) {
                UIContext uiContext = new UIContext(owner);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgExamineXInputUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
                data = ((BgExamineXInputUI)uiWindow.getUIObject()).getData();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return data;
    }

    public static BigDecimal getValue(Cell cell) {
        if (cell == null) {
            return BgNConstants.ZERO;
        }
        Object obj = BgNFSHelper.getValue(cell);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj != null) {
            try {
                return new BigDecimal(obj.toString());
            }
            catch (Exception e) {
                return BgNConstants.ZERO;
            }
        }
        return BgNConstants.ZERO;
    }

    public static BgCslFormInfo getBgCslFormInfo(Context ctx, BOSUuid bgCslFormId, boolean loadData) throws EASBizException, BOSException {
        SelectorItemCollection sic = BgCslHelper.getSelectors();
        if (loadData) {
            sic.add("data");
        }
        if (ctx != null) {
            return (BgCslFormInfo)BgCslFormFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgCslFormId), sic);
        }
        return (BgCslFormInfo)BgCslFormFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(bgCslFormId), sic);
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("state");
        sic.add("dataSource");
        sic.add("description");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgCslTemplate.id");
        sic.add("bgCslTemplate.name");
        sic.add("bgCslTemplate.number");
        sic.add("bgCslTemplate.canModify");
        sic.add("bgCslTemplate.parent.id");
        sic.add("bgCslTemplate.rootId");
        sic.add("bgCslTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("cslFormMeasureUnit.id");
        sic.add("cslFormMeasureUnit.bgElement.id");
        sic.add("cslFormMeasureUnit.bgElement.name");
        sic.add("cslFormMeasureUnit.bgElement.number");
        sic.add("cslFormMeasureUnit.measureUnit.id");
        sic.add("cslFormMeasureUnit.measureUnit.name");
        sic.add("cslFormMeasureUnit.measureUnit.number");
        sic.add("cslFormMeasureUnit.measureUnit.coefficient");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("auditTime");
        return sic;
    }
}

