/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.UnionVersionManager;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TablePorperts;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.TreeModel;

public class BgEliminationHelper {
    public static OrgTreeCollection getOrgTreeCollection() throws EASBizException, BOSException {
        OrgTreeCollection ocn = null;
        IOrgTree iorgTree = OrgTreeFactory.getRemoteInstance();
        OrgViewType vt = NewOrgViewHelper.convert((OrgType)OrgType.UnionDebt);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(vt.getValue()), CompareType.EQUALS));
        UnionVersionManager unionVersionManager = UnionVersionManager.getInstance();
        if (unionVersionManager.isStarted()) {
            FilterInfo filterStatus = new FilterInfo();
            filterStatus.getFilterItems().add(new FilterItemInfo("isForBudget", (Object)"1", CompareType.EQUALS));
            filter.mergeFilter(filterStatus, "AND");
        }
        evi.setFilter(filter);
        ocn = iorgTree.getOrgTreeCollection(evi);
        if (ocn != null && !ocn.isEmpty()) {
            IPermission ip = null;
            OrgTreeCollection trees = null;
            ip = PermissionFactory.getRemoteInstance();
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            ObjectStringPK pk = new ObjectStringPK(user.getId().toString());
            if (user != null) {
                trees = ip.getAllUnionTrees((IObjectPK)pk);
            }
            if (trees != null && !trees.isEmpty()) {
                for (int i = ocn.size() - 1; i >= 0; --i) {
                    OrgTreeInfo treeInfo = ocn.get(i);
                    if (trees.contains((Object)treeInfo.getId())) continue;
                    ocn.remove(treeInfo);
                }
            } else {
                ocn.clear();
            }
        }
        return ocn;
    }

    public static DefaultKingdeeTreeNode getUnionDebtTree(OrgUnitInfo unitInfo, OrgTreeInfo treeInfo, boolean isOneGrade, boolean onlyGroup) throws EASBizException, BOSException {
        String rootID = null;
        if (unitInfo != null) {
            rootID = unitInfo.getId().toString();
        }
        CtrlUnitInfo ctrlInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPK = new ObjectUuidPK(ctrlInfo.getId());
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        TreeModel treeModel = OrgF7InnerUtils.buildUnionTreeModel((IObjectPK)cuPK, (IObjectPK)userPK, (String)treeInfo.getId().toString(), (String)rootID, (boolean)isOneGrade, (boolean)false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        BgEliminationHelper.traceUnionDebtTreeForBudget(root);
        if (onlyGroup) {
            BgEliminationHelper.traceUnionDebtTreeOnlyShowGroup(root);
        }
        return root;
    }

    public static void traceUnionDebtTreeForBudget(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        int i;
        if (root == null) {
            return;
        }
        HashSet<String> seup = new HashSet<String>();
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (int i2 = root.getChildCount() - 1; i2 >= 0; --i2) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i2);
                if (!node.isLeaf()) {
                    BgEliminationHelper.traceUnionDebtTreeForBudget(node);
                    continue;
                }
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!info.isIsGrouping() && !info.isIsCostOrgUnit()) {
                    root.remove(i2);
                }
                if (!info.isIsCostOrgUnit()) continue;
                seup.add(info.getId().toString());
            }
        }
        if (seup.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", seup, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(1)));
        evi.setFilter(filter);
        CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        seup.clear();
        if (col != null && !col.isEmpty()) {
            for (i = 0; i < col.size(); ++i) {
                seup.add(col.get(i).getId().toString());
            }
        }
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                if (!node.isLeaf()) {
                    BgEliminationHelper.traceUnionDebtTreeForBudget(node);
                    continue;
                }
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!seup.contains(info.getId().toString())) continue;
                root.remove(i);
            }
        }
    }

    public static void traceUnionDebtTreeOnlyShowGroup(DefaultKingdeeTreeNode root) throws EASBizException, BOSException {
        if (root == null) {
            return;
        }
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = null;
        OrgStructureInfo oui = null;
        if (root != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)root)) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                oui = (OrgStructureInfo)node.getUserObject();
                info = oui.getUnit();
                if (!node.isLeaf() || info.isIsGrouping()) {
                    BgEliminationHelper.traceUnionDebtTreeOnlyShowGroup(node);
                    continue;
                }
                if (info.isIsGrouping()) continue;
                root.remove(i);
            }
        }
    }

    public static IObjectPK getPK(IObjectValue v) {
        if (v != null) {
            String pkField = v.getPKField();
            if (pkField != null && v.get(pkField) != null) {
                return new ObjectStringPK(v.get(pkField).toString());
            }
            return null;
        }
        return null;
    }

    public static void fillMap(Map map, Map fillMap) {
        if (map == null || fillMap == null || fillMap.isEmpty()) {
            return;
        }
        CoreBaseInfo cbi2 = null;
        CoreBaseInfo cbiFill2 = null;
        block0: for (CoreBaseInfo cbiFill2 : fillMap.keySet()) {
            for (CoreBaseInfo cbi2 : map.keySet()) {
                if (!cbi2.getId().equals((Object)cbiFill2.getId())) continue;
                map.put(cbi2, fillMap.get(cbiFill2));
                continue block0;
            }
        }
    }

    public static Object getValueFromMap(Map map, String id) {
        if (StringUtil.isEmpty((String)id) || map == null || map.isEmpty()) {
            return null;
        }
        CoreBaseInfo cbi2 = null;
        for (CoreBaseInfo cbi2 : map.keySet()) {
            if (cbi2 == null || cbi2.getId() == null || !id.equals(cbi2.getId().toString())) continue;
            return map.get(cbi2);
        }
        return null;
    }

    public static final void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
                int itemsSize = fiCol.size();
                if (itemsSize <= 1) {
                    filter.setMaskString("(#0)");
                } else {
                    filter.setMaskString("(" + filter.getMaskString() + ") and (#" + String.valueOf(itemsSize - 1) + ")");
                }
            }
        }
    }

    public static void saveBasePosition(KDTable table, int iLeft, int iTop) {
        TablePorperts tp;
        ICell cell;
        ItemFormula f;
        HashMap basePosition = BgEliminationHelper.getBasePosition(table);
        if (basePosition != null) {
            RptCell oldRptCell;
            int oldLeft = (Integer)basePosition.get("left");
            int oldTop = (Integer)basePosition.get("top");
            ICell oldcell = table.getCell(oldTop, oldLeft);
            if (oldcell != null && (f = (oldRptCell = (RptCell)oldcell.getUserObject()).getItemFormula()) != null) {
                f.removeExt("WORK_TEMPLATE_BASEPOSITION");
            }
        }
        if ((cell = table.getCell(iTop, iLeft)) != null) {
            RptCell rptCell = (RptCell)cell.getUserObject();
            if (rptCell == null) {
                rptCell = new RptCell(cell);
                cell.setUserObject((Object)rptCell);
            }
            if ((f = rptCell.getItemFormula()) == null) {
                f = new ItemFormula();
                rptCell.setItemFormula(f);
            }
            f.putExt("WORK_TEMPLATE_BASEPOSITION", "WORK_TEMPLATE_BASEPOSITION");
        }
        if ((tp = TablePorperts.getInstance((KDTable)table)) != null) {
            tp.put((Object)"WORK_TEMPLATE_BASEPOSITION", (Object)"WORK_TEMPLATE_BASEPOSITION");
        }
    }

    public static HashMap getBasePosition(KDTable table) {
        HashMap<String, Integer> map = null;
        Object base = null;
        TablePorperts tp = TablePorperts.getInstance((KDTable)table);
        if (tp != null) {
            base = tp.get((Object)"WORK_TEMPLATE_BASEPOSITION");
        }
        if (base != null && base.equals("WORK_TEMPLATE_BASEPOSITION")) {
            int i = 0;
            int j = 0;
            ItemFormula f = null;
            boolean isFindBasePosition = false;
            ICell c = null;
            RptCell rptCell = null;
            for (i = 0; i < table.getExpandedRowCount(); ++i) {
                for (j = 0; j < table.getExpandedColumnCount(); ++j) {
                    c = table.getCell(i, j);
                    rptCell = null;
                    if (c.getUserObject() instanceof RptCell) {
                        rptCell = (RptCell)c.getUserObject();
                    }
                    if (rptCell != null) {
                        f = rptCell.getItemFormula();
                        if (f != null && f.getExt("WORK_TEMPLATE_BASEPOSITION") != null) {
                            isFindBasePosition = true;
                            break;
                        }
                        f = null;
                    }
                    if (i != table.getExpandedRowCount() - 1 || j != table.getExpandedColumnCount() - 1) continue;
                    return null;
                }
                if (isFindBasePosition) break;
            }
            map = new HashMap<String, Integer>();
            map.put("left", new Integer(j));
            map.put("top", new Integer(i));
        }
        return map;
    }

    public static void saveBasePosition(Sheet sheet, int iLeft, int iTop) {
        Cell cell;
        HashMap basePosition = BgEliminationHelper.getBasePosition(sheet);
        if (basePosition != null) {
            int oldLeft = (Integer)basePosition.get("left");
            int oldTop = (Integer)basePosition.get("top");
            Cell cell2 = sheet.getCell(oldTop, oldLeft, false);
            if (cell2 != null) {
                sheet.getRange(cell2).setUserObject("WORK_TEMPLATE_BASEPOSITION", null);
            }
        }
        if ((cell = sheet.getCell(iTop, iLeft, false)) != null) {
            Range range = sheet.getRange(cell);
            range.setUserObject("WORK_TEMPLATE_BASEPOSITION", (Object)"WORK_TEMPLATE_BASEPOSITION");
            sheet.setUserObject("WORK_TEMPLATE_BASEPOSITION", (Object)BgEliminationHelper.getRowColTag(sheet, cell));
        }
    }

    public static HashMap getBasePosition(Sheet sheet) {
        HashMap<String, Integer> map = null;
        Object base = null;
        base = sheet.getUserObjectValue("WORK_TEMPLATE_BASEPOSITION");
        if (base != null && base instanceof String) {
            int i;
            String[] rowCol = ((String)base).split("!!");
            if (rowCol.length != 2) {
                return map;
            }
            int rowIndex = -1;
            int colIndex = -1;
            int rowCount = sheet.getRows().getMaxIntMark() + 1;
            int colCount = sheet.getCols().getMaxIntMark() + 1;
            for (i = 0; i < rowCount; ++i) {
                if (!rowCol[0].equals(BgNFSHelper.getRowSign(sheet.getRow(i, false)))) continue;
                rowIndex = i;
                break;
            }
            for (i = 0; i < colCount; ++i) {
                if (!rowCol[1].equals(BgNFSHelper.getColSign(sheet.getColumn(i, false)))) continue;
                colIndex = i;
                break;
            }
            if (rowIndex != -1 && colIndex != -1) {
                map = new HashMap<String, Integer>();
                map.put("top", new Integer(rowIndex));
                map.put("left", new Integer(colIndex));
            }
        }
        return map;
    }

    public static String getRowColTag(Sheet sheet, Cell selCell) {
        int rowIndex = selCell.getRow();
        int colIndex = selCell.getCol();
        String rowTag = BgNFSHelper.getRowSign(sheet.getRow(rowIndex, false));
        String colTag = BgNFSHelper.getColSign(sheet.getColumn(colIndex, false));
        if (rowTag == null) {
            rowTag = BgNFSHelper.setRowSign(sheet.getRow(rowIndex, true));
        }
        if (colTag == null) {
            colTag = BgNFSHelper.setColSign(sheet.getColumn(colIndex, true));
        }
        return rowTag + "!!" + colTag;
    }

    public static Map dealWithBgItemCombin(Context ctx, Map mapCombinNum) throws BOSException, EASBizException {
        if (mapCombinNum == null || mapCombinNum.isEmpty()) {
            return mapCombinNum;
        }
        String num2 = null;
        StringBuffer sql = new StringBuffer("SELECT FKey, FID FROM T_BG_BGItemCombination WHERE FKey IN (");
        for (int i = 1; i < mapCombinNum.keySet().size(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int pos = 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String num2 : mapCombinNum.keySet()) {
                pstmt.setString(pos++, num2.replaceAll(",", "_"));
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (mapCombinNum.containsKey(rst.getString(1))) {
                    mapCombinNum.put(rst.getString(1), rst.getString(2));
                    continue;
                }
                if (mapCombinNum.containsKey(rst.getString(1).replaceAll("_", ","))) {
                    mapCombinNum.put(rst.getString(1).replaceAll("_", ","), rst.getString(2));
                    continue;
                }
                mapCombinNum.put(rst.getString(1), rst.getString(2));
            }
            if (mapCombinNum.containsValue(null)) {
                HashMap<String, Object> insertMap = new HashMap<String, Object>();
                for (String num2 : mapCombinNum.keySet()) {
                    if (mapCombinNum.get(num2) != null) continue;
                    insertMap.put(num2, null);
                }
                BgEliminationHelper.insertItemCombin(ctx, insertMap);
                mapCombinNum.putAll(insertMap);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return mapCombinNum;
    }

    private static Map insertItemCombin(Context ctx, Map mapCombinNum) throws BOSException, EASBizException {
        int i;
        if (mapCombinNum == null || mapCombinNum.isEmpty()) {
            return mapCombinNum;
        }
        String num2 = null;
        String key2 = null;
        String value = null;
        String[] nums = null;
        String[] refValues = null;
        LinkedList<String> numList = new LinkedList<String>();
        LinkedList<String> combinKeyList = new LinkedList<String>();
        HashMap<String, String> refMap = new HashMap<String, String>();
        for (String num2 : mapCombinNum.keySet()) {
            combinKeyList.add(num2.replaceAll(",", "_"));
            if (num2.indexOf(",") != -1) {
                nums = num2.split(",");
                for (i = 0; i < nums.length; ++i) {
                    if (numList.contains(nums[i])) continue;
                    numList.add(num2);
                }
                continue;
            }
            if (StringUtil.isEmpty((String)num2) || numList.contains(num2)) continue;
            numList.add(num2);
        }
        StringBuffer sql = new StringBuffer("SELECT FNumber,FReffield FROM T_BG_BGItem WHERE FNumber IN (");
        for (i = 1; i < numList.size(); ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        sql.append(" ORDER BY FReffield ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rst = null;
        int pos = 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i2 = 0; i2 < numList.size(); ++i2) {
                pstmt.setString(i2 + 1, (String)numList.get(i2));
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                refMap.put(rst.getString(1), rst.getString(2));
            }
            for (String key2 : combinKeyList) {
                int i3;
                nums = key2.split("_");
                refValues = new String[nums.length];
                for (int i4 = 0; i4 < nums.length; ++i4) {
                    refValues[i4] = (String)refMap.get(nums[i4]);
                }
                StringBuffer sqlInsert = new StringBuffer("INSERT INTO T_BG_BGItemCombination (");
                for (i3 = 0; i3 < refValues.length; ++i3) {
                    sqlInsert.append(refValues[i3]).append(", ");
                }
                sqlInsert.append("FKey, FID) ");
                sqlInsert.append("VALUES (");
                for (i3 = 0; i3 < refValues.length; ++i3) {
                    sqlInsert.append("?,");
                }
                sqlInsert.append("?, ?)");
                pstmt1 = conn.prepareStatement(sqlInsert.toString());
                for (i3 = 0; i3 < nums.length; ++i3) {
                    pstmt1.setString(pos++, nums[i3]);
                }
                pstmt1.setString(pos++, key2);
                value = Uuid.create().toString() + "ABCDEFGH";
                pstmt1.setString(pos++, value);
                pstmt1.execute();
                if (mapCombinNum.containsKey(key2)) {
                    mapCombinNum.put(key2, value);
                } else if (mapCombinNum.containsKey(key2.replaceAll("_", ","))) {
                    mapCombinNum.put(key2.replaceAll("_", ","), value);
                } else {
                    mapCombinNum.put(key2, value);
                }
                SQLUtils.cleanup((Statement)pstmt1);
                pos = 1;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmt1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup(pstmt1);
        return mapCombinNum;
    }
}

