/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.IBgFormulaFacade;
import com.kingdee.eas.ma.nbudget.BgExpressionsParseHelper;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExpressionsItemVariableHelper {
    private static final Logger logger = Logger.getLogger(BgExpressionsItemVariableHelper.class);
    public static final String BGITEM_VARIABLE_KEY = "BGITEM_@";
    public static final String FORMULA_AUTO_CREATE_KEY = "AUTO_CREATE";

    public static void setBgItemVariable(Cell cell, boolean isFormEdit) {
        if (cell == null) {
            return;
        }
        boolean hasBgItemVariable = false;
        hasBgItemVariable = BgExpressionsParseHelper.parseExprHasBgItemVariable(cell);
        if (hasBgItemVariable) {
            cell.setUserObject(BGITEM_VARIABLE_KEY, (Object)BgNFSHelper.getExpression(cell));
        } else if (BgNFSHelper.getExpression(cell) == null || BgNFSHelper.getExpression(cell).trim().length() == 0) {
            cell.removeUserObject(BGITEM_VARIABLE_KEY);
        } else if (isFormEdit) {
            cell.removeUserObject(BGITEM_VARIABLE_KEY);
        }
    }

    public static boolean checkFormulaIsAutoCreate(Cell cell) {
        if (cell == null || cell.getFormula() == null) {
            return false;
        }
        UserObject userObject = cell.getUserObject(FORMULA_AUTO_CREATE_KEY);
        return userObject != null && userObject.getValue() != null;
    }

    public static String getBgItemVariable(Sheet sheet, Cell cell, int rowIndex, int colIndex) {
        String resultExpr = null;
        resultExpr = BgExpressionsItemVariableHelper.getBgItemVariable(cell);
        if (!StringUtils.isEmpty((String)resultExpr)) {
            return resultExpr;
        }
        Cell _cell = null;
        for (int rowBeginIndex = rowIndex - 1; rowBeginIndex >= 0; --rowBeginIndex) {
            _cell = sheet.getCell(rowBeginIndex, colIndex, false);
            if (_cell == null || StringUtils.isEmpty((String)(resultExpr = BgExpressionsItemVariableHelper.getBgItemVariable(_cell)))) continue;
            return resultExpr;
        }
        return resultExpr;
    }

    public static boolean hasBgItemVariable(Cell cell) {
        if (cell == null) {
            return false;
        }
        String espressions = BgExpressionsItemVariableHelper.getBgItemVariable(cell);
        return !StringUtils.isEmpty((String)espressions);
    }

    public static String getBgItemVariable(Cell cell) {
        if (cell == null) {
            return null;
        }
        UserObject userObj = cell.getUserObject(BGITEM_VARIABLE_KEY);
        if (userObj == null) {
            return null;
        }
        return (String)userObj.getValue();
    }

    public static String getBgItemCombinStr(Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, int[] indexes) {
        String bgItemCombinStr = "";
        String rowStr = BgExpressionsItemVariableHelper.getBgItemCombinStrByRow(sheet, rowIndex, colIndex, isFromDelete, indexes);
        String colStr = BgExpressionsItemVariableHelper.getBgItemCombinStrByCol(sheet, rowIndex, colIndex, isFromDelete, indexes);
        if (StringUtils.isEmpty((String)rowStr)) {
            bgItemCombinStr = colStr;
        } else {
            bgItemCombinStr = rowStr;
            if (!StringUtils.isEmpty((String)colStr)) {
                bgItemCombinStr = bgItemCombinStr + "," + colStr;
            }
        }
        return bgItemCombinStr;
    }

    private static String getBgItemCombinStrByRow(Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, int[] indexes) {
        StringBuffer strBuf = new StringBuffer("");
        Cell _cell = null;
        String[] str = null;
        for (int colBeginIndex = colIndex - 1; colBeginIndex >= 0; --colBeginIndex) {
            if (isFromDelete && indexes[0] == rowIndex && indexes[1] == colBeginIndex || (_cell = sheet.getCell(rowIndex, colBeginIndex, false)) == null || (str = BgNFSHelper.getBgItemInfo(_cell)) == null || str.length != 3) continue;
            strBuf.append(str[1] + ",");
        }
        String result = strBuf.toString();
        int length = result.trim().length();
        if (length > 0) {
            result = result.substring(0, length - 1);
        }
        return result;
    }

    private static String getBgItemCombinStrByCol(Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, int[] indexes) {
        StringBuffer strBuf = new StringBuffer("");
        Cell _cell = null;
        String[] str = null;
        for (int rowBeginIndex = rowIndex - 1; rowBeginIndex >= 0; --rowBeginIndex) {
            if (isFromDelete && indexes[0] == rowBeginIndex && indexes[1] == colIndex || (_cell = sheet.getCell(rowBeginIndex, colIndex, false)) == null || (str = BgNFSHelper.getBgItemInfo(_cell)) == null || str.length != 3) continue;
            strBuf.append(str[1]);
            break;
        }
        String result = strBuf.toString();
        return result;
    }

    public static void updateUserObject(Cell sourceCell, Cell targetCell, boolean isLocked) {
        if (isLocked) {
            UserObject userObject = null;
            userObject = sourceCell.getUserObject(FORMULA_AUTO_CREATE_KEY);
            Object value = null;
            if (userObject != null) {
                value = userObject.getValue();
            }
            if (value != null) {
                targetCell.setUserObject(FORMULA_AUTO_CREATE_KEY, value);
            } else if (!BgExpressionsItemVariableHelper.checkFormulaIsAutoCreate(targetCell)) {
                targetCell.removeUserObject(FORMULA_AUTO_CREATE_KEY);
            }
            String expr = BgExpressionsItemVariableHelper.getBgItemVariable(sourceCell);
            if (!StringUtils.isEmpty((String)expr)) {
                targetCell.setUserObject(BGITEM_VARIABLE_KEY, (Object)expr);
            } else {
                targetCell.removeUserObject(BGITEM_VARIABLE_KEY);
            }
        }
    }

    public static void batchRebuildExpressions(Book book, String orgUnitId, IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BgExpressionsItemVariableHelper.batchRebuildExpressions(book, orgUnitId, model, ctx, null);
    }

    public static void batchRebuildExpressions(Book book, String orgUnitId, IObjectValue model, Context ctx, Set filterSheet) throws BOSException, EASBizException {
        if (book == null || ctx == null) {
            return;
        }
        boolean isFilterSheet = false;
        if (filterSheet != null && !filterSheet.isEmpty()) {
            isFilterSheet = true;
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet _sheet = null;
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (isFilterSheet && !filterSheet.contains(BgNFSHelper.getSheetSign(_sheet))) continue;
            int rowCount = _sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = _sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    BgExpressionsItemVariableHelper.buildExpressionsByCurrCell(_sheet, rowIndex, colIndex, false, true, model);
                }
            }
        }
        try {
            BgNTemplateHelper.dealWith(book, orgUnitId, new HashMap(), true, false, true, true, ctx, filterSheet);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public static void batchRemoveUserObject(Book book) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                int colCount = _sheet.getMaxColIndex();
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (_cell == null) continue;
                    _cell.removeUserObject(FORMULA_AUTO_CREATE_KEY);
                    _cell.removeUserObject(BGITEM_VARIABLE_KEY);
                    if (!BgExpressionsParseHelper.parseExprHasBgItemVariable(_cell)) continue;
                    _cell.setFormula(null);
                    _cell.removeUserObject("CELL_DATA");
                }
            }
        }
    }

    public static void rebuildExpressions(NotifyEvent evt, IObjectValue model) {
        Book book = ((SpreadContext)evt.getSource()).getBook();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet sheet = book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        CellBlock _block = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        Range _blocks = sheet.getSelectionRange();
        if (_blocks == null || _blocks.size() == 0) {
            return;
        }
        String[] str = null;
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    if (_cell == null || (str = BgNFSHelper.getBgItemInfo(_cell)) == null || str.length != 3) continue;
                    try {
                        BgExpressionsItemVariableHelper.buildExpressionsByCurrCell(sheet, rowBegin, colBegin, true, false, model);
                        continue;
                    }
                    catch (EASBizException e) {
                        SysUtil.abort((Throwable)e);
                        continue;
                    }
                    catch (BOSException e) {
                        SysUtil.abort((Throwable)e);
                    }
                }
            }
        }
    }

    public static void autoBuildExpressions(Sheet sheet, SortedCellBlockArray _blocks, IObjectValue model) throws BOSException, EASBizException {
        if (sheet == null) {
            return;
        }
        CellBlock _block = null;
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        String[] str = null;
        if (_blocks == null || _blocks.size() == 0) {
            return;
        }
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    if (_cell == null || (str = BgNFSHelper.getBgItemInfo(_cell)) == null || str.length != 3) continue;
                    BgExpressionsItemVariableHelper.buildExpressionsByCurrCell(sheet, rowBegin, colBegin, false, false, model);
                }
            }
        }
    }

    public static boolean checkRowHasBgItemVariable(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0) {
            return false;
        }
        Cell _cell = null;
        int maxColIndex = sheet.getMaxColIndex();
        for (int colIndex = 0; colIndex <= maxColIndex; ++colIndex) {
            _cell = sheet.getActualCell(rowIndex, colIndex);
            if (_cell == null || !BgExpressionsItemVariableHelper.hasBgItemVariable(_cell)) continue;
            return true;
        }
        return false;
    }

    private static void buildExpressionsByCurrCell(Sheet sheet, int rowIndex, int colIndex, boolean isFromDelete, boolean isFromUpdate, IObjectValue model) throws BOSException, EASBizException {
        if (sheet == null) {
            return;
        }
        int maxColIndex = sheet.getMaxColIndex();
        Cell _cell = null;
        String expressions = null;
        String itemCombinStr = null;
        int beginColIndex = 0;
        String companyNumber = BgNExpressionHelper.getCompanyNumber(null, model);
        for (beginColIndex = isFromUpdate ? colIndex : colIndex + 1; beginColIndex <= maxColIndex; ++beginColIndex) {
            String[] itemStrs;
            _cell = sheet.getCell(rowIndex, beginColIndex, false);
            boolean hasItemVariable = BgExpressionsParseHelper.parseExprHasBgItemVariable(_cell);
            if (!BgExpressionsItemVariableHelper.checkFormulaIsAutoCreate(_cell) && BgNFSHelper.checkHasExpression(_cell) && !hasItemVariable || StringUtils.isEmpty((String)(expressions = BgExpressionsItemVariableHelper.getBgItemVariable(sheet, _cell, rowIndex, beginColIndex)))) continue;
            itemCombinStr = BgExpressionsItemVariableHelper.getBgItemCombinStr(sheet, rowIndex, beginColIndex, isFromDelete, new int[]{rowIndex, colIndex});
            if (!StringUtils.isEmpty((String)itemCombinStr) && (itemStrs = itemCombinStr.split(",")) != null && itemStrs.length > 1) {
                HashMap bgItemCombinMap = new HashMap();
                bgItemCombinMap.put(itemCombinStr, null);
                IBgFormulaFacade iBgF = BgFormulaFacadeFactory.getRemoteInstance();
                bgItemCombinMap = iBgF.batchParseBgItemCombi(bgItemCombinMap, SysContext.getSysContext().getCurrentCostUnit().getId().toString());
                Object[] res = (Object[])bgItemCombinMap.get(itemCombinStr);
                if (res[0] != null) {
                    itemCombinStr = (String)res[0];
                }
            }
            if (StringUtils.isEmpty((String)itemCombinStr)) {
                String tmpExpr = BgExpressionsItemVariableHelper.getBgItemVariable(_cell);
                if (!StringUtils.isEmpty((String)tmpExpr)) {
                    if (!_cell.setFormula(tmpExpr)) continue;
                    BgNFSHelper.checkExpression(_cell, model, companyNumber);
                    BgNFSHelper.saveExpression(_cell, tmpExpr, 0);
                    BgNFSHelper.saveExpression(_cell, tmpExpr, 1);
                    BgNFSHelper.saveExpression(_cell, tmpExpr, 2);
                    continue;
                }
                if (_cell == null) continue;
                _cell.setFormula(null);
                _cell.removeUserObject("CELL_DATA");
                continue;
            }
            if (StringUtils.isEmpty((String)(expressions = BgExpressionsParseHelper.processExprForBgItemCombin(expressions, new HashMap(), false, itemCombinStr, null, null)))) continue;
            boolean isAutoCreate = BgExpressionsItemVariableHelper.checkFormulaIsAutoCreate(_cell);
            if (isFromUpdate && isAutoCreate) {
                if (_cell.setFormula(expressions)) {
                    BgNFSHelper.saveExpression(_cell, expressions, 0);
                    BgNFSHelper.saveExpression(_cell, expressions, 1);
                    BgNFSHelper.saveExpression(_cell, expressions, 2);
                }
            } else if (!isFromDelete && !isFromUpdate) {
                if (_cell == null) {
                    _cell = sheet.getCell(rowIndex, beginColIndex, true);
                }
                if (_cell.setFormula(expressions)) {
                    BgNFSHelper.saveExpression(_cell, expressions, 0);
                    BgNFSHelper.saveExpression(_cell, expressions, 1);
                    BgNFSHelper.saveExpression(_cell, expressions, 2);
                }
                _cell.setUserObject(FORMULA_AUTO_CREATE_KEY, (Object)FORMULA_AUTO_CREATE_KEY);
            } else if (isFromDelete && isAutoCreate && _cell.setFormula(expressions)) {
                BgNFSHelper.saveExpression(_cell, expressions, 0);
                BgNFSHelper.saveExpression(_cell, expressions, 1);
                BgNFSHelper.saveExpression(_cell, expressions, 2);
            }
            BgNFSHelper.checkExpression(_cell, model, companyNumber);
        }
        beginColIndex = 0;
        if (!isFromDelete) {
            return;
        }
        Cell currCell = sheet.getCell(rowIndex, colIndex, false);
        int maxRowIndex = sheet.getMaxRowIndex();
        for (int beginRowIndex = rowIndex + 1; beginRowIndex <= maxRowIndex; ++beginRowIndex) {
            _cell = sheet.getCell(beginRowIndex, colIndex, false);
            if (_cell == null || BgExpressionsParseHelper.parseExprHasBgItemVariable(_cell) || BgNFSHelper.getExpression(currCell) == null || !BgExpressionsItemVariableHelper.checkFormulaIsAutoCreate(_cell) && BgNFSHelper.checkHasExpression(_cell) || StringUtils.isEmpty((String)(expressions = BgExpressionsItemVariableHelper.getBgItemVariable(sheet, _cell, beginRowIndex, colIndex)))) continue;
            itemCombinStr = BgExpressionsItemVariableHelper.getBgItemCombinStr(sheet, beginRowIndex, colIndex, isFromDelete, new int[]{rowIndex, colIndex});
            if (StringUtils.isEmpty((String)itemCombinStr)) {
                String tmpExpr = BgExpressionsItemVariableHelper.getBgItemVariable(_cell);
                if (!StringUtils.isEmpty((String)tmpExpr)) {
                    _cell.setFormula(tmpExpr);
                    continue;
                }
                _cell.setFormula(null);
                continue;
            }
            if (StringUtils.isEmpty((String)(expressions = BgExpressionsParseHelper.processExprForBgItemCombin(expressions, new HashMap(), false, itemCombinStr, null, null)))) continue;
            if (!isFromDelete) {
                _cell.setFormula(expressions);
                _cell.setUserObject(FORMULA_AUTO_CREATE_KEY, (Object)FORMULA_AUTO_CREATE_KEY);
                continue;
            }
            if (!isFromDelete || !BgExpressionsItemVariableHelper.checkFormulaIsAutoCreate(_cell)) continue;
            _cell.setFormula(expressions);
        }
    }

    public static void dealWithBgItemVariable(Sheet sheet, boolean isFormEdit) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        CellBlock _block = null;
        Range _blocks = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        _blocks = sheet.getSelectionRange();
        int size = _blocks.size();
        for (int index = 0; index < size; ++index) {
            _block = _blocks.getBlock(index);
            if (_block == null) {
                return;
            }
            int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
            int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
            int _rowBegin = _block.getRow();
            int _rowEnd = maxRow;
            int _colBegin = _block.getCol();
            int _colEnd = maxCol;
            int rowEnd = _rowEnd;
            for (int rowBegin = _rowBegin; rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = _colEnd;
                for (int colBegin = _colBegin; colBegin <= colEnd; ++colBegin) {
                    _cell = sheet.getCell(rowBegin, colBegin, false);
                    if (_cell == null) continue;
                    BgExpressionsItemVariableHelper.setBgItemVariable(_cell, isFormEdit);
                }
            }
        }
    }
}

