/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgXMLImportOrExportFactory;
import com.kingdee.eas.ma.nbudget.BgXMLImportOrExportInfo;
import com.kingdee.eas.util.client.EASResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class BgFormImportHelper {
    public static final String importAndExportResource = "com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource";
    private static final Logger logger = Logger.getLogger((String)BgFormImportHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Book importToBookForSinge(Book srcBook, BgFormInfo bgFormInfo, String fileName) throws Exception {
        XMLParser parser = new XMLParser();
        Document doc = null;
        try (InputStream in = null;){
            in = new FileInputStream(new File(fileName));
            doc = XMLParser.parseXML((InputStream)in);
        }
        Element root = doc.getRootElement();
        String bgTemplateID = root.getChild("BgTemplateID").getAttributeValue("value");
        String idElement = root.getChild("ID").getAttributeValue("value");
        BgTemplateInfo templateInfo = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgTemplate().getId()));
        BgTemplateInfo srcTemplateInfo = null;
        try {
            srcTemplateInfo = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateID));
        }
        catch (ObjectNotFoundException e) {
            String importError = EASResource.getString((String)importAndExportResource, (String)"noExist_bgTemplate");
            throw new BOSException(importError);
        }
        String parentTemplateID = templateInfo.getRootId().toString();
        String srcParentTemplateID = srcTemplateInfo.getRootId().toString();
        if (!parentTemplateID.equals(srcParentTemplateID)) {
            String importError = EASResource.getString((String)importAndExportResource, (String)"exportError");
            throw new BOSException(importError);
        }
        boolean isEnumerate = BgTemFormTypeEnum.ENUMERATEFORM.equals((Object)templateInfo.getFormType());
        BgXMLImportOrExportInfo xmlInfo = (BgXMLImportOrExportInfo)BgXMLImportOrExportFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(idElement));
        Book book = xmlInfo.getBook();
        Sheet sheet = null;
        if (srcBook.getSheetCount() != book.getSheetCount()) {
            String importError = EASResource.getString((String)importAndExportResource, (String)"exportError_sheetcountError");
            throw new BOSException(importError);
        }
        HashMap bgItemMap = new HashMap();
        HashMap<String, Map> areaMap = new HashMap<String, Map>();
        if (isEnumerate) {
            Sheet tmpSheet = null;
            for (int i = 0; i < book.getSheetCount(); ++i) {
                tmpSheet = book.getSheet(i);
                areaMap.put(tmpSheet.getID(), BgFormImportHelper.getEnumArea(book, i));
            }
        }
        String _orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String orgUnitId = BgSHelper.getIsolateOrg((String)_orgUnitId);
        String oql = "select number where orgUnit = '" + orgUnitId + "'";
        BgItemCollection coll = BgItemFactory.getRemoteInstance().getBgItemCollection(oql);
        if (coll != null) {
            com.kingdee.eas.ma.budget.BgItemInfo itemInfo = null;
            for (int i = 0; i < coll.size(); ++i) {
                itemInfo = coll.get(i);
                bgItemMap.put(itemInfo.getNumber(), null);
            }
        }
        Cell cell = null;
        String[] formulaPara = null;
        String formulaString = null;
        Map areaItemMap = null;
        String sheetID = null;
        boolean hasSetFormula = false;
        String[] fals = null;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            for (int row = 0; row < sheet.getMaxRowIndex() + 1; ++row) {
                for (int col = 0; col < sheet.getMaxColIndex() + 1; ++col) {
                    cell = sheet.getCell(row, col, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell(cell);
                    formulaPara = BgNFSHelper.parseFormulaPara(formulaString);
                    sheetID = cell.getSheet().getID();
                    areaItemMap = (Map)areaMap.get(sheetID);
                    if (formulaPara[0].indexOf(",") >= 0) {
                        hasSetFormula = false;
                        fals = formulaPara[0].split(",");
                        for (int j = 0; j < fals.length; ++j) {
                            if (areaItemMap == null || areaItemMap.isEmpty()) {
                                if (!bgItemMap.containsKey(fals[j])) continue;
                                hasSetFormula = true;
                                break;
                            }
                            if (!areaItemMap.containsKey(fals[j])) continue;
                            hasSetFormula = true;
                            break;
                        }
                        if (hasSetFormula) continue;
                        BgNFSHelper.clearFormulaOfCell(cell);
                        continue;
                    }
                    hasSetFormula = false;
                    if (areaItemMap == null || areaItemMap.isEmpty()) {
                        if (bgItemMap.containsKey(formulaPara[0])) {
                            hasSetFormula = true;
                        }
                    } else if (areaItemMap.containsKey(formulaPara[0])) {
                        hasSetFormula = true;
                    }
                    if (hasSetFormula) continue;
                    BgNFSHelper.clearFormulaOfCell(cell);
                }
            }
        }
        return book;
    }

    private static Map getEnumArea(Book book, int index) {
        HashMap<Object, Object> bgItemMap = new HashMap<Object, Object>();
        Map area = BgFormImportHelper.getSelectEnumArea(book, index);
        if (area == null) {
            return null;
        }
        BgEnumerateInfo enumInfo = new BgEnumerateInfo(area, book.getSheet(index), true, false);
        Map itemMap = enumInfo.getItemS();
        if (itemMap != null) {
            Object key2 = null;
            Set set = null;
            Object[] objs = null;
            for (Object key2 : itemMap.keySet()) {
                set = (Set)itemMap.get(key2);
                if (set == null) continue;
                objs = set.toArray();
                for (int i = 0; i < objs.length; ++i) {
                    bgItemMap.put(objs[i], null);
                }
            }
        }
        return bgItemMap;
    }

    public SelectorItemCollection getTemplateSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("parent.*"));
        return selector;
    }

    public static String getBgItemFilterOql(List cellList) {
        StringBuffer oql = new StringBuffer();
        CellInfo info = null;
        for (int i = 0; i < cellList.size(); ++i) {
            info = (CellInfo)cellList.get(i);
            if (info.getItemFormula() == null) continue;
            String formula = info.getItemFormula();
            String[] param = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = param[0];
            int index = itemNumber.indexOf(",");
            if (index >= 0) {
                String[] arr = itemNumber.split(",");
                for (int j = 0; j < arr.length; ++j) {
                    oql.append("'").append(arr[j]).append("',");
                }
                continue;
            }
            oql.append("'").append(itemNumber).append("',");
        }
        return oql.toString().substring(0, oql.length() - 1);
    }

    public static Map getSelectEnumArea(Book book, int sheetIndex) {
        UserObject areaObject;
        Sheet sheet = book.getSheet(sheetIndex);
        Range range = sheet.getRange(sheet.getMaxRowIndex(), sheet.getMaxColIndex());
        int selRow = -1;
        int selCol = -1;
        if (range.size() > 0) {
            CellBlock block = range.getBlock(0);
            selRow = block.getRow() > sheet.getMaxRowIndex() ? sheet.getMaxRowIndex() : block.getRow();
            int n = selCol = block.getCol() > sheet.getMaxColIndex() ? sheet.getMaxColIndex() : block.getCol();
        }
        if ((areaObject = book.getUserObject("EnumerAteArea")) == null) {
            return null;
        }
        Cell cell = null;
        String objKey = null;
        Map areaMap = null;
        Map selMap = null;
        BgEnumerateInfo info = null;
        for (int i = selRow; i >= 0; --i) {
            for (int j = selCol; j >= 0; --j) {
                cell = sheet.getCell(i, j, false);
                if (cell == null || cell.getUserObject("BeginCell") == null || cell.getUserObject("BeginCell").getValue() == null) continue;
                UserObject obj = cell.getUserObject("BeginCell");
                if (!(obj.getValue() instanceof String)) {
                    return null;
                }
                objKey = (String)obj.getValue();
                areaMap = (Map)BgAnalyseHelper.getObject((byte[])Base64.decode((String)((String)areaObject.getValue())));
                if (areaMap.get(sheet.getID().toString()) != null && ((Map)areaMap.get(sheet.getID().toString())).get(objKey) != null) {
                    selMap = (Map)((Map)areaMap.get(sheet.getID().toString())).get(objKey);
                    if (selMap != null && selRow <= (info = new BgEnumerateInfo(selMap, sheet, true, true)).getRowEnd() && selCol <= info.getColEnd()) {
                        return selMap;
                    }
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    private static List extractXMLData(Element rootElement) {
        ArrayList<CellInfo> list = new ArrayList<CellInfo>();
        if (rootElement == null) {
            return list;
        }
        CellInfo cellInfo = null;
        List elements = rootElement.getChildren("Cell");
        Element e = null;
        for (int i = 0; i < elements.size(); ++i) {
            e = (Element)elements.get(i);
            if (e == null) continue;
            cellInfo = new CellInfo(e);
            list.add(cellInfo);
        }
        return list;
    }

    static class BgItemInfo {
        private String value = null;
        private String bgFillType = null;
        private String bgFillValue = null;
        private String bgFillValue_ItemID = null;

        public BgItemInfo(String value, String bgFillType, String bgFillValue, String bgFillValue_ItemID) {
            this.value = value;
            this.bgFillType = bgFillType;
            this.bgFillValue = bgFillValue;
            this.bgFillValue_ItemID = bgFillValue_ItemID;
        }

        public String getBgFillValue_ItemID() {
            return this.bgFillValue_ItemID;
        }

        public void setBgFillValue_ItemID(String bgFillValue_ItemID) {
            this.bgFillValue_ItemID = bgFillValue_ItemID;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getBgFillType() {
            return this.bgFillType;
        }

        public void setBgFillType(String bgFillType) {
            this.bgFillType = bgFillType;
        }

        public String getBgFillValue() {
            return this.bgFillValue;
        }

        public void setBgFillValue(String bgFillValue) {
            this.bgFillValue = bgFillValue;
        }
    }

    static class CellInfo {
        private Element element = null;
        private int row = -1;
        private int col = -1;
        private Object value = null;
        private String itemFormula = null;
        private String expression = null;
        private BgItemInfo bgItemInfo = null;

        public CellInfo(Element element) {
            this.element = element;
            this.parseCell();
        }

        public void parseCell() {
            if (this.element == null || !"Cell".equals(this.element.getName())) {
                return;
            }
            Element tmpElement = null;
            this.value = this.element.getAttributeValue("value");
            this.row = Integer.valueOf(this.element.getAttributeValue("row"));
            this.col = Integer.valueOf(this.element.getAttributeValue("col"));
            tmpElement = this.element.getChild("BgItem");
            if (tmpElement != null) {
                String bgItemValue = tmpElement.getAttributeValue("value");
                String bgItemFillType = tmpElement.getAttributeValue("bgFillType");
                String bgItemFillValue = tmpElement.getAttributeValue("bgFillValue");
                String bgItemFillValue_ItemID = tmpElement.getAttributeValue("bgFillValue_itemId");
                this.bgItemInfo = new BgItemInfo(bgItemValue, bgItemFillType, bgItemFillValue, bgItemFillValue_ItemID);
            }
            if ((tmpElement = this.element.getChild("BgFormula")) != null) {
                this.itemFormula = tmpElement.getAttributeValue("value");
            }
            if ((tmpElement = this.element.getChild("Expression")) != null) {
                String exp;
                this.expression = exp = tmpElement.getAttributeValue("value");
            }
        }

        public Element getElement() {
            return this.element;
        }

        public void setElement(Element element) {
            this.element = element;
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getItemFormula() {
            return this.itemFormula;
        }

        public void setItemFormula(String itemFormula) {
            this.itemFormula = itemFormula;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public BgItemInfo getBgItemInfo() {
            return this.bgItemInfo;
        }

        public void setBgItemInfo(BgItemInfo bgItemInfo) {
            this.bgItemInfo = bgItemInfo;
        }
    }
}

