/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgPermission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPermissionHelper {
    private static final Logger logger = Logger.getLogger(BgPermissionHelper.class);
    private static final String nullID = "000000000000000000000000000=";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterInfo addBgSchemePermission(String userId, Set orgUnits, FilterInfo filter) {
        if (userId == null) return null;
        if (filter == null) {
            return null;
        }
        if (orgUnits == null) {
            return filter;
        }
        boolean isContinue = false;
        try {
            isContinue = BgPermissionHelper.getIBgPermission(null).isLimitedPermissionUse(userId);
            if (!BgSHelper.isBgTemplatePerimissionForUse()) return BgPermissionHelper.dealSchemePermission(userId, orgUnits, filter);
            if (!isContinue) return filter;
            return BgPermissionHelper.dealSchemePermission(userId, orgUnits, filter);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            return filter;
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        return filter;
    }

    private static FilterInfo dealSchemePermission(String userId, Set orgUnits, FilterInfo filter) throws BOSException, EASBizException {
        int perNum = 0;
        HashSet<String> schPer = BgPermissionHelper.getIBgPermission(null).getBgSchemePermission(userId, orgUnits);
        if (schPer == null || schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        FilterItemInfo item = new FilterItemInfo("id".toLowerCase(), schPer, CompareType.INCLUDE);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item, perNum);
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterInfo addBgSchemePermission(Context ctx, String userId, Set<String> orgUnits, FilterInfo filter) {
        if (userId == null) return null;
        if (filter == null) {
            return null;
        }
        if (orgUnits == null) {
            return filter;
        }
        try {
            boolean isContinue = false;
            isContinue = BgPermissionHelper.getIBgPermission(ctx).isLimitedPermissionUse(userId);
            if (!BgSHelper.isBgTemplatePerimissionForUse((Context)ctx)) return BgPermissionHelper.dealSchemePermission(ctx, userId, orgUnits, filter);
            if (!isContinue) return filter;
            return BgPermissionHelper.dealSchemePermission(ctx, userId, orgUnits, filter);
        }
        catch (EASBizException ex) {
            logger.error((Object)ex);
            return filter;
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        return filter;
    }

    private static FilterInfo dealSchemePermission(Context ctx, String userId, Set orgUnits, FilterInfo filter) throws BOSException, EASBizException {
        int perNum = 0;
        HashSet<String> schPer = BgPermissionHelper.getIBgPermission(ctx).getBgSchemePermission(userId, orgUnits);
        if (schPer == null || schPer.isEmpty()) {
            schPer = new HashSet<String>();
            schPer.add(nullID);
        }
        FilterItemInfo item = new FilterItemInfo("id".toLowerCase(), schPer, CompareType.INCLUDE);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item, perNum);
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterInfo addBgTemplatePermission(String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null) return null;
        if (filter == null) {
            return null;
        }
        boolean isContinue = false;
        try {
            isContinue = BgPermissionHelper.getIBgPermission(null).isLimitedPermissionUse(userId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (!BgSHelper.isBgTemplatePerimissionForUse()) return BgPermissionHelper.getTemplatePerimissionOfUse(userId, permissionOrg, filter);
        if (!isContinue) return filter;
        return BgPermissionHelper.getTemplatePerimissionOfUse(userId, permissionOrg, filter);
    }

    private static FilterInfo getTemplatePerimissionOfUse(String userId, Set permissionOrg, FilterInfo filter) {
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSql(null, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterInfo addBgTemplatePermission(Context ctx, String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null) return null;
        if (filter == null) {
            return null;
        }
        boolean isContinue = false;
        try {
            isContinue = BgPermissionHelper.getIBgPermission(ctx).isLimitedPermissionUse(userId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (!BgSHelper.isBgTemplatePerimissionForUse((Context)ctx)) return BgPermissionHelper.getTemplatePerimissionOfUse(ctx, userId, permissionOrg, filter);
        if (!isContinue) return filter;
        return BgPermissionHelper.getTemplatePerimissionOfUse(ctx, userId, permissionOrg, filter);
    }

    private static FilterInfo getTemplatePerimissionOfUse(Context ctx, String userId, Set permissionOrg, FilterInfo filter) {
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSql(ctx, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    private static String getTemSql(Context ctx, String userId, Set permissionOrg) {
        String sql = null;
        try {
            sql = ctx == null ? BgPermissionFactory.getRemoteInstance().getBgPermissionSqlLong(userId, permissionOrg) : BgPermissionFactory.getLocalInstance((Context)ctx).getBgPermissionSqlLong(userId, permissionOrg);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            sql = null;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            sql = null;
        }
        if (sql == null || sql.length() == 0) {
            sql = "select fid from t_bg_bgtemplate where fid = '000000000000000000000000000='";
        }
        return sql;
    }

    private static String getTemSqlWithForm(Context ctx, String userId, Set permissionOrg) {
        String sql = null;
        try {
            sql = ctx == null ? BgPermissionFactory.getRemoteInstance().getBgPermissionSqlLongForForm(userId, permissionOrg) : BgPermissionFactory.getLocalInstance((Context)ctx).getBgPermissionSqlLongForForm(userId, permissionOrg);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            sql = null;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            sql = null;
        }
        if (sql == null || sql.length() == 0) {
            sql = "select fid from t_bg_bgtemplate where fid = '000000000000000000000000000='";
        }
        return sql;
    }

    public static boolean isNeedDealBG02201(Context ctx, String userId) {
        boolean isContinue = false;
        try {
            isContinue = BgPermissionHelper.getIBgPermission(ctx).isLimitedPermissionUse(userId);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return isContinue;
    }

    public static boolean isNeedDealBG02201(String userId) {
        boolean isContinue = false;
        try {
            isContinue = BgPermissionHelper.getIBgPermission(null).isLimitedPermissionUse(userId);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return isContinue;
    }

    public static FilterInfo addBgFormPermission(String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null || filter == null) {
            return null;
        }
        if (BgSHelper.isBgTemplatePerimissionForUse() && !BgPermissionHelper.isNeedDealBG02201(userId)) {
            return filter;
        }
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSqlWithForm(null, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("bgTemplate.id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        Set schSet = BgPermissionHelper.getSchemeWithForm(null, userId, permissionOrg);
        if (schSet != null && !schSet.isEmpty()) {
            FilterItemInfo item2 = new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)schSet, CompareType.INCLUDE);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        } else {
            FilterItemInfo item2 = new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)nullID, CompareType.EQUALS);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        }
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    private static Set getSchemeWithForm(Context ctx, String userId, Set permissionOrg) {
        Set schemeIds = new HashSet();
        try {
            schemeIds = ctx == null ? BgPermissionFactory.getRemoteInstance().getBgSchemePermission(userId, permissionOrg) : BgPermissionFactory.getLocalInstance((Context)ctx).getBgSchemePermission(userId, permissionOrg);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            schemeIds = null;
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            schemeIds = null;
        }
        return schemeIds;
    }

    public static FilterInfo addBgFormPermission(Context ctx, String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null || filter == null) {
            return null;
        }
        if (!BgSHelper.isBgPermissionUsed()) {
            return filter;
        }
        if (BgSHelper.isBgTemplatePerimissionForUse((Context)ctx) && !BgPermissionHelper.isNeedDealBG02201(ctx, userId)) {
            return filter;
        }
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSqlWithForm(ctx, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("bgTemplate.id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        Set schSet = BgPermissionHelper.getSchemeWithForm(ctx, userId, permissionOrg);
        if (schSet != null && !schSet.isEmpty()) {
            FilterItemInfo item2 = new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)schSet, CompareType.INCLUDE);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        } else {
            FilterItemInfo item2 = new FilterItemInfo("bgScheme.id".toLowerCase(), (Object)nullID, CompareType.EQUALS);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        }
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    public static FilterInfo addBgFormPermissionFormActualRecord(String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null || filter == null) {
            return null;
        }
        if (BgSHelper.isBgTemplatePerimissionForUse() && !BgPermissionHelper.isNeedDealBG02201(userId)) {
            return filter;
        }
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSqlWithForm(null, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("bgform.bgTemplate.id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        Set schSet = BgPermissionHelper.getSchemeWithForm(null, userId, permissionOrg);
        if (schSet != null && !schSet.isEmpty()) {
            FilterItemInfo item2 = new FilterItemInfo("bgform.bgScheme.id".toLowerCase(), (Object)schSet, CompareType.INCLUDE);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        } else {
            FilterItemInfo item2 = new FilterItemInfo("bgform.bgScheme.id".toLowerCase(), (Object)nullID, CompareType.EQUALS);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        }
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    public static FilterInfo addBgFormPermissionForDec(String userId, Set permissionOrg, FilterInfo filter) {
        if (userId == null || filter == null) {
            return null;
        }
        if (BgSHelper.isBgTemplatePerimissionForUse() && !BgPermissionHelper.isNeedDealBG02201(userId)) {
            return filter;
        }
        int perNum = 0;
        String temSql = BgPermissionHelper.getTemSqlWithForm(null, userId, permissionOrg);
        FilterItemInfo item1 = new FilterItemInfo("bgForm.bgTemplate.id".toLowerCase(), (Object)temSql, CompareType.INNER);
        perNum = BgPermissionHelper.replaceFilterItems(filter, item1, perNum);
        Set schSet = BgPermissionHelper.getSchemeWithForm(null, userId, permissionOrg);
        if (schSet != null && !schSet.isEmpty()) {
            FilterItemInfo item2 = new FilterItemInfo("bgForm.bgScheme.id".toLowerCase(), (Object)schSet, CompareType.INCLUDE);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        } else {
            FilterItemInfo item2 = new FilterItemInfo("bgForm.bgScheme.id".toLowerCase(), (Object)nullID, CompareType.EQUALS);
            perNum = BgPermissionHelper.replaceFilterItems(filter, item2, perNum);
        }
        BgPermissionHelper.addUserPermission(userId, filter);
        filter = BgPermissionHelper.setMarkStringForForm(filter, perNum);
        return filter;
    }

    public static FilterInfo setMarkStringForForm(FilterInfo filter, int perNum) {
        if (perNum == 0) {
            return filter;
        }
        String filterMark = filter.getMaskString();
        String markString = "";
        if (filterMark == null || filterMark.trim().equals("")) {
            markString = "(";
            for (int i = 0; i < perNum; ++i) {
                markString = markString + " #" + i + " and ";
            }
            markString = markString.substring(0, markString.length() - 4);
            markString = markString + ") or #" + perNum;
            filter.setMaskString(markString);
        } else {
            markString = "((";
            for (int i = perNum; i > 0; --i) {
                markString = markString + " #" + (filter.getFilterItems().size() - i - 1) + " and ";
            }
            markString = markString.substring(0, markString.length() - 4);
            markString = markString + ") or #" + (filter.getFilterItems().size() - 1);
            markString = markString + ") ";
            filter.setMaskString(filterMark + " and " + markString);
        }
        return filter;
    }

    public static int replaceFilterItems(FilterInfo filter, FilterItemInfo item, int perNum) {
        if (filter == null || item == null) {
            return -1;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                ++perNum;
                fiCol.add(item);
            }
        }
        return perNum;
    }

    private static void addUserPermission(String userId, FilterInfo filter) {
        FilterItemInfo item = new FilterItemInfo("creator.id".toLowerCase(), (Object)userId, CompareType.INCLUDE);
        BgPermissionHelper.replaceFilterItemsForOR(filter, item);
    }

    private static void replaceFilterItemsForOR(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
            }
            if (!isReplace) {
                fiCol.add(item);
            }
        }
    }

    private static IBgPermission getIBgPermission(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgPermissionFactory.getRemoteInstance();
        }
        return BgPermissionFactory.getLocalInstance((Context)ctx);
    }

    public static Map getBgTemplateSheetPermission(Context ctx, Map templateIds) throws EASBizException, BOSException {
        templateIds = BgPermissionHelper.getIBgPermission(ctx).getTemplateSheetName(templateIds);
        return templateIds;
    }

    public static Map getBgFormSheetPermission(Context ctx, Map formIds) throws EASBizException, BOSException {
        formIds = BgPermissionHelper.getIBgPermission(ctx).getBgFormSheetName(formIds);
        return formIds;
    }
}

