/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgFormSpecialEditUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class BgSpecialFormDisplayValueProvider
implements IDisplayValueProvider {
    private static String BGFORMULA = "bgformula";
    private static String BGACTUALS = "bgactuals";
    private static String BGBALANCE = "bgbal";
    private BgFormSpecialEditUI ui = null;
    private Map measureUnitMap = null;
    private Map currencyMap = null;
    private Map formulaMap = null;
    private BigDecimal coefficient = null;
    private int precision = 0;

    public BgSpecialFormDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgFormSpecialEditUI) {
            this.ui = (BgFormSpecialEditUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        if (this.coefficient != null) {
            return this.coefficient;
        }
        if (this.ui.getBgFormInfo() != null && this.ui.getBgFormInfo().getMeasureUnit() != null) {
            this.coefficient = this.ui.getBgFormInfo().getMeasureUnit().getCoefficient();
            return this.coefficient;
        }
        return BgNConstants.ONE;
    }

    public int getPrecision() {
        if (this.precision != 0) {
            return this.precision;
        }
        this.precision = 3;
        if (this.ui.getBgFormInfo() != null && this.ui.getBgFormInfo().getCurrency() != null) {
            this.precision = this.ui.getBgFormInfo().getCurrency().getPrecision();
            return this.precision;
        }
        return this.precision;
    }

    public Map getMeasureUnitMap() {
        if (this.measureUnitMap != null) {
            return this.measureUnitMap;
        }
        if (this.ui.getMeasureUnitMap() != null) {
            this.measureUnitMap = this.ui.getMeasureUnitMap();
        }
        if (this.measureUnitMap == null) {
            this.measureUnitMap = new HashMap();
        }
        return this.measureUnitMap;
    }

    public Map getCurrencyMap() {
        if (this.currencyMap != null) {
            return this.currencyMap;
        }
        if (this.ui.getCurrencyMap() != null) {
            this.currencyMap = this.ui.getCurrencyMap();
        }
        if (this.currencyMap == null) {
            this.currencyMap = new HashMap();
        }
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        if (this.formulaMap != null) {
            return this.formulaMap;
        }
        if (this.ui.getFormulaMap() != null) {
            this.formulaMap = this.ui.getFormulaMap();
        }
        if (this.formulaMap == null) {
            this.formulaMap = new HashMap();
        }
        return this.formulaMap;
    }

    public void clearAll() {
        if (this.currencyMap != null) {
            this.currencyMap.clear();
            this.currencyMap = null;
        }
        if (this.formulaMap != null) {
            this.formulaMap.clear();
            this.formulaMap = null;
        }
        if (this.measureUnitMap != null) {
            this.measureUnitMap.clear();
            this.measureUnitMap = null;
        }
        this.coefficient = null;
        this.precision = 0;
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        Object obj = cell.getValue().getValue();
                        if (BgNFSHelper.checkHasPercentage(cell)) {
                            return cell.getText();
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                        }
                        if (BgNFSHelper.checkHasExpression(cell)) {
                            return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, obj);
                    }
                }
            } else if (viewMode == 1) {
                Object obj;
                if (cell.hasFormula()) {
                    return cell.getFormula();
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell) && (obj = cell.getValue().getValue()) != null) {
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                    }
                    if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, obj, true);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, obj);
                }
            } else if (viewMode == 10) {
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.getFormulaMap());
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    Object obj = cell.getValue().getValue();
                    if (BgNFSHelper.checkHasExpression(cell)) {
                        return this.getFormulaMeasureUnitDisplayValue(cell, obj);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, obj);
                }
            }
        }
        return null;
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[3]) && this.getCurrencyMap().containsKey(_parameter[3])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[3]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getFormulaMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        Expression _expression = null;
        Object _obj = null;
        String _expressions = cell.getFormula();
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception ex) {
            _obj = obj;
        }
        _obj = this.getFormulaMeasureUnitDisplayValue(_expression, cell, obj);
        if (_obj == null) {
            _obj = this.getDefMeasureUnitDisplayValue(cell, obj);
        }
        return _obj;
    }

    protected Object getFormulaMeasureUnitDisplayValue(Expression expression, Cell cell, Object obj) {
        if (expression == null) {
            return null;
        }
        Object _obj = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        if (expression instanceof FunctionExpr) {
            String _funcionName = ((FunctionExpr)expression).funcionName;
            if (BGFORMULA.equalsIgnoreCase(_funcionName) || BGACTUALS.equalsIgnoreCase(_funcionName) || BGBALANCE.equalsIgnoreCase(_funcionName)) {
                StringExpr _bgelement = (StringExpr)((FunctionExpr)expression).parameters.get(2);
                StringExpr _currency = (StringExpr)((FunctionExpr)expression).parameters.get(4);
                if (this.getMeasureUnitMap().containsKey(_bgelement.value)) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_bgelement.value);
                }
                if (this.getCurrencyMap().containsKey(_currency.value)) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_currency.value);
                    _precision = _currencyInfo.getPrecision();
                }
                _obj = this.getDisplayValue(obj, _coefficient, _precision);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).left, cell, obj);
            if (obj == null) {
                _obj = this.getFormulaMeasureUnitDisplayValue(((BinaryOperationExpr)expression).right, cell, obj);
            }
        }
        return _obj;
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return cell.getText();
        }
        if ("0".equals(obj.toString()) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

