/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.nbudget.BgWorkPaperInfo;
import com.kingdee.util.PropertyContainer;

public class BgWorkPaperPropertyAdapter
implements IReportPropertyAdapter {
    private static final long serialVersionUID = 2153051364296710294L;
    public static final String BG_COST_CENTER_NUMBER = "BgCostCenterNum";
    public static final String BG_PERIOD_TYPE = "BG_PERIOD_TYPE";
    public static final String BG_PERIOD_YEAR = "BG_PERIOD_YEAR";
    public static final String BG_PERIOD_MONTH = "BG_PERIOD_MONTH";
    public static final String BG_PERIOD_ID = "BG_PERIOD_ID";
    public static final String BG_PERIOD_NUMBER = "BG_PERIOD_NUMBER";
    public static final String BG_ORG_ID = "BG_ORG_ID";
    public static final String BG_FORM_ID = "BG_FORM_ID";
    public static final String BG_ORG_NUMBER = "BG_ORG_NUMBER";
    public static final String BG_ORG_NAME = "BG_ORG_NAME";
    public static final String BG_SCHEME_NUMBER = "BG_SCHEME_NUMBER";
    public static final String Bg_Begin_Date = "bg_begin_date";
    public static final String Bg_End_Date = "bg_end_date";
    public static final String Report_StartYear = "Report_StartYear";
    public static final String Report_EndYear = "Report_EndYear";
    public static final String Report_StartPeriod = "Report_StartPeriod";
    public static final String Report_EndPeriod = "Report_EndPeriod";
    public static final String Report_FormulaMap = "Report_FormulaMap";
    private PropertyContainer p;

    public Object getReportProperty(String name) {
        return this.p.get(name);
    }

    public void initReportProperties(IObjectValue vo, Context ctx) {
        if (vo instanceof BgWorkPaperInfo) {
            BgWorkPaperInfo info = (BgWorkPaperInfo)vo;
            if (this.p == null) {
                this.p = new PropertyContainer();
            }
            if (info.getCompany() != null) {
                this.p.setString("Company.Name", info.getCompany().getName());
                this.p.setString("Company.Number", info.getCompany().getNumber());
                this.p.setString("Company.ID", info.getCompany().getId().toString());
            }
            String bgFormId = info.getId().toString();
            Object org = null;
            org = info.get(BG_COST_CENTER_NUMBER) instanceof OrgUnitInfo ? (OrgUnitInfo)info.get(BG_COST_CENTER_NUMBER) : (info.getBgScheme() != null && info.getBgScheme().getOrgUnit() != null ? info.getBgScheme().getOrgUnit() : info.getOrgUnit());
            this.p.setString(BG_ORG_ID, org == null ? "" : org.getId().toString());
            this.p.setString(BG_ORG_NUMBER, org == null ? "" : org.getNumber());
            this.p.setString(BG_ORG_NAME, org == null ? "" : org.getName());
            this.p.setString(BG_FORM_ID, bgFormId);
            if (info.getBgScheme() != null) {
                this.p.setString(BG_SCHEME_NUMBER, info.getBgScheme().getNumber());
            }
            BgPeriodInfo period = info.getBgPeriod();
            if (info.getBgPeriod() != null) {
                if (info.getBgPeriod().getBeginDate() != null) {
                    this.p.setString(Bg_Begin_Date, String.valueOf(info.getBgPeriod().getBeginDate()));
                }
                if (info.getBgPeriod().getEndDate() != null) {
                    this.p.setString(Bg_End_Date, String.valueOf(info.getBgPeriod().getEndDate()));
                }
            }
            if (period != null) {
                String id = period.getId().toString();
                BgPeriodEnum periodType = period.getPeriodType();
                int year = period.getYear();
                int halfYear = period.getHalfYear();
                int month = period.getMonth();
                int quart = period.getQuarter();
                this.p.setString(BG_PERIOD_ID, id);
                this.p.setString(BG_PERIOD_NUMBER, period.getNumber());
                if (period.getPeriodType() != null) {
                    this.p.setInt(BG_PERIOD_TYPE, period.getPeriodType().getValue());
                    this.p.setInt(BG_PERIOD_YEAR, period.getYear());
                }
                if (periodType != null) {
                    if (periodType.getValue() == 1) {
                        info.setPeriodType(RptPeriodTypeEnum.YEARLY);
                        info.setYear(year);
                        info.setPeriod((short)1);
                    } else if (periodType.getValue() == 2) {
                        info.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                        info.setYear(year);
                        info.setPeriod((short)halfYear);
                        this.p.setInt(BG_PERIOD_MONTH, period.getHalfYear());
                    } else if (periodType.getValue() == 3) {
                        info.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                        info.setYear(year);
                        info.setPeriod((short)quart);
                        this.p.setInt(BG_PERIOD_MONTH, period.getQuarter());
                    } else if (periodType.getValue() == 4) {
                        info.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                        info.setYear(year);
                        info.setPeriod((short)month);
                        this.p.setInt(BG_PERIOD_MONTH, period.getMonth());
                    } else if (periodType.getValue() == 5 || periodType.getValue() == 6) {
                        info.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                        info.setYear(year);
                        info.setPeriod((short)month);
                        this.p.setInt(BG_PERIOD_MONTH, period.getWeek());
                    }
                }
            }
            this.p.setInt("Report.Year", info.getYear());
            this.p.setInt("Report.Period", (int)info.getPeriod());
            if (info.getCurrency() != null) {
                this.p.setString("Currency.Number", info.getCurrency().getNumber());
            }
            if (info.getLastUpdateUser() != null) {
                this.p.setString("LastUpdater.Name", info.getLastUpdateUser().getName());
            }
            this.p.setString("Report.Name", info.getName());
            if (info.getSourceType() != null) {
                this.p.setInt("Report.SourceType", info.getSourceType().getValue());
            }
            if (info.getCU() != null) {
                this.p.setString("CU.Name", info.getCU().getId().toString());
            }
            if (info.getCreator() != null) {
                this.p.setString("Creater.Name", info.getCreator().getName());
            }
            this.p.setDate("Report_StartDate", info.getStartDate());
            this.p.setDate("Report_EndDate", info.getEndDate());
            OrgUnitInfo costCenter = org;
            if (costCenter != null) {
                this.p.setString(BG_COST_CENTER_NUMBER, costCenter.getNumber());
            }
            if (info.getSheetParam() != null && info.getSheetParam().size() > 0) {
                this.p.setInt(Report_StartYear, info.getSheetParam().get(0).getStartYear());
                this.p.setInt(Report_StartPeriod, info.getSheetParam().get(0).getStartPeriod());
                this.p.setInt(Report_EndYear, info.getSheetParam().get(0).getEndYear());
                this.p.setInt(Report_EndPeriod, info.getSheetParam().get(0).getEndPeriod());
            }
            if (info.getPeriodType() != null) {
                this.p.setInt("PeriodType", info.getPeriodType().getValue());
            }
        }
    }
}

