/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.client.BgTemplateViewEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;

public class TemplateCheckHelper {
    public static final String STRRESOURCE = "com.kingdee.eas.ma.budget.client.BgFormResource";

    public static void checkDupBgItemFormula(Book book, Locale locale) throws EASBizException {
        if (book == null) {
            return;
        }
        String[] formula = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        int sizeBook = book.getSheetCount();
        for (int k = 0; k < sizeBook; ++k) {
            Sheet sheet = book.getSheet(k);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    Cell cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    String str = BgNFSHelper.getFormulaOfCell(cell);
                    formula = new String[]{sheet.getSheetName(), str, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                }
            }
        }
        TemplateCheckHelper.checkRelativeBgPeriodItemAndElement(checkList, locale);
        try {
            BgNTemplateHelper.checkFormulaIsEctype(checkList, locale);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
    }

    public static void checkRelativeBgPeriodItemAndElement(List checkList, Locale locale) throws EASBizException {
        for (int i = 0; i < checkList.size(); ++i) {
            String msg;
            String[] strs = (String[])checkList.get(i);
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)strs[1], (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (!hint.name.equalsIgnoreCase("bgitem")) continue;
            if (StringUtils.isEmpty((String)params[0])) {
                msg = strs[0] + "," + (Integer.parseInt(strs[2]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + (Integer.parseInt(strs[3]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)locale);
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
            }
            if (StringUtils.isEmpty((String)params[2])) {
                msg = strs[0] + "," + (Integer.parseInt(strs[2]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + (Integer.parseInt(strs[3]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)locale);
                throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, (Object[])new String[]{msg});
            }
            String str = params[1].trim();
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(str);
                isRelativeBgPeriod = true;
            }
            catch (NumberFormatException e1) {
                isRelativeBgPeriod = false;
            }
            if (!isRelativeBgPeriod || Math.abs(relativeValue) <= 100) continue;
            String msg2 = strs[0] + "," + (Integer.parseInt(strs[2]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + (Integer.parseInt(strs[3]) + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"itemformula.to.100.to100", (Locale)locale);
            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg2});
        }
    }

    public boolean checkCellCanEdit(Cell cell, BgTemplateViewEnum templateViewState, BgTemModifyEnum modifyType) {
        if (cell == null) {
            return true;
        }
        if (cell.getSSA().isLocked()) {
            return false;
        }
        if (modifyType.getValue() == 2) {
            return false;
        }
        if (modifyType.getValue() == 3 && templateViewState.getValue().equals("BGITEMFORMUAL")) {
            return false;
        }
        return BgNFSHelper.checkCanEditFormulaOfCell(cell);
    }

    public static void checkBgFormula(boolean isBgTem, Book book, Locale locale) throws ParserException, BgNTemplateException {
        if (book == null) {
            return;
        }
        Vector<String> formulaKind = new Vector<String>();
        formulaKind.add("BgFormula");
        formulaKind.add("BgActualS");
        formulaKind.add("BgBal");
        int sizeBook = book.getSheetCount();
        for (int k = 0; k < sizeBook; ++k) {
            Sheet sheet = book.getSheet(k);
            int maxRowIndex = sheet.getMaxRowIndex();
            for (int i = 0; i <= maxRowIndex; ++i) {
                int maxColIndex = sheet.getMaxColIndex();
                for (int j = 0; j <= maxColIndex; ++j) {
                    Expression expression;
                    String formula;
                    Cell cell = sheet.getCell(i, j, false);
                    if (isBgTem) {
                        if (!BgNTemplateHelper.CheckTemplateHaveDataFormula(cell)) continue;
                        formula = BgNTemplateHelper.getBgDataValue(cell, "BG_BUDGET_EXPRESSIONS");
                        if (formula != null && formula.length() > 0 && formula.charAt(0) == '=') {
                            formula = "value" + formula;
                            expression = null;
                            try {
                                expression = ExcelFormulaPaserHelper.parse((String)formula);
                            }
                            catch (Exception e) {
                                String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)locale) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)locale);
                                throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                            }
                        }
                        if ((formula = BgNTemplateHelper.getBgDataValue(cell, "BG_ACTUAL_EXPRESSIONS")) != null && formula.length() > 0 && formula.charAt(0) == '=') {
                            formula = "value" + formula;
                            expression = null;
                            try {
                                expression = ExcelFormulaPaserHelper.parse((String)formula);
                            }
                            catch (Exception e) {
                                String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)locale) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)locale);
                                throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                            }
                        }
                        if ((formula = BgNTemplateHelper.getBgDataValue(cell, "BG_ADD_EXPRESSIONS")) == null || formula.length() <= 0 || formula.charAt(0) != '=') continue;
                        formula = "value" + formula;
                        expression = null;
                        try {
                            expression = ExcelFormulaPaserHelper.parse((String)formula);
                            continue;
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)locale) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)locale);
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                        }
                    }
                    if (cell.getFormula() == null) continue;
                    formula = cell.getFormula();
                    if (formula.length() > 0 && formula.charAt(0) == '=') {
                        formula = "value" + formula;
                    }
                    expression = null;
                    try {
                        expression = ExcelFormulaPaserHelper.parse((String)formula);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)locale) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)locale);
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                    }
                }
            }
        }
    }

    public static void subCheckBgFormula(CodeExpr codeExpr, Vector formulaKind, String sheetName, int x, int y, String extStr, Locale locale) throws BgNTemplateException {
        if (codeExpr instanceof BinaryOpExpr) {
            BinaryOpExpr bo = (BinaryOpExpr)codeExpr;
            TemplateCheckHelper.subCheckBgFormula(bo.left, formulaKind, sheetName, x, y, extStr, locale);
            TemplateCheckHelper.subCheckBgFormula(bo.right, formulaKind, sheetName, x, y, extStr, locale);
        } else if (codeExpr instanceof MethodInvokeExpr) {
            String funcName = ((MethodInvokeExpr)codeExpr).methodName;
            List params = ((MethodInvokeExpr)codeExpr).paramList;
            if (funcName != null) {
                for (int i = 0; i < formulaKind.size(); ++i) {
                    String str;
                    String temp = (String)formulaKind.get(i);
                    if (!funcName.equalsIgnoreCase(temp)) continue;
                    CodeExpr param2 = (CodeExpr)params.get(2);
                    CodeExpr param3 = (CodeExpr)params.get(3);
                    if (param2 instanceof StringExpr && (str = ((StringExpr)param2).text) != null && str.equals("")) {
                        String msg = sheetName + extStr + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (x + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (y + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"elementIsEmpty", (Locale)locale);
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                    }
                    if (!(param3 instanceof StringExpr) || (str = ((StringExpr)param3).text) == null || !str.equals("")) break;
                    String msg = extStr + sheetName + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (x + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)locale) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)locale) + (y + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)locale) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"itemIsEmpty", (Locale)locale);
                    throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, new String[]{msg});
                }
            }
        }
    }
}

