/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustFacadeFactory;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPastRecordFactory;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgAdjustFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormCollectFacade;
import com.kingdee.eas.ma.budget.IBgPastRecord;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.nbudget.BgAdjustDataValue;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgAdjUpperOrgCollectAllViewUI;
import com.kingdee.eas.ma.nbudget.client.IGetFormula;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgAdjUpperOrgCollectAllViewUI
extends AbstractBgAdjUpperOrgCollectAllViewUI {
    private static final long serialVersionUID = 1344240378694121493L;
    public static final String ALL_FORMULA = "allFormula";
    public static final String FORMULA_COEF = "formula_coef";
    public static final String ALL_VALUE = "allValue";
    public static final String RefUI = "refUI";
    protected List orgUnitList = null;
    protected List formulaList = null;
    protected Map formulaCoef = null;
    protected Map valueMap = null;
    protected IGetFormula iGetFormula = null;
    protected List resultDataRow = null;
    protected CostCenterOrgUnitInfo rootCU = null;
    public Set collectOrgTree = null;
    protected Map collectOrgMap = null;
    protected AdjustViewTreeRender treeRender = new AdjustViewTreeRender();
    Map _tmpMap = new HashMap();

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadParam();
        this.queryCollectData();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("orgUnit").setRenderer((IBasicRender)this.treeRender);
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                NumberExpandInfo expandInfo;
                int rowIndex;
                IRow row;
                if (e.getColIndex() == 0 && e.getClickCount() == 1 && (row = BgAdjUpperOrgCollectAllViewUI.this.tblMain.getRow(rowIndex = e.getRowIndex())).getCell(0).getValue() != null && row.getCell(0).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && BgAdjUpperOrgCollectAllViewUI.this.treeRender != null && BgAdjUpperOrgCollectAllViewUI.this.treeRender.inRect(expandInfo, e.getX(), e.getY())) {
                    try {
                        BgAdjUpperOrgCollectAllViewUI.this.setTreeDisplayStyle(row, expandInfo);
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                }
            }
        });
        this.dealOrgUnitCol();
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        this.tblMain.setRefresh(false);
        this.expandTable(row, expandInfo);
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell("orgUnit").getValue();
                if (expandInfo == null || expandInfo.getLongNumber() == null) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getBody().size();
            if (rowIndex >= rowCount) {
                this.dealChildRow(parentExpandInfo, rowIndex);
            } else {
                for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = this.tblMain.getRow(rowIndex);
                    expandInfo = (NumberExpandInfo)child.getCell("orgUnit").getValue();
                    if (expandInfo == null || expandInfo.getLongNumber() == null) {
                        child.getStyleAttributes().setHided(false);
                        continue;
                    }
                    longNumber = expandInfo.getLongNumber();
                    if (longNumber.startsWith(parentLongNumber + "!")) {
                        if (expandInfo.getLevel() - parentLevel < 1) continue;
                        child.getStyleAttributes().setHided(false);
                        if (expandInfo.isLeaf()) continue;
                        expandInfo.setExpandStatus(false);
                        continue;
                    }
                    if (rowIndex != row.getRowIndex() + 1) break;
                    this.dealChildRow(parentExpandInfo, rowIndex);
                    break;
                }
            }
        }
    }

    private void dealChildRow(NumberExpandInfo expandInfo, int rowIndex) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.collectOrgTree, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(expandInfo.getLongNumber() + "!%"), CompareType.LIKE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        OrgUnitCollection orgUnits = this.getOrgUnitInterface().getOrgUnitCollection(view);
        if (orgUnits == null || orgUnits.size() == 0) {
            return;
        }
        String parentLongNumber = expandInfo.getLongNumber();
        for (int i = 0; i < orgUnits.size(); ++i) {
            FullOrgUnitInfo orgUnitInfo;
            if (!this.collectOrgTree.contains(orgUnits.get(i).getId().toString()) || (orgUnitInfo = (FullOrgUnitInfo)this.collectOrgMap.get(orgUnits.get(i).getId().toString())).getLongNumber().split("!").length - parentLongNumber.split("!").length != 1 && !orgUnitInfo.getLongNumber().startsWith(parentLongNumber)) continue;
            orgUnitInfo = (FullOrgUnitInfo)this.collectOrgMap.get(orgUnits.get(i).getId().toString());
            IRow parentRow = this.tblMain.getRow(rowIndex - 1);
            String formula = ((BgAdjustDataValue)parentRow.getUserObject()).getFormula();
            IRow row = this.tblMain.addRow(rowIndex);
            String orgUnitID = orgUnitInfo.getId().toString();
            this.fillDataToRow(row, formula, orgUnitID);
            NumberExpandInfo _expandInfo = new NumberExpandInfo();
            _expandInfo.setId(orgUnitID);
            _expandInfo.setName(orgUnitInfo.getName());
            _expandInfo.setNumber(orgUnitInfo.getNumber());
            _expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
            _expandInfo.setLevel(orgUnitInfo.getLevel());
            _expandInfo.setExpandStatus(false);
            _expandInfo.setLeaf(this.checkIsLeaf(orgUnits, orgUnitInfo));
            row.getCell("orgUnit").setValue((Object)_expandInfo);
            this.dealRowBackGroud(row, orgUnitID);
        }
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    private boolean checkIsLeaf(OrgUnitCollection orgUnits, FullOrgUnitInfo orgUnitInfo) {
        if (orgUnits == null || orgUnits.size() == 0) {
            return false;
        }
        if (orgUnitInfo.isIsLeaf()) {
            return true;
        }
        OrgUnitInfo _unitInfo = null;
        for (int i = 0; i < orgUnits.size(); ++i) {
            _unitInfo = orgUnits.get(i);
            if (_unitInfo.getLongNumber() == null || _unitInfo.getLongNumber().equals(orgUnitInfo.getLongNumber()) || !_unitInfo.getLongNumber().startsWith(orgUnitInfo.getLongNumber())) continue;
            return false;
        }
        return true;
    }

    protected void loadParam() throws Exception {
        String orgUnitId2 = null;
        String orgUnitName = null;
        Map orgUnitMap = null;
        Map bgSchemeMap = null;
        String[] orgUnitStr = null;
        this.orgUnitList = new ArrayList();
        if (this.getUIContext().get("GATHER_ORGUNIT") != null && this.getUIContext().get("GATHER_SCHEME") != null) {
            orgUnitMap = (Map)this.getUIContext().get("GATHER_ORGUNIT");
            bgSchemeMap = (Map)this.getUIContext().get("GATHER_SCHEME");
            if (orgUnitMap != null && !orgUnitMap.isEmpty() && bgSchemeMap != null && !bgSchemeMap.isEmpty()) {
                for (String orgUnitId2 : orgUnitMap.keySet()) {
                    orgUnitName = (String)orgUnitMap.get(orgUnitId2);
                    if (!bgSchemeMap.containsKey(orgUnitId2)) continue;
                    orgUnitStr = new String[]{orgUnitId2, orgUnitName, (String)bgSchemeMap.get(orgUnitId2)};
                    this.orgUnitList.add(orgUnitStr);
                }
            }
        }
        this.formulaList = (List)this.getUIContext().get(ALL_FORMULA);
        this.formulaCoef = (Map)this.getUIContext().get(FORMULA_COEF);
        this.valueMap = (Map)this.getUIContext().get(ALL_VALUE);
        this.iGetFormula = (IGetFormula)this.getUIContext().get(RefUI);
        Object bgAdjustFormObj = this.getUIContext().get("BGFORM_ID");
        if (bgAdjustFormObj == null || bgAdjustFormObj.toString().length() == 0) {
            throw new BOSException("adjsut form id is null !");
        }
        BgFormInfo bgFormInfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgAdjustFormObj.toString()));
        this.collectOrgTree = this.getBgFormCollectFacade().getsourceOrgSet((IObjectValue)bgFormInfo, true);
        this.collectOrgMap = new HashMap();
        Iterator iterator = this.collectOrgTree.iterator();
        while (iterator.hasNext()) {
            orgUnitId2 = iterator.next().toString();
            FullOrgUnitInfo orgUnit = this.getOrgUnitInfo(orgUnitId2);
            this.collectOrgMap.put(orgUnitId2, orgUnit);
        }
        Object orgUnitIdObj = this.getUIContext().get("ORGUNIT_ID");
        if (orgUnitIdObj == null || orgUnitIdObj.toString().length() == 0) {
            throw new BOSException("cu id is null !");
        }
        this.rootCU = this.getCUInterface().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitIdObj.toString()));
    }

    protected void queryCollectData() throws Exception {
        if (this.formulaList == null || this.formulaList.size() == 0) {
            return;
        }
        this.resultDataRow = this.getBgAdjustFacade().getCollectAdjustData(this.formulaList, this.orgUnitList);
    }

    protected void dealOrgUnitCol() throws EASBizException, BOSException {
        String formula;
        if (this.formulaList == null || this.formulaList.size() == 0) {
            return;
        }
        List<String[]> curFormAdjustInfo = new ArrayList();
        IBgPastRecord bgPastRecord = BgPastRecordFactory.getRemoteInstance();
        if (this.getUIContext().get("bgFormPastRecord") != null) {
            String bgFormInfoId = (String)this.getUIContext().get("bgFormPastRecord");
            curFormAdjustInfo = bgPastRecord.getValue(BOSUuid.read((String)bgFormInfoId), null);
        } else if (this.getUIContext().get("bgFormAdjust") != null) {
            curFormAdjustInfo = bgPastRecord.getValue((Map)this.getUIContext().get("bgFormAdjust"), null);
        }
        if (curFormAdjustInfo != null && curFormAdjustInfo.size() != 0) {
            for (int i = 0; i < curFormAdjustInfo.size(); ++i) {
                String[] info = (String[])curFormAdjustInfo.get(i);
                String itemCombinName = "";
                String[] a = info[0].split("\\;");
                for (int j = 0; j < a.length; ++j) {
                    String[] s = a[j].split("\\_");
                    itemCombinName = j == 0 ? s[s.length - 1] : itemCombinName + "_" + s[s.length - 1];
                }
                info[0] = itemCombinName;
                formula = info[9];
                if (!this.valueMap.keySet().contains(formula)) continue;
            }
        }
        Iterator _itr = this.valueMap.keySet().iterator();
        while (_itr.hasNext()) {
            String formula2 = _itr.next().toString();
            String[] parameter = BgNFSHelper.parseFormulaPara(this.iGetFormula.getFormulaMap(), formula2);
            this._tmpMap.put(parameter[0].replaceAll(",", "_"), null);
        }
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        this._tmpMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(this._tmpMap, orgUnitId);
        Iterator itr = this.valueMap.keySet().iterator();
        while (itr.hasNext()) {
            String _bgItemName;
            String formula3 = itr.next().toString();
            Object value = this.valueMap.get(formula3);
            String[] info = new String[11];
            String[] parameter = BgNFSHelper.parseFormulaPara(this.iGetFormula.getFormulaMap(), formula3);
            info[0] = _bgItemName = (String)this._tmpMap.get(parameter[0].replaceAll(",", "_"));
            BgElementInfo element = (BgElementInfo)BgElementFactory.getRemoteInstance().getValue("select name where number ='" + parameter[2] + "'");
            info[1] = element.getName();
            BigDecimal _value = BgNConstants.ZERO;
            try {
                _value = new BigDecimal(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            String periodNumber = parameter[1];
            BgPeriodInfo pi = null;
            try {
                pi = BgPeriodFactory.getRemoteInstance().getBgPeriodInfo("select name where number = '" + periodNumber + "'");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (pi != null) {
                info[2] = pi.getName();
            }
            info[4] = _value.toString();
            info[5] = _value.toString();
            info[6] = BgNConstants.ZERO.toString();
            curFormAdjustInfo.add(info);
        }
        Iterator iterator = this.formulaList.iterator();
        while (iterator.hasNext()) {
            formula = iterator.next().toString();
            IRow row = this.tblMain.addRow();
            int rowIndex = row.getRowIndex();
            int historyRowCount = this.fillDataToRow(row, formula, this.rootCU.getId().toString());
            this.processCurrentFormAdjustInfo(row, curFormAdjustInfo, formula);
            this.addExpandInfo(this.tblMain.getCell(rowIndex + historyRowCount, 0), this.rootCU);
        }
    }

    private int fillDataToRow(IRow row, String formula, String orgUnitId) throws EASBizException, BOSException {
        if (row == null || formula == null || formula.length() == 0 || orgUnitId == null || orgUnitId.length() == 0) {
            return 0;
        }
        if (this.resultDataRow == null || this.resultDataRow.size() == 0) {
            return 0;
        }
        BgAdjustDataValue value = null;
        boolean isExists = false;
        for (int i = 0; i < this.resultDataRow.size(); ++i) {
            value = (BgAdjustDataValue)this.resultDataRow.get(i);
            if (!orgUnitId.equals(value.getOrgUnitId()) || !formula.equals(value.getFormula())) continue;
            isExists = true;
            break;
        }
        if (!isExists) {
            value = new BgAdjustDataValue();
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.collectOrgMap.get(orgUnitId);
            value.setOrgUnitId(orgUnitId);
            value.setOrgUnitNumber(orgUnitInfo.getNumber());
            value.setOrgUnitLongNumber(orgUnitInfo.getLongNumber());
            value.setOrgUnitName(orgUnitInfo.getName());
            value.setOldValue(null);
            value.setAdjValue(null);
            value.setNewValue(null);
            value.setAdjustor("");
            value.setAdjusttime("");
            value.setAuditor("");
            value.setAuditTime("");
            value.setBgFormId("");
            value.setApproved(false);
            this.fillFormulaInfo(formula, value);
        }
        BigDecimal measure = null;
        measure = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
        row.getCell("orgUnitNumber").setValue((Object)value.getOrgUnitNumber());
        row.getCell("orgUnitLongNumber").setValue((Object)value.getOrgUnitLongNumber());
        row.getCell("bgItem").setValue((Object)(value.getItemName() + "(" + value.getElementName() + ")"));
        BigDecimal measure2 = null;
        if (this.getFormulaCoef(formula) != null) {
            measure2 = this.getFormulaCoef(formula);
            row.getCell("adjValue").setValue(value.getAdjValue() != null ? value.getAdjValue().divide(measure2, 8, 4) : null);
            row.getCell("adjBefore").setValue(value.getOldValue() != null ? value.getOldValue().divide(measure2, 8, 4) : null);
            row.getCell("adjAfter").setValue(value.getNewValue() != null ? value.getNewValue().divide(measure2, 8, 4) : null);
        } else {
            row.getCell("adjValue").setValue(value.getAdjValue() != null ? value.getAdjValue().divide(measure, 8, 4) : null);
            row.getCell("adjBefore").setValue(value.getOldValue() != null ? value.getOldValue().divide(measure, 8, 4) : null);
            row.getCell("adjAfter").setValue(value.getNewValue() != null ? value.getNewValue().divide(measure, 8, 4) : null);
        }
        row.getCell("person").setValue((Object)value.getAdjustor());
        row.getCell("time").setValue((Object)value.getAdjusttime());
        row.getCell("auditor").setValue((Object)value.getAuditor());
        row.getCell("auditTime").setValue((Object)value.getAuditTime());
        BgPeriodInfo periodInfo = this.getPeriodInfo(value.getFormula());
        row.getCell("periodNumber").setValue((Object)periodInfo.getNumber());
        row.getCell("periodName").setValue((Object)periodInfo.getName());
        row.setUserObject((Object)value);
        int currentRowIndex = row.getRowIndex();
        int historyRowCount = 0;
        if (value.getHistoryInfos() != null && value.getHistoryInfos().size() > 0) {
            historyRowCount = value.getHistoryInfos().size();
            for (int j = 0; j < value.getHistoryInfos().size(); ++j) {
                BgAdjustDataValue _value = (BgAdjustDataValue)value.getHistoryInfos().get(j);
                IRow _row = this.tblMain.addRow(currentRowIndex + j + 1);
                _row.getCell("orgUnitNumber").setValue((Object)_value.getOrgUnitNumber());
                _row.getCell("orgUnitLongNumber").setValue((Object)_value.getOrgUnitLongNumber());
                _row.getCell("bgItem").setValue(row.getCell("bgItem").getValue());
                if (this.getFormulaCoef(formula) != null) {
                    measure2 = this.getFormulaCoef(formula);
                    _row.getCell("adjValue").setValue((Object)(_value.getAdjValue() != null ? _value.getAdjValue().divide(measure2, 8, 4) : _value.getAdjValue()));
                    _row.getCell("adjBefore").setValue(_value.getOldValue() != null ? _value.getOldValue().divide(measure2, 8, 4) : null);
                    _row.getCell("adjAfter").setValue(_value.getNewValue() != null ? _value.getNewValue().divide(measure2, 8, 4) : null);
                } else {
                    _row.getCell("adjValue").setValue((Object)(_value.getAdjValue() != null ? _value.getAdjValue().divide(measure, 8, 4) : _value.getAdjValue()));
                    _row.getCell("adjBefore").setValue(_value.getOldValue() != null ? _value.getOldValue().divide(measure, 8, 4) : null);
                    _row.getCell("adjAfter").setValue(_value.getNewValue() != null ? _value.getNewValue().divide(measure, 8, 4) : null);
                }
                _row.getCell("person").setValue((Object)_value.getAdjustor());
                _row.getCell("time").setValue((Object)_value.getAdjusttime());
                _row.getCell("auditor").setValue((Object)_value.getAuditor());
                _row.getCell("auditTime").setValue((Object)_value.getAuditTime());
                BgPeriodInfo _periodInfo = this.getPeriodInfo(value.getFormula());
                _row.getCell("periodNumber").setValue((Object)_periodInfo.getNumber());
                _row.getCell("periodName").setValue((Object)_periodInfo.getName());
                _row.setUserObject((Object)_value);
                _row.getStyleAttributes().setBackground(BgNConstants.EDIT_COLOR);
            }
        }
        if (historyRowCount > 0) {
            this.tblMain.getMergeManager().mergeBlock(currentRowIndex, 0, currentRowIndex + historyRowCount, 1);
        }
        return historyRowCount;
    }

    private void processCurrentFormAdjustInfo(IRow row, List values, String formula2) {
        if (row == null || values == null || values.size() == 0) {
            return;
        }
        BigDecimal measure = null;
        measure = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
        for (int i = 0; i < values.size(); ++i) {
            String[] info = (String[])values.get(i);
            Object formula = row.getCell("bgItem").getValue();
            if (formula == null || formula.toString().length() == 0) continue;
            String _formula = formula.toString();
            if (info[0] == null || info[0].length() == 0 || info[1] == null || info[1].length() == 0) continue;
            try {
                if (this.getFormulaCoef(formula2) != null) {
                    measure = this.getFormulaCoef(formula2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String itemCombinName = "";
            String[] a = info[0].split("\\;");
            for (int j = 0; j < a.length; ++j) {
                String[] s = a[j].split("\\_");
                itemCombinName = j == 0 ? s[s.length - 1] : itemCombinName + "_" + s[s.length - 1];
            }
            itemCombinName = itemCombinName + "(" + info[1] + ")";
            String period = row.getCell("periodName").getValue() != null ? row.getCell("periodName").getValue().toString() : "";
            if (!_formula.equals((info[0] != null ? info[0] : "") + "(" + (info[1] != null ? info[1] : "") + ")") || !period.equals(info[2])) continue;
            row.getCell("adjValue").setValue(!StringUtils.isEmpty((String)info[6]) ? new BigDecimal(info[6]).divide(measure, 8, 4) : null);
            row.getCell("adjBefore").setValue(!StringUtils.isEmpty((String)info[4]) ? new BigDecimal(info[4]).divide(measure, 8, 4) : null);
            row.getCell("adjAfter").setValue(!StringUtils.isEmpty((String)info[5]) ? new BigDecimal(info[5]).divide(measure, 8, 4) : null);
            row.getCell("person").setValue((Object)info[7]);
            row.getCell("time").setValue((Object)info[8]);
            row.getCell("auditor").setValue((Object)info[9]);
            row.getCell("auditTime").setValue((Object)info[10]);
            if (info[6] == null || info[6].length() == 0 || new BigDecimal(info[6]).compareTo(BgNConstants.ZERO) == 0) break;
            row.getStyleAttributes().setBackground(BgNConstants.EDIT_COLOR);
            break;
        }
    }

    private void dealRowBackGroud(IRow row, String orgUnitId) {
        if (this.orgUnitList == null || this.orgUnitList.size() == 0) {
            return;
        }
        if (orgUnitId == null || orgUnitId.length() == 0) {
            return;
        }
        String[] collectUnitInfos = null;
        for (int i = 0; i < this.orgUnitList.size(); ++i) {
            collectUnitInfos = (String[])this.orgUnitList.get(i);
            if (!orgUnitId.equals(collectUnitInfos[0]) || row.getCell("adjValue").getValue() == null || new BigDecimal(row.getCell("adjValue").getValue().toString()).compareTo(BgNConstants.ZERO) == 0) continue;
            row.getStyleAttributes().setBackground(BgNConstants.EDIT_COLOR);
            break;
        }
    }

    private void fillFormulaInfo(String formula, BgAdjustDataValue value) throws BOSException, EASBizException {
        List formulaHint = null;
        formulaHint = TableToolkit.parseFormula((String)formula, (boolean)false);
        String[] parameter = null;
        if (formulaHint != null) {
            FormulaHint formulas = (FormulaHint)formulaHint.get(0);
            parameter = formulas.getParams();
        }
        if (parameter == null) {
            return;
        }
        void itemCmbNumber = parameter[0];
        String itemCmbName = (String)this._tmpMap.get(itemCmbNumber.replaceAll(",", "_"));
        String elementNumber = parameter[2];
        IBgElement iBgElement = BgElementFactory.getRemoteInstance();
        CoreBaseInfo element = null;
        try {
            element = iBgElement.getValue(" select name where number = '" + elementNumber + "' ");
        }
        catch (ObjectNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        String elementName = "";
        if (element != null) {
            elementName = ((BgElementInfo)element).getName();
        }
        value.setItemNumber((String)itemCmbNumber);
        value.setItemName(itemCmbName);
        value.setElementNumber(elementNumber);
        value.setElementName(elementName);
        value.setFormula(formula);
    }

    private void addExpandInfo(ICell cell, CostCenterOrgUnitInfo orgUnitInfo) {
        if (cell == null) {
            return;
        }
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        expandInfo.setLeaf(false);
        cell.setValue((Object)expandInfo);
    }

    protected ICostCenterOrgUnit getCUInterface() throws BOSException {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    protected IBgFormCollectFacade getBgFormCollectFacade() throws BOSException {
        return BgFormCollectFacadeFactory.getRemoteInstance();
    }

    protected IBgAdjustFacade getBgAdjustFacade() throws Exception {
        return BgAdjustFacadeFactory.getRemoteInstance();
    }

    protected IBgForm getBgFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    private FullOrgUnitInfo getOrgUnitInfo(String orgUnitId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isLeaf"));
        return this.getOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
    }

    protected IFullOrgUnit getOrgUnitInterface() throws BOSException {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    private BgPeriodInfo getPeriodInfo(String itemFormula) throws BOSException, EASBizException {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
        }
        catch (ParserException e1) {
            return null;
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        String periodNumber = params[1];
        IBgPeriod iP = BgPeriodFactory.getRemoteInstance();
        BgPeriodInfo info = null;
        try {
            info = iP.getBgPeriodInfo(" select number,name where number = '" + periodNumber + "'");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return info;
    }

    private BigDecimal getFormulaCoef(String formula) throws BOSException, EASBizException {
        if (this.formulaCoef != null && this.formulaCoef.containsKey(formula)) {
            return (BigDecimal)this.formulaCoef.get(formula);
        }
        return null;
    }

    protected class AdjustViewTreeRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected AdjustViewTreeRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        protected boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getName(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    protected class NumberExpandInfo {
        private String id = null;
        private String number = null;
        private String name = null;
        private String longNumber = null;
        private boolean isExpandStatus = false;
        private int level = 0;
        private boolean isLeaf = false;
        private boolean isEffective = true;

        protected NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isEffective() {
            return this.isEffective;
        }

        public void setEffective(boolean isEffective) {
            this.isEffective = isEffective;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

