/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgAdjustFacadeFactory;
import com.kingdee.eas.ma.budget.BgCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgAdjustFacade;
import com.kingdee.eas.ma.budget.IBgCollectFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.nbudget.BgAdjustDataValue;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgAdjUpperOrgCollectView;
import com.kingdee.eas.ma.nbudget.client.BgAdjCurOrgView;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BgAdjUpperOrgCollectView
extends AbstractBgAdjUpperOrgCollectView {
    private static final long serialVersionUID = 5211609456160199052L;
    private IBgAdjustFacade iFacade = null;
    private IBgCollectFacade ibgCollectFacade = null;
    private IBgForm iBgForm = null;
    private String formulaStr = null;
    private BigDecimal measure = null;
    private int decimal = 8;
    private List orgUnitList = null;
    protected Map bgFormIdsMap = null;
    public static final String Bg_AdjustData_Value = "BgAdjustDataValue";
    BigDecimal sumAmount = BgNConstants.ZERO;

    protected IBgAdjustFacade getFacade() throws Exception {
        if (this.iFacade == null) {
            this.iFacade = BgAdjustFacadeFactory.getRemoteInstance();
        }
        return this.iFacade;
    }

    protected IBgCollectFacade getBgCollectInterface() throws Exception {
        if (this.ibgCollectFacade == null) {
            this.ibgCollectFacade = BgCollectFacadeFactory.getRemoteInstance();
        }
        return this.ibgCollectFacade;
    }

    protected IBgForm getBgForm() throws Exception {
        if (this.iBgForm == null) {
            this.iBgForm = BgFormFactory.getRemoteInstance();
        }
        return this.iBgForm;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.processInitSystem();
        this.processInitHeadInfo();
        this.processCollectInfo();
    }

    private void processInitSystem() {
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processInitHeadInfo() throws Exception {
        String orgUnitId2222222;
        block28: {
            this.measure = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
            orgUnitId2222222 = null;
            String orgUnitName = null;
            Map orgUnitMap = null;
            Map bgSchemeMap = null;
            String[] orgUnitStr = null;
            this.orgUnitList = new ArrayList();
            if (this.getUIContext().get("GATHER_ORGUNIT") != null && this.getUIContext().get("GATHER_SCHEME") != null) {
                orgUnitMap = (Map)this.getUIContext().get("GATHER_ORGUNIT");
                bgSchemeMap = (Map)this.getUIContext().get("GATHER_SCHEME");
                if (this.getUIContext().get("GATHER_BGFORM") != null) {
                    this.bgFormIdsMap = (Map)this.getUIContext().get("GATHER_BGFORM");
                }
                if (orgUnitMap != null && !orgUnitMap.isEmpty() && bgSchemeMap != null && !bgSchemeMap.isEmpty()) {
                    for (String orgUnitId2222222 : orgUnitMap.keySet()) {
                        orgUnitName = (String)orgUnitMap.get(orgUnitId2222222);
                        if (!bgSchemeMap.containsKey(orgUnitId2222222)) continue;
                        orgUnitStr = new String[]{orgUnitId2222222, orgUnitName, (String)bgSchemeMap.get(orgUnitId2222222)};
                        this.orgUnitList.add(orgUnitStr);
                    }
                    break block28;
                } else {
                    return;
                }
            }
            return;
        }
        this.formulaStr = (String)this.getUIContext().get("GATHER_FORMULA");
        String[] parameter = BgNFSHelper.parseFormulaPara(null, this.formulaStr);
        if (parameter != null) {
            CurrencyInfo currencyInfo;
            if (parameter[0] != null && parameter[0].trim().length() > 0) {
                HashSet<String> bgItemsSet = new HashSet<String>();
                HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                String bgItemsName = null;
                String[] bgItems = parameter[0].split(",");
                int n = bgItems.length;
                for (int i = 0; i < n; ++i) {
                    bgItemsSet.add(bgItems[i]);
                }
                try {
                    IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                    if (ibgItem == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    orgUnitId2222222 = BgSHelper.getIsolateOrg((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId2222222, CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgItemInfo bgItemInfo2222222 = null;
                    BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                    for (BgItemInfo bgItemInfo2222222 : bgItemCol) {
                        if (bgItemsMap.containsKey(bgItemInfo2222222.getNumber())) continue;
                        bgItemsMap.put(bgItemInfo2222222.getNumber(), bgItemInfo2222222.getName());
                    }
                    if (bgItemCol != null) {
                        bgItemCol.clear();
                    }
                    int n2 = bgItems.length;
                    for (int i = 0; i < n2; ++i) {
                        bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                    }
                }
                catch (BOSException ex) {
                    try {
                        throw ex;
                        catch (EASBizException ex2) {
                            throw ex2;
                        }
                    }
                    catch (Throwable throwable) {
                        this.txtBgItemNumber.setText(parameter[0]);
                        this.txtBgItemName.setText(bgItemsName);
                        throw throwable;
                    }
                }
                this.txtBgItemNumber.setText(parameter[0]);
                this.txtBgItemName.setText(bgItemsName);
            } else {
                this.txtBgItemNumber.setText("");
                this.txtBgItemName.setText("");
            }
            if (parameter[2] != null && parameter[2].trim().length() > 0) {
                String bgElementName = null;
                try {
                    IBgElement ibgElement = BgElementFactory.getRemoteInstance();
                    if (ibgElement == null) {
                        throw new BgException(BgException.NOINSTANCE);
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    view.getSelector().addObjectCollection((IObjectCollection)sic);
                    BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
                    bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
                    if (bgElementCol != null) {
                        bgElementCol.clear();
                    }
                }
                catch (BOSException ex) {
                    try {
                        throw ex;
                        catch (EASBizException ex3) {
                            throw ex3;
                        }
                    }
                    catch (Throwable throwable) {
                        this.txtBgElementName.setText(bgElementName);
                        throw throwable;
                    }
                }
                this.txtBgElementName.setText(bgElementName);
            }
            if (parameter[3] != null && parameter[3].trim().length() > 0) {
                this.txtBgDataType.setText(BgDataTypeEnum.BgData.getAlias());
            }
            if (parameter != null && parameter[5] != null && (currencyInfo = BgSHelper.getCurrencyInfo(null, (String)parameter[5], null)) != null) {
                this.decimal = currencyInfo.getPrecision();
            }
        }
    }

    private void processCollectInfo() throws Exception {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(this.formulaStr);
        List retList = this.getFacade().getCollectAdjustData(paramList, this.orgUnitList);
        this.sumAmount = this.sumAmount.setScale(4);
        if (retList != null && !retList.isEmpty()) {
            BgAdjustDataValue data = null;
            IRow row = null;
            int i = 0;
            int n = 0;
            n = retList.size();
            for (i = 0; i < n; ++i) {
                data = (BgAdjustDataValue)retList.get(i);
                row = this.tblMain.addRow();
                int currentRowIndex = row.getRowIndex();
                row.getCell("orgUnit.name").setValue((Object)data.getOrgUnitName());
                BigDecimal adjVal = data.getAdjValue() == null ? BgNConstants.ZERO : data.getAdjValue().divide(this.measure, this.decimal, 4);
                row.getCell("beforeAdj").setValue(data.getOldValue() != null ? data.getOldValue().divide(this.measure, this.decimal, 4) : null);
                row.getCell("adjValue").setValue(data.getAdjValue() != null ? data.getAdjValue().divide(this.measure, this.decimal, 4) : null);
                row.getCell("afterAdj").setValue(data.getNewValue() != null ? data.getNewValue().divide(this.measure, this.decimal, 4) : null);
                row.getCell("adjustor").setValue((Object)data.getAdjustor());
                row.getCell("adjustTime").setValue((Object)data.getAdjusttime());
                row.getCell("type").setValue((Object)BgPastSourceEnum.ADJUST);
                this.sumAmount = this.sumAmount.add(adjVal);
                row.setUserObject((Object)data);
                int historyRowCount = 0;
                if (data.getHistoryInfos() != null && data.getHistoryInfos().size() > 0) {
                    historyRowCount = data.getHistoryInfos().size();
                    List historyValues = data.getHistoryInfos();
                    for (int j = 0; j < historyValues.size(); ++j) {
                        BgAdjustDataValue _value = (BgAdjustDataValue)historyValues.get(j);
                        IRow _row = this.tblMain.addRow();
                        _row.getCell("orgUnit.name").setValue((Object)_value.getOrgUnitName());
                        BigDecimal adjVal2 = _value.getAdjValue() == null ? BgNConstants.ZERO : _value.getAdjValue().divide(this.measure, this.decimal, 4);
                        _row.getCell("beforeAdj").setValue(_value.getOldValue() != null ? _value.getOldValue().divide(this.measure, this.decimal, 4) : null);
                        _row.getCell("adjValue").setValue(_value.getAdjValue() != null ? _value.getAdjValue().divide(this.measure, this.decimal, 4) : null);
                        _row.getCell("afterAdj").setValue(_value.getNewValue() != null ? _value.getNewValue().divide(this.measure, this.decimal, 4) : null);
                        _row.getCell("adjustor").setValue((Object)_value.getAdjustor());
                        _row.getCell("adjustTime").setValue((Object)_value.getAdjusttime());
                        _row.getCell("type").setValue((Object)BgPastSourceEnum.ADJUST);
                        this.sumAmount = this.sumAmount.add(adjVal2);
                        _row.setUserObject((Object)_value);
                    }
                }
                if (historyRowCount <= 0) continue;
                this.tblMain.getMergeManager().mergeBlock(currentRowIndex, 0, currentRowIndex + historyRowCount, 0);
            }
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
        this.txtTotalAmt.setText(this.sumAmount.toString());
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    @Override
    protected void btnViewRpt_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewRpt_actionPerformed(e);
        this.openReport(OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.openReport(OprtState.VIEW);
        }
    }

    protected void openReport(String reportState) throws Exception {
        IRow row;
        Object userObject;
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        if ((userObject = (row = this.tblMain.getRow(activeRowIndex)).getUserObject()) == null || !(userObject instanceof BgAdjustDataValue)) {
            return;
        }
        BgAdjustDataValue data = (BgAdjustDataValue)userObject;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)Bg_AdjustData_Value, (Object)data);
        uiContext.put((Object)"GATHER_DATA_TYPE", this.getUIContext().get("GATHER_DATA_TYPE"));
        uiContext.put((Object)"GATHER_FORMULA", (Object)this.formulaStr);
        uiContext.put((Object)"GATHER_ORGUNIT", this.getUIContext().get("GATHER_ORGUNIT"));
        uiContext.put((Object)"GATHER_SCHEME", this.getUIContext().get("GATHER_SCHEME"));
        uiContext.put((Object)"GATHER_BGFORM", this.getUIContext().get("GATHER_BGFORM"));
        uiContext.put((Object)"IS_GATHER_ADJUST", this.getUIContext().get("IS_GATHER_ADJUST"));
        uiContext.put((Object)"GATHER_MEASUREUNIT", this.getUIContext().get("GATHER_MEASUREUNIT"));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAdjCurOrgView.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

