/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTemplateObject;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgTemplateDialog;
import com.kingdee.eas.ma.nbudget.BgCourseFilterParam;
import com.kingdee.eas.ma.nbudget.BgFormCourseHelper;
import com.kingdee.eas.ma.nbudget.BgNFFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.IBgNFFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgAnalyseCourseUI;
import com.kingdee.eas.ma.nbudget.client.BgFormCourseStateDialog;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.solution.MaQuerySolutionUpgrande;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgAnalyseCourseUI
extends AbstractBgAnalyseCourseUI {
    private static final long serialVersionUID = 1216036738629156598L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseCourseUI.class);
    private CtrlUnitInfo currCU = null;
    private OrgUnitInfo currOrgUnit = null;
    private CostCenterOrgUnitInfo currCCOrgUnit = null;
    private boolean hasUseFund = false;
    private static final String BGSCHEME_ID = "BGSCHEME_ID";
    private static final String BGPERIOD_ID = "BGPERIOD_ID";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String TEMPLATE_ID = "TEMPLATE_ID";
    private static final String STATE = "STATE";
    private CustomerParams cp;

    public BgAnalyseCourseUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    protected void prmtBgTemplate_willShow(SelectorEvent e) {
        Object obj = this.prmtBgScheme.getData();
        if (!(obj instanceof BgSchemeInfo[]) && !(obj instanceof BgSchemeInfo)) {
            this.prmtBgScheme.requestFocus();
            BgNFCHelper.showWarning((Component)((Object)this), BgNFCHelper.getMessageStr("noBgScheme"));
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "analyse_title");
    }

    protected ICostCenterOrgUnit getCCOrgUnitInterface() throws Exception {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    protected IBgScheme getBgSchemeInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected IBgPeriod getBgPeriodInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected ICurrency getCurrencyInterface() throws Exception {
        return CurrencyFactory.getRemoteInstance();
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.currCU;
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public CostCenterOrgUnitInfo getCCorgUnit() {
        return this.currCCOrgUnit;
    }

    public boolean isHasUseFund() {
        return this.hasUseFund;
    }

    protected void initFilter() throws Exception {
        this.currCU = SysContext.getSysContext().getCurrentCtrlUnit();
        this.currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        this.currCCOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
        if (this.currCCOrgUnit != null) {
            this.currCCOrgUnit = this.getCCOrgUnitInterface().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currCCOrgUnit.getId()));
        }
        this.hasUseFund = BgParamCHelper.isFodian();
        this.initBgScheme();
        this.initBgTemplate();
        this.initBgPeriod();
        this.initCurrency();
        this.initState();
    }

    protected void initBgTemplate() throws Exception {
        this.prmtBgTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BgAnalyseCourseUI.this.prmtBgTemplate_willShow(e);
            }
        });
        this.prmtBgTemplate.setSelector((KDPromptSelector)new NewBgTemplateDialog((IUIObject)this));
    }

    public void loadFilterInfo() throws Exception {
        this.showBgScheme();
        this.showBgPeriod();
        this.showCurrency();
        this.showBgTemplate();
    }

    protected boolean isMultiSelect() {
        return true;
    }

    protected boolean isReturnSuperior() {
        return true;
    }

    protected void initBgScheme() throws Exception {
        this.prmtBgScheme.setEnabledMultiSelection(false);
        this.prmtBgScheme.setHistoryRecordEnabled(false);
        EntityViewInfo _view = new EntityViewInfo();
        FilterInfo _filter = new FilterInfo();
        _filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCurrOrgUnit().getId().toString(), CompareType.EQUALS));
        _filter.setMaskString("#0");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(this.getCurrOrgUnit().getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            _filter = BgPermissionHelper.addBgSchemePermission(user, orgSet, _filter);
        }
        _view.setFilter(_filter);
        this.prmtBgScheme.setEntityViewInfo(_view);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("rootid");
    }

    protected void showBgScheme() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)((Object)method.invoke(this.ui, null))) != null) {
                    this.prmtBgScheme.setData((Object)filterParam.getBgScheme());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void showBgTemplate() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)((Object)method.invoke(this.ui, null))) != null) {
                    this.prmtBgTemplate.setData((Object)BgFormCourseHelper.tempArray2TempObj(filterParam.getTemplateInfo()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, false);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
        this.prmtBgPeriod.setEnabledMultiSelection(false);
        this.prmtBgPeriod.setHistoryRecordEnabled(false);
    }

    protected void showBgPeriod() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)((Object)method.invoke(this.ui, null))) != null) {
                    this.prmtBgPeriod.setData((Object)filterParam.getBgPeriod());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initCurrency() throws Exception {
        this.prmtCurrency.setHistoryRecordEnabled(false);
    }

    protected void showCurrency() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgCourseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgCourseFilterParam)((Object)method.invoke(this.ui, null))) != null) {
                    this.prmtCurrency.setData((Object)filterParam.getCurrency());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initState() throws Exception {
        BgFormCourseStateDialog dialog = new BgFormCourseStateDialog((IUIObject)this);
        this.prmtState.setSelector((KDPromptSelector)dialog);
        this.prmtState.setEditable(false);
        this.prmtState.setHistoryRecordEnabled(false);
        this.prmtState.setEnabledMultiSelection(true);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo _info = null;
        Object _obj = this.prmtBgScheme.getData();
        if (_obj != null) {
            BgSchemeInfo _bgSchemeInfo = null;
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                try {
                    _info = this.getBgSchemeInterface().getBgSchemeInfo("select id, name, number, rootid,orgUnit where fnumber = '" + _obj.toString() + "'");
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                if (_info != null) {
                    this.prmtBgScheme.setData(_info);
                    _bgSchemeInfo = _info;
                } else {
                    this.prmtBgScheme.setData(null);
                    this.prmtBgTemplate.setData(null);
                }
            } else if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[]) {
                Object[] obj = (Object[])_obj;
                _bgSchemeInfo = (BgSchemeInfo)obj[0];
            }
            if (_bgSchemeInfo != null) {
                this.prmtBgTemplate.setData(null);
                BgFormCourseHelper.initTemplateFormBgScheme(this.prmtBgTemplate, _bgSchemeInfo, (IUIObject)this);
            } else {
                this.prmtBgTemplate.setData(null);
            }
        }
    }

    @Override
    protected void prmtBgPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriod_dataChanged(e);
        BgPeriodInfo _info = null;
        Object _obj = this.prmtBgPeriod.getData();
        if (_obj != null) {
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                try {
                    _info = this.getBgPeriodInterface().getBgPeriodInfo("select id, name, number where fnumber = '" + _obj.toString() + "'");
                }
                catch (Exception ex) {
                    this.handUIException(ex);
                }
                if (_info != null) {
                    this.prmtBgPeriod.setData(_info);
                } else {
                    this.prmtBgPeriod.setData(null);
                }
            } else if (_obj instanceof BgPeriodInfo || _obj instanceof BgPeriodInfo[]) {
                // empty if block
            }
        }
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        CurrencyInfo _info = null;
        CurrencyCollection _col = null;
        Object _obj = this.prmtCurrency.getData();
        if (_obj != null) {
            if (_obj instanceof String && !StringUtils.isEmpty((String)_obj.toString())) {
                _col = this.getCurrencyInterface().getCurrencyCollection("select id, name, number where fnumber = '" + _obj.toString() + "'");
                if (_col != null && !_col.isEmpty()) {
                    _info = _col.get(0);
                    _col.clear();
                }
                if (_info != null) {
                    this.prmtCurrency.setData(_info);
                } else {
                    this.prmtCurrency.setData(null);
                }
            } else if (_obj instanceof CurrencyInfo || _obj instanceof CurrencyInfo[]) {
                // empty if block
            }
        }
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            int i;
            int in;
            Object[] _objs;
            boolean _hasObject;
            Object _obj = null;
            _obj = this.prmtBgScheme.getData();
            if (_obj == null) {
                this.prmtBgScheme.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectBgScheme"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtBgScheme.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectBgScheme"));
                        return false;
                    }
                }
            }
            _obj = this.prmtBgPeriod.getData();
            if (_obj == null) {
                this.prmtBgPeriod.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectBgPeriod"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtBgPeriod.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectBgPeriod"));
                        return false;
                    }
                }
            }
            _obj = this.prmtCurrency.getData();
            if (_obj == null) {
                this.prmtCurrency.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectCurrency"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtCurrency.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectCurrency"));
                        SysUtil.abort();
                    }
                }
            }
            _obj = this.prmtState.getData();
            if (_obj == null) {
                this.prmtState.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectState"));
                SysUtil.abort();
            } else {
                _hasObject = false;
                _objs = null;
                if (_obj instanceof Object[]) {
                    _objs = (Object[])_obj;
                    in = _objs.length;
                    for (i = 0; i < in; ++i) {
                        if (_objs[i] == null) continue;
                        _hasObject = true;
                        break;
                    }
                    if (!_hasObject) {
                        this.prmtState.requestFocus();
                        MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectState"));
                        SysUtil.abort();
                    }
                }
            }
        }
        return re;
    }

    protected FilterParam createNewFilterParam() {
        return new BgCourseFilterParam();
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgCourseFilterParam) {
            BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
            Object _obj = null;
            _obj = this.prmtBgScheme.getData();
            if (_obj != null) {
                if (_obj instanceof BgSchemeInfo) {
                    _filterParam.setBgScheme((BgSchemeInfo)_obj);
                } else if (_obj instanceof BgSchemeInfo[]) {
                    _filterParam.setBgScheme((BgSchemeInfo[])_obj);
                }
            } else {
                _filterParam.clearBgScheme();
            }
            _obj = this.prmtBgTemplate.getData();
            if (_obj != null) {
                if (_obj instanceof BgTemplateObject) {
                    _filterParam.setTemplateInfo(BgFormCourseHelper.tempObj2TempArray((BgTemplateObject)_obj));
                } else {
                    this.prmtBgTemplate.setData(null);
                }
            } else {
                _filterParam.clearBgTemplate();
            }
            _obj = this.prmtBgPeriod.getData();
            if (_obj != null) {
                if (_obj instanceof BgPeriodInfo) {
                    _filterParam.setBgPeriod((BgPeriodInfo)_obj);
                } else if (_obj instanceof BgPeriodInfo[]) {
                    _filterParam.setBgPeriod((BgPeriodInfo[])_obj);
                }
            } else {
                _filterParam.clearBgPeriod();
            }
            _obj = this.prmtCurrency.getData();
            if (_obj != null) {
                if (_obj instanceof CurrencyInfo) {
                    _filterParam.setCurrency((CurrencyInfo)_obj);
                } else if (_obj instanceof BgPeriodInfo[]) {
                    _filterParam.setCurrency((CurrencyInfo[])_obj);
                } else if (_obj instanceof Object[]) {
                    _filterParam.setCurrency((Object[])_obj);
                }
            } else {
                _filterParam.clearCurrency();
            }
            _obj = this.prmtState.getData();
            if (_obj != null) {
                if (_obj instanceof BgFormStateEnum) {
                    _filterParam.setState((BgFormStateEnum)_obj);
                } else if (_obj instanceof BgFormStateEnum[]) {
                    _filterParam.setState((BgFormStateEnum[])_obj);
                }
            } else {
                _filterParam.clearState();
            }
        }
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgCourseFilterParam) {
            BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
            if (_filterParam.getBgScheme() != null) {
                this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
            } else {
                this.prmtBgScheme.setData(null);
            }
            if (_filterParam.getBgPeriod() != null) {
                this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriod());
            } else {
                this.prmtBgPeriod.setData(null);
            }
            if (_filterParam.getTemplateInfo() != null) {
                this.prmtBgTemplate.setData((Object)BgFormCourseHelper.tempArray2TempObj(_filterParam.getTemplateInfo()));
            } else {
                this.prmtBgTemplate.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                this.prmtCurrency.setData((Object)_filterParam.getCurrency());
            } else {
                this.prmtCurrency.setData(null);
            }
            if (_filterParam.getState() != null) {
                this.prmtState.setData((Object)_filterParam.getState());
            } else {
                this.prmtState.setData(null);
            }
        }
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgCourseFilterParam)) {
            return;
        }
        String tmpStr = null;
        List tmpList = null;
        BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
        try {
            tmpStr = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgScheme(new BgSchemeInfo());
                _filterParam.getBgScheme()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearBgScheme();
            }
            tmpStr = cp.getCustomerParam(TEMPLATE_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setTemplateInfo(this.getBgTemplateInfos(tmpStr));
            } else {
                _filterParam.clearBgScheme();
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgPeriod(new BgPeriodInfo());
                _filterParam.getBgPeriod()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearBgPeriod();
            }
            tmpStr = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency()[0].setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.clearCurrency();
            }
            tmpList = (List)BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.decode((String)cp.getCustomerParam(STATE)));
            if (tmpList != null && !tmpList.isEmpty()) {
                BgFormStateEnum[] state = new BgFormStateEnum[tmpList.size()];
                int in = tmpList.size();
                for (int i = 0; i < in; ++i) {
                    state[i] = BgFormStateEnum.getEnum((int)((Integer)tmpList.get(i)));
                }
                _filterParam.setState(state);
            } else {
                _filterParam.clearState();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgCourseFilterParam)) {
            return;
        }
        BgSchemeInfo[] _objs = null;
        BgFormStateEnum state2 = null;
        BgFormStateEnum[] states = null;
        ArrayList<Integer> tmpList = null;
        BgCourseFilterParam _filterParam = (BgCourseFilterParam)filterParam;
        try {
            _objs = _filterParam.getBgScheme();
            if (_objs != null && _objs[0] instanceof BgSchemeInfo) {
                cp.addCustomerParam(BGSCHEME_ID, _objs[0].getId().toString());
            } else {
                cp.removeCustomerParam(BGSCHEME_ID);
            }
            _objs = _filterParam.getTemplateInfo();
            if (_objs != null && _objs instanceof BgTemplateInfo[]) {
                cp.addCustomerParam(TEMPLATE_ID, this.combineBgTemplateIDS((BgTemplateInfo[])_objs));
            } else {
                cp.removeCustomerParam(TEMPLATE_ID);
            }
            _objs = _filterParam.getBgPeriod();
            if (_objs != null && _objs[0] instanceof BgPeriodInfo) {
                cp.addCustomerParam(BGPERIOD_ID, ((BgPeriodInfo)_objs[0]).getId().toString());
            } else {
                cp.removeCustomerParam(BGPERIOD_ID);
            }
            _objs = _filterParam.getCurrency();
            if (_objs != null && _objs[0] instanceof CurrencyInfo) {
                cp.addCustomerParam(CURRENCY_ID, ((CurrencyInfo)_objs[0]).getId().toString());
            } else {
                cp.removeCustomerParam(CURRENCY_ID);
            }
            states = _filterParam.getState();
            if (states != null && states.length > 0) {
                tmpList = new ArrayList<Integer>();
                for (BgFormStateEnum state2 : states) {
                    tmpList.add(new Integer(state2.getValue()));
                }
                cp.addCustomerParam(STATE, BgAnalyseHelper.encode((byte[])BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(STATE);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    private String combineBgTemplateIDS(BgTemplateInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = infos.length;
        for (int i = 0; i < size; ++i) {
            sb.append(infos[i].getId().toString()).append("!");
        }
        return sb.toString();
    }

    private BgTemplateInfo[] getBgTemplateInfos(String ids) throws BOSException {
        if (StringUtils.isEmpty((String)ids)) {
            return null;
        }
        String[] tmps = ids.split("!");
        BgTemplateInfo[] infos = new BgTemplateInfo[tmps.length];
        BOSUuid id = null;
        BgTemplateInfo info = null;
        int size = tmps.length;
        for (int i = 0; i < size; ++i) {
            id = BOSUuid.read((String)tmps[i]);
            info = new BgTemplateInfo();
            info.setId(id);
            infos[i] = info;
        }
        return infos;
    }

    public void clear() {
        super.clear();
        this.prmtBgScheme.setData(null);
        this.prmtBgPeriod.setData(null);
        CurrencyInfo currencyInfo = BgNFCHelper.getBaseCurrency(this.currOrgUnit.getId());
        if (currencyInfo != null) {
            try {
                currencyInfo = this.getCurrencyInterface().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
                this.prmtCurrency.setData((Object)currencyInfo);
            }
            catch (Exception ex) {
                this.prmtCurrency.setData(null);
                logger.error((Object)ex);
            }
        }
        this.prmtState.setData(null);
        this.prmtBgTemplate.setData(null);
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            KDPromptSelector _obj = this.prmtBgPeriod.getSelector();
            if (_obj != null && _obj instanceof BgPeriodDialog) {
                ((BgPeriodDialog)_obj).close();
            }
            if ((_obj = this.prmtState.getSelector()) != null && _obj instanceof BgFormCourseStateDialog) {
                ((BgFormCourseStateDialog)_obj).close();
            }
        }
        return re;
    }

    protected BgTemplateCollection getBgTemplateOfBgScheme(BOSUuid bgSchemeId, String orgId) throws Exception {
        return this.getNFacadeInterface().getBgTemplateInfo(bgSchemeId, orgId);
    }

    protected IBgNFFacade getNFacadeInterface() throws Exception {
        return BgNFFacadeFactory.getRemoteInstance();
    }

    public Object getFilterObject(CustomerParams cp) {
        if (cp.getCustomerParam("FILTERPARAM") != null) {
            MaQuerySolutionUpgrande upGrande = new MaQuerySolutionUpgrande();
            FilterParam filterParam = null;
            if (upGrande.isNewQuerySolution(upGrande.cast(cp))) {
                try {
                    filterParam = (FilterParam)upGrande.convertToParams(((Object)((Object)this)).getClass().getName(), cp.getCustomerParam("FILTERPARAM"));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                filterParam = (FilterParam)super.getFilterObject(cp);
            }
            return filterParam;
        }
        return null;
    }

    public void setFilterObject(CustomerParams cp, Object param) {
        MaQuerySolutionUpgrande upGrande = new MaQuerySolutionUpgrande();
        try {
            String params = upGrande.serial(((Object)((Object)this)).getClass().getName(), upGrande.convertToMyParams(param));
            cp.addCustomerParam("FILTERPARAM", params);
            cp.addCustomerParam("MA_NEW_QUERY_SULUTION", "true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

