/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.SearchKeyEnum;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeCollection;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCalculateSchemeAssignUI;
import com.kingdee.eas.ma.nbudget.client.BgCalculateSchemeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgCalculateSchemeAssignUI
extends AbstractBgCalculateSchemeAssignUI
implements PropertyChangeListener,
AssignSolutionInterface {
    private static final Logger logger = Logger.getLogger(BgCalculateSchemeAssignUI.class);
    private boolean hasNotChooseTemAndOrg = true;
    private static final long serialVersionUID = 884772483775769857L;
    private boolean isSelectTemAll = false;
    private TreeModel treeModelOld = null;
    private Hashtable temMap = new Hashtable();
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgSchemeResource";
    private Map scriptMap = new HashMap();
    private Map specialMap = new HashMap();
    private Map storeStateCache = new HashMap();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String selectedOldTableItemID;
    private OrgUnitInfo org = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setVisible(false);
        this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setEnabled(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BgCalculateSchemeAssignUI.this.action_search();
                }
                catch (Exception e) {
                    BgCalculateSchemeAssignUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        this.btnSelectNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BgCalculateSchemeAssignUI.this.action_selectNowTemp(arg0);
                }
                catch (Exception e) {
                    BgCalculateSchemeAssignUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        this.initComBoxOrgType();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(true);
        this.refreshOrgUnitTree();
        this.initTable(null, null, null);
        this.support.addPropertyChangeListener("selectedOldTableItemID", this);
        this.chBoxTogether.setSelected(false);
        this.chBoxTogether.setVisible(false);
        this.initLabel1Visual();
        this.comboSearchKey.removeItem((Object)SearchKeyEnum.templeNum);
        this.comboSearchKey.removeItem((Object)SearchKeyEnum.tempName);
    }

    public String getUITitle() {
        return super.getUITitle();
    }

    @Override
    protected void btnOnlyUpdateAddFormulaToAuditFormAndActualForm_stateChanged(ChangeEvent e) throws Exception {
        this.initLabel1Visual();
    }

    private void initLabel1Visual() {
        if (this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected()) {
            this.kDLabel1.setVisible(true);
        } else {
            this.kDLabel1.setVisible(false);
        }
    }

    private void action_selectNowTemp(ActionEvent arg0) {
        this.hasNotChooseTemAndOrg = false;
        KDTSelectBlock sb = null;
        int size = this.temTable.getSelectManager().size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size && i != this.temTable.getRowCount() - 1 - 1; ++i) {
            sb = this.temTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.temTable.getRow(j).getCell("select").setValue((Object)true);
            }
        }
    }

    void action_search() throws Exception {
        if (this.txtKey.getText() == null || this.txtKey.getText().trim().length() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"195_BgCtrlSchemeAssignChildUI"));
            this.txtKey.requestFocus();
            return;
        }
        String value = this.txtKey.getText();
        SearchKeyEnum keyEnum = (SearchKeyEnum)this.comboSearchKey.getSelectedItem();
        if (keyEnum.getValue() == 10) {
            TreeModel model = null;
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"name", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
        } else if (keyEnum.getValue() == 0) {
            TreeModel model = null;
            model = NewOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"number", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
        } else if (keyEnum.getValue() == 20) {
            this.initTable(null, "number", value);
        } else if (keyEnum.getValue() == 30) {
            this.initTable(null, "name", value);
        }
    }

    private void initTable(String bgSchemeId, String searchKey, String searchValue) throws Exception {
        this.temTable.checkParsed();
        this.temTable.removeRows();
        String orgId = (String)this.getUIContext().get("CUID");
        if (orgId == null || orgId.trim().length() < 0) {
            return;
        }
        BgCalculateSchemeCollection col = (BgCalculateSchemeCollection)((Object)this.getUIContext().get("col"));
        for (int i = 0; i < col.size(); ++i) {
            BgCalculateSchemeInfo info = col.get(i);
            IRow row = this.temTable.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("creator").setValue((Object)info.getCreator().getName());
            row.getCell("createtime").setValue((Object)info.getCreateTime());
            this.storeStateCache.put(info.getId().toString(), null);
        }
        IRow row = this.temTable.addRow();
        row.getStyleAttributes().setHided(true);
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        Object treeModel = null;
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            this.treeModelOld = BgNFSHelper.getFullTreeModel(rootUnitID);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
            root.setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(this.treeModelOld);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    void setTreeNodeSelected(DefaultKingdeeTreeNode parent, boolean selected) {
        parent.setChecked(selected);
        DefaultKingdeeTreeNode node = null;
        Enumeration children = parent.children();
        while (children.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)children.nextElement();
            this.setTreeNodeSelected(node, selected);
        }
    }

    protected BgTemplateCollection getBgTemColl(String schemeId, String searchKey, String searchValue) throws BOSException, EASBizException, Exception {
        BgTemplateCollection result = new BgTemplateCollection();
        String locale = SysContext.getSysContext().getLocale().toString();
        String sql = "select a.fid,a.fnumber, a.fname,a.fcreatorid,a.fcreatetime,c.fname_" + locale + " , a.FFormType from t_bg_bgtemplate a ,t_bg_bgschemenode b ,t_pm_user c  where a.fcreatorid=c.fid and a.fid = b.fbgtemplateid and b.fbgschemeid='" + schemeId + "'";
        if (searchKey != null && searchKey.trim().length() > 0 && searchValue != null && searchValue.trim().length() > 0) {
            if (searchKey.equalsIgnoreCase("number")) {
                searchKey = "a.fnumber";
            } else if (searchKey.equalsIgnoreCase("name")) {
                searchKey = "a.fname";
            }
            sql = sql + " and " + searchKey + " like '%" + searchValue + "%'  order by a.fnumber";
        } else {
            sql = sql + " order by a.fnumber";
        }
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                BgTemplateInfo info = new BgTemplateInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setNumber(rs.getString(2));
                info.setName(rs.getString(3));
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)rs.getString(4)));
                user.setName(rs.getString(6));
                info.setCreator(user);
                info.setCreateTime(rs.getTimestamp(5));
                if (2 == rs.getInt(7)) {
                    this.scriptMap.put(rs.getString(1), null);
                }
                if (3 == rs.getInt(7)) {
                    this.specialMap.put(rs.getString(1), null);
                }
                result.add(info);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return result;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.hasNotChooseTemAndOrg) {
            int rowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
            if (rowID == -1 || rowID == this.temTable.getRowCount() - 1) {
                if (this.isSelectTemAll) {
                    rowID = this.temTable.getRowCount() - 1 - 1;
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
                    return;
                }
            }
            int rowCount = this.temTable.getRowCount() - 1;
            boolean isSelect = false;
            for (int i = 0; !(i >= rowCount || this.temTable.getRow(i).getCell("select").getValue() != null && (isSelect = ((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue())); ++i) {
            }
            if (!isSelect) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
                return;
            }
            if (this.chBoxTogether.isSelected()) {
                Map map = this.getSelectedNodesInTree();
                if (map.size() > 0) {
                    String keyID = this.temTable.getRow(rowID).getCell("id").getValue().toString();
                    this.storeStateCache.put(keyID, map);
                    for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
                        String tempId;
                        if (!((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue() || (tempId = this.temTable.getRow(i).getCell("id").getValue().toString()).equals(keyID)) continue;
                        this.storeStateCache.put(tempId, map);
                    }
                }
            } else {
                this.doAfterConfirm(rowID);
            }
        }
        this.validateSetting();
        Object[] obj = this.adapter();
        if (obj == null || obj.length < 2) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
            return;
        }
        Object ui = this.getUIContext().get("Owner");
        if (ui instanceof BgCalculateSchemeListUI) {
            BgCalculateSchemeListUI bGui = (BgCalculateSchemeListUI)((Object)ui);
            String id = (String)this.getUIContext().get("CUID");
            FullOrgUnitInfo org = null;
            if (id != null) {
                org = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            bGui.assignDetail(this, (ArrayList)obj[0], org, (Hashtable)obj[1]);
        }
        this.clearSolutionList();
    }

    private int getScriptType(Hashtable map) {
        String key2 = null;
        String key12 = null;
        HashMap selectMap = new HashMap();
        for (String key2 : map.keySet()) {
            Vector vec = (Vector)map.get(key2);
            for (String key12 : vec) {
                selectMap.put(key12, null);
            }
        }
        int scriptType = -1;
        for (String key2 : selectMap.keySet()) {
            if (this.scriptMap.containsKey(key2)) {
                if (scriptType == -1) {
                    scriptType = 3;
                    continue;
                }
                if (scriptType != 1) continue;
                scriptType = 2;
                continue;
            }
            if (scriptType == -1) {
                scriptType = 1;
                continue;
            }
            if (scriptType != 3) continue;
            scriptType = 2;
        }
        return scriptType;
    }

    private int getSpecialType(Hashtable map) {
        String key2 = null;
        String key12 = null;
        HashMap selectMap = new HashMap();
        for (String key2 : map.keySet()) {
            Vector vec = (Vector)map.get(key2);
            for (String key12 : vec) {
                selectMap.put(key12, null);
            }
        }
        int specialType = -1;
        for (String key2 : selectMap.keySet()) {
            if (this.specialMap.containsKey(key2)) {
                if (specialType == -1) {
                    specialType = 3;
                    continue;
                }
                if (specialType != 1) continue;
                specialType = 2;
                break;
            }
            if (specialType == -1) {
                specialType = 1;
                continue;
            }
            if (specialType != 3) continue;
            specialType = 2;
            break;
        }
        return specialType;
    }

    private void doAfterConfirm(int rowID) {
        String keyID = this.temTable.getRow(rowID).getCell("id").getValue().toString();
        Map map = this.getSelectedNodesInTree();
        if (map.size() > 0) {
            this.storeStateCache.put(keyID, map);
        }
    }

    private void validateSetting() {
        int rowCount = this.temTable.getRowCount() - 1;
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                IRow row = this.temTable.getRow(i);
                boolean isSelected = Boolean.valueOf(row.getCell("select").getValue().toString());
                String itemID = row.getCell("id").getValue().toString();
                Map map = (Map)this.storeStateCache.get(itemID);
                if (!isSelected && map != null && map.size() != 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)"\u4f60\u9009\u62e9\u4e86\u7ec4\u7ec7\uff0c\u5374\u6ca1\u6709\u9009\u62e9\u91cd\u7b97\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\uff01");
                    SysUtil.abort();
                    continue;
                }
                if (!isSelected || map != null && map.size() != 0) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"pleaseSelectOrg"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.storeStateCache.clear();
        this.destroyWindow();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(true);
    }

    protected FullOrgUnitInfo getInDirectOrgUnit() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!node.isCheckBoxVisible()) {
            return null;
        }
        if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return null;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        if (oui == null || oui.getUnit() == null) {
            return null;
        }
        boolean isCkecked = node.isChecked();
        FullOrgUnitInfo info = oui.getUnit();
        String id = info.getId().toString();
        try {
            FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id where id='" + id + "'");
            info.setCU(info1.getCU());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        info.setLongNumber(oui.getLongNumber());
        info.put("bg_isChecked", (Object)new Boolean(isCkecked));
        return info;
    }

    private OrgUnitInfo getDirectOrgUnit() {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        this.org = (OrgUnitInfo)this.table.getRow(rowIndex).getUserObject();
        return this.org;
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.doAllSelAndAllClr(false);
    }

    protected void table_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        OrgUnitInfo org = this.getDirectOrgUnit();
        if (org == null) {
            return;
        }
        this.localSelectTem(org);
    }

    private void localSelectTem(OrgUnitInfo org) {
        for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue(null);
        }
        String orgId = org.getId().toString();
        if (this.temMap.containsKey(orgId)) {
            Vector vec = (Vector)this.temMap.get(orgId);
            for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
                String id = (String)this.temTable.getRow(i).getCell("id").getValue();
                if (vec.contains(id)) {
                    this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
                    continue;
                }
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        } else {
            for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
                this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected void temTable_editStopped(KDTEditEvent e) throws Exception {
        super.temTable_editStopped(e);
    }

    @Override
    protected void temTable_editStarted(KDTEditEvent e) throws Exception {
        this.isSelectTemAll = false;
        this.hasNotChooseTemAndOrg = false;
        super.temTable_editStarted(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setAllTreeNodesUncheckedOrChecked(root, false);
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        int currentRowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (currentRowID == this.temTable.getRowCount() - 1) {
            return;
        }
        String currentKeyID = this.temTable.getRow(currentRowID).getCell("id").getValue().toString();
        this.support.firePropertyChange("selectedOldTableItemID", this.getSelectedOldTableItemID(), currentKeyID);
        Object obj = this.storeStateCache.get(currentKeyID);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (obj != null) {
            Map map = (Map)obj;
            this.setSelectedNodesForTree(map, root);
        } else {
            this.setSelectedNodesForTree(null, root);
        }
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        int rowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (rowID == this.temTable.getRowCount() - 1) {
            return;
        }
        int y = e.getColIndex();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (rowID != -1 && y != -1) {
            this.setDefaultColorForTreeNode(root);
            if (this.temTable.getColumnKey(y).equals("select")) {
                this.changeTableSelectValue(rowID);
            }
            String rootID = this.getTemRootId(rowID);
            Hashtable orgMap = new Hashtable();
            this.getAllOrgId(rootID, root, orgMap);
            Hashtable assignOrgMap = this.getIsAreadyDispatched(rootID, orgMap);
            this.setColorForNode(root, assignOrgMap);
        }
    }

    private Hashtable getIsAreadyDispatched(String rootID, Map orgMap) throws Exception {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String orgIdStr = "(''";
        for (String id : orgMap.keySet()) {
            orgIdStr = orgIdStr + ",'" + id + "'";
        }
        orgIdStr = orgIdStr + ")";
        String sql = "select orgUnit.id  where orgUnit.id in " + orgIdStr + " and rootid = '" + rootID + "' ";
        BgCalculateSchemeCollection col = BgCalculateSchemeFactory.getRemoteInstance().getBgCalculateSchemeCollection(sql);
        String orgId = null;
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                orgId = col.get(i).getOrgUnit().getId().toString();
                result.put(orgId, orgId);
            }
        }
        return result;
    }

    private String getTemRootId(int rowID) {
        if (rowID == this.temTable.getRowCount() - 1) {
            return null;
        }
        String id = this.temTable.getRow(rowID).getCell("id").getValue().toString();
        BgCalculateSchemeInfo info = null;
        try {
            info = BgCalculateSchemeFactory.getRemoteInstance().getBgCalculateSchemeInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        catch (EASBizException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        String rootID = info.getRootId().toString();
        return rootID;
    }

    private void changeTableSelectValue(int rowID) {
        if (rowID == this.temTable.getRowCount() - 1) {
            return;
        }
        boolean isSelected = Boolean.valueOf(this.temTable.getRow(rowID).getCell("select").getValue().toString());
        if (isSelected) {
            this.temTable.getRow(rowID).getCell("select").setValue((Object)Boolean.FALSE);
        } else {
            this.temTable.getRow(rowID).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }

    private void getAllOrgId(String rootID, DefaultKingdeeTreeNode root, Hashtable orgMap) {
        if (rootID == null) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            String orgUnitID = oui.getUnit().getId().toString();
            orgMap.put(orgUnitID, orgUnitID);
            if (node.isLeaf()) continue;
            this.getAllOrgId(rootID, node, orgMap);
        }
    }

    private void setColorForNode(DefaultKingdeeTreeNode root, Hashtable assignOrgMap) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            String orgUnitID = oui.getUnit().getId().toString();
            if (assignOrgMap.containsKey(orgUnitID)) {
                node.setTextColor(Color.red);
            }
            if (node.isLeaf()) continue;
            this.setColorForNode(node, assignOrgMap);
        }
    }

    private void setDefaultColorForTreeNode(DefaultKingdeeTreeNode rootNode) {
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(Color.BLACK);
            if (node.isLeaf()) continue;
            this.setDefaultColorForTreeNode(node);
        }
    }

    private Map getSelectedNodesInTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        HashMap map = new HashMap();
        this.deepViewTree(map, root);
        return map;
    }

    private void setSelectedNodesForTree(Map map, DefaultKingdeeTreeNode root) {
        if (map == null || map.size() == 0) {
            this.setAllTreeNodesUncheckedOrChecked(root, false);
        } else {
            Enumeration children = root.children();
            Set keySet = map.keySet();
            Object[] key = null;
            key = keySet.toArray();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
                boolean isContains = false;
                int size = key.length;
                for (int i = 0; i < size; ++i) {
                    DefaultKingdeeTreeNode nodeTem = (DefaultKingdeeTreeNode)key[i];
                    if (nodeTem.getUserObject() == null || !(nodeTem.getUserObject() instanceof OrgStructureInfo) || node.getUserObject() == null || !(node.getUserObject() instanceof OrgStructureInfo)) continue;
                    OrgStructureInfo orgTemKey = (OrgStructureInfo)nodeTem.getUserObject();
                    OrgStructureInfo orgTemNode = (OrgStructureInfo)node.getUserObject();
                    if (!orgTemKey.getId().equals((Object)orgTemNode.getId())) continue;
                    isContains = true;
                    break;
                }
                if (isContains) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
                if (node.isLeaf()) continue;
                this.setSelectedNodesForTree(map, node);
            }
        }
    }

    public Map getStoreStateCache() {
        return this.storeStateCache;
    }

    public String getSelectedOldTableItemID() {
        return this.selectedOldTableItemID;
    }

    public void setSelectedOldTableItemID(String selectedOldTableItemID) {
        this.selectedOldTableItemID = selectedOldTableItemID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasNotChooseTemAndOrg) {
            this.hasNotChooseTemAndOrg = false;
            return;
        }
        Object obj = evt.getOldValue();
        if (obj == null) {
            this.setSelectedOldTableItemID(evt.getNewValue().toString());
            return;
        }
        String oldKey = obj.toString();
        this.storeStateCache.put(oldKey, this.getSelectedNodesInTree());
        this.setSelectedOldTableItemID(evt.getNewValue().toString());
    }

    private void deepViewTree(Map treeMap, DefaultKingdeeTreeNode rootNode) {
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isChecked()) {
                treeMap.put(node, rootNode);
            }
            if (node.isLeaf()) continue;
            this.deepViewTree(treeMap, node);
        }
    }

    private void setAllTreeNodesUncheckedOrChecked(DefaultKingdeeTreeNode rootNode, boolean state) {
        rootNode.setChecked(state);
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isLeaf()) {
                node.setChecked(state);
                continue;
            }
            this.setAllTreeNodesUncheckedOrChecked(node, state);
        }
    }

    public Object[] adapter() {
        if (this.storeStateCache == null || this.storeStateCache.size() == 0) {
            return new Object[0];
        }
        ArrayList templateIDList = new ArrayList(this.storeStateCache.keySet());
        ArrayList subOrgs = this.getSubOrgs(templateIDList, this.storeStateCache);
        Hashtable tempMap = this.rebuildMap(templateIDList, this.storeStateCache);
        Object[] array = new Object[]{subOrgs, tempMap};
        return array;
    }

    private ArrayList getSubOrgs(ArrayList keyList, Map map) {
        HashSet set = new HashSet();
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            String templateID = keyList.get(i).toString();
            Object orgMap = map.get(templateID);
            if (orgMap == null) continue;
            this.getSubOrgInfo((Map)orgMap, set);
        }
        return new ArrayList(set);
    }

    private void getSubOrgInfo(Map map, Set set) {
        if (map.size() == 0) {
            return;
        }
        for (DefaultKingdeeTreeNode node : map.keySet()) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            set.add(info);
        }
    }

    private Hashtable rebuildMap(ArrayList keyList, Map map) {
        Hashtable table = new Hashtable();
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            List list;
            String templateID = keyList.get(i).toString();
            Object orgMap = map.get(templateID);
            if (orgMap == null || (list = this.getSubOrgID((Map)orgMap)) == null || list.isEmpty()) continue;
            int _num = list.size();
            for (int _i = 0; _i < _num; ++_i) {
                String orgID = list.get(_i).toString();
                Object templateIDsVector = table.get(orgID);
                if (templateIDsVector != null && templateIDsVector instanceof Vector) {
                    Vector tempVctr = (Vector)templateIDsVector;
                    tempVctr.add(templateID);
                    continue;
                }
                Vector<String> templateIDsVctr = new Vector<String>();
                templateIDsVctr.add(templateID);
                table.put(orgID, templateIDsVctr);
            }
        }
        return table;
    }

    private List getSubOrgID(Map map) {
        if (map.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (DefaultKingdeeTreeNode node : map.keySet()) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            list.add(oui.getUnit().getId().toString());
        }
        return list;
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setAllTreeNodesUncheckedOrChecked(root, false);
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
        this.isSelectTemAll = false;
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.hasNotChooseTemAndOrg = false;
        this.isSelectTemAll = true;
        for (i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
        for (i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.doAfterConfirm(i);
        }
    }

    @Override
    protected void chBoxTogether_actionPerformed(ActionEvent e) throws Exception {
        super.chBoxTogether_actionPerformed(e);
        if (this.chBoxTogether.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"togetherNotice"));
        }
    }

    public boolean destroyWindow() {
        boolean isDestroy = super.destroyWindow();
        if (isDestroy && this.getUIContext().get("ID") != null) {
            BgClientHelper.releaseMutexService((String)this.getUIContext().get("ID").toString());
        }
        return isDestroy;
    }

    public void clear() throws Exception {
        int i = 0;
        int rowCount = this.temTable.getRowCount() - 1;
        for (i = 0; i < rowCount; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)false);
        }
        this.isSelectTemAll = false;
        DefaultTreeModel node = (DefaultTreeModel)this.treeOrgUnit.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.getRoot();
        this.setTreeNodeSelected(root, false);
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
        this.chBoxTogether.setSelected(false);
    }

    public Object saveSolution() throws Exception {
        int rowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (rowID == this.temTable.getRowCount() - 1) {
            rowID = -1;
        }
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put("chBoxTogether", this.chBoxTogether.isSelected());
        objMap.put("OnlyUpdateAddFormulaToAuditFormAndActualForm", this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected());
        if (rowID == -1) {
            if (this.isSelectTemAll) {
                rowID = this.temTable.getRowCount() - 1 - 1;
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
                SysUtil.abort();
            }
        }
        int rowCount = this.temTable.getRowCount() - 1;
        boolean isSelect = false;
        for (int i = 0; !(i >= rowCount || this.temTable.getRow(i).getCell("select").getValue() != null && (isSelect = ((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue())); ++i) {
        }
        if (!isSelect) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
            SysUtil.abort();
        }
        if (this.chBoxTogether.isSelected()) {
            Map map = this.getSelectedNodesInTree();
            if (map.size() > 0) {
                String keyID = this.temTable.getRow(rowID).getCell("id").getValue().toString();
                this.storeStateCache.put(keyID, map);
                for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
                    String tempId;
                    if (!((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue() || (tempId = this.temTable.getRow(i).getCell("id").getValue().toString()).equals(keyID)) continue;
                    this.storeStateCache.put(tempId, map);
                }
            }
        } else {
            this.doAfterConfirm(rowID);
        }
        this.validateSetting();
        Object[] obj = this.adapter();
        if (obj == null || obj.length < 2) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"please.choose.first"));
            SysUtil.abort();
        }
        if (this.storeStateCache != null && !this.storeStateCache.isEmpty()) {
            HashMap mapTem = new HashMap();
            for (Object key : this.storeStateCache.keySet()) {
                Object value = this.storeStateCache.get(key);
                if (value == null || !(value instanceof Map) || ((Map)value).isEmpty()) continue;
                HashMap<String, String> mapTemValue = new HashMap<String, String>();
                Map valueMap = (Map)value;
                if (valueMap.isEmpty()) break;
                for (Object valueKey : valueMap.keySet()) {
                    Object valueValue;
                    String valueIdKey = null;
                    String valueIdValue = null;
                    if (valueKey instanceof DefaultKingdeeTreeNode) {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)valueKey;
                        if (node == null || node.getUserObject() == null || !(node.getUserObject() instanceof OrgStructureInfo)) continue;
                        valueIdKey = ((OrgStructureInfo)node.getUserObject()).getUnit().getId().toString();
                    }
                    if ((valueValue = valueMap.get(valueKey)) instanceof DefaultKingdeeTreeNode) {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)valueValue;
                        valueIdValue = node != null && node.getUserObject() != null && node.getUserObject() instanceof OrgStructureInfo ? ((OrgStructureInfo)node.getUserObject()).getUnit().getId().toString() : null;
                    }
                    mapTemValue.put(valueIdKey, valueIdValue);
                }
                mapTem.put(key, mapTemValue);
            }
            this.storeStateCache = mapTem;
        }
        objMap.put("storeStateCache", this.storeStateCache);
        return objMap;
    }

    public void reloadSolution(Object o) throws Exception {
        this.selectedOldTableItemID = null;
        this.hasNotChooseTemAndOrg = true;
        Map objMap = (Map)o;
        if (objMap == null) {
            return;
        }
        this.storeStateCache = (Map)objMap.get("storeStateCache");
        if (objMap.get("chBoxTogether") != null && objMap.get("chBoxTogether") instanceof Boolean) {
            boolean chBoxTogetherValue = (Boolean)objMap.get("chBoxTogether");
            this.chBoxTogether.setSelected(chBoxTogetherValue);
        }
        boolean OnlyUpdateAddFormulaToAuditFormAndActualForm = false;
        if (objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") != null && objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") instanceof Boolean) {
            OnlyUpdateAddFormulaToAuditFormAndActualForm = (Boolean)objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm");
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(OnlyUpdateAddFormulaToAuditFormAndActualForm);
        } else {
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(false);
        }
        this.initLabel1Visual();
        int CurrentSelectRow = 0;
        String firstID = null;
        HashMap mapStrTotRreeNode = new HashMap();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.initTreeNodeUserObectToIdStringMap(mapStrTotRreeNode, root);
        if (this.storeStateCache != null && this.storeStateCache instanceof Map && !this.storeStateCache.isEmpty()) {
            String temIdTemp;
            HashMap mapTem = new HashMap();
            Set temIdSet = this.storeStateCache.keySet();
            if (temIdSet == null || temIdSet.size() < 1) {
                return;
            }
            Iterator iterator = temIdSet.iterator();
            while (iterator.hasNext() && (temIdTemp = (String)iterator.next()) != null && temIdTemp.trim().length() >= 1) {
                int size = this.temTable.getRowCount() - 1;
                for (int i = 0; i < size; ++i) {
                    String idColValue = (String)this.temTable.getRow(i).getCell("id").getValue();
                    if (!idColValue.equals(temIdTemp)) continue;
                    if (firstID == null) {
                        firstID = idColValue;
                        CurrentSelectRow = i;
                    }
                    this.temTable.getRow(i).getCell("select").setValue((Object)true);
                    break;
                }
                Object value = this.storeStateCache.get(temIdTemp);
                HashMap<DefaultKingdeeTreeNode, DefaultKingdeeTreeNode> mapTemValue = new HashMap<DefaultKingdeeTreeNode, DefaultKingdeeTreeNode>();
                Map valueMap = (Map)value;
                if (valueMap.isEmpty()) break;
                String keyStr2 = null;
                DefaultKingdeeTreeNode keyDef = null;
                String valueStr = null;
                DefaultKingdeeTreeNode valueDef = null;
                for (String keyStr2 : valueMap.keySet()) {
                    valueStr = (String)valueMap.get(keyStr2);
                    if (keyStr2 == null || mapStrTotRreeNode.get(keyStr2) == null) continue;
                    keyDef = (DefaultKingdeeTreeNode)mapStrTotRreeNode.get(keyStr2);
                    valueDef = valueStr != null && mapStrTotRreeNode.get(valueStr) != null ? (DefaultKingdeeTreeNode)mapStrTotRreeNode.get(valueStr) : null;
                    mapTemValue.put(keyDef, valueDef);
                }
                valueMap.clear();
                mapTem.put(temIdTemp, mapTemValue);
            }
            this.storeStateCache.clear();
            this.storeStateCache = mapTem;
        }
        this.temTable.getSelectManager().select(CurrentSelectRow, 0, CurrentSelectRow, this.temTable.getColumnCount());
        if (this.temTable.getRowCount() > 0 && this.storeStateCache.containsKey(firstID)) {
            Map mapOrg = (Map)this.storeStateCache.get(firstID);
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.setSelectedNodesForTree(mapOrg, root);
        }
        mapStrTotRreeNode.clear();
    }

    private void initTreeNodeUserObectToIdStringMap(Map map, DefaultKingdeeTreeNode root) {
        if (root == null || root.getUserObject() == null || !(root.getUserObject() instanceof OrgStructureInfo)) {
            return;
        }
        OrgStructureInfo org = (OrgStructureInfo)root.getUserObject();
        map.put(org.getUnit().getId().toString(), root);
        if (root.isLeaf()) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
            this.initTreeNodeUserObectToIdStringMap(map, child);
        }
    }

    public void clearSolutionList() throws Exception {
    }

    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getMetaDataPK().getFullName() + "'");
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    public boolean conferm(Object obj) throws Exception {
        this.btnConfirm_actionPerformed(null);
        return false;
    }

    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    public Map getReturnData() throws Exception {
        return null;
    }

    public String getNewConfermLabel() {
        return EASResource.getString((String)RESOURCE, (String)"re.assign");
    }

    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    private void doAllSelAndAllClr(boolean selected) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (this.treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        if (root == null) {
            return;
        }
        if (this.chkIncludeChildren.isSelected()) {
            Enumeration nodeEnum = root.breadthFirstEnumeration();
            DefaultKingdeeTreeNode node = null;
            while (nodeEnum.hasMoreElements()) {
                node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
                if (!this.canTheNodeBeSelected(node)) continue;
                node.setChecked(selected);
            }
        } else {
            root.setChecked(selected);
            if (root.getParent() != null) {
                DefaultKingdeeTreeNode node = null;
                for (int i = 0; i < root.getParent().getChildCount(); ++i) {
                    node = (DefaultKingdeeTreeNode)root.getParent().getChildAt(i);
                    if (!this.canTheNodeBeSelected(node)) continue;
                    node.setChecked(selected);
                }
            }
        }
        this.treeOrgUnit.repaint();
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }
}

