/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgCslFormFactory;
import com.kingdee.eas.ma.nbudget.BgCslTemplateInfo;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCombinAndSingleFormListUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Observable;
import java.util.Set;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgCombinAndSingleFormListUI
extends AbstractBgCombinAndSingleFormListUI
implements IBgElimContextUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgCombinAndSingleFormListUI.class);
    private boolean isCslForm = true;

    public void onLoad() throws Exception {
        this.tblMain.putBindContents("mainQuery", new String[]{"id", "number", "name", "bgTemplate.name", "bgCslTemplate.name", "bgScheme.name", "bgPeriod.name", "currency.name", "state", "creator.name", "createTime", "auditor.name", "auditTime", "orgTree.id", "orgUnit.id"});
        if (BgElimContextHelper.isInitialized(this.getUIContext())) {
            super.onLoad();
            BgElimContextHelper.registUIObject(this);
        } else {
            SysUtil.abort();
        }
        this.init();
        if (this.isCslForm) {
            this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(false);
        }
        this.refreshSchemeF7Filter();
        this.refreshTemplateF7filter();
    }

    private void init() throws Exception {
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBeginPeriod.setSelector((KDPromptSelector)dialog);
        this.prmtEndPeriod.setSelector((KDPromptSelector)dialog);
        this.initData();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAddNew.setVisible(false);
        this.itemViewFlow.setVisible(false);
    }

    public String getPermissionNum() {
        return "bg_cslAndForm001_list";
    }

    private void initData() throws Exception {
        if (this.bgElimContext.getCurBgDataType() != null) {
            this.cbxDataType.setSelectedItem((Object)this.bgElimContext.getCurBgDataType());
        }
        if (this.bgElimContext.getCurBgScheme() != null) {
            this.prmtBgScheme.setData((Object)this.bgElimContext.getCurBgScheme());
            this.prmtBgScheme.setEnabled(false);
        }
        if (this.bgElimContext.getCurBgPeriod() != null) {
            this.prmtBeginPeriod.setData((Object)this.bgElimContext.getCurBgPeriod());
            this.prmtEndPeriod.setData((Object)this.bgElimContext.getCurBgPeriod());
            this.prmtBeginPeriod.setEnabled(false);
            this.prmtEndPeriod.setEnabled(false);
        }
    }

    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        this.clearCommonQueryDialog();
        super.treeOrgUnit_valueChanged(e);
    }

    protected void buildTreeFilter() throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo org = oui.getUnit();
            org.setLongNumber(oui.getLongNumber());
            Object orgUnitId = null;
            if (org.isIsUnion()) {
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.ma.nbudget", "BgCslFormListQuery");
                this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(false);
                this.isCslForm = true;
            } else {
                this.mainQueryPK = new MetaDataPK("com.kingdee.eas.ma.budget", "BgFormListQuery");
                this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(true);
                this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(false);
                this.isCslForm = false;
            }
        }
        FilterInfo _filter = new FilterInfo();
        this.mainQuery.setFilter(_filter);
        this.setDefaultEntityViewInfo(null);
        this.refreshSchemeF7Filter();
        this.refreshTemplateF7filter();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter;
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if ((filter = viewInfo.getFilter()) == null) {
            filter = new FilterInfo();
        }
        this.getQueryFilterInfo(filter);
        this.refreshMainFilter(filter);
        if (!this.isCslForm) {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getOrgUnitInfo();
            String userId = this.getUserInfo().getId().toString();
            String orgUnitID = orgUnitInfo == null ? null : orgUnitInfo.getId().toString();
            Set<String> orgSet = null;
            if (BgParamCHelper.isBgPermissionUsed()) {
                orgSet = new HashSet();
                if (this.getPermissionOrg() != null) {
                    orgSet = this.getPermissionOrg();
                } else if (orgUnitID != null) {
                    orgSet.add(orgUnitID);
                }
                filter = BgPermissionHelper.addBgFormPermission(userId, orgSet, filter);
            }
        }
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        this.addFilterItem(filter, new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE));
        viewInfo.setFilter(filter);
        IQueryExecutor que = super.getQueryExecutor(queryPK, viewInfo);
        return que;
    }

    protected void replaceIsFillingFilter(FilterInfo filter) {
        if (filter != null) {
            FilterItemInfo fitem = new FilterItemInfo("bgScheme.isFiling", (Object)new Integer(0), CompareType.EQUALS);
            this.replaceFilterItems(filter, fitem);
        }
    }

    protected void replaceOrgFilter(FilterInfo filter) {
        if (filter != null) {
            String orgId = this.getOrgUnitId();
            if (orgId == null) {
                try {
                    OrgUnitInfo currCompany = this.bgElimContext.getCurOrgGroup();
                    orgId = currCompany.getId().toString();
                }
                catch (BOSException e) {
                    this.handUIExceptionAndAbort((Exception)((Object)e));
                }
            }
            FilterItemInfo fitem = new FilterItemInfo("orgunit.id", (Object)orgId);
            this.replaceFilterItems(filter, fitem);
        }
    }

    protected void replaceDataTypeFilter(FilterInfo filter) {
        if (filter != null) {
            int dataType = 1;
            if (this.cbxDataType.getSelectedItem() instanceof BgDataTypeEnum) {
                dataType = ((BgDataTypeEnum)this.cbxDataType.getSelectedItem()).getValue();
            }
            FilterItemInfo fitem = new FilterItemInfo("dataType", (Object)new Integer(dataType));
            this.replaceFilterItems(filter, fitem);
        }
    }

    protected String getEditUIName() {
        if (this.isCslForm) {
            return BgCslFormProcessUI.class.getName();
        }
        return BgNFormProcessUI.class.getName();
    }

    protected boolean isUseForElim() {
        return true;
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        if (this.isCslForm) {
            return BgCslFormFactory.getRemoteInstance();
        }
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    protected void prmpBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtEndPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
        if (!this.isCslForm) {
            this.refreshTemplateF7filter();
        }
    }

    @Override
    protected void prmtBeginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        this.refreshTable();
    }

    private void refreshTable() throws Exception {
        FilterInfo _filter = new FilterInfo();
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshMainFilter(FilterInfo filter) {
        BgPeriodInfo _bgPeriodInfo;
        Object obj;
        this.replaceOrgFilter(filter);
        if (this.isCslForm) {
            this.replaceDataTypeFilter(filter);
        }
        if ((obj = this.prmtBgScheme.getData()) != null && obj instanceof BgSchemeInfo) {
            BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
        }
        obj = this.prmpBgTemplate.getData();
        String templateNum = null;
        if (obj != null) {
            if (obj instanceof BgTemplateInfo) {
                BgTemplateInfo _bgTemplateInfo = (BgTemplateInfo)obj;
                templateNum = _bgTemplateInfo.getNumber();
            }
            if (obj instanceof BgCslTemplateInfo) {
                BgCslTemplateInfo _bgCslTemplateInfo = (BgCslTemplateInfo)obj;
                templateNum = _bgCslTemplateInfo.getNumber();
            }
            if (this.isCslForm) {
                this.replaceFilterItems(filter, new FilterItemInfo("bgCslTemplate.number", (Object)templateNum, CompareType.EQUALS));
            } else {
                this.replaceFilterItems(filter, new FilterItemInfo("bgTemplate.number", (Object)templateNum, CompareType.EQUALS));
            }
        }
        if ((obj = this.prmtBeginPeriod.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.beginDate", (Object)_bgPeriodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        if ((obj = this.prmtEndPeriod.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.endDate", (Object)_bgPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.prmtBeginPeriod.getData() != null || this.prmtEndPeriod.getData() != null) {
            int bgPeriodType = 0;
            bgPeriodType = this.prmtBeginPeriod.getData() != null ? ((BgPeriodInfo)this.prmtBeginPeriod.getData()).getPeriodType().getValue() : ((BgPeriodInfo)this.prmtEndPeriod.getValue()).getPeriodType().getValue();
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        }
    }

    private void refreshSchemeF7Filter() throws BOSException {
        OrgUnitInfo orgUnit;
        EntityViewInfo schemeView = new EntityViewInfo();
        FilterInfo schemeFilter = new FilterInfo();
        String orgUnitId = null;
        orgUnitId = this.isCslForm ? ((orgUnit = this.bgElimContext.getCurMappedOrgUnit()) != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID") : this.getOrgUnitId();
        schemeFilter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
        schemeFilter.setMaskString("#0");
        schemeView.setFilter(schemeFilter);
        this.prmtBgScheme.setEntityViewInfo(schemeView);
    }

    private void refreshTemplateF7filter() throws BOSException {
        EntityViewInfo templateView = new EntityViewInfo();
        FilterInfo templateFilter = new FilterInfo();
        String orgUnitId = null;
        if (this.isCslForm) {
            OrgUnitInfo orgUnit = this.bgElimContext.getCurMappedOrgUnit();
            orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
            this.prmpBgTemplate.setQueryInfo("com.kingdee.eas.ma.nbudget.BgCslTemplateListQuery");
            this.prmpBgTemplate.setEntityViewInfo(templateView);
        } else {
            orgUnitId = this.getOrgUnitId();
            this.prmpBgTemplate.setQueryInfo("com.kingdee.eas.ma.budget.BgTemplateF7Query");
            templateFilter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
            templateFilter.setMaskString("(#0)");
            Object obj = this.prmtBgScheme.getData();
            if (obj != null && obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                templateFilter.getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
                templateFilter.setMaskString(" #0 and #1");
            }
            templateView.setFilter(templateFilter);
            this.prmpBgTemplate.setEntityViewInfo(templateView);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.isCslForm) {
            this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("bgCslTemplate.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("bgTemplate.name").getStyleAttributes().setHided(false);
        }
    }

    protected String getKeyFieldName() {
        return "id";
    }
}

