/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.CustomerQueryConditionObserver;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgCombinDataFilterParam;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.BgWorkTemplateInfo;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCombinDataFilterUI;
import com.kingdee.eas.ma.nbudget.client.UnionCombinDataF7;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgCombinDataFilterUI
extends AbstractBgCombinDataFilterUI {
    private static final long serialVersionUID = 5889761071666910981L;
    private static final Logger logger = CoreUIObject.getLogger(BgCombinDataFilterUI.class);
    static final String FILTER_UI_KEY = BgCombinDataFilterUI.class.getName();
    private BgCombinDataFilterParam ownFilterParam;
    private KDTEditListener kdUnitEditListener = null;
    private MeasureUnitInfo unitInfo = null;
    private Map orgUnitMapping = null;
    private static final String resourcePath = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    protected static final String resourcePathRpt = "com.kingdee.eas.ma.budget.client.BgRptResource";

    public BgCombinDataFilterParam getOwnFilterParam() {
        if (this.ownFilterParam == null) {
            this.ownFilterParam = new BgCombinDataFilterParam();
        }
        return this.ownFilterParam;
    }

    public void onLoad() throws Exception {
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.currencyBox.setEditable(false);
        this.initBgPeriod();
        this.initMeasureUnit();
        this.refreshOrgBound();
        this.refreshCompany();
        this.refreshWorkTemplateF7();
        this.refreshBgScheme();
        this.orgUnitMapping = BgElimFacadeFactory.getRemoteInstance().getOrgMapping(null);
        this.initMyListener();
        try {
            MeasureUnitCollection unitCollection = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection("select id,number,name,coefficient where measureUnitGroup.number='BUDGET' and isBaseUnit = 1");
            if (unitCollection != null && unitCollection.size() > 0) {
                this.unitInfo = unitCollection.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)resourcePath, (String)"combinFilterTitle");
    }

    private void initMyListener() {
        this.kdUnitEditListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BgCombinDataFilterUI.this.tblMain_editStopped(e);
                }
                catch (Exception e1) {
                    BgCombinDataFilterUI.this.handUIException(e1);
                }
            }
        };
        this.tblMeasureUnit.addKDTEditListener(this.kdUnitEditListener);
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String colName = this.tblMeasureUnit.getColumnKey(colIndex);
        if ("bgElement".equals(colName)) {
            KDTRange range = this.tblMeasureUnit.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = this.tblMeasureUnit.getCell(rowIndex, colIndex).getValue();
            if (object instanceof Object[]) {
                int i;
                Object[] result = (Object[])object;
                int size = result.length;
                int maxRow = this.tblMeasureUnit.getRowCount();
                int leftRow = maxRow - (firstInsertRow + 1);
                if (size > leftRow) {
                    for (i = leftRow; i < size - 1; ++i) {
                        this.tblMeasureUnit.addRow();
                    }
                }
                int length = result.length;
                for (i = 0; i < length; ++i) {
                    BgElementInfo info = (BgElementInfo)result[i];
                    this.tblMeasureUnit.getCell(firstInsertRow, "bgElement").setValue((Object)info);
                    ++firstInsertRow;
                }
            }
        }
    }

    private void initMeasureUnit() throws Exception {
        this.tblMeasureUnit.checkParsed();
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.F7BgElementQuery");
        prmtSelect.setVisible(true);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        this.tblMeasureUnit.getColumn("bgElement").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        KDBizPromptBox prmtSelect2 = null;
        prmtSelect2 = new KDBizPromptBox();
        prmtSelect2.setEditable(false);
        prmtSelect2.setDisplayFormat("$name$");
        prmtSelect2.setEnabledMultiSelection(false);
        prmtSelect2.setQueryInfo("com.kingdee.eas.ma.budget.BgMeasureUnitQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = null;
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        view.setFilter(filterInfo);
        view.getSorter().add(new SorterItemInfo("coefficient"));
        prmtSelect2.setEntityViewInfo(view);
        this.tblMeasureUnit.getColumn("MeasureUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect2));
    }

    private void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = null;
        bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtEndPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setEditable(false);
    }

    private void refreshWorkTemplateF7() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        view.setSorter(sorter);
        this.bgWorkTemplate.setEntityViewInfo(view);
        this.bgWorkTemplate.setEnabled(true);
    }

    private void refreshOrgBound() throws EASBizException, BOSException {
        OrgTreeCollection ocn = BgEliminationHelper.getOrgTreeCollection();
        this.listOrgBound.removeAllItems();
        if (ocn != null) {
            this.listOrgBound.addItems(ocn.toArray());
        }
    }

    private void refreshCompany() {
        OrgTreeInfo orgTreeInfo = null;
        if (this.listOrgBound.getSelectedItem() != null) {
            this.F7Company.setValue(null);
            orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem();
            UnionCombinDataF7 oldf7 = (UnionCombinDataF7)this.F7Company.getSelector();
            UnionCombinDataF7 f7 = new UnionCombinDataF7((IUIObject)this, 2);
            if (oldf7 == null || !orgTreeInfo.getId().toString().equals(oldf7.getTreeID())) {
                f7.setTreeID(orgTreeInfo.getId().toString());
            } else {
                f7 = oldf7;
            }
            HashMap map = null;
            HashMap<String, Boolean> funcPermissionMap = new HashMap<String, Boolean>();
            String orgid = "";
            boolean hasFuncPermission = false;
            try {
                map = (HashMap)PermissionFactory.getRemoteInstance().getUnionUnits(BgEliminationHelper.getPK((IObjectValue)SysContext.getSysContext().getCurrentUserInfo()), BgEliminationHelper.getPK((IObjectValue)orgTreeInfo));
                Iterator iterTmp = map.keySet().iterator();
                while (iterTmp.hasNext()) {
                    orgid = iterTmp.next().toString();
                    hasFuncPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(orgid), "bg_CombinData_query");
                    if (!hasFuncPermission) continue;
                    funcPermissionMap.put(orgid, new Boolean(false));
                }
            }
            catch (EASBizException e) {
                super.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                super.handUIException((Throwable)e);
            }
            f7.setMultiSelect(true);
            this.F7Company.setSelector((KDPromptSelector)f7);
            this.F7Company.setEnabled(true);
        } else {
            this.F7Company.setValue(null);
            this.F7Company.setEnabled(false);
        }
    }

    private void refreshBgScheme() throws EASBizException, BOSException {
        OrgUnitInfo orgUnitInfo;
        OrgTreeInfo orgTreeInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (this.listOrgBound.getSelectedItem() != null && (orgTreeInfo = (OrgTreeInfo)this.listOrgBound.getSelectedItem()) != null && orgTreeInfo.getId() != null && (orgUnitInfo = (OrgUnitInfo)BgEliminationHelper.getValueFromMap(this.orgUnitMapping, orgTreeInfo.getId().toString())) != null && orgUnitInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        }
        if (filter.getFilterItems().size() == 0) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)"AABBCC", CompareType.EQUALS));
        }
        this.promptBgScheme.setData(null);
        this.promptBgScheme.setEntityViewInfo(view);
        this.promptBgScheme.setEditable(false);
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMeasureUnit.addRow();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        int index;
        if (this.tblMeasureUnit.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"238_BgFormAnalyseFilterUI"));
            SysUtil.abort();
        }
        if ((index = this.tblMeasureUnit.getSelectManager().getActiveRowIndex()) < 0) {
            return;
        }
        this.tblMeasureUnit.removeRow(index);
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        super.listOrgBound_actionPerformed(e);
        this.refreshCompany();
        this.refreshBgScheme();
        this.refreshWorkTemplateF7();
    }

    protected FilterParam createNewFilterParam() {
        return new BgCombinDataFilterParam();
    }

    @Override
    protected void prmtEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        BgPeriodInfo period;
        Object obj = this.prmtEndPeriod.getValue();
        if (obj == null && this.prmtBeginPeriod.getValue() != null && (period = (BgPeriodInfo)this.prmtBeginPeriod.getValue()).getPeriodType().getValue() == 8) {
            this.prmtBeginPeriod.setValue(null);
        }
        period = new BgPeriodInfo[2];
        if (obj != null) {
            BgPeriodInfo endPeriod = (BgPeriodInfo)obj;
            int periodType = endPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtBeginPeriod.setValue((Object)endPeriod);
            }
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate((Object)period);
        } else {
            Object beginPeriodObj = this.prmtBeginPeriod.getValue();
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate((Object)period);
        }
    }

    @Override
    protected void prmtBeginPeriod_stateChanged(ChangeEvent e) throws Exception {
        BgPeriodInfo period;
        Object obj = this.prmtBeginPeriod.getValue();
        if (obj == null && this.prmtEndPeriod.getValue() != null && (period = (BgPeriodInfo)this.prmtEndPeriod.getValue()).getPeriodType().getValue() == 8) {
            this.prmtEndPeriod.setValue(null);
        }
        period = new BgPeriodInfo[2];
        if (obj != null) {
            BgPeriodInfo beginPeriod = (BgPeriodInfo)obj;
            int periodType = beginPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtEndPeriod.setValue((Object)beginPeriod);
                this.prmtEndPeriod.setEnabled(false);
            } else {
                this.prmtEndPeriod.setEnabled(true);
            }
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate((Object)period);
        } else {
            period[0] = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            period[1] = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            CustomerQueryConditionObserver.getIntance().notifyForUpdate((Object)period);
        }
    }

    public CustomerParams getCustomerParams() {
        Object endPeriodObj;
        Object currencyObj;
        Object shemeObj;
        Object workTemplateObj;
        Object orgTreeObj;
        CustomerParams cp = super.getCustomerParams();
        this.ownFilterParam = this.getOwnFilterParam();
        Object orgObj = this.F7Company.getData();
        if (orgObj != null) {
            if (orgObj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] array = (OrgUnitInfo[])orgObj;
                int length = array.length;
                FullOrgUnitInfo[] costAry = null;
                if (length > 0) {
                    costAry = new FullOrgUnitInfo[length];
                    System.arraycopy(array, 0, costAry, 0, length);
                    FullOrgUnitInfo tmp = null;
                    for (int i = 0; i < length - 1; ++i) {
                        for (int j = 0; j < length - i - 1; ++j) {
                            if (costAry[j].getLongNumber().compareTo(costAry[j + 1].getLongNumber()) <= 0) continue;
                            tmp = costAry[j];
                            costAry[j] = costAry[j + 1];
                            costAry[j + 1] = tmp;
                        }
                    }
                }
                this.ownFilterParam.setFullOrgUnitInfoAry(costAry);
            } else if (orgObj instanceof CostCenterOrgUnitInfo) {
                this.ownFilterParam.setFullOrgUnitInfoAry(new FullOrgUnitInfo[]{(FullOrgUnitInfo)orgObj});
            }
            this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getFullUnitIDs((FullOrgUnitInfo[])this.ownFilterParam.getFullOrgUnitInfoAry()), "OrgUnitKey");
        }
        if ((orgTreeObj = this.listOrgBound.getSelectedItem()) != null) {
            OrgTreeInfo info = (OrgTreeInfo)orgTreeObj;
            this.ownFilterParam.setOrgTreeInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "OrgTreeInfoId");
        }
        if ((workTemplateObj = this.bgWorkTemplate.getData()) != null) {
            BgWorkTemplateInfo info = (BgWorkTemplateInfo)workTemplateObj;
            this.ownFilterParam.setBgWorkTemplateInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "BgWorkTemplateId");
        }
        if ((shemeObj = this.promptBgScheme.getData()) != null) {
            BgSchemeInfo info = (BgSchemeInfo)shemeObj;
            this.ownFilterParam.setBgSchemeInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "BgSchemeID");
        }
        if ((currencyObj = this.currencyBox.getValue()) != null) {
            CurrencyInfo info = (CurrencyInfo)currencyObj;
            this.ownFilterParam.setCurrencyInfo(info);
            this.setFilterObject(cp, info.getId().toString(), "CurrencyID");
        }
        if ((endPeriodObj = this.prmtEndPeriod.getValue()) != null) {
            BgPeriodInfo info = (BgPeriodInfo)endPeriodObj;
            this.ownFilterParam.setEndPeriod(info);
            this.setFilterObject(cp, info.getId().toString(), "EndPeriodID");
        } else {
            this.ownFilterParam.setEndPeriod(null);
            cp.removeCustomerParam("EndPeriodID");
        }
        Object beginPeriodObj = this.prmtBeginPeriod.getValue();
        if (beginPeriodObj != null) {
            BgPeriodInfo info = (BgPeriodInfo)beginPeriodObj;
            this.ownFilterParam.setBeginPeriod(info);
            this.setFilterObject(cp, info.getId().toString(), "BeginPeriodID");
        } else {
            this.ownFilterParam.setEndPeriod(null);
            cp.removeCustomerParam("BeginPeriodID");
        }
        int rowNum = this.tblMeasureUnit.getRowCount();
        LinkedHashMap<BgElementInfo, MeasureUnitInfo> map = new LinkedHashMap<BgElementInfo, MeasureUnitInfo>();
        if (rowNum > 0) {
            for (int i = 0; i < rowNum; ++i) {
                IRow row = this.tblMeasureUnit.getRow(i);
                MeasureUnitInfo measureInfo = (MeasureUnitInfo)row.getCell("MeasureUnit").getValue();
                BgElementInfo elementInfo = (BgElementInfo)row.getCell("bgElement").getValue();
                map.put(elementInfo, measureInfo);
            }
        } else {
            map = null;
        }
        this.ownFilterParam.setMeasureUnitInfoMap(map);
        this.setFilterObject(cp, NewBgCompareAndAnalysisSimpleObjFilterParam.getMeasureUnit(map), "BgMeasureUnitKey");
        return cp;
    }

    public void setPanelName(String panelName) {
        super.setPanelName(EASResource.getString((String)resourcePathRpt, (String)"Analysis_Condition"));
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String orgTreeId = cp.getCustomerParam("OrgTreeInfoId");
        int num = this.listOrgBound.getItemCount();
        for (int i = 0; i < num; ++i) {
            String tempId = ((OrgTreeInfo)this.listOrgBound.getItemAt(i)).getId().toString();
            if (!tempId.equals(orgTreeId)) continue;
            this.listOrgBound.setSelectedIndex(i);
        }
        try {
            this.listOrgBound_actionPerformed(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        FullOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeFullOrgUnit((String)cp.getCustomerParam("OrgUnitKey"));
        if (ccouiAry != null) {
            this.F7Company.setData((Object)ccouiAry);
        }
        try {
            this.F7Company_dataChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.bgWorkTemplate.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgWorkTemplateInfo((String)cp.getCustomerParam("BgWorkTemplateId")));
        this.promptBgScheme.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo((String)cp.getCustomerParam("BgSchemeID")));
        this.prmtBeginPeriod.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("BeginPeriodID")));
        this.prmtEndPeriod.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("EndPeriodID")));
        try {
            this.prmtBeginPeriod_stateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.currencyBox.setValue((Object)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo((String)cp.getCustomerParam("CurrencyID")));
        Map map = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit((String)cp.getCustomerParam("BgMeasureUnitKey"));
        this.tblMeasureUnit.removeRows();
        this.tblMeasureUnit.checkParsed();
        if (map != null && map.size() > 0) {
            Set set = map.keySet();
            ArrayList list = new ArrayList(set);
            int num2 = list.size();
            for (int i = 0; i < num2; ++i) {
                Object element = list.get(i);
                Object measureUnit = map.get(element);
                IRow row = this.tblMeasureUnit.addRow(i);
                row.getCell("MeasureUnit").setValue(measureUnit);
                row.getCell("bgElement").setValue(element);
            }
        }
        Object beginPeriodObj = this.prmtBeginPeriod.getValue();
        BgPeriodInfo[] period = new BgPeriodInfo[]{(BgPeriodInfo)this.prmtBeginPeriod.getValue(), (BgPeriodInfo)this.prmtEndPeriod.getValue()};
        CustomerQueryConditionObserver.getIntance().clearOldObj();
        CustomerQueryConditionObserver.getIntance().notifyForUpdate((Object)period);
    }

    public void setFilterObject(CustomerParams cp, Object param, String key) {
        cp.addCustomerParam(key, param.toString());
    }

    public void clear() {
        super.clear();
        if (this.listOrgBound.getItemCount() > 0) {
            this.listOrgBound.setSelectedIndex(0);
        }
        this.promptBgScheme.setData(null);
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.F7Company.setData(null);
        this.currencyBox.setData(null);
        this.tblMeasureUnit.removeRows();
    }

    public boolean verify() {
        if (this.listOrgBound.getSelectedItem() == null) {
            this.listOrgBound.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Msg_NoFindOrgBound"));
            return false;
        }
        if (this.F7Company.getValue() == null) {
            this.F7Company.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Msg_NoFindOrgGroup"));
            return false;
        }
        if (this.promptBgScheme.getValue() == null) {
            this.promptBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Msg_NoFindScheme"));
            return false;
        }
        if (this.bgWorkTemplate.getValue() == null) {
            this.bgWorkTemplate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Msg_NoFindWorkTemplate"));
            return false;
        }
        Object sPeriodObj = this.prmtBeginPeriod.getValue();
        Object ePeriodObj = this.prmtEndPeriod.getValue();
        String sPeriodStr = this.prmtBeginPeriod.getText();
        String ePeriodStr = this.prmtEndPeriod.getText();
        if ("".equals(sPeriodStr) || "".equals(ePeriodStr)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePathRpt, (String)"SPeriod_EPeriod_Not_Null"));
            return false;
        }
        BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, (KDBizPromptBox)this.prmtBeginPeriod, (KDBizPromptBox)this.prmtEndPeriod);
        if (this.currencyBox.getValue() == null) {
            this.currencyBox.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"Msg_NoFindCurrency"));
            return false;
        }
        int rowNum = this.tblMeasureUnit.getRowCount();
        if (rowNum > 0) {
            int i;
            HashSet<String> verifySet = new HashSet<String>();
            int size = 0;
            for (i = 0; i < rowNum; ++i) {
                IRow row = this.tblMeasureUnit.getRow(i);
                Object unitObj = row.getCell("MeasureUnit").getValue();
                Object elementObj = row.getCell("bgElement").getValue();
                if (unitObj != null && elementObj != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePathRpt, (String)"Make_Whole_MesureUnit"));
                return false;
            }
            for (i = 0; i < rowNum; ++i) {
                ICell elementCell = this.tblMeasureUnit.getCell(i, "bgElement");
                String elementNumber = ((BgElementInfo)elementCell.getValue()).getNumber();
                verifySet.add(elementNumber);
                ++size;
            }
            if (verifySet.size() < size) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage((String)"elementIsRepeat"));
                return false;
            }
        }
        return true;
    }
}

