/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IWizzardComment;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.ma.budget.BgTemplateComment;
import com.kingdee.eas.ma.budget.BgTemplateCommentTank;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCommentEditUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgCommentEditUI
extends AbstractBgCommentEditUI
implements IWizzardComment {
    private static final long serialVersionUID = -296196371319634672L;
    private static final Logger logger = CoreUIObject.getLogger(BgCommentEditUI.class);
    private SpreadContext _context = null;
    private int _mode = 0;
    private boolean _isEditor = true;
    private boolean _isCancel = false;
    private RptCommentTank comments = null;
    private UserInfo defaultAuthor = SysContext.getSysContext().getCurrentUserInfo();
    private String defaultContent = BgNFCHelper.getMessageStr("comment");

    public void onLoad() throws Exception {
        super.onLoad();
        this.comboxSort.setEnabled(false);
        this.comboxSort.setVisible(false);
        this.tblComment.checkParsed();
        this.tblComment.getSelectManager().setSelectMode(2);
    }

    public void show() {
        if (this.getUIWindow() instanceof KDDialog && !((KDDialog)this.getUIWindow()).isVisible()) {
            this.initialize();
            this.getUIWindow().show();
        } else {
            super.show();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    protected void initialize() {
        if (this.getComments() != null && this.getComments().getSize() > 0) {
            this.tblComment.getSelectManager().select(0, 0);
        } else {
            this.txtComment.setText(this.getDefaultContent());
        }
        BgNFCHelper.setFocusTo((Component)this.txtComment);
    }

    protected void setContext(SpreadContext context) {
        this._context = context;
    }

    protected SpreadContext getContext() {
        return this._context;
    }

    protected int getMode() {
        return this._mode;
    }

    protected boolean isEditor() {
        return this._isEditor;
    }

    protected void setIsEditor(boolean isEditor) {
        this._isEditor = isEditor;
    }

    protected boolean isCancel() {
        return this._isCancel;
    }

    protected void setIsCancel(boolean isCancel) {
        this._isCancel = isCancel;
    }

    protected void setComments(RptCommentTank comments) {
        this.comments = comments;
    }

    protected RptCommentTank getComments() {
        return this.comments;
    }

    protected UserInfo getDefaultAuthor() {
        return this.defaultAuthor;
    }

    protected String getDefaultContent() {
        return this.defaultContent;
    }

    protected Timestamp getCurrTime() {
        return new Timestamp(Calendar.getInstance().getTimeInMillis());
    }

    public boolean prepare() {
        this.getContext().getStateManager().stop();
        RptCommentTank _comments = null;
        if (this.getMode() == 2) {
            _comments = this.getComments(this.getContext().getBook());
        } else if (this.getMode() == 1) {
            _comments = this.getComments(this.getContext().getBook().getActiveSheet());
        } else if (this.getMode() == 0) {
            _comments = this.getComments(this.getContext().getBook().getActiveCellRange());
        }
        if (_comments == null) {
            _comments = new RptCommentTank();
        }
        this.setComments(_comments);
        this.getComments().setTable(this.tblComment);
        this.getComments().refresh();
        return true;
    }

    protected RptCommentTank getComments(Object obj) {
        if (obj == null) {
            return null;
        }
        Comment comment = null;
        if (obj.getClass().isAssignableFrom(Range.class)) {
            comment = ((Range)obj).getComment();
        } else if (obj.getClass().isAssignableFrom(Sheet.class)) {
            comment = ((Sheet)obj).getComment();
        } else if (obj.getClass().isAssignableFrom(Book.class)) {
            comment = ((Book)obj).getComment();
        }
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = null;
        if (comment instanceof RptCommentTank) {
            ct = (RptCommentTank)comment;
        } else if (comment instanceof Comment) {
            ct = this.convertComment(comment);
        }
        return ct;
    }

    protected RptCommentTank convertComment(Comment comment) {
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = new RptCommentTank();
        if (comment instanceof BgTemplateCommentTank) {
            BgTemplateComment temComment = null;
            for (int i = 0; i < ((BgTemplateCommentTank)comment).getSize(); ++i) {
                RptComment rptComment = new RptComment();
                temComment = ((BgTemplateCommentTank)comment).getEntry(i);
                rptComment.author = this.getDefaultAuthor();
                rptComment.setContent(temComment.getContent());
                rptComment.date = temComment.getDateTimeStamp();
                ct.addEntry(rptComment);
            }
        } else {
            RptComment rptComment = new RptComment();
            rptComment.author = this.getDefaultAuthor();
            rptComment.setContent(comment.getText());
            rptComment.date = this.getCurrTime();
            ct.addEntry(rptComment);
        }
        return ct;
    }

    public void setMode(int mode) {
        this._mode = mode;
    }

    public boolean isModal() {
        return true;
    }

    public void commit() {
        if (!this.isCancel()) {
            this.getContext().getStateManager().stop();
            RptCommentTank ct = this.getComments();
            if (ct == null || ct.getSize() <= 0) {
                ct = null;
            }
            if (this.getMode() == 2) {
                this.getContext().getBook().setComment((Comment)ct);
            } else if (this.getMode() == 1) {
                this.getContext().getBook().getActiveSheet().setComment((Comment)ct);
            } else if (this.getMode() == 0) {
                this.getContext().getRangeManager().getActiveCellRange().setComment((Comment)ct);
            }
        }
    }

    public static IWizzardComment createCommentUI(Object parent, SpreadContext context) throws UIException {
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCommentEditUI.class.getName(), (Map)new UIContext(parent), null, OprtState.ADDNEW);
        BgCommentEditUI ui = (BgCommentEditUI)window.getUIObject();
        ui.setContext(context);
        return ui;
    }

    @Override
    protected void btnAddNew_actionPerformed(ActionEvent e) throws Exception {
        RptComment cmt = this.createComment();
        this.getComments().addEntry(cmt);
        this.tblComment.getSelectManager().select(this.getComments().indexOf(cmt), 1, 2);
        this.txtComment.setText(this.getDefaultContent());
        this.txtComment.requestFocus();
    }

    @Override
    protected void btnRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
        RptComment rc = this.getComments().getEntry(activeRowIndex);
        if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
            if (this.getComments().deletEntry(this.tblComment.getSelectManager().getActiveRowIndex())) {
                this.txtComment.setText("");
                this.tblComment.getSelectManager().select(0, 1, 2);
                if (this.tblComment.getExpandedRowCount() > 0) {
                    this.txtComment.setText(this.getComments().getContent(0));
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.remove"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        if (this.isEditor() && this.checkHasComment()) {
            this.submitComment();
        }
        this.disposeUIWindow();
        this.setIsCancel(false);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCancel(true);
        this.disposeUIWindow();
    }

    @Override
    protected void tblComment_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.txtComment.setText(this.getComments().getContent(this.tblComment.getSelectManager().getActiveRowIndex()));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.tblComment.getRowCount() > 0 && StringUtils.isEmpty((String)this.txtComment.getText())) {
            BgNFCHelper.setFocusTo((Component)this.txtComment);
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.context"));
            SysUtil.abort();
        }
    }

    protected void submitComment() throws Exception {
        this.checkSelected();
        int activeRowIndex = this.tblComment.getSelectManager().getActiveRowIndex();
        RptComment rc = this.getComments().getEntry(activeRowIndex);
        if (rc.author != null && this.getDefaultAuthor().getId().equals((Object)rc.author.getId())) {
            this.getComments().setContent(this.tblComment.getSelectManager().getActiveRowIndex(), this.txtComment.getText());
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("comment.edit"));
            SysUtil.abort();
        }
    }

    protected void checkSelected() {
        if (this.tblComment.getRowCount() == 0 || this.tblComment.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean checkHasComment() {
        return this.tblComment.getRowCount() != 0;
    }

    protected RptComment createComment() {
        RptComment comment = new RptComment();
        comment.author = this.getDefaultAuthor();
        comment.setContent(null);
        if (this.txtComment.getText() == null || "".equals(this.txtComment.getText().trim())) {
            comment.setContent(this.getDefaultContent());
        } else {
            comment.setContent(this.txtComment.getText());
        }
        comment.date = this.getCurrTime();
        return comment;
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        return re;
    }

    public void close() {
        this.setContext(null);
        this.comments = null;
    }
}

