/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.NumberExpendRender;
import com.kingdee.eas.ma.nbudget.BgCourseFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgCourseFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCoursePlanUI;
import com.kingdee.eas.ma.nbudget.client.BgFormCourseListUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCoursePlanUI
extends AbstractBgCoursePlanUI {
    private static final long serialVersionUID = 3880302497483996808L;
    private static final Logger logger = CoreUIObject.getLogger(BgCoursePlanUI.class);
    private NumberExpendRender render = new NumberExpendRender();
    private boolean hasQueryType = true;
    private boolean isStartBasisApproved = BgNSHelper.isStartBasisApproved();
    private boolean isStepByStepReport = BgNSHelper.isStepByStepReport();
    private int sel_orgunit = 0;
    private int columns_count = 0;
    private BgFormCourseListUI ui = null;
    private OrgUnitInfo unitInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.ui = (BgFormCourseListUI)((Object)this.getUIContext().get("Owner"));
        this.sel_orgunit = (Integer)this.getUIContext().get("SEL_ORGUNIT_TYPE");
        this.unitInfo = (OrgUnitInfo)this.getUIContext().get("SEL_ORGUNIT_INFO");
        this.viewOrgUnit();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initShow();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgCoursePlanUI.this.tblMain_tableClicked(e);
                }
                catch (Exception ex) {
                    BgCoursePlanUI.this.handUIException(ex);
                }
            }
        });
    }

    protected IBgCourseFacade getInterface() throws Exception {
        return BgCourseFacadeFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuTool.setEnabled(false);
        this.menuTool.setVisible(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        JMenuItem jmi = this.btnPrint.addAssistMenuItem((Action)((Object)this.actionPrintPreview));
        jmi.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void initShow() {
        IUIWindow window = this.getUIWindow();
        if (window instanceof KDFrame) {
            ((KDFrame)window).setExtendedState(6);
        } else if (window instanceof Dialog) {
            ((Dialog)window).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    @Override
    public void actionViewPlan_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewPlan_actionPerformed(e);
        if (this.hasQueryType) {
            this.viewOrgUnit();
        } else {
            this.viewScheme();
        }
    }

    protected void viewOrgUnit() throws Exception {
        this.hasQueryType = false;
        this.initOrgHead();
        this.initOrgExpendInfo();
        this.fillOrgData();
    }

    protected void viewScheme() throws Exception {
        this.hasQueryType = true;
        this.initSchemeHead();
        this.fillSchemeData();
    }

    protected void initHead() throws Exception {
        IRow row = null;
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.columns_count = this.isStartBasisApproved ? (this.isStepByStepReport ? 19 : 21) : 15;
        this.tblMain.addColumns(this.columns_count);
        row = this.tblMain.addHeadRow();
        row.getCell(1).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_bgScheme"));
        row.getCell(2).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_bgPeriod"));
        row.getCell(3).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_currency"));
        row.getCell(4).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_count"));
        if (this.isStartBasisApproved) {
            row.getCell(5).setValue((Object)BgFormStateEnum.CANTEDIT.getAlias());
            row.getCell(7).setValue((Object)BgFormStateEnum.Edited.getAlias());
            row.getCell(9).setValue((Object)BgFormStateEnum.Approving.getAlias());
            row.getCell(11).setValue((Object)BgFormStateEnum.BasisApproved.getAlias());
            row.getCell(13).setValue((Object)BgFormStateEnum.Report.getAlias());
            if (this.columns_count == 19) {
                row.getCell(15).setValue((Object)BgFormStateEnum.Back.getAlias());
                row.getCell(17).setValue((Object)BgFormStateEnum.Approved.getAlias());
            } else {
                row.getCell(15).setValue((Object)BgFormStateEnum.Certificate.getAlias());
                row.getCell(17).setValue((Object)BgFormStateEnum.Back.getAlias());
                row.getCell(19).setValue((Object)BgFormStateEnum.Approved.getAlias());
            }
            row = this.tblMain.addHeadRow();
            for (int i = 5; i < this.columns_count; ++i) {
                row.getCell(i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_amount"));
                row.getCell(++i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_rate"));
            }
        } else {
            row.getCell(5).setValue((Object)BgFormStateEnum.CANTEDIT.getAlias());
            row.getCell(7).setValue((Object)BgFormStateEnum.Edited.getAlias());
            row.getCell(9).setValue((Object)BgFormStateEnum.Report.getAlias());
            row.getCell(11).setValue((Object)BgFormStateEnum.Certificate.getAlias());
            row.getCell(13).setValue((Object)BgFormStateEnum.Back.getAlias());
            row = this.tblMain.addHeadRow();
            for (int i = 5; i < this.columns_count; ++i) {
                row.getCell(i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_amount"));
                row.getCell(++i).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_rate"));
            }
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 2, 1, 2);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 3, 1, 3);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 4, 1, 4);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 5, 0, 6);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 7, 0, 8);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 9, 0, 10);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 11, 0, 12);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 13, 0, 14);
        if (this.isStartBasisApproved) {
            if (this.columns_count == 19) {
                this.tblMain.getHeadMergeManager().mergeBlock(0, 15, 0, 16);
                this.tblMain.getHeadMergeManager().mergeBlock(0, 17, 0, 18);
            } else {
                this.tblMain.getHeadMergeManager().mergeBlock(0, 15, 0, 16);
                this.tblMain.getHeadMergeManager().mergeBlock(0, 17, 0, 18);
                this.tblMain.getHeadMergeManager().mergeBlock(0, 19, 0, 20);
            }
        }
        this.tblMain.getColumn(0).setRenderer((IBasicRender)this.render);
        this.tblMain.getColumn(0).setWidth(250);
        this.tblMain.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(5).setUserObject((Object)BgFormStateEnum.CANTEDIT);
        this.tblMain.getColumn(5).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(6).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(6).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(7).setUserObject((Object)BgFormStateEnum.Edited);
        this.tblMain.getColumn(7).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(8).getStyleAttributes().setNumberFormat("0.000%");
        this.tblMain.getColumn(8).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (this.isStartBasisApproved) {
            this.tblMain.getColumn(9).setUserObject((Object)BgFormStateEnum.Approving);
            this.tblMain.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(10).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(11).setUserObject((Object)BgFormStateEnum.BasisApproved);
            this.tblMain.getColumn(11).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(12).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(12).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(13).setUserObject((Object)BgFormStateEnum.Report);
            this.tblMain.getColumn(13).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(14).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(14).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (this.columns_count == 19) {
                this.tblMain.getColumn(15).setUserObject((Object)BgFormStateEnum.Back);
                this.tblMain.getColumn(15).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(16).getStyleAttributes().setNumberFormat("0.000%");
                this.tblMain.getColumn(16).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(17).setUserObject((Object)BgFormStateEnum.Approved);
                this.tblMain.getColumn(17).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(18).getStyleAttributes().setNumberFormat("0.000%");
                this.tblMain.getColumn(18).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            } else {
                this.tblMain.getColumn(15).setUserObject((Object)BgFormStateEnum.Certificate);
                this.tblMain.getColumn(15).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(16).getStyleAttributes().setNumberFormat("0.000%");
                this.tblMain.getColumn(16).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(17).setUserObject((Object)BgFormStateEnum.Back);
                this.tblMain.getColumn(17).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(18).getStyleAttributes().setNumberFormat("0.000%");
                this.tblMain.getColumn(18).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(19).setUserObject((Object)BgFormStateEnum.Approved);
                this.tblMain.getColumn(19).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.tblMain.getColumn(20).getStyleAttributes().setNumberFormat("0.000%");
                this.tblMain.getColumn(20).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        } else {
            this.tblMain.getColumn(9).setUserObject((Object)BgFormStateEnum.Report);
            this.tblMain.getColumn(9).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(10).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(10).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(11).setUserObject((Object)BgFormStateEnum.Certificate);
            this.tblMain.getColumn(11).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(12).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(12).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(13).setUserObject((Object)BgFormStateEnum.Back);
            this.tblMain.getColumn(13).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getColumn(14).getStyleAttributes().setNumberFormat("0.000%");
            this.tblMain.getColumn(14).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.checkParsed(true);
    }

    protected void initOrgHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_orgUnit"));
    }

    protected void initSchemeHead() throws Exception {
        this.initHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "title_template"));
    }

    protected void initOrgExpendInfo() throws Exception {
        if (this.unitInfo == null) {
            return;
        }
        IRow row = null;
        if (this.sel_orgunit == 1) {
            row = this.tblMain.addRow();
            NumberExpandInfo _expend = new NumberExpandInfo();
            _expend.setId(this.unitInfo.getId().toString());
            _expend.setName(this.unitInfo.getName());
            _expend.setNumber(this.unitInfo.getNumber());
            _expend.setLongNumber(this.unitInfo.getLongNumber());
            _expend.setLevel(this.unitInfo.getLevel());
            _expend.setLeaf(true);
            row.getCell(0).setValue((Object)_expend);
        } else if (this.sel_orgunit == 2) {
            this.createTreeModel(this.unitInfo.getLongNumber());
        } else {
            this.createTreeModel();
        }
    }

    protected TreeModel getTreeModel() throws Exception {
        CtrlUnitInfo cu = null;
        TreeModel model = null;
        try {
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
            model = BgNFSHelper.getFullTreeModel(cu.getId().toString());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return model;
    }

    protected void createTreeModel(String longnumber) throws Exception {
        if (longnumber == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        this.createTreeModel(longnumber, root, null);
    }

    protected void createTreeModel(String longnumber, DefaultKingdeeTreeNode node, NumberExpandInfo expend) throws Exception {
        int _length2;
        int _length1;
        if (node == null) {
            return;
        }
        IRow row = null;
        DefaultKingdeeTreeNode _node = null;
        NumberExpandInfo _expend = null;
        OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo unitInfo = osi.getUnit();
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        if (unitInfo != null && osi.getLongNumber().startsWith(longnumber) && (_length1 = osi.getLongNumber().split("!").length) - (_length2 = longnumber.split("!").length) <= 1) {
            _expend = new NumberExpandInfo();
            _expend.setId(unitInfo.getId().toString());
            _expend.setName(unitInfo.getName());
            _expend.setNumber(unitInfo.getNumber());
            _expend.setLongNumber(osi.getLongNumber());
            _expend.setLevel(expend.getLevel() + 1);
            if (!longnumber.equals(osi.getLongNumber())) {
                _expend.setLeaf(true);
            }
            _expend.setExpandStatus(true);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)_expend);
        }
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.createTreeModel(longnumber, _node, _expend);
        }
    }

    protected void createTreeModel() throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTreeModel().getRoot();
        this.createTreeModel(root, null);
    }

    protected void createTreeModel(DefaultKingdeeTreeNode node, NumberExpandInfo expend) {
        if (node == null) {
            return;
        }
        IRow row = null;
        DefaultKingdeeTreeNode _node = null;
        NumberExpandInfo _expend = null;
        OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo unitInfo = osi.getUnit();
        if (expend == null) {
            expend = new NumberExpandInfo();
        }
        if (unitInfo != null) {
            unitInfo.setLongNumber(osi.getLongNumber());
            _expend = new NumberExpandInfo();
            _expend.setId(unitInfo.getId().toString());
            _expend.setName(unitInfo.getName());
            _expend.setNumber(unitInfo.getNumber());
            _expend.setLongNumber(unitInfo.getLongNumber());
            _expend.setLevel(expend.getLevel() + 1);
            if (node.getChildCount() <= 0) {
                _expend.setLeaf(true);
            }
            _expend.setExpandStatus(true);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)_expend);
        }
        int in = node.getChildCount();
        for (int i = 0; i < in; ++i) {
            _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.createTreeModel(_node, _expend);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            NumberExpandInfo _expend;
            Object _obj;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (colIndex == 0 && (_obj = this.tblMain.getCell(rowIndex, colIndex).getValue()) != null && _obj instanceof NumberExpandInfo && this.render.inRect(_expend = (NumberExpandInfo)_obj, e.getX(), e.getY())) {
                this.expendStyle(rowIndex, colIndex, _expend);
            }
        }
    }

    protected void expendStyle(int rowIndex, int colIndex, NumberExpandInfo expend) {
        IRow _row = null;
        String _longNumber = null;
        NumberExpandInfo _expand = null;
        String longnumber = expend.getLongNumber();
        boolean isExpandStatus = expend.isExpandStatus();
        int _rowCount = this.tblMain.getRowCount();
        expend.setExpandStatus(!isExpandStatus);
        for (int _rowIndex = rowIndex + 1; _rowIndex < _rowCount && (_longNumber = (_expand = (NumberExpandInfo)(_row = this.tblMain.getRow(_rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(longnumber + "!"); ++_rowIndex) {
            _row.getStyleAttributes().setHided(isExpandStatus);
            _expand.setExpandStatus(true);
        }
    }

    protected void fillOrgData() throws Exception {
        Object[] _objs;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "btnViewTemplate"));
        IRow row = null;
        NumberExpandInfo expend = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        int _state = 0;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        BigDecimal _sum = null;
        BigDecimal _cant = null;
        BigDecimal _tmpValue = null;
        Map _tmpMap = null;
        Map.Entry _entry2 = null;
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgPeriodInfo()) != null) {
            if (_obj instanceof BgPeriodInfo) {
                _bgPeriodInfo = (BgPeriodInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgPeriodInfo = (BgPeriodInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        Map _dataMap = this.getInterface().queryOrgInfo(this.ui.getQueryCourseMap());
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            row.getCell(1).setValue((Object)_bgSchemeInfo);
            row.getCell(2).setValue((Object)_bgPeriodInfo);
            row.getCell(3).setValue((Object)_currencyInfo);
            expend = (NumberExpandInfo)row.getCell(0).getValue();
            if (_dataMap.containsKey(expend.getId())) {
                _tmpMap = (Map)_dataMap.get(expend.getId());
                BigDecimal spceialFormCount = new BigDecimal("0");
                if (this.ui.getOrgCountMap() != null && this.ui.getOrgCountMap().containsKey(expend.getId())) {
                    spceialFormCount = (BigDecimal)this.ui.getOrgCountMap().get(expend.getId());
                }
                _count = _tmpMap.containsKey(_key = new Integer(100)) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
                _count = _count.add(spceialFormCount);
                row.getCell(4).setValue((Object)_count);
                int jn = this.tblMain.getColumnCount();
                for (int j = 7; j < jn; j += 2) {
                    state = (BgFormStateEnum)this.tblMain.getColumn(j).getUserObject();
                    _key = new Integer(state.getValue());
                    _value = BgNConstants.ZERO;
                    if (_tmpMap.containsKey(_key)) {
                        _value = (BigDecimal)_tmpMap.get(_key);
                    }
                    if (state.getValue() == 1) {
                        _key = new Integer(30);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    } else if (state.getValue() == 14) {
                        _key = new Integer(25);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    } else if (state.getValue() == 2) {
                        _key = new Integer(20);
                        if (_tmpMap.containsKey(_key)) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                        if (_tmpMap.containsKey(_key = new Integer(43))) {
                            _tmpValue = (BigDecimal)_tmpMap.get(_key);
                            _value = _value.add(_tmpValue);
                        }
                    }
                    row.getCell(j).setValue((Object)_value);
                    if (_count.compareTo(BgNConstants.ZERO) != 0) {
                        row.getCell(j + 1).setValue((Object)_value.divide(_count, 8, 4));
                        continue;
                    }
                    row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
                }
                _sum = BgNConstants.ZERO;
                for (Map.Entry _entry2 : _tmpMap.entrySet()) {
                    _key = (Integer)_entry2.getKey();
                    _value = (BigDecimal)_entry2.getValue();
                    _state = _key;
                    if (_state != 2 && _state != 14 && _state != 25 && _state != 20 && _state != 1 && _state != 30 && _state != 41 && _state != 40 && _state != 42 && _state != 3 && _state != 43) continue;
                    _sum = _sum.add(_value);
                }
                _cant = _count.subtract(_sum);
                if (_cant.compareTo(BgNConstants.ZERO) < 0) {
                    _cant = BgNConstants.ZERO;
                }
                row.getCell(5).setValue((Object)_cant);
                if (_cant.compareTo(BgNConstants.ZERO) != 0) {
                    row.getCell(6).setValue((Object)_cant.divide(_count, 8, 4));
                    continue;
                }
                row.getCell(6).setValue((Object)BgNConstants.ZERO);
                continue;
            }
            row.getCell(4).setValue((Object)BgNConstants.ZERO);
            int jn = this.tblMain.getColumnCount();
            for (int j = 5; j < jn; j += 2) {
                row.getCell(j).setValue((Object)BgNConstants.ZERO);
                row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
            }
        }
    }

    protected void fillSchemeData() throws Exception {
        Object[] _objs;
        this.btnViewPlan.setText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "btnViewOrgUnit"));
        IRow row = null;
        BgFormStateEnum state = null;
        BgSchemeInfo _bgSchemeInfo = null;
        BgPeriodInfo _bgPeriodInfo = null;
        CurrencyInfo _currencyInfo = null;
        int _state = 0;
        String _name = null;
        Map.Entry _entry22 = null;
        Object _obj = null;
        Integer _key = null;
        BigDecimal _value = null;
        BigDecimal _count = null;
        BigDecimal _sum = null;
        BigDecimal _cant = null;
        BigDecimal _tmpValue = null;
        Map _tmpMap = null;
        this.tblMain.removeRows();
        Map _dataMap = this.getInterface().querySchemeInfo(this.ui.getQueryCourseMap());
        Map _bgTemplateMap = (Map)_dataMap.get("BGTEMPLATE_INFO");
        _obj = this.ui.getBgSchemeInfo();
        if (_obj != null) {
            if (_obj instanceof BgSchemeInfo) {
                _bgSchemeInfo = (BgSchemeInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgSchemeInfo = (BgSchemeInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getBgPeriodInfo()) != null) {
            if (_obj instanceof BgPeriodInfo) {
                _bgPeriodInfo = (BgPeriodInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _bgPeriodInfo = (BgPeriodInfo)_objs[0];
            }
        }
        if ((_obj = this.ui.getCurrencyInfo()) != null) {
            if (_obj instanceof CurrencyInfo) {
                _currencyInfo = (CurrencyInfo)_obj;
            } else if (_obj instanceof Object[] && (_objs = (Object[])_obj).length > 0 && _objs[0] != null) {
                _currencyInfo = (CurrencyInfo)_objs[0];
            }
        }
        for (Map.Entry _entry22 : _bgTemplateMap.entrySet()) {
            String _rootId = (String)_entry22.getKey();
            _name = (String)_entry22.getValue();
            if (!_dataMap.containsKey(_rootId)) continue;
            _tmpMap = (Map)_dataMap.get(_rootId);
            row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)_name);
            row.getCell(1).setValue((Object)_bgSchemeInfo);
            row.getCell(2).setValue((Object)_bgPeriodInfo);
            row.getCell(3).setValue((Object)_currencyInfo);
            _key = new Integer(100);
            _count = _tmpMap.containsKey(_key) ? (BigDecimal)_tmpMap.get(_key) : BgNConstants.ZERO;
            BigDecimal tempCount = new BigDecimal("0");
            if (this.ui.getTempCountMap() != null && this.ui.getTempCountMap().containsKey(_rootId)) {
                tempCount = (BigDecimal)this.ui.getTempCountMap().get(_rootId);
            }
            _count = _count.add(tempCount);
            row.getCell(4).setValue((Object)_count);
            int jn = this.tblMain.getColumnCount();
            for (int j = 7; j < jn; j += 2) {
                state = (BgFormStateEnum)this.tblMain.getColumn(j).getUserObject();
                _key = new Integer(state.getValue());
                _value = BgNConstants.ZERO;
                if (_tmpMap.containsKey(_key)) {
                    _value = (BigDecimal)_tmpMap.get(_key);
                }
                if (state.getValue() == 1) {
                    _key = new Integer(30);
                    if (_tmpMap.containsKey(_key)) {
                        _tmpValue = (BigDecimal)_tmpMap.get(_key);
                        _value = _value.add(_tmpValue);
                    }
                } else if (state.getValue() == 14 && _tmpMap.containsKey(_key = new Integer(25))) {
                    _tmpValue = (BigDecimal)_tmpMap.get(_key);
                    _value = _value.add(_tmpValue);
                }
                row.getCell(j).setValue((Object)_value);
                if (_count.compareTo(BgNConstants.ZERO) != 0) {
                    row.getCell(j + 1).setValue((Object)_value.divide(_count, 8, 4));
                    continue;
                }
                row.getCell(j + 1).setValue((Object)BgNConstants.ZERO);
            }
            _sum = BgNConstants.ZERO;
            for (Map.Entry _entry22 : _tmpMap.entrySet()) {
                _key = (Integer)_entry22.getKey();
                _value = (BigDecimal)_entry22.getValue();
                _state = _key;
                if (_state == 4 || _state == 15 || _state == 100) continue;
                _sum = _sum.add(_value);
            }
            _cant = _count.subtract(_sum);
            if (_cant.compareTo(BgNConstants.ZERO) < 0) {
                _cant = BgNConstants.ZERO;
            }
            row.getCell(5).setValue((Object)_cant);
            if (_cant.compareTo(BgNConstants.ZERO) != 0) {
                row.getCell(6).setValue((Object)_cant.divide(_count, 8, 4));
                continue;
            }
            row.getCell(6).setValue((Object)BgNConstants.ZERO);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.hasQueryType) {
            this.fillSchemeData();
        } else {
            this.fillOrgData();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgClientHelper.exportKDTableToExcel((Component)((Object)this), (KDTable)this.tblMain, (boolean)false);
    }
}

