/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.client.BgAdjustViewUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgCourseException;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCourseProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgCourseCauseUI;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BudgetCourseMenuManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgCourseProcessUI
extends AbstractBgCourseProcessUI {
    private static final long serialVersionUID = -4287735989229394015L;
    private static final Logger logger = CoreUIObject.getLogger(BgCourseProcessUI.class);
    private boolean checkExamine = false;
    private UserInfo userInfo = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.menuBatchEditFormula.setVisible(false);
        this.menuBatchEditFormula.setEnabled(false);
        this.menuItemAttachement.setVisible(true);
        this.menuItemAttachement.setEnabled(true);
    }

    public boolean isCheckExamine() {
        return this.checkExamine;
    }

    public void setCheckExamine(boolean checkExamine) {
        this.checkExamine = checkExamine;
    }

    public boolean isCalculateOfAddNew() {
        return false;
    }

    @Override
    public boolean isCalculateOfUpdate() {
        return false;
    }

    @Override
    public IMenuStrategy getBudgetMenuStrategy() {
        return new BudgetCourseMenuManager((Component)((Object)this));
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    @Override
    protected void showAction() {
        super.showAction();
        this.actionSetCtrl.setVisible(false);
        this.actionItemInput.setVisible(false);
        this.actionSetBgItem.setVisible(false);
        this.actionSetBgElement.setVisible(false);
        this.actionSetBgPeriod.setVisible(false);
        this.actionSetCurrency.setVisible(false);
        this.itemItemInput.setVisible(false);
        this.menuItemInsertRow.setVisible(false);
        this.menuItemInsertColumn.setVisible(false);
        this.menuBgFormula.setVisible(false);
    }

    @Override
    protected void initToolbarAction() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").setVisible(false);
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        toolBarManager.addLastGroupItem((Action)((Object)this.actionCertificate), "common");
        if (!BgNSHelper.isStartBasisApproved()) {
            this.actionAreaCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_partaffirm"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionAreaCertificate), "common");
            this.actionAntiAreaCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fpartaffirm"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionAntiAreaCertificate), "common");
            this.actionCause.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_emendreason"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionCause), "common");
        } else if (!BgNSHelper.isStepByStepReport() && BgNSHelper.isCanEditWithBgCourse(null)) {
            this.actionCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_affirm"));
            this.actionAreaCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_partaffirm"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionAreaCertificate), "common");
            this.actionAntiAreaCertificate.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fpartaffirm"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionAntiAreaCertificate), "common");
            this.actionCause.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_emendreason"));
            toolBarManager.addLastGroupItem((Action)((Object)this.actionCause), "common");
        } else {
            this.actionCertificate.setVisible(false);
        }
        this.actionViewDiff.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_differentia"));
        toolBarManager.addLastGroupItem((Action)((Object)this.actionViewDiff), "common");
        this.actionBgExamineCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_examinecheck"));
        toolBarManager.addLastGroupItem((Action)((Object)this.actionBgExamineCheck), "common");
        toolBarManager.getToolBar("common");
    }

    @Override
    protected void aftInitToolbarAction() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.setItemVisible("ToolItem_Cut", false);
        toolBarManager.setItemVisible("ToolItem_Copy", false);
        toolBarManager.setItemVisible("ToolItem_Paste", false);
        toolBarManager.setItemVisible("ToolItem_Stylebrush", false);
        toolBarManager.setItemVisible("ToolItem_Undo", false);
        toolBarManager.setItemVisible("ToolItem_Redo", false);
        toolBarManager.setItemVisible("ToolItem_Hyperlink", false);
        toolBarManager.setItemVisible("ToolItem_Diagonal", false);
        toolBarManager.setItemVisible("ToolItem_Sum", false);
        toolBarManager.setItemVisible("ToolItem_SortAscend", false);
        toolBarManager.setItemVisible("ToolItem_SortDecsend", false);
        toolBarManager.setItemVisible("ToolItem_Comment", false);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.getSpreadManager().getSpreadContainer().getPopMenuManager().setItemVisible("MenuItem_SelectablePaste", false);
        this.getSpreadManager().getSpreadContainer().getPopMenuManager().setItemVisible("MenuItem_InsertRow", false);
        this.getSpreadManager().getSpreadContainer().getPopMenuManager().setItemVisible("MenuItem_DeleteRow", false);
        this.getSpreadManager().getSpreadContainer().getPopMenuManager().setItemVisible("MenuItem_InsertCol", false);
        this.getSpreadManager().getSpreadContainer().getPopMenuManager().setItemVisible("MenuItem_DeleteCol", false);
        this.menuItemCopy.setAccelerator(KeyStroke.getKeyStroke(67, 128, false));
        this.menuItemCalculate.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
        this.menuItemImport.setAccelerator(KeyStroke.getKeyStroke(73, 128, false));
        this.menuItemExport.setAccelerator(KeyStroke.getKeyStroke(69, 192, false));
    }

    @Override
    public void actionCertificate_actionPerformed(ActionEvent e) throws Exception {
        super.actionCertificate_actionPerformed(e);
        if (this.getBgFormInfo().getState().getValue() != 40) {
            throw new BgCourseException(BgCourseException.CHECKCERTIFICATESTATE);
        }
        this.verifyPermission("bg_course04_certificate");
        ArrayList<String> _bgFormIds = new ArrayList<String>();
        _bgFormIds.add(this.getBillId());
        final BOSUuid[] _uuids = this.getUuids(_bgFormIds);
        int re = 0;
        if (OprtState.EDIT.equals(this.getOprtState()) && this.getSpreadManager().getModifyManager().isDirty()) {
            re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "isSave"));
            if (re == 0) {
                this.actionSave_actionPerformed(e);
            } else if (re == 2) {
                return;
            }
        }
        if (BgNSHelper.isVerifyOfCertificate()) {
            this.setCheckExamine(false);
            if (!this.checkReport(_uuids)) {
                return;
            }
            if (this.getBgExamineInterface().canExamine(_uuids)) {
                final String xNum = BgNFCHelper.returnExamineX(_uuids, this);
                LongTimeDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new LongTimeDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new LongTimeDialog((Dialog)win);
                }
                if (dialog == null) {
                    return;
                }
                dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgCourseProcessUI.this.getBgExamineInterface().examines(_uuids, xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            BgCourseProcessUI.this.openBgExamineViewUI(result);
                            Map bgExamineCheckMap = (Map)result;
                            Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                            if (bgExCheck.booleanValue()) {
                                BgCourseProcessUI.this.setCheckExamine(true);
                                if (!StringUtils.isEmpty((String)xNum)) {
                                    BgCourseProcessUI.this.getFormInterface().saveXNum(null, xNum);
                                }
                                BgCourseProcessUI.this.setMessageText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "resultPass"));
                                BgCourseProcessUI.this.showMessage();
                            } else {
                                MsgBox.showInfo((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgExamineCheckResource", "resultNoPass"));
                            }
                        }
                    }
                });
                dialog.show();
            } else {
                this.setCheckExamine(true);
            }
        } else {
            this.setCheckExamine(true);
        }
        if (this.isCheckExamine() && (re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all"))) == 0) {
            List _re = this.getNFacadeInterface().approve(_bgFormIds, this.userInfo.getId().toString());
            if (_re != null && !_re.isEmpty()) {
                Boolean _course = (Boolean)_re.get(0);
                if (_course != null && _course.booleanValue()) {
                    this.updateViewState();
                    String _msg = (String)_re.get(1);
                    if (StringUtils.isEmpty((String)_msg)) {
                        MsgBox.showInfo((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all_over"));
                    } else {
                        _msg = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all_cause"), _msg);
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all_over"), (String)_msg, (int)1);
                    }
                    BgNCHelper.refreshListUI((CoreUI)this);
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all_over"));
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_certificate_all_over"));
            }
        }
    }

    @Override
    public void actionAntiCertificate_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiCertificate_actionPerformed(e);
        this.verifyPermission("bg_course05_antiCertificate");
    }

    @Override
    public void actionAreaCertificate_actionPerformed(ActionEvent e) throws Exception {
        super.actionAreaCertificate_actionPerformed(e);
        if (this.getBgFormInfo().getState().getValue() != 40) {
            throw new BgCourseException(BgCourseException.CHECKAREACERTIFICATE);
        }
        this.verifyPermission("bg_course08_areaCertificate");
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_areaCertificateBySelectCell"));
        if (re == 0) {
            this.updateCertificateStateOfCell(true);
        }
    }

    @Override
    public void actionAntiAreaCertificate_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAreaCertificate_actionPerformed(e);
        if (this.getBgFormInfo().getState().getValue() != 40) {
            throw new BgCourseException(BgCourseException.CHECKANTIAREACERTIFICATE);
        }
        this.verifyPermission("bg_course09_areaAntiCertificate");
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "question_areaAntiCertificateBySelectCell"));
        if (re == 0) {
            this.updateCertificateStateOfCell(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCertificateStateOfCell(boolean isCertificate) throws Exception {
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        ArrayList _blocks = null;
        Range _range = null;
        CellBlock _block = null;
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        int rowIndex = 0;
        int colIndex = 0;
        String _value = isCertificate ? BgNConstants.TRUE_STE : BgNConstants.FALSE_STR;
        _book = this.getBook();
        _sheet = _book.getActiveSheet();
        _blocks = _sheet.getSheetOption().getSelection().toSelectionBlocks();
        _range = _sheet.getSelectionRange();
        int rowCount = _sheet.getMaxRowIndex();
        int colCount = _sheet.getMaxColIndex();
        if (_blocks != null && _range != null) {
            int jn = _blocks.size();
            for (int j = 0; j < jn; ++j) {
                _block = (CellBlock)_blocks.get(j);
                rowBegin = _block.getRow();
                colBegin = _block.getCol();
                rowEnd = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                colEnd = _block.getCol2() > colCount ? colCount : _block.getCol2();
                for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        BgNFSHelper.setCellData(_cell, "COURSE_CER", _value);
                    }
                }
            }
        }
        if (!_range.isEmpty()) {
            this.getBook().getUndoManager().startGroup();
            try {
                BgNFSHelper.setCellLocked(_sheet, _range, isCertificate);
            }
            finally {
                this.getBook().getUndoManager().endGroup();
            }
            this.getSpreadManager().getSpreadContainer().repaint();
        }
    }

    @Override
    public void actionCause_actionPerformed(ActionEvent e) throws Exception {
        super.actionCause_actionPerformed(e);
        Cell _cell = null;
        String _formulaStr = null;
        _cell = this.getBook().getActiveSheet().getActiveCell();
        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", (Object)this.getBillId());
            uiContext.put((Object)"FORMULA", (Object)_formulaStr);
            uiContext.put((Object)"CELL", (Object)_cell);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCauseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", "selectFormula"));
        }
    }

    @Override
    public void actionViewDiff_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDiff_actionPerformed(e);
        Cell _cell = null;
        String _formulaStr = null;
        _cell = this.getBook().getActiveSheet().getActiveCell();
        if (BgNFSHelper.checkHasFormulaOfCell(_cell)) {
            _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_ID", (Object)this.getBillId());
        uiContext.put((Object)"FORMULA", (Object)_formulaStr);
        if (this.getSpreadManager().getModifyManager().isDirty()) {
            uiContext.put((Object)"COURSE_VALUE", (Object)this.getAllSheetValue());
        }
        uiContext.put((Object)"CURRENCY_PRECISION", (Object)(this.getBgFormInfo().getCurrency() != null ? new Integer(this.getBgFormInfo().getCurrency().getPrecision()) : new Integer(2)));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAdjustViewUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected Map getAllSheetValue() {
        int rowCount = 0;
        int colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        BigDecimal _value = null;
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        Cell _cell = null;
        Sheet _sheet = null;
        Book _book = this.getBook();
        int in = _book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            _sheet = _book.getSheet(i);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                    _obj = BgNFSHelper.getValue(_cell);
                    if (_obj != null) {
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else {
                            try {
                                _value = new BigDecimal(_obj.toString().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    formulaMap.put(_formulaStr, _value);
                }
            }
        }
        return formulaMap;
    }

    protected void updateViewState() throws Exception {
        this.setOprtState(OprtState.VIEW);
        this.actionSave.setEnabled(false);
    }

    protected void verifyPermission(String permission) throws Exception {
        if (StringUtils.isEmpty((String)permission)) {
            throw new BgCourseException(BgCourseException.CHECKCURRORGPERMISSION);
        }
        if (this.getBgFormInfo().getCourseOrgId() == null) {
            throw new BgCourseException(BgCourseException.CHECKCOURSEORGPERMISSION);
        }
        if (!this.verifyPermission(this.userInfo.getId().toString(), this.getBgFormInfo().getCourseOrgId(), permission)) {
            String _msg = MessageFormat.format(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.nbudget.client.BgFormCourseResource", permission), "");
            MsgBox.showWarning((Component)((Object)this), (String)_msg);
            SysUtil.abort();
        }
    }

    protected boolean verifyPermission(String userId, String orgUnitId, String permission) throws Exception {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        return this.getPermissionInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), permission);
    }

    protected BOSUuid[] getUuids(List ids) throws Exception {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        BOSUuid[] _uuids = new BOSUuid[ids.size()];
        try {
            int in = ids.size();
            for (int i = 0; i < in; ++i) {
                _uuids[i] = BOSUuid.read((String)ids.get(i).toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            _uuids = null;
        }
        return _uuids;
    }

    protected boolean checkReport(BOSUuid[] bgFormIds) throws Exception {
        if (bgFormIds == null || bgFormIds.length == 0) {
            return false;
        }
        boolean isCheck = true;
        List check = this.getFormInterface().reportCheck(bgFormIds);
        if (Boolean.TRUE.equals(check.get(0))) {
            return isCheck;
        }
        if (Boolean.FALSE.equals(check.get(0))) {
            isCheck = false;
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"String", (Object)check.get(3).toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        return isCheck;
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        if (e == null) {
            return;
        }
        super.actionCalculate_actionPerformed(e);
    }
}

