/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.nbudget.BgCslFormCommentFactory;
import com.kingdee.eas.ma.nbudget.client.AbstractBgCslFormCommentListUI;
import com.kingdee.eas.ma.nbudget.client.BgCslFormCommentEditUI;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BgCslFormCommentListUI
extends AbstractBgCslFormCommentListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCslFormCommentListUI.class);
    private static final long serialVersionUID = -8022557643753745774L;
    private static final int rowPerWords = 35;
    private String bgClsFormId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("BGFORM_ID");
        if (obj != null) {
            this.bgClsFormId = (String)obj;
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow irow = this.tblMain.getRow(i);
            Object cellValue = irow.getCell("comment").getValue();
            if (cellValue == null || cellValue.toString().trim().length() == 0) continue;
            int wordCount = irow.getCell("comment").getValue().toString().length();
            int j = wordCount / 35;
            int rowHeight = wordCount % 35 == 0 ? j * 20 : (j + 1) * 20;
            irow.setHeight(rowHeight);
        }
        this.tblMain.getColumn("comment").getStyleAttributes().setWrapText(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNew.setVisible(false);
        this.btnView.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRefresh.setVisible(false);
        this.btnQuery.setVisible(false);
        this.btnLocate.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionView.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionRefresh.setEnabled(false);
        this.actionQuery.setEnabled(false);
        this.actionLocate.setEnabled(false);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filterInfo = null;
        filterInfo = viewInfo.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (!StringUtils.isEmpty((String)this.bgClsFormId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bgClsFormId", (Object)this.bgClsFormId, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("bgClsFormId", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCslFormCommentFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgCslFormCommentEditUI.class.getName();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }
}

