/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCornerView;
import com.kingdee.bos.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.IDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgSpecialAnalysisFilterParam;
import com.kingdee.eas.ma.nbudget.BgSpecialData;
import com.kingdee.eas.ma.nbudget.BgSpecialDataComparator;
import com.kingdee.eas.ma.nbudget.client.AbstractBgDataAnalyseForSpecialMainUI;
import com.kingdee.eas.ma.nbudget.client.BgDataAnalyseForSpecialFilter2UI;
import com.kingdee.eas.ma.nbudget.client.BgDataAnalyseForSpecialFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgSpecialCollectViewUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgDataAnalyseForSpecialMainUI
extends AbstractBgDataAnalyseForSpecialMainUI {
    private static final long serialVersionUID = -3963957134640679012L;
    private static final Logger logger = CoreUIObject.getLogger(BgDataAnalyseForSpecialMainUI.class);
    private Map dataMap = null;
    private Map measureMap = null;
    private IFullOrgUnit ifullOrgUnit;
    private int decimal = 8;
    private DecimalFormat decFormat = null;
    private Map muMap = new HashMap();
    private BigDecimal coefficient = BgNConstants.ONE;
    private BgDataAnalyseForSpecialFilterUI filterUI;
    private BgDataAnalyseForSpecialFilter2UI filter2UI;
    private boolean orgExpand = false;
    private FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected final FetchAndDealDataAnalysisSystemFacade getAnalysisSysFacade() {
        return this.fetchAndDealDataFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery() {
        this.orgExpand = false;
        BgSpecialAnalysisFilterParam filter1Params = this.getFilterUIParams();
        this.clearCache();
        if (((Object)((Object)filter1Params)).toString() == null) {
            if (!this.resetFilterParam()) {
                SysUtil.abort();
            }
            return;
        }
        BgSpecialAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        BgSpecialAnalysisFilterParam[] filterParams = new BgSpecialAnalysisFilterParam[]{filter1Params, filter2Params};
        Map dataMap = null;
        if (dataMap == null) {
            this.init((FilterParam)filter1Params);
        }
        try {
            filter1Params.setExpendGroup(false);
            filter1Params.setExpendOrgUnit(false);
            dataMap = this.getInterface().querySpecific((Object)filter1Params);
            this.setDecimal(filter1Params.getCurrency().getPrecision());
            if (this.getDecimal() > 0) {
                this.setDecFormat(new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()), BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            } else {
                this.setDecFormat(new DecimalFormat("#,##0%", BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            }
            this.initMeasureUnitMap((FilterParam)filter1Params);
            KDTable sheet = this.initAnalyseDataHead((FilterParam[])filterParams, dataMap, null, null, false);
            if (sheet == null) {
                return;
            }
            this.fillSheet(sheet, (FilterParam[])filterParams, dataMap, filter1Params.getOrgUnits()[0], null);
            sheet.addKDTMouseListener((KDTMouseListener)new MyKDTMouseListener(sheet));
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private boolean resetFilterParam() {
        try {
            CommonQueryDialog dialog = this.getCommonQueryDialog();
            if (!dialog.show()) {
                return false;
            }
            this.setFilterParam(this.getFilterUI().getCustomerParams(), BgDataAnalyseForSpecialFilterUI.FILTER_UI_KEY);
            KDPanel[] ary = this.getOtherFilterUI();
            this.setFilterParam(((BgDataAnalyseForSpecialFilter2UI)ary[0]).getCustomerParams(), BgDataAnalyseForSpecialFilter2UI.FILTER_UI_KEY);
            this.executeQuery();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    private void clearCache() {
        IDataDealCenter ddc = this.getAnalysisSysFacade().getDataDealCenter();
        if (ddc != null) {
            ddc.getFetchDataFactory().clearAllCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionOrgQuery_actionPerformed(ActionEvent e) throws Exception {
        this.orgExpand = true;
        boolean includeSelf = true;
        BgSpecialAnalysisFilterParam filter1Params = this.getFilterUIParams();
        BgSpecialAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        BgSpecialAnalysisFilterParam[] filterParams = new BgSpecialAnalysisFilterParam[]{filter1Params, filter2Params};
        Map dataMap = null;
        this.init((FilterParam)filter1Params);
        try {
            filter1Params.setExpendGroup(false);
            filter1Params.setExpendOrgUnit(false);
            dataMap = this.getInterface().querySpecific((Object)filter1Params);
            this.setDecimal(filter1Params.getCurrency().getPrecision());
            if (this.getDecimal() > 0) {
                this.setDecFormat(new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()), BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            } else {
                this.setDecFormat(new DecimalFormat("#,##0%", BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            }
            KDTable sheet = this.initAnalyseDataHead((FilterParam[])filterParams, dataMap, null, null, false);
            if (sheet == null) {
                return;
            }
            this.fillSheet(sheet, (FilterParam[])filterParams, dataMap, filter1Params.getOrgUnits()[0], null);
            if (!filter1Params.isHasIncludeData()) {
                filter1Params.setHasIncludeData(true);
                includeSelf = false;
            }
            filter1Params.setExpendGroup(false);
            filter1Params.setExpendOrgUnit(true);
            dataMap = this.getInterface().querySpecific((Object)filter1Params);
            OrgUnitInfo[] _orgUnits = filter1Params.getOrgUnits();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                if (dataMap.get(_orgUnits[i].getNumber()) == null) continue;
                KDTable sheet1 = this.initAnalyseDataHead((FilterParam[])filterParams, dataMap, _orgUnits[i], null, false);
                this.fillSheet(sheet1, (FilterParam[])filterParams, dataMap, _orgUnits[i], null);
                sheet1.addKDTMouseListener((KDTMouseListener)new MyKDTMouseListener(sheet1));
            }
            sheet.addKDTMouseListener((KDTMouseListener)new MyKDTMouseListener(sheet));
            if (!includeSelf) {
                filter1Params.setHasIncludeData(false);
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionSpecialQuery_actionPerformed(ActionEvent e) throws Exception {
        this.orgExpand = false;
        BgSpecialAnalysisFilterParam filter1Params = this.getFilterUIParams();
        BgSpecialAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        BgSpecialAnalysisFilterParam[] filterParams = new BgSpecialAnalysisFilterParam[]{filter1Params, filter2Params};
        Map dataMap = null;
        KDTable sheet = null;
        this.init((FilterParam)filter1Params);
        try {
            OrgUnitInfo[] _orgUnits = filter1Params.getOrgUnits();
            filter1Params.setExpendGroup(false);
            filter1Params.setExpendOrgUnit(false);
            dataMap = this.getInterface().querySpecific((Object)filter1Params);
            this.setDecimal(filter1Params.getCurrency().getPrecision());
            if (this.getDecimal() > 0) {
                this.setDecFormat(new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()), BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            } else {
                this.setDecFormat(new DecimalFormat("#,##0%", BgNationalFormatUIUtil.getDecimalFormatSymbols()));
            }
            sheet = this.initAnalyseDataHead((FilterParam[])filterParams, dataMap, null, null, false);
            if (sheet == null) {
                return;
            }
            this.fillSheet(sheet, (FilterParam[])filterParams, dataMap, filter1Params.getOrgUnits()[0], null);
            filter1Params.setExpendGroup(true);
            filter1Params.setExpendOrgUnit(false);
            dataMap = this.getInterface().querySpecific((Object)filter1Params);
            List groupList = (List)dataMap.get("BGITEMGROUP_INFO");
            int in = groupList.size();
            for (int i = 0; i < in; ++i) {
                KDTable sheet1 = this.initAnalyseDataHead((FilterParam[])filterParams, dataMap, _orgUnits[0], (BgItemGroupInfo)groupList.get(i), false);
                this.fillSheet(sheet1, (FilterParam[])filterParams, dataMap, _orgUnits[0], (BgItemGroupInfo)groupList.get(i));
                sheet1.addKDTMouseListener((KDTMouseListener)new MyKDTMouseListener(sheet1));
            }
            sheet.addKDTMouseListener((KDTMouseListener)new MyKDTMouseListener(sheet));
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        KDTable sheet = (KDTable)((KDPanel)this.getMainTabPane().getSelectedComponent()).getComponents()[0];
        if (sheet.getSelectManager().toRange().toArray().length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"multiSelectWarning"));
            SysUtil.abort();
        }
        KDTSelectBlock selectBlock = (KDTSelectBlock)sheet.getSelectManager().toRange().toArray()[0];
        int top = selectBlock.getTop();
        int bottom = selectBlock.getBottom();
        int left = selectBlock.getLeft();
        int right = selectBlock.getRight();
        if (top != bottom || left != right || left < 3) {
            MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage((String)"multiSelectWarning"));
            SysUtil.abort();
        }
        ArrayList<BgSpecialData> collectList = new ArrayList<BgSpecialData>();
        BgSpecialData specialData = null;
        BgSpecialAnalysisFilterParam _param = this.getFilterUIParams();
        String sheetSign = sheet.getID().split("_")[0];
        String sheetId = sheet.getID().split("_")[1];
        boolean includeSelf = true;
        if ("Gather".equals(sheetSign)) {
            _param.setExpendGroup(false);
            _param.setExpendOrgUnit(false);
        } else if ("Org".equals(sheetSign)) {
            _param.setExpendGroup(false);
            _param.setExpendOrgUnit(true);
            if (!this.getFilterUIParams().isHasIncludeData()) {
                this.getFilterUIParams().setHasIncludeData(true);
                includeSelf = false;
            }
        } else if ("Group".equals(sheetSign)) {
            _param.setExpendGroup(true);
            _param.setExpendOrgUnit(false);
        }
        Map returnMap = this.getInterface().queryTotalData((Object)_param);
        String bgItemNum = sheet.getRow(top).getUserObject().toString();
        String userObj = sheet.getHeadRow(3).getCell(left).getUserObject().toString();
        String elementNum = userObj.split("_")[0];
        String elementName = userObj.split("_")[1];
        String periodStr = userObj.split("_")[2];
        String sign = userObj.split("_")[3];
        List _returnData = (List)returnMap.get("back_result");
        Iterator iterData = _returnData.iterator();
        BigDecimal total = new BigDecimal(0);
        while (iterData.hasNext()) {
            specialData = (BgSpecialData)iterData.next();
            if (!bgItemNum.equals(specialData.getBgItemNumber()) || !periodStr.equals(specialData.getBgPeriodId()) || !elementNum.equals(specialData.getBgElementNumbr()) || ("Org".equals(sheetSign) ? !sheetId.equals(specialData.getOrgUnitNumber()) : "Group".equals(sheetSign) && !sheetId.equals(specialData.getBgItemGroupNumber()))) continue;
            collectList.add(specialData);
            total = total.subtract(specialData.getBudgetValue());
        }
        if (!includeSelf) {
            this.getFilterUIParams().setHasIncludeData(false);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"GATHER_VIEW_TYPE_ITEM", collectList);
        uiContext.put((Object)"BGITEM_ID", (Object)bgItemNum);
        uiContext.put((Object)"BGITEM_INFO", sheet.getRow(top).getCell(2).getValue());
        uiContext.put((Object)"BGELEMENT_INFO", (Object)elementName);
        uiContext.put((Object)"CURRENCY_PRECISION", (Object)String.valueOf(this.getDecimal()));
        uiContext.put((Object)"IDS", (Object)sign);
        Map _bgItemSpecificMap = (Map)returnMap.get("BGITEM_INFO");
        uiContext.put((Object)"@", (Object)_bgItemSpecificMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSpecialCollectViewUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void init(FilterParam filterParam) {
        this.initMeasureUnitMap(filterParam);
        this.clearAnalyseSheet();
    }

    protected void initMeasureUnitMap(FilterParam filterParam) {
        this.muMap.clear();
        BgSpecialAnalysisFilterParam _itemAnalyseParam = (BgSpecialAnalysisFilterParam)filterParam;
        if (_itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit() != null) {
            this.setCoefficient(_itemAnalyseParam.getBgTemplateInfo().getDefaultMeasureUnit().getCoefficient());
        }
        if (_itemAnalyseParam.getMeasureUnitInfoMap() != null) {
            Map.Entry _entry2 = null;
            BgElementInfo elementInfo = null;
            MeasureUnitInfo unitInfo = null;
            for (Map.Entry _entry2 : _itemAnalyseParam.getMeasureUnitInfoMap().entrySet()) {
                elementInfo = (BgElementInfo)_entry2.getKey();
                unitInfo = (MeasureUnitInfo)_entry2.getValue();
                if (elementInfo == null || unitInfo == null) continue;
                this.muMap.put(elementInfo.getNumber(), unitInfo.getCoefficient());
            }
        }
    }

    protected KDTable initAnalyseDataHead(FilterParam[] filterParams, Map dataMap, OrgUnitInfo orgUnitInfo, BgItemGroupInfo bgItemGroup, boolean isShowPopMenu) {
        BgSpecialAnalysisFilterParam _itemAnalyseParam = (BgSpecialAnalysisFilterParam)filterParams[0];
        BgSpecialAnalysisFilterParam _itemAnalyseParam2 = (BgSpecialAnalysisFilterParam)filterParams[1];
        KDTable sheet = null;
        if (bgItemGroup != null) {
            sheet = this.addAnalyseSheet("Group_" + bgItemGroup.getNumber(), bgItemGroup.getName(), isShowPopMenu);
        } else if (orgUnitInfo != null) {
            sheet = this.addAnalyseSheet("Org_" + orgUnitInfo.getNumber(), orgUnitInfo.getName(), isShowPopMenu);
        } else {
            orgUnitInfo = _itemAnalyseParam.getOrgUnits()[0];
            sheet = this.addAnalyseSheet("Gather_" + orgUnitInfo.getId().toString(), BgAnalyseHelper.getMessage((String)"gather"), isShowPopMenu);
        }
        if (sheet == null) {
            return null;
        }
        sheet.setEditable(false);
        IRow row0 = null;
        IRow row1 = null;
        IRow row2 = null;
        IRow row3 = null;
        sheet.setRefresh(false);
        sheet.checkParsed();
        List elementList = (List)dataMap.get("BGELEMENT_INFO");
        if (elementList == null) {
            return null;
        }
        row0 = sheet.addHeadRow();
        row1 = sheet.addHeadRow();
        row2 = sheet.addHeadRow();
        sheet.addColumns(3);
        BgElementInfo bgElement2 = null;
        BgElementInfo bgElementDel2 = null;
        int elementSize = 0;
        ArrayList<BgElementInfo> elementObjList = new ArrayList<BgElementInfo>();
        if (_itemAnalyseParam.getMeasureUnitInfoMap() != null && _itemAnalyseParam.getMeasureUnitInfoMap().size() > 0) {
            for (BgElementInfo bgElement2 : _itemAnalyseParam.getMeasureUnitInfoMap().keySet()) {
                for (BgElementInfo bgElementDel2 : elementList) {
                    if (!bgElementDel2.getNumber().equals(bgElement2.getNumber())) continue;
                    ++elementSize;
                    elementObjList.add(bgElementDel2);
                }
            }
        }
        int periodSize = ((BgPeriodCollection)dataMap.get("BGPERIOD_INFO")).size();
        int analyseColumnSize = _itemAnalyseParam2.getAnalysisElement().size();
        int totalColumn = elementSize * periodSize * analyseColumnSize;
        sheet.addColumns(totalColumn);
        String[] strObj = new String[periodSize * elementSize];
        String[] strObjCol = new String[totalColumn];
        Object[] elementObj = elementObjList.toArray();
        int k = 0;
        int m = 0;
        int w = 0;
        for (int j = 0; j < elementObj.length; ++j) {
            sheet.getHeadMergeManager().mergeBlock(0, k + 3, 0, k + periodSize * analyseColumnSize + 2);
            row0.getCell(3 + k).setValue((Object)((BgElementInfo)elementObj[j]).getName());
            row0.getCell(3 + k).setUserObject((Object)((BgElementInfo)elementObj[j]));
            sheet.getHeadMergeManager().mergeBlock(1, k + 3, 1, k + periodSize * analyseColumnSize + 2);
            row1.getCell(3 + k).setValue((Object)_itemAnalyseParam.getCurrency().getName());
            k += periodSize * analyseColumnSize;
            Object[] periodObj = ((BgPeriodCollection)dataMap.get("BGPERIOD_INFO")).toArray();
            for (int n = 0; n < periodSize; ++n) {
                sheet.getHeadMergeManager().mergeBlock(2, m + 3, 2, m + analyseColumnSize + 2);
                row2.getCell(m + 3).setValue((Object)((BgPeriodInfo)periodObj[n]).getName());
                row2.getCell(m + 3).setUserObject((Object)((BgPeriodInfo)periodObj[n]));
                m += analyseColumnSize;
                strObj[w] = ((BgElementInfo)elementObj[j]).getNumber() + "_" + ((BgElementInfo)elementObj[j]).getName() + "_" + ((BgPeriodInfo)periodObj[n]).getId().toString() + "_";
                ++w;
            }
        }
        row3 = sheet.addHeadRow();
        row3.getCell(0).setValue((Object)BgAnalyseHelper.getMessage((String)"orgUnit"));
        row3.getCell(1).setValue((Object)BgAnalyseHelper.getMessage((String)"bgScheme"));
        row3.getCell(2).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABgItem"));
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.ma.nbudget.client.SpecialDataAnalysisElement");
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        Field f = null;
        String fieldName = null;
        Object[] analyseObj = _itemAnalyseParam2.getAnalysisElement().toArray();
        k = 0;
        int y = 0;
        int x = 0;
        for (int j = 3; j < totalColumn + 3; ++j) {
            fieldName = (String)analyseObj[k];
            try {
                if (cls == null) break;
                f = cls.getField(fieldName);
                row3.getCell(j).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormAnalyseLableResource", (String)f.get(fieldName).toString()));
                strObjCol[y] = strObj[x] + analyseObj[k];
                row3.getCell(j).setUserObject((Object)strObjCol[y]);
            }
            catch (SecurityException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            ++y;
            if (++k != analyseColumnSize) continue;
            k = 0;
            if (++x != strObj.length) continue;
            x = 0;
        }
        sheet.getHeadMergeManager().mergeBlock(0, 0, 2, 2);
        sheet.reLayoutAndPaint();
        sheet.setRefresh(true);
        return sheet;
    }

    protected void fillSheet(KDTable sheet, FilterParam[] filterParam, Map dataMap, OrgUnitInfo orgUnitInfo, BgItemGroupInfo bgItemGroup) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        String tmp = "";
        String filldata = "";
        String userObj = null;
        String[] objStr = null;
        String elementStr = null;
        String periodStr = null;
        String analyseStr = null;
        String bgItemNum = null;
        int reRowNum = -1;
        BigDecimal budgetValue = BgNConstants.ZERO;
        BigDecimal actualValue = BgNConstants.ZERO;
        BigDecimal adjustValue = BgNConstants.ZERO;
        BigDecimal processValue = BgNConstants.ZERO;
        BigDecimal difValue = BgNConstants.ZERO;
        BigDecimal difRate = BgNConstants.ZERO;
        BgSpecialAnalysisFilterParam _itemAnalyseParam = (BgSpecialAnalysisFilterParam)filterParam[0];
        BgSpecialAnalysisFilterParam _itemAnalyseParam2 = (BgSpecialAnalysisFilterParam)filterParam[1];
        String[] bgitemInfoAry = _itemAnalyseParam.getBgItemList();
        LinkedHashSet<String> bgitemNumset = new LinkedHashSet<String>();
        if (bgitemInfoAry != null && bgitemInfoAry.length > 0) {
            for (int i = 0; i < bgitemInfoAry.length; ++i) {
                bgitemNumset.add(bgitemInfoAry[i].split("\\!")[0]);
            }
        }
        Map bgItemInfoMap = (Map)dataMap.get("BGITEM_INFO");
        BgElementInfo bgElement2 = null;
        BgElementInfo bgElementDel2 = null;
        int elementSize = 0;
        List elementList = (List)dataMap.get("BGELEMENT_INFO");
        if (_itemAnalyseParam.getMeasureUnitInfoMap() != null && _itemAnalyseParam.getMeasureUnitInfoMap().size() > 0) {
            for (BgElementInfo bgElement2 : _itemAnalyseParam.getMeasureUnitInfoMap().keySet()) {
                for (BgElementInfo bgElementDel2 : elementList) {
                    if (!bgElementDel2.getNumber().equals(bgElement2.getNumber())) continue;
                    ++elementSize;
                }
            }
        }
        int periodSize = ((BgPeriodCollection)dataMap.get("BGPERIOD_INFO")).size();
        int analyseColumnSize = _itemAnalyseParam2.getAnalysisElement().size();
        int totalColumn = elementSize * periodSize * analyseColumnSize;
        IRow row = null;
        Map spDataMap = null;
        Map delMap = null;
        Iterator iterData = null;
        Iterator iterDel = null;
        Object keyData2 = null;
        Object keyDelData2 = null;
        String orgNum = orgUnitInfo.getNumber();
        HashSet itemSet = (HashSet)dataMap.get("BGITEM_ID");
        ArrayList bgItemNumList = new ArrayList(itemSet);
        Collections.sort(bgItemNumList, new BgSpecialDataComparator());
        Iterator listIter = bgItemNumList.iterator();
        String pipei = null;
        while (listIter.hasNext()) {
            String itemNum = (String)listIter.next();
            if (!bgitemNumset.contains(itemNum)) continue;
            row = sheet.addRow();
            row.getCell(2).setValue((Object)BgInfoHelper.getBgItemName(itemNum.replaceAll(",", "_"), bgItemInfoMap));
            row.setUserObject((Object)itemNum);
        }
        for (int i = 0; i < totalColumn; ++i) {
            userObj = sheet.getHeadRow(3).getCell(i + 3).getUserObject().toString();
            objStr = userObj.split("_");
            elementStr = objStr[0];
            periodStr = objStr[2];
            analyseStr = objStr[3];
            BgSpecialData spData = null;
            if (bgItemGroup != null && bgItemGroup.getNumber() != null) {
                if (((Map)dataMap.get(orgNum)).get(bgItemGroup.getNumber()) != null) {
                    spDataMap = (Map)((Map)((Map)((Map)dataMap.get(orgNum)).get(bgItemGroup.getNumber())).get(elementStr)).get(periodStr);
                }
            } else {
                spDataMap = (Map)((Map)((Map)((Map)dataMap.get(orgNum)).get("0")).get(elementStr)).get(periodStr);
            }
            if (spDataMap == null || spDataMap.size() <= 0) continue;
            for (Object keyData2 : spDataMap.keySet()) {
                delMap = (Map)spDataMap.get(keyData2);
                if (delMap == null || delMap.size() <= 0) continue;
                for (Object keyDelData2 : delMap.keySet()) {
                    spData = (BgSpecialData)delMap.get(keyDelData2);
                    pipei = bgItemNum = spData.getBgItemNumber();
                    if (bgitemNumset.size() > 0 && !bgitemNumset.contains(pipei)) continue;
                    budgetValue = spData.getBudgetValue();
                    actualValue = spData.getActualValue();
                    adjustValue = spData.getAdjustValue();
                    difValue = spData.getExecuteDif();
                    reRowNum = this.getRowNum(sheet, bgItemNum);
                    if (reRowNum == -1) {
                        row = sheet.addRow();
                        String bgItemNumTmp = bgItemNum.replaceAll(",", "_");
                        row.getCell(2).setValue((Object)BgInfoHelper.getBgItemName(bgItemNumTmp, bgItemInfoMap));
                        row.setUserObject((Object)bgItemNum);
                    } else {
                        row = sheet.getRow(reRowNum);
                    }
                    row.getCell(i + 3).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    if ("col4".equals(analyseStr)) {
                        row.getCell(i + 3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                        row.getCell(i + 3).setValue((Object)budgetValue);
                    }
                    if ("col0".equals(analyseStr)) {
                        row.getCell(i + 3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                        row.getCell(i + 3).setValue((Object)actualValue);
                    }
                    if ("col6".equals(analyseStr)) {
                        row.getCell(i + 3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                        row.getCell(i + 3).setValue((Object)adjustValue);
                    }
                    if ("col1".equals(analyseStr)) {
                        if (budgetValue.compareTo(DataDealCenter.ZERO) == 0) {
                            tmp = this.decFormat.format(DataDealCenter.ZERO);
                            row.getCell(i + 3).setValue((Object)(tmp + "%"));
                        } else {
                            filldata = this.decFormat.format(actualValue.multiply(new BigDecimal(100)).divide(budgetValue, this.decimal, 4));
                            row.getCell(i + 3).setValue((Object)(filldata + "%"));
                        }
                    }
                    if ("col2".equals(analyseStr)) {
                        row.getCell(i + 3).getStyleAttributes().setNumberFormat("#,##0." + BgNFSHelper.getNumberFormat("0", this.getDecimal()));
                        row.getCell(i + 3).setValue((Object)difValue);
                    }
                    if (!"col3".equals(analyseStr)) continue;
                    if (budgetValue.compareTo(DataDealCenter.ZERO) == 0) {
                        tmp = this.decFormat.format(DataDealCenter.ZERO);
                        row.getCell(i + 3).setValue((Object)(tmp + "%"));
                        continue;
                    }
                    filldata = this.decFormat.format(budgetValue.subtract(actualValue).multiply(new BigDecimal(100)).divide(budgetValue, this.decimal, 4));
                    row.getCell(i + 3).setValue((Object)(String.valueOf(filldata) + "%"));
                }
            }
        }
        if (sheet.getRowCount() > 0) {
            sheet.getCell(0, 0).setValue((Object)orgUnitInfo.getName());
            sheet.getCell(0, 1).setValue((Object)_itemAnalyseParam.getBgScheme().getName());
            sheet.getMergeManager().mergeBlock(0, 0, sheet.getRowCount() - 1, 0);
            sheet.getMergeManager().mergeBlock(0, 1, sheet.getRowCount() - 1, 1);
        }
        sheet.setRefresh(true);
    }

    private int getRowNum(KDTable sheet, String bgItemNum) {
        int rowNum = -1;
        IRow row = null;
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            if (row.getUserObject() == null || !bgItemNum.equals(row.getUserObject())) continue;
            rowNum = i;
            break;
        }
        return rowNum;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public DecimalFormat getDecFormat() {
        return this.decFormat;
    }

    public void setDecFormat(DecimalFormat decFormat) {
        this.decFormat = decFormat;
    }

    public BigDecimal getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.setSolutionId(ds.getId());
            int size = ds.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(info.getCustomerParams());
                this.setFilterParam(cp, info.getPanelClassName());
            }
        }
        return this.getFilterParam() != null;
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) {
        if (cp == null) {
            return;
        }
        BgAnalyseFilterBaseUI filterUI = this.getFilterUIByFilterUIKey(filterUIKey);
        if (filterUI instanceof BgDataAnalyseForSpecialFilterUI) {
            BgDataAnalyseForSpecialFilterUI filter1UI = (BgDataAnalyseForSpecialFilterUI)filterUI;
            BgSpecialAnalysisFilterParam filter1Param = filter1UI.getOwnFilterParam();
            CostCenterOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCostCenterOrgUnit((String)cp.getCustomerParam("OrgUnitKey"));
            filter1Param.setOrgUnits((OrgUnitInfo[])ccouiAry);
            BgSchemeInfo scheme = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo((String)cp.getCustomerParam("BgSchemeID"));
            filter1Param.setBgScheme(scheme);
            BgTemplateInfo bgTemplateInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgTemplateInfo((String)cp.getCustomerParam("BgTemplateId"));
            filter1Param.setBgTemplateInfo(bgTemplateInfo);
            CurrencyInfo currency = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo((String)cp.getCustomerParam("CurrencyID"));
            filter1Param.setCurrency(currency);
            LinkedHashMap measureMap = (LinkedHashMap)NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit((String)cp.getCustomerParam("BgMeasureUnitKey"));
            filter1Param.setMeasureUnitInfoMap(measureMap);
            BgPeriodInfo sInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("BeginPeriodID"));
            filter1Param.setBgPeriodBegin(sInfo);
            BgPeriodInfo eInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo((String)cp.getCustomerParam("EndPeriodID"));
            filter1Param.setBgPeriodEnd(eInfo);
            BgItemGroupInfo[] bgItemGroupAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgItemGroupInfo((String)cp.getCustomerParam("BgItemGroupKey"));
            filter1Param.setBgItemGroupInfo(bgItemGroupAry);
            BgItemInfo[] bgItemInfoAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgItemSpecialInfo((String)cp.getCustomerParam("BgItemSpecialKey"));
            filter1Param.setBgItemInfo(bgItemInfoAry);
            String[] bgItemListStr = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgItemInfo((String)cp.getCustomerParam("BgItemKey"));
            filter1Param.setBgItemList(bgItemListStr);
            String isSum = cp.getCustomerParam("IsSum");
            filter1Param.setHasIncludeData(Boolean.valueOf(isSum));
        } else if (filterUI instanceof BgDataAnalyseForSpecialFilter2UI) {
            BgDataAnalyseForSpecialFilter2UI filter2UI = (BgDataAnalyseForSpecialFilter2UI)filterUI;
            BgSpecialAnalysisFilterParam filter2Param = filter2UI.getOwnFilterParam();
            List analysisEleList = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisElement((String)cp.getCustomerParam("BgSimpleAnalysisElement"));
            filter2Param.setAnalysisElement(analysisEleList);
        }
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    protected Object[] getElemuObj() {
        Object[] returnObj = new Object[2];
        Map<String, Object> _elementMap = null;
        HashMap _elementMuMap = null;
        BgSpecialAnalysisFilterParam filterParam = this.getFilterUIParams();
        if (filterParam.getMeasureUnitInfoMap() != null && filterParam.getMeasureUnitInfoMap().size() > 0) {
            BgElementInfo _elementInfo2 = null;
            _elementMuMap = new HashMap();
            _elementMap = new HashMap();
            for (BgElementInfo _elementInfo2 : filterParam.getMeasureUnitInfoMap().keySet()) {
                if (_elementInfo2 == null) continue;
                _elementMap.put(_elementInfo2.getNumber(), _elementInfo2);
                _elementMuMap.put(_elementInfo2.getNumber(), filterParam.getMeasureUnitInfoMap().get(_elementInfo2));
            }
            returnObj[0] = _elementMap;
            returnObj[1] = _elementMuMap;
        } else {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                sic.add("number");
                sic.add("isApportionable");
                sic.add("dataType");
                returnObj[0] = _elementMap = BgSHelper.getBgElementInfo(null, null, null, (SelectorItemCollection)sic);
            }
            catch (Exception ex) {
                _elementMap = new HashMap<String, BgElementInfo>();
                logger.error((Object)ex);
            }
        }
        return returnObj;
    }

    private BgAnalyseFilterBaseUI getFilterUIByFilterUIKey(String filterUIKey) {
        if (BgDataAnalyseForSpecialFilterUI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filterUI == null) {
                    this.filterUI = new BgDataAnalyseForSpecialFilterUI();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            return this.filterUI;
        }
        if (BgDataAnalyseForSpecialFilter2UI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filter2UI == null) {
                    this.filter2UI = new BgDataAnalyseForSpecialFilter2UI();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            return this.filter2UI;
        }
        return null;
    }

    protected BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new BgDataAnalyseForSpecialFilterUI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.filterUI;
    }

    protected boolean hasOtherFilterUI() {
        return true;
    }

    protected KDPanel[] getOtherFilterUI() {
        try {
            if (this.filter2UI == null) {
                this.filter2UI = new BgDataAnalyseForSpecialFilter2UI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return new KDPanel[]{this.filter2UI};
    }

    protected BgAnalyseFilterBaseUI getFilter2UI() {
        KDPanel[] ary = this.getOtherFilterUI();
        BgDataAnalyseForSpecialFilter2UI filter2UI = (BgDataAnalyseForSpecialFilter2UI)ary[0];
        return filter2UI;
    }

    protected BgSpecialAnalysisFilterParam getFilterUIParams() {
        BgDataAnalyseForSpecialFilterUI tempFilterUI = (BgDataAnalyseForSpecialFilterUI)this.getFilterUI();
        BgSpecialAnalysisFilterParam filterParam = tempFilterUI.getOwnFilterParam();
        return filterParam;
    }

    protected BgSpecialAnalysisFilterParam getFilterUI2Params() {
        KDPanel[] panels = this.getOtherFilterUI();
        this.filter2UI = (BgDataAnalyseForSpecialFilter2UI)panels[0];
        return this.filter2UI.getOwnFilterParam();
    }

    private IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        if (this.ifullOrgUnit == null) {
            this.ifullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return this.ifullOrgUnit;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOrg.setEnabled(true);
        this.btnOrg.setIcon(EASResource.getIcon((String)"imgTbtn_differencedispose"));
        this.btnSpecial.setEnabled(true);
        this.btnSpecial.setIcon(EASResource.getIcon((String)"imgTbtn_associateentry"));
        this.btnView.setEnabled(true);
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_hook"));
    }

    public void setUITitle(String title) {
        title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"SpecialAnalyse");
        super.setUITitle(title);
    }

    protected int getWidthOfDialog() {
        return 300;
    }

    protected int getHeightOfDialog() {
        return 480;
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    class MyKDTMouseListener
    implements KDTMouseListener {
        private KDPopupMenu pm = null;
        private KDTable sheet = null;

        public MyKDTMouseListener(KDTable sheet) {
            this.sheet = sheet;
            this.initUI();
            this.initPopMenu();
        }

        public void initUI() {
            this.pm = new KDPopupMenu();
        }

        public void initPopMenu() {
            KDMenu mailItem = new KDMenu("\u53d1\u9001\u90ae\u4ef6");
            KDMenuItem HTMLForMailItem = new KDMenuItem((Action)BgDataAnalyseForSpecialMainUI.this.actionHTMLForMail);
            mailItem.add((JMenuItem)HTMLForMailItem);
            KDMenuItem excelForMailItem = new KDMenuItem((Action)BgDataAnalyseForSpecialMainUI.this.actionExcelForMail);
            mailItem.add((JMenuItem)excelForMailItem);
            this.pm.add((JMenuItem)mailItem);
            KDMenu rptItem = new KDMenu("\u53d1\u9001\u62a5\u8868");
            KDMenuItem HTMLForRpt = new KDMenuItem((Action)BgDataAnalyseForSpecialMainUI.this.actionHTMLForRpt);
            rptItem.add((JMenuItem)HTMLForRpt);
            KDMenuItem ExcelForRpt = new KDMenuItem((Action)BgDataAnalyseForSpecialMainUI.this.actionExcelForRpt);
            rptItem.add((JMenuItem)ExcelForRpt);
            this.pm.add((JMenuItem)rptItem);
            this.pm.add((Component)new JPopupMenu.Separator());
            KDMenuItem exportItem = new KDMenuItem((Action)BgDataAnalyseForSpecialMainUI.this.actionExport);
            this.pm.add((JMenuItem)exportItem);
            this.sheet.add((Component)this.pm);
        }

        public void tableClicked(KDTMouseEvent e) {
            if (SwingUtilities.isRightMouseButton((MouseEvent)e)) {
                int height = this.sheet.getHead().getHeight();
                int width = this.sheet.getIndexColumn().getWidth();
                int y = e.getY() + height;
                int x = e.getX() + width;
                if (KDTView.class.getName().equals(e.getOriginView().getClass().getName())) {
                    y = e.getY() + height;
                    x = e.getX() + width;
                } else if (e.getOriginView() instanceof KDTIndexColumnView) {
                    x = e.getX();
                } else if (e.getOriginView() instanceof KDTCornerView) {
                    x = e.getX();
                    y = e.getY();
                } else {
                    y = e.getY();
                }
                this.pm.show((Component)this.sheet, x, y);
            }
        }
    }
}

