/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.NumberExpendRender;
import com.kingdee.eas.ma.nbudget.client.AbstractBgDecompActualRecordDataUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgDecompActualRecordDataUI
extends AbstractBgDecompActualRecordDataUI {
    private static final Logger logger = CoreUIObject.getLogger(BgDecompActualRecordDataUI.class);
    private Vector orgUnits = null;
    private Map orgProportion = null;
    private List formProportion = null;
    protected NumberExpendRender expendRender = null;
    protected ICostCenterOrgUnit iCostCenterOrgUnit = null;
    protected CostCenterOrgUnitCollection refOrgUnitCol = null;
    protected Map bgActualRecordMap = null;
    protected BigDecimal oldValue = null;
    protected BigDecimal newValue = null;
    private int ORGCOL = 0;
    private int BOOLEANCOL = 1;
    private int VALUECOL = 2;
    private Map haveDataOrg = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle((String)this.getUIContext().get("UI_Title"));
        this.tblMain.reLayoutAndPaint();
        this.promBgActualRecord.setEnabled(false);
        this.txtBgForm.setEnabled(false);
        this.promBgActualRecord.setData(this.getUIContext().get("bgActualRecord"));
        this.txtBgForm.setText(this.getUIContext().get("bgForm").toString());
        this.initOrgTree();
        this.refOrgUnitCol = (CostCenterOrgUnitCollection)this.getUIContext().get("refOrgUnitCol");
        this.haveDataOrg = (Map)this.getUIContext().get("haveDataOrg");
        this.bgActualRecordMap = (Map)this.getUIContext().get("bgActualRecordMap");
        this.showOrgUnitData();
        this.tblMain.getColumn(this.VALUECOL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDNumberTextField()));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelectAll.setEnabled(true);
        this.btnCleanAll.setEnabled(true);
        this.btnConcrim.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void initOrgTree() {
        this.orgUnits = (Vector)this.getUIContext().get("orgUnits");
        this.tblMain.checkParsed();
        NumberExpandInfo expandInfo = null;
        CostCenterOrgUnitInfo orgInfo = null;
        this.tblMain.addRow();
        this.expendRender = new NumberExpendRender();
        this.tblMain.getColumn(this.ORGCOL).setRenderer((IBasicRender)this.expendRender);
        this.tblMain.getColumn(this.ORGCOL).getStyleAttributes().setLocked(true);
        String perantLNum = (String)this.getUIContext().get("perantLNum");
        for (int i = 0; i < this.orgUnits.size(); ++i) {
            orgInfo = (CostCenterOrgUnitInfo)this.orgUnits.get(i);
            if (!orgInfo.getLongNumber().equals(perantLNum)) continue;
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(orgInfo.getId().toString());
            expandInfo.setName(orgInfo.getName());
            expandInfo.setNumber(orgInfo.getNumber());
            expandInfo.setLongNumber(orgInfo.getLongNumber());
            expandInfo.setLevel(0);
            expandInfo.setLeaf(false);
            expandInfo.setExpandStatus(false);
            this.tblMain.getRow(0).getCell(this.ORGCOL).setValue((Object)expandInfo);
            this.tblMain.getRow(0).getCell(this.BOOLEANCOL).setValue(null);
            this.tblMain.getRow(0).getStyleAttributes().setLocked(true);
            break;
        }
        ActionMap am = this.tblMain.getActionMap();
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        am.remove("Copy");
    }

    private void showOrgUnitData() throws Exception {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            NumberExpandInfo expandInfo;
            if (this.tblMain.getCell(i, 0).getValue() == null || !(this.tblMain.getCell(i, 0).getValue() instanceof NumberExpandInfo) || (expandInfo = (NumberExpandInfo)this.tblMain.getCell(i, 0).getValue()) == null || expandInfo.getName().equals(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"))) continue;
            this.setTreeDisplayStyle(this.tblMain, this.tblMain.getRow(i), expandInfo, 0);
        }
    }

    private void setTreeDisplayStyle(KDTable table, IRow row, NumberExpandInfo expandInfo, int colIndex) {
        table.setRefresh(false);
        this.expandTable(table, row, expandInfo, colIndex);
        table.setRefresh(true);
        table.reLayoutAndPaint();
    }

    protected void expandTable(KDTable table, IRow row, NumberExpandInfo parentExpandInfo, int colIndex) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        IRow child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = table.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = table.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell(colIndex).getValue();
                if (expandInfo == null) continue;
                longnumber = expandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            int rowCount = table.getBody().size();
            if (rowIndex >= rowCount) {
                this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
            } else {
                for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = table.getRow(rowIndex);
                    expandInfo = (NumberExpandInfo)child.getCell(colIndex).getValue();
                    if (expandInfo != null) {
                        longnumber = expandInfo.getLongNumber();
                        if (longnumber.startsWith(plongnumber + "!")) {
                            child.getStyleAttributes().setHided(false);
                            if (!expandInfo.isLeaf()) {
                                expandInfo.setExpandStatus(false);
                            }
                            if (table.getRow(rowIndex + 1) == null || !this.isCol(table, table.getRow(rowIndex + 1), colIndex)) continue;
                            expandInfo.setExpandStatus(true);
                            continue;
                        }
                        if (rowIndex != row.getRowIndex() + 1) break;
                        this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
                        break;
                    }
                    if (rowIndex != row.getRowIndex() + 1) continue;
                    this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildOrgUnitByCol(KDTable table, NumberExpandInfo expandInfo, int rowAlias, int colAlias) {
        block11: {
            if (table == null || expandInfo == null) {
                return;
            }
            String[] plongnumber = expandInfo.getLongNumber().split("!");
            String[] longnumber = null;
            IRow row = null;
            NumberExpandInfo expand = null;
            CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
            CostCenterOrgUnitInfo costCenterOrgUnitInfo2 = null;
            CostCenterOrgUnitCollection costCenterOrgUnitColl = new CostCenterOrgUnitCollection();
            CostCenterOrgUnitCollection tmpCol = new CostCenterOrgUnitCollection();
            String expandOrgNum = expandInfo.getLongNumber() + "!";
            for (int i = this.refOrgUnitCol.size() - 1; i >= 0; --i) {
                costCenterOrgUnitInfo2 = this.refOrgUnitCol.get(i);
                if (costCenterOrgUnitInfo2.getLongNumber().indexOf(expandOrgNum) != 0) continue;
                costCenterOrgUnitColl.add(costCenterOrgUnitInfo2);
            }
            try {
                if (costCenterOrgUnitColl == null || costCenterOrgUnitColl.isEmpty()) {
                    expandInfo.setLeaf(true);
                    break block11;
                }
                int jn = costCenterOrgUnitColl.size();
                for (int j = 0; j < jn; ++j) {
                    costCenterOrgUnitInfo = costCenterOrgUnitColl.get(j);
                    longnumber = costCenterOrgUnitInfo.getLongNumber().split("!");
                    if (longnumber.length - plongnumber.length != 1) continue;
                    row = table.addRow(rowAlias);
                    this.dealMergeInfo(table, row);
                    expand = new NumberExpandInfo();
                    expand.setId(costCenterOrgUnitInfo.getId().toString());
                    expand.setName(costCenterOrgUnitInfo.getName());
                    expand.setNumber(costCenterOrgUnitInfo.getNumber());
                    expand.setLongNumber(costCenterOrgUnitInfo.getLongNumber());
                    expand.setLevel(expandInfo.getLevel() + 1);
                    expandOrgNum = costCenterOrgUnitInfo.getLongNumber() + "!";
                    for (int i = this.refOrgUnitCol.size() - 1; i >= 0; --i) {
                        costCenterOrgUnitInfo2 = this.refOrgUnitCol.get(i);
                        if (costCenterOrgUnitInfo2.getLongNumber().indexOf(expandOrgNum) != 0) continue;
                        tmpCol.add(costCenterOrgUnitInfo2);
                    }
                    if (tmpCol == null || tmpCol.isEmpty()) {
                        expand.setLeaf(true);
                    } else {
                        expand.setLeaf(false);
                    }
                    expand.setExpandStatus(false);
                    expand.setCollect(false);
                    table.getCell(row.getRowIndex(), colAlias).setValue((Object)expand);
                    row.getCell(this.ORGCOL).setUserObject((Object)this.getOrgUnitByLNum(expandInfo.getLongNumber()));
                    tmpCol.clear();
                    row.getCell(this.BOOLEANCOL).setValue((Object)new Boolean(false));
                    if (this.haveDataOrg.containsKey(costCenterOrgUnitInfo.getId().toString())) continue;
                    row.getCell(this.BOOLEANCOL).setValue(null);
                    row.getStyleAttributes().setLocked(true);
                }
                row = table.addRow(rowAlias);
                this.dealMergeInfo(table, row);
                row.getStyleAttributes().setBackground(BgSHelper.COLLECT_COLOR);
                row.getStyleAttributes().setLocked(true);
                expand = new NumberExpandInfo();
                expand.setName(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"));
                expand.setLongNumber(expandInfo.getLongNumber() + "!");
                expand.setLevel(expandInfo.getLevel() + 1);
                expand.setLeaf(true);
                expand.setExpandStatus(false);
                expand.setCollect(true);
                table.getCell(row.getRowIndex(), colAlias).setValue((Object)expand);
                table.setRowCount(table.getBody().size());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void dealMergeInfo(KDTable table, IRow row) {
        List mblist;
        if (table == null || row == null) {
            return;
        }
        KDTMergeManager mm = table.getMergeManager();
        if (mm != null && !(mblist = mm.getMergeBlockList()).isEmpty()) {
            KDTMergeBlock mb = null;
            int n = mblist.size();
            for (int i = 0; i < n; ++i) {
                mb = (KDTMergeBlock)mblist.get(i);
                if (row.getRowIndex() != mb.getBottom() + 1) continue;
                mb.setBottom(mb.getBottom() + 1);
            }
        }
    }

    private boolean isCol(KDTable table, IRow row, int colIndex) {
        NumberExpandInfo info = (NumberExpandInfo)row.getCell(colIndex).getValue();
        return info.getName().equals(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"));
    }

    private CostCenterOrgUnitInfo getOrgUnitByLNum(String plongnumber) {
        if (plongnumber == null || this.orgUnits == null) {
            return null;
        }
        CostCenterOrgUnitInfo orgUnitInfo2 = null;
        for (CostCenterOrgUnitInfo orgUnitInfo2 : this.orgUnits) {
            if (!orgUnitInfo2.getLongNumber().equals(plongnumber)) continue;
            return orgUnitInfo2;
        }
        return null;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.addDataToOrgItem();
        this.getUIWindow().close();
    }

    @Override
    public void actionDisselectAllCostCenter_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (row == null || row.getStyleAttributes().isLocked()) continue;
            row.getCell(this.BOOLEANCOL).setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionSelectAllCostCenter_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (row == null || row.getStyleAttributes().isLocked()) continue;
            row.getCell(this.BOOLEANCOL).setValue((Object)new Boolean(true));
        }
    }

    private void addDataToOrgItem() throws BOSException, EASBizException {
        int i;
        IBgActualRecord iBgActualRecord = BgActualRecordFactory.getRemoteInstance();
        Object bgInfo = null;
        this.orgProportion = new HashMap();
        IRow row2 = null;
        int maxLevel = 0;
        String formId = null;
        String parentFormId = null;
        NumberExpandInfo numberExpandInfo = null;
        HashMap<IRow, BigDecimal> rowMap = new HashMap<IRow, BigDecimal>();
        BigDecimal proportion = null;
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            row2 = this.tblMain.getRow(i);
            if (row2.getCell(this.BOOLEANCOL) == null || row2.getCell(this.BOOLEANCOL).getValue() == null || !((Boolean)row2.getCell(this.BOOLEANCOL).getValue()).booleanValue() || row2.getCell(this.VALUECOL).getValue() == null) continue;
            numberExpandInfo = (NumberExpandInfo)row2.getCell(this.ORGCOL).getValue();
            this.orgProportion.put(numberExpandInfo.getId(), new BigDecimal(row2.getCell(this.VALUECOL).getValue().toString()));
            if (numberExpandInfo.getLevel() > maxLevel) {
                maxLevel = numberExpandInfo.getLevel();
            }
            rowMap.put(row2, new BigDecimal(row2.getCell(this.VALUECOL).getValue().toString()));
        }
        if (this.orgProportion.size() < 1) {
            this.orgProportion = null;
        } else {
            this.formProportion = new ArrayList();
            for (i = 0; i <= maxLevel; ++i) {
                for (IRow row2 : rowMap.keySet()) {
                    numberExpandInfo = (NumberExpandInfo)row2.getCell(this.ORGCOL).getValue();
                    if (numberExpandInfo.getLevel() != i) continue;
                    formId = (String)this.bgActualRecordMap.get(BOSUuid.read((String)numberExpandInfo.getId()));
                    parentFormId = (String)this.bgActualRecordMap.get(((CostCenterOrgUnitInfo)row2.getCell(this.ORGCOL).getUserObject()).getId());
                    proportion = (BigDecimal)rowMap.get(row2);
                    Object[] obj = new Object[]{formId, parentFormId, proportion};
                    this.formProportion.add(obj);
                }
            }
        }
    }

    public SelectorItemCollection getActualRecordSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bgForm.*"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("bgForm.name"));
        sic.add(new SelectorItemInfo("bgForm.number"));
        return sic;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) {
        if (e.getClickCount() == 1) {
            NumberExpandInfo expandInfo;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            if (rowIndex == -1 && colIndex == -1) {
                return;
            }
            KDTable table = (KDTable)e.getSource();
            if (table.getCell(rowIndex, colIndex).getValue() != null && table.getCell(rowIndex, colIndex).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)table.getCell(rowIndex, colIndex).getValue()) != null && this.expendRender.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(table, table.getRow(rowIndex), expandInfo, e.getColIndex());
            }
        }
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (this.isBoolean(e)) {
            this.getEditStarting(row);
        } else {
            this.oldValue = new BigDecimal("0");
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        IRow row = this.tblMain.getRow(e.getRowIndex());
        if (this.isBoolean(e)) {
            this.setEditStopped(row);
        } else {
            this.newValue = new BigDecimal("0");
        }
        if (!row.getCell(this.ORGCOL).getValue().toString().trim().equals(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"))) {
            this.addDataToColl(row);
        }
    }

    private void addDataToColl(IRow row) {
        if (this.oldValue != this.newValue) {
            for (int i = row.getRowIndex() - 1; i >= 0; --i) {
                if (this.tblMain.getCell(i, this.ORGCOL).getValue() == null || !this.tblMain.getCell(i, this.ORGCOL).getValue().toString().trim().equals(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"))) continue;
                NumberExpandInfo expand1 = (NumberExpandInfo)this.tblMain.getCell(row.getRowIndex(), this.ORGCOL).getValue();
                NumberExpandInfo expand2 = (NumberExpandInfo)this.tblMain.getCell(i, this.ORGCOL).getValue();
                if (expand1 == null || expand2 == null || expand2.getLevel() != expand1.getLevel()) continue;
                if (this.tblMain.getCell(i, this.VALUECOL).getValue() != null) {
                    String value = this.tblMain.getCell(i, this.VALUECOL).getValue().toString();
                    this.tblMain.getCell(i, this.VALUECOL).setValue((Object)new BigDecimal(value).add(this.newValue).subtract(this.oldValue));
                    break;
                }
                this.tblMain.getCell(i, this.VALUECOL).setValue((Object)this.newValue.subtract(this.oldValue));
                break;
            }
        }
    }

    private void setEditStopped(IRow row) {
        ICell cell = row.getCell(this.VALUECOL);
        this.newValue = null;
        try {
            this.newValue = new BigDecimal(cell.getValue().toString());
        }
        catch (Exception ex) {
            this.newValue = new BigDecimal("0");
        }
    }

    private void getEditStarting(IRow row) {
        ICell cell = row.getCell(this.VALUECOL);
        try {
            this.oldValue = new BigDecimal(cell.getValue().toString());
        }
        catch (Exception ex) {
            this.oldValue = new BigDecimal("0");
        }
    }

    private boolean isBoolean(KDTEditEvent e) {
        return this.tblMain.getCell(e.getRowIndex(), this.BOOLEANCOL) != null && this.tblMain.getCell(e.getRowIndex(), this.BOOLEANCOL).getValue() != null && (Boolean)this.tblMain.getCell(e.getRowIndex(), this.BOOLEANCOL).getValue() != false && this.tblMain.getCell(e.getRowIndex(), this.VALUECOL) != null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Map getData() {
        return this.orgProportion;
    }

    public List getFormProportion() {
        return this.formProportion;
    }
}

