/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.nbudget.BgDecompActualRecordFactory;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgDecompActualRecordListUI;
import com.kingdee.eas.ma.nbudget.client.BgDecompActualRecordEditUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgDecompActualRecordListUI
extends AbstractBgDecompActualRecordListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgDecompActualRecordListUI.class);
    private static final String res = "com.kingdee.eas.ma.nbudget.client.BgActualRecordDecompResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnEdit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnConfirm.setEnabled(false);
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDecompActualRecordFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgDecompActualRecordEditUI.class.getName();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isok = true;
        String[] state = this.getSelectedStatus();
        for (int i = 0; i < state.length; ++i) {
            if (!BgDecomposerStateEnum.SIGNED.toString().equals(state[i])) continue;
            isok = false;
            break;
        }
        if (!isok) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt"));
            SysUtil.abort();
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private void groupTableRow() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn(0).setGroup(true);
        this.tblMain.getColumn(1).setGroup(true);
        this.tblMain.getColumn(0).setMergeable(true);
        this.tblMain.getColumn(1).setMergeable(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bgActualRecord.name"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgPeriod.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgPeriod.name"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.id"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.orgUnit.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.orgUnit.id"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.bgScheme.*"));
        sic.add(new SelectorItemInfo("bgActualRecord.bgForm.bgScheme.id"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("otherCon"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("adjustMapData"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.getSelectedStatus() == null || this.getSelectedStatus().length == 0) {
            return;
        }
        String state = this.getSelectedStatus()[0];
        if (BgDecomposerStateEnum.SIGNED.toString().equals(state)) {
            this.disableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (Action)this.actionEdit);
            this.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (Action)this.actionRemove);
            this.disableAction((JButton)this.btnConfirm, null, (Action)this.actionEdit);
        } else {
            this.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (Action)this.actionEdit);
            this.enableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (Action)this.actionRemove);
            this.enableAction((JButton)this.btnConfirm, null, (Action)this.actionEdit);
        }
    }

    protected void enableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, true);
    }

    protected void disableAction(JButton button, JMenuItem menuItem, Action action) {
        this.setAction(button, menuItem, action, false);
    }

    private void setAction(JButton button, JMenuItem menuItem, Action action, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        if (menuItem != null) {
            menuItem.setEnabled(enabled);
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    public String[] getSelectedStatus() {
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<String> idList = new ArrayList<String>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            if (top == -1 || bottom == -1) continue;
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell("state");
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue().toString());
            }
        }
        String[] listId = null;
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            listId = new String[idList.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedStatus() == null || this.getSelectedStatus().length == 0) {
            return;
        }
        String state = this.getSelectedStatus()[0];
        if (BgDecomposerStateEnum.SIGNED.toString().equals(state)) {
            MsgBox.showError((String)EASResource.getString((String)res, (String)"confirmed"));
            SysUtil.abort();
            return;
        }
        String id = this.getSelectedId()[0];
        BgDecompActualRecordFactory.getRemoteInstance().confirm((IObjectPK)new ObjectUuidPK(id));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"confirmSuccess"));
        this.refreshList();
    }

    public String[] getSelectedId() {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<String> idList = new ArrayList<String>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell("id");
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue().toString());
            }
        }
        String[] listId = null;
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            listId = new String[idList.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgActualRecord.bgForm.orgUnit.id", (Object)SysContext.getSysContext().getCurrentCostUnit().getId().toString(), CompareType.EQUALS));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("bgActualRecord.bgForm.bgScheme.PERIOD", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bgActualRecord.bgForm.bgScheme.PERIOD", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.setMaskString("#0 and #1");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> org = new HashSet<String>();
            org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermissionForDec(userId, org, filter);
        }
        return filter;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"bgActualRecord.number", "bgActualRecord.name"};
        return locateNames;
    }
}

