/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.nbudget.BgElimContext;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationHelper;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.IBgElimFacade;
import com.kingdee.eas.ma.nbudget.client.AbstractBgElimOrgUnitSetUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BgElimOrgUnitSetUI
extends AbstractBgElimOrgUnitSetUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElimOrgUnitSetUI.class);
    private static final String SOURCE_STR = "com.kingdee.eas.ma.nbudget.client.BgAreaResource";
    private static final String SOURCE_BGELIM = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private OrgTreeCollection treeCollection = null;
    private Map mapCache = new HashMap();
    private boolean isModify = false;
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getColumn(0).getStyleAttributes().setLocked(true);
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.disablePerm();
        orgView.setTitle(BgAnalyseHelper.getMessage((String)"orgUnitTitle"));
        orgView.setCuID("00000000-0000-0000-0000-000000000000CCE7AED4");
        orgView.setMultiSelect(false);
        orgView.setReturnSuperior(false);
        prmtSelect.setSelector((KDPromptSelector)orgView);
        this.tblMain.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        this.listOrgBound_actionPerformed(null);
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                BgElimOrgUnitSetUI.this.setModify(true);
            }
        });
    }

    protected void init() throws Exception {
        this.treeCollection = BgEliminationHelper.getOrgTreeCollection();
        if (this.treeCollection == null) {
            this.treeCollection = new OrgTreeCollection();
        }
        this.listOrgBound.removeAllItems();
        this.listOrgBound.addItem((Object)BgNFCHelper.getMessageStr(SOURCE_STR, "all"));
        this.listOrgBound.addItems(this.treeCollection.toArray());
        AbstractAction actionSave2 = new AbstractAction(){
            private static final long serialVersionUID = 8707818271853932164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BgElimOrgUnitSetUI.this.actionSave_actionPerformed(e);
                }
                catch (Exception ex) {
                    BgElimOrgUnitSetUI.this.handleException(ex);
                }
            }
        };
        String strKey = "CTRL_S";
        KeyStroke ks = KeyStroke.getKeyStroke(83, 192, false);
        this.getActionMap().put(strKey, actionSave2);
        this.getInputMap(2).put(ks, strKey);
        ActionMap map = this.tblMain.getActionMap();
        map.remove("Cut");
        map.remove("Paste");
        map.remove("Copy");
        map.remove("Delete");
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    public boolean isModify() {
        return this.isModify;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.listOrgBound.setLimitedSize(false);
        this.listOrgBound.setComboPopupWidth(300);
    }

    @Override
    protected void listOrgBound_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.listOrgBound.getSelectedItem();
        if (obj != null) {
            int _result;
            if (this.isModify() && (_result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSelect"))) == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            }
            this.tblMain.removeRows();
            if (obj instanceof String && ((String)obj).equals(BgNFCHelper.getMessageStr(SOURCE_STR, "all"))) {
                HashMap<OrgTreeInfo, Object> map = new HashMap<OrgTreeInfo, Object>();
                if (this.treeCollection != null && !this.treeCollection.isEmpty()) {
                    ArrayList<String> treeIdList = new ArrayList<String>();
                    for (int i = 0; i < this.treeCollection.size(); ++i) {
                        treeIdList.add(this.treeCollection.get(i).getId().toString());
                        map.put(this.treeCollection.get(i), null);
                    }
                    Map returnMap = this.getBgElimFacade().getOrgMapping(treeIdList);
                    this.fillMap(map, returnMap);
                    this.fillMap(this.mapCache, returnMap);
                    this.refreshTable(map);
                }
            } else if (obj instanceof OrgTreeInfo) {
                HashMap map = new HashMap();
                map.put(obj, null);
                if (this.mapCache != null && this.mapCache.containsKey(obj)) {
                    map.put(obj, this.mapCache.get(obj));
                    this.refreshTable(map);
                } else {
                    ArrayList<String> treeIdList = new ArrayList<String>();
                    treeIdList.add(((OrgTreeInfo)obj).getId().toString());
                    Map returnMap = this.getBgElimFacade().getOrgMapping(treeIdList);
                    this.fillMap(map, returnMap);
                    this.fillMap(this.mapCache, returnMap);
                    this.refreshTable(map);
                }
            }
        }
        this.setModify(false);
    }

    protected void refreshTable(Map map) {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (map == null || map.isEmpty()) {
            return;
        }
        OrgTreeInfo treeInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        IRow _row = null;
        if (this.treeCollection != null && map != null) {
            for (int i = 0; i < this.treeCollection.size(); ++i) {
                treeInfo = this.treeCollection.get(i);
                if (!map.containsKey(treeInfo)) continue;
                orgUnitInfo = (FullOrgUnitInfo)map.get(treeInfo);
                _row = this.tblMain.addRow();
                _row.getCell(0).setValue((Object)treeInfo);
                _row.getCell(1).setValue((Object)orgUnitInfo);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        OrgTreeInfo _orgTreeInfo = null;
        OrgUnitInfo _unitInfo = null;
        HashMap<OrgTreeInfo, OrgUnitInfo> map = new HashMap<OrgTreeInfo, OrgUnitInfo>();
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            row = this.tblMain.getRow(i);
            _orgTreeInfo = (OrgTreeInfo)row.getCell(0).getValue();
            _unitInfo = (OrgUnitInfo)row.getCell(1).getValue();
            map.put(_orgTreeInfo, _unitInfo);
        }
        int re = MsgBox.showConfirm2((String)BgNFCHelper.getMessageStr(SOURCE_BGELIM, "setOrgUnitMappingWorning"));
        if (re == 0) {
            this.getBgElimFacade().saveOrgMapping(map);
            this.setMessageText(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgPermissionResource", "saveOK"));
            this.showMessage();
            _orgTreeInfo = this.ctx.getCurOrgBound();
            if (_orgTreeInfo != null && _orgTreeInfo.getId() != null) {
                _unitInfo = (OrgUnitInfo)BgEliminationHelper.getValueFromMap(map, _orgTreeInfo.getId().toString());
                ((BgElimContext)this.ctx).setCurMappedOrgUnit(_unitInfo);
            }
            this.setModify(false);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re && this.isModify()) {
            int _result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCE_STR, (String)"beforeSave"));
            if (_result == 0) {
                try {
                    IPermission iPer = PermissionFactory.getRemoteInstance();
                    UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
                    String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                    iPer.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgUnitId), "bg_BgElimOrgUnitSetUI002_save");
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception ex) {
                    this.handUIExceptionAndAbort(ex);
                }
            } else if (_result == 2) {
                re = false;
            }
        }
        return re;
    }

    private void fillMap(Map map, Map fillMap) {
        if (map == null || fillMap == null || fillMap.isEmpty()) {
            return;
        }
        CoreBaseInfo cbi2 = null;
        CoreBaseInfo cbiFill2 = null;
        block0: for (CoreBaseInfo cbiFill2 : fillMap.keySet()) {
            for (CoreBaseInfo cbi2 : map.keySet()) {
                if (!cbi2.getId().equals((Object)cbiFill2.getId())) continue;
                map.put(cbi2, fillMap.get(cbiFill2));
                continue block0;
            }
        }
    }

    public IBgElimFacade getBgElimFacade() throws Exception {
        return BgElimFacadeFactory.getRemoteInstance();
    }
}

