/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgElimContextHelper;
import com.kingdee.eas.ma.nbudget.BgElimSourceEnum;
import com.kingdee.eas.ma.nbudget.BgElimTypeEnum;
import com.kingdee.eas.ma.nbudget.BgEliminationEntryInfo;
import com.kingdee.eas.ma.nbudget.BgEliminationFactory;
import com.kingdee.eas.ma.nbudget.BgEliminationInfo;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgElimContext;
import com.kingdee.eas.ma.nbudget.client.AbstractBgEliminationEditUI;
import com.kingdee.eas.ma.nbudget.client.BgCodeNumberCHelper;
import com.kingdee.eas.ma.nbudget.client.IBgElimContextUI;
import com.kingdee.eas.ma.nbudget.client.UnionBudgetF7;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BgEliminationEditUI
extends AbstractBgEliminationEditUI
implements IBgElimContextUI {
    private static final Logger logger = CoreUIObject.getLogger(BgEliminationEditUI.class);
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.client.BgEliminationResource";
    private IBgElimContext ctx = BgElimContextHelper.getBgElimContext();
    private FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
    protected String commentColIndex = "comment";
    protected String orgUnitColIndex = "orgUnit";
    protected String bgItemIdColIndex = "bgItemId";
    protected String bgItemNumberColIndex = "bgItemNumber";
    protected String bgItemNameColIndex = "bgItemName";
    protected String debitAmountColIndex = "debitAmount";
    protected String creditAmountColIndex = "creditAmount";
    private static final String NUM_FOTMATTER = BgNationalFormatUIUtil.getNumberFormat((int)2);
    public static final String STATUS_AUDIT = "STATUS_AUDIT";
    public static final String STATUS_ANTI_AUDIT = "STATUS_ANTI_AUDIT";
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;

    public void onLoad() throws Exception {
        super.onLoad();
        BgElimContextHelper.registUIObject(this);
        this.init();
        if (this.orgUnitInfo != null) {
            String OUID = this.orgUnitInfo.getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)this.editData, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)this.editData, OUID));
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnAddNewLine.setText("");
        this.btnDeleteLine.setText("");
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.txtBorrowAmount.setPrecision(2);
        this.txtLoanAmount.setPrecision(2);
        if (this.isHasCodeNumber()) {
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        if (this.kdtEntries.getRowCount() != 0) {
            this.setCreditAndDebitAmountSum();
        }
        if (OprtState.VIEW.equals(this.getOprtState()) || this.isAudit() || this.isAntiAudit()) {
            this.setCanEdit(false);
            this.btnAddNew.setEnabled(false);
            this.menuItemAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            if (this.isAudit()) {
                this.btnAudit.setVisible(true);
                this.menuItemAudit.setVisible(true);
                this.btnAntiAudit.setVisible(false);
                this.menuItemAntiAudit.setVisible(false);
            } else if (this.isAntiAudit()) {
                this.btnAntiAudit.setVisible(true);
                this.menuItemAntiAudit.setVisible(true);
                this.btnAudit.setVisible(false);
                this.menuItemAudit.setVisible(false);
            } else if (OprtState.VIEW.equals(this.getOprtState())) {
                this.btnAudit.setVisible(false);
                this.menuItemAudit.setVisible(false);
                this.btnAntiAudit.setVisible(false);
                this.menuItemAntiAudit.setVisible(false);
            }
        }
    }

    protected boolean isAudit() {
        return STATUS_AUDIT.equals(this.getUIContext().get("Status"));
    }

    protected boolean isAntiAudit() {
        return STATUS_ANTI_AUDIT.equals(this.getUIContext().get("Status"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setVisible(false);
        this.menuItemSubmit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuItemCopy.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.menuItemCopyLine.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.menuItemCopyFrom.setVisible(false);
        this.btnCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnFirst.setVisible(false);
        this.menuItemFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.menuItemPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.menuItemNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.menuItemLast.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.menuItemTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.menuItemTraceDown.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.menuItemCreateFrom.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.menuItemCreateTo.setVisible(false);
        this.btnPrint.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuWorkflow.setVisible(false);
        this.menuView.setVisible(false);
        this.menuSubmitOption.setVisible(false);
        this.menuBiz.setVisible(false);
        this.btnRemove.setVisible(false);
        this.menuItemRemove.setVisible(false);
        this.btnAudit.setVisible(false);
        this.menuItemAudit.setVisible(false);
        this.btnAntiAudit.setVisible(false);
        this.menuItemAntiAudit.setVisible(false);
    }

    private void init() throws Exception {
        this.getDetailTable().checkParsed();
        this.getDetailTable().setUserCellDisplayParser((IUserCellDisplayParser)new UserCellDisplayParser());
        KDFormattedTextField formattedTextField = null;
        formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(2);
        formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
        this.kdtEntries.getColumn(this.debitAmountColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.kdtEntries.getColumn(this.creditAmountColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.comboElimType.removeItem((Object)BgElimTypeEnum.None);
        this.comboElimType.removeItem((Object)BgElimTypeEnum.All);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.comboElimType.setSelectedItem((Object)BgElimTypeEnum.ComeAndGo);
            if (this.ctx.getCurBgDataType() != null) {
                this.comboDataType.setSelectedItem((Object)this.ctx.getCurBgDataType());
                this.comboDataType.setEnabled(false);
            }
            this.getDetailTable().addRow();
            this.getDetailTable().addRow();
        }
        this.resetBgSchemeF7();
        this.resetBgPeriodF7();
        this.resetOppOrgUnitF7();
        this.resetBgItemF7();
    }

    private void resetBgSchemeF7() throws BOSException {
        if (this.ctx.getCurBgScheme() != null) {
            this.prmtBgScheme.setData((Object)this.ctx.getCurBgScheme());
            this.prmtBgScheme.setEnabled(false);
        } else {
            String orgUnitId = null;
            OrgUnitInfo orgUnit = this.ctx.getCurMappedOrgUnit();
            orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.Id", (Object)orgUnitId));
            SorterItemCollection sorter = new SorterItemCollection();
            sorter.add(new SorterItemInfo("number"));
            view.setFilter(filter);
            view.setSorter(sorter);
            this.prmtBgScheme.setEntityViewInfo(view);
            this.prmtBgScheme.setEnabled(true);
        }
    }

    private void resetBgPeriodF7() throws BOSException {
        if (this.ctx.getCurBgPeriod() != null) {
            this.prmtBgPeriod.setData((Object)this.ctx.getCurBgPeriod());
            this.prmtBgPeriod.setEnabled(false);
        } else {
            BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
            this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
            this.prmtBgPeriod.setEnabled(true);
        }
    }

    private void resetOppOrgUnitF7() throws BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        UnionBudgetF7 UnionBudgetF72 = new UnionBudgetF7((IUIObject)this, 1);
        OrgTreeInfo orgTreeInfo = this.ctx.getCurOrgBound();
        UnionBudgetF72.setTreeID(orgTreeInfo.getId().toString());
        OrgUnitInfo orgUnitInfo = this.ctx.getCurOrgGroup();
        UnionBudgetF72.setRootUnitID(orgUnitInfo.getId().toString());
        UnionBudgetF72.setUsePerm(true);
        prmtSelect.setSelector((KDPromptSelector)UnionBudgetF72);
        this.getDetailTable().getColumn("orgUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        prmtSelect.setCommitFormat("$number$");
    }

    private void resetBgItemF7() throws BOSException {
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        NewBgItemDialog dialog = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = null;
        OrgUnitInfo orgUnit = this.ctx.getCurMappedOrgUnit();
        try {
            orgUnitId = orgUnit != null ? orgUnit.getId().toString() : "NONE_ORGUNIT_ID";
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        dialog.setOrgUnitId(orgUnitId);
        dialog.setElimType((BgElimTypeEnum)((Object)this.comboElimType.getSelectedItem()));
        dialog.setSelectCombinItem(false);
        dialog.setMulSelect(false);
        prmtSelect.setSelector((KDPromptSelector)dialog);
        prmtSelect.setEditable(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$number$");
        prmtSelect.setCommitFormat("$number$");
        prmtSelect.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgEliminationEditUI.this.bgVisualItemInfo_dataChanged(eventObj);
            }
        });
        this.getDetailTable().getColumn(this.bgItemNumberColIndex).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    protected void bgVisualItemInfo_dataChanged(DataChangeEvent e) {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int n = rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        if (e.getNewValue() != null) {
            if (e.getNewValue() instanceof BgItemObject) {
                BgItemObject bgItem = (BgItemObject)e.getNewValue();
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setUserObject((Object)bgItem);
                this.getDetailTable().getCell(rowIndex, this.bgItemNameColIndex).setValue((Object)bgItem.getResult().get(0).getName());
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue((Object)bgItem.getResult().get(0).getNumber());
            } else if (e.getNewValue() instanceof String) {
                this.getDetailTable().getCell(rowIndex, this.bgItemNumberColIndex).setValue(e.getNewValue());
            }
        }
    }

    @Override
    protected void comboElimType_itemStateChanged(ItemEvent e) throws Exception {
        IRow row = null;
        for (int i = 0; i < this.getDetailTable().getRowCount(); ++i) {
            row = this.getDetailTable().getRow(i);
            row.getCell(this.bgItemIdColIndex).setValue(null);
            row.getCell(this.bgItemNumberColIndex).setValue(null);
            row.getCell(this.bgItemNameColIndex).setValue(null);
            row.getCell(this.bgItemNumberColIndex).setUserObject(null);
        }
        this.resetBgItemF7();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        BgEliminationInfo bgElimination = new BgEliminationInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        bgElimination.setCreator(userInfo);
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
        }
        bgElimination.setOrgUnit(this.orgUnitInfo);
        bgElimination.setElimType(BgElimTypeEnum.getEnum(1));
        bgElimination.setSource(BgElimSourceEnum.manual);
        try {
            if (this.ctx.getCurBgScheme() != null) {
                bgElimination.setBgScheme(this.ctx.getCurBgScheme());
            }
            if (this.ctx.getCurBgPeriod() != null) {
                bgElimination.setBgPeriod(this.ctx.getCurBgPeriod());
            }
            bgElimination.setDataType(this.ctx.getCurBgDataType());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String OUID = bgElimination.getOrgUnit().getId().toString();
            this.setHasCodeNumber(BgCodeNumberCHelper.hasCodeNumber((IObjectValue)bgElimination, OUID));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgCodeNumberCHelper.hasDisplayNumber((IObjectValue)bgElimination, OUID));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
            this.getNumberByCodingRule((IObjectValue)bgElimination, OUID);
        }
        return bgElimination;
    }

    protected void getNumberByCodingRule(IObjectValue caller, String orgId) {
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(this.txtNumber, caller, orgId, this.isHasCodeNumber(), this.isHasShowCodeNumber());
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BgEliminationEntryInfo bgEliminationEntryInfo = new BgEliminationEntryInfo();
        bgEliminationEntryInfo.setDebitAmount(new BigDecimal("0.00"));
        bgEliminationEntryInfo.setCreditAmount(new BigDecimal("0.00"));
        return bgEliminationEntryInfo;
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        if (colIndex == 4 || colIndex == 5) {
            if (colIndex == 4 && this.kdtEntries.getCell(rowIndex, colIndex) != null && this.kdtEntries.getCell(rowIndex, colIndex).getValue() != null) {
                this.kdtEntries.getCell(rowIndex, 5).setValue((Object)new BigDecimal("0.00"));
            } else if (colIndex == 5 && this.kdtEntries.getCell(rowIndex, colIndex) != null && this.kdtEntries.getCell(rowIndex, colIndex).getValue() != null) {
                this.kdtEntries.getCell(rowIndex, 4).setValue((Object)new BigDecimal("0.00"));
            }
            this.setCreditAndDebitAmountSum();
        }
    }

    private void setCreditAndDebitAmountSum() {
        this.txtBorrowAmount.setText(this.getDebitAmountCount().toString());
        this.txtLoanAmount.setText(this.getCreditAmountCount().toString());
    }

    private BigDecimal getCreditAmountCount() {
        BigDecimal creditAmount = new BigDecimal("0.00");
        BigDecimal creditAmountCount = new BigDecimal("0.00");
        Object value = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            value = this.kdtEntries.getCell(i, this.creditAmountColIndex).getValue();
            if (value instanceof BigDecimal) {
                creditAmount = (BigDecimal)value;
                creditAmountCount = creditAmountCount.add(creditAmount);
                continue;
            }
            if (!(value instanceof String)) continue;
            creditAmount = new BigDecimal((String)value);
            creditAmountCount = creditAmountCount.add(creditAmount);
        }
        return creditAmountCount;
    }

    private BigDecimal getDebitAmountCount() {
        BigDecimal debitAmount = new BigDecimal("0.00");
        BigDecimal debitAmountCount = new BigDecimal("0.00");
        Object value = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            value = this.kdtEntries.getCell(i, this.debitAmountColIndex).getValue();
            if (value instanceof BigDecimal) {
                debitAmount = (BigDecimal)value;
                debitAmountCount = debitAmountCount.add(debitAmount);
                continue;
            }
            if (!(value instanceof String)) continue;
            debitAmount = new BigDecimal((String)value);
            debitAmountCount = debitAmountCount.add(debitAmount);
        }
        return debitAmountCount;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgEliminationFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String number = this.txtNumber.getText();
        if (this.isHasCodeNumber()) {
            if (this.isHasShowCodeNumber() && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberEmpty"));
                this.txtNumber.requestFocus();
                SysUtil.abort();
            }
        } else if (StringUtils.isEmpty((String)number)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberEmpty"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else if (!this.isNumberValidity(number)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"numberHasEspecialChar"));
            SysUtil.abort();
        }
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"schemeEmpty"));
            this.prmtBgScheme.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBgPeriod.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"periodEmpty"));
            this.prmtBgPeriod.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtBgElement.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"elementEmpty"));
            this.prmtBgElement.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtCurrency.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"currencyEmpty"));
            this.prmtCurrency.requestFocus();
            SysUtil.abort();
        }
        if (number.length() > 80) {
            this.txtNumber.setText(number.substring(0, 80));
        }
        this.checkEntriesValidity();
        this.beforeSave();
    }

    protected void beforeSave() throws Exception {
        Object value = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            value = this.kdtEntries.getCell(i, this.orgUnitColIndex).getValue();
            if (!(value instanceof OrgUnitInfo)) continue;
            this.editData.getEntries().get(i).setOrgUnit(((OrgUnitInfo)value).castToFullOrgUnitInfo());
        }
    }

    private boolean isNumberValidity(String str) {
        return str.matches("[^\\*\\/\\_\\|\\%]+");
    }

    private void checkEntriesValidity() {
        int rowCount = this.kdtEntries.getRowCount();
        if (!BgNSHelper.isVerifyOfLoanBalance(null) && rowCount < 2) {
            String msg = EASResource.getString((String)RES_PATH, (String)"elimTemplateEntryLessThenTwoRow");
            MsgBox.showWarning((Component)((Object)this), (String)(msg.substring(0, 4) + msg.substring(6, msg.length())));
            SysUtil.abort();
        } else if (!BgNSHelper.isVerifyOfLoanBalance(null) && this.getCreditAmountCount().doubleValue() != this.getDebitAmountCount().doubleValue()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"borrowAmountNotEquasLoan"));
            SysUtil.abort();
        }
        for (int i = 0; i < rowCount; ++i) {
            this.isEntriesCorrect(i);
        }
    }

    private void isEntriesCorrect(int row) {
        Object objDebit = this.kdtEntries.getCell(row, this.debitAmountColIndex).getValue();
        Object objCredit = this.kdtEntries.getCell(row, this.creditAmountColIndex).getValue();
        BigDecimal debitAmount = BgNConstants.ZERO;
        BigDecimal creditAmount = BgNConstants.ZERO;
        if (objDebit instanceof String) {
            debitAmount = new BigDecimal((String)objDebit);
        } else if (objDebit instanceof BigDecimal) {
            debitAmount = (BigDecimal)objDebit;
        }
        if (objCredit instanceof String) {
            creditAmount = new BigDecimal((String)objCredit);
        } else if (objCredit instanceof BigDecimal) {
            creditAmount = (BigDecimal)objCredit;
        }
        if (this.kdtEntries.getCell(row, this.bgItemNumberColIndex).getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"backSchemeNotEmpty"), new Integer(row + 1)));
            SysUtil.abort();
        } else if (creditAmount.compareTo(BgNConstants.ZERO) == 0 && debitAmount.compareTo(BgNConstants.ZERO) == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)RES_PATH, (String)"backElimNotBothEmpty"), new Integer(row + 1)));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSave_actionPerformed(e);
        }
        catch (Exception ex) {
            if (ex instanceof BTPException && "904".equals(((BTPException)ex).getSubCode())) {
                String[] msgs = ((BTPException)ex).getMessage().split(":");
                if (msgs != null && msgs.length == 2) {
                    throw new BgCtrlException(BgCtrlException.NOTACROSS, (Object[])new String[]{msgs[1]});
                }
            }
            throw ex;
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.init();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getEditData() != null && this.getEditData().getId() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(this.getEditData().getId().toString());
            boolean result = BgEliminationFactory.getRemoteInstance().audit(ids);
            if (result) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"auditSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"auditFail"));
            }
            this.actionExitCurrent_actionPerformed(e);
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getEditData() != null && this.getEditData().getId() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(this.getEditData().getId().toString());
            boolean result = BgEliminationFactory.getRemoteInstance().antiAudit(ids);
            if (result) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"antiAuditSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES_PATH, (String)"antiAuditFail"));
            }
            this.actionExitCurrent_actionPerformed(e);
        }
    }

    private void setCanEdit(boolean editable) {
        this.btnEdit.setEnabled(editable);
        this.menuItemEdit.setEnabled(editable);
        this.btnAddLine.setEnabled(editable);
        this.btnCopyLine.setEnabled(editable);
        this.btnInsertLine.setEnabled(editable);
        this.btnRemoveLine.setEnabled(editable);
        this.menuItemAddLine.setEnabled(editable);
        this.menuItemCopyLine.setEnabled(editable);
        this.menuItemInsertLine.setEnabled(editable);
        this.menuItemRemoveLine.setEnabled(editable);
        this.btnAddNewLine.setEnabled(editable);
        this.btnDeleteLine.setEnabled(editable);
    }

    @Override
    public void update(Observable o, Object arg) {
        BgElimContextHelper.update(o, (CoreUI)this);
    }

    public boolean destroyWindow() {
        BgElimContextHelper.unRegistUIObject(this);
        return super.destroyWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            if (this.editData.getOrgTree() == null && this.ctx.getCurOrgBound() != null) {
                this.editData.setOrgTree(this.ctx.getCurOrgBound());
            }
            if (this.editData.getOrgUnit() == null) {
                if (this.orgUnitInfo != null) {
                    this.editData.setOrgUnit(this.orgUnitInfo);
                } else if (this.ctx.getCurOrgGroup() != null) {
                    this.editData.setOrgUnit(this.ctx.getCurOrgGroup().castToFullOrgUnitInfo());
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("orgTree.*");
        sic.add("orgUnit.*");
        sic.add("source");
        sic.add("status");
        return sic;
    }

    protected IObjectPK getOrgPK() {
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
        }
        if (this.orgUnitInfo != null && this.orgUnitInfo.getId() != null) {
            return new ObjectUuidPK(this.orgUnitInfo.getId());
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("ORG_UNIT");
        }
        if (this.orgUnitInfo != null && this.orgUnitInfo.getId() != null) {
            return new ObjectUuidPK(this.orgUnitInfo.getId());
        }
        return super.getOrgPK(action);
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (colIndex == 4 || colIndex == 5) {
            if (value instanceof BigDecimal) {
                if (BgNConstants.ZERO.compareTo((BigDecimal)value) == 0) {
                    return null;
                }
                if (StringUtils.isEmpty((String)cell.getFormattedStyleAttributes().getNumberFormat())) {
                    cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    cell.getStyleAttributes().setNumberFormat(NUM_FOTMATTER);
                }
            } else if (value instanceof String) {
                try {
                    value = new BigDecimal(value.toString());
                    if (BgNConstants.ZERO.compareTo((BigDecimal)value) == 0) {
                        return null;
                    }
                    if (StringUtils.isEmpty((String)cell.getFormattedStyleAttributes().getNumberFormat())) {
                        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        cell.getStyleAttributes().setNumberFormat(NUM_FOTMATTER);
                    }
                }
                catch (Exception e) {
                    return value;
                }
            }
        }
        return value;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    private final class UserCellDisplayParser
    implements IUserCellDisplayParser {
        private UserCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgEliminationEditUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

