/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgAvlBalDetailUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.BgExecuteAnalyseBillInfo;
import com.kingdee.eas.ma.nbudget.BgExecuteAnalyseInfo;
import com.kingdee.eas.ma.nbudget.BgExecuteFilterParam;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgExecuteAnalyseMainUI;
import com.kingdee.eas.ma.nbudget.client.BgExecuteAnalyseFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BgExecuteAnalyseMainUI
extends AbstractBgExecuteAnalyseMainUI {
    private static final long serialVersionUID = -7952506513669231356L;
    private static final Logger logger = CoreUIObject.getLogger(BgExecuteAnalyseMainUI.class);
    private static final String tmpFileKey = "BgExeAnalyse";
    private Map dataMap = new HashMap();
    private Map fileMap = new HashMap();
    private ChangeListener listener = null;
    private DateFormat format = BgNationalFormatUIUtil.getNationalDateFormat();
    private static String NUM_FOTMATTER = "#,##0.00";
    private KDTable selSheet = null;
    private int BGITEM_COMBINATION_NAME = 0;
    private int BGITEM_NAME = 1;
    private int BGPERIOD_NUMBER = 2;
    private int BILL_TYPE_NAME = 3;
    private int BILL_NUMBER = 4;
    private int BGELEMENT_NAME = 5;
    private int CURRENCY_NAME = 6;
    private int BUS_DATE = 7;
    private int CTRL_DATE = 8;
    private int ACTUAL_TYPE = 9;
    private int BILL_MONETARY = 10;
    private int BALANCE_MONETARY = 11;
    private int BGDATAID = 12;
    private int BILL_ID = 13;
    private int BILL_TYPE = 14;
    private int BILL_SOURCE_ORG = 5;
    private List billSourceOrg = null;
    private Map orgMap = null;

    public Map getOrgMap() {
        if (this.orgMap == null) {
            this.orgMap = new HashMap();
        }
        return this.orgMap;
    }

    public void setOrgMap(Map orgMap) {
        this.orgMap = orgMap;
    }

    public List getBillSourceOrg() {
        if (this.billSourceOrg == null) {
            this.billSourceOrg = new ArrayList();
        }
        return this.billSourceOrg;
    }

    public void setBillSourceOrg(List billSourceOrg) {
        this.billSourceOrg = billSourceOrg;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected String getQueryMainName() {
        return this.getMetaDataPK().getFullName();
    }

    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage((String)"bgEATitle"));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.menuItemViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.menuItemViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_inquirebudget"));
    }

    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgExecuteAnalyseFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    public Map getDataMap() {
        return this.dataMap;
    }

    public Map getFileMap() {
        return this.fileMap;
    }

    protected int getHeightOfDialog() {
        return 350;
    }

    protected int getWidthOfDialog() {
        return 290;
    }

    public void setSelSheet(KDTable selSheet) {
        this.selSheet = selSheet;
    }

    public KDTable getSelSheet() {
        return this.selSheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeQuery() {
        FilterParam _filterParam = this.getFilterParam();
        if (!(_filterParam instanceof BgExecuteFilterParam)) {
            return;
        }
        if (this.listener != null) {
            this.getMainTabPane().removeChangeListener(this.listener);
        }
        this.getDataMap().clear();
        BgAnalyseHelper.clearAllFile((Map)this.getFileMap());
        this.getFileMap().clear();
        this.setSelSheet(null);
        BgExecuteFilterParam param = (BgExecuteFilterParam)_filterParam;
        if (param.isByBillSourceOrgunitQuery()) {
            try {
                List list = this.getInterface().querySourceOrgunit((Object)_filterParam);
                OrgUnitInfo orgUnitInfo = null;
                OrgUnitInfo[] orgUnitInfos = null;
                if (list != null && !list.isEmpty()) {
                    orgUnitInfos = new OrgUnitInfo[list.size()];
                    Iterator it = list.iterator();
                    int i = list.size() - 1;
                    while (it.hasNext()) {
                        BgExecuteAnalyseInfo info = (BgExecuteAnalyseInfo)it.next();
                        orgUnitInfo = new OrgUnitInfo();
                        orgUnitInfo.setId(BOSUuid.read((String)info.getBillSourceOrgunitID()));
                        orgUnitInfo.setNumber(info.getBillSourceOrgunitNumber());
                        orgUnitInfo.setName(info.getBillSourceOrgunitName());
                        orgUnitInfos[i] = orgUnitInfo;
                        --i;
                    }
                }
                param.setOrgUnits(orgUnitInfos);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        this.init();
        try {
            Map map;
            if (this.getSelSheet() != null && (map = this.getInterface().queryExecuteData(this.getSelSheet().getID(), (Object)_filterParam)) != null) {
                this.getDataMap().putAll(map);
            }
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        finally {
            this.fillSheet(null);
        }
        this.initSheetListener();
        this.getMainTabPane().repaint();
    }

    protected void init() {
        this.clearAnalyseSheet();
        this.initAnalyseData();
    }

    protected void initAnalyseData() {
        BgExecuteFilterParam _itemAnalyseParam = (BgExecuteFilterParam)this.getFilterParam();
        OrgUnitInfo orgUnitInfo2 = null;
        OrgUnitInfo[] orgUnitInfos = null;
        KDTable sheet = null;
        orgUnitInfos = _itemAnalyseParam.getOrgUnits();
        if (orgUnitInfos != null) {
            for (OrgUnitInfo orgUnitInfo2 : orgUnitInfos) {
                sheet = this.addAnalyseSheet(orgUnitInfo2.getId().toString(), orgUnitInfo2.getName());
                this.initHeadOfSheet(sheet);
                if (this.getSelSheet() != null) continue;
                this.setSelSheet(sheet);
            }
        }
    }

    protected void dealListener(KDTable sheet) {
        super.dealListener(sheet);
        sheet.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    BgExecuteAnalyseMainUI.this.sheet_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    BgExecuteAnalyseMainUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void sheet_tableSelectChanged(KDTSelectEvent e) throws Exception {
        KDTable sheet = (KDTable)e.getSource();
        if (sheet != null) {
            Integer traceType;
            int rowIndex = sheet.getSelectManager().getActiveRowIndex();
            IRow row = sheet.getRow(rowIndex);
            int colIndex = this.BILL_TYPE;
            Object _obj = sheet.getUserObject();
            if (BgNConstants.FALSE_STR.equals(_obj)) {
                --colIndex;
            }
            if (row != null && row.getCell(colIndex) != null && row.getCell(colIndex).getValue() instanceof Integer && (3 == (traceType = (Integer)row.getCell(colIndex).getValue()) || 7 == traceType || 6 == traceType || 4 == traceType)) {
                this.enabledViewBill();
                return;
            }
        }
        this.disableViewBill();
    }

    protected void enabledViewBill() {
        this.btnViewBill.setEnabled(true);
        this.menuItemViewBill.setEnabled(true);
        this.actionViewBill.setEnabled(true);
    }

    protected void disableViewBill() {
        this.btnViewBill.setEnabled(false);
        this.menuItemViewBill.setEnabled(false);
        this.actionViewBill.setEnabled(false);
    }

    protected void initHeadOfSheet(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        BgExecuteFilterParam _filterParam = null;
        boolean isDisplaySourceOrg = false;
        boolean isByBillSourceOrgQuery = false;
        if (this.getFilterParam() instanceof BgExecuteFilterParam) {
            _filterParam = (BgExecuteFilterParam)this.getFilterParam();
        }
        if (_filterParam != null) {
            isDisplaySourceOrg = _filterParam.isDisplayBillSourceOrgUnit();
            isByBillSourceOrgQuery = _filterParam.isByBillSourceOrgunitQuery();
        }
        IRow row = null;
        sheet.checkParsed();
        if (sheet.getColumnCount() != 16 && isDisplaySourceOrg) {
            this.dealColumnNumber(0);
            sheet.addColumns(16);
        } else {
            this.dealColumnNumber(3);
            sheet.addColumns(15);
        }
        sheet.getGroupManager().setGroup(true);
        sheet.getColumn(this.BGITEM_COMBINATION_NAME).setWidth(125);
        sheet.getColumn(this.BGITEM_NAME).setWidth(125);
        sheet.getColumn(this.BGPERIOD_NUMBER).setWidth(70);
        sheet.getColumn(this.BILL_TYPE_NAME).setWidth(165);
        sheet.getColumn(this.BILL_NUMBER).setWidth(135);
        if (isDisplaySourceOrg) {
            sheet.getColumn(this.BILL_SOURCE_ORG).setWidth(135);
        }
        sheet.getColumn(this.BGELEMENT_NAME).setWidth(75);
        sheet.getColumn(this.CURRENCY_NAME).setWidth(55);
        sheet.getColumn(this.BUS_DATE).setWidth(70);
        sheet.getColumn(this.CTRL_DATE).setWidth(70);
        sheet.getColumn(this.ACTUAL_TYPE).setWidth(70);
        sheet.getColumn(this.BILL_MONETARY).setWidth(100);
        sheet.getColumn(this.BALANCE_MONETARY).setWidth(100);
        sheet.getColumn(this.BGDATAID).setWidth(0);
        sheet.getColumn(this.BILL_ID).setWidth(0);
        sheet.getColumn(this.BILL_TYPE).setWidth(0);
        sheet.getColumn(this.BGITEM_COMBINATION_NAME).getStyleAttributes().setWrapText(true);
        sheet.getColumn(this.BGITEM_NAME).getStyleAttributes().setWrapText(true);
        sheet.getColumn(this.BGELEMENT_NAME).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sheet.getColumn(this.CURRENCY_NAME).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sheet.getColumn(this.BILL_MONETARY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(this.BALANCE_MONETARY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        sheet.getColumn(this.BGDATAID).getStyleAttributes().setHided(true);
        sheet.getColumn(this.BILL_ID).getStyleAttributes().setHided(true);
        sheet.getColumn(this.BILL_TYPE).getStyleAttributes().setHided(true);
        if (isByBillSourceOrgQuery) {
            sheet.getColumn(this.BALANCE_MONETARY).getStyleAttributes().setHided(true);
        } else {
            sheet.getColumn(this.BALANCE_MONETARY).getStyleAttributes().setHided(false);
        }
        row = sheet.addHeadRow();
        row.getCell(this.BGITEM_COMBINATION_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"38_BgExecuteAnalyseMainUI"));
        row.getCell(this.BGITEM_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABgItem"));
        row.getCell(this.BGPERIOD_NUMBER).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABgPeriod"));
        row.getCell(this.BILL_TYPE_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABillType"));
        row.getCell(this.BILL_NUMBER).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABillNumber"));
        if (isDisplaySourceOrg) {
            row.getCell(this.BILL_SOURCE_ORG).setValue((Object)BgAnalyseHelper.getMessage((String)"billSourceOrgunit"));
        }
        row.getCell(this.BGELEMENT_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABgElement"));
        row.getCell(this.CURRENCY_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEACurrency"));
        row.getCell(this.BUS_DATE).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEABizDate"));
        row.getCell(this.CTRL_DATE).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEAProcDate"));
        row.getCell(this.BILL_MONETARY).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEAValue"));
        row.getCell(this.BALANCE_MONETARY).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEACurrBudget"));
        row.getCell(this.BGDATAID).setValue((Object)"BgDataId");
        row.getCell(this.BILL_ID).setValue((Object)"billId");
        row.getCell(this.BILL_TYPE).setValue((Object)"traceType");
        row.getCell(this.ACTUAL_TYPE).setValue((Object)BgAnalyseHelper.getMessage((String)"bgActualType"));
        sheet.getSelectManager().setSelectMode(2);
        sheet.getStyleAttributes().setLocked(true);
    }

    private void dealColumnNumber(int isDis) {
        if (isDis == 0) {
            this.BGELEMENT_NAME = 6;
            this.CURRENCY_NAME = 7;
            this.BUS_DATE = 8;
            this.CTRL_DATE = 9;
            this.ACTUAL_TYPE = 10;
            this.BILL_MONETARY = 11;
            this.BALANCE_MONETARY = 12;
            this.BGDATAID = 13;
            this.BILL_ID = 14;
            this.BILL_TYPE = 15;
        } else {
            this.BGELEMENT_NAME = 5;
            this.CURRENCY_NAME = 6;
            this.BUS_DATE = 7;
            this.CTRL_DATE = 8;
            this.ACTUAL_TYPE = 9;
            this.BILL_MONETARY = 10;
            this.BALANCE_MONETARY = 11;
            this.BGDATAID = 12;
            this.BILL_ID = 13;
            this.BILL_TYPE = 14;
        }
    }

    protected void fillSheet(KDTable sheet) {
        if (this.getDataMap() == null || this.getDataMap().isEmpty()) {
            return;
        }
        this.getBillSourceOrg().clear();
        this.getOrgMap().clear();
        KDTable _sheet = sheet;
        if (_sheet == null) {
            _sheet = (KDTable)this.getSelectSheet();
        }
        BgExecuteFilterParam filterParam = (BgExecuteFilterParam)this.getFilterParam();
        Map _bgItemMap = (Map)this.getDataMap().get("BGITEM_INFO");
        Map _bgPeriodMap = (Map)this.getDataMap().get("BGPERIOD_INFO");
        Map _bgElementMap = (Map)this.getDataMap().get("BGELEMENT_INFO");
        Map _currencyMap = (Map)this.getDataMap().get("CURRENCY_INFO");
        HashMap _groupMap = new HashMap();
        HashSet<String> _queryNoSet = new HashSet<String>();
        boolean _hasShowNumner = filterParam.getHasShowNumber();
        String _key = null;
        List _dataList = null;
        List<BgExecuteAnalyseInfo> _tmpList = null;
        BgExecuteAnalyseInfo _info = null;
        boolean isDisSourceOrg = filterParam.isDisplayBillSourceOrgUnit();
        if (_sheet != null) {
            _sheet.removeRows();
            String hasGroupCtrl = (String)this.getDataMap().get("HAS_GROUPCTRL");
            _sheet.setUserObject((Object)hasGroupCtrl);
            if (this.getDataMap().containsKey(_sheet.getID()) && (_dataList = (List)this.getDataMap().get(_sheet.getID())) != null) {
                int j;
                int jn = _dataList.size();
                for (j = 0; j < jn; ++j) {
                    _info = (BgExecuteAnalyseInfo)_dataList.get(j);
                    if (isDisSourceOrg) {
                        this.fillOrgSet(_info);
                    }
                    this.processAnalyseDataOfBgItem(_info, _bgItemMap, _hasShowNumner);
                    this.processAnalyseDataOfBgPeriod(_info, _bgPeriodMap);
                    this.processAnalyseDataOfBgElement(_info, _bgElementMap);
                    this.processAnalyseDataOfCurrency(_info, _currencyMap);
                    if (!_info.isHasGroupCtrl()) continue;
                    _key = _info.getGroupCtrlNo() + "_" + _info.getBgPeriodNumber();
                    if (_groupMap.containsKey(_key)) {
                        _tmpList = (List)_groupMap.get(_key);
                    } else {
                        _tmpList = new ArrayList();
                        _groupMap.put(_key, _tmpList);
                    }
                    _tmpList.add(_info);
                }
                if (isDisSourceOrg) {
                    try {
                        Map temp = this.getInterface().queryOrg(this.getBillSourceOrg());
                        if (temp != null) {
                            this.getOrgMap().putAll(temp);
                        }
                    }
                    catch (Exception e) {
                        this.handUIExceptionAndAbort(e);
                    }
                }
                jn = _dataList.size();
                for (j = 0; j < jn; ++j) {
                    _info = (BgExecuteAnalyseInfo)_dataList.get(j);
                    if (_info.isHasGroupCtrl()) {
                        _key = _info.getBgItemNumber() + "_" + _info.getGroupCtrlNo() + "_" + _info.getBgPeriodNumber();
                        if (_queryNoSet.contains(_key)) continue;
                        this.fillAnalyseDataInfo(_sheet, _info, _groupMap, _queryNoSet);
                        _queryNoSet.add(_key);
                        continue;
                    }
                    this.fillAnalyseDataInfo(_sheet, _info, null, null);
                }
            }
            if (BgNConstants.FALSE_STR.equals(hasGroupCtrl)) {
                _sheet.removeColumn(0);
            }
            this.saveAnalyseInfo(_sheet);
            this.setSelSheet(_sheet);
        }
    }

    private void fillOrgSet(BgExecuteAnalyseInfo info) {
        List infos;
        if (info == null) {
            return;
        }
        String billSourceOrgId = info.getBillSourceOrgunitID();
        if (!this.getBillSourceOrg().contains(billSourceOrgId) && !StringUtils.isEmpty((String)billSourceOrgId)) {
            this.getBillSourceOrg().add(billSourceOrgId);
        }
        if ((infos = info.getBillInfos()) != null && !infos.isEmpty()) {
            String billID = null;
            for (BgExecuteAnalyseBillInfo billInfo : infos) {
                billID = billInfo.getBillSourceOrgunitID();
                if (this.getBillSourceOrg().contains(billID) || StringUtils.isEmpty((String)billID)) continue;
                this.getBillSourceOrg().add(billID);
            }
        }
    }

    protected void processAnalyseDataOfBgItem(BgExecuteAnalyseInfo info, Map parameter, boolean hasShowNumber) {
        if (info == null || parameter == null) {
            return;
        }
        VisualItemInfo itemInfo = BgSHelper.getBgItemCombinInfo((String)info.getBgItemNumber(), (Map)parameter);
        if (itemInfo != null) {
            if (hasShowNumber) {
                info.setBgItemName(itemInfo.getNumber() + " " + itemInfo.getName());
            } else {
                info.setBgItemName(itemInfo.getName());
            }
        } else {
            info.setBgItemName(info.getBgItemNumber());
        }
    }

    protected void processAnalyseDataOfBgPeriod(BgExecuteAnalyseInfo info, Map parameter) {
        if (info == null || parameter == null) {
            return;
        }
        BgPeriodInfo bgPeriodInfo = null;
        if (parameter.containsKey(info.getBgPeriodId())) {
            bgPeriodInfo = (BgPeriodInfo)parameter.get(info.getBgPeriodId());
            info.setBgPeriodName(bgPeriodInfo.getName());
            info.setBgPeriodNumber(bgPeriodInfo.getNumber());
        } else {
            info.setBgPeriodName(info.getBgPeriodId());
            info.setBgPeriodNumber(info.getBgPeriodId());
        }
    }

    protected void processAnalyseDataOfBgElement(BgExecuteAnalyseInfo info, Map parameter) {
        if (info == null || parameter == null) {
            return;
        }
        BgElementInfo bgElementInfo = null;
        if (parameter.containsKey(info.getBgElementId())) {
            bgElementInfo = (BgElementInfo)parameter.get(info.getBgElementId());
            info.setBgElementName(bgElementInfo.getName());
        } else {
            info.setBgElementName(info.getBgElementId());
        }
    }

    protected void processAnalyseDataOfCurrency(BgExecuteAnalyseInfo info, Map parameter) {
        if (info == null || parameter == null) {
            return;
        }
        CurrencyInfo currencyInfo = null;
        if (parameter.containsKey(info.getCurrencyId())) {
            currencyInfo = (CurrencyInfo)parameter.get(info.getCurrencyId());
            info.setCurrencyName(currencyInfo.getName());
            info.setCurrencyNumber(currencyInfo.getNumber());
            info.setPrecision(currencyInfo.getPrecision());
        } else {
            info.setBgPeriodName(info.getCurrencyId());
        }
    }

    protected void fillAnalyseDataInfo(KDTable sheet, BgExecuteAnalyseInfo info, Map groupMap, Set queryInfo) {
        int i;
        int in;
        if (sheet == null || info == null || info.getBillInfos() == null || info.getBillInfos().isEmpty() || !info.isHasShowInfo()) {
            return;
        }
        BgExecuteFilterParam _filterParam = null;
        boolean isDisplaySourceOrg = false;
        boolean isByBillSourceOrg = false;
        if (this.getFilterParam() instanceof BgExecuteFilterParam) {
            _filterParam = (BgExecuteFilterParam)this.getFilterParam();
        }
        if (_filterParam != null) {
            isDisplaySourceOrg = _filterParam.isDisplayBillSourceOrgUnit();
            isByBillSourceOrg = _filterParam.isByBillSourceOrgunitQuery();
        }
        int beginIndex = 0;
        int endIndex = 0;
        int itemBegin = 0;
        int itemEnd = 0;
        int periodBegin = 0;
        int periodEnd = 0;
        boolean hasGroupActual = false;
        IRow beginRow = null;
        IRow row = null;
        String _key = null;
        BigDecimal sumValue = BgNConstants.ZERO;
        BigDecimal balValue = info.getValue();
        BgExecuteAnalyseInfo _tmpInfo = null;
        BgExecuteAnalyseBillInfo billInfo = null;
        List _tmpList = null;
        HashSet<String> _bgItemNumberSet = new HashSet<String>();
        if (!isByBillSourceOrg) {
            beginRow = sheet.addRow();
            itemBegin = beginIndex = beginRow.getRowIndex();
            periodBegin = beginIndex;
            if (info.isHasGroupCtrl()) {
                beginRow.getCell(this.BGITEM_COMBINATION_NAME).setValue((Object)info.getBgItemName());
            }
            beginRow.getCell(this.BGITEM_NAME).setValue((Object)info.getBgItemName());
            _bgItemNumberSet.add(info.getBgItemNumber());
            beginRow.getCell(this.BGPERIOD_NUMBER).setValue((Object)info.getBgPeriodNumber());
            beginRow.getCell(this.BILL_TYPE_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEACurrBudget"));
            beginRow.getCell(this.BGDATAID).setValue((Object)info.getBgDataId());
        }
        boolean isHideActualTypeColumn = true;
        if (info.getBillInfos() != null && !info.getBillInfos().isEmpty()) {
            in = info.getBillInfos().size();
            for (i = 0; i < in; ++i) {
                billInfo = (BgExecuteAnalyseBillInfo)info.getBillInfos().get(i);
                row = sheet.addRow();
                if (isByBillSourceOrg && i == 0) {
                    itemBegin = beginIndex = row.getRowIndex();
                    periodBegin = beginIndex;
                    row.getCell(this.BGITEM_COMBINATION_NAME).setValue((Object)info.getBgItemName());
                }
                row.getCell(this.BGITEM_NAME).setValue((Object)info.getBgItemName());
                row.getCell(this.BGPERIOD_NUMBER).setValue((Object)info.getBgPeriodNumber());
                row.getCell(this.BILL_TYPE_NAME).setValue((Object)billInfo.getBillType());
                row.getCell(this.BILL_NUMBER).setValue((Object)billInfo.getBillNumber());
                if (isDisplaySourceOrg && this.getOrgMap().containsKey(billInfo.getBillSourceOrgunitID())) {
                    row.getCell(this.BILL_SOURCE_ORG).setValue(this.getOrgMap().get(billInfo.getBillSourceOrgunitID()));
                }
                row.getCell(this.BGELEMENT_NAME).setValue((Object)info.getBgElementName());
                row.getCell(this.CURRENCY_NAME).setValue((Object)info.getCurrencyName());
                row.getCell(this.BUS_DATE).setValue((Object)this.format.format(billInfo.getBusTime()));
                row.getCell(this.CTRL_DATE).setValue((Object)this.format.format(billInfo.getProcTime()));
                row.getCell(this.BILL_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(info));
                row.getCell(this.BILL_MONETARY).setValue((Object)billInfo.getValue());
                row.getCell(this.BGDATAID).setValue((Object)info.getBgDataId());
                row.getCell(this.BILL_ID).setValue((Object)billInfo.getBillId());
                row.getCell(this.BILL_TYPE).setValue((Object)new Integer(billInfo.getBillTypeEnum()));
                if (isHideActualTypeColumn && billInfo.getActualTypeEnum() == 10) {
                    isHideActualTypeColumn = false;
                }
                row.getCell(this.ACTUAL_TYPE).setValue((Object)ActualTypeEnum.getEnum((int)billInfo.getActualTypeEnum()));
                sumValue = sumValue.add(billInfo.getValue());
            }
        }
        _key = info.getGroupCtrlNo() + "_" + info.getBgPeriodNumber();
        if (info.isHasGroupCtrl() && groupMap != null && groupMap.containsKey(_key)) {
            _tmpList = (List)groupMap.get(_key);
            if (_tmpList != null && row != null) {
                itemEnd = row.getRowIndex();
                sheet.getMergeManager().mergeBlock(itemBegin, 1, itemEnd, 1);
                in = _tmpList.size();
                for (i = 0; i < in; ++i) {
                    int rowIndex;
                    _tmpInfo = (BgExecuteAnalyseInfo)_tmpList.get(i);
                    if (_tmpInfo.getBgDataId().equals(info.getBgDataId())) continue;
                    itemBegin = rowIndex = row.getRowIndex() + 1;
                    _key = _tmpInfo.getBgItemNumber() + "_" + _tmpInfo.getGroupCtrlNo() + "_" + _tmpInfo.getBgPeriodNumber();
                    if (queryInfo != null) {
                        queryInfo.add(_key);
                    }
                    if (!_bgItemNumberSet.contains(_tmpInfo.getBgItemNumber())) {
                        sheet.getCell(beginIndex, this.BGITEM_COMBINATION_NAME).setValue((Object)(sheet.getCell(beginIndex, this.BGITEM_COMBINATION_NAME).getValue() + "," + _tmpInfo.getBgItemName()));
                        _bgItemNumberSet.add(_tmpInfo.getBgItemNumber());
                    }
                    if (_tmpInfo.getBillInfos() != null && !_tmpInfo.getBillInfos().isEmpty()) {
                        hasGroupActual = true;
                        int jn = _tmpInfo.getBillInfos().size();
                        for (int j = 0; j < jn; ++j) {
                            billInfo = (BgExecuteAnalyseBillInfo)_tmpInfo.getBillInfos().get(j);
                            row = sheet.addRow();
                            row.getCell(this.BGITEM_NAME).setValue((Object)_tmpInfo.getBgItemName());
                            row.getCell(this.BGPERIOD_NUMBER).setValue((Object)_tmpInfo.getBgPeriodNumber());
                            row.getCell(this.BILL_TYPE_NAME).setValue((Object)billInfo.getBillType());
                            row.getCell(this.BILL_NUMBER).setValue((Object)billInfo.getBillNumber());
                            if (isDisplaySourceOrg && this.getOrgMap().containsKey(billInfo.getBillSourceOrgunitID())) {
                                row.getCell(this.BILL_SOURCE_ORG).setValue(this.getOrgMap().get(billInfo.getBillSourceOrgunitID()));
                            }
                            row.getCell(this.BGELEMENT_NAME).setValue((Object)_tmpInfo.getBgElementName());
                            row.getCell(this.CURRENCY_NAME).setValue((Object)_tmpInfo.getCurrencyName());
                            row.getCell(this.BUS_DATE).setValue((Object)this.format.format(billInfo.getBusTime()));
                            row.getCell(this.CTRL_DATE).setValue((Object)this.format.format(billInfo.getProcTime()));
                            row.getCell(this.BILL_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
                            row.getCell(this.BILL_MONETARY).setValue((Object)billInfo.getValue());
                            row.getCell(this.BGDATAID).setValue((Object)_tmpInfo.getBgDataId());
                            row.getCell(this.BILL_ID).setValue((Object)billInfo.getBillId());
                            row.getCell(this.BILL_TYPE).setValue((Object)new Integer(billInfo.getBillTypeEnum()));
                            if (isHideActualTypeColumn && billInfo.getActualTypeEnum() == 10) {
                                isHideActualTypeColumn = false;
                            }
                            row.getCell(this.ACTUAL_TYPE).setValue((Object)ActualTypeEnum.getEnum((int)billInfo.getActualTypeEnum()));
                            sumValue = sumValue.add(billInfo.getValue());
                        }
                    }
                    itemEnd = row.getRowIndex();
                    sheet.getMergeManager().mergeBlock(itemBegin, 1, itemEnd, 1);
                }
            }
            if (!hasGroupActual) {
                itemBegin = beginIndex;
            }
        }
        sheet.getColumn(this.ACTUAL_TYPE).getStyleAttributes().setHided(isHideActualTypeColumn);
        if (row != null) {
            for (int x = row.getRowIndex(); x > beginIndex; --x) {
                row = sheet.getRow(x);
                row.getCell(this.BALANCE_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
                row.getCell(this.BALANCE_MONETARY).setValue((Object)balValue);
                balValue = balValue.add((BigDecimal)row.getCell(this.BILL_MONETARY).getValue());
            }
        }
        if (!isByBillSourceOrg) {
            row = sheet.addRow();
            if (_tmpInfo != null) {
                row.getCell(this.BGPERIOD_NUMBER).setValue((Object)_tmpInfo.getBgPeriodNumber());
            } else {
                row.getCell(this.BGPERIOD_NUMBER).setValue((Object)info.getBgPeriodNumber());
            }
            row.getCell(this.BILL_TYPE_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"bgEACurrBudget"));
            row.getCell(this.BALANCE_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
            row.getCell(this.BALANCE_MONETARY).setValue((Object)info.getValue());
            row.getCell(this.BGDATAID).setValue((Object)info.getBgDataId());
        }
        row = sheet.addRow();
        row.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
        itemEnd = endIndex = row.getRowIndex();
        periodEnd = endIndex;
        if (_tmpInfo != null) {
            row.getCell(this.BGPERIOD_NUMBER).setValue((Object)_tmpInfo.getBgPeriodNumber());
        } else {
            row.getCell(this.BGPERIOD_NUMBER).setValue((Object)info.getBgPeriodNumber());
        }
        row.getCell(this.BILL_TYPE_NAME).setValue((Object)BgAnalyseHelper.getMessage((String)"sum"));
        row.getCell(this.BALANCE_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
        row.getCell(this.BILL_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
        row.getCell(this.BILL_MONETARY).setValue((Object)sumValue);
        row.getCell(this.BALANCE_MONETARY).setValue((Object)info.getValue());
        row.getCell(this.BGDATAID).setValue((Object)info.getBgDataId());
        if (!isByBillSourceOrg) {
            beginRow.getCell(this.BALANCE_MONETARY).getStyleAttributes().setNumberFormat(this.getNumberFormat(_tmpInfo));
            beginRow.getCell(this.BALANCE_MONETARY).setValue((Object)balValue);
        }
        sheet.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
        sheet.getMergeManager().mergeBlock(itemBegin, 1, itemEnd, 1);
        sheet.getMergeManager().mergeBlock(periodBegin, 2, periodEnd, 2);
    }

    protected void initSheetListener() {
        if (this.getMainTabPane() != null) {
            if (this.listener == null) {
                this.listener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        try {
                            BgExecuteAnalyseMainUI.this.tabPane_stateChanged(e);
                        }
                        catch (Exception ex) {
                            BgExecuteAnalyseMainUI.this.handUIExceptionAndAbort(ex);
                        }
                    }
                };
            }
            this.getMainTabPane().addChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tabPane_stateChanged(ChangeEvent e) throws Exception {
        KDTable sheet = null;
        sheet = this.getSelSheet();
        if (sheet != null) {
            sheet.removeRows();
        }
        if ((sheet = (KDTable)this.getSelectSheet()) == null) {
            return;
        }
        if (this.getFileMap().containsKey(sheet.getID())) {
            this.loadAnalyseInfo(sheet);
            this.setSelSheet(sheet);
        } else {
            try {
                this.getDataMap().putAll(this.getInterface().queryExecuteData(sheet.getID(), (Object)this.getFilterParam()));
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
            finally {
                this.fillSheet(sheet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveAnalyseInfo(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        if (!this.getFileMap().containsKey(sheet.getID())) {
            SecureRandom random = new SecureRandom();
            DecimalFormat df = new DecimalFormat("0000000");
            String tmpStr = System.getProperty("user.dir") + "/" + tmpFileKey + df.format(random.nextInt(999999)) + ".kdf";
            KDF kdf = new KDF();
            kdf.addTable((IDObject)sheet);
            byte[] bytes = null;
            try {
                bytes = ZipKDF.pack((KDF)kdf);
                if (BgAnalyseHelper.saveToFile((String)tmpStr, (byte[])bytes, (int)4096)) {
                    this.getFileMap().put(sheet.getID(), tmpStr);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                bytes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadAnalyseInfo(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        String filename = (String)this.getFileMap().get(sheet.getID());
        byte[] bytes = BgAnalyseHelper.loadFormFile((String)filename);
        KDF kdf = null;
        KDTable tmpSheet = null;
        if (bytes != null && bytes.length > 0) {
            try {
                kdf = ZipKDF.unpack((byte[])bytes);
                if (kdf.getAllTable().size() > 0) {
                    tmpSheet = (KDTable)kdf.getTableByIndex(0);
                    this.loadSheet(sheet, tmpSheet);
                } else {
                    sheet.removeRows();
                }
            }
            catch (Exception ex) {
                this.handUIExceptionAndAbort(ex);
            }
            finally {
                kdf = null;
            }
        }
    }

    protected void loadSheet(KDTable tSheet, KDTable fSheet) {
        if (tSheet == null || fSheet == null) {
            return;
        }
        IRow tRow = null;
        IRow fRow = null;
        ICell tCell = null;
        ICell fCell = null;
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = fSheet.getExpandedRowCount();
        int colCount = fSheet.getExpandedColumnCount();
        tSheet.setRefresh(false);
        tSheet.removeRows();
        tSheet.addRows(rowCount);
        tSheet.setUserObject(fSheet.getUserObject());
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            tRow = tSheet.getRow(rowIndex);
            fRow = fSheet.getRow(rowIndex);
            if (tRow != null && fRow != null && fRow.getStyleAttributes().getBackground() != null) {
                tRow.getStyleAttributes().setBackground(fRow.getStyleAttributes().getBackground());
            }
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                tCell = tSheet.getCell(rowIndex, colIndex);
                fCell = fSheet.getCell(rowIndex, colIndex);
                if (tCell == null || fCell == null) continue;
                tCell.setValue(fCell.getValue());
                tCell.getStyleAttributes().setNumberFormat(fCell.getStyleAttributes().getNumberFormat());
            }
        }
        if (fSheet.getMergeManager().getMergeBlockList() != null) {
            KDTMergeBlock mergeBlock = null;
            List mergeList = fSheet.getMergeManager().getMergeBlockList();
            int in = mergeList.size();
            for (int i = 0; i < in; ++i) {
                mergeBlock = (KDTMergeBlock)mergeList.get(i);
                tSheet.getMergeManager().mergeBlock(mergeBlock.getTop(), mergeBlock.getLeft(), mergeBlock.getBottom(), mergeBlock.getRight());
            }
        }
        tSheet.setRefresh(true);
        tSheet.reLayoutAndPaint();
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal && StringUtils.isEmpty((String)cell.getFormattedStyleAttributes().getNumberFormat())) {
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.getStyleAttributes().setNumberFormat(NUM_FOTMATTER);
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            BgAnalyseHelper.clearAllFile((Map)this.getFileMap());
        }
        return re;
    }

    protected Object getSelectBillId() {
        int rowIndex;
        KDTable sheet = (KDTable)this.getSelectSheet();
        if (sheet != null && (rowIndex = sheet.getSelectManager().getActiveRowIndex()) >= 0) {
            IRow row = sheet.getRow(rowIndex);
            int colIndex = this.BILL_ID;
            Object _obj = sheet.getUserObject();
            if (BgNConstants.FALSE_STR.equals(_obj)) {
                --colIndex;
            }
            return row.getCell(colIndex).getValue();
        }
        return null;
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBill_actionPerformed(e);
        this.checkSelected();
        Object obj = this.getSelectBillId();
        if (obj != null) {
            String billid = obj.toString();
            CompanyOrgUnitInfo info = SysContext.getSysContext().getCurrentFIUnit();
            BgClientHelper.viewDetailBill((CoreUIObject)this, (String)billid.trim(), (CompanyOrgUnitInfo)info);
        }
    }

    protected Object getSelectBgDataId() {
        int rowIndex;
        KDTable sheet = (KDTable)this.getSelectSheet();
        if (sheet != null && (rowIndex = sheet.getSelectManager().getActiveRowIndex()) >= 0) {
            IRow row = sheet.getRow(rowIndex);
            int colIndex = this.BGDATAID;
            Object _obj = sheet.getUserObject();
            if (BgNConstants.FALSE_STR.equals(_obj)) {
                --colIndex;
            }
            return row.getCell(colIndex).getValue();
        }
        return null;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        this.checkSelected();
        Object bgDataId = this.getSelectBgDataId();
        if (bgDataId != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"bgDataId", bgDataId);
            uiContext.put((Object)"formatStyle", (Object)NUM_FOTMATTER);
            uiContext.put((Object)"isCtrl", (Object)Boolean.FALSE);
            uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    public void checkSelected() {
        KDTable sheet = (KDTable)this.getSelectSheet();
        if (sheet != null && (sheet.getRowCount() == 0 || sheet.getSelectManager().size() == 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (request == null) {
                request = new RequestContext();
                request.setClassName(this.getUIHandlerClassName());
                handler.setRequestContext((Serializable)request);
            }
            request.put("QUERY_NAME", (Object)this.getQueryMainName());
            request.put("QUERY_PK_NAME", (Object)this.getQueryPk().getFullName());
        }
        return handler;
    }

    protected String getNumberFormat(BgExecuteAnalyseInfo info) {
        int precision;
        if (info != null && (precision = info.getPrecision()) != 0) {
            NUM_FOTMATTER = "#,##0." + BgNFSHelper.getNumberFormat("0", precision);
        }
        return NUM_FOTMATTER;
    }
}

