/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgFormOrgViewUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;

public class BgFormOrgViewDisplayValueProvider
implements IDisplayValueProvider {
    private static String BGFORMULA = "bgformula";
    private static String BGACTUALS = "bgactuals";
    private static String BGBALANCE = "bgbal";
    private BgFormOrgViewUI ui = null;

    public BgFormOrgViewDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgFormOrgViewUI) {
            this.ui = (BgFormOrgViewUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        return this.ui.getBgFormInfo(this.ui).getMeasureUnit().getCoefficient();
    }

    public int getPrecision() {
        return this.ui.getBgFormInfo(this.ui).getCurrency().getPrecision();
    }

    public Map getMeasureUnitMap() {
        return this.ui.getMeasreUnitMap();
    }

    public Map getCurrencyMap() {
        return this.ui.getCurrencyMap();
    }

    public Map getFormulaMap() {
        return this.ui.getFormulaMap();
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        if (cell != null) {
            if (viewMode == 0) {
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    if (cell.getValue().getValue() instanceof GregorianCalendar) {
                        return cell.getText();
                    }
                    String _text = cell.getText();
                    if (!StringUtils.isEmpty((String)_text)) {
                        if ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0) {
                            Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                            if (obj instanceof ReportCalculateErrorProvider) {
                                ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                                if ("#DIV/0!".equals(_text)) {
                                    return rcep.getZeroDivDisplayAs();
                                }
                                if (_text.indexOf("#BAD FUNCTION") >= 0) {
                                    return rcep.getExceptionReplacer();
                                }
                            }
                            return _text;
                        }
                        if (BgNFSHelper.checkHasPercentage(cell) || BgNFSHelper.checkHasTextOfCell(cell)) {
                            return cell.getText();
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, true);
                        }
                        if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                            String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                            if (this.getMeasureUnitMap().isEmpty()) {
                                return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, false);
                            }
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, true);
                        }
                        if (BgNFSHelper.checkHasExpression(cell)) {
                            return this.getFormulaMeasureUnitDisplayValue(cell, _text);
                        }
                        return this.getDefMeasureUnitDisplayValue(cell, _text);
                    }
                }
            } else if (viewMode == 1) {
                String _text;
                if (cell.hasFormula()) {
                    return cell.getFormula();
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell) && !StringUtils.isEmpty((String)(_text = cell.getValue().getValue().toString()))) {
                    if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, true);
                    }
                    if (BgNFSHelper.checkHasGatFormulaOfCell(cell)) {
                        String _formulaStr = BgNFSHelper.getGatFormulaOfCell(cell);
                        if (this.getMeasureUnitMap().isEmpty()) {
                            return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, false);
                        }
                        return this.getMeasureUnitDisplayValue(cell, _formulaStr, _text, true);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, _text);
                }
            } else if (viewMode == 10) {
                if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                    return BgNFSHelper.getDisplayFormula(BgNFSHelper.getFormulaOfCell(cell), this.ui.getFormulaMap());
                }
                if (!BgNFSHelper.checkIsEmptyValue(cell)) {
                    String _text = cell.getValue().getValue().toString();
                    if (BgNFSHelper.checkHasExpression(cell)) {
                        return this.getFormulaMeasureUnitDisplayValue(cell, _text);
                    }
                    return this.getDefMeasureUnitDisplayValue(cell, _text);
                }
            }
        }
        return null;
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, String formulaStr, Object obj, boolean useMeasureUnit) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String[] _parameter = null;
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        _parameter = BgNFSHelper.parseFormulaPara(this.getFormulaMap(), formulaStr);
        if (_parameter != null) {
            if (_parameter.length == 6) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                    _precision = _currencyInfo.getPrecision();
                }
            } else if (_parameter.length == 4) {
                if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                    _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
                }
                if (!StringUtils.isEmpty((String)_parameter[3]) && this.getCurrencyMap().containsKey(_parameter[3])) {
                    _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[3]);
                    _precision = _currencyInfo.getPrecision();
                }
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getFormulaMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        Expression _expression = null;
        String _text = null;
        String _expressions = cell.getFormula();
        try {
            _expression = ExcelFormulaPaserHelper.parse((String)_expressions);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        if (_expression == null) return this.getDefMeasureUnitDisplayValue(cell, obj);
        if (!(_expression instanceof FunctionExpr)) return this.getDefMeasureUnitDisplayValue(cell, obj);
        CurrencyInfo _currencyInfo = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        String _funcionName = ((FunctionExpr)_expression).funcionName;
        if (!BGFORMULA.equalsIgnoreCase(_funcionName) && !BGACTUALS.equalsIgnoreCase(_funcionName)) {
            if (!BGBALANCE.equalsIgnoreCase(_funcionName)) return this.getDefMeasureUnitDisplayValue(cell, obj);
        }
        StringExpr _bgelement = (StringExpr)((FunctionExpr)_expression).parameters.get(2);
        StringExpr _currency = (StringExpr)((FunctionExpr)_expression).parameters.get(4);
        if (this.getMeasureUnitMap().containsKey(_bgelement.value)) {
            _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_bgelement.value);
        }
        if (!this.getCurrencyMap().containsKey(_currency.value)) return this.getDisplayValue(obj, _coefficient, _precision);
        _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_currency.value);
        _precision = _currencyInfo.getPrecision();
        return this.getDisplayValue(obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        String showStr;
        if (!BgNFSHelper.checkHasNumbericOfCell(cell) || !BgNFSHelper.checkIsNumericOfCell(cell)) {
            return cell.getText();
        }
        if ("0".equals(obj) && (showStr = BgNFSHelper.checkShowStrByNumberic(cell)) != null) {
            return showStr;
        }
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber(cell, _precision);
            _text = this.getDisplayValue(obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal((Object)obj).divide(coefficient, precision, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat((int)precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

