/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAnalyseFormQueryParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BookHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgFormOrgViewUI;
import com.kingdee.eas.ma.nbudget.client.BgFormOrgViewDisplayValueProvider;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgFormOrgViewUI
extends AbstractBgFormOrgViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormOrgViewUI.class);
    protected boolean isOnload = false;
    protected Map tableFoOrg = null;
    protected OrgUnitInfo[] orgUnits = null;
    protected Book sampleTable = null;
    protected String filePath = null;
    protected int selectPanelIndex = -1;
    protected String resource = "com.kingdee.eas.ma.budget.client.BgAnalyseFormQueryResource";
    private Map currencyMap = null;
    private Map measreUnitMap = null;
    private Map formulaMap = null;
    private BgFormInfo returnBgFormInfo = null;
    private Map tmpMap = null;
    private Map orgPanelMap = null;
    Map formMap = null;

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.formMap = (Map)this.getUIContext().get("form");
        this.currencyMap = new HashMap();
        this.measreUnitMap = new HashMap();
        this.formulaMap = new HashMap();
        this.loadAllCurrency();
        this.tmpMap = new HashMap();
        this.formatTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatTable() throws Exception {
        String tmpFilPath = "";
        HashMap tables = new HashMap();
        HashMap org = new HashMap();
        String orgId2 = null;
        String bgFormId = null;
        IBgForm form = BgFormFactory.getRemoteInstance();
        IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        BgFormInfo info = null;
        FullOrgUnitInfo orgInfo = null;
        int i = 0;
        if (this.orgPanelMap == null) {
            this.orgPanelMap = new HashMap();
        } else {
            this.orgPanelMap.clear();
        }
        try {
            for (String orgId2 : this.formMap.keySet()) {
                Book book = Book.Manager.getNewBook((String)"123", (int)1);
                String panelName = System.getProperty("user.dir") + "/BAFQ_" + i + ".data";
                this.clearAllFile(panelName);
                tmpFilPath = tmpFilPath + panelName + "!";
                bgFormId = (String)this.formMap.get(orgId2);
                info = form.getBgFormInfo("select data,name,bgTemplate.id where id='" + bgFormId + "'");
                this.filePath = this.filePath + panelName + "!";
                BgAnalyseHelper.saveToFile((String)panelName, (Object)info.getZipData());
                this.tmpMap.put(panelName, info);
                BgNFSHelper.disableCal(book);
                BgNFSHelper.disableUndo(book);
                orgInfo = fullOrgUnit.getFullOrgUnitInfo("select name where id='" + orgId2 + "'");
                this.orgPanelMap.put(panelName, orgInfo);
                this.addAnalyseSheet(book, orgInfo.getName(), panelName);
                ++i;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        finally {
            tables.clear();
            org.clear();
        }
        this.showTable();
        this.isOnload = true;
    }

    private boolean processSheetPer(Book _book, String templateId) {
        Sheet _sheet = null;
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        if (!isSheetPer) {
            return true;
        }
        Map sheetPer = null;
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission(templateId);
        }
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        boolean isShowSheet = false;
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                        continue;
                    }
                    this.hideSheet(_sheet, sheetPer, user);
                    continue;
                }
                _sheet.setHide(false);
            }
        }
        return isShowSheet;
    }

    protected boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign(_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }

    protected Map addBgSheetPermission(String templateId) {
        if (templateId == null || templateId.trim().length() == 0) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(templateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(templateId) != null) {
                sheetPer = (Map)hasPer.get(templateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    private void showTable() {
        KDPanel panel = this.getSelectPanel();
        if (panel == null) {
            return;
        }
        this.clearPanle();
        Book book = null;
        String name = panel.getName();
        SpreadContext delSc = null;
        Book delBook = null;
        for (int i = panel.getComponentCount() - 1; i >= 0; --i) {
            if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
            delSc = (SpreadContext)panel.getComponent(i);
            delBook = delSc.getBook();
            if (delBook != null) {
                delBook.clear();
            }
            delSc.removeAll();
            delSc.removeNotify();
            panel.remove(panel.getComponent(i));
            break;
        }
        try {
            BgFormInfo info;
            Object byteData = BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.loadFormFile((String)name));
            if (byteData == null) {
                this.selectPanelIndex = this.getMainTabPane().getSelectedIndex();
                return;
            }
            book = IOHelper.unpackBook((byte[])((byte[])byteData));
            if (!this.processSheetPer(book, (info = (BgFormInfo)this.tmpMap.get(name)).getBgTemplate().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.nbudget.NBUDGETAutoGenerateResource", (String)"42_BgFormOrgViewUI"));
                return;
            }
            BgNFSHelper.disableCal(book);
            BgNFSHelper.disableUndo(book);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        String title = "";
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
            title = panel.getComponent(i).getName();
        }
        SpreadContext sc = new SpreadContext();
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider((IDisplayValueProvider)new BgFormOrgViewDisplayValueProvider((Component)((Object)this)));
        sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        sc.setBook(book);
        sc.setName(title);
        Sheet _sheet = null;
        int sheetCount = sc.getBook().getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            _sheet = sc.getBook().getSheet(i);
            if (_sheet.isHide()) continue;
            Range selectRange = _sheet.getRange(0, 0);
            selectRange.select();
            sc.getSpread().scrollCellVisible(0, 0);
            break;
        }
        panel.add((Component)sc, (Object)"Center");
        this.selectPanelIndex = this.getMainTabPane().getSelectedIndex();
        sc.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    BgFormOrgViewUI.this.onSheetActive(e.getSheet());
                }
            }
        });
    }

    public boolean destroyWindow() {
        try {
            this.tmpMap.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.destroyWindow();
    }

    private void clearAllFile(String filePath2) {
        if (filePath2 == null || filePath2.trim().length() == 0) {
            return;
        }
        String[] fileP = filePath2.split("!");
        File file = null;
        for (int i = 0; i < fileP.length; ++i) {
            file = new File(fileP[i]);
            BgAnalyseHelper.deleteFile((File)file);
        }
    }

    protected KDPanel getSelectPanel() {
        Component obj = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj != null && obj instanceof KDPanel) {
            return (KDPanel)obj;
        }
        return null;
    }

    private void clearPanle() {
        KDPanel panel = null;
        Component obj = null;
        if (this.selectPanelIndex == -1 || this.selectPanelIndex >= this.getMainTabPane().getComponentCount()) {
            return;
        }
        try {
            obj = this.getMainTabPane().getComponentAt(this.selectPanelIndex);
        }
        catch (Exception e) {
            return;
        }
        if (obj == null || !(obj instanceof KDPanel)) {
            return;
        }
        panel = (KDPanel)obj;
        SpreadContext delSc = null;
        Book delBook = null;
        for (int i = panel.getComponentCount() - 1; i >= 0; --i) {
            if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
            String title = ((SpreadContext)panel.getComponent(i)).getName();
            KDSeparator kdSep = new KDSeparator();
            kdSep.setName(title);
            delSc = (SpreadContext)panel.getComponent(i);
            delBook = delSc.getBook();
            BgNFSHelper.disableCal(delBook);
            BgNFSHelper.disableUndo(delBook);
            try {
                BgAnalyseHelper.saveToFile((String)panel.getName(), (Object)IOHelper.packBook((Book)delBook));
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (delBook != null) {
                delBook.clear();
            }
            delSc.removeAll();
            delSc.removeNotify();
            panel.remove(panel.getComponent(i));
            panel.add((Component)kdSep);
            break;
        }
    }

    protected void onSheetActive(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(0, 0);
        if (range != null) {
            range.select();
        }
        this.getSC().getSpread().scrollCellVisible(0, 0);
    }

    protected SpreadContext getSC() {
        Component obj = null;
        Component objSC = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj != null && obj instanceof KDPanel) {
            for (int i = 0; i < ((KDPanel)obj).getComponentCount(); ++i) {
                objSC = ((KDPanel)obj).getComponent(i);
                if (objSC == null || !(objSC instanceof SpreadContext)) continue;
                return (SpreadContext)objSC;
            }
        }
        return null;
    }

    protected Book addAnalyseSheet(Book book, String title, String panelName) {
        if (this.getMainTabPane() == null) {
            return null;
        }
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.setName(panelName);
        SpreadContext sc = new SpreadContext();
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider((IDisplayValueProvider)new BgFormOrgViewDisplayValueProvider((Component)((Object)this)));
        sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        sc.setBook(book);
        sc.setName(title);
        sc.getSpread().scrollCellVisible(0, 0);
        panel.add((Component)sc, (Object)"Center");
        this.getMainTabPane().addTab(title, (Component)panel);
        return book;
    }

    private OrgUnitInfo[] withoutMidOrg(OrgUnitInfo[] org, BgAnalyseFormQueryParam bgFormQueryParam) {
        String longNum;
        int i;
        String orgNum = "";
        org = (OrgUnitInfo[])bgFormQueryParam.getOrgUnits().clone();
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") >= 0) continue;
            orgNum = orgNum + longNum;
        }
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") < 0) continue;
            org[i] = null;
        }
        return org;
    }

    protected OrgUnitInfo[] withoutNull(OrgUnitInfo[] orgCol) {
        Vector<OrgUnitInfo> orgs = new Vector<OrgUnitInfo>();
        OrgUnitInfo[] orgInfos = null;
        for (int i = 0; i < orgCol.length; ++i) {
            if (orgCol[i] == null) continue;
            orgs.add(orgCol[i]);
        }
        if (orgs.size() > 0) {
            orgInfos = new OrgUnitInfo[orgs.size()];
            for (int j = 0; j < orgs.size(); ++j) {
                orgInfos[j] = (OrgUnitInfo)orgs.get(j);
            }
        }
        return orgInfos;
    }

    public Map getMeasreUnitMap() {
        return this.measreUnitMap;
    }

    public void setMeasreUnitMap(Map measreUnitMap) {
        this.measreUnitMap = measreUnitMap;
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public void setFormulaMap(Map formulaMap) {
        this.formulaMap = formulaMap;
    }

    public BgFormInfo getBgFormInfo(BgFormOrgViewUI editUI) {
        BOSUuid id = null;
        Object[] forms = this.formMap.values().toArray();
        String formId = (String)forms[0];
        id = BOSUuid.read((String)formId);
        if (id != null && this.returnBgFormInfo != null && id.equals((Object)this.returnBgFormInfo.getId())) {
            return this.returnBgFormInfo;
        }
        try {
            if (id != null) {
                this.returnBgFormInfo = this.getFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(id), this.getBgFormInfo());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handleException((Exception)((Object)e));
        }
        return this.returnBgFormInfo;
    }

    protected IBgForm getFormInterface() throws BOSException {
        return BgFormFactory.getRemoteInstance();
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        return sic;
    }

    protected void loadAllCurrency() throws BOSException, EASBizException {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
    }

    @Override
    protected void TabPaneMain_stateChanged(ChangeEvent e) throws Exception {
        if (this.isOnload) {
            this.showTable();
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "fileExport"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        StringBuffer titleName = new StringBuffer();
        String bgFormName = this.getUIContext().get("bgFormName").toString();
        if (!StringUtils.isEmpty((String)bgFormName)) {
            titleName.append(bgFormName);
        }
        titleName.append("-");
        titleName.append(this.getUITitle());
        titleName.append("-");
        titleName.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"bySelectOrgDisplay"));
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + titleName.toString().trim() + ".xls"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fc.getSelectedFile();
            FileFilter filter = fc.getFileFilter();
            if (filter instanceof ExcelFileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(fc.getSelectedFile() + ".xls");
                }
                if (file != null) {
                    if (file.exists()) {
                        int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        this.exportBook(file);
                    }
                    catch (Exception ex) {
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            } else if (filter instanceof Excel2007FileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(fc.getSelectedFile() + ".xlsx");
                }
                if (file != null) {
                    if (file.exists()) {
                        int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        Book _book = this.getSC().getBook();
                        this.exportToExcel2007(_book, file.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            }
        }
    }

    private boolean exportToExcel2007(Book book, String fileName) {
        String[] sns = new String[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sns[i] = book.getSheetName(i);
        }
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.getSC());
            return false;
        }
        try {
            Book tempBook = SpreadHelper.copyBook((Book)book);
            HashMap<String, Object> _parameter = new HashMap<String, Object>();
            BigDecimal _coefficient = this.returnBgFormInfo.getMeasureUnit() != null ? this.returnBgFormInfo.getMeasureUnit().getCoefficient() : BgNConstants.ONE;
            _parameter.put("EXPORT_BOOK", tempBook);
            _parameter.put("EXPORT_COEFFICIENT", _coefficient);
            _parameter.put("EXPORT_MEASUREUNIT", this.measreUnitMap);
            _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("EXPORT_DATA", this.getUIContext().get("EXPORT_DATA"));
            Book _book = BgNFCHelper.exportExcel2007(_parameter);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
            bookDataWrapper.setExportFormula(false);
            bookDataWrapper.setExportCustomerFomulas(true);
            bookDataWrapper.setShowValue(true);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
            booksc.write(fileName);
            return true;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.getSC());
            return false;
        }
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    private void exportBook(File file) {
        if (file == null) {
            return;
        }
        HashMap<String, Book> bookMap = new HashMap<String, Book>();
        Book exportBook = null;
        Book tempBook = null;
        KDPanel panel = null;
        Component obj2 = null;
        String orgName = null;
        for (Component obj2 : this.getMainTabPane().getComponents()) {
            String name;
            Object byteData;
            if (obj2 == null || !(obj2 instanceof KDPanel) || (byteData = BgAnalyseHelper.getObject((byte[])BgAnalyseHelper.loadFormFile((String)(name = (panel = (KDPanel)obj2).getName())))) == null) continue;
            try {
                tempBook = IOHelper.unpackBook((byte[])((byte[])byteData));
                if (this.orgPanelMap == null || !this.orgPanelMap.containsKey(name)) continue;
                FullOrgUnitInfo org = (FullOrgUnitInfo)this.orgPanelMap.get(name);
                orgName = org.getName();
                bookMap.put(orgName, tempBook);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (bookMap == null || bookMap.isEmpty()) {
            return;
        }
        exportBook = BookHelper.getNewBook();
        if (exportBook == null) {
            return;
        }
        exportBook.clear();
        String key = null;
        Sheet sheet = null;
        String sheetName = null;
        Iterator it = bookMap.keySet().iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            tempBook = (Book)bookMap.get(key);
            BgNFSHelper.setBookProtection(tempBook, false);
            BgNFSHelper.setBookLocked(tempBook, false);
            for (int index = 0; index < tempBook.getSheetCount(); ++index) {
                sheet = tempBook.getSheet(index);
                sheetName = key + "_" + sheet.getSheetName();
                sheet.setName(sheetName);
                exportBook.addSheet(sheet);
            }
        }
        String _filename = file.getPath();
        BigDecimal _coefficient = this.returnBgFormInfo.getMeasureUnit() != null ? this.returnBgFormInfo.getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        _parameter.put("EXPORT_BOOK", exportBook);
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        _parameter.put("EXPORT_MEASUREUNIT", this.getMeasreUnitMap());
        _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
        _parameter.put("EXPORT_DATA", this.getUIContext().get("EXPORT_DATA"));
        KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        em.exportToExcel(_kdsBook, _filename);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }
}

