/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgAuditStateFilterParam;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.AbstractBgFormViewStateFilterUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFormViewStateFilterUI
extends AbstractBgFormViewStateFilterUI {
    private static final long serialVersionUID = 2646999979528638558L;
    private static final Logger logger = Logger.getLogger(BgFormViewStateFilterUI.class);

    public BgFormViewStateFilterUI() throws Exception {
    }

    public BgFormViewStateFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "workFlow_title");
    }

    protected void initFilter() throws Exception {
        this.initBgScheme();
        this.initBgPeriod();
    }

    private void initBgScheme() {
        String orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID");
        Set permissionOrg = (Set)this.getUIContext().get("PERMISSIONORG");
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            filter.setMaskString("#0");
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                Set<String> orgSet = new HashSet<String>();
                if (permissionOrg != null) {
                    orgSet = permissionOrg;
                } else {
                    orgSet.add(orgUnitId);
                }
                filter = BgPermissionHelper.addBgSchemePermission(userId, orgSet, filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriod.setEditable(false);
    }

    protected FilterParam createNewFilterParam() {
        return new BgAuditStateFilterParam();
    }

    public void loadFilterInfo() throws Exception {
        this.showBgScheme();
        this.showBgPeriod();
        this.showCurrency();
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
                this.prmtBgScheme.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "selectBgScheme"));
                return false;
            }
            if (!(this.prmtBgPeriod.getData() instanceof BgPeriodInfo)) {
                this.prmtBgPeriod.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "selectBgPeriod"));
                return false;
            }
            if (!(this.prmtCurrency.getData() instanceof CurrencyInfo)) {
                this.prmtCurrency.requestFocus();
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "selectCurrency"));
                return false;
            }
        }
        return re;
    }

    public void clear() {
        this.prmtCurrency.setData(null);
        this.prmtBgScheme.setData(null);
        this.prmtBgPeriod.setData(null);
        this.txtApproveState.setText(null);
        this.chkDisplayWorkFlow.setSelected(false);
    }

    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam instanceof BgAuditStateFilterParam) {
            BgAuditStateFilterParam _filterParam = (BgAuditStateFilterParam)filterParam;
            if (_filterParam.getBgSchemeInfo() != null) {
                this.prmtBgScheme.setData((Object)_filterParam.getBgSchemeInfo());
            } else {
                this.prmtBgScheme.setData(null);
            }
            if (_filterParam.getBgPeriodInfo() != null) {
                this.prmtBgPeriod.setData((Object)_filterParam.getBgPeriodInfo());
            } else {
                this.prmtBgPeriod.setData(null);
            }
            if (_filterParam.getCurrencyInfo() != null) {
                this.prmtCurrency.setData((Object)_filterParam.getCurrencyInfo());
            } else {
                this.prmtCurrency.setData(null);
            }
            if (!StringUtils.isEmpty((String)_filterParam.getQueryInfo())) {
                this.txtApproveState.setText(_filterParam.getQueryInfo());
            } else {
                this.txtApproveState.setText(null);
            }
            if (_filterParam.getHasShowWorkFlow().booleanValue()) {
                this.chkDisplayWorkFlow.setSelected(true);
            } else {
                this.chkDisplayWorkFlow.setSelected(false);
            }
        }
    }

    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam instanceof BgAuditStateFilterParam) {
            BgAuditStateFilterParam _filterParam = (BgAuditStateFilterParam)filterParam;
            if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
                _filterParam.setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
            } else {
                _filterParam.setBgSchemeInfo(null);
            }
            if (this.prmtBgPeriod.getData() instanceof BgPeriodInfo) {
                _filterParam.setBgPeriodInfo((BgPeriodInfo)this.prmtBgPeriod.getData());
            } else {
                _filterParam.setBgPeriodInfo(null);
            }
            if (this.prmtCurrency.getData() instanceof CurrencyInfo) {
                _filterParam.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getData());
            } else {
                _filterParam.setCurrencyInfo(null);
            }
            if (!StringUtils.isEmpty((String)this.txtApproveState.getText())) {
                _filterParam.setQueryInfo(this.txtApproveState.getText());
            } else {
                _filterParam.setQueryInfo(null);
            }
            if (this.chkDisplayWorkFlow.isSelected()) {
                _filterParam.setHasShowWorkFlow(Boolean.TRUE);
            } else {
                _filterParam.setHasShowWorkFlow(Boolean.FALSE);
            }
        }
    }

    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgAuditStateFilterParam _mainParam = null;
        BgAuditStateFilterParam _filterParam = null;
        if (mainParam instanceof BgAuditStateFilterParam && filterParam instanceof BgAuditStateFilterParam) {
            _mainParam = (BgAuditStateFilterParam)_fp;
            _filterParam = (BgAuditStateFilterParam)filterParam;
            if (_filterParam.getBgSchemeInfo() != null) {
                _mainParam.setBgSchemeInfo(_filterParam.getBgSchemeInfo());
            } else {
                _mainParam.setBgSchemeInfo(null);
            }
            if (_filterParam.getBgPeriodInfo() != null) {
                _mainParam.setBgPeriodInfo(_filterParam.getBgPeriodInfo());
            } else {
                _mainParam.setBgPeriodInfo(null);
            }
            if (_filterParam.getCurrencyInfo() != null) {
                _mainParam.setCurrencyInfo(_filterParam.getCurrencyInfo());
            } else {
                _mainParam.setCurrencyInfo(null);
            }
            if (_filterParam.getQueryInfo() != null) {
                _mainParam.setQueryInfo(_filterParam.getQueryInfo());
            } else {
                _mainParam.setQueryInfo(null);
            }
            _mainParam.setHasShowWorkFlow(_filterParam.getHasShowWorkFlow());
        }
        return _mainParam;
    }

    protected void showBgScheme() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgAuditStateFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAuditStateFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtBgScheme.setData((Object)filterParam.getBgSchemeInfo());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void showBgPeriod() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgAuditStateFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAuditStateFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtBgPeriod.setData((Object)filterParam.getBgPeriodInfo());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void showCurrency() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgAuditStateFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAuditStateFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtCurrency.setData((Object)filterParam.getCurrencyInfo());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }
}

